#include "colors.inc"
#include "povlab.inc"
#include "htex.inc"

camera { location <4.75,1.25,5.45> look_at <3,.55,1.5> }

light_source { <2.3,3,3.7> color Orange }

plane { y, .24 texture { Stormy_Water scale 15 }}


height_field { gif "tree.gif" texture { Asteroid } smooth scale <6,.65,6> }
height_field { gif "dina.gif" pigment { image_map { gif "NovaSlika.Gif"} rotate
   <270,0,180>} smooth scale <9.5,.75,4.5> rotate <90,0,0> translate <-3.5,4.5,0> }

#declare Stapic = union {
    cylinder { <0,.2,0>, <0,.44,0>, .05 texture { Yellow_Pine } texture { Smjesa}}
    cylinder { <0,.44,0>, <0,.6,0>, .05 texture { Yellow_Pine }}
    cylinder { <0,.6,0>, <0,1.2,0>, .05 texture { Book_Text }}
    rotate <0,0,40>
}

#declare Posuda = union {
    union {
         torus { .2, .2 }
         torus { .3, .05 }
         torus { .4, .075 translate <.01,.1,0> }
         torus { .5, .075 translate <.015,.2,0> }
         torus { .5, .075 translate <.004,.3,0> }
         torus { .5, .075 translate <.02,.4,0> }
         texture { Glina scale 2}
    }

    difference {
        torus { .23, .21 texture { Smjesa scale .5 } translate <0,.1,0> }
        sphere { <.2,.65,0>, .5 texture { Smjesa scale .5 }}
    }
    
    object { Stapic }
}

#declare Posuda2 = union {
    union {
         torus { .2, .2 }
         torus { .3, .05 }
         torus { .4, .075 translate <.01,.1,0> }
         torus { .5, .075 translate <.015,.2,0> }
         torus { .5, .075 translate <.004,.3,0> }
         torus { .5, .075 translate <.02,.4,0> }
         texture { Glina scale 2}
    }
    object { Stapic }
    
    torus { .23, .21 texture { Smjesa2 scale .5 } translate <0,.1,0> }
}

#declare Vatra = union {
    sphere { 0, 1 pigment { color rgbt <1,1,1,1> }
         halo {
             emitting
             spherical_mapping
             linear
             turbulence 1.5
             color_map {
                 [ 0 color rgbt <1,0,0,1> ]
                 [ 1 color rgbt <1,1,0,-1> ]
             }
             samples 5
             scale .5
         }
    hollow
    scale <1.5,3,1.5>
    }

    sphere { <0,-1,0> 1.5 pigment { color rgbt <1,1,1,1> }
         halo {
             emitting
             spherical_mapping
             linear
             turbulence 1
             color_map {
                 [ 0 color rgbt <1,0,0,1> ]
                 [ 1 color rgbt <1,1,0,-1> ]
             }
             samples 20
             scale .5
         }
         hollow
         scale <2.5,3.5,2.5>
    }
} // End Of Vatra

#declare luk = intersection {
    torus { 1, .1 }
    box { <0,-.2,0>, <1,.2,1> }
    texture { Book_Text }
}

#declare luk1 = intersection {
    torus { 1, .1 }
    box { <-1,-.2,-1>, <0,.2,0> }
    texture { Book_Text }
    texture { GlassFrit }
}

#declare drvo1 = union {
    cylinder { <0,1,0>, <0,5,0>, .35 texture { Book_Text }}
    cylinder { <0,0,0>, <0,5,0>, .33 texture { Yellow_Pine }}
}

#declare sijek = height_field { gif "sunce.gif" texture { Yellow_Pine }
                 translate <-.5,0,-.5> 
}

#declare Drvo1 = difference {
        object { drvo1 }
        object { sijek scale <.85,6,.85> }
        box { <-1,-.1,-1>, <1,.01,1> pigment { Black }}
}

#declare drvo2 = difference {
        cone { <0,0,0>, .4, <0,2,0>, .35 texture { Yellow_Pine scale 2 }}
        object { sijek scale <1,2,1> }
        box { <-1,-.1,-1>, <1,.01,1> pigment { Black }}
}

#declare Drvo2 = union {
        object { drvo2 }
        object { drvo2 rotate <180,0,0> translate <0,3.91,0> }
        object { drvo2 rotate <140,0,0> scale <.35,1,.35> translate <0,3,-.7>}
        sphere { <0,0,-.325>, .135 texture { Yellow_Pine } scale <1.2,3,1> translate <0,1.75,0>}
        torus { .32, .05 texture { Book_Text } scale <0,3,0> translate <0,2,0>}
}

#declare Noz = difference {
    sphere { <0,0,0>, 1 scale <.75,.5,2> texture { Stone8 }}
    #declare kZ=-.6
    union {
    #while (kZ<2)
        #declare kY = abs (kZ) / 6
        sphere { <0,0,0>, .5 scale <.65,.27,.6> rotate <0,0,90> translate <-.65,.16 ,kZ > }
        sphere { <0,0,0>, .5 scale <.55,.2,.6> rotate <0,0,30>  translate <-.38,.45 - kY,kZ + .05 > }
        sphere { <0,0,0>, .5 scale <.55,.2,.6> translate <0,.55 - kY,kZ> }
        sphere { <0,0,0>, .5 scale <.55,.2,.6> rotate <0,0,-30> translate <.38,.45 - kY,kZ + .05> }
        sphere { <0,0,0>, .5 scale <.65,.27,.6> rotate <0,0,-90> translate <.65,.16 ,kZ> }

        sphere { <0,0,0>, .5 scale <.65,.27,.6> rotate <0,0,90> translate <-.65,-.16 ,kZ> }
        sphere { <0,0,0>, .5 scale <.55,.2,.6> translate <-.38,-.45 + kY,kZ> }
        sphere { <0,0,0>, .5 scale <.55,.2,.6> translate <0,-.55 + kY,kZ> }
        sphere { <0,0,0>, .5 scale <.55,.2,.6> translate <.38,- .45 + kY,kZ> }
        sphere { <0,0,0>, .5 scale <.65,.27,.6> rotate <0,0,-90> translate <.65,-.16 ,kZ> }
        #declare kZ = kZ + .4
    #end
    sphere { <0,0,2>, .33 }
    texture { Stone17 }
    }
}

#declare Zar = box { <-1,-1,-1>, <1,1,1> pigment { color rgbt <1,1,1,1> }
    halo { emitting spherical_mapping cubic
           turbulence .33
           color_map { 
	       [ 0 color rgbt <1,1,0,1> ]
	       [ 1 color rgbt <1,0,0,-1> ]
	   }
	   frequency 1.5
	   samples 20
	   scale 2
    }
    hollow 
}

object { Noz scale .1 rotate <0,130,0> translate <3.5,.377,4.3> }

object { Drvo1 scale .5 rotate <0,0,90> translate <3.21,.35,3.5> }
object { Drvo2 scale .3 rotate <-25,0,90> translate <2.6,.375,3.9> }
object { Drvo1 scale .2 rotate <-10,0,90> translate <2.8,.55,3.8> }
object { Posuda scale .3 rotate <15,0,0> translate <4.85,.2,3.65> }
object { Posuda2 scale .3 rotate <20,0,10> translate <4.75,.2,.75> }


object { Vatra scale <.35,.75,.35> translate <2.3,.1,3.7> }
object { Zar scale .035 translate <2.53,.3,3.9> }
object { Zar scale .035 translate <2.56,.3,3.8> }
object { Zar scale .03 translate <2.45,.3,3.9>}
object { Zar scale .035 rotate <0,80,0> translate <2.65,.3,3.8> }
object { Zar scale .06 translate <2.3,.3,3.9> }

