// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: You're history
// Date: 99/03/23 -  99/04/25
// Auth: Matthias M. Giwer

#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 2.2
}

#include "METALS.INC"   // Metallic pigments, finishes, and textures

// ----------------------------------------

#declare place = <0, 4, -25> ;

#declare place2 = <-25,4,0>;

#declare place3 = <0,25,0>;

camera {location place translate <-.15,0,0> direction 1.5*z right 4/3*x 
   look_at <0.0, 5.0,  0.0> }

// create a point "spotlight" (cylindrical directed) light source
light_source // car headlight
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  cylinder                // this variation
  translate place         // to the car
  translate <2,-2,4>      // <x y z> position of light
  point_at <2, 1, 0>      // direction of spotlight
  radius 5 //5                // hotspot (inner, in degrees)
  tightness 25 //0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 45               // intensity falloff radius (outer, in degrees)
  fade_distance 20
  fade_power 1.5
}

light_source // car headlight 
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  cylinder                // this variation
  translate place
  translate <-2,-2,4> // <x y z> position of light
  point_at <-2, 1, 0>      // direction of spotlight
  radius 5 //5                // hotspot (inner, in degrees)
  tightness 25 //0            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 45               // intensity falloff radius (outer, in degrees)
  fade_distance 20
  fade_power 1.5
}

box {0*x,1*x scale <5,3,10> translate place translate<0,0,-5> pigment {color Green}}

// ----------------------------------------

//roadbox
box { -1,1 

        texture { pigment {color rgb <1,1,1>*.4}
                finish {ambient .1
                        reflection .1 
                        metallic
                        roughness .1
                        } 
                }
        
        scale <18.,1,100000> translate <9,-1,0> 
}

// whitelinebox
box { -1,1 

        texture { pigment {color rgb<1,1,1>}
                finish {reflection 0
                        ambient 1
                        roughness 1}
                 }
        
        scale <.125,1,100000> translate <9,-0.99,0> 
}

//side roadbox
box { -1,1 

        texture { pigment {color rgb<.2,.3,.2>}
                finish {ambient .5
                        roughness .5
                        } 
                }
        
        scale <9,1,100000> translate <-18,-1,0> 
}
                        
#declare rcolor = <1,.2,.2> ;

#declare rtex = texture 
{ pigment { color rgb 0.5* rcolor }
         
  finish {reflection 0.64*rcolor
         metallic
         ambient 0.55 * rcolor 
         specular 0.9 
         roughness .9
         diffuse 0.5 // 0.5 
         brilliance 7.5
         //crand 0.001
         phong 0.7
         phong_size 10 
  }
}  

#declare cylcolor4 = <1,1,1> ; //g .64

#declare T_Chrome_5A = texture 
{ pigment { color rgb 0.64* cylcolor4 }
         
  finish {reflection 0.64*cylcolor4
         metallic
         ambient 0.35//0.55 * cylcolor4 
         specular .9 
         roughness .9
         diffuse 0.5 // 0.5 
         brilliance 7.5
  }
}

// car

#declare car = union {

union { // steering wheel
   torus { 1, .075 }
   superellipsoid {<0.3, 0.2>
         scale <1,.1,.35>
      }
   
      texture {
         pigment{ color rgb <1,.6,0>*.4}
         finish {}
      }  
      rotate 110*x
      scale .2
      translate place translate <-.15,-0.3,1>
} // end union steering wheel

//dashboard

union {

superellipsoid {<.25,.05> scale <1.25,.75,.4>}
   translate <0,0,.5>
      texture {
         pigment{ color rgb <1,.6,0>*.4}
         finish { ambient .1 }
         normal {crackle -.1 }
         }
  translate place translate <0.2,-.9,1.5>
}
//mirror

union { 
superellipsoid { <.4,.005> scale <1.5,.4,.03> scale .1 // reflective
   texture {
      pigment {color <0,0,0>}
      finish {ambient <0,0,0>
         reflection <1,.8,.8>
         }
   }
}

superellipsoid  { <.4,.005> scale <1.6,.5,.02> scale .1 // mounting
   texture {
      pigment {color <1,.5,0>*.2}
      finish {ambient 0.4
         reflection .1
      }
      normal {crackle -.1}
   }
} 

   rotate -10*x
   translate place translate <.25,.7,1>
 }  
  
translate <0,-.5,0> //-.125
} // end union car 
car

//truck
#declare truck = union {
//grill frame
difference {
superellipsoid { <0.05, 0.05> 
   texture { T_Chrome_5A }
   scale <4,5,1>*.5
}
superellipsoid { <0.001, 0.001> 
   texture { T_Chrome_5A }
   scale <3.25,4.25,1.5>*.5
   translate <0,-.25,0>
} 
} // end difference

//cab

// running lights
#declare running =union {
torus { 0.4, 0.5 translate <0,-.15,0>}
torus { 0.92, 0.2 }
torus { 0.90, 0.2 translate <0, .3,0> }
torus { 0.88, 0.2 translate <0, .6,0> }
torus { 0.86, 0.2 translate <0, .9,0> }
light_source { 0*x color <1,1,0> translate <0,1,0> 
        fade_distance 1 fade_power 4 }
torus { 0.84, 0.2 translate <0,1.2,0> }
torus { 0.82, 0.2 translate <0,1.5,0> }
torus { 0.8, 0.2 translate <0,1.8,0> }
torus { 0.4, 0.5 translate <0,1.95,0> }

        texture {
                pigment {color rgbft <1,1,0,1,0>}
                finish {
                        roughness 11
                        reflection .5
                        diffuse 1
                        brilliance 1
                        phong .50 phong_size .01
                }
        }        
        interior {ior 1.33 
        //media {scattering { 1 color <1,1,0>}}
        }
       // translate <-4,5,-1>
       scale .1
}

// on top
object {running  translate <-4,5.6,6>}
object {running  translate <4,5.6,6>}
object {running  translate <0,5.6,6>}
object {running  translate <-1.5,5.6,6>}
object {running  translate < 1.5,5.6,6>}

// front
object {running rotate  90*x translate <-3.85,-1,0>}
object {running rotate  90*x translate < 3.85,-1,0>}

// headlights
#declare headlight =union {
torus { 0.4, 0.5 translate <0,-.15,0>}
torus { 0.90, 0.2 }
torus { 0.90, 0.2 translate <0, .3,0> }
torus { 0.90, 0.2 translate <0, .6,0> }
torus { 0.90, 0.2 translate <0, .9,0> }
light_source { 0*x color <1,1,1> translate <0,1,0> 
        fade_distance 1 fade_power 3 }
torus { 0.90, 0.2 translate <0,1.2,0> }
torus { 0.90, 0.2 translate <0,1.5,0> }
torus { 0.90, 0.2 translate <0,1.8,0> }
torus { 0.4, 0.5 translate <0,1.95,0> }

        texture {
                pigment {color rgbft <1,1,1,1,0>}
                finish {
                        roughness 11
                        reflection .5
                        diffuse 1
                        brilliance 1
                        phong .50 phong_size .01
                }
        }        
        interior {ior 1.33 
        //media {scattering { 1 color <1,1,0>}}
        }
       // translate <-4,5,-1>
       scale <.28,.5,.1>*.3
}

object {headlight rotate 90*z rotate 180*y translate <-3.25,   -1, -.1>}
object {headlight rotate 90*z rotate 180*y translate  <-2.45, -1, -.1>}
object {headlight rotate 90*z translate < 3.25,   -1, -.1>}
object {headlight rotate 90*z translate < 2.45, -1, -.1>}



// hood part
superellipsoid { <.2,.2>
        texture { rtex}
        scale <3.5,2.5,2.5>
        translate <0,0,5>
}       

// part behind window 
superellipsoid { <.1,.1>
        texture { rtex}
        scale <6.25,4.5,2.5>
        translate <0,2.5,10>
}

// exhausts 

cylinder { -.10*y, 1*y, 1
   texture { T_Chrome_5A }
   scale <.25,8,.25>
   translate <-5.5,0,7>
}
cylinder { -.10*y, 1*y, 1
   texture { T_Chrome_5A }
   scale <.25,8,.25>
   translate <5.5,0,7>
}
// part with window
difference {
superellipsoid { <.1,.1>
        texture { rtex}
        scale <5,3.5,2.5>
        translate <0,2,8>
}
superellipsoid { <0.001, 0.001> 
   //texture { T_Chrome_5A }
        texture { pigment {color .2}}
   hollow
   scale <4.6,1.1,1>
   translate <0,0,-.2> translate <0,3.75,6.5>
}
 }
//windshield frame

difference {
superellipsoid { <0.05, 0.05> 
   texture { T_Chrome_5A }
   scale <4.75,1.25,1>
}

superellipsoid { <0.001, 0.001> 
   //texture { T_Chrome_5A }
        texture { pigment {color .2}}
   hollow
   scale <4.6,1.1,1>
}   
                  
//   texture { T_Chrome_5A }
        translate <0,3.75,6.5>

} // winshield frame end difference
            
// windshield
superellipsoid { <0.001, 0.001> 
   //texture { T_Chrome_5A }
        texture { pigment {color <0,0,0>}
                finish {reflection .1
                        roughness .01}
                }
        interior { ior 1.33}
        scale <4.6,1.1,.1>
           translate <0,3.75,5.575>
}
            
            
//radiator honeycombing needed

superellipsoid { <0.05, 0.05> 
   //texture { T_Chrome_5A }
   texture { pigment {color .1}}
   translate <0,0,1>
   scale <4,5,1>*.45
}

//grillwork
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.05, 2.4, 0.05>
   rotate <0,45,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.05, 2.4, 0.05>
   rotate <0,0,0>
   translate <-0.85,0,0>
   }   

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.05, 2.4, 0.05>
   rotate <0,0,0>
   translate <0.85,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-0.2125,0,0>
   }
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-0.31875,0,0>
   }
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <0.31875,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-0.425,0,0>
   }   
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-0.531,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <0.531,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-0.6375,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <0.2125,0,0>
   }
   
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <0.425,0,0>
   }   

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <0.6375,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-1.06,0,0>
   }
   
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-1.2725,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <-1.485,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <1.06,0,0>
   }
   
superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <1.2725,0,0>
   }

superellipsoid { <0.1, 0.1> 
   texture { T_Chrome_5A }
   scale <0.01, 2.4, 0.01>
   rotate <0,0,0>
   translate <1.485,0,0>
   }

//wheel cover
difference {
cylinder { -1*x 1*x 1 scale <5,2,1> translate <0,-2.5,3>
        texture { rtex}
}

superellipsoid { <0.05, 0.05> 
   //texture { T_Chrome_5A } 
   scale <1,1,50>
   scale <4,5,1>*.5
}



} // end difference

// tire tyre
cylinder {-1*x, 1*x, 1
      texture {
         pigment { color <.2,.2,.2>}
         finish { ambient <1,1,1>*-1
               reflection .3
               roughness 5
               specular .5
         }
      }
   scale <.5,1.3,1>
   translate <-3.8,-5,1.1>
}
cylinder {-1*x, 1*x, 1
      texture {
         pigment { color <.2,.2,.2>}
         finish { ambient <1,1,1>*-1
               reflection .3
               roughness 10
               specular .5
            }
      }
   scale <.5,1.3,1>
   translate <3.8,-5,1.1>
}

// bumper  

union {
superellipsoid { <0.05,0.2>
        texture { T_Chrome_5A }
        scale <5,1,1> translate <0,-3.5,1>
}

superellipsoid { <0.05,0.2>
        texture { T_Chrome_5A }
        scale <5,.9,1> translate <0,-3.5,0.95>
}
// rivets

sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <0,-3.2,0.05>
        }

sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <-.5,-3.2,0.05>
        }
sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <.5,-3.2,0.05>
        }
sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <2.5,-3.2,0.05>
        }
sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <3,-3.2,0.05>
        }
sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <2.75,-3.9,0.05>
        }
sphere { 0*x 1        
        texture { T_Chrome_5A }
        scale .15 translate <-2.5,-3.2,0.05>
        }
sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <-3,-3.2,0.05>
        }
sphere { 0*x 1 
        texture { T_Chrome_5A }
        scale .15 translate <-2.75,-3.9,0.05>
        }

#declare lplate = intersection // union 
{
      height_field 
         {
            gif "lplate1.gif"
            //smooth
            texture {pigment {color <1,1,1>}
               finish 
                  {
                     ambient 1
                     specular 1
            } }
            
            scale 3  rotate -90*x   translate -0.92*z translate -1*y translate -1.5*x
            }
         
         
      superellipsoid { <.1, .01>
            texture {pigment {color <0,0,1>}
               finish { ambient 1
                  specular .5
                  }
            }
            scale <1.5,1.5,1> translate .5*y
      }
      scale <1.6,.9,1> // shape scale
      scale .3
      translate -3.85*y translate .2*z
}                    
lplate
        
}
//headlamp 1
union {
difference {
superellipsoid { <0.1,0.1> 
}
superellipsoid { <0.1,0.1> scale <.9,.9,1.001>
}
        texture { T_Chrome_5A }
        //scale <.4,.175,.2>
        
}// end difference

superellipsoid { <0.1,0.1> scale <.85,.85,.85>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5 phong_size 0.1
                         roughness 1
                }
                }
        //normal { crackle 20 scale .0001}        
        interior {ior 1.33 caustics 1}
}

superellipsoid { <0.1,0.1> scale <.84,.84,.84>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5
                         roughness 1
                }
                }
        //normal { waves 10 scale .0001}        
        interior {ior 1.33 caustics 1}
}


                scale <.4,.2,.2>
                translate <-3.25,-1,0>
}//end headlamp union 1

//headlamp 2
union {
difference {
superellipsoid { <0.1,0.1> 
}
superellipsoid { <0.1,0.1> scale <.9,.9,1.001>
}
        texture { T_Chrome_5A }
        //scale <.4,.175,.2>
        
}// end difference

superellipsoid { <0.1,0.1> scale <.85,.85,.85>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5 phong_size 0.1
                         roughness 1
                }
                }
        //normal { crackle 20 scale .0001}        
        interior {ior 1.33 caustics 1}
}

superellipsoid { <0.1,0.1> scale <.84,.84,.84>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5
                         roughness 1
                }
                }
        //normal { waves 10 scale .0001}        
        interior {ior 1.33 caustics 1}
}
                scale <.4,.2,.2>
                translate <-2.45,-1,0>
}//end headlamp union 2
 
//headlamp 3
union {
difference {
superellipsoid { <0.1,0.1> 
}
superellipsoid { <0.1,0.1> scale <.9,.9,1.001>
}
        texture { T_Chrome_5A }
        //scale <.4,.175,.2>
        
}// end difference


superellipsoid { <0.1,0.1> scale <.85,.85,.85>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5 phong_size 0.1
                         roughness 1
                }
                }
        //normal { crackle 20 scale .0001}        
        interior {ior 1.33 caustics 1}
}

superellipsoid { <0.1,0.1> scale <.84,.84,.84>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5
                         roughness 1
                }
                }
        //normal { waves 10 scale .0001}        
        interior {ior 1.33 caustics 1}
}
                scale <.4,.2,.2>
                translate <2.45,-1,0>
}//end headlamp union 3

//headlamp 4
union {
difference {
superellipsoid { <0.1,0.1> 
}
superellipsoid { <0.1,0.1> scale <.9,.9,1.001>
}
        texture { T_Chrome_5A }
        //scale <.4,.175,.2>
        
}// end difference


superellipsoid { <0.1,0.1> scale <.85,.85,.85>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5 phong_size 0.1
                         roughness 1
                }
                }
        //normal { crackle 20 scale .0001}        
        interior {ior 1.33 caustics 1}
}

superellipsoid { <0.1,0.1> scale <.84,.84,.84>
        texture { pigment {color rgbft <1,1,1,.5,.5>} 
                finish { phong .5
                         roughness 1
                }
                }
        //normal { waves 10 scale .0001}        
        interior {ior 1.33 caustics 1}
}
                scale <.4,.2,.2>
                translate <3.25,-1,0>
}//end headlamp union 4


// truck height            
  translate <0,5, 1>

}// end union

truck

fog 
{
  fog_type   2
  distance   6.5
  color      rgb <.3,.3,.35>// *1.3 // gray
  fog_offset 0.001
  fog_alt    1.75 //2
  //turbulence <3,10,5> octaves 10 omega .4 lambda 4 
  turbulence <1,2,.1> octaves 1 omega 0.4 lambda .1
   scale 2.0
  //turb_depth .9
} 

