/*

#include "colors.inc"
#include "twood.inc"

camera {
	location <0,1.25,-5>
	look_at  <0,1.25,0>
}


light_source {<50,100,-200> color White}  

*/

#declare Rust = texture{
	pigment{rgb<.3,.3,.5>}
	finish{phong 1 reflection .2}
}

#declare Silver2 = 
texture{pigment{
     rgb<0.827,0.827,0.827>
    }
  finish {
    ambient 0.25
    diffuse 0.65
    brilliance 6.0
    phong 1.0    phong_size 100    metallic
    reflection 0.6
  }
}

#declare Rust2 =
texture{
	pigment{rgb<.3,.3,.5>}
	finish{phong 1 reflection .2}
}


// clintonboard 

#declare Part_Lamp =
union {
	sphere {<0,0,0>,.03 texture{Silver2}}
	sphere {<0,-.03,0>,.06 texture{Silver2}}
	cone {<0,-.03,0>,.06,<0,-.12,0>,.15 texture{Silver2}}
}  

#declare Lamp =
union {
	cylinder {<0,-1,0><0,.5,0>,.03 texture{Rust}}
	sphere {<0,.5,0>,.03 texture{Rust}}
	cylinder {<0,.5,0><0,.75,-.5>,.03 texture{Rust}}
	object {Part_Lamp rotate <45,0,0> translate <0,.75,-.5>}
}

#declare Part_Support =
union {
	box {<.05,0,0><-.05,.1,.05> texture{Rust2}}
	box {<.05,0,.6><-.05,.1,.55> texture{Rust2}}
	box {<-.1,0,.1><-.05,.1,.5> texture{Rust2}}
	box {<.1,0,.1><.05,.1,.5> texture{Rust2}} 
}

#declare Support = 
union {

	box {<-.1,0,0><-.05,4,.1> texture{Rust2}}
	box {<.1,0,0><.05,4,.1> texture{Rust2}}
	
	box {<-.1,0,.5><-.05,4,.6> texture{Rust2}}
	box {<.1,0,.5><.05,4,.6> texture{Rust2}}   
	
	object {Part_Support translate <0,.25,0>}   
	object {Part_Support translate <0,.75,0>}
	object {Part_Support translate <0,1.25,0>}   
	
	object {Lamp rotate <-70,0,0> translate <0,5,0>}
}

#declare Plank2 = superellipsoid { 0.2 scale <.1,1.5,.02> translate <0,1.5,.01> 
	texture{Twood2 scale <.01,.5,.01>}}

#declare Paper1 = 
bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <.01,  .01, -.05> <.25,  0, 0> <.5,  0, 0> <.75,  0, 0>
  <0,.25, 0> <.25,.25, 0> <.5,.25, 0> <.75,.25, 0>
  <0, .5, 0> <.25, .5, 0> <.5, .5, 0> <.75, .5, 0>
  <0,.75, 0> <.25,.75, 0> <.5,.75, 0> <.75,.75, 0>
} 

#declare Paper2 = 
bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <0,  0, 0> <.25,  0, 0> <.5,  0, 0> <.75,  0, 0>
  <0,.25, 0> <.25,.25, 0> <.5,.25, 0> <.75,.25, 0>
  <0, .5, 0> <.25, .5, 0> <.5, .5, 0> <.75, .5, 0>
  <0,.74, -.05> <.25,.75, 0> <.5,.75, 0> <.75,.75, 0>
}

#declare Paper3 = 
bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <0,  0, 0> <.25,  0, 0> <.5,  0, 0> <.75,  0, 0>
  <0,.25, 0> <.25,.25, 0> <.5,.25, 0> <.75,.25, 0>
  <0, .5, 0> <.25, .5, 0> <.5, .5, 0> <.75, .5, -.05>
  <0,.75, 0> <.25,.75, 0> <.5,.75, -.05> <.7,.7, -.1>
}

#declare Paper3a = 
bicubic_patch
{
  type 1 // patch_type (0..1)
  flatness 0.1 // flatness value
  u_steps 3 // # of triangles to subdivide (1-5)
  v_steps 3 // # of triangles to subdivide (1-5)
  <0,  0, 0> <.25,  0, 0> <.5,  0, 0> <.75,  0, 0>
  <0,.25, 0> <.25,.25, 0> <.5,.25, 0> <.75,.25, 0>
  <0, .5, 0> <.25, .5, 0> <.5, .5, 0> <.75, .45, -.1>
  <0,.75, 0> <.25,.75, 0> <.45,.75, -.1> <.55,.55, -.25>
}

#declare Paper4 =
union {

	object {Paper3a}
	object {Paper1 translate <.75,0,0>}
	object {Paper2 translate <1.5,0,0>}
	object {Paper2 translate <2.25,0,0>}
	object {Paper1 translate <3,0,0>}
	object {Paper2 translate <3.75,0,0>}
	
	object {Paper1 translate <0,.75,0>}
	object {Paper1 translate <.75,.75,0>}
	object {Paper2 translate <1.5,.75,0>}
	object {Paper1 translate <2.25,.75,0>}
	object {Paper2 translate <3,.75,0>}
	object {Paper1 translate <3.75,.75,0>}  
	
	object {Paper1 translate <0,1.5,0>}
	object {Paper2 translate <.75,1.5,0>}
	object {Paper1 translate <1.5,1.5,0>}
	object {Paper3 translate <2.25,1.5,0>}
	object {Paper1 translate <3,1.5,0>}
	object {Paper2 translate <3.75,1.5,0>}
	
}	

#declare BILL =  
union {

//	box {<-2.5,0,0><2.5,3,.2> texture{EMBWood1 scale <.01,.1,.01>}} 
	object{Plank2} 
	object{Plank2 translate <.2,0,0>} 
	object{Plank2 translate <.4,0,0>}
	object{Plank2 translate <.6,0,0>}
	object{Plank2 translate <.8,0,0>}
	object{Plank2 translate <1.0,0,0>}
	object{Plank2 translate <1.2,0,0>} 
	object{Plank2 translate <1.4,0,0>}
	object{Plank2 translate <1.6,0,0>}
	object{Plank2 translate <1.8,0,0>}
	object{Plank2 translate <2.0,0,0>}
	object{Plank2 translate <2.2,0,0>}
	object{Plank2 translate <2.4,0,0>}
	
	object{Plank2 translate <-.2,0,0>}
	object{Plank2 translate <-.4,0,0>}
	object{Plank2 translate <-.6,0,0>}
	object{Plank2 translate <-.8,0,0>}
	object{Plank2 translate <-1.0,0,0>}
	object{Plank2 translate <-1.2,0,0>}
	object{Plank2 translate <-1.4,0,0>}
	object{Plank2 translate <-1.6,0,0>}
	object{Plank2 translate <-1.8,0,0>}
	object{Plank2 translate <-2.0,0,0>}
	object{Plank2 translate <-2.2,0,0>}
	object{Plank2 translate <-2.4,0,0>}

//	box {<-2.4,.5,0><2.4,.35,-.05> texture{Rust}}

	object {Paper4	translate <-2.25,.5,-.06> 
	
	texture{pigment{
			image_map {tga "banner.tga"}
		}
		translate <-.5,-.5,0>
		scale <4.5,2.5,1>
		translate <0,1.5,-.05>
		} 
		normal {crackle .15 scale <.05,.15,.05>}
		finish {phong .5}
	
	}

    box {<2.35,.25,0><-2.35,2.9,-0.01> 
    	texture {
    		pigment{
    		bozo
    		color_map {
    			[0.0 rgb <1,1,.9>]
    			[1.0 rgb <.8,.8,.75>]
    		}
    		scale <3,2,1>
    		}
    	} 
    finish{phong .5} normal {crackle .075 scale <.05,.15,.05>}}
	  
	object {Support translate <0,-1.75,.2>}
	object {Support translate <2,-1.75,.2>}
	object {Support translate <-2,-1.75,.2>}

	#if (Pig_Switch = on)

	PIGGY (<-90,0,0>,<30,0,30>,<-30,0,10>,-30)
	// billboard  
	object {PIG texture{Pigtex1} scale .175 rotate <45,150,0> translate <-1.25,2,-1>} 

	#end   

	// logo
    #declare Logo = 
    box {<0,0,0><1,1,.1>
    	texture{pigment{
    		image_map{tga "logo.tga"}
    	}}
    }
    
    object {Logo scale <.5,.15,1> scale 2 translate <1.1,.1,-.08>
    	finish{phong .5 reflection .2}
    	normal {wrinkles .1 scale .1}
    }

} 

object {BILL rotate <0,35,0> translate <0,1.25,2>}
