/*
#include "colors.inc"

camera {
	location <0,10,0>
	look_at  <0,1,0>
}

//  normal{wrinkles 1 scale <1,.2,.2>}


light_source {<5,10,-7> color White}

*/

//#declare Pig_Head_R = <0,0,0>;  
//#declare Pig_Legs_F = <10,0,10>;
//#declare Pig_Legs_R = <-10,0,10>; 
//#declare Pig_Wing_A = 0;

#declare Pigtex1 =
texture { 
	pigment{rgb <1,.8,.75>}
	normal {wrinkles .25 scale <.5,.5,1> scale .5 scallop_wave turbulence <.3,.3,.7>} 
	finish {phong .2 phong_size 10}
} 

#declare Pigtex2 =
texture { 
	pigment{rgb <.6,.3,.25>}
	normal {wrinkles .25 scale <.5,.5,1> scale .5 scallop_wave turbulence <.3,.3,.7>} 
	finish {phong .2 phong_size 10}
}

#declare Pigtex3 =
texture { 
	pigment{rgb <.3,.15,.1>}
	normal {wrinkles .25 scale <.5,.5,1> scale .5 scallop_wave turbulence <.3,.3,.7>} 
	finish {phong .2 phong_size 10}
} 

#declare Pigtex4 =
texture {pigment {
	wood
	color_map {
		[0.0 rgb <.3,.1,.1>]
		[0.3 rgb <.3,.1,.1>]
		[0.4 rgb <.8,.6,.5>]
		[0.4 rgb <.95,1,.9>]
		[1.0 rgb <.95,1,.8>]
	}
	scale .3
	}
	finish {phong 1 reflection .1}
}

#macro Pigs_Leg (ROTATE,ORIGIN) //- <.3,-1.5,2.2>)
	sphere {<0,0,0>,.4,1 rotate ROTATE translate ORIGIN}
	cylinder {(<.3,-1,2.2>- <.3,-1.5,2.2>)(<.3,-2.2,2.2>- <.3,-1.5,2.2>),.3,1 rotate ROTATE translate ORIGIN}  
	sphere {(<.35,-2.3,2.1>- <.3,-1.5,2.2>),.15,1 rotate ROTATE translate ORIGIN texture{Pigtex2}}
	sphere {(<.25,-2.3,2.1>- <.3,-1.5,2.2>),.15,1 rotate ROTATE translate ORIGIN texture{Pigtex2}}
	sphere {(<.3,-2.3,2.1>- <.3,-1.5,2.2>),.15,-1 rotate ROTATE translate ORIGIN texture{Pigtex2}} 
	sphere {(<.3,-2.25,2.3>- <.3,-1.5,2.2>),.15,1 rotate ROTATE translate ORIGIN texture{Pigtex2}}
#end

#macro PIGGY (HEAD,LEGS1,LEGS2,WING) 

#declare Pig_Head_R = HEAD;  
#declare Pig_Legs_F = LEGS1;
#declare Pig_Legs_R = LEGS2; 
#declare Pig_Wing_A = WING;

#declare PIG = 
union {

// the pigs head

blob {
	threshold .7  
	
	
	// head  
	
	sphere {<0,0,0>,1.5,1}  
	
	// eyes
	
	sphere {<.35,.35,-.5>.2,-1 rotate Pig_Head_R texture{Pigtex2}}
	sphere {<.25,.25,-.3>.15,-1 rotate Pig_Head_R texture{Pigtex2}} 
	sphere {<0,0,0>,.15,1 scale <1.75,1,.75> rotate <-15,5,-5> translate <.25,.35,-.3> rotate Pig_Head_R texture{Pigtex3}}
	
	sphere {<-.35,.35,-.5>.2,-1 rotate Pig_Head_R texture{Pigtex2}}
	sphere {<-.25,.25,-.3>.15,-1 rotate Pig_Head_R texture{Pigtex2}} 
	sphere {<0,0,0>,.15,1 scale <1.75,1,.75> rotate <-15,5,-5> translate <-.25,.35,-.3> rotate Pig_Head_R texture{Pigtex3}}
	
	// SNOUT
	
	cylinder {<0,-.1,0><0,-.1,-.85>,.3,1 rotate Pig_Head_R texture{Pigtex2}} 
	cylinder {<0,.1,0><0,.1,-.65>.1,1 rotate Pig_Head_R}
	sphere {<0,-.1,-.9>.3,-1 rotate Pig_Head_R}  
	
	cylinder {<0,0,0><0,0,-.5>,.15,-1 scale <.4,1,1> translate <.1,-.1,-.25> rotate Pig_Head_R texture{Pigtex3}}
	cylinder {<0,0,0><0,0,-.5>,.15,-1 scale <.4,1,1> translate <-.1,-.1,-.25> rotate Pig_Head_R texture{Pigtex3}}    
	
	// ear mounds
	
	sphere {<.4,.4,.1>,.2,1 rotate Pig_Head_R texture{Pigtex2}} 
	sphere {<.55,.45,.05>,.15,1 rotate Pig_Head_R texture{Pigtex2}}
	sphere {<.55,.45,0>,.15,-1 rotate Pig_Head_R texture{Pigtex2}}  
	
	sphere {<-.4,.4,.1>,.2,1 rotate Pig_Head_R texture{Pigtex2}} 
	sphere {<-.55,.45,.05>,.15,1 rotate Pig_Head_R texture{Pigtex2}}
	sphere {<-.55,.45,0>,.15,-1 rotate Pig_Head_R texture{Pigtex2}}  
	
	//mouth
	
	cylinder {<0,0,0><0,0,-.5>,.2,1 scale <1.3,.5,1> translate <0,-.4,0> rotate Pig_Head_R texture{Pigtex2}}  
	
	// fixed piggy neck
	
	cylinder {<0,0,0><0,-.5,1>,.3,1}	

}

// eyes balls

sphere {<-.25,.25,-.3>,.13  texture{Pigtex4 rotate <5,15,0> translate <-.25,.25,-.3>} rotate Pig_Head_R}
sphere {<.25,.25,-.3>,.13  texture{Pigtex4 rotate <5,-15,0> translate <.25,.25,-.3>} rotate Pig_Head_R}

// ears   

#include "ear.inc"

object {Pigs_Ear scale .35 rotate <-10,0,10> translate <.4,.5,0> rotate Pig_Head_R} 
object {Pigs_Ear scale .35 rotate <-10,0,10> translate <.4,.5,0> scale <-1,1,1> rotate Pig_Head_R}

// the pigs body


blob {
	threshold .7  
	
	// piggy neck 
	
	cylinder {<0,0,0><0,-.5,1>,.3,1}   
	
	// piggy body
	
	sphere {<0,0,0>,2,1 scale <.8,1,1.4> translate <0,-.75,1.5>} 
	sphere {<0,-.2,.85>,.35,1}      
	
	// piggy legs front
	
	sphere {<0,0,0>,.8,1 scale <.5,1,.75> translate <.3,-1,1>} 
	sphere {<0,0,0>,.8,1 scale <.5,1,.75> translate <-.3,-1,1>}
	
	// piggy legs rear 
	
	sphere {<0,0,0>,.8,1 scale <.5,1,.75> translate <.3,-1,2.2>} 
	sphere {<0,0,0>,.8,1 scale <.5,1,.75> translate <-.3,-1,2.2>}  
	
	// plr2       
	
	#local Pig_Legs_R2 = (Pig_Legs_R * <1,1,-1>);
	Pigs_Leg (Pig_Legs_R,<.35,-1.5,2.2>) 
	Pigs_Leg (Pig_Legs_R2,<-.35,-1.5,2.2>) 
	
	// plf2
	
	#local Pig_Legs_F2 = (Pig_Legs_F * <1,1,-1>);
	Pigs_Leg (Pig_Legs_F,<.35,-1.5,1>) 
	Pigs_Leg (Pig_Legs_F2,<-.35,-1.5,1>)
	
}

	// pig tail 
   
    #include "torspline.inc"
	#declare Pts=array[5]{<0,-.8,2.6>, <.2,-1,2.9>, <.2,-1.2,2.9>, <-.1,-1,3.2>, <.1,-1.3,3.4>}
	TorusSpline(.05,Pts,<0,0,1>)	
	
    // the wings
    
    #include "wings.inc"
    WINGS (Pig_Wing_A,<0,-.275,1.75>,5)
			
}

#end

