//Clinker built boat by M. Hazelgrove, modified and completed by Ch. Gerber

#declare Prow = union {
   #declare Count = 0;
   #declare Radius = 1;
   #declare Angle = 0;
   #declare SphRad = 0.01;
   #while (Count<140)
      sphere{ 
         0,SphRad scale <0.6,1.7,0.6>
         translate <Count/25,pow(Count,2)/750,0>
         rotate z*Angle
      }
      #declare Count = Count+1;
      #declare Angle = Angle+5;
      #declare SphRad = SphRad+0.03;
      #declare Radius =  Radius+Radius;
   #end
   rotate x*180
}

#declare Prow2 = union {
   #declare Count = 0;
   #declare Radius = 100;
   #declare Angle = 280;
   #declare SphRad = 4.2;
   #while (Count<40)
      sphere{
         0,SphRad scale <0.6,1.7,0.6>
         translate <0,Radius,0>
         rotate z*Angle
      }
      #declare Count = Count+1;
      #declare Angle = Angle+1;
      #declare SphRad = SphRad+0.03;
   #end
   rotate x*180
}

#declare FProw = union {
   object {Prow  scale 0.025 rotate z*35}
   object {Prow2 scale 0.025 translate <-1.8495,0.15,0>}
   object {
      torus {0.1,0.075 scale <1.6,1.4,0.5>}
      translate <0.6,-0.175,0>
   }
   translate <4.85,1,0>
}

#declare Post = intersection {
   difference {
      cylinder {z*-0.05,z*0.05,2.1}
      cylinder {z*-0.2,z*0.2,1.95}
   }  
   torus {2.025,0.075 scale <1,0.85,1> rotate 90*x}
   scale <2.5,1.25,1>
   clipped_by {sphere {0,20 inverse translate <1,19.1,0>}}
}

#declare BtShape = union {
   sphere {0,2
      scale <2.5,1.25,1>
      clipped_by {sphere{0,20 inverse translate <1,18,0>}}
      texture {B_Tex}
   }
   sphere {0,2
      scale <2.5,1.25,1>
      clipped_by {sphere{0,20 inverse translate <1,18.2,0>}}
      clipped_by {sphere{0,20 translate <1,18,0>}}
      texture {B_Tex}
      scale 1.01
   }
   sphere {0,2
      scale <2.5,1.25,1>
      clipped_by {sphere {0,20 inverse translate <1,18.4,0>}}
      clipped_by {sphere {0,20 translate <1,18.2,0>}}
      texture {B_Tex}
      scale 1.02
   }
   sphere {0,2
      scale <2.5,1.25,1>
      clipped_by {sphere {0,20 inverse translate <1,18.6,0>}}
      clipped_by {sphere {0,20 translate <1,18.4,0>}}
      texture {B_Tex}
      scale 1.03
   }
   sphere {0,2
      scale <2.5,1.25,1>
      clipped_by {sphere {0,20 inverse translate <1,18.8,0>}}
      clipped_by {sphere {0,20 translate <1,18.6,0>}}
      texture {B_Tex}
      scale 1.04
   }
   intersection {
      difference {
         sphere {0,2.16}
         sphere {0,2.04}
         scale <2.5,1.25,1>
      }  
      sphere {0,20 inverse translate <1,18.72,0>}
      sphere {0,20 translate <1,18.68,0>}
      texture {B_Tex}
   }
   sphere {0,2
      scale <2.5,1.25,1>
      clipped_by {sphere{0,20 inverse translate <1,19,0>}}
      clipped_by {sphere{0,20 translate <1,18.8,0>}}
      texture {
         pigment {color rgb <0.4,1,0.3>} 
         finish {ambient 0.1 diffuse 0.8 specular 1 metallic reflection 0.2} 
      }
      scale 1.05
   }
   intersection {
      difference {
         sphere {0,2.16}
         sphere {0,2.04}
         scale <2.5,1.25,1>
      }  
      sphere {0,20 inverse translate <1,18.93,0>}
      sphere {0,20 translate <1,18.89,0>}
      texture {B_Tex}
   }
}

#declare Pin = union {
   sphere {<-10,4,0 >,0.75}
   cylinder {<-9.8125,4,0>,<-8.875,4,0>,0.5}
   sphere {<-9,4,0>,0.5}
   cylinder {<-9,4,0>,<-5,4,0>,0.5}
   sphere {<-5,4,0>,0.5}
   cylinder {<-5,4,0>,<-4.66057,4,0>,0.5}
   sphere {<-4.66057,4,0>,0.5}
   cylinder {<-4.66057,4,0>,<-4.22566,4,0>,0.5}
   sphere {<-4.22566,4,0>,0.5}
   cylinder {<-4.22566,4,0>,<-3.76159,3.91676,0>,0.5}
   sphere {<-3.76159,3.91676,0>,0.5}
   cylinder {<-3.76159,3.91676,0>,<-3.27207,3.76162,0>,0.5}
   sphere {<-3.27207,3.76162,0>,0.5}
   cylinder {<-3.27207,3.76162,0>,<-2.7608,3.55871,0>,0.5}
   sphere {<-2.7608,3.55871,0>,0.5}
   cylinder {<-2.7608,3.55871,0>,<-2.23148,3.31569,0>,0.5}
   sphere {<-2.23148,3.31569,0>,0.5}
   cylinder {<-2.23148,3.31569,0>,<-1.68782,3.04025,0>,0.5}
   sphere {<-1.68782,3.04025,0>,0.5}
   cylinder {<-1.68782,3.04025,0>,<-1.13353,2.74006,0>,0.5}
   sphere {<-1.13353,2.74006,0>,0.5}
   cylinder {<-1.13353,2.74006,0>,<-0.57229,2.42278,0>,0.5}
   sphere {<-0.57229,2.42278,0>,0.5}
   cylinder {<-0.57229,2.42278,0>,<-0.00783,2.0961,0>,0.5}
   sphere {<-0.00783,2.0961,0>,0.5}
   cylinder {<-0.00783,2.0961,0>,<0.55617,1.76768,0>,0.5}
   sphere {<0.55617,1.76768,0>,0.5}
   cylinder {<0.55617,1.76768,0>,<1.11599,1.4452,0>,0.5}
   sphere {<1.11599,1.4452,0>,0.5}
   cylinder {<1.11599,1.4452,0>,<1.66794,1.13634,0>,0.5}
   sphere {<1.66794,1.13634,0>,0.5}
   cylinder {<1.66794,1.13634,0>,<2.20831,0.84876,0>,0.5}
   sphere {<2.20831,0.84876,0>,0.5}
   cylinder {<2.20831,0.84876,0>,<2.7334,0.59014,0>,0.5}
   sphere {<2.7334,0.59014,0>,0.5}
   cylinder {<2.7334,0.59014,0>,<3.2395,0.36815,0>,0.5}
   sphere {<3.2395,0.36815,0>,0.5}
   cylinder {<3.2395,0.36815,0>,<3.72292,0.19047,0>,0.5}
   sphere {<3.72292,0.19047,0>,0.5}
   cylinder {<3.72292,0.19047,0>,<4.17994,0.06477,0>,0.5}
   sphere {<4.17994,0.06477,0>,0.5}
   cylinder {<4.17994,0.06477,0>,<4.60687,0.00128,0>,0.5}
   sphere {<4.60687,0.00128,0>,0.5}
   cylinder {<4.60687,0.00128,0>,<5,0,0>,0.5}
   sphere {<5,0,0>,0.5}
   cylinder {<5,0,0>,<15,0,0>,0.5}
   sphere {<15,0,0>,0.5}
   rotate <180,0,165>
   scale 0.125
}

#declare Boat = union {
   object {BtShape clipped_by {plane {z,-0.4}} translate <0,0,0.4>}
   object {BtShape clipped_by {plane {z, 0.4 inverse}} translate <0,0,-0.4>}
   object {FProw texture {B_Tex} scale 0.75 rotate z*18 translate <1.4,-1.25,0>}
   object {Post texture{B_Tex}}
   object {Pin texture {B_Tex} translate <-3.6,-0.3,0>}
   rotate z*10
}