//Parts and complete buildings to set up an ancient city

#declare ColumnStone = texture {pigment {rgb <1, 1, 1>} finish {ambient 0.15 diffuse 0.9 phong 0.5 phong_size 80}}
#declare WallStone   = texture {SandStone scale 30}
#declare BaseStone   = texture {SandStone scale 30}

//--- Parts ---

//column (length 10*y, bottom 0)

#declare a=15;
#declare R=sin(radians(a/2));
#declare n=0;
#declare k=0.916666666666666;

#declare Beam = union {
   cylinder {<0, -4.5, 0>, <0, 4.5, 0>, R}
   sphere {<0, -4.5, 0> R}
   sphere {<0,  4.5, 0> R}
   scale <0.5, 1, 1>
}

#declare BaseColumn = difference {
   cylinder {-5*y, 5*y, 1}
   union {
      #while (n < (360/a+1))
       object {Beam translate 1*x rotate y*n*a}
       #declare n=n+1;
      #end
   }
   bounded_by {cylinder {<0, -6, 0>, <0, 6, 0>, 1.5}}
}

#declare BasePad = union {
   intersection {
      quadric {
         <1.0, -1.0, 1.0>,
         <0.0,  0.0, 0.0>,
         <0.0,  0.0, 0.0>,
         -1.0
      }
      plane {y,  0}
      plane {y, -0.75 inverse}
   }
   intersection {
      sphere {0*x, 1 scale <1.5, 1.658312395177698, 1.5>}
      plane {y,  k}
      plane {y, -k inverse} 
      translate y*-(k+0.75)
   }
   union {
      cylinder {-0.25*y, 0*y, 1.25}
      box {<-1.51875, -1.0, -1.51875>, <1.51875, -0.25, 1.51875>}
      translate y*-(2*k+0.75)
   }
   cylinder {-0.25*y, 0*y, 1.25 translate y*-(2*k+0.75)}
   scale <1, 1.5/(2*k+1.75), 1>
}

#declare TopPad = union {
   intersection {
      quadric {
         <1.0, -1.0, 1.0>,
         <0.0,  0.0, 0.0>,
         <0.0,  0.0, 0.0>,
         -1.0
      }
      plane {y, 0.75}
      plane {y, 0 inverse}
   }
   cylinder {0*y, 0.75*y, 1.25 translate y*0.75}
   scale <1, 0.65/1.5, 1>
}

#declare Column = union {
   object {BaseColumn }
   object {BasePad translate y*-5}
   object {TopPad translate y*5}
   translate y*6.5
   scale 10/12.15
}

//arch

#declare Arch = intersection {
   difference {
      cylinder {<2, 0, 0>, <-2, 0, 0>, 11.356}
      union {
         cylinder {<4, 0, 0>, <-4, 0, 0>, 7.356}
         plane {y, 0}
     }
   }
   torus {9.365, 2.4 rotate 90*z}
   texture {ColumnStone}
}

//connector (length 25*y, center 0)

#declare Pad = intersection {
   plane {x, 0 rotate -15*z translate 2*x}
   plane {x, 0 inverse rotate 15*z translate -2*x}
   plane {y,  2}
   plane {y, -2 inverse}
   plane {z, -1 inverse}
   plane {z,  5}
}

#declare Connector = union {
   object {Pad translate 5*y}
   object {Pad rotate 180*z translate -5*y}
   cylinder {< 0.8, -4, 0>, < 0.8, 4, 0>, 0.5}
   cylinder {<-0.8, -4, 0>, <-0.8, 4, 0>, 0.5}
   bounded_by {box {<3, -8, -2>, <-3, 8, 6>}}
   scale 25/14
   texture {ColumnStone}
}  

//small dome

#declare SFullColumn = union {
   object {Column scale <3.3, 4.4, 3.3> texture {ColumnStone} translate 45*x}
   object {Arch translate -9.356*z rotate 12*y translate < 45, 44, 0>}
}

#declare SP1 = difference {
   cylinder {<0, 6, 0>, <0, -6, 0>, 46}
   cylinder {<0, 7, 0>, <0, -7, 0>, 43}
   #declare nc=0;
   #while (nc<15)
      cylinder {<42, -6, 0>, <47, -6, 0>, 9.356 rotate (nc*24+12)*y}
      #declare nc=nc+1;
   #end
   texture {WallStone}
}
   
#declare SP2 = union {
   difference {
      difference {sphere {<0, 6, 0>, 47} plane {y, 7}}
      difference {sphere {<0, 6, 0>, 43} plane {y, 6}}
   }
   difference {
      cone {<0, 6, 0>, 46, <0, 7, 0>, 47}
      cylinder {<0, 5, 0>, <0, 8, 0>, 43}
   }
   texture {WallStone}
}

#declare SRoof = union {object {SP1} object {SP2}}

#declare SmallDome = union {
   #declare nc=0;
   #while (nc<15)
      object {SFullColumn rotate nc*24*y}
      #declare nc=nc+1;
   #end   
   object {SRoof translate 50*y}
}

//small floor (height 76, radius 63)

#declare SFFullColumn = union {
   object {Column scale <3.3, 4.4, 3.3> texture {ColumnStone} translate 60*x}
   object {Arch translate -9.356*z rotate 9*y translate <60, 44, 0>}
}

#declare SCore = cylinder {<0, 0, 0>, <0, 56, 0>, 55 texture {WallStone}}

#declare SP3 = difference {
   cylinder {<0, 6, 0>, <0, -6, 0>, 61}
   cylinder {<0, 7, 0>, <0, -7, 0>, 58}
   #declare nc=0;
   #while (nc<20)
      cylinder {<57, -6, 0>, <62, -6, 0>, 9.356 rotate (nc*18+9)*y}
      #declare nc=nc+1;
   #end
   texture {WallStone}
}

#declare SP4 = union {
   cylinder {<0, 2, 0>, <0, 20.644, 0>, 63}
   cone {<0, 0, 0>, 61, <0, 2, 0>, 63}    
   texture {WallStone}  
}   

#declare SmallFloor = union {
   #declare nc=0;
   #while (nc<20)
      object {SFFullColumn rotate nc*18*y}
      #declare nc=nc+1;
   #end
   object {SP3 translate 50*y}
   object {SP4 translate 55.356*y}
   object {SCore}
}

//big dome

#declare BFullColumn = union {
   object {Column scale <3.3, 3.3, 3.3> texture {ColumnStone} translate 90*x}
   object {Arch translate -9.356*z rotate 6*y translate <90, 33, 0>}
}

#declare BCore = cylinder {<0, 0, 0>, <0, 45, 0>, 85 texture {WallStone}}
   
#declare BP1 = difference {
   cylinder {<0, 6, 0>, <0, -6, 0>, 91.5}
   cylinder {<0, 7, 0>, <0, -7, 0>, 88.0}
   #declare nc=0;
   #while (nc<30)
      cylinder {<87, -6, 0>, <92, -6, 0>, 9.356 rotate (nc*12+6)*y}
      #declare nc=nc+1;
   #end
   texture {WallStone}
}

#declare BP2 = union {
   difference {sphere {<0, 6, 0>, 92.5} plane {y, 7}}
   cone {<0, 6, 0>, 91.5, <0, 7, 0>, 92.5}
   texture {WallStone}
}

#declare BRoof = union {object {BP1} object {BP2}}

#declare BigDome = union {
   #declare nc=0;
   #while (nc<30)
      object {BFullColumn rotate nc*12*y}
      #declare nc=nc+1;
   #end
   object {BRoof translate 39*y}
   object {BCore}   
}

//big floor (height 65, radius 94) 

#declare BP3 = union {
   cylinder {<0, 2.5, 0>, <0, 20.644, 0>, 95}
   cone {<0, 0, 0>, 91.5, <0, 2.5, 0>, 95}    
   texture {WallStone}  
}   

#declare BigFloor = union {
   #declare nc=0;
   #while (nc<30)
      object {BFullColumn rotate nc*12*y}
      #declare nc=nc+1;
   #end
   object {BP1 translate 39*y}
   object {BP3 translate 44.356*y}
   object {BCore}   
}

//half big dome

#declare BHCore = object {object {BCore} clipped_by {plane {z, 0}}}   
   
#declare BHP1 = object {object {BP1} clipped_by {plane {z, 0}}}

#declare BHP2 = union {
   difference {sphere {<0, -1, 0>, 92.5} plane {y, 0} scale <1, 0.5, 1> translate 7*y}
   cone {<0, 6, 0>, 91.5, <0, 7, 0>, 92.5}
   texture {WallStone}
   clipped_by {plane {z, 0}}
}
 
#declare BHRoof = union {object {BHP1} object {BHP2}}

#declare BigHDome = union {
   #declare nc=0;
   #while (nc<16)
      object {BFullColumn rotate nc*12*y}
      #declare nc=nc+1;
   #end
   object {BHRoof translate 39*y}
   object {BHCore}   
}

//big middle part

#declare BMFullColumn = union {
   object {Column scale <3.3, 3.3, 3.3> texture {ColumnStone}}
   object {Arch translate -9.356*z rotate 90*y translate 33*y}
}

#declare BMCore = box {<-95, 0, -85>, <95, 45, 85> texture {WallStone}}

#declare BMP1 = difference {
   box {<-95, -6, -91.5>, <95, 6, 91.5>}
   #declare nc=0;
   #while (nc<10)
      cylinder {<0, -6, -93>, <0, -6, 93>, 9.356 translate (-85.5+19*nc)*x}
      #declare nc=nc+1;
   #end
   texture {WallStone}
}

#declare BMP2 = union {
   difference {cylinder {<-95, -1, 0>, <95, -1, 0>, 92.5} plane {y, 0} scale <1, 0.5, 1> translate 1*y}
   intersection {
      plane {x, 95}
      plane {x,-95 inverse}
      plane {y, 1}
      plane {y, 0 inverse}
      plane {z, 0 rotate 45*x translate 91.5*z}
      plane {z, 0 inverse rotate -45*x translate -91.5*z}
   }
   texture {WallStone}
}

#declare BigMPart = union {
   #declare nc=0;
   #while (nc<9)
      object {BMFullColumn translate <-76+19*nc, 0, -90>}
      object {BMFullColumn translate <-76+19*nc, 0,  90>}
      #declare nc=nc+1;
   #end
   object {Arch translate -9.356*z rotate 90*y translate <95, 33,  90>}
   object {Arch translate -9.356*z rotate 90*y translate <95, 33, -90>}
   object {BMP1 translate 39*y}
   object {BMP2 translate 45*y}
   object {BMCore}
}

//small top
#declare ST1 = union {
   lathe{
      cubic_spline
      9,
      <0.200000,1.000000>,
      <0.200000,0.950000>,
      <0.200000,0.900000>,
      <0.190000,0.780000>,
      <0.150000,0.640000>,
      <0.060000,0.430000>,
      <0.010000,0.210000>,
      <0.000000,0.030000>,
      <0.000000,0.000000>
      rotate 180*z translate 1*y 
   }
   cylinder {<0, 0, 0>, <0, 0.05, 0>, 0.2}   
   scale 200 texture {WallStone}
}

//--- Complete Buildings ---

//big tower with 2 floors
#declare B1 = union {
   cylinder {<0, 0, 0>, <0, 100, 0>, 95 texture {BaseStone}}
   object {BigFloor translate 100*y}
   object {BigDome  translate 165*y} 
}

//medium tower with 2 floors
#declare B2 = union {
   cylinder {<0, 0, 0>, <0, 105, 0>, 66 texture {BaseStone}}
   object {SmallFloor translate 105*y}
   union {
      cone {<0, 181, 0>, 63, <0, 205, 0>, 50}
      cylinder {<0, 205, 0>, <0, 230, 0>, 50}
      texture {WallStone}
   }   
   object {SmallDome translate 230*y}
}

//big tower with 3 floors
#declare B3 = union {
   cylinder {<0, 0, 0>, <0, 100, 0>, 95 texture {BaseStone}}
   object {BigFloor translate 100*y}
   cone {<0, 165, 0>, 95, <0, 170, 0>, 90 texture {WallStone}}
   object {SmallFloor scale <1, 3/4, 1> translate y*170}
   union {
      cone {<0, 227, 0>, 63, <0, 240, 0>, 50}
      cylinder {<0, 240, 0>, <0, 260, 0>, 50}
      texture {WallStone}
   }   
   object {SmallDome translate 260*y}
}

//small tower with 1 floor   
#declare B4 = union {
   union {
      cylinder {<0, 0, 0>, <0, 200, 0>, 50 texture {BaseStone}}
      cylinder {<0, 200, 0>, <0, 256, >, 40 texture {WallStone}} 
   }
   object {SmallDome translate 200*y}
}     

//big round hall
#declare B5 = union {
   cone {<0, 0, 0>, 150, <0, 120, 0>, 129 texture {BaseStone}}
   union {
      #declare nc=0;
      #while (nc<30)
         object {Connector rotate 10*x translate -128*z rotate nc*12*y translate 129*y}
         #declare nc=nc+1;
      #end
   }
   cone {<0, 120, 0>, 123, <0, 139, 0>, 119.5 texture {WallStone}}
   difference {
      sphere {0, 125.5}
      plane {y, 0}
      scale <1, 0.5, 1> 
      translate 138.5*y 
      texture {WallStone}
   }   
}

//small round hall
#declare B6 = union {
   cone {<0, 0, 0>, 100, <0, 80, 0>, 86 texture {BaseStone}}
   union {
      #declare nc=0;
      #while (nc<18)
         object {Connector rotate 10*x translate -84.5*z rotate nc*20*y translate 89*y}
         #declare nc=nc+1;
      #end
   }
   cone {<0, 80, 0>, 80, <0, 99, 0>, 76.5 texture {WallStone}}
   difference {
      sphere {0, 82.5}
      plane {y, 0}
      scale <1, 0.5, 1> 
      translate 98.5*y 
      texture {WallStone}
   }   
}

//big long hall
#declare B7 = union {
   union { 
      superellipsoid {<0.02, 0.02> scale <95, 160, 110>}
      superellipsoid {<1, 0.02> rotate 90*x scale <110, 160, 110> translate  95*x}
      superellipsoid {<1, 0.02> rotate 90*x scale <110, 160, 110> translate -95*x}
      translate -60*y
      clipped_by {plane {y, 0 inverse}}
      texture {BaseStone}
   }   
   object {BigMPart translate 100*y}
   object {BigHDome rotate  90*y translate <-95, 100, 0>}
   object {BigHDome rotate -90*y translate < 95, 100, 0>}
      
}   

//small tower with point roof   
#declare B8 = union {
   cylinder {<0, 0, 0>, <0, 150, 0>, 40 texture {BaseStone}}
   #declare nc=0;     
   #while (nc<6)
      object {Connector translate <0, 160, -41> rotate nc*60*y}
      #declare nc=nc+1;
   #end
   cylinder {<0, 145, 0>, <0, 175, 0>, 37 texture {WallStone}} 
   object {ST1 translate 170*y}
}      

//big dome
#declare B9 = union {
   cylinder {<0, 0, 0>, <0, 100, 0>, 95 texture {BaseStone}}
   object {BigDome translate 100*y}
}

//small dome
#declare B10 = union {
   cylinder {<0, 0, 0>, <0, 100, 0>, 50 texture {BaseStone}}
   cylinder {<0, 100, 0>, <0, 150, 0>, 40 texture {WallStone}}
   object {SmallDome translate 100*y}
}      
 