//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 5 lights, 24 materials and 1132 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 06/28/1999    (28.06.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 14
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      0.000,    -122.899,     329.497>
  direction <        0.0,         0.0,      0.6667> // Aperture is 1.29 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     95.711,     542.898,     220.700>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <   -100.084,    -111.136,     321.340> // Attached to Spotlight001
  direction <        0.0,         0.0,      0.5501> // Aperture is 1.48 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -90.738,    -108.104,     319.480> // Following Spotlight001
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight001
  <-100.084, -111.136, 321.340>
  color rgb <1.000, 1.000, 1.000>*0.2378
  spotlight
    point_at  <-81.391, -105.073, 317.620>
    falloff    42.268  // outer radius (in deg)
    radius     0.100  // inner radius
    tightness  0.000
  media_interaction off
}

light_source {   // Instrumentenlicht
  <45.035, -71.296, 331.415>
  color rgb <1.000, 0.329, 0.000>
  fade_distance  8.0
  fade_power 1.0
  media_interaction off
}

light_source {   // Instrumentenlicht
  <45.035, -71.296, 331.415>
  color rgb <1.000, 0.329, 0.000>
  fade_distance  8.0
  fade_power 1.0
  media_interaction off
}

light_source {   // skylight
  <-1215.559, 499.505, 715.165>
  color rgb <0.543, 0.543, 0.686>*0.2635
  shadowless
  media_interaction off
}

light_source {   // Sun
  <-1202.611, 2008.183, 860.544>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  MATERIALS  *******
//

#include "beans.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare BezPtch015 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt44 = union {
  cone { // Cone015
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch015 }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <31.628035, -259.103821, 307.123962>
    translate  <-1.161474, -3.837334, 0.018375>
  }
  scale 0.5
  rotate <-12.041919, -1.656685, 55.464649>
  translate  <-2.33158, 1.920636, 4.682748>
}
#declare BezPtch016 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt47 = union {
  cone { // Cone016
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch016 }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <29.587643, -258.484039, 305.296539>
    translate  <-1.160273, -3.839119, 0.016444>
  }
  scale 0.5
  rotate <168.158859, -136.436874, -86.324211>
  translate  <-3.477381, 0.187207, 4.456019>
}
#declare Blatt45 = object {
  object { // Blatt45->Blatt47
    Blatt47
    rotate <125.623444, -169.508286, 304.291656>
    translate  <3.056851, 1.831936, -1.814514>
  }
}
#declare TText001 = object {
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Space Crawler",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Red
    }
    scale <1.5, 1.5, 1.0>
    rotate <33.293095, 0.0, -90.0>
    translate  <-7.121753, 6.172618, 2.598728>
  }

}
#declare Pilotenkopf = union {
  sphere { // Pilotenhaare
    <0,0,0>,1
    material {
      DullMBlack
    }
    scale <2.447901, 1.779639, 2.447901>
    rotate -41.503437*x
    translate  <0.0, -2.385043, 35.149011>
  }
  cone { // Pilotennase
    <0,0,0>, 0.2, <0,0,1>, 1.0
    scale <0.436414, 0.65278, 0.894952>
    rotate -173.531998*x
    translate  <0.0, 0.399934, 34.039804>
    material {
      Skin
      // Transform to world space
      translate  <-0.0, 1.589653, 0.794827>
      rotate 2.692987*x
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Pilotengesicht
    <0,0,0>,1
    scale <2.221424, 2.144957, 2.805427>
    rotate 8.423429*x
    translate  <0.0, -1.661083, 33.802397>
    material {
      Skin
      // Transform to world space
      translate  <-0.0, 1.589653, 0.794827>
      rotate 2.692987*x
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  cylinder { // Pilotenhals
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.061073, 2.810566>
    rotate -6.346067*x
    translate  <0.0, -2.214777, 29.345796>
    material {
      Skin
      // Transform to world space
      translate  <-0.0, 1.589653, 0.794827>
      rotate 2.692987*x
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  rotate -2.692987*x
  translate  <0.0, -1.589653, -0.794827>
}
#declare Pilotenarm1 = union {
  sphere { // Po3
    <0,0,0>,1
    scale 2.522659
    translate  <0.0, -2.353201, 18.410334>
    material {
      Overallstoff
      // Transform to world space
      translate  <-4.597311, 0.529884, -14.963283>
      rotate 5.0*y
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Oberschenkel3
    <0,0,0>,1
    scale <2.0, -5.198025, 1.861576>
    rotate <-69.253372, -0.0, -0.0>
    translate  <0.0, -1.277447, 14.702566>
    material {
      Overallstoff
      // Transform to world space
      translate  <-4.597311, 0.529884, -14.963283>
      rotate 5.0*y
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Knie4
    <0,0,0>,1
    scale 1.830541
    translate  <0.0, 0.327479, 10.653091>
    material {
      Overallstoff
      // Transform to world space
      translate  <-4.597311, 0.529884, -14.963283>
      rotate 5.0*y
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Unterschenkel3
    <0,0,0>,1
    scale <1.692118, 1.968965, 5.567977>
    rotate <66.27655, 0.0, -0.0>
    translate  <0.0, 4.238531, 8.380567>
    material {
      Overallstoff
      // Transform to world space
      translate  <-4.597311, 0.529884, -14.963283>
      rotate 5.0*y
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Fusselenk3
    <0,0,0>,1
    scale 1.3
    translate  <0.0, 9.158887, 6.526872>
    material {
      DullMBlack
      // Transform to world space
      translate  <-4.597311, 0.529884, -14.963283>
      rotate 5.0*y
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Schuh4
    <0,0,0>,1
    scale <1.0, 2.5, 1.5>
    rotate -6.528854*x
    translate  <0.0, 11.349143, 6.074819>
    material {
      DullMBlack
      // Transform to world space
      translate  <-4.597311, 0.529884, -14.963283>
      rotate 5.0*y
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  scale 0.7
  rotate -5.0*y
  translate  <4.597311, -0.529884, 14.963283>
}
#declare Pilotenarm = union {
  sphere { // Po2
    <0,0,0>,1
    scale 2.522659
    translate  <0.0, -2.353201, 18.410334>
    material {
      Overallstoff
      // Transform to world space
      translate  <4.852294, -2.119538, -15.669795>
      rotate -0.943732*z rotate -4.193295*y rotate -12.695584*x
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Oberschenkel2
    <0,0,0>,1
    scale <2.0, -5.198025, 1.861576>
    rotate <-69.253372, -0.0, -0.0>
    translate  <0.0, -1.277447, 14.702566>
    material {
      Overallstoff
      // Transform to world space
      translate  <4.852294, -2.119538, -15.669795>
      rotate -0.943732*z rotate -4.193295*y rotate -12.695584*x
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Knie3
    <0,0,0>,1
    scale 1.830541
    translate  <0.0, 0.327479, 10.653091>
    material {
      Overallstoff
      // Transform to world space
      translate  <4.852294, -2.119538, -15.669795>
      rotate -0.943732*z rotate -4.193295*y rotate -12.695584*x
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Unterschenkel2
    <0,0,0>,1
    scale <1.692118, 1.968965, 5.567977>
    rotate <66.27655, 0.0, -0.0>
    translate  <0.0, 4.238531, 8.380567>
    material {
      Overallstoff
      // Transform to world space
      translate  <4.852294, -2.119538, -15.669795>
      rotate -0.943732*z rotate -4.193295*y rotate -12.695584*x
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Fusselenk2
    <0,0,0>,1
    scale 1.3
    translate  <0.0, 9.158887, 6.526872>
    material {
      DullMBlack
      // Transform to world space
      translate  <4.852294, -2.119538, -15.669795>
      rotate -0.943732*z rotate -4.193295*y rotate -12.695584*x
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Schuh3
    <0,0,0>,1
    scale <1.0, 2.5, 1.5>
    rotate -6.528854*x
    translate  <0.0, 11.349143, 6.074819>
    material {
      DullMBlack
      // Transform to world space
      translate  <4.852294, -2.119538, -15.669795>
      rotate -0.943732*z rotate -4.193295*y rotate -12.695584*x
      scale 1.0/0.7
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  scale 0.7
  rotate <12.695584, 4.193295, 0.943732>
  translate  <-4.852294, 2.119538, 15.669795>
}
#declare Pilotenoberkoeper = union {
  sphere { // Pilotenkreuz
    <0,0,0>,1
    material {
      Overallstoff
    }
    scale <4.102602, 2.334126, 2.110579>
    translate  <-0.138424, 0.0, 28.012463>
  }
  sphere { // Pilotenrumpf
    <0,0,0>,1
    scale <3.518671, 2.384236, 5.291131>
    translate  <0.138424, 0.0, 24.224124>
    material {
      Overallstoff
      // Transform to world space
      translate  2.353201*y
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Becken
    <0,0,0>,1
    scale <4.183742, 2.384236, 2.245812>
    translate  20.071417*z
    material {
      Overallstoff
      // Transform to world space
      translate  2.353201*y
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  translate  -2.353201*y
}
#declare Bein8 = union {
  sphere { // Po1
    <0,0,0>,1
    scale 2.522659
    translate  <0.0, -2.353201, 18.410334>
    material {
      Overallstoff
      // Transform to world space
      translate  <-2.214777, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Oberschenkel1
    <0,0,0>,1
    scale <2.0, -5.198025, 1.861576>
    translate  <0.0, 1.245812, 17.85664>
    material {
      Overallstoff
      // Transform to world space
      translate  <-2.214777, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Knie2
    <0,0,0>,1
    scale 1.830541
    translate  <0.0, 5.121672, 17.718216>
    material {
      Overallstoff
      // Transform to world space
      translate  <-2.214777, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Unterschenkel1
    <0,0,0>,1
    scale <1.692118, 1.968965, 5.567977>
    translate  <0.0, 5.121672, 13.427086>
    material {
      Overallstoff
      // Transform to world space
      translate  <-2.214777, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Fusselenk1
    <0,0,0>,1
    scale 1.2
    translate  <0.0, 5.121672, 8.16699>
    material {
      DullMBlack
      // Transform to world space
      translate  <-2.214777, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Schuh2
    <0,0,0>,1
    scale <1.1, 3.0, 0.9>
    rotate -6.528854*x
    translate  <0.0, 7.059602, 7.336449>
    material {
      DullMBlack
      // Transform to world space
      translate  <-2.214777, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  translate  <2.214777, 0.0, -0.138424>
}
#declare Bein9 = union {
  sphere { // Po
    <0,0,0>,1
    scale 2.522659
    translate  <0.0, -2.353201, 18.410334>
    material {
      Overallstoff
      // Transform to world space
      translate  <1.93793, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Oberschenkel
    <0,0,0>,1
    scale <2.0, -5.198025, 1.861576>
    translate  <0.0, 1.245812, 17.85664>
    material {
      Overallstoff
      // Transform to world space
      translate  <1.93793, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Knie1
    <0,0,0>,1
    scale 1.830541
    translate  <0.0, 5.121672, 17.718216>
    material {
      Overallstoff
      // Transform to world space
      translate  <1.93793, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Unterschenkel
    <0,0,0>,1
    scale <1.692118, 1.968965, 5.567977>
    translate  <0.0, 5.121672, 13.427086>
    material {
      Overallstoff
      // Transform to world space
      translate  <1.93793, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Fusselenk
    <0,0,0>,1
    scale 1.2
    translate  <0.0, 5.121672, 8.16699>
    material {
      DullMBlack
      // Transform to world space
      translate  <1.93793, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  sphere { // Schuh1
    <0,0,0>,1
    scale <1.1, 3.0, 0.9>
    rotate -6.528854*x
    translate  <0.0, 7.059602, 7.336449>
    material {
      DullMBlack
      // Transform to world space
      translate  <1.93793, 0.0, 0.138424>
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  translate  <-1.93793, 0.0, -0.138424>
}
#declare Pilotenbrille = union {
  cylinder { // Brillenglas1
    <0,0,1>, <0,0,0>, 1 
    scale <0.747674, 0.523372, 0.224302>
    rotate -90.0*x
    translate  <-0.927044, 0.0, 33.492985>
    material {
      ColoredMGlass
      // Transform to world space
      translate  <0.0, -3.016194, -0.116007>
      rotate -4.444673*x
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  cylinder { // Brillenglas2
    <0,0,1>, <0,0,0>, 1 
    scale <0.747674, 0.523372, 0.224302>
    rotate -90.0*x
    translate  <0.929075, 0.0, 33.531654>
    material {
      ColoredMGlass
      // Transform to world space
      translate  <0.0, -3.016194, -0.116007>
      rotate -4.444673*x
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  rotate 4.444673*x
  translate  <0.0, 3.016194, 0.116007>
}
#declare Pilot = union {
  object { Pilotenkopf }
  object { Pilotenarm1 }
  object { Pilotenarm }
  object { Pilotenoberkoeper }
  object { Bein8 }
  object { Bein9 }
  object { Pilotenbrille }
}
#declare Steuerpult = union {
  box { // SteuerpultB
    <-1, -1, -1>, <1, 1, 1>
    scale <4.878931, 1.721662, 2.53353>
    translate  <0.0, 13.891985, 25.167946>
    material {
      DullMGrey
      // Transform to world space
      translate  0.541246*y
      translate  <0.014737, -2.654082, 5.292809>
      rotate 90.0*z rotate -0.0*y rotate -19.171642*x
      scale 1.0/0.3
      translate  <204.44437, 259.990797, -406.186282>
      rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
      scale 1.0/0.7
      translate  <190.305173, 254.226517, -383.33112>
      rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
      scale 1.0/0.8
      translate  <-203.475776, -254.188542, 379.455769>
      rotate -0.0*z rotate -0.0*y rotate -0.0*x
      translate  <-91.352902, -233.471156, 83.427297>
      rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
    }
  }
  box { // SteuerpultA
    <-1, -1, -1>, <1, 1, 1>
    material {
      DullMGrey
    }
    scale <2.533531, 1.902077, 7.043915>
    rotate -12.825583*x
    translate  <0.0, 11.727, 18.312162>
  }
  translate  -0.541246*y
}
#declare Sessel = union {
  cylinder { // SitzTeilA
    <0,0,1>, <0,0,0>, 1 
    material {
      ChairMskin
    }
    scale <-4.5569, 1.553694, 10.412803>
    translate  <1.603854, 0.160385, -0.0>
  }
  cylinder { // SitzTeilB
    <0,0,1>, <0,0,0>, 1 
    scale <1.579312, 6.539334, 8.613297>
    rotate -10.665012*z
    translate  <6.22906, 6.090637, 0.968965>
  }
  cylinder { // SitzTeilC
    <0,0,1>, <0,0,0>, 1 
    scale <1.415271, 2.799506, 5.706401>
    translate  <7.198025, 13.703933, 2.630048>
  }
  sphere { // Sitzlehne1
    <0,0,0>,1
    scale <7.367484, 1.830541, 0.861576>
    rotate 5.458285*z
    translate  <0.0, 1.107389, 0.415271>
  }
  sphere { // Sitzlehne2
    <0,0,0>,1
    scale <7.367484, 1.830541, 0.861576>
    rotate 5.458285*z
    translate  <0.0, 1.107389, 10.10492>
  }
  scale <1.0, 1.0, 1.160385>
  rotate <90.0, 0.0, -90.0>
  translate  <6.069406, 1.488854, 16.147623>
  material {
    ChairMskin
    // Transform to world space
    translate  <0.014737, -2.654082, 5.292809>
    rotate 90.0*z rotate -0.0*y rotate -19.171642*x
    scale 1.0/0.3
    translate  <204.44437, 259.990797, -406.186282>
    rotate -218.921249*z rotate 103.752838*y rotate 159.346298*x
    scale 1.0/0.7
    translate  <190.305173, 254.226517, -383.33112>
    rotate -24.121611*z rotate 0.011585*y rotate 0.117905*x
    scale 1.0/0.8
    translate  <-203.475776, -254.188542, 379.455769>
    rotate -0.0*z rotate -0.0*y rotate -0.0*x
    translate  <-91.352902, -233.471156, 83.427297>
    rotate -17.53793*z rotate -7.350279*y rotate -2.315258*x
  }
}
#declare Pilotengruppe = union {
  object { Pilot }
  object { Steuerpult }
  object { Sessel }
  scale 0.3
  rotate <19.171642, 0.0, -90.0>
  translate  <-0.014737, 2.654082, -5.292809>
}


#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt = union {
  cone { // Cone001
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch001 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 77.084526>
  translate  <-2.991145, 0.529553, 2.682482>
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt5 = union {
  cone { // Cone002
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 77.084526>
  translate  <-2.991145, 0.529553, 2.682482>
}
#declare BezPtch003 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt8 = union {
  cone { // Cone003
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch003 }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 3.761748, 2.590573>
}
#declare BezPtch004 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt11 = union {
  cone { // Cone004
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch004 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 1.280195, 3.05012>
}
#declare BezPtch005 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt14 = union {
  cone { // Cone005
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch005 }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare BezPtch006 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt17 = union {
  cone { // Cone006
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch006 }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-0.898673, 2.35502, 2.682482>
}
#declare BezPtch008 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt23 = union {
  cone { // Cone008
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch008 }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare BezPtch009 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt26 = union {
  cone { // Cone009
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch009 }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <0.385118, 32.014065, 18.410421>
  translate  <-0.898673, 2.35502, 2.682482>
}
#declare BezPtch010 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt29 = union {
  cone { // Cone010
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch010 }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 3.761748, 2.590573>
}
#declare BezPtch011 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt32 = union {
  cone { // Cone011
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch011 }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare BezPtch014 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt41 = union {
  cone { // Cone014
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch014 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 3.761748, 2.590573>
}
#declare BezPtch013 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt38 = union {
  cone { // Cone013
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch013 }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare BezPtch012 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt35 = union {
  cone { // Cone012
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch012 }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-0.898673, 2.35502, 2.682482>
}




//
// ********  OBJECTS  *******
//



#declare sPatchObj15 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.316323, -0.058464, 0.508489>, <0.164796, -0.058464, 0.735456>, <0.199995, -0.051711, 1.077744>, <0.431196, -0.051711, 1.222727>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.902234, -0.049748, 0.567079>, <0.713589, -0.049748, 0.448783>, <0.439959, -0.058464, 0.323300>, <0.316323, -0.058464, 0.508489>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.212851, -0.042017, 1.108256>, <1.345058, -0.042017, 0.910229>, <1.103956, -0.049748, 0.693576>, <0.902234, -0.049748, 0.567079>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.212851, -0.042017, 1.108256>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.047485, -0.042017, 1.355951>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.683513, -0.051711, 1.380951>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.431196, -0.051711, 1.222727>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>, 
      <0.154984, 5.626361, 0.730007>, <0.154984, 5.566828, 0.730007>, <0.155052, 5.486724, 0.720730>, <0.154984, 5.427918, 0.730007>, 
      <0.213551, 5.626361, 1.051520>, <0.213551, 5.566828, 1.051520>, <0.238801, 5.481828, 1.050949>, <0.213551, 5.427918, 1.051520>, 
      <0.444763, 5.626361, 1.196486>, <0.444763, 5.566828, 1.196486>, <0.470013, 5.481828, 1.195915>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>, 
      <0.693530, 5.626361, 0.422904>, <0.693530, 5.566828, 0.422904>, <0.704857, 5.480305, 0.396992>, <0.693530, 5.427918, 0.422904>, 
      <0.430117, 5.626361, 0.317830>, <0.430117, 5.566828, 0.317830>, <0.430185, 5.486724, 0.308554>, <0.430117, 5.427918, 0.317830>, 
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.205451, 5.566828, 1.066661>, <1.234991, 5.473854, 1.042967>, <1.205451, 5.427918, 1.066661>, 
      <1.337643, 5.626361, 0.868624>, <1.337643, 5.566828, 0.868624>, <1.367183, 5.473854, 0.844930>, <1.337643, 5.427918, 0.868624>, 
      <1.083915, 5.626361, 0.667669>, <1.083915, 5.566828, 0.667669>, <1.095242, 5.480305, 0.641757>, <1.083915, 5.427918, 0.667669>, 
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.040103, 5.626361, 1.314368>, <0.697091, 5.626361, 1.354692>, <0.444763, 5.626361, 1.196486>, 
      <1.205451, 5.566828, 1.066661>, <1.040103, 5.566828, 1.314368>, <0.697091, 5.566828, 1.354692>, <0.444763, 5.566828, 1.196486>, 
      <1.234991, 5.473854, 1.042967>, <1.069643, 5.473854, 1.290674>, <0.722341, 5.481828, 1.354121>, <0.470013, 5.481828, 1.195915>, 
      <1.205451, 5.427918, 1.066661>, <1.040103, 5.427918, 1.314368>, <0.697091, 5.427918, 1.354692>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>, 
      <0.346497, 4.594506, 0.671614>, <0.073661, 4.594506, 0.665696>, <-0.053878, 4.594802, 1.057458>, <-0.052002, 4.594802, 1.330351>, 
      <0.306075, 5.069158, 0.559621>, <0.154565, 5.069158, 0.786598>, <0.040898, 5.059296, 1.055421>, <0.272110, 5.059296, 1.200387>, 
      <0.306494, 5.427918, 0.503029>, <0.154984, 5.427918, 0.730007>, <0.213551, 5.427918, 1.051520>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>, 
      <0.781077, 4.594883, 1.125284>, <0.779546, 4.594883, 0.902622>, <0.569112, 4.594506, 0.676443>, <0.346497, 4.594506, 0.671614>, 
      <0.801868, 5.056452, 0.724924>, <0.613214, 5.056452, 0.606641>, <0.429698, 5.069158, 0.374422>, <0.306075, 5.069158, 0.559621>, 
      <0.882184, 5.427918, 0.541187>, <0.693530, 5.427918, 0.422904>, <0.430117, 5.427918, 0.317830>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>, 
      <0.654951, 4.595179, 1.785078>, <0.892999, 4.595179, 1.790242>, <0.782714, 4.594883, 1.363382>, <0.781077, 4.594883, 1.125284>, 
      <0.959541, 5.045514, 1.263906>, <1.091733, 5.045514, 1.065869>, <1.003599, 5.056452, 0.851406>, <0.801868, 5.056452, 0.724924>, 
      <1.205451, 5.427918, 1.066661>, <1.337643, 5.427918, 0.868624>, <1.083915, 5.427918, 0.667669>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.654951, 4.595179, 1.785078>, <0.959541, 5.045514, 1.263906>, <1.205451, 5.427918, 1.066661>, 
      <0.014414, 4.237260, 1.776704>, <0.357198, 4.595179, 1.778620>, <0.794193, 5.045514, 1.511613>, <1.040103, 5.427918, 1.314368>, 
      <-0.203806, 4.237260, 1.509005>, <-0.049954, 4.594802, 1.628167>, <0.524439, 5.059296, 1.358594>, <0.697091, 5.427918, 1.354692>, 
      <-0.205854, 4.237260, 1.211188>, <-0.052002, 4.594802, 1.330351>, <0.272110, 5.059296, 1.200387>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>, 
      <0.105462, 3.463578, 0.850334>, <0.055023, 3.463578, 0.582137>, <-0.340953, 3.483383, 0.584389>, <-0.607601, 3.483383, 0.642467>, 
      <0.265438, 3.898818, 0.770024>, <-0.007397, 3.898818, 0.764106>, <-0.366443, 3.868423, 0.815368>, <-0.364567, 3.868423, 1.088261>, 
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>, 
      <-0.204841, 3.488257, 1.374467>, <0.012726, 3.488257, 1.327079>, <0.146616, 3.463578, 1.069166>, <0.105462, 3.463578, 0.850334>, 
      <0.371952, 3.860518, 1.336769>, <0.370421, 3.860518, 1.114107>, <0.488054, 3.898818, 0.774853>, <0.265438, 3.898818, 0.770024>, 
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>, 
      <-0.849194, 3.504386, 1.439758>, <-0.805187, 3.504386, 1.673760>, <-0.437490, 3.488257, 1.425140>, <-0.204841, 3.488257, 1.374467>, 
      <-0.075015, 3.832981, 1.780999>, <0.163032, 3.832981, 1.786163>, <0.373589, 3.860518, 1.574868>, <0.371952, 3.860518, 1.336769>, 
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.849194, 3.504386, 1.439758>, <-0.075015, 3.832981, 1.780999>, <0.312168, 4.237260, 1.783163>, 
      <-1.053398, 3.126806, 0.761653>, <-0.904239, 3.504386, 1.147066>, <-0.372769, 3.832981, 1.774541>, <0.014414, 4.237260, 1.776704>, 
      <-0.836419, 3.126806, 0.492946>, <-0.898602, 3.483383, 0.705849>, <-0.362519, 3.868423, 1.386078>, <-0.203806, 4.237260, 1.509005>, 
      <-0.545418, 3.126806, 0.429564>, <-0.607601, 3.483383, 0.642467>, <-0.364567, 3.868423, 1.088261>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>, 
      <-0.128147, 2.415676, 0.651832>, <0.126414, 2.415676, 0.553481>, <0.053531, 2.440944, 0.169666>, <-0.052050, 2.440944, -0.081982>, 
      <-0.023820, 2.814543, 0.808328>, <-0.074258, 2.814543, 0.540130>, <-0.219259, 2.785552, 0.167732>, <-0.485907, 2.785552, 0.225810>, 
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>, 
      <-0.697247, 2.446923, 0.443910>, <-0.611100, 2.446923, 0.649238>, <-0.335852, 2.415676, 0.732080>, <-0.128147, 2.415676, 0.651832>, 
      <-0.587640, 2.778548, 1.039500>, <-0.370073, 2.778548, 0.992112>, <0.017335, 2.814543, 1.027160>, <-0.023820, 2.814543, 0.808328>, 
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>, 
      <-0.880560, 2.466101, -0.172718>, <-1.102663, 2.466101, -0.086907>, <-0.789365, 2.446923, 0.224348>, <-0.697247, 2.446923, 0.443910>, 
      <-1.144960, 2.755688, 0.675529>, <-1.100952, 2.755688, 0.909531>, <-0.820290, 2.778548, 1.090173>, <-0.587640, 2.778548, 1.039500>, 
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.880560, 2.466101, -0.172718>, <-1.144960, 2.755688, 0.675529>, <-0.998353, 3.126806, 1.054346>, 
      <-0.252738, 2.104019, -0.501665>, <-0.602749, 2.466101, -0.280051>, <-1.200004, 2.755688, 0.382836>, <-1.053398, 3.126806, 0.761653>, 
      <0.050935, 2.104019, -0.337146>, <-0.167273, 2.440944, -0.356614>, <-0.776909, 2.785552, 0.289192>, <-0.836419, 3.126806, 0.492946>, 
      <0.166158, 2.104019, -0.062515>, <-0.052050, 2.440944, -0.081982>, <-0.485907, 2.785552, 0.225810>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.234524, 1.081232, 0.616299>, <0.551125, 1.081232, 0.697322>, <0.779388, 1.081232, 0.547756>, 
      <0.028194, 1.393687, 0.395892>, <0.171180, 1.393687, 0.628333>, <0.505759, 1.423886, 0.492281>, <0.734022, 1.423886, 0.342715>, 
      <-0.111949, 1.792362, 0.516332>, <0.142612, 1.792362, 0.417981>, <0.489946, 1.767094, 0.208601>, <0.384366, 1.767094, -0.043048>, 
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>, 
      <0.234524, 1.081232, 0.616299>, <0.300570, 0.755451, 0.603751>, <0.100099, 0.326674, 0.699584>, <0.154975, 0.000000, 0.730010>, 
      <0.551125, 1.081232, 0.697322>, <0.595304, 0.747538, 0.897002>, <0.302425, 0.339953, 0.879182>, <0.213519, 0.000000, 1.051528>, 
      <0.779388, 1.081232, 0.547756>, <0.823568, 0.747538, 0.747436>, <0.533627, 0.339953, 1.024166>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.180330, 1.081232, -0.001283>, <-0.025129, 1.081232, 0.194200>, <0.091538, 1.081232, 0.383857>, 
      <0.125214, 1.431229, -0.176519>, <-0.061034, 1.431229, -0.054483>, <-0.088473, 1.393687, 0.206234>, <0.028194, 1.393687, 0.395892>, 
      <-0.440308, 1.761115, -0.001050>, <-0.354161, 1.761115, 0.204279>, <-0.319654, 1.792362, 0.596580>, <-0.111949, 1.792362, 0.516332>, 
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>, 
      <0.180330, 1.081232, -0.001283>, <0.411833, 0.745534, 0.049744>, <0.555172, 0.343419, 0.244602>, <0.693544, 0.000000, 0.422947>, 
      <-0.025129, 1.081232, 0.194200>, <0.040917, 0.755451, 0.181652>, <0.375262, 0.326674, 0.287429>, <0.430138, 0.000000, 0.317854>, 
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.854275, 1.081232, -0.400463>, <0.565737, 1.081232, -0.253815>, <0.366578, 1.081232, -0.123319>, 
      <0.670363, 1.455342, -0.457448>, <0.545608, 1.455342, -0.660252>, <0.324373, 1.431229, -0.307015>, <0.125214, 1.431229, -0.176519>, 
      <-0.180537, 1.741937, -0.615946>, <-0.402640, 1.741937, -0.530136>, <-0.532426, 1.761115, -0.220612>, <-0.440308, 1.761115, -0.001050>, 
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.261608, 0.738743, 0.040172>, <1.142527, 0.355497, 0.715488>, <1.205418, 0.000000, 1.066741>, 
      <0.854275, 1.081232, -0.400463>, <1.136853, 0.738743, -0.162632>, <1.274733, 0.355497, 0.517461>, <1.337625, 0.000000, 0.868714>, 
      <0.565737, 1.081232, -0.253815>, <0.797239, 0.745534, -0.202788>, <0.945539, 0.343419, 0.489396>, <1.083911, 0.000000, 0.667741>, 
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.670363, 1.455342, -0.457448>, <-0.180537, 1.741937, -0.615946>, <-0.530548, 2.104019, -0.394332>, 
      <1.135075, 1.081232, 0.056011>, <0.826408, 1.455342, -0.203778>, <0.097274, 1.741937, -0.723279>, <-0.252738, 2.104019, -0.501665>, 
      <1.028498, 1.081232, 0.384530>, <0.983133, 1.423886, 0.179489>, <0.269142, 1.767094, -0.317679>, <0.050935, 2.104019, -0.337146>, 
      <0.779388, 1.081232, 0.547756>, <0.734022, 1.423886, 0.342715>, <0.384366, 1.767094, -0.043048>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.135075, 1.081232, 0.056011>, <1.028498, 1.081232, 0.384530>, <0.779388, 1.081232, 0.547756>, 
      <1.261608, 0.738743, 0.040172>, <1.417652, 0.738743, 0.293842>, <1.072678, 0.747538, 0.584210>, <0.823568, 0.747538, 0.747436>, 
      <1.142527, 0.355497, 0.715488>, <0.977161, 0.355497, 0.963183>, <0.785944, 0.339953, 1.182390>, <0.533627, 0.339953, 1.024166>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.171607, -0.058008, 0.567566>, <-0.429647, -0.058008, 0.478746>, <-0.748211, -0.046475, 0.605113>, <-0.829626, -0.046475, 0.865585>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.080693, -0.053847, 1.152972>, <-0.014263, -0.053847, 0.940444>, <0.038937, -0.058008, 0.640038>, <-0.171607, -0.058008, 0.567566>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.523592, -0.042839, 1.593553>, <-0.298453, -0.042839, 1.671048>, <-0.151727, -0.053847, 1.380233>, <-0.080693, -0.053847, 1.152972>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.523592, -0.042839, 1.593553>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.805199, -0.042839, 1.496620>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.918477, -0.046475, 1.149846>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.829626, -0.046475, 0.865585>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>, 
      <-0.423778, 5.626361, 0.490812>, <-0.423778, 5.566828, 0.490812>, <-0.430195, 5.486410, 0.499852>, <-0.423778, 5.427918, 0.490812>, 
      <-0.719823, 5.626361, 0.629223>, <-0.719823, 5.566828, 0.629223>, <-0.726450, 5.477662, 0.661250>, <-0.719823, 5.427918, 0.629223>, 
      <-0.801219, 5.626361, 0.889701>, <-0.801219, 5.566828, 0.889701>, <-0.807845, 5.477662, 0.921728>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>, 
      <0.010193, 5.626361, 0.933545>, <0.010193, 5.566828, 0.933545>, <0.025226, 5.483433, 0.948915>, <0.010193, 5.427918, 0.933545>, 
      <0.044818, 5.626361, 0.652071>, <0.044818, 5.566828, 0.652071>, <0.038401, 5.486410, 0.661111>, <0.044818, 5.427918, 0.652071>, 
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.482199, 5.566828, 1.592358>, <-0.463544, 5.474575, 1.624284>, <-0.482199, 5.427918, 1.592358>, 
      <-0.257054, 5.626361, 1.669837>, <-0.257054, 5.566828, 1.669837>, <-0.238399, 5.474575, 1.701764>, <-0.257054, 5.427918, 1.669837>, 
      <-0.127237, 5.626361, 1.373344>, <-0.127237, 5.566828, 1.373344>, <-0.112205, 5.483433, 1.388713>, <-0.127237, 5.427918, 1.373344>, 
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.763814, 5.626361, 1.495446>, <-0.890049, 5.626361, 1.173969>, <-0.801219, 5.626361, 0.889701>, 
      <-0.482199, 5.566828, 1.592358>, <-0.763814, 5.566828, 1.495446>, <-0.890049, 5.566828, 1.173969>, <-0.801219, 5.566828, 0.889701>, 
      <-0.463544, 5.474575, 1.624284>, <-0.745159, 5.474575, 1.527372>, <-0.896675, 5.477662, 1.205995>, <-0.807845, 5.477662, 0.921728>, 
      <-0.482199, 5.427918, 1.592358>, <-0.763814, 5.427918, 1.495446>, <-0.890049, 5.427918, 1.173969>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>, 
      <-0.089107, 4.594527, 0.386047>, <-0.152773, 4.594527, 0.120678>, <-0.564322, 4.595013, 0.097065>, <-0.827765, 4.595013, 0.168284>, 
      <-0.126297, 5.068491, 0.524063>, <-0.384344, 5.068491, 0.435261>, <-0.669715, 5.051760, 0.387044>, <-0.751111, 5.051760, 0.647522>, 
      <-0.165731, 5.427918, 0.579614>, <-0.423778, 5.427918, 0.490812>, <-0.719823, 5.427918, 0.629223>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>, 
      <-0.417480, 4.594711, 0.921634>, <-0.202528, 4.594711, 0.863524>, <-0.037160, 4.594527, 0.602571>, <-0.089107, 4.594527, 0.386047>, 
      <-0.155195, 5.062406, 1.044886>, <-0.088782, 5.062406, 0.832353>, <0.084253, 5.068491, 0.596519>, <-0.126297, 5.068491, 0.524063>, 
      <-0.056220, 5.427918, 1.146078>, <0.010193, 5.427918, 0.933545>, <0.044818, 5.427918, 0.652071>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>, 
      <-1.087756, 4.595149, 0.967504>, <-1.032208, 4.595149, 1.199037>, <-0.647332, 4.594711, 0.983772>, <-0.417480, 4.594711, 0.921634>, 
      <-0.634640, 5.046650, 1.331464>, <-0.409495, 5.046650, 1.408943>, <-0.226213, 5.062406, 1.272152>, <-0.155195, 5.062406, 1.044886>, 
      <-0.482199, 5.427918, 1.592358>, <-0.257054, 5.427918, 1.669837>, <-0.127237, 5.427918, 1.373344>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-1.087756, 4.595149, 0.967504>, <-0.634640, 5.046650, 1.331464>, <-0.482199, 5.427918, 1.592358>, 
      <-1.107078, 4.237260, 0.352218>, <-1.157237, 4.595149, 0.677899>, <-0.916254, 5.046650, 1.234552>, <-0.763814, 5.427918, 1.495446>, 
      <-0.903679, 4.237260, 0.073090>, <-1.115267, 4.595013, 0.246007>, <-0.839940, 5.051760, 0.931790>, <-0.890049, 5.427918, 1.173969>, 
      <-0.616177, 4.237260, -0.004633>, <-0.827765, 4.595013, 0.168284>, <-0.751111, 5.051760, 0.647522>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>, 
      <0.271064, 3.465083, 0.375612>, <0.517615, 3.465083, 0.258622>, <0.402853, 3.495644, -0.136809>, <0.278870, 3.495644, -0.379918>, 
      <0.058931, 3.896598, 0.344779>, <-0.004735, 3.896598, 0.079410>, <-0.122620, 3.848180, -0.263910>, <-0.386062, 3.848180, -0.192692>, 
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>, 
      <-0.313106, 3.477658, 0.196542>, <-0.211944, 3.477658, 0.394904>, <0.069895, 3.465083, 0.471068>, <0.271064, 3.465083, 0.375612>, 
      <-0.447355, 3.877483, 0.600333>, <-0.232404, 3.877483, 0.542223>, <0.110878, 3.896598, 0.561302>, <0.058931, 3.896598, 0.344779>, 
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>, 
      <-0.545698, 3.502879, -0.414521>, <-0.760812, 3.502879, -0.312448>, <-0.421281, 3.477658, -0.015569>, <-0.313106, 3.477658, 0.196542>, 
      <-0.981310, 3.835650, 0.276356>, <-0.925762, 3.835650, 0.507889>, <-0.677208, 3.877483, 0.662471>, <-0.447355, 3.877483, 0.600333>, 
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.545698, 3.502879, -0.414521>, <-0.981310, 3.835650, 0.276356>, <-1.037597, 4.237260, 0.641823>, 
      <0.109377, 3.126806, -0.629339>, <-0.276629, 3.502879, -0.542196>, <-1.050791, 3.835650, -0.013249>, <-1.107078, 4.237260, 0.352218>, 
      <0.424431, 3.126806, -0.487834>, <0.143563, 3.495644, -0.645230>, <-0.673564, 3.848180, -0.114968>, <-0.903679, 4.237260, 0.073090>, 
      <0.559738, 3.126806, -0.222522>, <0.278870, 3.495644, -0.379918>, <-0.386062, 3.848180, -0.192692>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>, 
      <0.365100, 2.417655, 0.731806>, <0.524959, 2.417655, 0.952983>, <0.891390, 2.455820, 0.766646>, <1.107911, 2.455820, 0.600536>, 
      <0.370049, 2.812306, 0.506711>, <0.616600, 2.812306, 0.389721>, <0.956934, 2.768021, 0.173693>, <0.832951, 2.768021, -0.069416>, 
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>, 
      <0.437691, 2.433805, 0.127413>, <0.261024, 2.433805, 0.262947>, <0.234666, 2.417655, 0.551341>, <0.365100, 2.417655, 0.731806>, 
      <0.000755, 2.793839, 0.038072>, <0.101918, 2.793839, 0.236433>, <0.168879, 2.812306, 0.602167>, <0.370049, 2.812306, 0.506711>, 
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>, 
      <0.991383, 2.464347, -0.214834>, <0.851907, 2.464347, -0.407810>, <0.626605, 2.433805, -0.017518>, <0.437691, 2.433805, 0.127413>, 
      <0.219055, 2.757805, -0.587170>, <0.003941, 2.757805, -0.485097>, <-0.107420, 2.793839, -0.174039>, <0.000755, 2.793839, 0.038072>, 
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <0.991383, 2.464347, -0.214834>, <0.219055, 2.757805, -0.587170>, <-0.159692, 3.126806, -0.501665>, 
      <1.326447, 2.104019, 0.388885>, <1.165841, 2.464347, 0.026543>, <0.488124, 2.757805, -0.714844>, <0.109377, 3.126806, -0.629339>, 
      <1.244570, 2.104019, 0.724413>, <1.344208, 2.455820, 0.419255>, <0.697644, 2.768021, -0.334728>, <0.424431, 3.126806, -0.487834>, 
      <1.008274, 2.104019, 0.905694>, <1.107911, 2.455820, 0.600536>, <0.832951, 2.768021, -0.069416>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.224474, 1.081232, 1.042327>, <-0.222313, 1.081232, 1.369123>, <-0.019611, 1.081232, 1.551842>, 
      <0.035153, 1.396006, 0.876905>, <-0.153280, 1.396006, 1.074305>, <0.088221, 1.442306, 1.371879>, <0.290923, 1.442306, 1.554598>, 
      <0.255198, 1.790383, 0.854888>, <0.415056, 1.790383, 1.076065>, <0.692115, 1.752218, 1.376962>, <0.908636, 1.752218, 1.210852>, 
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>, 
      <-0.224474, 1.081232, 1.042327>, <-0.298291, 0.754862, 1.009170>, <-0.390564, 0.327640, 0.558707>, <-0.423769, 0.000000, 0.490773>, 
      <-0.222313, 1.081232, 1.369123>, <-0.513671, 0.742454, 1.366537>, <-0.506757, 0.348832, 0.809677>, <-0.719824, 0.000000, 0.629163>, 
      <-0.019611, 1.081232, 1.551842>, <-0.310969, 0.742454, 1.549256>, <-0.588171, 0.348832, 1.070149>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.359017, 1.081232, 0.832847>, <0.117708, 1.081232, 0.683860>, <-0.036041, 1.081232, 0.844926>, 
      <0.620129, 1.415221, 0.842415>, <0.454738, 1.415221, 0.693328>, <0.188902, 1.396006, 0.715839>, <0.035153, 1.396006, 0.876905>, 
      <0.655813, 1.774233, 0.406870>, <0.479146, 1.774233, 0.542404>, <0.124764, 1.790383, 0.674422>, <0.255198, 1.790383, 0.854888>, 
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>, 
      <0.359017, 1.081232, 0.832847>, <0.264047, 0.749863, 0.971272>, <0.162627, 0.335985, 0.890444>, <0.010170, 0.000000, 0.933538>, 
      <0.117708, 1.081232, 0.683860>, <0.043891, 0.754862, 0.650703>, <0.078020, 0.327640, 0.720000>, <0.044816, 0.000000, 0.652066>, 
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.916474, 1.081232, 1.383110>, <0.701264, 1.081232, 1.141355>, <0.524408, 1.081232, 0.981934>, 
      <1.040909, 1.453099, 1.299984>, <1.205316, 1.453099, 1.127752>, <0.796985, 1.415221, 1.001836>, <0.620129, 1.415221, 0.842415>, 
      <1.312595, 1.743691, 0.509850>, <1.173120, 1.743691, 0.316874>, <0.844727, 1.774233, 0.261939>, <0.655813, 1.774233, 0.406870>, 
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.486546, 0.739388, 1.790082>, <-0.140497, 0.354327, 1.582077>, <-0.482271, 0.000000, 1.592315>, 
      <0.916474, 1.081232, 1.383110>, <0.650953, 0.739388, 1.617850>, <0.084642, 0.354327, 1.659573>, <-0.257132, 0.000000, 1.669811>, 
      <0.701264, 1.081232, 1.141355>, <0.606294, 0.749863, 1.279780>, <0.025164, 0.335985, 1.330233>, <-0.127293, 0.000000, 1.373327>, 
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <1.040909, 1.453099, 1.299984>, <1.312595, 1.743691, 0.509850>, <1.151989, 2.104019, 0.147508>, 
      <0.546424, 1.081232, 1.770770>, <0.835266, 1.453099, 1.515412>, <1.487054, 1.743691, 0.751227>, <1.326447, 2.104019, 0.388885>, 
      <0.201603, 1.081232, 1.751248>, <0.512137, 1.442306, 1.754004>, <1.144933, 1.752218, 1.029571>, <1.244570, 2.104019, 0.724413>, 
      <-0.019611, 1.081232, 1.551842>, <0.290923, 1.442306, 1.554598>, <0.908636, 1.752218, 1.210852>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.546424, 1.081232, 1.770770>, <0.201603, 1.081232, 1.751248>, <-0.019611, 1.081232, 1.551842>, 
      <0.486546, 0.739388, 1.790082>, <0.280903, 0.739388, 2.005510>, <-0.089755, 0.742454, 1.748662>, <-0.310969, 0.742454, 1.549256>, 
      <-0.140497, 0.354327, 1.582077>, <-0.422104, 0.354327, 1.485145>, <-0.677022, 0.348832, 1.354410>, <-0.588171, 0.348832, 1.070149>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.531123, -0.050749, 0.000078>, <0.531123, -0.050749, -0.272821>, <0.304895, -0.043346, -0.532983>, <0.032107, -0.043346, -0.525189>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.010372, -0.057224, 0.275149>, <0.232949, -0.057224, 0.268790>, <0.531123, -0.050749, 0.222746>, <0.531123, -0.050749, 0.000078>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.555407, -0.047723, -0.004906>, <-0.555407, -0.047723, 0.233197>, <-0.227635, -0.057224, 0.281949>, <0.010372, -0.057224, 0.275149>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.555407, -0.047723, -0.004906>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.555407, -0.047723, -0.302730>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.265595, -0.043346, -0.516683>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.032107, -0.043346, -0.525189>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>, 
      <0.499935, 5.626361, -0.272928>, <0.499935, 5.566828, -0.272928>, <0.487182, 5.481088, -0.296477>, <0.499935, 5.427918, -0.272928>, 
      <0.272705, 5.626361, -0.507806>, <0.272705, 5.566828, -0.507806>, <0.239261, 5.475015, -0.522211>, <0.272705, 5.427918, -0.507806>, 
      <-0.000082, 5.626361, -0.499992>, <-0.000082, 5.566828, -0.499992>, <-0.033527, 5.475015, -0.514397>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>, 
      <0.222553, 5.626361, 0.281511>, <0.222553, 5.566828, 0.281511>, <0.209130, 5.485864, 0.279002>, <0.222553, 5.427918, 0.281511>, 
      <0.499971, 5.626361, 0.222639>, <0.499971, 5.566828, 0.222639>, <0.487219, 5.481088, 0.199091>, <0.499971, 5.427918, 0.222639>, 
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560649, 5.566828, 0.030352>, <-0.589835, 5.478685, 0.041080>, <-0.560649, 5.427918, 0.030352>, 
      <-0.560631, 5.626361, 0.268456>, <-0.560631, 5.566828, 0.268456>, <-0.589817, 5.478685, 0.279183>, <-0.560631, 5.427918, 0.268456>, 
      <-0.238030, 5.626361, 0.294705>, <-0.238030, 5.566828, 0.294705>, <-0.251453, 5.485864, 0.292195>, <-0.238030, 5.427918, 0.294705>, 
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560671, 5.626361, -0.267471>, <-0.297783, 5.626361, -0.491464>, <-0.000082, 5.626361, -0.499992>, 
      <-0.560649, 5.566828, 0.030352>, <-0.560671, 5.566828, -0.267471>, <-0.297783, 5.566828, -0.491464>, <-0.000082, 5.566828, -0.499992>, 
      <-0.589835, 5.478685, 0.041080>, <-0.589857, 5.478685, -0.256743>, <-0.331228, 5.475015, -0.505870>, <-0.033527, 5.475015, -0.514397>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560671, 5.427918, -0.267471>, <-0.297783, 5.427918, -0.491464>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>, 
      <0.871674, 4.594842, 0.409537>, <1.101873, 4.594842, 0.262968>, <0.990284, 4.595130, -0.133963>, <0.837200, 4.595130, -0.359882>, 
      <0.588703, 5.057900, 0.163849>, <0.588683, 5.057900, -0.109050>, <0.542953, 5.047354, -0.391404>, <0.270166, 5.047354, -0.383590>, 
      <0.499955, 5.427918, -0.000029>, <0.499935, 5.427918, -0.272928>, <0.272705, 5.427918, -0.507806>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>, 
      <0.258408, 4.594562, 0.273502>, <0.383314, 4.594562, 0.457837>, <0.683847, 4.594842, 0.529128>, <0.871674, 4.594842, 0.409537>, 
      <0.083501, 5.067343, 0.303502>, <0.306078, 5.067343, 0.297127>, <0.588720, 5.057900, 0.386517>, <0.588703, 5.057900, 0.163849>, 
      <-0.000024, 5.427918, 0.287887>, <0.222553, 5.427918, 0.281511>, <0.499971, 5.427918, 0.222639>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>, 
      <-0.002919, 4.594964, -0.345512>, <-0.203767, 4.594964, -0.217631>, <0.124843, 4.594562, 0.076388>, <0.258408, 4.594562, 0.273502>, 
      <-0.345421, 5.053539, -0.048759>, <-0.345404, 5.053539, 0.189344>, <-0.154505, 5.067343, 0.310320>, <0.083501, 5.067343, 0.303502>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560631, 5.427918, 0.268456>, <-0.238030, 5.427918, 0.294705>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <-0.002919, 4.594964, -0.345512>, <-0.345421, 5.053539, -0.048759>, <-0.560649, 5.427918, 0.030352>, 
      <0.489158, 4.237260, -0.423140>, <0.248304, 4.594964, -0.505468>, <-0.345443, 5.053539, -0.346583>, <-0.560671, 5.427918, -0.267471>, 
      <0.819288, 4.237260, -0.321664>, <0.670135, 4.595130, -0.606434>, <-0.027535, 5.047354, -0.375063>, <-0.297783, 5.427918, -0.491464>, 
      <0.986353, 4.237260, -0.075112>, <0.837200, 4.595130, -0.359882>, <0.270166, 5.047354, -0.383590>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>, 
      <0.487685, 3.485815, 1.278173>, <0.678550, 3.485815, 1.473223>, <1.021481, 3.501927, 1.236272>, <1.211001, 3.501927, 1.039914>, 
      <0.792948, 3.864501, 0.829580>, <1.023146, 3.864501, 0.683010>, <1.306122, 3.837324, 0.469049>, <1.153038, 3.837324, 0.243131>, 
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>, 
      <0.458265, 3.467610, 0.673952>, <0.303630, 3.467610, 0.834167>, <0.331951, 3.485815, 1.119025>, <0.487685, 3.485815, 1.278173>, 
      <0.382814, 3.892839, 0.419899>, <0.507721, 3.892839, 0.604234>, <0.605121, 3.864501, 0.949171>, <0.792948, 3.864501, 0.829580>, 
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>, 
      <0.975227, 3.492933, 0.262535>, <0.808698, 3.492933, 0.092354>, <0.623620, 3.467610, 0.502630>, <0.458265, 3.467610, 0.673952>, 
      <0.496831, 3.852760, -0.174689>, <0.295984, 3.852760, -0.046808>, <0.249249, 3.892839, 0.222786>, <0.382814, 3.892839, 0.419899>, 
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.975227, 3.492933, 0.262535>, <0.496831, 3.852760, -0.174689>, <0.237935, 4.237260, -0.263184>, 
      <1.197061, 3.126806, 0.772832>, <1.183524, 3.492933, 0.475399>, <0.748054, 3.852760, -0.334644>, <0.489158, 4.237260, -0.423140>, 
      <1.165802, 3.126806, 1.116788>, <1.417829, 3.501927, 0.825623>, <0.985973, 3.837324, -0.003422>, <0.819288, 4.237260, -0.321664>, 
      <0.958974, 3.126806, 1.331080>, <1.211001, 3.501927, 1.039914>, <1.153038, 3.837324, 0.243131>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>, 
      <-0.478676, 2.443939, 1.104255>, <-0.635781, 2.443939, 1.327397>, <-0.339553, 2.463236, 1.620984>, <-0.112016, 2.463236, 1.771652>, 
      <0.025493, 2.782051, 1.366857>, <0.216358, 2.782051, 1.561907>, <0.522439, 2.759143, 1.812815>, <0.711959, 2.759143, 1.616456>, 
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>, 
      <0.105840, 2.420954, 0.966742>, <-0.079815, 2.420954, 0.843806>, <-0.350489, 2.443939, 0.922187>, <-0.478676, 2.443939, 1.104255>, 
      <0.360933, 2.808564, 0.855739>, <0.206297, 2.808564, 1.015955>, <-0.130241, 2.782051, 1.207709>, <0.025493, 2.782051, 1.366857>, 
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>, 
      <0.604571, 2.452578, 1.399187>, <0.741644, 2.452578, 1.204498>, <0.304365, 2.420954, 1.098199>, <0.105840, 2.420954, 0.966742>, 
      <1.001887, 2.771873, 0.848307>, <0.835358, 2.771873, 0.678127>, <0.526288, 2.808564, 0.684418>, <0.360933, 2.808564, 0.855739>, 
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.604571, 2.452578, 1.399187>, <1.001887, 2.771873, 0.848307>, <0.988764, 3.126806, 0.559968>, 
      <0.145354, 2.104019, 1.713333>, <0.433118, 2.452578, 1.642708>, <1.210184, 2.771873, 1.061171>, <1.197061, 3.126806, 0.772832>, 
      <-0.198554, 2.104019, 1.745119>, <0.136302, 2.463236, 1.936081>, <0.918787, 2.759143, 1.402165>, <1.165802, 3.126806, 1.116788>, 
      <-0.446872, 2.104019, 1.580690>, <-0.112016, 2.463236, 1.771652>, <0.711959, 2.759143, 1.616456>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.532779, 1.081232, -0.115902>, <-0.841079, 1.081232, -0.007496>, <-0.947876, 1.081232, 0.243639>, 
      <-0.460568, 1.427554, 0.143533>, <-0.708550, 1.427554, 0.029607>, <-0.919759, 1.451683, 0.358848>, <-1.026556, 1.451683, 0.609983>, 
      <-0.657048, 1.764099, 0.663767>, <-0.814153, 1.764099, 0.886908>, <-1.009265, 1.744802, 1.239059>, <-0.781728, 1.744802, 1.389728>, 
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>, 
      <-0.532779, 1.081232, -0.115902>, <-0.362912, 0.746541, -0.256523>, <0.290460, 0.341673, -0.273427>, <0.500000, 0.000000, -0.272899>, 
      <-0.841079, 1.081232, -0.007496>, <-0.768561, 0.739794, -0.345148>, <0.010876, 0.353593, -0.302315>, <0.272788, 0.000000, -0.507794>, 
      <-0.947876, 1.081232, 0.243639>, <-0.875358, 0.739794, -0.094013>, <-0.261912, 0.353593, -0.294521>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.144796, 1.081232, 0.367641>, <-0.082460, 1.081232, 0.090980>, <-0.284797, 1.081232, -0.001976>, 
      <-0.230920, 1.399890, 0.670780>, <-0.143781, 1.399890, 0.465871>, <-0.258231, 1.427554, 0.236488>, <-0.460568, 1.427554, 0.143533>, 
      <-0.092438, 1.787084, 0.906190>, <-0.278093, 1.787084, 0.783255>, <-0.528861, 1.764099, 0.481698>, <-0.657048, 1.764099, 0.663767>, 
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>, 
      <-0.144796, 1.081232, 0.367641>, <-0.145838, 0.753870, 0.266728>, <0.162897, 0.329277, 0.354769>, <0.222577, 0.000000, 0.281520>, 
      <-0.082460, 1.081232, 0.090980>, <0.087407, 0.746541, -0.049642>, <0.290460, 0.341673, 0.222140>, <0.500000, 0.000000, 0.222668>, 
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.483662, 1.081232, 1.073839>, <-0.325115, 1.081232, 0.791664>, <-0.231935, 1.081232, 0.572550>, 
      <-0.551143, 1.438248, 1.218700>, <-0.334780, 1.438248, 1.318099>, <-0.324100, 1.399890, 0.889893>, <-0.230920, 1.399890, 0.670780>, 
      <0.029043, 1.755460, 1.540437>, <0.166117, 1.755460, 1.345747>, <0.106087, 1.787084, 1.037648>, <-0.092438, 1.787084, 0.906190>, 
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.840828, 0.743590, 0.743435>, <-0.598392, 0.346823, 0.286187>, <-0.560606, 0.000000, 0.030303>, 
      <-0.483662, 1.081232, 1.073839>, <-0.624465, 0.743590, 0.842835>, <-0.598392, 0.346823, 0.524291>, <-0.560606, 0.000000, 0.268407>, 
      <-0.325115, 1.081232, 0.791664>, <-0.326157, 0.753870, 0.690751>, <-0.297686, 0.329277, 0.367929>, <-0.238007, 0.000000, 0.294679>, 
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.551143, 1.438248, 1.218700>, <0.029043, 1.755460, 1.540437>, <0.316807, 2.104019, 1.469812>, 
      <-0.970655, 1.081232, 0.850110>, <-0.821773, 1.438248, 1.094370>, <-0.142410, 1.755460, 1.783957>, <0.145354, 2.104019, 1.713333>, 
      <-1.064426, 1.081232, 0.517710>, <-1.143107, 1.451683, 0.884053>, <-0.533411, 1.744802, 1.554156>, <-0.198554, 2.104019, 1.745119>, 
      <-0.947876, 1.081232, 0.243639>, <-1.026556, 1.451683, 0.609983>, <-0.781728, 1.744802, 1.389728>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.970655, 1.081232, 0.850110>, <-1.064426, 1.081232, 0.517710>, <-0.947876, 1.081232, 0.243639>, 
      <-0.840828, 0.743590, 0.743435>, <-1.111458, 0.743590, 0.619105>, <-0.991908, 0.739794, 0.180057>, <-0.875358, 0.739794, -0.094013>, 
      <-0.598392, 0.346823, 0.286187>, <-0.598392, 0.346823, -0.011636>, <-0.559614, 0.353593, -0.286016>, <-0.261912, 0.353593, -0.294521>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
}
#declare segMstraightMA2 = union {
  object { // Blatt42->Blatt44
    Blatt44
    scale 0.7
    rotate <-12.441627, -17.528614, 48.362408>
    translate  <0.637602, -0.596402, -0.200384>
  }
  object { // Blatt43->Blatt44
    Blatt44
    rotate <-12.856555, -9.676538, -167.951874>
    translate  <-0.577361, -0.624717, -0.248322>
  }
  object { sPatchObj15 }
  object { Blatt44 }
  translate  <-0.2, 0.7, 62.2>
}
#declare sPatchObj16 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.314306, -0.058772, 0.508445>, <0.162778, -0.058772, 0.735411>, <0.199510, -0.053679, 1.073126>, <0.430711, -0.053679, 1.218109>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.897501, -0.052107, 0.565628>, <0.708856, -0.052107, 0.447332>, <0.437942, -0.058772, 0.323255>, <0.314306, -0.058772, 0.508445>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.208411, -0.045498, 1.105018>, <1.340617, -0.045498, 0.906991>, <1.099223, -0.052107, 0.692125>, <0.897501, -0.052107, 0.565628>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.208411, -0.045498, 1.105018>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.043045, -0.045498, 1.352713>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.683029, -0.053679, 1.376333>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.430711, -0.053679, 1.218109>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, 5.626361, 0.503044>, <0.306502, 5.566828, 0.503044>, <0.313705, 5.486803, 0.508029>, <0.306502, 5.427918, 0.503044>, 
      <0.154975, 5.626361, 0.730010>, <0.154975, 5.566828, 0.730010>, <0.162178, 5.486803, 0.734995>, <0.154975, 5.427918, 0.730010>, 
      <0.213519, 5.626361, 1.051528>, <0.213519, 5.566828, 1.051528>, <0.200427, 5.482373, 1.071712>, <0.213519, 5.427918, 1.051528>, 
      <0.444720, 5.626361, 1.196511>, <0.444720, 5.566828, 1.196511>, <0.431628, 5.482373, 1.216695>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, 5.626361, 0.541244>, <0.882189, 5.566828, 0.541244>, <0.896551, 5.480972, 0.564116>, <0.882189, 5.427918, 0.541244>, 
      <0.693544, 5.626361, 0.422947>, <0.693544, 5.566828, 0.422947>, <0.707906, 5.480972, 0.445820>, <0.693544, 5.427918, 0.422947>, 
      <0.430138, 5.626361, 0.317854>, <0.430138, 5.566828, 0.317854>, <0.437341, 5.486803, 0.322839>, <0.430138, 5.427918, 0.317854>, 
      <0.306502, 5.626361, 0.503044>, <0.306502, 5.566828, 0.503044>, <0.313705, 5.486803, 0.508029>, <0.306502, 5.427918, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, 5.626361, 1.066741>, <1.205418, 5.566828, 1.066741>, <1.208266, 5.474919, 1.103168>, <1.205418, 5.427918, 1.066741>, 
      <1.337625, 5.626361, 0.868714>, <1.337625, 5.566828, 0.868714>, <1.340473, 5.474919, 0.905141>, <1.337625, 5.427918, 0.868714>, 
      <1.083911, 5.626361, 0.667741>, <1.083911, 5.566828, 0.667741>, <1.098273, 5.480972, 0.690613>, <1.083911, 5.427918, 0.667741>, 
      <0.882189, 5.626361, 0.541244>, <0.882189, 5.566828, 0.541244>, <0.896551, 5.480972, 0.564116>, <0.882189, 5.427918, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, 5.626361, 1.066741>, <1.040052, 5.626361, 1.314436>, <0.697037, 5.626361, 1.354735>, <0.444720, 5.626361, 1.196511>, 
      <1.205418, 5.566828, 1.066741>, <1.040052, 5.566828, 1.314436>, <0.697037, 5.566828, 1.354735>, <0.444720, 5.566828, 1.196511>, 
      <1.208266, 5.474919, 1.103168>, <1.042900, 5.474919, 1.350863>, <0.683945, 5.482373, 1.374919>, <0.431628, 5.482373, 1.216695>, 
      <1.205418, 5.427918, 1.066741>, <1.040052, 5.427918, 1.314436>, <0.697037, 5.427918, 1.354735>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.136589, 4.237260, 0.385449>, <0.230985, 4.237260, 0.641503>, <0.525421, 4.237260, 0.783306>, <0.778675, 4.237260, 0.681636>, 
      <0.133888, 4.598742, 0.357947>, <0.228284, 4.598742, 0.614001>, <0.613669, 4.629140, 0.771958>, <0.866922, 4.629140, 0.670288>, 
      <0.262640, 5.069327, 0.472687>, <0.111113, 5.069327, 0.699654>, <0.301889, 5.060339, 0.915284>, <0.533090, 5.060339, 1.060267>, 
      <0.306502, 5.427918, 0.503044>, <0.154975, 5.427918, 0.730010>, <0.213519, 5.427918, 1.051528>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506148, 4.237260, -0.057609>, <0.299510, 4.237260, 0.025347>, <0.059568, 4.237260, 0.176526>, <0.136589, 4.237260, 0.385449>, 
      <0.537902, 4.639177, -0.157845>, <0.331264, 4.639177, -0.074889>, <0.056867, 4.598742, 0.149024>, <0.133888, 4.598742, 0.357947>, 
      <0.781964, 5.057685, 0.381634>, <0.593319, 5.057685, 0.263337>, <0.386276, 5.069327, 0.287498>, <0.262640, 5.069327, 0.472687>, 
      <0.882189, 5.427918, 0.541244>, <0.693544, 5.427918, 0.422947>, <0.430138, 5.427918, 0.317854>, <0.306502, 5.427918, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 4.237260, -0.009847>, <1.038884, 4.237260, -0.233253>, <0.727110, 4.237260, -0.146316>, <0.506148, 4.237260, -0.057609>, 
      <1.248264, 4.685070, -0.135836>, <1.165904, 4.685070, -0.359242>, <0.758865, 4.639177, -0.246552>, <0.537902, 4.639177, -0.157845>, 
      <1.182348, 5.047201, 0.771676>, <1.314555, 5.047201, 0.573649>, <0.983686, 5.057685, 0.508131>, <0.781964, 5.057685, 0.381634>, 
      <1.205418, 5.427918, 1.066741>, <1.337625, 5.427918, 0.868714>, <1.083911, 5.427918, 0.667741>, <0.882189, 5.427918, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 4.237260, -0.009847>, <1.248264, 4.685070, -0.135836>, <1.182348, 5.047201, 0.771676>, <1.205418, 5.427918, 1.066741>, 
      <1.224261, 4.237260, 0.269593>, <1.351281, 4.685070, 0.143604>, <1.016982, 5.047201, 1.019371>, <1.040052, 5.427918, 1.314436>, 
      <1.055058, 4.237260, 0.570680>, <1.143306, 4.629140, 0.559332>, <0.785407, 5.060339, 1.218491>, <0.697037, 5.427918, 1.354735>, 
      <0.778675, 4.237260, 0.681636>, <0.866922, 4.629140, 0.670288>, <0.533090, 5.060339, 1.060267>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.323697, 3.126806, 0.678117>, <0.055656, 3.126806, 0.729386>, <-0.132371, 3.126806, 0.996682>, <-0.073467, 3.126806, 1.263149>, 
      <0.293214, 3.471417, 0.631713>, <0.025173, 3.471417, 0.682982>, <0.028361, 3.536985, 0.884052>, <0.087265, 3.536985, 1.150519>, 
      <0.139190, 3.889220, 0.411928>, <0.233586, 3.889220, 0.667983>, <0.425565, 3.793829, 0.796148>, <0.678819, 3.793829, 0.694477>, 
      <0.136589, 4.237260, 0.385449>, <0.230985, 4.237260, 0.641503>, <0.525421, 4.237260, 0.783306>, <0.778675, 4.237260, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700384, 3.126806, 1.115132>, <0.652323, 3.126806, 0.897713>, <0.542400, 3.126806, 0.636285>, <0.323697, 3.126806, 0.678117>, 
      <0.659006, 3.554167, 0.883174>, <0.610945, 3.554167, 0.665754>, <0.511917, 3.471417, 0.589881>, <0.293214, 3.471417, 0.631713>, 
      <0.468847, 3.765138, 0.060136>, <0.262209, 3.765138, 0.143092>, <0.062169, 3.889220, 0.203006>, <0.139190, 3.889220, 0.411928>, 
      <0.506148, 4.237260, -0.057609>, <0.299510, 4.237260, 0.025347>, <0.059568, 4.237260, 0.176526>, <0.136589, 4.237260, 0.385449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552715, 3.126806, 1.714146>, <0.786579, 3.126806, 1.669414>, <0.751777, 3.126806, 1.347623>, <0.700384, 3.126806, 1.115132>, 
      <0.676641, 3.615166, 1.322087>, <0.910505, 3.615166, 1.277355>, <0.710399, 3.554167, 1.115665>, <0.659006, 3.554167, 0.883174>, 
      <0.953085, 3.644414, 0.156947>, <0.870725, 3.644414, -0.066459>, <0.689809, 3.765138, -0.028570>, <0.468847, 3.765138, 0.060136>, 
      <1.121244, 4.237260, -0.009847>, <1.038884, 4.237260, -0.233253>, <0.727110, 4.237260, -0.146316>, <0.506148, 4.237260, -0.057609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552715, 3.126806, 1.714146>, <0.676641, 3.615166, 1.322087>, <0.953085, 3.644414, 0.156947>, <1.121244, 4.237260, -0.009847>, 
      <0.260194, 3.126806, 1.770097>, <0.384120, 3.615166, 1.378038>, <1.056102, 3.644414, 0.436386>, <1.224261, 4.237260, 0.269593>, 
      <-0.009184, 3.126806, 1.553953>, <0.151548, 3.536985, 1.441322>, <0.955202, 3.793829, 0.583522>, <1.055058, 4.237260, 0.570680>, 
      <-0.073467, 3.126806, 1.263149>, <0.087265, 3.536985, 1.150519>, <0.678819, 3.793829, 0.694477>, <0.778675, 4.237260, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.325290, 2.104019, 0.672703>, <0.058603, 2.104019, 0.730599>, <-0.122741, 2.104019, 1.002473>, <-0.057252, 2.104019, 1.267398>, 
      <0.352961, 2.406529, 0.715984>, <0.086273, 2.406529, 0.773880>, <-0.236885, 2.378022, 1.080366>, <-0.171396, 2.378022, 1.345291>, 
      <0.350494, 2.823872, 0.718909>, <0.082453, 2.823872, 0.770178>, <-0.240845, 2.849986, 1.072693>, <-0.181941, 2.849986, 1.339160>, 
      <0.323697, 3.126806, 0.678117>, <0.055656, 3.126806, 0.729386>, <-0.132371, 3.126806, 0.996682>, <-0.073467, 3.126806, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.712692, 2.104019, 1.100248>, <0.659257, 2.104019, 0.884086>, <0.542890, 2.104019, 0.625464>, <0.325290, 2.104019, 0.672703>, 
      <0.737887, 2.369360, 1.252370>, <0.684452, 2.369360, 1.036208>, <0.570560, 2.406529, 0.668745>, <0.352961, 2.406529, 0.715984>, 
      <0.726405, 2.858055, 1.261002>, <0.678344, 2.858055, 1.043582>, <0.569197, 2.823872, 0.677077>, <0.350494, 2.823872, 0.718909>, 
      <0.700384, 3.126806, 1.115132>, <0.652323, 3.126806, 0.897713>, <0.542400, 3.126806, 0.636285>, <0.323697, 3.126806, 0.678117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.579914, 2.104019, 1.702737>, <0.812597, 2.104019, 1.652223>, <0.769831, 2.104019, 1.331393>, <0.712692, 2.104019, 1.100248>, 
      <0.516103, 2.333612, 1.896236>, <0.748786, 2.333612, 1.845722>, <0.795026, 2.369360, 1.483515>, <0.737887, 2.369360, 1.252370>, 
      <0.493128, 2.891989, 1.902659>, <0.726992, 2.891989, 1.857927>, <0.777798, 2.858055, 1.493492>, <0.726405, 2.858055, 1.261002>, 
      <0.552715, 3.126806, 1.714146>, <0.786579, 3.126806, 1.669414>, <0.751777, 3.126806, 1.347623>, <0.700384, 3.126806, 1.115132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.579914, 2.104019, 1.702737>, <0.516103, 2.333612, 1.896236>, <0.493128, 2.891989, 1.902659>, <0.552715, 3.126806, 1.714146>, 
      <0.288870, 2.104019, 1.765921>, <0.225059, 2.333612, 1.959420>, <0.200607, 2.891989, 1.958610>, <0.260194, 3.126806, 1.770097>, 
      <0.014219, 2.104019, 1.556518>, <-0.099925, 2.378022, 1.634412>, <-0.117658, 2.849986, 1.629964>, <-0.009184, 3.126806, 1.553953>, 
      <-0.057252, 2.104019, 1.267398>, <-0.171396, 2.378022, 1.345291>, <-0.181941, 2.849986, 1.339160>, <-0.073467, 3.126806, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.136589, 1.081232, 0.385449>, <0.230985, 1.081232, 0.641503>, <0.525421, 1.081232, 0.783306>, <0.778675, 1.081232, 0.681636>, 
      <0.139470, 1.403868, 0.411465>, <0.233866, 1.403868, 0.667519>, <0.424876, 1.502667, 0.797505>, <0.678130, 1.502667, 0.695835>, 
      <0.296100, 1.784891, 0.627044>, <0.029412, 1.784891, 0.684940>, <0.038498, 1.716962, 0.892441>, <0.103988, 1.716962, 1.157366>, 
      <0.325290, 2.104019, 0.672703>, <0.058603, 2.104019, 0.730599>, <-0.122741, 2.104019, 1.002473>, <-0.057252, 2.104019, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.136589, 1.081232, 0.385449>, <0.133650, 0.752073, 0.358907>, <0.263214, 0.326017, 0.473085>, <0.306502, 0.000000, 0.503044>, 
      <0.230985, 1.081232, 0.641503>, <0.228046, 0.752073, 0.614961>, <0.111687, 0.326017, 0.700051>, <0.154975, 0.000000, 0.730010>, 
      <0.525421, 1.081232, 0.783306>, <0.611930, 0.718632, 0.771090>, <0.301283, 0.336303, 0.916217>, <0.213519, 0.000000, 1.051528>, 
      <0.778675, 1.081232, 0.681636>, <0.865183, 0.718632, 0.669420>, <0.532485, 0.336303, 1.061200>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506148, 1.081232, -0.057609>, <0.299510, 1.081232, 0.025347>, <0.059568, 1.081232, 0.176526>, <0.136589, 1.081232, 0.385449>, 
      <0.469852, 1.531785, 0.062096>, <0.263214, 1.531785, 0.145052>, <0.062449, 1.403868, 0.202542>, <0.139470, 1.403868, 0.411465>, 
      <0.674303, 1.699731, 0.868467>, <0.620868, 1.699731, 0.652306>, <0.513699, 1.784891, 0.579805>, <0.296100, 1.784891, 0.627044>, 
      <0.712692, 2.104019, 1.100248>, <0.659257, 2.104019, 0.884086>, <0.542890, 2.104019, 0.625464>, <0.325290, 2.104019, 0.672703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506148, 1.081232, -0.057609>, <0.536233, 0.707777, -0.156830>, <0.782503, 0.339233, 0.382492>, <0.882189, 0.000000, 0.541244>, 
      <0.299510, 1.081232, 0.025347>, <0.329595, 0.707777, -0.073874>, <0.593858, 0.339233, 0.264196>, <0.693544, 0.000000, 0.422947>, 
      <0.059568, 1.081232, 0.176526>, <0.056629, 0.752073, 0.149984>, <0.386850, 0.326017, 0.287895>, <0.430138, 0.000000, 0.317854>, 
      <0.136589, 1.081232, 0.385449>, <0.133650, 0.752073, 0.358907>, <0.263214, 0.326017, 0.473085>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <1.038884, 1.081232, -0.233252>, <0.727110, 1.081232, -0.146316>, <0.506148, 1.081232, -0.057609>, 
      <0.951527, 1.652112, 0.162718>, <0.869167, 1.652112, -0.060688>, <0.690815, 1.531785, -0.026611>, <0.469852, 1.531785, 0.062096>, 
      <0.708813, 1.640239, 1.311867>, <0.941496, 1.640239, 1.261353>, <0.731442, 1.699731, 1.099613>, <0.674303, 1.699731, 0.868467>, 
      <0.579914, 2.104019, 1.702737>, <0.812597, 2.104019, 1.652223>, <0.769831, 2.104019, 1.331393>, <0.712692, 2.104019, 1.100248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <1.246722, 0.659160, -0.137429>, <1.182372, 0.350362, 0.771983>, <1.205418, 0.000000, 1.066741>, 
      <1.038884, 1.081232, -0.233252>, <1.164362, 0.659160, -0.360834>, <1.314579, 0.350362, 0.573956>, <1.337625, 0.000000, 0.868714>, 
      <0.727110, 1.081232, -0.146316>, <0.757196, 0.707777, -0.245536>, <0.984225, 0.339233, 0.508989>, <1.083911, 0.000000, 0.667741>, 
      <0.506148, 1.081232, -0.057609>, <0.536233, 0.707777, -0.156830>, <0.782503, 0.339233, 0.382492>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <0.951527, 1.652112, 0.162718>, <0.708813, 1.640239, 1.311867>, <0.579914, 2.104019, 1.702737>, 
      <1.224261, 1.081232, 0.269593>, <1.054544, 1.652112, 0.442157>, <0.417769, 1.640239, 1.375051>, <0.288870, 2.104019, 1.765921>, 
      <1.055058, 1.081232, 0.570681>, <0.954513, 1.502667, 0.584879>, <0.175458, 1.716962, 1.446486>, <0.014219, 2.104019, 1.556518>, 
      <0.778675, 1.081232, 0.681636>, <0.678130, 1.502667, 0.695835>, <0.103988, 1.716962, 1.157366>, <-0.057252, 2.104019, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <1.224261, 1.081232, 0.269593>, <1.055058, 1.081232, 0.570681>, <0.778675, 1.081232, 0.681636>, 
      <1.246722, 0.659160, -0.137429>, <1.349739, 0.659160, 0.142011>, <1.141566, 0.718632, 0.558464>, <0.865183, 0.718632, 0.669420>, 
      <1.182372, 0.350362, 0.771983>, <1.017006, 0.350362, 1.019678>, <0.784802, 0.336303, 1.219424>, <0.532485, 0.336303, 1.061200>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.169675, -0.058443, 0.568964>, <-0.427715, -0.058443, 0.480143>, <-0.742934, -0.049389, 0.605272>, <-0.824349, -0.049389, 0.865744>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.077858, -0.055343, 1.149915>, <-0.011429, -0.055343, 0.937387>, <0.040870, -0.058443, 0.641436>, <-0.169675, -0.058443, 0.568964>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.519688, -0.046232, 1.589722>, <-0.294549, -0.046232, 1.667217>, <-0.148892, -0.055343, 1.377175>, <-0.077858, -0.055343, 1.149915>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.519688, -0.046232, 1.589722>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.801295, -0.046232, 1.492789>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.913200, -0.049389, 1.150005>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.824349, -0.049389, 0.865744>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, 5.626361, 0.579594>, <-0.165728, 5.566828, 0.579594>, <-0.169374, 5.486522, 0.569774>, <-0.165728, 5.427918, 0.579594>, 
      <-0.423769, 5.626361, 0.490773>, <-0.423769, 5.566828, 0.490773>, <-0.427414, 5.486522, 0.480954>, <-0.423769, 5.427918, 0.490773>, 
      <-0.719824, 5.626361, 0.629163>, <-0.719824, 5.566828, 0.629163>, <-0.741634, 5.478515, 0.606616>, <-0.719824, 5.427918, 0.629163>, 
      <-0.801239, 5.626361, 0.889635>, <-0.801239, 5.566828, 0.889635>, <-0.823049, 5.478515, 0.867088>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, 5.626361, 1.146066>, <-0.056259, 5.566828, 1.146066>, <-0.076364, 5.483838, 1.149648>, <-0.056259, 5.427918, 1.146066>, 
      <0.010170, 5.626361, 0.933538>, <0.010170, 5.566828, 0.933538>, <-0.009935, 5.483838, 0.937120>, <0.010170, 5.427918, 0.933538>, 
      <0.044816, 5.626361, 0.652066>, <0.044816, 5.566828, 0.652066>, <0.041170, 5.486522, 0.642246>, <0.044816, 5.427918, 0.652066>, 
      <-0.165728, 5.626361, 0.579594>, <-0.165728, 5.566828, 0.579594>, <-0.169374, 5.486522, 0.569774>, <-0.165728, 5.427918, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, 5.626361, 1.592315>, <-0.482271, 5.566828, 1.592315>, <-0.517825, 5.475604, 1.589851>, <-0.482271, 5.427918, 1.592315>, 
      <-0.257132, 5.626361, 1.669811>, <-0.257132, 5.566828, 1.669811>, <-0.292686, 5.475604, 1.667346>, <-0.257132, 5.427918, 1.669811>, 
      <-0.127293, 5.626361, 1.373327>, <-0.127293, 5.566828, 1.373327>, <-0.147398, 5.483838, 1.376909>, <-0.127293, 5.427918, 1.373327>, 
      <-0.056259, 5.626361, 1.146066>, <-0.056259, 5.566828, 1.146066>, <-0.076364, 5.483838, 1.149648>, <-0.056259, 5.427918, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, 5.626361, 1.592315>, <-0.763878, 5.626361, 1.495382>, <-0.890089, 5.626361, 1.173896>, <-0.801239, 5.626361, 0.889635>, 
      <-0.482271, 5.566828, 1.592315>, <-0.763878, 5.566828, 1.495382>, <-0.890089, 5.566828, 1.173896>, <-0.801239, 5.566828, 0.889635>, 
      <-0.517825, 5.475604, 1.589851>, <-0.799432, 5.475604, 1.492918>, <-0.911900, 5.478515, 1.151348>, <-0.823049, 5.478515, 0.867088>, 
      <-0.482271, 5.427918, 1.592315>, <-0.763878, 5.427918, 1.495382>, <-0.890089, 5.427918, 1.173896>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079315, 4.237260, 0.812352>, <-0.302942, 4.237260, 0.968765>, <-0.365198, 4.237260, 1.289584>, <-0.202462, 4.237260, 1.508653>, 
      <-0.095667, 4.600611, 0.841447>, <-0.319294, 4.600611, 0.997861>, <-0.378389, 4.657299, 1.422767>, <-0.215653, 4.657299, 1.641836>, 
      <-0.143384, 5.068730, 0.639780>, <-0.401424, 5.068730, 0.550959>, <-0.558318, 5.053241, 0.796129>, <-0.639733, 5.053241, 1.056601>, 
      <-0.165728, 5.427918, 0.579594>, <-0.423769, 5.427918, 0.490773>, <-0.719824, 5.427918, 0.629163>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443163, 4.237260, 1.057078>, <0.310381, 4.237260, 0.878332>, <0.103150, 4.237260, 0.684729>, <-0.079315, 4.237260, 0.812352>, 
      <0.498345, 4.618864, 1.102730>, <0.365563, 4.618864, 0.923985>, <0.086798, 4.600611, 0.713825>, <-0.095667, 4.600611, 0.841447>, 
      <0.074864, 5.063210, 1.122702>, <0.141293, 5.063210, 0.910174>, <0.067160, 5.068730, 0.712251>, <-0.143384, 5.068730, 0.639780>, 
      <-0.056259, 5.427918, 1.146066>, <0.010170, 5.427918, 0.933538>, <0.044816, 5.427918, 0.652066>, <-0.165728, 5.427918, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 4.237260, 1.664096>, <0.748519, 4.237260, 1.527626>, <0.585149, 4.237260, 1.248215>, <0.443163, 4.237260, 1.057078>, 
      <0.654074, 4.679660, 1.800983>, <0.849187, 4.679660, 1.664513>, <0.640332, 4.618864, 1.293867>, <0.498345, 4.618864, 1.102730>, 
      <-0.199245, 5.048310, 1.611931>, <0.025894, 5.048310, 1.689427>, <0.003830, 5.063210, 1.349963>, <0.074864, 5.063210, 1.122702>, 
      <-0.482271, 5.427918, 1.592315>, <-0.257132, 5.427918, 1.669811>, <-0.127293, 5.427918, 1.373327>, <-0.056259, 5.427918, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 4.237260, 1.664096>, <0.654074, 4.679660, 1.800983>, <-0.199245, 5.048310, 1.611931>, <-0.482271, 5.427918, 1.592315>, 
      <0.309356, 4.237260, 1.834794>, <0.410023, 4.679660, 1.971681>, <-0.480853, 5.048310, 1.514998>, <-0.763878, 5.427918, 1.495382>, 
      <-0.024864, 4.237260, 1.747729>, <-0.038054, 4.657299, 1.880911>, <-0.728584, 5.053241, 1.340861>, <-0.890089, 5.427918, 1.173896>, 
      <-0.202462, 4.237260, 1.508653>, <-0.215653, 4.657299, 1.641836>, <-0.639733, 5.053241, 1.056601>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062171, 3.126806, 0.395332>, <-0.179924, 3.126806, 0.149145>, <-0.486251, 3.126806, 0.035282>, <-0.728975, 3.126806, 0.160018>, 
      <-0.064112, 3.476210, 0.462942>, <-0.181865, 3.476210, 0.216754>, <-0.371764, 3.581238, 0.318136>, <-0.614488, 3.581238, 0.442872>, 
      <-0.063366, 3.882862, 0.783973>, <-0.286993, 3.882862, 0.940387>, <-0.348819, 3.715716, 1.124218>, <-0.186083, 3.715716, 1.343286>, 
      <-0.079315, 4.237260, 0.812352>, <-0.302942, 4.237260, 0.968765>, <-0.365198, 4.237260, 1.289584>, <-0.202462, 4.237260, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389013, 3.126806, 0.870777>, <-0.190966, 3.126806, 0.769001>, <0.033908, 3.126806, 0.596205>, <-0.062171, 3.126806, 0.395332>, 
      <-0.237849, 3.517399, 0.902656>, <-0.039802, 3.517399, 0.800880>, <0.031967, 3.476210, 0.663814>, <-0.064112, 3.476210, 0.462942>, 
      <0.383466, 3.824432, 1.007690>, <0.250684, 3.824432, 0.828945>, <0.119099, 3.882862, 0.656351>, <-0.063366, 3.882862, 0.783973>, 
      <0.443163, 4.237260, 1.057078>, <0.310381, 4.237260, 0.878332>, <0.103150, 4.237260, 0.684729>, <-0.079315, 4.237260, 0.812352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005887, 3.126806, 0.880309>, <-0.903148, 3.126806, 1.095106>, <-0.600789, 3.126806, 0.979609>, <-0.389013, 3.126806, 0.870777>, 
      <-0.654901, 3.609153, 1.051319>, <-0.552162, 3.609153, 1.266116>, <-0.449625, 3.517399, 1.011488>, <-0.237849, 3.517399, 0.902656>, 
      <0.421587, 3.657960, 1.484850>, <0.616700, 3.657960, 1.348380>, <0.525452, 3.824432, 1.198827>, <0.383466, 3.824432, 1.007690>, 
      <0.553406, 4.237260, 1.664096>, <0.748519, 4.237260, 1.527626>, <0.585149, 4.237260, 1.248215>, <0.443163, 4.237260, 1.057078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005887, 3.126806, 0.880309>, <-0.654901, 3.609153, 1.051319>, <0.421587, 3.657960, 1.484850>, <0.553406, 4.237260, 1.664096>, 
      <-1.134395, 3.126806, 0.611638>, <-0.783409, 3.609153, 0.782648>, <0.177536, 3.657960, 1.655548>, <0.309356, 4.237260, 1.834794>, 
      <-0.993867, 3.126806, 0.296146>, <-0.879380, 3.581238, 0.579000>, <-0.008485, 3.715716, 1.582362>, <-0.024864, 4.237260, 1.747729>, 
      <-0.728975, 3.126806, 0.160018>, <-0.614488, 3.581238, 0.442872>, <-0.186083, 3.715716, 1.343286>, <-0.202462, 4.237260, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.067467, 2.104019, 0.399568>, <-0.191285, 2.104019, 0.156375>, <-0.500339, 2.104019, 0.050139>, <-0.739897, 2.104019, 0.180852>, 
      <-0.064947, 2.404667, 0.338276>, <-0.188765, 2.404667, 0.095083>, <-0.564821, 2.354539, -0.115028>, <-0.804379, 2.354539, 0.015686>, 
      <-0.060498, 2.825556, 0.337040>, <-0.178251, 2.825556, 0.090852>, <-0.550444, 2.872004, -0.123316>, <-0.793168, 2.872004, 0.001420>, 
      <-0.062171, 3.126806, 0.395332>, <-0.179924, 3.126806, 0.149145>, <-0.486251, 3.126806, 0.035282>, <-0.728975, 3.126806, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.382426, 2.104019, 0.882967>, <-0.186963, 2.104019, 0.776314>, <0.033561, 2.104019, 0.597998>, <-0.067467, 2.104019, 0.399568>, 
      <-0.497652, 2.387256, 0.857171>, <-0.302188, 2.387256, 0.750518>, <0.036080, 2.404667, 0.536706>, <-0.064947, 2.404667, 0.338276>, 
      <-0.499449, 2.841451, 0.847487>, <-0.301402, 2.841451, 0.745711>, <0.035581, 2.825556, 0.537912>, <-0.060498, 2.825556, 0.337040>, 
      <-0.389013, 3.126806, 0.870777>, <-0.190966, 3.126806, 0.769001>, <0.033908, 3.126806, 0.596205>, <-0.062171, 3.126806, 0.395332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998874, 2.104019, 0.907784>, <-0.890843, 2.104019, 1.119969>, <-0.591439, 2.104019, 0.997014>, <-0.382426, 2.104019, 0.882967>, 
      <-1.176878, 2.337535, 0.818310>, <-1.068847, 2.337535, 1.030495>, <-0.706665, 2.387256, 0.971218>, <-0.497652, 2.387256, 0.857171>, 
      <-1.179499, 2.888217, 0.795721>, <-1.076760, 2.888217, 1.010518>, <-0.711224, 2.841451, 0.956319>, <-0.499449, 2.841451, 0.847487>, 
      <-1.005887, 3.126806, 0.880309>, <-0.903148, 3.126806, 1.095106>, <-0.600789, 3.126806, 0.979609>, <-0.389013, 3.126806, 0.870777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998874, 2.104019, 0.907784>, <-1.176878, 2.337535, 0.818310>, <-1.179499, 2.888217, 0.795721>, <-1.005887, 3.126806, 0.880309>, 
      <-1.134000, 2.104019, 0.642380>, <-1.312004, 2.337535, 0.552905>, <-1.308007, 2.888217, 0.527049>, <-1.134395, 3.126806, 0.611638>, 
      <-1.001334, 2.104019, 0.323503>, <-1.065815, 2.354539, 0.158337>, <-1.058060, 2.872004, 0.137549>, <-0.993867, 3.126806, 0.296146>, 
      <-0.739897, 2.104019, 0.180852>, <-0.804379, 2.354539, 0.015686>, <-0.793168, 2.872004, 0.001420>, <-0.728975, 3.126806, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079315, 1.081232, 0.812352>, <-0.302942, 1.081232, 0.968765>, <-0.365198, 1.081232, 1.289584>, <-0.202462, 1.081232, 1.508653>, 
      <-0.063934, 1.410573, 0.784173>, <-0.287561, 1.410573, 0.940586>, <-0.350615, 1.581443, 1.121077>, <-0.187879, 1.581443, 1.340146>, 
      <-0.070184, 1.779797, 0.465665>, <-0.194002, 1.779797, 0.222472>, <-0.389402, 1.673014, 0.334298>, <-0.628960, 1.673014, 0.465011>, 
      <-0.067467, 2.104019, 0.399568>, <-0.191285, 2.104019, 0.156375>, <-0.500339, 2.104019, 0.050139>, <-0.739897, 2.104019, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079315, 1.081232, 0.812352>, <-0.094784, 0.749990, 0.840694>, <-0.143666, 0.326719, 0.639020>, <-0.165728, 0.000000, 0.579594>, 
      <-0.302942, 1.081232, 0.968765>, <-0.318411, 0.749990, 0.997107>, <-0.401706, 0.326719, 0.550200>, <-0.423769, 0.000000, 0.490773>, 
      <-0.365198, 1.081232, 1.289584>, <-0.376651, 0.688389, 1.421922>, <-0.558846, 0.344035, 0.795584>, <-0.719824, 0.000000, 0.629163>, 
      <-0.202462, 1.081232, 1.508653>, <-0.213915, 0.688389, 1.640991>, <-0.640260, 0.344035, 1.056055>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443163, 1.081232, 1.057078>, <0.310381, 1.081232, 0.878332>, <0.103150, 1.081232, 0.684729>, <-0.079315, 1.081232, 0.812352>, 
      <0.382688, 1.471339, 1.008297>, <0.249907, 1.471339, 0.829551>, <0.118531, 1.410573, 0.656550>, <-0.063934, 1.410573, 0.784173>, 
      <-0.233066, 1.736876, 0.916405>, <-0.037602, 1.736876, 0.809751>, <0.030843, 1.779797, 0.664095>, <-0.070184, 1.779797, 0.465665>, 
      <-0.382426, 2.104019, 0.882967>, <-0.186963, 2.104019, 0.776314>, <0.033561, 2.104019, 0.597998>, <-0.067467, 2.104019, 0.399568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443163, 1.081232, 1.057078>, <0.497637, 0.729837, 1.101018>, <0.073733, 0.333080, 1.122904>, <-0.056259, 0.000000, 1.146066>, 
      <0.310381, 1.081232, 0.878332>, <0.364855, 0.729837, 0.922273>, <0.140162, 0.333080, 0.910376>, <0.010170, 0.000000, 0.933538>, 
      <0.103150, 1.081232, 0.684729>, <0.087680, 0.749990, 0.713071>, <0.066878, 0.326719, 0.711492>, <0.044816, 0.000000, 0.652066>, 
      <-0.079315, 1.081232, 0.812352>, <-0.094784, 0.749990, 0.840694>, <-0.143666, 0.326719, 0.639020>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.748519, 1.081232, 1.527626>, <0.585149, 1.081232, 1.248215>, <0.443163, 1.081232, 1.057078>, 
      <0.416513, 1.638769, 1.482704>, <0.611626, 1.638769, 1.346234>, <0.524675, 1.471339, 1.199433>, <0.382688, 1.471339, 1.008297>, 
      <-0.649730, 1.645991, 1.083283>, <-0.541699, 1.645991, 1.295468>, <-0.442079, 1.736876, 1.030451>, <-0.233066, 1.736876, 0.916405>, 
      <-0.998874, 2.104019, 0.907784>, <-0.890843, 2.104019, 1.119969>, <-0.591439, 2.104019, 0.997014>, <-0.382426, 2.104019, 0.882967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.655651, 0.664810, 1.799576>, <-0.199640, 0.349216, 1.611903>, <-0.482271, 0.000000, 1.592315>, 
      <0.748519, 1.081232, 1.527626>, <0.850764, 0.664810, 1.663107>, <0.025499, 0.349216, 1.689399>, <-0.257132, 0.000000, 1.669811>, 
      <0.585149, 1.081232, 1.248215>, <0.639623, 0.729837, 1.292155>, <0.002699, 0.333080, 1.350164>, <-0.127293, 0.000000, 1.373327>, 
      <0.443163, 1.081232, 1.057078>, <0.497637, 0.729837, 1.101018>, <0.073733, 0.333080, 1.122904>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.416513, 1.638769, 1.482704>, <-0.649730, 1.645991, 1.083283>, <-0.998874, 2.104019, 0.907784>, 
      <0.309356, 1.081232, 1.834794>, <0.172463, 1.638769, 1.653403>, <-0.784857, 1.645991, 0.817879>, <-1.134000, 2.104019, 0.642380>, 
      <-0.024864, 1.081232, 1.747729>, <-0.010280, 1.581443, 1.579222>, <-0.890397, 1.673014, 0.607662>, <-1.001334, 2.104019, 0.323503>, 
      <-0.202462, 1.081232, 1.508653>, <-0.187879, 1.581443, 1.340146>, <-0.628960, 1.673014, 0.465011>, <-0.739897, 2.104019, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.309356, 1.081232, 1.834794>, <-0.024864, 1.081232, 1.747729>, <-0.202462, 1.081232, 1.508653>, 
      <0.655651, 0.664810, 1.799576>, <0.411600, 0.664810, 1.970275>, <-0.036317, 0.688389, 1.880066>, <-0.213915, 0.688389, 1.640991>, 
      <-0.199640, 0.349216, 1.611903>, <-0.481248, 0.349216, 1.514971>, <-0.729111, 0.344035, 1.340316>, <-0.640260, 0.344035, 1.056055>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.527141, -0.052914, 0.002769>, <0.527141, -0.052914, -0.270131>, <0.303971, -0.046681, -0.527610>, <0.031183, -0.046681, -0.519816>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.009846, -0.057873, 0.277982>, <0.232423, -0.057873, 0.271622>, <0.527141, -0.052914, 0.225437>, <0.527141, -0.052914, 0.002769>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.552912, -0.050439, -0.000371>, <-0.552912, -0.050439, 0.237733>, <-0.228160, -0.057873, 0.284782>, <0.009846, -0.057873, 0.277982>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.552912, -0.050439, -0.000371>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.552912, -0.050439, -0.298194>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.266518, -0.046681, -0.511310>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.031183, -0.046681, -0.519816>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 5.626361, 0.000000>, <0.500000, 5.566828, 0.000000>, <0.525410, 5.481693, 0.002592>, <0.500000, 5.427918, 0.000000>, 
      <0.500000, 5.626361, -0.272899>, <0.500000, 5.566828, -0.272899>, <0.525410, 5.481693, -0.270307>, <0.500000, 5.427918, -0.272899>, 
      <0.272788, 5.626361, -0.507794>, <0.272788, 5.566828, -0.507794>, <0.302391, 5.476022, -0.526606>, <0.272788, 5.427918, -0.507794>, 
      <0.000000, 5.626361, -0.500000>, <0.000000, 5.566828, -0.500000>, <0.029603, 5.476022, -0.518812>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.626361, 0.287879>, <0.000000, 5.566828, 0.287879>, <0.009109, 5.486033, 0.278723>, <0.000000, 5.427918, 0.287879>, 
      <0.222577, 5.626361, 0.281520>, <0.222577, 5.566828, 0.281520>, <0.231686, 5.486033, 0.272364>, <0.222577, 5.427918, 0.281520>, 
      <0.500000, 5.626361, 0.222668>, <0.500000, 5.566828, 0.222668>, <0.525410, 5.481693, 0.225260>, <0.500000, 5.427918, 0.222668>, 
      <0.500000, 5.626361, 0.000000>, <0.500000, 5.566828, 0.000000>, <0.525410, 5.481693, 0.002592>, <0.500000, 5.427918, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, 5.626361, 0.030303>, <-0.560606, 5.566828, 0.030303>, <-0.553362, 5.479470, 0.001422>, <-0.560606, 5.427918, 0.030303>, 
      <-0.560606, 5.626361, 0.268407>, <-0.560606, 5.566828, 0.268407>, <-0.553362, 5.479470, 0.239525>, <-0.560606, 5.427918, 0.268407>, 
      <-0.238007, 5.626361, 0.294679>, <-0.238007, 5.566828, 0.294679>, <-0.228898, 5.486033, 0.285523>, <-0.238007, 5.427918, 0.294679>, 
      <0.000000, 5.626361, 0.287879>, <0.000000, 5.566828, 0.287879>, <0.009109, 5.486033, 0.278723>, <0.000000, 5.427918, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, 5.626361, 0.030303>, <-0.560606, 5.626361, -0.267520>, <-0.297702, 5.626361, -0.491494>, <0.000000, 5.626361, -0.500000>, 
      <-0.560606, 5.566828, 0.030303>, <-0.560606, 5.566828, -0.267520>, <-0.297702, 5.566828, -0.491494>, <0.000000, 5.566828, -0.500000>, 
      <-0.553362, 5.479470, 0.001422>, <-0.553362, 5.479470, -0.296401>, <-0.268099, 5.476022, -0.510306>, <0.029603, 5.476022, -0.518812>, 
      <-0.560606, 5.427918, 0.030303>, <-0.560606, 5.427918, -0.267520>, <-0.297702, 5.427918, -0.491494>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.156367, 4.237260, -0.066958>, <-0.377048, 4.237260, -0.227501>, <-0.700661, 4.237260, -0.181950>, <-0.854836, 4.237260, 0.043226>, 
      <-0.211176, 4.633984, -0.146791>, <-0.431857, 4.633984, -0.307334>, <-0.857792, 4.676394, -0.230798>, <-1.011967, 4.676394, -0.005622>, 
      <0.325701, 5.059040, -0.017781>, <0.325701, 5.059040, -0.290680>, <0.039604, 5.048995, -0.359611>, <-0.233184, 5.048995, -0.351817>, 
      <0.500000, 5.427918, 0.000000>, <0.500000, 5.427918, -0.272899>, <0.272788, 5.427918, -0.507794>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217716, 4.237260, 0.506724>, <-0.091919, 4.237260, 0.322995>, <0.023694, 4.237260, 0.064035>, <-0.156367, 4.237260, -0.066958>, 
      <-0.259454, 4.603884, 0.503398>, <-0.133658, 4.603884, 0.319669>, <-0.031115, 4.633984, -0.015799>, <-0.211176, 4.633984, -0.146791>, 
      <-0.056458, 5.067698, 0.344630>, <0.166119, 5.067698, 0.338270>, <0.325701, 5.059040, 0.204887>, <0.325701, 5.059040, -0.017781>, 
      <0.000000, 5.427918, 0.287879>, <0.222577, 5.427918, 0.281520>, <0.500000, 5.427918, 0.222668>, <0.500000, 5.427918, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 4.237260, 0.808531>, <-0.563259, 4.237260, 0.948604>, <-0.352233, 4.237260, 0.703189>, <-0.217716, 4.237260, 0.506724>, 
      <-0.865763, 4.650181, 0.862675>, <-0.673220, 4.650181, 1.002748>, <-0.393971, 4.603884, 0.699863>, <-0.259454, 4.603884, 0.503398>, 
      <-0.613017, 5.054936, 0.239262>, <-0.613017, 5.054936, 0.477366>, <-0.294464, 5.067698, 0.351430>, <-0.056458, 5.067698, 0.344630>, 
      <-0.560606, 5.427918, 0.030303>, <-0.560606, 5.427918, 0.268407>, <-0.238007, 5.427918, 0.294679>, <0.000000, 5.427918, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 4.237260, 0.808531>, <-0.865763, 4.650181, 0.862675>, <-0.613017, 5.054936, 0.239262>, <-0.560606, 5.427918, 0.030303>, 
      <-0.996637, 4.237260, 0.633326>, <-1.106599, 4.650181, 0.687470>, <-0.613017, 5.054936, -0.058561>, <-0.560606, 5.427918, -0.267520>, 
      <-1.023091, 4.237260, 0.288967>, <-1.180222, 4.676394, 0.240119>, <-0.530886, 5.048995, -0.343312>, <-0.297702, 5.427918, -0.491494>, 
      <-0.854836, 4.237260, 0.043226>, <-1.011967, 4.676394, -0.005622>, <-0.233184, 5.048995, -0.351817>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.817907, 3.126806, 0.463057>, <1.012365, 3.126806, 0.271588>, <1.020327, 3.126806, -0.055119>, <0.823383, 3.126806, -0.244029>, 
      <0.627449, 3.545497, 0.362485>, <0.821907, 3.545497, 0.171016>, <0.648626, 3.605394, 0.013256>, <0.451682, 3.605394, -0.175654>, 
      <-0.093174, 3.779848, 0.025088>, <-0.313855, 3.779848, -0.135455>, <-0.496329, 3.666211, -0.118428>, <-0.650504, 3.666211, 0.106748>, 
      <-0.156367, 4.237260, -0.066958>, <-0.377048, 4.237260, -0.227501>, <-0.700661, 4.237260, -0.181950>, <-0.854836, 4.237260, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.261970, 3.126806, 0.308754>, <0.422664, 3.126806, 0.462892>, <0.659242, 3.126806, 0.619283>, <0.817907, 3.126806, 0.463057>, 
      <0.182844, 3.484314, 0.342564>, <0.343538, 3.484314, 0.496702>, <0.468784, 3.545497, 0.518711>, <0.627449, 3.545497, 0.362485>, 
      <-0.176124, 3.871918, 0.510038>, <-0.050327, 3.871918, 0.326309>, <0.086887, 3.779848, 0.156080>, <-0.093174, 3.779848, 0.025088>, 
      <-0.217716, 4.237260, 0.506724>, <-0.091919, 4.237260, 0.322995>, <0.023694, 4.237260, 0.064035>, <-0.156367, 4.237260, -0.066958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052183, 3.126806, -0.271430>, <-0.117481, 3.126806, -0.104375>, <0.090137, 3.126806, 0.143931>, <0.261970, 3.126806, 0.308754>, 
      <-0.111563, 3.571147, -0.046815>, <-0.281227, 3.571147, 0.120240>, <0.011011, 3.484314, 0.177740>, <0.182844, 3.484314, 0.342564>, 
      <-0.621998, 3.734806, 0.742647>, <-0.429455, 3.734806, 0.882720>, <-0.310640, 3.871918, 0.706503>, <-0.176124, 3.871918, 0.510038>, 
      <-0.755802, 4.237260, 0.808531>, <-0.563259, 4.237260, 0.948604>, <-0.352233, 4.237260, 0.703189>, <-0.217716, 4.237260, 0.506724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052183, 3.126806, -0.271430>, <-0.111563, 3.571147, -0.046815>, <-0.621998, 3.734806, 0.742647>, <-0.755802, 4.237260, 0.808531>, 
      <0.264401, 3.126806, -0.480385>, <0.100654, 3.571147, -0.255771>, <-0.862833, 3.734806, 0.567442>, <-0.996637, 4.237260, 0.633326>, 
      <0.608452, 3.126806, -0.450192>, <0.236751, 3.605394, -0.381818>, <-0.818759, 3.666211, 0.352489>, <-1.023091, 4.237260, 0.288967>, 
      <0.823383, 3.126806, -0.244029>, <0.451682, 3.605394, -0.175654>, <-0.650504, 3.666211, 0.106748>, <-0.854836, 4.237260, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.814019, 2.104019, 0.445460>, <1.003672, 2.104019, 0.249231>, <1.003535, 2.104019, -0.077573>, <0.801970, 2.104019, -0.261544>, 
      <0.942511, 2.373799, 0.515361>, <1.132164, 2.373799, 0.319132>, <1.197087, 2.339938, -0.110702>, <0.995521, 2.339938, -0.294673>, 
      <0.942043, 2.853912, 0.528608>, <1.136501, 2.853912, 0.337139>, <1.207420, 2.885913, -0.089535>, <1.010475, 2.885913, -0.278445>, 
      <0.817907, 3.126806, 0.463057>, <1.012365, 3.126806, 0.271588>, <1.020327, 3.126806, -0.055119>, <0.823383, 3.126806, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254429, 2.104019, 0.304983>, <0.418893, 2.104019, 0.455091>, <0.659275, 2.104019, 0.605570>, <0.814019, 2.104019, 0.445460>, 
      <0.324175, 2.401444, 0.276198>, <0.488639, 2.401444, 0.426307>, <0.787767, 2.373799, 0.675471>, <0.942511, 2.373799, 0.515361>, 
      <0.327998, 2.828479, 0.280541>, <0.488692, 2.828479, 0.434680>, <0.783378, 2.853912, 0.684834>, <0.942043, 2.853912, 0.528608>, 
      <0.261970, 3.126806, 0.308754>, <0.422664, 3.126806, 0.462892>, <0.659242, 3.126806, 0.619283>, <0.817907, 3.126806, 0.463057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030328, 2.104019, -0.269824>, <-0.135143, 2.104019, -0.098615>, <0.078564, 2.104019, 0.144469>, <0.254429, 2.104019, 0.304983>, 
      <0.131534, 2.360242, -0.405097>, <-0.033937, 2.360242, -0.233888>, <0.148310, 2.401444, 0.115684>, <0.324175, 2.401444, 0.276198>, 
      <0.148067, 2.866616, -0.402956>, <-0.021597, 2.866616, -0.235901>, <0.156165, 2.828479, 0.115718>, <0.327998, 2.828479, 0.280541>, 
      <0.052183, 3.126806, -0.271430>, <-0.117481, 3.126806, -0.104375>, <0.090137, 3.126806, 0.143931>, <0.261970, 3.126806, 0.308754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030328, 2.104019, -0.269824>, <0.131534, 2.360242, -0.405097>, <0.148067, 2.866616, -0.402956>, <0.052183, 3.126806, -0.271430>, 
      <0.237302, 2.104019, -0.483975>, <0.338508, 2.360242, -0.619248>, <0.360284, 2.866616, -0.611912>, <0.264401, 3.126806, -0.480385>, 
      <0.581996, 2.104019, -0.462317>, <0.775547, 2.339938, -0.495447>, <0.795544, 2.885913, -0.484608>, <0.608452, 3.126806, -0.450192>, 
      <0.801970, 2.104019, -0.261544>, <0.995521, 2.339938, -0.294673>, <1.010475, 2.885913, -0.278445>, <0.823383, 3.126806, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.156367, 1.081232, -0.066958>, <-0.377048, 1.081232, -0.227501>, <-0.700661, 1.081232, -0.181950>, <-0.854836, 1.081232, 0.043226>, 
      <-0.091347, 1.516885, 0.025278>, <-0.312028, 1.516885, -0.135265>, <-0.491255, 1.630623, -0.119685>, <-0.645429, 1.630623, 0.105491>, 
      <0.625591, 1.708398, 0.342953>, <0.815244, 1.708398, 0.146724>, <0.630723, 1.649599, -0.013760>, <0.429157, 1.649599, -0.197731>, 
      <0.814019, 2.104019, 0.445460>, <1.003672, 2.104019, 0.249231>, <1.003535, 2.104019, -0.077573>, <0.801970, 2.104019, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.156367, 1.081232, -0.066958>, <-0.211268, 0.713382, -0.144839>, <0.326766, 0.337743, -0.017672>, <0.500000, 0.000000, 0.000000>, 
      <-0.377048, 1.081232, -0.227501>, <-0.431948, 0.713382, -0.305381>, <0.326766, 0.337743, -0.290571>, <0.500000, 0.000000, -0.272899>, 
      <-0.700661, 1.081232, -0.181950>, <-0.858081, 0.668232, -0.228757>, <0.039983, 0.348506, -0.359852>, <0.272788, 0.000000, -0.507794>, 
      <-0.854836, 1.081232, 0.043226>, <-1.012256, 0.668232, -0.003581>, <-0.232805, 0.348506, -0.352058>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217716, 1.081232, 0.506724>, <-0.091919, 1.081232, 0.322995>, <0.023694, 1.081232, 0.064035>, <-0.156367, 1.081232, -0.066958>, 
      <-0.176501, 1.422066, 0.509495>, <-0.050704, 1.422066, 0.325766>, <0.088714, 1.516885, 0.156270>, <-0.091347, 1.516885, 0.025278>, 
      <0.176391, 1.771232, 0.337190>, <0.340855, 1.771232, 0.487299>, <0.470847, 1.708398, 0.503064>, <0.625591, 1.708398, 0.342953>, 
      <0.254429, 2.104019, 0.304983>, <0.418893, 2.104019, 0.455091>, <0.659275, 2.104019, 0.605570>, <0.814019, 2.104019, 0.445460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217716, 1.081232, 0.506724>, <-0.258211, 0.746352, 0.504002>, <-0.055791, 0.327924, 0.343959>, <0.000000, 0.000000, 0.287879>, 
      <-0.091919, 1.081232, 0.322995>, <-0.132415, 0.746352, 0.320273>, <0.166786, 0.327924, 0.337600>, <0.222577, 0.000000, 0.281520>, 
      <0.023694, 1.081232, 0.064035>, <-0.031206, 0.713382, -0.013846>, <0.326766, 0.337743, 0.204996>, <0.500000, 0.000000, 0.222668>, 
      <-0.156367, 1.081232, -0.066958>, <-0.211268, 0.713382, -0.144839>, <0.326766, 0.337743, -0.017672>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.563259, 1.081232, 0.948604>, <-0.352233, 1.081232, 0.703189>, <-0.217716, 1.081232, 0.506724>, 
      <-0.620680, 1.562332, 0.739905>, <-0.428137, 1.562332, 0.879978>, <-0.311017, 1.422066, 0.705960>, <-0.176501, 1.422066, 0.509495>, 
      <-0.136006, 1.682913, -0.047501>, <-0.301477, 1.682913, 0.123708>, <0.000526, 1.771232, 0.176676>, <0.176391, 1.771232, 0.337190>, 
      <0.030328, 2.104019, -0.269824>, <-0.135143, 2.104019, -0.098615>, <0.078564, 2.104019, 0.144469>, <0.254429, 2.104019, 0.304983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.864006, 0.695973, 0.863486>, <-0.612807, 0.342219, 0.238422>, <-0.560606, 0.000000, 0.030303>, 
      <-0.563259, 1.081232, 0.948604>, <-0.671463, 0.695973, 1.003559>, <-0.612807, 0.342219, 0.476525>, <-0.560606, 0.000000, 0.268407>, 
      <-0.352233, 1.081232, 0.703189>, <-0.392728, 0.746352, 0.700467>, <-0.293797, 0.327924, 0.350760>, <-0.238007, 0.000000, 0.294679>, 
      <-0.217716, 1.081232, 0.506724>, <-0.258211, 0.746352, 0.504002>, <-0.055791, 0.327924, 0.343959>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.620680, 1.562332, 0.739905>, <-0.136006, 1.682913, -0.047501>, <0.030328, 2.104019, -0.269824>, 
      <-0.996637, 1.081232, 0.633326>, <-0.861516, 1.562332, 0.564700>, <0.070968, 1.682913, -0.261651>, <0.237302, 2.104019, -0.483975>, 
      <-1.023091, 1.081232, 0.288967>, <-0.813685, 1.630623, 0.351231>, <0.209183, 1.649599, -0.398504>, <0.581996, 2.104019, -0.462317>, 
      <-0.854836, 1.081232, 0.043226>, <-0.645429, 1.630623, 0.105491>, <0.429157, 1.649599, -0.197731>, <0.801970, 2.104019, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.996637, 1.081232, 0.633326>, <-1.023091, 1.081232, 0.288967>, <-0.854836, 1.081232, 0.043226>, 
      <-0.864006, 0.695973, 0.863486>, <-1.104841, 0.695973, 0.688281>, <-1.180511, 0.668232, 0.242160>, <-1.012256, 0.668232, -0.003581>, 
      <-0.612807, 0.342219, 0.238422>, <-0.612807, 0.342219, -0.059401>, <-0.530507, 0.348506, -0.343552>, <-0.232805, 0.348506, -0.352058>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.04242, -0.064368, 0.015153>
}
#declare segMstraightMB1 = union {
  object { Blatt45 }
  object { // Blatt46->Blatt47
    Blatt47
    rotate <290.177673, -177.468506, 148.539398>
    translate  <2.340326, 3.191692, 3.150205>
  }
  object { Blatt47 }
  object { sPatchObj16 }
  translate  <-0.15, 0.75, 67.9>
}
#declare smallMstalk = union {
  object { segMstraightMA2 }
  object { segMstraightMB1 }
  object { // Blatt90->Blatt45
    Blatt45
    rotate <1.569541, -14.194149, 38.043385>
    translate  <-0.640194, 0.639822, 71.943039>
  }
  scale 10.0
  rotate -0.452962*z
  translate  <-191.475573, -240.193352, -293.799489>
}
#declare legMconnector = union {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG005 = union {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG006 = difference {
  object { CSG005 }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow = union {
  object { CSG006 }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 54.919292*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG011 = difference {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG012 = union {
  object { CSG011 }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG007 = union {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG008 = difference {
  object { CSG007 }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG015 = difference {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG016 = union {
  object { CSG015 }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid = union {
  object { CSG012 }
  object { CSG008 }
  object { CSG016 }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA = union {
  object { legseglow }
  object { legsegmid }
  // Scaling fixed
  // Translation fixed
  rotate -312.834717*z
}
#declare CSG009 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG010 = difference {
  object { CSG009 }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG013 = difference {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG014 = union {
  object { CSG013 }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG017 = difference {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG018 = union {
  object { CSG017 }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh = union {
  object { CSG010 }
  object { CSG014 }
  object { CSG018 }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB = union {
  object { legMsegMA }
  object { legseghigh }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 368.065033*z
  translate  3.1*x
}
#declare gelenk = union {
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein = union {
  object { legMsegMB }
  object { gelenk }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 18.989019>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly = union {
  object { legMconnector }
  object { Bein }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, -0.8, 0.017874>
}
#declare CSG073 = difference {
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 4.7, 20.0>
    rotate -90.0*x
    translate  <1.8, -5.76, 0.0>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 10.3, 0.7>
    translate  <1.6, 4.2, 4.2>
  }
  scale <1.0, 0.625, 1.0>
}
#declare crawlersegbody = union {
  sphere { // Sphere001
    <0,0,0>,1
    scale <4.3, 2.6, 2.8>
    translate  <2.0, -4.5, 0.0>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    material {
      crawlerMskin
    }
    scale <5.3, 5.8, 1.0>
    translate  <1.8, 2.7, 3.3>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    scale <5.0, 3.3, 14.2>
    rotate -90.0*x
    translate  <1.9, -4.5, 0.0>
  }
  object { CSG073 }
  object { // TText002->TText001
    TText001
    rotate <0.0, -0.015323, -180.0>
    translate  <3.3692, 2.682384, -0.025046>
  }
  object { TText001 }
  scale <1.0, 1.6, 1.0>
}
#declare Group007 = union {
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group008 = union {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe3 = union {
  object { Group007 }
  object { Group008 }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container3 = union {
  object { Containerframe3 }
  box { // Containerbody3
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 8.7, 5.1>
}
#declare Group005 = union {
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group006 = union {
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe2 = union {
  object { Group005 }
  object { Group006 }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container2 = union {
  object { Containerframe2 }
  box { // Containerbody2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 8.7, 5.1>
}
#declare Group003 = union {
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group004 = union {
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe1 = union {
  object { Group003 }
  object { Group004 }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container1 = union {
  object { Containerframe1 }
  box { // Containerbody1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 0.0, 5.1>
}
#declare Group002 = union {
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group001 = union {
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe = union {
  object { Group002 }
  object { Group001 }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container = union {
  object { Containerframe }
  box { // Containerbody
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 0.0, 5.1>
}
#declare Containergroup = union {
  object { Container3 }
  object { Container2 }
  object { Container1 }
  object { Container }
  scale <1.5, 1.2, 1.5>
  translate  <-0.834685, -0.955352, 0.309442>
}
#declare legMconnector1 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG019 = union {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG020 = difference {
  object { CSG019 }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow1 = union {
  object { CSG020 }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 41.248531*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG021 = difference {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG022 = union {
  object { CSG021 }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG023 = union {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG024 = difference {
  object { CSG023 }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG025 = difference {
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG026 = union {
  object { CSG025 }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid1 = union {
  object { CSG022 }
  object { CSG024 }
  object { CSG026 }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA1 = union {
  object { legseglow1 }
  object { legsegmid1 }
  // Scaling fixed
  // Translation fixed
  rotate -362.901947*z
}
#declare CSG027 = union {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG028 = difference {
  object { CSG027 }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG029 = difference {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG030 = union {
  object { CSG029 }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG031 = difference {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG032 = union {
  object { CSG031 }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh1 = union {
  object { CSG028 }
  object { CSG030 }
  object { CSG032 }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB1 = union {
  object { legMsegMA1 }
  object { legseghigh1 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 422.509064*z
  translate  3.1*x
}
#declare gelenk1 = union {
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein1 = union {
  object { legMsegMB1 }
  object { gelenk1 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.22089>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly1 = union {
  object { legMconnector1 }
  object { Bein1 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, 9.125889, 0.017874>
}
#declare legMconnector2 = union {
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG033 = union {
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG034 = difference {
  object { CSG033 }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow2 = union {
  object { CSG034 }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 33.588139*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG035 = difference {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG036 = union {
  object { CSG035 }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG037 = union {
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG038 = difference {
  object { CSG037 }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG039 = difference {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG040 = union {
  object { CSG039 }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid2 = union {
  object { CSG036 }
  object { CSG038 }
  object { CSG040 }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA2 = union {
  object { legseglow2 }
  object { legsegmid2 }
  // Scaling fixed
  // Translation fixed
  rotate 49.411064*z
}
#declare CSG041 = union {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG042 = difference {
  object { CSG041 }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG043 = difference {
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG044 = union {
  object { CSG043 }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG045 = difference {
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG046 = union {
  object { CSG045 }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh2 = union {
  object { CSG042 }
  object { CSG044 }
  object { CSG046 }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB2 = union {
  object { legMsegMA2 }
  object { legseghigh2 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 361.123444*z
  translate  3.1*x
}
#declare gelenk2 = union {
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein2 = union {
  object { legMsegMB2 }
  object { gelenk2 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, -10.124236>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly2 = union {
  object { legMconnector2 }
  object { Bein2 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, 9.125889, 0.017874>
}
#declare legMconnector3 = union {
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG047 = union {
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG048 = difference {
  object { CSG047 }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow3 = union {
  object { CSG048 }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 56.243031*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG049 = difference {
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG050 = union {
  object { CSG049 }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG051 = union {
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG052 = difference {
  object { CSG051 }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG053 = difference {
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG054 = union {
  object { CSG053 }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid3 = union {
  object { CSG050 }
  object { CSG052 }
  object { CSG054 }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA3 = union {
  object { legseglow3 }
  object { legsegmid3 }
  // Scaling fixed
  // Translation fixed
  rotate -357.48233*z
}
#declare CSG055 = union {
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG056 = difference {
  object { CSG055 }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG057 = difference {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG058 = union {
  object { CSG057 }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG059 = difference {
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG060 = union {
  object { CSG059 }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh3 = union {
  object { CSG056 }
  object { CSG058 }
  object { CSG060 }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB3 = union {
  object { legMsegMA3 }
  object { legseghigh3 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 377.385406*z
  translate  3.1*x
}
#declare gelenk3 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein3 = union {
  object { legMsegMB3 }
  object { gelenk3 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, -59.425926>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly3 = union {
  object { legMconnector3 }
  object { Bein3 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, -0.702687, 0.017874>
}
#declare crawlerMseg = union {
  object { legMassembly }
  object { crawlersegbody }
  object { Containergroup }
  object { legMassembly1 }
  object { legMassembly2 }
  object { legMassembly3 }
  material {
    crawlerMskin
  }
  scale 0.7
  rotate <-91.900291, -0.0, 140.097626>
  translate  <-203.22339, -260.30671, 394.119936>
}
#declare legMconnector4 = union {
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG061 = union {
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG062 = difference {
  object { CSG061 }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow4 = union {
  object { CSG062 }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 54.919292*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG063 = difference {
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG064 = union {
  object { CSG063 }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG065 = union {
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG066 = difference {
  object { CSG065 }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG067 = difference {
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG068 = union {
  object { CSG067 }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid4 = union {
  object { CSG064 }
  object { CSG066 }
  object { CSG068 }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA4 = union {
  object { legseglow4 }
  object { legsegmid4 }
  // Scaling fixed
  // Translation fixed
  rotate -312.834717*z
}
#declare CSG069 = union {
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG070 = difference {
  object { CSG069 }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG071 = difference {
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG072 = union {
  object { CSG071 }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG074 = difference {
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG075 = union {
  object { CSG074 }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh4 = union {
  object { CSG070 }
  object { CSG072 }
  object { CSG075 }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB4 = union {
  object { legMsegMA4 }
  object { legseghigh4 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 368.065033*z
  translate  3.1*x
}
#declare gelenk4 = union {
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein4 = union {
  object { legMsegMB4 }
  object { gelenk4 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 18.989019>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly4 = union {
  object { legMconnector4 }
  object { Bein4 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, -0.8, 0.017874>
}
#declare CSG076 = difference {
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 4.7, 20.0>
    rotate -90.0*x
    translate  <1.8, -5.76, 0.0>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 10.3, 0.7>
    translate  <1.6, 4.2, 4.2>
  }
  scale <1.0, 0.625, 1.0>
}
#declare crawlersegbody1 = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale <4.3, 2.6, 2.8>
    translate  <2.0, -4.5, 0.0>
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    material {
      crawlerMskin
    }
    scale <5.3, 5.8, 1.0>
    translate  <1.8, 2.7, 3.3>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    scale <5.0, 3.3, 14.2>
    rotate -90.0*x
    translate  <1.9, -4.5, 0.0>
  }
  object { CSG076 }
  object { // TText003->TText001
    TText001
    rotate <0.0, -0.015323, -180.0>
    translate  <3.3692, 2.682384, -0.025046>
  }
  text {   // TText004
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Space Crawler",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Red
    }
    scale <1.5, 1.5, 1.0>
    rotate <33.293095, 0.0, -90.0>
    translate  <-7.121753, 6.172618, 2.598728>
  }

  scale <1.0, 1.6, 1.0>
}
#declare Group009 = union {
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group010 = union {
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe4 = union {
  object { Group009 }
  object { Group010 }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container4 = union {
  object { Containerframe4 }
  box { // Containerbody4
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 8.7, 5.1>
}
#declare Group011 = union {
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group012 = union {
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe5 = union {
  object { Group011 }
  object { Group012 }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container5 = union {
  object { Containerframe5 }
  box { // Containerbody5
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 8.7, 5.1>
}
#declare Group013 = union {
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group014 = union {
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe6 = union {
  object { Group013 }
  object { Group014 }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container6 = union {
  object { Containerframe6 }
  box { // Containerbody6
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 0.0, 5.1>
}
#declare Group015 = union {
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group016 = union {
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe7 = union {
  object { Group015 }
  object { Group016 }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container7 = union {
  object { Containerframe7 }
  box { // Containerbody7
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 0.0, 5.1>
}
#declare Containergroup1 = union {
  object { Container4 }
  object { Container5 }
  object { Container6 }
  object { Container7 }
  scale <1.5, 1.2, 1.5>
  translate  <-0.834685, -0.955352, 0.309442>
}
#declare legMconnector5 = union {
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG077 = union {
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG078 = difference {
  object { CSG077 }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow5 = union {
  object { CSG078 }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 41.248531*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG079 = difference {
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG080 = union {
  object { CSG079 }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG081 = union {
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG082 = difference {
  object { CSG081 }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG083 = difference {
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG084 = union {
  object { CSG083 }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid5 = union {
  object { CSG080 }
  object { CSG082 }
  object { CSG084 }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA5 = union {
  object { legseglow5 }
  object { legsegmid5 }
  // Scaling fixed
  // Translation fixed
  rotate -362.901947*z
}
#declare CSG085 = union {
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG086 = difference {
  object { CSG085 }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG087 = difference {
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG088 = union {
  object { CSG087 }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG089 = difference {
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG090 = union {
  object { CSG089 }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh5 = union {
  object { CSG086 }
  object { CSG088 }
  object { CSG090 }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB5 = union {
  object { legMsegMA5 }
  object { legseghigh5 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 422.509064*z
  translate  3.1*x
}
#declare gelenk5 = union {
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein5 = union {
  object { legMsegMB5 }
  object { gelenk5 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.22089>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly5 = union {
  object { legMconnector5 }
  object { Bein5 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, 9.125889, 0.017874>
}
#declare legMconnector6 = union {
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG091 = union {
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG092 = difference {
  object { CSG091 }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow6 = union {
  object { CSG092 }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 33.588139*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG093 = difference {
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG094 = union {
  object { CSG093 }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG095 = union {
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG096 = difference {
  object { CSG095 }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG097 = difference {
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG098 = union {
  object { CSG097 }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid6 = union {
  object { CSG094 }
  object { CSG096 }
  object { CSG098 }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA6 = union {
  object { legseglow6 }
  object { legsegmid6 }
  // Scaling fixed
  // Translation fixed
  rotate 49.411064*z
}
#declare CSG099 = union {
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG100 = difference {
  object { CSG099 }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG101 = difference {
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG102 = union {
  object { CSG101 }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG103 = difference {
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG104 = union {
  object { CSG103 }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh6 = union {
  object { CSG100 }
  object { CSG102 }
  object { CSG104 }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB6 = union {
  object { legMsegMA6 }
  object { legseghigh6 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 361.123444*z
  translate  3.1*x
}
#declare gelenk6 = union {
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein6 = union {
  object { legMsegMB6 }
  object { gelenk6 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, -10.124236>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly6 = union {
  object { legMconnector6 }
  object { Bein6 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, 9.125889, 0.017874>
}
#declare legMconnector7 = union {
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG105 = union {
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG106 = difference {
  object { CSG105 }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow7 = union {
  object { CSG106 }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 60.822308*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG107 = difference {
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG108 = union {
  object { CSG107 }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG109 = union {
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG110 = difference {
  object { CSG109 }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG111 = difference {
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG112 = union {
  object { CSG111 }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid7 = union {
  object { CSG108 }
  object { CSG110 }
  object { CSG112 }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA7 = union {
  object { legseglow7 }
  object { legsegmid7 }
  // Scaling fixed
  // Translation fixed
  rotate -369.198181*z
}
#declare CSG113 = union {
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG114 = difference {
  object { CSG113 }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG115 = difference {
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG116 = union {
  object { CSG115 }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG117 = difference {
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG118 = union {
  object { CSG117 }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh7 = union {
  object { CSG114 }
  object { CSG116 }
  object { CSG118 }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB7 = union {
  object { legMsegMA7 }
  object { legseghigh7 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 416.493835*z
  translate  3.1*x
}
#declare gelenk7 = union {
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein7 = union {
  object { legMsegMB7 }
  object { gelenk7 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.223825>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly7 = union {
  object { legMconnector7 }
  object { Bein7 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, -0.702687, 0.017874>
}
#declare crawlerMseg1 = union {
  object { legMassembly4 }
  object { crawlersegbody1 }
  object { Containergroup1 }
  object { legMassembly5 }
  object { legMassembly6 }
  object { legMassembly7 }
  material {
    crawlerMskin
  }
  scale 0.7
  rotate <-84.534019, -8.58044, 139.091309>
  translate  <-204.230782, -257.914184, 376.992808>
}
#declare CrawlerMFront = difference {
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 5.0>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 6.0>
    rotate -18.0*z
    translate  <4.5, 12.0, 0.0>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 6.0>
    rotate 18.0*z
    translate  <4.5, -12.0, 0.0>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <6.940049, 11.99824, 1.970962>
    rotate 15.601972*y
    translate  <7.384533, 0.0, 5.49912>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    scale <6.940049, 11.99824, 1.970962>
    rotate <180.0, 55.943863, 180.0>
    translate  <9.793671, 0.0, -4.242179>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <-16.397465, -6.141892, -3.308892>
    rotate 22.957012*x
    translate  <3.0, -10.0, 6.0>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <-16.397465, -6.141892, -3.308892>
    rotate -22.95701*x
    translate  <3.0, 10.0, 6.0>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <-16.397465, -6.141892, -3.308892>
    rotate -22.95701*x
    translate  <3.0, -10.0, -6.5>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <-16.397465, -6.141892, -3.308892>
    rotate 22.95701*x
    translate  <3.0, 10.0, -6.5>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    scale <6.940049, 11.99824, 1.970962>
    rotate 56.217327*y
    translate  <10.317397, 0.0, 4.870649>
  }
  material {
    crawlerMskin
  }
  scale <1.0, 1.2, 0.7>
  translate  <1.008022, 0.0, -1.541596>
}
#declare CSG119 = difference {
  object { CrawlerMFront }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    material {
      DullMGrey
    }
    scale <5.0, 5.580701, 3.462207>
    translate  <-2.199648, 0.0, 1.780668>
  }
}
#declare Kabine = difference {
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    material {
      ColoredMGlass
    }
    scale 5.0
    translate  <-0.0, -0.106416, 0.744914>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    scale <3.246263, 6.597623, -2.498926>
    rotate <0.0, -60.0, -0.0>
    translate  <-5.5, 0.0, 6.0>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    scale <3.246263, 6.597623, -2.498926>
    rotate 60.0*y
    translate  <5.5, 0.0, 6.0>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    scale <5.240205, 6.597623, -3.692235>
    rotate <0.0, 64.962128, -90.0>
    translate  <-0.963337, -7.180548, 2.909225>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    scale <3.246263, 6.597623, -2.498926>
    rotate <0.0, -45.0, -90.0>
    translate  <-0.963337, 6.436256, 5.87041>
  }
  material {
    ColoredMGlass
  }
  scale <1.4, 1.4, 0.5>
  rotate 90.0*z
  translate  <-2.157164, 0.0, 2.407151>
}
#declare CrawlerMHead = union {
  object { CSG119 }
  object { Kabine }
  object { // Pilotengruppe1->Pilotengruppe
    Pilotengruppe
    rotate <-0.0, -0.0, -0.0>
    translate  <0.046449, -5.087355, 0.0>
  }
  object { Pilotengruppe }
  text {   // TText005
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Space Crawler",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Red
    }
    scale <2.0, 2.0, 1.5>
    rotate <11.071515, 0.0, 90.0>
    translate  <7.330987, -6.7671, 1.016607>
  }

  scale 0.7
  rotate <-159.346298, -103.752838, 218.921249>
  translate  <-204.44437, -259.990797, 406.186282>
}
#declare legMconnector8 = union {
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG120 = union {
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG121 = difference {
  object { CSG120 }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow8 = union {
  object { CSG121 }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 54.919292*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG122 = difference {
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG123 = union {
  object { CSG122 }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG124 = union {
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG125 = difference {
  object { CSG124 }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG126 = difference {
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG127 = union {
  object { CSG126 }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid8 = union {
  object { CSG123 }
  object { CSG125 }
  object { CSG127 }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA8 = union {
  object { legseglow8 }
  object { legsegmid8 }
  // Scaling fixed
  // Translation fixed
  rotate -312.834717*z
}
#declare CSG128 = union {
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG129 = difference {
  object { CSG128 }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG130 = difference {
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG131 = union {
  object { CSG130 }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG132 = difference {
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG133 = union {
  object { CSG132 }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh8 = union {
  object { CSG129 }
  object { CSG131 }
  object { CSG133 }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB8 = union {
  object { legMsegMA8 }
  object { legseghigh8 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 368.065033*z
  translate  3.1*x
}
#declare gelenk8 = union {
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein10 = union {
  object { legMsegMB8 }
  object { gelenk8 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 18.989019>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly8 = union {
  object { legMconnector8 }
  object { Bein10 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, -0.8, 0.017874>
}
#declare CSG134 = difference {
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 4.7, 20.0>
    rotate -90.0*x
    translate  <1.8, -5.76, 0.0>
  }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 10.3, 0.7>
    translate  <1.6, 4.2, 4.2>
  }
  scale <1.0, 0.625, 1.0>
}
#declare crawlersegbody2 = union {
  sphere { // Sphere003
    <0,0,0>,1
    scale <4.3, 2.6, 2.8>
    translate  <2.0, -4.5, 0.0>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    material {
      crawlerMskin
    }
    scale <5.3, 5.8, 1.0>
    translate  <1.8, 2.7, 3.3>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    scale <5.0, 3.3, 14.2>
    rotate -90.0*x
    translate  <1.9, -4.5, 0.0>
  }
  object { CSG134 }
  object { // TText006->TText001
    TText001
    rotate <0.0, -0.015323, -180.0>
    translate  <3.3692, 2.682384, -0.025046>
  }
  text {   // TText007
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Space Crawler",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Red
    }
    scale <1.5, 1.5, 1.0>
    rotate <33.293095, 0.0, -90.0>
    translate  <-7.121753, 6.172618, 2.598728>
  }

  scale <1.0, 1.6, 1.0>
}
#declare Group017 = union {
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group018 = union {
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe8 = union {
  object { Group017 }
  object { Group018 }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container8 = union {
  object { Containerframe8 }
  box { // Containerbody8
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 8.7, 5.1>
}
#declare Group019 = union {
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group020 = union {
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe9 = union {
  object { Group019 }
  object { Group020 }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container9 = union {
  object { Containerframe9 }
  box { // Containerbody9
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 8.7, 5.1>
}
#declare Group021 = union {
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group022 = union {
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe10 = union {
  object { Group021 }
  object { Group022 }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container10 = union {
  object { Containerframe10 }
  box { // Containerbody10
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 0.0, 5.1>
}
#declare Group023 = union {
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group024 = union {
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe11 = union {
  object { Group023 }
  object { Group024 }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container11 = union {
  object { Containerframe11 }
  box { // Containerbody11
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 0.0, 5.1>
}
#declare Containergroup2 = union {
  object { Container8 }
  object { Container9 }
  object { Container10 }
  object { Container11 }
  scale <1.5, 1.2, 1.5>
  translate  <-0.834685, -0.955352, 0.309442>
}
#declare legMconnector9 = union {
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG135 = union {
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG136 = difference {
  object { CSG135 }
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow9 = union {
  object { CSG136 }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 41.248531*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG137 = difference {
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG138 = union {
  object { CSG137 }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG139 = union {
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG140 = difference {
  object { CSG139 }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG141 = difference {
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG142 = union {
  object { CSG141 }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid9 = union {
  object { CSG138 }
  object { CSG140 }
  object { CSG142 }
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA9 = union {
  object { legseglow9 }
  object { legsegmid9 }
  // Scaling fixed
  // Translation fixed
  rotate -362.901947*z
}
#declare CSG143 = union {
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG144 = difference {
  object { CSG143 }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG145 = difference {
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG146 = union {
  object { CSG145 }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG147 = difference {
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG148 = union {
  object { CSG147 }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh9 = union {
  object { CSG144 }
  object { CSG146 }
  object { CSG148 }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB9 = union {
  object { legMsegMA9 }
  object { legseghigh9 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 422.509064*z
  translate  3.1*x
}
#declare gelenk9 = union {
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein11 = union {
  object { legMsegMB9 }
  object { gelenk9 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.22089>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly9 = union {
  object { legMconnector9 }
  object { Bein11 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, 9.125889, 0.017874>
}
#declare legMconnector10 = union {
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG149 = union {
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG150 = difference {
  object { CSG149 }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow10 = union {
  object { CSG150 }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 33.588139*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG151 = difference {
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG152 = union {
  object { CSG151 }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG153 = union {
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG154 = difference {
  object { CSG153 }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG155 = difference {
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG156 = union {
  object { CSG155 }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid10 = union {
  object { CSG152 }
  object { CSG154 }
  object { CSG156 }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA10 = union {
  object { legseglow10 }
  object { legsegmid10 }
  // Scaling fixed
  // Translation fixed
  rotate 49.411064*z
}
#declare CSG157 = union {
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG158 = difference {
  object { CSG157 }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG159 = difference {
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG160 = union {
  object { CSG159 }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG161 = difference {
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG162 = union {
  object { CSG161 }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh10 = union {
  object { CSG158 }
  object { CSG160 }
  object { CSG162 }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB10 = union {
  object { legMsegMA10 }
  object { legseghigh10 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 361.123444*z
  translate  3.1*x
}
#declare gelenk10 = union {
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein12 = union {
  object { legMsegMB10 }
  object { gelenk10 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, -10.124236>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly10 = union {
  object { legMconnector10 }
  object { Bein12 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, 9.125889, 0.017874>
}
#declare legMconnector11 = union {
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG163 = union {
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG164 = difference {
  object { CSG163 }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow11 = union {
  object { CSG164 }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 60.822308*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG165 = difference {
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG166 = union {
  object { CSG165 }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG167 = union {
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG168 = difference {
  object { CSG167 }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG169 = difference {
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG170 = union {
  object { CSG169 }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid11 = union {
  object { CSG166 }
  object { CSG168 }
  object { CSG170 }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA11 = union {
  object { legseglow11 }
  object { legsegmid11 }
  // Scaling fixed
  // Translation fixed
  rotate -369.198181*z
}
#declare CSG171 = union {
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG172 = difference {
  object { CSG171 }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG173 = difference {
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG174 = union {
  object { CSG173 }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG175 = difference {
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG176 = union {
  object { CSG175 }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh11 = union {
  object { CSG172 }
  object { CSG174 }
  object { CSG176 }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB11 = union {
  object { legMsegMA11 }
  object { legseghigh11 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 416.493835*z
  translate  3.1*x
}
#declare gelenk11 = union {
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein13 = union {
  object { legMsegMB11 }
  object { gelenk11 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.223825>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly11 = union {
  object { legMconnector11 }
  object { Bein13 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, -0.702687, 0.017874>
}
#declare crawlerMseg2 = union {
  object { legMassembly8 }
  object { crawlersegbody2 }
  object { Containergroup2 }
  object { legMassembly9 }
  object { legMassembly10 }
  object { legMassembly11 }
  material {
    crawlerMskin
  }
  scale 0.7
  rotate <-92.005943, 2.058242, 150.312576>
  translate  <-207.124896, -261.256956, 361.328262>
}
#declare legMconnector12 = union {
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG177 = union {
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG178 = difference {
  object { CSG177 }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow12 = union {
  object { CSG178 }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 54.919292*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG179 = difference {
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG180 = union {
  object { CSG179 }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG181 = union {
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG182 = difference {
  object { CSG181 }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG183 = difference {
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG184 = union {
  object { CSG183 }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid12 = union {
  object { CSG180 }
  object { CSG182 }
  object { CSG184 }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA12 = union {
  object { legseglow12 }
  object { legsegmid12 }
  // Scaling fixed
  // Translation fixed
  rotate -312.834717*z
}
#declare CSG185 = union {
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG186 = difference {
  object { CSG185 }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG187 = difference {
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG188 = union {
  object { CSG187 }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG189 = difference {
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG190 = union {
  object { CSG189 }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh12 = union {
  object { CSG186 }
  object { CSG188 }
  object { CSG190 }
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB12 = union {
  object { legMsegMA12 }
  object { legseghigh12 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 368.065033*z
  translate  3.1*x
}
#declare gelenk12 = union {
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein14 = union {
  object { legMsegMB12 }
  object { gelenk12 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 18.989019>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly12 = union {
  object { legMconnector12 }
  object { Bein14 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, -0.8, 0.017874>
}
#declare CSG191 = difference {
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 4.7, 20.0>
    rotate -90.0*x
    translate  <1.8, -5.76, 0.0>
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    scale <7.2, 10.3, 0.7>
    translate  <1.6, 4.2, 4.2>
  }
  scale <1.0, 0.625, 1.0>
}
#declare crawlersegbody3 = union {
  sphere { // Sphere004
    <0,0,0>,1
    scale <4.3, 2.6, 2.8>
    translate  <2.0, -4.5, 0.0>
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    material {
      crawlerMskin
    }
    scale <5.3, 5.8, 1.0>
    translate  <1.8, 2.7, 3.3>
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    scale <5.0, 3.3, 14.2>
    rotate -90.0*x
    translate  <1.9, -4.5, 0.0>
  }
  object { CSG191 }
  object { // TText008->TText001
    TText001
    rotate <0.0, -0.015323, -180.0>
    translate  <3.3692, 2.682384, -0.025046>
  }
  text {   // TText009
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "Space Crawler",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Red
    }
    scale <1.5, 1.5, 1.0>
    rotate <33.293095, 0.0, -90.0>
    translate  <-7.121753, 6.172618, 2.598728>
  }

  scale <1.0, 1.6, 1.0>
}
#declare Group025 = union {
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group026 = union {
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe12 = union {
  object { Group025 }
  object { Group026 }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container12 = union {
  object { Containerframe12 }
  box { // Containerbody12
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 8.7, 5.1>
}
#declare Group027 = union {
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group028 = union {
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe13 = union {
  object { Group027 }
  object { Group028 }
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container13 = union {
  object { Containerframe13 }
  box { // Containerbody13
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 8.7, 5.1>
}
#declare Group029 = union {
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group030 = union {
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe14 = union {
  object { Group029 }
  object { Group030 }
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container14 = union {
  object { Containerframe14 }
  box { // Containerbody14
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <4.0, 0.0, 5.1>
}
#declare Group031 = union {
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
  translate  -4.0*y
}
#declare Group032 = union {
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, -1.0>
  }
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    scale <1.1, 0.1, 0.1>
    translate  <0.0, 2.0, 1.0>
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <-1.0, 2.0, 0.0>
  }
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 1.1>
    translate  <1.0, 2.0, 0.0>
  }
}
#declare Containerframe15 = union {
  object { Group031 }
  object { Group032 }
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, -1.0>
  }
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, -1.0>
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.1>
    translate  <1.0, 0.0, 1.0>
  }
  material {
    Rust
  }
}
#declare Container15 = union {
  object { Containerframe15 }
  box { // Containerbody15
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rust_Ripple
    }
    scale <1.0, 2.0, 1.0>
  }
  material {
    Rust
  }
  scale 2.0
  translate  <-0.7, 0.0, 5.1>
}
#declare Containergroup3 = union {
  object { Container12 }
  object { Container13 }
  object { Container14 }
  object { Container15 }
  scale <1.5, 1.2, 1.5>
  translate  <-0.834685, -0.955352, 0.309442>
}
#declare legMconnector13 = union {
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG192 = union {
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG193 = difference {
  object { CSG192 }
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow13 = union {
  object { CSG193 }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 41.248531*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG194 = difference {
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG195 = union {
  object { CSG194 }
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG196 = union {
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG197 = difference {
  object { CSG196 }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG198 = difference {
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG199 = union {
  object { CSG198 }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid13 = union {
  object { CSG195 }
  object { CSG197 }
  object { CSG199 }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA13 = union {
  object { legseglow13 }
  object { legsegmid13 }
  // Scaling fixed
  // Translation fixed
  rotate -362.901947*z
}
#declare CSG200 = union {
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG201 = difference {
  object { CSG200 }
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG202 = difference {
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG203 = union {
  object { CSG202 }
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG204 = difference {
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG205 = union {
  object { CSG204 }
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh13 = union {
  object { CSG201 }
  object { CSG203 }
  object { CSG205 }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB13 = union {
  object { legMsegMA13 }
  object { legseghigh13 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 422.509064*z
  translate  3.1*x
}
#declare gelenk13 = union {
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein15 = union {
  object { legMsegMB13 }
  object { gelenk13 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.22089>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly13 = union {
  object { legMconnector13 }
  object { Bein15 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate -33.459747*y
  translate  <-3.258331, 9.125889, 0.017874>
}
#declare legMconnector14 = union {
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG206 = union {
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG207 = difference {
  object { CSG206 }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow14 = union {
  object { CSG207 }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 33.588139*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG208 = difference {
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG209 = union {
  object { CSG208 }
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG210 = union {
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG211 = difference {
  object { CSG210 }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG212 = difference {
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG213 = union {
  object { CSG212 }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid14 = union {
  object { CSG209 }
  object { CSG211 }
  object { CSG213 }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA14 = union {
  object { legseglow14 }
  object { legsegmid14 }
  // Scaling fixed
  // Translation fixed
  rotate 49.411064*z
}
#declare CSG214 = union {
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG215 = difference {
  object { CSG214 }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG216 = difference {
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG217 = union {
  object { CSG216 }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG218 = difference {
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG219 = union {
  object { CSG218 }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh14 = union {
  object { CSG215 }
  object { CSG217 }
  object { CSG219 }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB14 = union {
  object { legMsegMA14 }
  object { legseghigh14 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 361.123444*z
  translate  3.1*x
}
#declare gelenk14 = union {
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein16 = union {
  object { legMsegMB14 }
  object { gelenk14 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, -10.124236>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly14 = union {
  object { legMconnector14 }
  object { Bein16 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, 9.125889, 0.017874>
}
#declare legMconnector15 = union {
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.6, 2.7, 2.3>
    translate  <7.0, 0.0, 0.4>
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, -1.2>
  }
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    material {
      attention
    }
    // All transformations fixed
    scale <1.6, 2.0, 1.0>
    translate  <6.4, 0.0, 1.0>
  }
  // All transformations fixed
}
#declare CSG220 = union {
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    material {
      attention
    }
    // All transformations fixed
    scale <2.0, 0.6, 0.5>
    translate  <-4.913717, 0.0, 0.5>
  }
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.75, 0.75, 1.0>
    translate  -3.1*x
  }
  // All transformations fixed
}
#declare CSG221 = difference {
  object { CSG220 }
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale 0.6
    rotate -45.0*z
    translate  <-7.038863, 0.7, 0.5>
  }
  // All transformations fixed
  translate  <0.222858, 0.0, 0.0>
}
#declare legseglow15 = union {
  object { CSG221 }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 2.9>
    translate  <-2.8, 0.0, -0.925>
  }
  rotate -0.0*z
  translate  <2.788005, 0.001293, -0.002733>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate 60.822308*z
  translate  <-2.888005, -0.001293, 0.001366>
}
#declare CSG222 = difference {
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG223 = union {
  object { CSG222 }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  1.0*z
}
#declare CSG224 = union {
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.9, 0.9, 1.0>
    translate  -0.1*x
  }
  // All transformations fixed
}
#declare CSG225 = difference {
  object { CSG224 }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.2>
    translate  <-2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG226 = difference {
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 0.8, 0.5>
    translate  <-1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  -0.1*z
  }
  // All transformations fixed
}
#declare CSG227 = union {
  object { CSG226 }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.8, 0.8, 1.0>
    translate  -3.0*x
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.7>
  translate  -0.7*z
}
#declare legsegmid15 = union {
  object { CSG223 }
  object { CSG225 }
  object { CSG227 }
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 3.5>
    translate  -1.25*z
  }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.0>
    rotate -90.0*y
    translate  <-0.8, 0.8, 0.5>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
}
#declare legMsegMA15 = union {
  object { legseglow15 }
  object { legsegmid15 }
  // Scaling fixed
  // Translation fixed
  rotate -369.198181*z
}
#declare CSG228 = union {
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 1.0>
    translate  3.0*x
  }
  // All transformations fixed
}
#declare CSG229 = difference {
  object { CSG228 }
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.0, 1.0, 1.2>
    translate  <0.2, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG230 = difference {
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG231 = union {
  object { CSG230 }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  1.0*z
}
#declare CSG232 = difference {
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.5, 1.0, 0.5>
    translate  <1.5, 0.0, 0.5>
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale 1.2
    translate  <2.8, 0.0, -0.1>
  }
  // All transformations fixed
}
#declare CSG233 = union {
  object { CSG232 }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
  }
  // All transformations fixed
  translate  -1.0*z
}
#declare legseghigh15 = union {
  object { CSG229 }
  object { CSG231 }
  object { CSG233 }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.6, 0.2, 2.5>
    rotate -90.0*y
    translate  <2.8, 1.0, 0.5>
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.5, 0.5, 4.8>
    rotate <180.0, -0.0, -30.0>
    translate  <3.0, 0.0, 2.9>
  }
  // All transformations fixed
  scale <1.0, 1.0, 0.5>
  translate  0.1*x
}
#declare legMsegMB15 = union {
  object { legMsegMA15 }
  object { legseghigh15 }
  rotate -0.0*z
  translate  <-3.1, 0.0, 0.0>
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 2.0>
  rotate 416.493835*z
  translate  3.1*x
}
#declare gelenk15 = union {
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <6.0, -0.4, 0.3>
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, 0.55>
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <1.2, 1.2, 0.75>
    translate  <3.1, 0.0, -0.8>
  }
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, -0.5>
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <1.0, 0.5, 0.4>
    rotate <-0.0, -0.0, 0.0>
    translate  <4.7, 0.1, 1.0>
  }
  // All transformations fixed
  scale <1.0, 1.0, 2.0>
}
#declare Bein17 = union {
  object { legMsegMB15 }
  object { gelenk15 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-6.0, 0.0, -0.6>
  material {
    crawlerMskin
  }
  // Scaling fixed
  // Translation fixed
  scale <1.0, 1.0, 0.5>
  rotate <90.0, 0.0, 0.223825>
  translate  <6.0, 0.0, 0.3>
}
#declare legMassembly15 = union {
  object { legMconnector15 }
  object { Bein17 }
  rotate <0.0, 0.0, 0.0>
  translate  <-7.639042, 0.0, -0.535219>
  material {
    crawlerMskin
  }
  // All transformations fixed
  scale 2.0
  rotate <0.0, -33.459747, -180.0>
  translate  <6.570245, -0.702687, 0.017874>
}
#declare crawlerMseg3 = union {
  object { legMassembly12 }
  object { crawlersegbody3 }
  object { Containergroup3 }
  object { legMassembly13 }
  object { legMassembly14 }
  object { legMassembly15 }
  material {
    crawlerMskin
  }
  scale 0.7
  rotate <-99.478683, 14.783679, 149.20993>
  translate  <-204.878149, -261.256956, 345.101759>
}
#declare crawler = union {
  object { crawlerMseg }
  object { crawlerMseg1 }
  object { CrawlerMHead }
  object { crawlerMseg2 }
  object { crawlerMseg3 }
  rotate <0.0, 0.0, 0.0>
  translate  <203.475776, 254.188542, -379.455769>
  scale 0.8
  rotate <-0.117905, -0.011585, 24.121611>
  translate  <-190.305173, -254.226517, 383.33112>
}
union { // action
  object { smallMstalk }
  object { crawler }
  rotate <2.315258, 7.350279, 17.53793>
  translate  <91.352902, 233.471156, -83.427297>
}


#declare sPatchObj17 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.316323, -0.058464, 0.508489>, <0.164796, -0.058464, 0.735456>, <0.199995, -0.051711, 1.077744>, <0.431196, -0.051711, 1.222727>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.902234, -0.049748, 0.567079>, <0.713589, -0.049748, 0.448783>, <0.439959, -0.058464, 0.323300>, <0.316323, -0.058464, 0.508489>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.212851, -0.042017, 1.108256>, <1.345058, -0.042017, 0.910229>, <1.103956, -0.049748, 0.693576>, <0.902234, -0.049748, 0.567079>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.212851, -0.042017, 1.108256>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.047485, -0.042017, 1.355951>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.683513, -0.051711, 1.380951>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.431196, -0.051711, 1.222727>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>, 
      <0.154984, 5.626361, 0.730007>, <0.154984, 5.566828, 0.730007>, <0.155052, 5.486724, 0.720730>, <0.154984, 5.427918, 0.730007>, 
      <0.213551, 5.626361, 1.051520>, <0.213551, 5.566828, 1.051520>, <0.238801, 5.481828, 1.050949>, <0.213551, 5.427918, 1.051520>, 
      <0.444763, 5.626361, 1.196486>, <0.444763, 5.566828, 1.196486>, <0.470013, 5.481828, 1.195915>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>, 
      <0.693530, 5.626361, 0.422904>, <0.693530, 5.566828, 0.422904>, <0.704857, 5.480305, 0.396992>, <0.693530, 5.427918, 0.422904>, 
      <0.430117, 5.626361, 0.317830>, <0.430117, 5.566828, 0.317830>, <0.430185, 5.486724, 0.308554>, <0.430117, 5.427918, 0.317830>, 
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.205451, 5.566828, 1.066661>, <1.234991, 5.473854, 1.042967>, <1.205451, 5.427918, 1.066661>, 
      <1.337643, 5.626361, 0.868624>, <1.337643, 5.566828, 0.868624>, <1.367183, 5.473854, 0.844930>, <1.337643, 5.427918, 0.868624>, 
      <1.083915, 5.626361, 0.667669>, <1.083915, 5.566828, 0.667669>, <1.095242, 5.480305, 0.641757>, <1.083915, 5.427918, 0.667669>, 
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.040103, 5.626361, 1.314368>, <0.697091, 5.626361, 1.354692>, <0.444763, 5.626361, 1.196486>, 
      <1.205451, 5.566828, 1.066661>, <1.040103, 5.566828, 1.314368>, <0.697091, 5.566828, 1.354692>, <0.444763, 5.566828, 1.196486>, 
      <1.234991, 5.473854, 1.042967>, <1.069643, 5.473854, 1.290674>, <0.722341, 5.481828, 1.354121>, <0.470013, 5.481828, 1.195915>, 
      <1.205451, 5.427918, 1.066661>, <1.040103, 5.427918, 1.314368>, <0.697091, 5.427918, 1.354692>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>, 
      <0.346497, 4.594506, 0.671614>, <0.073661, 4.594506, 0.665696>, <-0.053878, 4.594802, 1.057458>, <-0.052002, 4.594802, 1.330351>, 
      <0.306075, 5.069158, 0.559621>, <0.154565, 5.069158, 0.786598>, <0.040898, 5.059296, 1.055421>, <0.272110, 5.059296, 1.200387>, 
      <0.306494, 5.427918, 0.503029>, <0.154984, 5.427918, 0.730007>, <0.213551, 5.427918, 1.051520>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>, 
      <0.781077, 4.594883, 1.125284>, <0.779546, 4.594883, 0.902622>, <0.569112, 4.594506, 0.676443>, <0.346497, 4.594506, 0.671614>, 
      <0.801868, 5.056452, 0.724924>, <0.613214, 5.056452, 0.606641>, <0.429698, 5.069158, 0.374422>, <0.306075, 5.069158, 0.559621>, 
      <0.882184, 5.427918, 0.541187>, <0.693530, 5.427918, 0.422904>, <0.430117, 5.427918, 0.317830>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>, 
      <0.654951, 4.595179, 1.785078>, <0.892999, 4.595179, 1.790242>, <0.782714, 4.594883, 1.363382>, <0.781077, 4.594883, 1.125284>, 
      <0.959541, 5.045514, 1.263906>, <1.091733, 5.045514, 1.065869>, <1.003599, 5.056452, 0.851406>, <0.801868, 5.056452, 0.724924>, 
      <1.205451, 5.427918, 1.066661>, <1.337643, 5.427918, 0.868624>, <1.083915, 5.427918, 0.667669>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.654951, 4.595179, 1.785078>, <0.959541, 5.045514, 1.263906>, <1.205451, 5.427918, 1.066661>, 
      <0.014414, 4.237260, 1.776704>, <0.357198, 4.595179, 1.778620>, <0.794193, 5.045514, 1.511613>, <1.040103, 5.427918, 1.314368>, 
      <-0.203806, 4.237260, 1.509005>, <-0.049954, 4.594802, 1.628167>, <0.524439, 5.059296, 1.358594>, <0.697091, 5.427918, 1.354692>, 
      <-0.205854, 4.237260, 1.211188>, <-0.052002, 4.594802, 1.330351>, <0.272110, 5.059296, 1.200387>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>, 
      <0.105462, 3.463578, 0.850334>, <0.055023, 3.463578, 0.582137>, <-0.340953, 3.483383, 0.584389>, <-0.607601, 3.483383, 0.642467>, 
      <0.265438, 3.898818, 0.770024>, <-0.007397, 3.898818, 0.764106>, <-0.366443, 3.868423, 0.815368>, <-0.364567, 3.868423, 1.088261>, 
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>, 
      <-0.204841, 3.488257, 1.374467>, <0.012726, 3.488257, 1.327079>, <0.146616, 3.463578, 1.069166>, <0.105462, 3.463578, 0.850334>, 
      <0.371952, 3.860518, 1.336769>, <0.370421, 3.860518, 1.114107>, <0.488054, 3.898818, 0.774853>, <0.265438, 3.898818, 0.770024>, 
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>, 
      <-0.849194, 3.504386, 1.439758>, <-0.805187, 3.504386, 1.673760>, <-0.437490, 3.488257, 1.425140>, <-0.204841, 3.488257, 1.374467>, 
      <-0.075015, 3.832981, 1.780999>, <0.163032, 3.832981, 1.786163>, <0.373589, 3.860518, 1.574868>, <0.371952, 3.860518, 1.336769>, 
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.849194, 3.504386, 1.439758>, <-0.075015, 3.832981, 1.780999>, <0.312168, 4.237260, 1.783163>, 
      <-1.053398, 3.126806, 0.761653>, <-0.904239, 3.504386, 1.147066>, <-0.372769, 3.832981, 1.774541>, <0.014414, 4.237260, 1.776704>, 
      <-0.836419, 3.126806, 0.492946>, <-0.898602, 3.483383, 0.705849>, <-0.362519, 3.868423, 1.386078>, <-0.203806, 4.237260, 1.509005>, 
      <-0.545418, 3.126806, 0.429564>, <-0.607601, 3.483383, 0.642467>, <-0.364567, 3.868423, 1.088261>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>, 
      <-0.128147, 2.415676, 0.651832>, <0.126414, 2.415676, 0.553481>, <0.053531, 2.440944, 0.169666>, <-0.052050, 2.440944, -0.081982>, 
      <-0.023820, 2.814543, 0.808328>, <-0.074258, 2.814543, 0.540130>, <-0.219259, 2.785552, 0.167732>, <-0.485907, 2.785552, 0.225810>, 
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>, 
      <-0.697247, 2.446923, 0.443910>, <-0.611100, 2.446923, 0.649238>, <-0.335852, 2.415676, 0.732080>, <-0.128147, 2.415676, 0.651832>, 
      <-0.587640, 2.778548, 1.039500>, <-0.370073, 2.778548, 0.992112>, <0.017335, 2.814543, 1.027160>, <-0.023820, 2.814543, 0.808328>, 
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>, 
      <-0.880560, 2.466101, -0.172718>, <-1.102663, 2.466101, -0.086907>, <-0.789365, 2.446923, 0.224348>, <-0.697247, 2.446923, 0.443910>, 
      <-1.144960, 2.755688, 0.675529>, <-1.100952, 2.755688, 0.909531>, <-0.820290, 2.778548, 1.090173>, <-0.587640, 2.778548, 1.039500>, 
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.880560, 2.466101, -0.172718>, <-1.144960, 2.755688, 0.675529>, <-0.998353, 3.126806, 1.054346>, 
      <-0.252738, 2.104019, -0.501665>, <-0.602749, 2.466101, -0.280051>, <-1.200004, 2.755688, 0.382836>, <-1.053398, 3.126806, 0.761653>, 
      <0.050935, 2.104019, -0.337146>, <-0.167273, 2.440944, -0.356614>, <-0.776909, 2.785552, 0.289192>, <-0.836419, 3.126806, 0.492946>, 
      <0.166158, 2.104019, -0.062515>, <-0.052050, 2.440944, -0.081982>, <-0.485907, 2.785552, 0.225810>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.234524, 1.081232, 0.616299>, <0.551125, 1.081232, 0.697322>, <0.779388, 1.081232, 0.547756>, 
      <0.028194, 1.393687, 0.395892>, <0.171180, 1.393687, 0.628333>, <0.505759, 1.423886, 0.492281>, <0.734022, 1.423886, 0.342715>, 
      <-0.111949, 1.792362, 0.516332>, <0.142612, 1.792362, 0.417981>, <0.489946, 1.767094, 0.208601>, <0.384366, 1.767094, -0.043048>, 
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>, 
      <0.234524, 1.081232, 0.616299>, <0.300570, 0.755451, 0.603751>, <0.100099, 0.326674, 0.699584>, <0.154975, 0.000000, 0.730010>, 
      <0.551125, 1.081232, 0.697322>, <0.595304, 0.747538, 0.897002>, <0.302425, 0.339953, 0.879182>, <0.213519, 0.000000, 1.051528>, 
      <0.779388, 1.081232, 0.547756>, <0.823568, 0.747538, 0.747436>, <0.533627, 0.339953, 1.024166>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.180330, 1.081232, -0.001283>, <-0.025129, 1.081232, 0.194200>, <0.091538, 1.081232, 0.383857>, 
      <0.125214, 1.431229, -0.176519>, <-0.061034, 1.431229, -0.054483>, <-0.088473, 1.393687, 0.206234>, <0.028194, 1.393687, 0.395892>, 
      <-0.440308, 1.761115, -0.001050>, <-0.354161, 1.761115, 0.204279>, <-0.319654, 1.792362, 0.596580>, <-0.111949, 1.792362, 0.516332>, 
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>, 
      <0.180330, 1.081232, -0.001283>, <0.411833, 0.745534, 0.049744>, <0.555172, 0.343419, 0.244602>, <0.693544, 0.000000, 0.422947>, 
      <-0.025129, 1.081232, 0.194200>, <0.040917, 0.755451, 0.181652>, <0.375262, 0.326674, 0.287429>, <0.430138, 0.000000, 0.317854>, 
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.854275, 1.081232, -0.400463>, <0.565737, 1.081232, -0.253815>, <0.366578, 1.081232, -0.123319>, 
      <0.670363, 1.455342, -0.457448>, <0.545608, 1.455342, -0.660252>, <0.324373, 1.431229, -0.307015>, <0.125214, 1.431229, -0.176519>, 
      <-0.180537, 1.741937, -0.615946>, <-0.402640, 1.741937, -0.530136>, <-0.532426, 1.761115, -0.220612>, <-0.440308, 1.761115, -0.001050>, 
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.261608, 0.738743, 0.040172>, <1.142527, 0.355497, 0.715488>, <1.205418, 0.000000, 1.066741>, 
      <0.854275, 1.081232, -0.400463>, <1.136853, 0.738743, -0.162632>, <1.274733, 0.355497, 0.517461>, <1.337625, 0.000000, 0.868714>, 
      <0.565737, 1.081232, -0.253815>, <0.797239, 0.745534, -0.202788>, <0.945539, 0.343419, 0.489396>, <1.083911, 0.000000, 0.667741>, 
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.670363, 1.455342, -0.457448>, <-0.180537, 1.741937, -0.615946>, <-0.530548, 2.104019, -0.394332>, 
      <1.135075, 1.081232, 0.056011>, <0.826408, 1.455342, -0.203778>, <0.097274, 1.741937, -0.723279>, <-0.252738, 2.104019, -0.501665>, 
      <1.028498, 1.081232, 0.384530>, <0.983133, 1.423886, 0.179489>, <0.269142, 1.767094, -0.317679>, <0.050935, 2.104019, -0.337146>, 
      <0.779388, 1.081232, 0.547756>, <0.734022, 1.423886, 0.342715>, <0.384366, 1.767094, -0.043048>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.135075, 1.081232, 0.056011>, <1.028498, 1.081232, 0.384530>, <0.779388, 1.081232, 0.547756>, 
      <1.261608, 0.738743, 0.040172>, <1.417652, 0.738743, 0.293842>, <1.072678, 0.747538, 0.584210>, <0.823568, 0.747538, 0.747436>, 
      <1.142527, 0.355497, 0.715488>, <0.977161, 0.355497, 0.963183>, <0.785944, 0.339953, 1.182390>, <0.533627, 0.339953, 1.024166>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.171607, -0.058008, 0.567566>, <-0.429647, -0.058008, 0.478746>, <-0.748211, -0.046475, 0.605113>, <-0.829626, -0.046475, 0.865585>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.080693, -0.053847, 1.152972>, <-0.014263, -0.053847, 0.940444>, <0.038937, -0.058008, 0.640038>, <-0.171607, -0.058008, 0.567566>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.523592, -0.042839, 1.593553>, <-0.298453, -0.042839, 1.671048>, <-0.151727, -0.053847, 1.380233>, <-0.080693, -0.053847, 1.152972>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.523592, -0.042839, 1.593553>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.805199, -0.042839, 1.496620>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.918477, -0.046475, 1.149846>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.829626, -0.046475, 0.865585>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>, 
      <-0.423778, 5.626361, 0.490812>, <-0.423778, 5.566828, 0.490812>, <-0.430195, 5.486410, 0.499852>, <-0.423778, 5.427918, 0.490812>, 
      <-0.719823, 5.626361, 0.629223>, <-0.719823, 5.566828, 0.629223>, <-0.726450, 5.477662, 0.661250>, <-0.719823, 5.427918, 0.629223>, 
      <-0.801219, 5.626361, 0.889701>, <-0.801219, 5.566828, 0.889701>, <-0.807845, 5.477662, 0.921728>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>, 
      <0.010193, 5.626361, 0.933545>, <0.010193, 5.566828, 0.933545>, <0.025226, 5.483433, 0.948915>, <0.010193, 5.427918, 0.933545>, 
      <0.044818, 5.626361, 0.652071>, <0.044818, 5.566828, 0.652071>, <0.038401, 5.486410, 0.661111>, <0.044818, 5.427918, 0.652071>, 
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.482199, 5.566828, 1.592358>, <-0.463544, 5.474575, 1.624284>, <-0.482199, 5.427918, 1.592358>, 
      <-0.257054, 5.626361, 1.669837>, <-0.257054, 5.566828, 1.669837>, <-0.238399, 5.474575, 1.701764>, <-0.257054, 5.427918, 1.669837>, 
      <-0.127237, 5.626361, 1.373344>, <-0.127237, 5.566828, 1.373344>, <-0.112205, 5.483433, 1.388713>, <-0.127237, 5.427918, 1.373344>, 
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.763814, 5.626361, 1.495446>, <-0.890049, 5.626361, 1.173969>, <-0.801219, 5.626361, 0.889701>, 
      <-0.482199, 5.566828, 1.592358>, <-0.763814, 5.566828, 1.495446>, <-0.890049, 5.566828, 1.173969>, <-0.801219, 5.566828, 0.889701>, 
      <-0.463544, 5.474575, 1.624284>, <-0.745159, 5.474575, 1.527372>, <-0.896675, 5.477662, 1.205995>, <-0.807845, 5.477662, 0.921728>, 
      <-0.482199, 5.427918, 1.592358>, <-0.763814, 5.427918, 1.495446>, <-0.890049, 5.427918, 1.173969>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>, 
      <-0.089107, 4.594527, 0.386047>, <-0.152773, 4.594527, 0.120678>, <-0.564322, 4.595013, 0.097065>, <-0.827765, 4.595013, 0.168284>, 
      <-0.126297, 5.068491, 0.524063>, <-0.384344, 5.068491, 0.435261>, <-0.669715, 5.051760, 0.387044>, <-0.751111, 5.051760, 0.647522>, 
      <-0.165731, 5.427918, 0.579614>, <-0.423778, 5.427918, 0.490812>, <-0.719823, 5.427918, 0.629223>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>, 
      <-0.417480, 4.594711, 0.921634>, <-0.202528, 4.594711, 0.863524>, <-0.037160, 4.594527, 0.602571>, <-0.089107, 4.594527, 0.386047>, 
      <-0.155195, 5.062406, 1.044886>, <-0.088782, 5.062406, 0.832353>, <0.084253, 5.068491, 0.596519>, <-0.126297, 5.068491, 0.524063>, 
      <-0.056220, 5.427918, 1.146078>, <0.010193, 5.427918, 0.933545>, <0.044818, 5.427918, 0.652071>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>, 
      <-1.087756, 4.595149, 0.967504>, <-1.032208, 4.595149, 1.199037>, <-0.647332, 4.594711, 0.983772>, <-0.417480, 4.594711, 0.921634>, 
      <-0.634640, 5.046650, 1.331464>, <-0.409495, 5.046650, 1.408943>, <-0.226213, 5.062406, 1.272152>, <-0.155195, 5.062406, 1.044886>, 
      <-0.482199, 5.427918, 1.592358>, <-0.257054, 5.427918, 1.669837>, <-0.127237, 5.427918, 1.373344>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-1.087756, 4.595149, 0.967504>, <-0.634640, 5.046650, 1.331464>, <-0.482199, 5.427918, 1.592358>, 
      <-1.107078, 4.237260, 0.352218>, <-1.157237, 4.595149, 0.677899>, <-0.916254, 5.046650, 1.234552>, <-0.763814, 5.427918, 1.495446>, 
      <-0.903679, 4.237260, 0.073090>, <-1.115267, 4.595013, 0.246007>, <-0.839940, 5.051760, 0.931790>, <-0.890049, 5.427918, 1.173969>, 
      <-0.616177, 4.237260, -0.004633>, <-0.827765, 4.595013, 0.168284>, <-0.751111, 5.051760, 0.647522>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>, 
      <0.271064, 3.465083, 0.375612>, <0.517615, 3.465083, 0.258622>, <0.402853, 3.495644, -0.136809>, <0.278870, 3.495644, -0.379918>, 
      <0.058931, 3.896598, 0.344779>, <-0.004735, 3.896598, 0.079410>, <-0.122620, 3.848180, -0.263910>, <-0.386062, 3.848180, -0.192692>, 
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>, 
      <-0.313106, 3.477658, 0.196542>, <-0.211944, 3.477658, 0.394904>, <0.069895, 3.465083, 0.471068>, <0.271064, 3.465083, 0.375612>, 
      <-0.447355, 3.877483, 0.600333>, <-0.232404, 3.877483, 0.542223>, <0.110878, 3.896598, 0.561302>, <0.058931, 3.896598, 0.344779>, 
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>, 
      <-0.545698, 3.502879, -0.414521>, <-0.760812, 3.502879, -0.312448>, <-0.421281, 3.477658, -0.015569>, <-0.313106, 3.477658, 0.196542>, 
      <-0.981310, 3.835650, 0.276356>, <-0.925762, 3.835650, 0.507889>, <-0.677208, 3.877483, 0.662471>, <-0.447355, 3.877483, 0.600333>, 
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.545698, 3.502879, -0.414521>, <-0.981310, 3.835650, 0.276356>, <-1.037597, 4.237260, 0.641823>, 
      <0.109377, 3.126806, -0.629339>, <-0.276629, 3.502879, -0.542196>, <-1.050791, 3.835650, -0.013249>, <-1.107078, 4.237260, 0.352218>, 
      <0.424431, 3.126806, -0.487834>, <0.143563, 3.495644, -0.645230>, <-0.673564, 3.848180, -0.114968>, <-0.903679, 4.237260, 0.073090>, 
      <0.559738, 3.126806, -0.222522>, <0.278870, 3.495644, -0.379918>, <-0.386062, 3.848180, -0.192692>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>, 
      <0.365100, 2.417655, 0.731806>, <0.524959, 2.417655, 0.952983>, <0.891390, 2.455820, 0.766646>, <1.107911, 2.455820, 0.600536>, 
      <0.370049, 2.812306, 0.506711>, <0.616600, 2.812306, 0.389721>, <0.956934, 2.768021, 0.173693>, <0.832951, 2.768021, -0.069416>, 
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>, 
      <0.437691, 2.433805, 0.127413>, <0.261024, 2.433805, 0.262947>, <0.234666, 2.417655, 0.551341>, <0.365100, 2.417655, 0.731806>, 
      <0.000755, 2.793839, 0.038072>, <0.101918, 2.793839, 0.236433>, <0.168879, 2.812306, 0.602167>, <0.370049, 2.812306, 0.506711>, 
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>, 
      <0.991383, 2.464347, -0.214834>, <0.851907, 2.464347, -0.407810>, <0.626605, 2.433805, -0.017518>, <0.437691, 2.433805, 0.127413>, 
      <0.219055, 2.757805, -0.587170>, <0.003941, 2.757805, -0.485097>, <-0.107420, 2.793839, -0.174039>, <0.000755, 2.793839, 0.038072>, 
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <0.991383, 2.464347, -0.214834>, <0.219055, 2.757805, -0.587170>, <-0.159692, 3.126806, -0.501665>, 
      <1.326447, 2.104019, 0.388885>, <1.165841, 2.464347, 0.026543>, <0.488124, 2.757805, -0.714844>, <0.109377, 3.126806, -0.629339>, 
      <1.244570, 2.104019, 0.724413>, <1.344208, 2.455820, 0.419255>, <0.697644, 2.768021, -0.334728>, <0.424431, 3.126806, -0.487834>, 
      <1.008274, 2.104019, 0.905694>, <1.107911, 2.455820, 0.600536>, <0.832951, 2.768021, -0.069416>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.224474, 1.081232, 1.042327>, <-0.222313, 1.081232, 1.369123>, <-0.019611, 1.081232, 1.551842>, 
      <0.035153, 1.396006, 0.876905>, <-0.153280, 1.396006, 1.074305>, <0.088221, 1.442306, 1.371879>, <0.290923, 1.442306, 1.554598>, 
      <0.255198, 1.790383, 0.854888>, <0.415056, 1.790383, 1.076065>, <0.692115, 1.752218, 1.376962>, <0.908636, 1.752218, 1.210852>, 
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>, 
      <-0.224474, 1.081232, 1.042327>, <-0.298291, 0.754862, 1.009170>, <-0.390564, 0.327640, 0.558707>, <-0.423769, 0.000000, 0.490773>, 
      <-0.222313, 1.081232, 1.369123>, <-0.513671, 0.742454, 1.366537>, <-0.506757, 0.348832, 0.809677>, <-0.719824, 0.000000, 0.629163>, 
      <-0.019611, 1.081232, 1.551842>, <-0.310969, 0.742454, 1.549256>, <-0.588171, 0.348832, 1.070149>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.359017, 1.081232, 0.832847>, <0.117708, 1.081232, 0.683860>, <-0.036041, 1.081232, 0.844926>, 
      <0.620129, 1.415221, 0.842415>, <0.454738, 1.415221, 0.693328>, <0.188902, 1.396006, 0.715839>, <0.035153, 1.396006, 0.876905>, 
      <0.655813, 1.774233, 0.406870>, <0.479146, 1.774233, 0.542404>, <0.124764, 1.790383, 0.674422>, <0.255198, 1.790383, 0.854888>, 
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>, 
      <0.359017, 1.081232, 0.832847>, <0.264047, 0.749863, 0.971272>, <0.162627, 0.335985, 0.890444>, <0.010170, 0.000000, 0.933538>, 
      <0.117708, 1.081232, 0.683860>, <0.043891, 0.754862, 0.650703>, <0.078020, 0.327640, 0.720000>, <0.044816, 0.000000, 0.652066>, 
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.916474, 1.081232, 1.383110>, <0.701264, 1.081232, 1.141355>, <0.524408, 1.081232, 0.981934>, 
      <1.040909, 1.453099, 1.299984>, <1.205316, 1.453099, 1.127752>, <0.796985, 1.415221, 1.001836>, <0.620129, 1.415221, 0.842415>, 
      <1.312595, 1.743691, 0.509850>, <1.173120, 1.743691, 0.316874>, <0.844727, 1.774233, 0.261939>, <0.655813, 1.774233, 0.406870>, 
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.486546, 0.739388, 1.790082>, <-0.140497, 0.354327, 1.582077>, <-0.482271, 0.000000, 1.592315>, 
      <0.916474, 1.081232, 1.383110>, <0.650953, 0.739388, 1.617850>, <0.084642, 0.354327, 1.659573>, <-0.257132, 0.000000, 1.669811>, 
      <0.701264, 1.081232, 1.141355>, <0.606294, 0.749863, 1.279780>, <0.025164, 0.335985, 1.330233>, <-0.127293, 0.000000, 1.373327>, 
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <1.040909, 1.453099, 1.299984>, <1.312595, 1.743691, 0.509850>, <1.151989, 2.104019, 0.147508>, 
      <0.546424, 1.081232, 1.770770>, <0.835266, 1.453099, 1.515412>, <1.487054, 1.743691, 0.751227>, <1.326447, 2.104019, 0.388885>, 
      <0.201603, 1.081232, 1.751248>, <0.512137, 1.442306, 1.754004>, <1.144933, 1.752218, 1.029571>, <1.244570, 2.104019, 0.724413>, 
      <-0.019611, 1.081232, 1.551842>, <0.290923, 1.442306, 1.554598>, <0.908636, 1.752218, 1.210852>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.546424, 1.081232, 1.770770>, <0.201603, 1.081232, 1.751248>, <-0.019611, 1.081232, 1.551842>, 
      <0.486546, 0.739388, 1.790082>, <0.280903, 0.739388, 2.005510>, <-0.089755, 0.742454, 1.748662>, <-0.310969, 0.742454, 1.549256>, 
      <-0.140497, 0.354327, 1.582077>, <-0.422104, 0.354327, 1.485145>, <-0.677022, 0.348832, 1.354410>, <-0.588171, 0.348832, 1.070149>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.531123, -0.050749, 0.000078>, <0.531123, -0.050749, -0.272821>, <0.304895, -0.043346, -0.532983>, <0.032107, -0.043346, -0.525189>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.010372, -0.057224, 0.275149>, <0.232949, -0.057224, 0.268790>, <0.531123, -0.050749, 0.222746>, <0.531123, -0.050749, 0.000078>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.555407, -0.047723, -0.004906>, <-0.555407, -0.047723, 0.233197>, <-0.227635, -0.057224, 0.281949>, <0.010372, -0.057224, 0.275149>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.555407, -0.047723, -0.004906>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.555407, -0.047723, -0.302730>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.265595, -0.043346, -0.516683>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.032107, -0.043346, -0.525189>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>, 
      <0.499935, 5.626361, -0.272928>, <0.499935, 5.566828, -0.272928>, <0.487182, 5.481088, -0.296477>, <0.499935, 5.427918, -0.272928>, 
      <0.272705, 5.626361, -0.507806>, <0.272705, 5.566828, -0.507806>, <0.239261, 5.475015, -0.522211>, <0.272705, 5.427918, -0.507806>, 
      <-0.000082, 5.626361, -0.499992>, <-0.000082, 5.566828, -0.499992>, <-0.033527, 5.475015, -0.514397>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>, 
      <0.222553, 5.626361, 0.281511>, <0.222553, 5.566828, 0.281511>, <0.209130, 5.485864, 0.279002>, <0.222553, 5.427918, 0.281511>, 
      <0.499971, 5.626361, 0.222639>, <0.499971, 5.566828, 0.222639>, <0.487219, 5.481088, 0.199091>, <0.499971, 5.427918, 0.222639>, 
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560649, 5.566828, 0.030352>, <-0.589835, 5.478685, 0.041080>, <-0.560649, 5.427918, 0.030352>, 
      <-0.560631, 5.626361, 0.268456>, <-0.560631, 5.566828, 0.268456>, <-0.589817, 5.478685, 0.279183>, <-0.560631, 5.427918, 0.268456>, 
      <-0.238030, 5.626361, 0.294705>, <-0.238030, 5.566828, 0.294705>, <-0.251453, 5.485864, 0.292195>, <-0.238030, 5.427918, 0.294705>, 
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560671, 5.626361, -0.267471>, <-0.297783, 5.626361, -0.491464>, <-0.000082, 5.626361, -0.499992>, 
      <-0.560649, 5.566828, 0.030352>, <-0.560671, 5.566828, -0.267471>, <-0.297783, 5.566828, -0.491464>, <-0.000082, 5.566828, -0.499992>, 
      <-0.589835, 5.478685, 0.041080>, <-0.589857, 5.478685, -0.256743>, <-0.331228, 5.475015, -0.505870>, <-0.033527, 5.475015, -0.514397>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560671, 5.427918, -0.267471>, <-0.297783, 5.427918, -0.491464>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>, 
      <0.871674, 4.594842, 0.409537>, <1.101873, 4.594842, 0.262968>, <0.990284, 4.595130, -0.133963>, <0.837200, 4.595130, -0.359882>, 
      <0.588703, 5.057900, 0.163849>, <0.588683, 5.057900, -0.109050>, <0.542953, 5.047354, -0.391404>, <0.270166, 5.047354, -0.383590>, 
      <0.499955, 5.427918, -0.000029>, <0.499935, 5.427918, -0.272928>, <0.272705, 5.427918, -0.507806>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>, 
      <0.258408, 4.594562, 0.273502>, <0.383314, 4.594562, 0.457837>, <0.683847, 4.594842, 0.529128>, <0.871674, 4.594842, 0.409537>, 
      <0.083501, 5.067343, 0.303502>, <0.306078, 5.067343, 0.297127>, <0.588720, 5.057900, 0.386517>, <0.588703, 5.057900, 0.163849>, 
      <-0.000024, 5.427918, 0.287887>, <0.222553, 5.427918, 0.281511>, <0.499971, 5.427918, 0.222639>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>, 
      <-0.002919, 4.594964, -0.345512>, <-0.203767, 4.594964, -0.217631>, <0.124843, 4.594562, 0.076388>, <0.258408, 4.594562, 0.273502>, 
      <-0.345421, 5.053539, -0.048759>, <-0.345404, 5.053539, 0.189344>, <-0.154505, 5.067343, 0.310320>, <0.083501, 5.067343, 0.303502>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560631, 5.427918, 0.268456>, <-0.238030, 5.427918, 0.294705>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <-0.002919, 4.594964, -0.345512>, <-0.345421, 5.053539, -0.048759>, <-0.560649, 5.427918, 0.030352>, 
      <0.489158, 4.237260, -0.423140>, <0.248304, 4.594964, -0.505468>, <-0.345443, 5.053539, -0.346583>, <-0.560671, 5.427918, -0.267471>, 
      <0.819288, 4.237260, -0.321664>, <0.670135, 4.595130, -0.606434>, <-0.027535, 5.047354, -0.375063>, <-0.297783, 5.427918, -0.491464>, 
      <0.986353, 4.237260, -0.075112>, <0.837200, 4.595130, -0.359882>, <0.270166, 5.047354, -0.383590>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>, 
      <0.487685, 3.485815, 1.278173>, <0.678550, 3.485815, 1.473223>, <1.021481, 3.501927, 1.236272>, <1.211001, 3.501927, 1.039914>, 
      <0.792948, 3.864501, 0.829580>, <1.023146, 3.864501, 0.683010>, <1.306122, 3.837324, 0.469049>, <1.153038, 3.837324, 0.243131>, 
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>, 
      <0.458265, 3.467610, 0.673952>, <0.303630, 3.467610, 0.834167>, <0.331951, 3.485815, 1.119025>, <0.487685, 3.485815, 1.278173>, 
      <0.382814, 3.892839, 0.419899>, <0.507721, 3.892839, 0.604234>, <0.605121, 3.864501, 0.949171>, <0.792948, 3.864501, 0.829580>, 
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>, 
      <0.975227, 3.492933, 0.262535>, <0.808698, 3.492933, 0.092354>, <0.623620, 3.467610, 0.502630>, <0.458265, 3.467610, 0.673952>, 
      <0.496831, 3.852760, -0.174689>, <0.295984, 3.852760, -0.046808>, <0.249249, 3.892839, 0.222786>, <0.382814, 3.892839, 0.419899>, 
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.975227, 3.492933, 0.262535>, <0.496831, 3.852760, -0.174689>, <0.237935, 4.237260, -0.263184>, 
      <1.197061, 3.126806, 0.772832>, <1.183524, 3.492933, 0.475399>, <0.748054, 3.852760, -0.334644>, <0.489158, 4.237260, -0.423140>, 
      <1.165802, 3.126806, 1.116788>, <1.417829, 3.501927, 0.825623>, <0.985973, 3.837324, -0.003422>, <0.819288, 4.237260, -0.321664>, 
      <0.958974, 3.126806, 1.331080>, <1.211001, 3.501927, 1.039914>, <1.153038, 3.837324, 0.243131>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>, 
      <-0.478676, 2.443939, 1.104255>, <-0.635781, 2.443939, 1.327397>, <-0.339553, 2.463236, 1.620984>, <-0.112016, 2.463236, 1.771652>, 
      <0.025493, 2.782051, 1.366857>, <0.216358, 2.782051, 1.561907>, <0.522439, 2.759143, 1.812815>, <0.711959, 2.759143, 1.616456>, 
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>, 
      <0.105840, 2.420954, 0.966742>, <-0.079815, 2.420954, 0.843806>, <-0.350489, 2.443939, 0.922187>, <-0.478676, 2.443939, 1.104255>, 
      <0.360933, 2.808564, 0.855739>, <0.206297, 2.808564, 1.015955>, <-0.130241, 2.782051, 1.207709>, <0.025493, 2.782051, 1.366857>, 
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>, 
      <0.604571, 2.452578, 1.399187>, <0.741644, 2.452578, 1.204498>, <0.304365, 2.420954, 1.098199>, <0.105840, 2.420954, 0.966742>, 
      <1.001887, 2.771873, 0.848307>, <0.835358, 2.771873, 0.678127>, <0.526288, 2.808564, 0.684418>, <0.360933, 2.808564, 0.855739>, 
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.604571, 2.452578, 1.399187>, <1.001887, 2.771873, 0.848307>, <0.988764, 3.126806, 0.559968>, 
      <0.145354, 2.104019, 1.713333>, <0.433118, 2.452578, 1.642708>, <1.210184, 2.771873, 1.061171>, <1.197061, 3.126806, 0.772832>, 
      <-0.198554, 2.104019, 1.745119>, <0.136302, 2.463236, 1.936081>, <0.918787, 2.759143, 1.402165>, <1.165802, 3.126806, 1.116788>, 
      <-0.446872, 2.104019, 1.580690>, <-0.112016, 2.463236, 1.771652>, <0.711959, 2.759143, 1.616456>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.532779, 1.081232, -0.115902>, <-0.841079, 1.081232, -0.007496>, <-0.947876, 1.081232, 0.243639>, 
      <-0.460568, 1.427554, 0.143533>, <-0.708550, 1.427554, 0.029607>, <-0.919759, 1.451683, 0.358848>, <-1.026556, 1.451683, 0.609983>, 
      <-0.657048, 1.764099, 0.663767>, <-0.814153, 1.764099, 0.886908>, <-1.009265, 1.744802, 1.239059>, <-0.781728, 1.744802, 1.389728>, 
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>, 
      <-0.532779, 1.081232, -0.115902>, <-0.362912, 0.746541, -0.256523>, <0.290460, 0.341673, -0.273427>, <0.500000, 0.000000, -0.272899>, 
      <-0.841079, 1.081232, -0.007496>, <-0.768561, 0.739794, -0.345148>, <0.010876, 0.353593, -0.302315>, <0.272788, 0.000000, -0.507794>, 
      <-0.947876, 1.081232, 0.243639>, <-0.875358, 0.739794, -0.094013>, <-0.261912, 0.353593, -0.294521>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.144796, 1.081232, 0.367641>, <-0.082460, 1.081232, 0.090980>, <-0.284797, 1.081232, -0.001976>, 
      <-0.230920, 1.399890, 0.670780>, <-0.143781, 1.399890, 0.465871>, <-0.258231, 1.427554, 0.236488>, <-0.460568, 1.427554, 0.143533>, 
      <-0.092438, 1.787084, 0.906190>, <-0.278093, 1.787084, 0.783255>, <-0.528861, 1.764099, 0.481698>, <-0.657048, 1.764099, 0.663767>, 
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>, 
      <-0.144796, 1.081232, 0.367641>, <-0.145838, 0.753870, 0.266728>, <0.162897, 0.329277, 0.354769>, <0.222577, 0.000000, 0.281520>, 
      <-0.082460, 1.081232, 0.090980>, <0.087407, 0.746541, -0.049642>, <0.290460, 0.341673, 0.222140>, <0.500000, 0.000000, 0.222668>, 
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.483662, 1.081232, 1.073839>, <-0.325115, 1.081232, 0.791664>, <-0.231935, 1.081232, 0.572550>, 
      <-0.551143, 1.438248, 1.218700>, <-0.334780, 1.438248, 1.318099>, <-0.324100, 1.399890, 0.889893>, <-0.230920, 1.399890, 0.670780>, 
      <0.029043, 1.755460, 1.540437>, <0.166117, 1.755460, 1.345747>, <0.106087, 1.787084, 1.037648>, <-0.092438, 1.787084, 0.906190>, 
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.840828, 0.743590, 0.743435>, <-0.598392, 0.346823, 0.286187>, <-0.560606, 0.000000, 0.030303>, 
      <-0.483662, 1.081232, 1.073839>, <-0.624465, 0.743590, 0.842835>, <-0.598392, 0.346823, 0.524291>, <-0.560606, 0.000000, 0.268407>, 
      <-0.325115, 1.081232, 0.791664>, <-0.326157, 0.753870, 0.690751>, <-0.297686, 0.329277, 0.367929>, <-0.238007, 0.000000, 0.294679>, 
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.551143, 1.438248, 1.218700>, <0.029043, 1.755460, 1.540437>, <0.316807, 2.104019, 1.469812>, 
      <-0.970655, 1.081232, 0.850110>, <-0.821773, 1.438248, 1.094370>, <-0.142410, 1.755460, 1.783957>, <0.145354, 2.104019, 1.713333>, 
      <-1.064426, 1.081232, 0.517710>, <-1.143107, 1.451683, 0.884053>, <-0.533411, 1.744802, 1.554156>, <-0.198554, 2.104019, 1.745119>, 
      <-0.947876, 1.081232, 0.243639>, <-1.026556, 1.451683, 0.609983>, <-0.781728, 1.744802, 1.389728>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.970655, 1.081232, 0.850110>, <-1.064426, 1.081232, 0.517710>, <-0.947876, 1.081232, 0.243639>, 
      <-0.840828, 0.743590, 0.743435>, <-1.111458, 0.743590, 0.619105>, <-0.991908, 0.739794, 0.180057>, <-0.875358, 0.739794, -0.094013>, 
      <-0.598392, 0.346823, 0.286187>, <-0.598392, 0.346823, -0.011636>, <-0.559614, 0.353593, -0.286016>, <-0.261912, 0.353593, -0.294521>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
}
#declare BezPtch017 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt50 = union {
  cone { // Cone017
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch017 }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 77.084526>
  translate  <-2.991145, 0.529553, 2.682482>
}
#declare segMstraightMA3 = union {
  object { // Blatt48->Blatt
    Blatt
    rotate <0.0, 0.0, 128.875092>
    translate  <-0.519128, -1.070326, -1.747901>
  }
  object { // Blatt49->Blatt
    Blatt
    rotate <0.0, 0.0, -115.116074>
    translate  <0.706542, -0.813839, 1.562842>
  }
  object { sPatchObj17 }
  object { Blatt50 }
  translate  <-4.521275, 0.049384, 33.406994>
}
#declare sPatchObj18 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.316323, -0.058464, 0.508489>, <0.164796, -0.058464, 0.735456>, <0.199995, -0.051711, 1.077744>, <0.431196, -0.051711, 1.222727>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.902234, -0.049748, 0.567079>, <0.713589, -0.049748, 0.448783>, <0.439959, -0.058464, 0.323300>, <0.316323, -0.058464, 0.508489>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.212851, -0.042017, 1.108256>, <1.345058, -0.042017, 0.910229>, <1.103956, -0.049748, 0.693576>, <0.902234, -0.049748, 0.567079>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.212851, -0.042017, 1.108256>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.047485, -0.042017, 1.355951>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.683513, -0.051711, 1.380951>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.431196, -0.051711, 1.222727>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>, 
      <0.154984, 5.626361, 0.730007>, <0.154984, 5.566828, 0.730007>, <0.155052, 5.486724, 0.720730>, <0.154984, 5.427918, 0.730007>, 
      <0.213551, 5.626361, 1.051520>, <0.213551, 5.566828, 1.051520>, <0.238801, 5.481828, 1.050949>, <0.213551, 5.427918, 1.051520>, 
      <0.444763, 5.626361, 1.196486>, <0.444763, 5.566828, 1.196486>, <0.470013, 5.481828, 1.195915>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>, 
      <0.693530, 5.626361, 0.422904>, <0.693530, 5.566828, 0.422904>, <0.704857, 5.480305, 0.396992>, <0.693530, 5.427918, 0.422904>, 
      <0.430117, 5.626361, 0.317830>, <0.430117, 5.566828, 0.317830>, <0.430185, 5.486724, 0.308554>, <0.430117, 5.427918, 0.317830>, 
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.205451, 5.566828, 1.066661>, <1.234991, 5.473854, 1.042967>, <1.205451, 5.427918, 1.066661>, 
      <1.337643, 5.626361, 0.868624>, <1.337643, 5.566828, 0.868624>, <1.367183, 5.473854, 0.844930>, <1.337643, 5.427918, 0.868624>, 
      <1.083915, 5.626361, 0.667669>, <1.083915, 5.566828, 0.667669>, <1.095242, 5.480305, 0.641757>, <1.083915, 5.427918, 0.667669>, 
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.040103, 5.626361, 1.314368>, <0.697091, 5.626361, 1.354692>, <0.444763, 5.626361, 1.196486>, 
      <1.205451, 5.566828, 1.066661>, <1.040103, 5.566828, 1.314368>, <0.697091, 5.566828, 1.354692>, <0.444763, 5.566828, 1.196486>, 
      <1.234991, 5.473854, 1.042967>, <1.069643, 5.473854, 1.290674>, <0.722341, 5.481828, 1.354121>, <0.470013, 5.481828, 1.195915>, 
      <1.205451, 5.427918, 1.066661>, <1.040103, 5.427918, 1.314368>, <0.697091, 5.427918, 1.354692>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>, 
      <0.346497, 4.594506, 0.671614>, <0.073661, 4.594506, 0.665696>, <-0.053878, 4.594802, 1.057458>, <-0.052002, 4.594802, 1.330351>, 
      <0.306075, 5.069158, 0.559621>, <0.154565, 5.069158, 0.786598>, <0.040898, 5.059296, 1.055421>, <0.272110, 5.059296, 1.200387>, 
      <0.306494, 5.427918, 0.503029>, <0.154984, 5.427918, 0.730007>, <0.213551, 5.427918, 1.051520>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>, 
      <0.781077, 4.594883, 1.125284>, <0.779546, 4.594883, 0.902622>, <0.569112, 4.594506, 0.676443>, <0.346497, 4.594506, 0.671614>, 
      <0.801868, 5.056452, 0.724924>, <0.613214, 5.056452, 0.606641>, <0.429698, 5.069158, 0.374422>, <0.306075, 5.069158, 0.559621>, 
      <0.882184, 5.427918, 0.541187>, <0.693530, 5.427918, 0.422904>, <0.430117, 5.427918, 0.317830>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>, 
      <0.654951, 4.595179, 1.785078>, <0.892999, 4.595179, 1.790242>, <0.782714, 4.594883, 1.363382>, <0.781077, 4.594883, 1.125284>, 
      <0.959541, 5.045514, 1.263906>, <1.091733, 5.045514, 1.065869>, <1.003599, 5.056452, 0.851406>, <0.801868, 5.056452, 0.724924>, 
      <1.205451, 5.427918, 1.066661>, <1.337643, 5.427918, 0.868624>, <1.083915, 5.427918, 0.667669>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.654951, 4.595179, 1.785078>, <0.959541, 5.045514, 1.263906>, <1.205451, 5.427918, 1.066661>, 
      <0.014414, 4.237260, 1.776704>, <0.357198, 4.595179, 1.778620>, <0.794193, 5.045514, 1.511613>, <1.040103, 5.427918, 1.314368>, 
      <-0.203806, 4.237260, 1.509005>, <-0.049954, 4.594802, 1.628167>, <0.524439, 5.059296, 1.358594>, <0.697091, 5.427918, 1.354692>, 
      <-0.205854, 4.237260, 1.211188>, <-0.052002, 4.594802, 1.330351>, <0.272110, 5.059296, 1.200387>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>, 
      <0.105462, 3.463578, 0.850334>, <0.055023, 3.463578, 0.582137>, <-0.340953, 3.483383, 0.584389>, <-0.607601, 3.483383, 0.642467>, 
      <0.265438, 3.898818, 0.770024>, <-0.007397, 3.898818, 0.764106>, <-0.366443, 3.868423, 0.815368>, <-0.364567, 3.868423, 1.088261>, 
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>, 
      <-0.204841, 3.488257, 1.374467>, <0.012726, 3.488257, 1.327079>, <0.146616, 3.463578, 1.069166>, <0.105462, 3.463578, 0.850334>, 
      <0.371952, 3.860518, 1.336769>, <0.370421, 3.860518, 1.114107>, <0.488054, 3.898818, 0.774853>, <0.265438, 3.898818, 0.770024>, 
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>, 
      <-0.849194, 3.504386, 1.439758>, <-0.805187, 3.504386, 1.673760>, <-0.437490, 3.488257, 1.425140>, <-0.204841, 3.488257, 1.374467>, 
      <-0.075015, 3.832981, 1.780999>, <0.163032, 3.832981, 1.786163>, <0.373589, 3.860518, 1.574868>, <0.371952, 3.860518, 1.336769>, 
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.849194, 3.504386, 1.439758>, <-0.075015, 3.832981, 1.780999>, <0.312168, 4.237260, 1.783163>, 
      <-1.053398, 3.126806, 0.761653>, <-0.904239, 3.504386, 1.147066>, <-0.372769, 3.832981, 1.774541>, <0.014414, 4.237260, 1.776704>, 
      <-0.836419, 3.126806, 0.492946>, <-0.898602, 3.483383, 0.705849>, <-0.362519, 3.868423, 1.386078>, <-0.203806, 4.237260, 1.509005>, 
      <-0.545418, 3.126806, 0.429564>, <-0.607601, 3.483383, 0.642467>, <-0.364567, 3.868423, 1.088261>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>, 
      <-0.128147, 2.415676, 0.651832>, <0.126414, 2.415676, 0.553481>, <0.053531, 2.440944, 0.169666>, <-0.052050, 2.440944, -0.081982>, 
      <-0.023820, 2.814543, 0.808328>, <-0.074258, 2.814543, 0.540130>, <-0.219259, 2.785552, 0.167732>, <-0.485907, 2.785552, 0.225810>, 
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>, 
      <-0.697247, 2.446923, 0.443910>, <-0.611100, 2.446923, 0.649238>, <-0.335852, 2.415676, 0.732080>, <-0.128147, 2.415676, 0.651832>, 
      <-0.587640, 2.778548, 1.039500>, <-0.370073, 2.778548, 0.992112>, <0.017335, 2.814543, 1.027160>, <-0.023820, 2.814543, 0.808328>, 
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>, 
      <-0.880560, 2.466101, -0.172718>, <-1.102663, 2.466101, -0.086907>, <-0.789365, 2.446923, 0.224348>, <-0.697247, 2.446923, 0.443910>, 
      <-1.144960, 2.755688, 0.675529>, <-1.100952, 2.755688, 0.909531>, <-0.820290, 2.778548, 1.090173>, <-0.587640, 2.778548, 1.039500>, 
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.880560, 2.466101, -0.172718>, <-1.144960, 2.755688, 0.675529>, <-0.998353, 3.126806, 1.054346>, 
      <-0.252738, 2.104019, -0.501665>, <-0.602749, 2.466101, -0.280051>, <-1.200004, 2.755688, 0.382836>, <-1.053398, 3.126806, 0.761653>, 
      <0.050935, 2.104019, -0.337146>, <-0.167273, 2.440944, -0.356614>, <-0.776909, 2.785552, 0.289192>, <-0.836419, 3.126806, 0.492946>, 
      <0.166158, 2.104019, -0.062515>, <-0.052050, 2.440944, -0.081982>, <-0.485907, 2.785552, 0.225810>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.234524, 1.081232, 0.616299>, <0.551125, 1.081232, 0.697322>, <0.779388, 1.081232, 0.547756>, 
      <0.028194, 1.393687, 0.395892>, <0.171180, 1.393687, 0.628333>, <0.505759, 1.423886, 0.492281>, <0.734022, 1.423886, 0.342715>, 
      <-0.111949, 1.792362, 0.516332>, <0.142612, 1.792362, 0.417981>, <0.489946, 1.767094, 0.208601>, <0.384366, 1.767094, -0.043048>, 
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>, 
      <0.234524, 1.081232, 0.616299>, <0.300570, 0.755451, 0.603751>, <0.100099, 0.326674, 0.699584>, <0.154975, 0.000000, 0.730010>, 
      <0.551125, 1.081232, 0.697322>, <0.595304, 0.747538, 0.897002>, <0.302425, 0.339953, 0.879182>, <0.213519, 0.000000, 1.051528>, 
      <0.779388, 1.081232, 0.547756>, <0.823568, 0.747538, 0.747436>, <0.533627, 0.339953, 1.024166>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.180330, 1.081232, -0.001283>, <-0.025129, 1.081232, 0.194200>, <0.091538, 1.081232, 0.383857>, 
      <0.125214, 1.431229, -0.176519>, <-0.061034, 1.431229, -0.054483>, <-0.088473, 1.393687, 0.206234>, <0.028194, 1.393687, 0.395892>, 
      <-0.440308, 1.761115, -0.001050>, <-0.354161, 1.761115, 0.204279>, <-0.319654, 1.792362, 0.596580>, <-0.111949, 1.792362, 0.516332>, 
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>, 
      <0.180330, 1.081232, -0.001283>, <0.411833, 0.745534, 0.049744>, <0.555172, 0.343419, 0.244602>, <0.693544, 0.000000, 0.422947>, 
      <-0.025129, 1.081232, 0.194200>, <0.040917, 0.755451, 0.181652>, <0.375262, 0.326674, 0.287429>, <0.430138, 0.000000, 0.317854>, 
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.854275, 1.081232, -0.400463>, <0.565737, 1.081232, -0.253815>, <0.366578, 1.081232, -0.123319>, 
      <0.670363, 1.455342, -0.457448>, <0.545608, 1.455342, -0.660252>, <0.324373, 1.431229, -0.307015>, <0.125214, 1.431229, -0.176519>, 
      <-0.180537, 1.741937, -0.615946>, <-0.402640, 1.741937, -0.530136>, <-0.532426, 1.761115, -0.220612>, <-0.440308, 1.761115, -0.001050>, 
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.261608, 0.738743, 0.040172>, <1.142527, 0.355497, 0.715488>, <1.205418, 0.000000, 1.066741>, 
      <0.854275, 1.081232, -0.400463>, <1.136853, 0.738743, -0.162632>, <1.274733, 0.355497, 0.517461>, <1.337625, 0.000000, 0.868714>, 
      <0.565737, 1.081232, -0.253815>, <0.797239, 0.745534, -0.202788>, <0.945539, 0.343419, 0.489396>, <1.083911, 0.000000, 0.667741>, 
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.670363, 1.455342, -0.457448>, <-0.180537, 1.741937, -0.615946>, <-0.530548, 2.104019, -0.394332>, 
      <1.135075, 1.081232, 0.056011>, <0.826408, 1.455342, -0.203778>, <0.097274, 1.741937, -0.723279>, <-0.252738, 2.104019, -0.501665>, 
      <1.028498, 1.081232, 0.384530>, <0.983133, 1.423886, 0.179489>, <0.269142, 1.767094, -0.317679>, <0.050935, 2.104019, -0.337146>, 
      <0.779388, 1.081232, 0.547756>, <0.734022, 1.423886, 0.342715>, <0.384366, 1.767094, -0.043048>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.135075, 1.081232, 0.056011>, <1.028498, 1.081232, 0.384530>, <0.779388, 1.081232, 0.547756>, 
      <1.261608, 0.738743, 0.040172>, <1.417652, 0.738743, 0.293842>, <1.072678, 0.747538, 0.584210>, <0.823568, 0.747538, 0.747436>, 
      <1.142527, 0.355497, 0.715488>, <0.977161, 0.355497, 0.963183>, <0.785944, 0.339953, 1.182390>, <0.533627, 0.339953, 1.024166>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.171607, -0.058008, 0.567566>, <-0.429647, -0.058008, 0.478746>, <-0.748211, -0.046475, 0.605113>, <-0.829626, -0.046475, 0.865585>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.080693, -0.053847, 1.152972>, <-0.014263, -0.053847, 0.940444>, <0.038937, -0.058008, 0.640038>, <-0.171607, -0.058008, 0.567566>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.523592, -0.042839, 1.593553>, <-0.298453, -0.042839, 1.671048>, <-0.151727, -0.053847, 1.380233>, <-0.080693, -0.053847, 1.152972>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.523592, -0.042839, 1.593553>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.805199, -0.042839, 1.496620>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.918477, -0.046475, 1.149846>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.829626, -0.046475, 0.865585>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>, 
      <-0.423778, 5.626361, 0.490812>, <-0.423778, 5.566828, 0.490812>, <-0.430195, 5.486410, 0.499852>, <-0.423778, 5.427918, 0.490812>, 
      <-0.719823, 5.626361, 0.629223>, <-0.719823, 5.566828, 0.629223>, <-0.726450, 5.477662, 0.661250>, <-0.719823, 5.427918, 0.629223>, 
      <-0.801219, 5.626361, 0.889701>, <-0.801219, 5.566828, 0.889701>, <-0.807845, 5.477662, 0.921728>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>, 
      <0.010193, 5.626361, 0.933545>, <0.010193, 5.566828, 0.933545>, <0.025226, 5.483433, 0.948915>, <0.010193, 5.427918, 0.933545>, 
      <0.044818, 5.626361, 0.652071>, <0.044818, 5.566828, 0.652071>, <0.038401, 5.486410, 0.661111>, <0.044818, 5.427918, 0.652071>, 
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.482199, 5.566828, 1.592358>, <-0.463544, 5.474575, 1.624284>, <-0.482199, 5.427918, 1.592358>, 
      <-0.257054, 5.626361, 1.669837>, <-0.257054, 5.566828, 1.669837>, <-0.238399, 5.474575, 1.701764>, <-0.257054, 5.427918, 1.669837>, 
      <-0.127237, 5.626361, 1.373344>, <-0.127237, 5.566828, 1.373344>, <-0.112205, 5.483433, 1.388713>, <-0.127237, 5.427918, 1.373344>, 
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.763814, 5.626361, 1.495446>, <-0.890049, 5.626361, 1.173969>, <-0.801219, 5.626361, 0.889701>, 
      <-0.482199, 5.566828, 1.592358>, <-0.763814, 5.566828, 1.495446>, <-0.890049, 5.566828, 1.173969>, <-0.801219, 5.566828, 0.889701>, 
      <-0.463544, 5.474575, 1.624284>, <-0.745159, 5.474575, 1.527372>, <-0.896675, 5.477662, 1.205995>, <-0.807845, 5.477662, 0.921728>, 
      <-0.482199, 5.427918, 1.592358>, <-0.763814, 5.427918, 1.495446>, <-0.890049, 5.427918, 1.173969>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>, 
      <-0.089107, 4.594527, 0.386047>, <-0.152773, 4.594527, 0.120678>, <-0.564322, 4.595013, 0.097065>, <-0.827765, 4.595013, 0.168284>, 
      <-0.126297, 5.068491, 0.524063>, <-0.384344, 5.068491, 0.435261>, <-0.669715, 5.051760, 0.387044>, <-0.751111, 5.051760, 0.647522>, 
      <-0.165731, 5.427918, 0.579614>, <-0.423778, 5.427918, 0.490812>, <-0.719823, 5.427918, 0.629223>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>, 
      <-0.417480, 4.594711, 0.921634>, <-0.202528, 4.594711, 0.863524>, <-0.037160, 4.594527, 0.602571>, <-0.089107, 4.594527, 0.386047>, 
      <-0.155195, 5.062406, 1.044886>, <-0.088782, 5.062406, 0.832353>, <0.084253, 5.068491, 0.596519>, <-0.126297, 5.068491, 0.524063>, 
      <-0.056220, 5.427918, 1.146078>, <0.010193, 5.427918, 0.933545>, <0.044818, 5.427918, 0.652071>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>, 
      <-1.087756, 4.595149, 0.967504>, <-1.032208, 4.595149, 1.199037>, <-0.647332, 4.594711, 0.983772>, <-0.417480, 4.594711, 0.921634>, 
      <-0.634640, 5.046650, 1.331464>, <-0.409495, 5.046650, 1.408943>, <-0.226213, 5.062406, 1.272152>, <-0.155195, 5.062406, 1.044886>, 
      <-0.482199, 5.427918, 1.592358>, <-0.257054, 5.427918, 1.669837>, <-0.127237, 5.427918, 1.373344>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-1.087756, 4.595149, 0.967504>, <-0.634640, 5.046650, 1.331464>, <-0.482199, 5.427918, 1.592358>, 
      <-1.107078, 4.237260, 0.352218>, <-1.157237, 4.595149, 0.677899>, <-0.916254, 5.046650, 1.234552>, <-0.763814, 5.427918, 1.495446>, 
      <-0.903679, 4.237260, 0.073090>, <-1.115267, 4.595013, 0.246007>, <-0.839940, 5.051760, 0.931790>, <-0.890049, 5.427918, 1.173969>, 
      <-0.616177, 4.237260, -0.004633>, <-0.827765, 4.595013, 0.168284>, <-0.751111, 5.051760, 0.647522>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>, 
      <0.271064, 3.465083, 0.375612>, <0.517615, 3.465083, 0.258622>, <0.402853, 3.495644, -0.136809>, <0.278870, 3.495644, -0.379918>, 
      <0.058931, 3.896598, 0.344779>, <-0.004735, 3.896598, 0.079410>, <-0.122620, 3.848180, -0.263910>, <-0.386062, 3.848180, -0.192692>, 
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>, 
      <-0.313106, 3.477658, 0.196542>, <-0.211944, 3.477658, 0.394904>, <0.069895, 3.465083, 0.471068>, <0.271064, 3.465083, 0.375612>, 
      <-0.447355, 3.877483, 0.600333>, <-0.232404, 3.877483, 0.542223>, <0.110878, 3.896598, 0.561302>, <0.058931, 3.896598, 0.344779>, 
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>, 
      <-0.545698, 3.502879, -0.414521>, <-0.760812, 3.502879, -0.312448>, <-0.421281, 3.477658, -0.015569>, <-0.313106, 3.477658, 0.196542>, 
      <-0.981310, 3.835650, 0.276356>, <-0.925762, 3.835650, 0.507889>, <-0.677208, 3.877483, 0.662471>, <-0.447355, 3.877483, 0.600333>, 
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.545698, 3.502879, -0.414521>, <-0.981310, 3.835650, 0.276356>, <-1.037597, 4.237260, 0.641823>, 
      <0.109377, 3.126806, -0.629339>, <-0.276629, 3.502879, -0.542196>, <-1.050791, 3.835650, -0.013249>, <-1.107078, 4.237260, 0.352218>, 
      <0.424431, 3.126806, -0.487834>, <0.143563, 3.495644, -0.645230>, <-0.673564, 3.848180, -0.114968>, <-0.903679, 4.237260, 0.073090>, 
      <0.559738, 3.126806, -0.222522>, <0.278870, 3.495644, -0.379918>, <-0.386062, 3.848180, -0.192692>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>, 
      <0.365100, 2.417655, 0.731806>, <0.524959, 2.417655, 0.952983>, <0.891390, 2.455820, 0.766646>, <1.107911, 2.455820, 0.600536>, 
      <0.370049, 2.812306, 0.506711>, <0.616600, 2.812306, 0.389721>, <0.956934, 2.768021, 0.173693>, <0.832951, 2.768021, -0.069416>, 
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>, 
      <0.437691, 2.433805, 0.127413>, <0.261024, 2.433805, 0.262947>, <0.234666, 2.417655, 0.551341>, <0.365100, 2.417655, 0.731806>, 
      <0.000755, 2.793839, 0.038072>, <0.101918, 2.793839, 0.236433>, <0.168879, 2.812306, 0.602167>, <0.370049, 2.812306, 0.506711>, 
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>, 
      <0.991383, 2.464347, -0.214834>, <0.851907, 2.464347, -0.407810>, <0.626605, 2.433805, -0.017518>, <0.437691, 2.433805, 0.127413>, 
      <0.219055, 2.757805, -0.587170>, <0.003941, 2.757805, -0.485097>, <-0.107420, 2.793839, -0.174039>, <0.000755, 2.793839, 0.038072>, 
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <0.991383, 2.464347, -0.214834>, <0.219055, 2.757805, -0.587170>, <-0.159692, 3.126806, -0.501665>, 
      <1.326447, 2.104019, 0.388885>, <1.165841, 2.464347, 0.026543>, <0.488124, 2.757805, -0.714844>, <0.109377, 3.126806, -0.629339>, 
      <1.244570, 2.104019, 0.724413>, <1.344208, 2.455820, 0.419255>, <0.697644, 2.768021, -0.334728>, <0.424431, 3.126806, -0.487834>, 
      <1.008274, 2.104019, 0.905694>, <1.107911, 2.455820, 0.600536>, <0.832951, 2.768021, -0.069416>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.224474, 1.081232, 1.042327>, <-0.222313, 1.081232, 1.369123>, <-0.019611, 1.081232, 1.551842>, 
      <0.035153, 1.396006, 0.876905>, <-0.153280, 1.396006, 1.074305>, <0.088221, 1.442306, 1.371879>, <0.290923, 1.442306, 1.554598>, 
      <0.255198, 1.790383, 0.854888>, <0.415056, 1.790383, 1.076065>, <0.692115, 1.752218, 1.376962>, <0.908636, 1.752218, 1.210852>, 
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>, 
      <-0.224474, 1.081232, 1.042327>, <-0.298291, 0.754862, 1.009170>, <-0.390564, 0.327640, 0.558707>, <-0.423769, 0.000000, 0.490773>, 
      <-0.222313, 1.081232, 1.369123>, <-0.513671, 0.742454, 1.366537>, <-0.506757, 0.348832, 0.809677>, <-0.719824, 0.000000, 0.629163>, 
      <-0.019611, 1.081232, 1.551842>, <-0.310969, 0.742454, 1.549256>, <-0.588171, 0.348832, 1.070149>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.359017, 1.081232, 0.832847>, <0.117708, 1.081232, 0.683860>, <-0.036041, 1.081232, 0.844926>, 
      <0.620129, 1.415221, 0.842415>, <0.454738, 1.415221, 0.693328>, <0.188902, 1.396006, 0.715839>, <0.035153, 1.396006, 0.876905>, 
      <0.655813, 1.774233, 0.406870>, <0.479146, 1.774233, 0.542404>, <0.124764, 1.790383, 0.674422>, <0.255198, 1.790383, 0.854888>, 
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>, 
      <0.359017, 1.081232, 0.832847>, <0.264047, 0.749863, 0.971272>, <0.162627, 0.335985, 0.890444>, <0.010170, 0.000000, 0.933538>, 
      <0.117708, 1.081232, 0.683860>, <0.043891, 0.754862, 0.650703>, <0.078020, 0.327640, 0.720000>, <0.044816, 0.000000, 0.652066>, 
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.916474, 1.081232, 1.383110>, <0.701264, 1.081232, 1.141355>, <0.524408, 1.081232, 0.981934>, 
      <1.040909, 1.453099, 1.299984>, <1.205316, 1.453099, 1.127752>, <0.796985, 1.415221, 1.001836>, <0.620129, 1.415221, 0.842415>, 
      <1.312595, 1.743691, 0.509850>, <1.173120, 1.743691, 0.316874>, <0.844727, 1.774233, 0.261939>, <0.655813, 1.774233, 0.406870>, 
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.486546, 0.739388, 1.790082>, <-0.140497, 0.354327, 1.582077>, <-0.482271, 0.000000, 1.592315>, 
      <0.916474, 1.081232, 1.383110>, <0.650953, 0.739388, 1.617850>, <0.084642, 0.354327, 1.659573>, <-0.257132, 0.000000, 1.669811>, 
      <0.701264, 1.081232, 1.141355>, <0.606294, 0.749863, 1.279780>, <0.025164, 0.335985, 1.330233>, <-0.127293, 0.000000, 1.373327>, 
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <1.040909, 1.453099, 1.299984>, <1.312595, 1.743691, 0.509850>, <1.151989, 2.104019, 0.147508>, 
      <0.546424, 1.081232, 1.770770>, <0.835266, 1.453099, 1.515412>, <1.487054, 1.743691, 0.751227>, <1.326447, 2.104019, 0.388885>, 
      <0.201603, 1.081232, 1.751248>, <0.512137, 1.442306, 1.754004>, <1.144933, 1.752218, 1.029571>, <1.244570, 2.104019, 0.724413>, 
      <-0.019611, 1.081232, 1.551842>, <0.290923, 1.442306, 1.554598>, <0.908636, 1.752218, 1.210852>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.546424, 1.081232, 1.770770>, <0.201603, 1.081232, 1.751248>, <-0.019611, 1.081232, 1.551842>, 
      <0.486546, 0.739388, 1.790082>, <0.280903, 0.739388, 2.005510>, <-0.089755, 0.742454, 1.748662>, <-0.310969, 0.742454, 1.549256>, 
      <-0.140497, 0.354327, 1.582077>, <-0.422104, 0.354327, 1.485145>, <-0.677022, 0.348832, 1.354410>, <-0.588171, 0.348832, 1.070149>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.531123, -0.050749, 0.000078>, <0.531123, -0.050749, -0.272821>, <0.304895, -0.043346, -0.532983>, <0.032107, -0.043346, -0.525189>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.010372, -0.057224, 0.275149>, <0.232949, -0.057224, 0.268790>, <0.531123, -0.050749, 0.222746>, <0.531123, -0.050749, 0.000078>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.555407, -0.047723, -0.004906>, <-0.555407, -0.047723, 0.233197>, <-0.227635, -0.057224, 0.281949>, <0.010372, -0.057224, 0.275149>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.555407, -0.047723, -0.004906>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.555407, -0.047723, -0.302730>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.265595, -0.043346, -0.516683>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.032107, -0.043346, -0.525189>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>, 
      <0.499935, 5.626361, -0.272928>, <0.499935, 5.566828, -0.272928>, <0.487182, 5.481088, -0.296477>, <0.499935, 5.427918, -0.272928>, 
      <0.272705, 5.626361, -0.507806>, <0.272705, 5.566828, -0.507806>, <0.239261, 5.475015, -0.522211>, <0.272705, 5.427918, -0.507806>, 
      <-0.000082, 5.626361, -0.499992>, <-0.000082, 5.566828, -0.499992>, <-0.033527, 5.475015, -0.514397>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>, 
      <0.222553, 5.626361, 0.281511>, <0.222553, 5.566828, 0.281511>, <0.209130, 5.485864, 0.279002>, <0.222553, 5.427918, 0.281511>, 
      <0.499971, 5.626361, 0.222639>, <0.499971, 5.566828, 0.222639>, <0.487219, 5.481088, 0.199091>, <0.499971, 5.427918, 0.222639>, 
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560649, 5.566828, 0.030352>, <-0.589835, 5.478685, 0.041080>, <-0.560649, 5.427918, 0.030352>, 
      <-0.560631, 5.626361, 0.268456>, <-0.560631, 5.566828, 0.268456>, <-0.589817, 5.478685, 0.279183>, <-0.560631, 5.427918, 0.268456>, 
      <-0.238030, 5.626361, 0.294705>, <-0.238030, 5.566828, 0.294705>, <-0.251453, 5.485864, 0.292195>, <-0.238030, 5.427918, 0.294705>, 
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560671, 5.626361, -0.267471>, <-0.297783, 5.626361, -0.491464>, <-0.000082, 5.626361, -0.499992>, 
      <-0.560649, 5.566828, 0.030352>, <-0.560671, 5.566828, -0.267471>, <-0.297783, 5.566828, -0.491464>, <-0.000082, 5.566828, -0.499992>, 
      <-0.589835, 5.478685, 0.041080>, <-0.589857, 5.478685, -0.256743>, <-0.331228, 5.475015, -0.505870>, <-0.033527, 5.475015, -0.514397>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560671, 5.427918, -0.267471>, <-0.297783, 5.427918, -0.491464>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>, 
      <0.871674, 4.594842, 0.409537>, <1.101873, 4.594842, 0.262968>, <0.990284, 4.595130, -0.133963>, <0.837200, 4.595130, -0.359882>, 
      <0.588703, 5.057900, 0.163849>, <0.588683, 5.057900, -0.109050>, <0.542953, 5.047354, -0.391404>, <0.270166, 5.047354, -0.383590>, 
      <0.499955, 5.427918, -0.000029>, <0.499935, 5.427918, -0.272928>, <0.272705, 5.427918, -0.507806>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>, 
      <0.258408, 4.594562, 0.273502>, <0.383314, 4.594562, 0.457837>, <0.683847, 4.594842, 0.529128>, <0.871674, 4.594842, 0.409537>, 
      <0.083501, 5.067343, 0.303502>, <0.306078, 5.067343, 0.297127>, <0.588720, 5.057900, 0.386517>, <0.588703, 5.057900, 0.163849>, 
      <-0.000024, 5.427918, 0.287887>, <0.222553, 5.427918, 0.281511>, <0.499971, 5.427918, 0.222639>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>, 
      <-0.002919, 4.594964, -0.345512>, <-0.203767, 4.594964, -0.217631>, <0.124843, 4.594562, 0.076388>, <0.258408, 4.594562, 0.273502>, 
      <-0.345421, 5.053539, -0.048759>, <-0.345404, 5.053539, 0.189344>, <-0.154505, 5.067343, 0.310320>, <0.083501, 5.067343, 0.303502>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560631, 5.427918, 0.268456>, <-0.238030, 5.427918, 0.294705>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <-0.002919, 4.594964, -0.345512>, <-0.345421, 5.053539, -0.048759>, <-0.560649, 5.427918, 0.030352>, 
      <0.489158, 4.237260, -0.423140>, <0.248304, 4.594964, -0.505468>, <-0.345443, 5.053539, -0.346583>, <-0.560671, 5.427918, -0.267471>, 
      <0.819288, 4.237260, -0.321664>, <0.670135, 4.595130, -0.606434>, <-0.027535, 5.047354, -0.375063>, <-0.297783, 5.427918, -0.491464>, 
      <0.986353, 4.237260, -0.075112>, <0.837200, 4.595130, -0.359882>, <0.270166, 5.047354, -0.383590>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>, 
      <0.487685, 3.485815, 1.278173>, <0.678550, 3.485815, 1.473223>, <1.021481, 3.501927, 1.236272>, <1.211001, 3.501927, 1.039914>, 
      <0.792948, 3.864501, 0.829580>, <1.023146, 3.864501, 0.683010>, <1.306122, 3.837324, 0.469049>, <1.153038, 3.837324, 0.243131>, 
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>, 
      <0.458265, 3.467610, 0.673952>, <0.303630, 3.467610, 0.834167>, <0.331951, 3.485815, 1.119025>, <0.487685, 3.485815, 1.278173>, 
      <0.382814, 3.892839, 0.419899>, <0.507721, 3.892839, 0.604234>, <0.605121, 3.864501, 0.949171>, <0.792948, 3.864501, 0.829580>, 
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>, 
      <0.975227, 3.492933, 0.262535>, <0.808698, 3.492933, 0.092354>, <0.623620, 3.467610, 0.502630>, <0.458265, 3.467610, 0.673952>, 
      <0.496831, 3.852760, -0.174689>, <0.295984, 3.852760, -0.046808>, <0.249249, 3.892839, 0.222786>, <0.382814, 3.892839, 0.419899>, 
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.975227, 3.492933, 0.262535>, <0.496831, 3.852760, -0.174689>, <0.237935, 4.237260, -0.263184>, 
      <1.197061, 3.126806, 0.772832>, <1.183524, 3.492933, 0.475399>, <0.748054, 3.852760, -0.334644>, <0.489158, 4.237260, -0.423140>, 
      <1.165802, 3.126806, 1.116788>, <1.417829, 3.501927, 0.825623>, <0.985973, 3.837324, -0.003422>, <0.819288, 4.237260, -0.321664>, 
      <0.958974, 3.126806, 1.331080>, <1.211001, 3.501927, 1.039914>, <1.153038, 3.837324, 0.243131>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>, 
      <-0.478676, 2.443939, 1.104255>, <-0.635781, 2.443939, 1.327397>, <-0.339553, 2.463236, 1.620984>, <-0.112016, 2.463236, 1.771652>, 
      <0.025493, 2.782051, 1.366857>, <0.216358, 2.782051, 1.561907>, <0.522439, 2.759143, 1.812815>, <0.711959, 2.759143, 1.616456>, 
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>, 
      <0.105840, 2.420954, 0.966742>, <-0.079815, 2.420954, 0.843806>, <-0.350489, 2.443939, 0.922187>, <-0.478676, 2.443939, 1.104255>, 
      <0.360933, 2.808564, 0.855739>, <0.206297, 2.808564, 1.015955>, <-0.130241, 2.782051, 1.207709>, <0.025493, 2.782051, 1.366857>, 
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>, 
      <0.604571, 2.452578, 1.399187>, <0.741644, 2.452578, 1.204498>, <0.304365, 2.420954, 1.098199>, <0.105840, 2.420954, 0.966742>, 
      <1.001887, 2.771873, 0.848307>, <0.835358, 2.771873, 0.678127>, <0.526288, 2.808564, 0.684418>, <0.360933, 2.808564, 0.855739>, 
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.604571, 2.452578, 1.399187>, <1.001887, 2.771873, 0.848307>, <0.988764, 3.126806, 0.559968>, 
      <0.145354, 2.104019, 1.713333>, <0.433118, 2.452578, 1.642708>, <1.210184, 2.771873, 1.061171>, <1.197061, 3.126806, 0.772832>, 
      <-0.198554, 2.104019, 1.745119>, <0.136302, 2.463236, 1.936081>, <0.918787, 2.759143, 1.402165>, <1.165802, 3.126806, 1.116788>, 
      <-0.446872, 2.104019, 1.580690>, <-0.112016, 2.463236, 1.771652>, <0.711959, 2.759143, 1.616456>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.532779, 1.081232, -0.115902>, <-0.841079, 1.081232, -0.007496>, <-0.947876, 1.081232, 0.243639>, 
      <-0.460568, 1.427554, 0.143533>, <-0.708550, 1.427554, 0.029607>, <-0.919759, 1.451683, 0.358848>, <-1.026556, 1.451683, 0.609983>, 
      <-0.657048, 1.764099, 0.663767>, <-0.814153, 1.764099, 0.886908>, <-1.009265, 1.744802, 1.239059>, <-0.781728, 1.744802, 1.389728>, 
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>, 
      <-0.532779, 1.081232, -0.115902>, <-0.362912, 0.746541, -0.256523>, <0.290460, 0.341673, -0.273427>, <0.500000, 0.000000, -0.272899>, 
      <-0.841079, 1.081232, -0.007496>, <-0.768561, 0.739794, -0.345148>, <0.010876, 0.353593, -0.302315>, <0.272788, 0.000000, -0.507794>, 
      <-0.947876, 1.081232, 0.243639>, <-0.875358, 0.739794, -0.094013>, <-0.261912, 0.353593, -0.294521>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.144796, 1.081232, 0.367641>, <-0.082460, 1.081232, 0.090980>, <-0.284797, 1.081232, -0.001976>, 
      <-0.230920, 1.399890, 0.670780>, <-0.143781, 1.399890, 0.465871>, <-0.258231, 1.427554, 0.236488>, <-0.460568, 1.427554, 0.143533>, 
      <-0.092438, 1.787084, 0.906190>, <-0.278093, 1.787084, 0.783255>, <-0.528861, 1.764099, 0.481698>, <-0.657048, 1.764099, 0.663767>, 
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>, 
      <-0.144796, 1.081232, 0.367641>, <-0.145838, 0.753870, 0.266728>, <0.162897, 0.329277, 0.354769>, <0.222577, 0.000000, 0.281520>, 
      <-0.082460, 1.081232, 0.090980>, <0.087407, 0.746541, -0.049642>, <0.290460, 0.341673, 0.222140>, <0.500000, 0.000000, 0.222668>, 
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.483662, 1.081232, 1.073839>, <-0.325115, 1.081232, 0.791664>, <-0.231935, 1.081232, 0.572550>, 
      <-0.551143, 1.438248, 1.218700>, <-0.334780, 1.438248, 1.318099>, <-0.324100, 1.399890, 0.889893>, <-0.230920, 1.399890, 0.670780>, 
      <0.029043, 1.755460, 1.540437>, <0.166117, 1.755460, 1.345747>, <0.106087, 1.787084, 1.037648>, <-0.092438, 1.787084, 0.906190>, 
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.840828, 0.743590, 0.743435>, <-0.598392, 0.346823, 0.286187>, <-0.560606, 0.000000, 0.030303>, 
      <-0.483662, 1.081232, 1.073839>, <-0.624465, 0.743590, 0.842835>, <-0.598392, 0.346823, 0.524291>, <-0.560606, 0.000000, 0.268407>, 
      <-0.325115, 1.081232, 0.791664>, <-0.326157, 0.753870, 0.690751>, <-0.297686, 0.329277, 0.367929>, <-0.238007, 0.000000, 0.294679>, 
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.551143, 1.438248, 1.218700>, <0.029043, 1.755460, 1.540437>, <0.316807, 2.104019, 1.469812>, 
      <-0.970655, 1.081232, 0.850110>, <-0.821773, 1.438248, 1.094370>, <-0.142410, 1.755460, 1.783957>, <0.145354, 2.104019, 1.713333>, 
      <-1.064426, 1.081232, 0.517710>, <-1.143107, 1.451683, 0.884053>, <-0.533411, 1.744802, 1.554156>, <-0.198554, 2.104019, 1.745119>, 
      <-0.947876, 1.081232, 0.243639>, <-1.026556, 1.451683, 0.609983>, <-0.781728, 1.744802, 1.389728>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.970655, 1.081232, 0.850110>, <-1.064426, 1.081232, 0.517710>, <-0.947876, 1.081232, 0.243639>, 
      <-0.840828, 0.743590, 0.743435>, <-1.111458, 0.743590, 0.619105>, <-0.991908, 0.739794, 0.180057>, <-0.875358, 0.739794, -0.094013>, 
      <-0.598392, 0.346823, 0.286187>, <-0.598392, 0.346823, -0.011636>, <-0.559614, 0.353593, -0.286016>, <-0.261912, 0.353593, -0.294521>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
}
#declare BezPtch018 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt53 = union {
  cone { // Cone018
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch018 }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 77.084526>
  translate  <-2.991145, 0.529553, 2.682482>
}
#declare segMstraightMA4 = union {
  object { // Blatt51->Blatt
    Blatt
    rotate <-2.834017, 24.737967, 128.253464>
    translate  <0.666684, -2.256138, -1.615506>
  }
  object { // Blatt52->Blatt
    Blatt
    rotate <0.0, 0.0, -115.116074>
    translate  <0.706542, -0.813839, 1.562842>
  }
  object { sPatchObj18 }
  object { Blatt53 }
  translate  <-0.1416, 0.695127, 0.180219>
}
#declare BezPtch019 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt56 = union {
  cone { // Cone019
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch019 }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 77.084526>
  translate  <-2.991145, 0.529553, 2.682482>
}
#declare sPatchObj19 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.314306, -0.058772, 0.508445>, <0.162778, -0.058772, 0.735411>, <0.199510, -0.053679, 1.073126>, <0.430711, -0.053679, 1.218109>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.897501, -0.052107, 0.565628>, <0.708856, -0.052107, 0.447332>, <0.437942, -0.058772, 0.323255>, <0.314306, -0.058772, 0.508445>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.208411, -0.045498, 1.105018>, <1.340617, -0.045498, 0.906991>, <1.099223, -0.052107, 0.692125>, <0.897501, -0.052107, 0.565628>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.208411, -0.045498, 1.105018>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.043045, -0.045498, 1.352713>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.683029, -0.053679, 1.376333>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.430711, -0.053679, 1.218109>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, 5.626361, 0.503044>, <0.306502, 5.566828, 0.503044>, <0.313705, 5.486803, 0.508029>, <0.306502, 5.427918, 0.503044>, 
      <0.154975, 5.626361, 0.730010>, <0.154975, 5.566828, 0.730010>, <0.162178, 5.486803, 0.734995>, <0.154975, 5.427918, 0.730010>, 
      <0.213519, 5.626361, 1.051528>, <0.213519, 5.566828, 1.051528>, <0.200427, 5.482373, 1.071712>, <0.213519, 5.427918, 1.051528>, 
      <0.444720, 5.626361, 1.196511>, <0.444720, 5.566828, 1.196511>, <0.431628, 5.482373, 1.216695>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, 5.626361, 0.541244>, <0.882189, 5.566828, 0.541244>, <0.896551, 5.480972, 0.564116>, <0.882189, 5.427918, 0.541244>, 
      <0.693544, 5.626361, 0.422947>, <0.693544, 5.566828, 0.422947>, <0.707906, 5.480972, 0.445820>, <0.693544, 5.427918, 0.422947>, 
      <0.430138, 5.626361, 0.317854>, <0.430138, 5.566828, 0.317854>, <0.437341, 5.486803, 0.322839>, <0.430138, 5.427918, 0.317854>, 
      <0.306502, 5.626361, 0.503044>, <0.306502, 5.566828, 0.503044>, <0.313705, 5.486803, 0.508029>, <0.306502, 5.427918, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, 5.626361, 1.066741>, <1.205418, 5.566828, 1.066741>, <1.208266, 5.474919, 1.103168>, <1.205418, 5.427918, 1.066741>, 
      <1.337625, 5.626361, 0.868714>, <1.337625, 5.566828, 0.868714>, <1.340473, 5.474919, 0.905141>, <1.337625, 5.427918, 0.868714>, 
      <1.083911, 5.626361, 0.667741>, <1.083911, 5.566828, 0.667741>, <1.098273, 5.480972, 0.690613>, <1.083911, 5.427918, 0.667741>, 
      <0.882189, 5.626361, 0.541244>, <0.882189, 5.566828, 0.541244>, <0.896551, 5.480972, 0.564116>, <0.882189, 5.427918, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, 5.626361, 1.066741>, <1.040052, 5.626361, 1.314436>, <0.697037, 5.626361, 1.354735>, <0.444720, 5.626361, 1.196511>, 
      <1.205418, 5.566828, 1.066741>, <1.040052, 5.566828, 1.314436>, <0.697037, 5.566828, 1.354735>, <0.444720, 5.566828, 1.196511>, 
      <1.208266, 5.474919, 1.103168>, <1.042900, 5.474919, 1.350863>, <0.683945, 5.482373, 1.374919>, <0.431628, 5.482373, 1.216695>, 
      <1.205418, 5.427918, 1.066741>, <1.040052, 5.427918, 1.314436>, <0.697037, 5.427918, 1.354735>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.136589, 4.237260, 0.385449>, <0.230985, 4.237260, 0.641503>, <0.525421, 4.237260, 0.783306>, <0.778675, 4.237260, 0.681636>, 
      <0.133888, 4.598742, 0.357947>, <0.228284, 4.598742, 0.614001>, <0.613669, 4.629140, 0.771958>, <0.866922, 4.629140, 0.670288>, 
      <0.262640, 5.069327, 0.472687>, <0.111113, 5.069327, 0.699654>, <0.301889, 5.060339, 0.915284>, <0.533090, 5.060339, 1.060267>, 
      <0.306502, 5.427918, 0.503044>, <0.154975, 5.427918, 0.730010>, <0.213519, 5.427918, 1.051528>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506148, 4.237260, -0.057609>, <0.299510, 4.237260, 0.025347>, <0.059568, 4.237260, 0.176526>, <0.136589, 4.237260, 0.385449>, 
      <0.537902, 4.639177, -0.157845>, <0.331264, 4.639177, -0.074889>, <0.056867, 4.598742, 0.149024>, <0.133888, 4.598742, 0.357947>, 
      <0.781964, 5.057685, 0.381634>, <0.593319, 5.057685, 0.263337>, <0.386276, 5.069327, 0.287498>, <0.262640, 5.069327, 0.472687>, 
      <0.882189, 5.427918, 0.541244>, <0.693544, 5.427918, 0.422947>, <0.430138, 5.427918, 0.317854>, <0.306502, 5.427918, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 4.237260, -0.009847>, <1.038884, 4.237260, -0.233253>, <0.727110, 4.237260, -0.146316>, <0.506148, 4.237260, -0.057609>, 
      <1.248264, 4.685070, -0.135836>, <1.165904, 4.685070, -0.359242>, <0.758865, 4.639177, -0.246552>, <0.537902, 4.639177, -0.157845>, 
      <1.182348, 5.047201, 0.771676>, <1.314555, 5.047201, 0.573649>, <0.983686, 5.057685, 0.508131>, <0.781964, 5.057685, 0.381634>, 
      <1.205418, 5.427918, 1.066741>, <1.337625, 5.427918, 0.868714>, <1.083911, 5.427918, 0.667741>, <0.882189, 5.427918, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 4.237260, -0.009847>, <1.248264, 4.685070, -0.135836>, <1.182348, 5.047201, 0.771676>, <1.205418, 5.427918, 1.066741>, 
      <1.224261, 4.237260, 0.269593>, <1.351281, 4.685070, 0.143604>, <1.016982, 5.047201, 1.019371>, <1.040052, 5.427918, 1.314436>, 
      <1.055058, 4.237260, 0.570680>, <1.143306, 4.629140, 0.559332>, <0.785407, 5.060339, 1.218491>, <0.697037, 5.427918, 1.354735>, 
      <0.778675, 4.237260, 0.681636>, <0.866922, 4.629140, 0.670288>, <0.533090, 5.060339, 1.060267>, <0.444720, 5.427918, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.323697, 3.126806, 0.678117>, <0.055656, 3.126806, 0.729386>, <-0.132371, 3.126806, 0.996682>, <-0.073467, 3.126806, 1.263149>, 
      <0.293214, 3.471417, 0.631713>, <0.025173, 3.471417, 0.682982>, <0.028361, 3.536985, 0.884052>, <0.087265, 3.536985, 1.150519>, 
      <0.139190, 3.889220, 0.411928>, <0.233586, 3.889220, 0.667983>, <0.425565, 3.793829, 0.796148>, <0.678819, 3.793829, 0.694477>, 
      <0.136589, 4.237260, 0.385449>, <0.230985, 4.237260, 0.641503>, <0.525421, 4.237260, 0.783306>, <0.778675, 4.237260, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.700384, 3.126806, 1.115132>, <0.652323, 3.126806, 0.897713>, <0.542400, 3.126806, 0.636285>, <0.323697, 3.126806, 0.678117>, 
      <0.659006, 3.554167, 0.883174>, <0.610945, 3.554167, 0.665754>, <0.511917, 3.471417, 0.589881>, <0.293214, 3.471417, 0.631713>, 
      <0.468847, 3.765138, 0.060136>, <0.262209, 3.765138, 0.143092>, <0.062169, 3.889220, 0.203006>, <0.139190, 3.889220, 0.411928>, 
      <0.506148, 4.237260, -0.057609>, <0.299510, 4.237260, 0.025347>, <0.059568, 4.237260, 0.176526>, <0.136589, 4.237260, 0.385449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552715, 3.126806, 1.714146>, <0.786579, 3.126806, 1.669414>, <0.751777, 3.126806, 1.347623>, <0.700384, 3.126806, 1.115132>, 
      <0.676641, 3.615166, 1.322087>, <0.910505, 3.615166, 1.277355>, <0.710399, 3.554167, 1.115665>, <0.659006, 3.554167, 0.883174>, 
      <0.953085, 3.644414, 0.156947>, <0.870725, 3.644414, -0.066459>, <0.689809, 3.765138, -0.028570>, <0.468847, 3.765138, 0.060136>, 
      <1.121244, 4.237260, -0.009847>, <1.038884, 4.237260, -0.233253>, <0.727110, 4.237260, -0.146316>, <0.506148, 4.237260, -0.057609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.552715, 3.126806, 1.714146>, <0.676641, 3.615166, 1.322087>, <0.953085, 3.644414, 0.156947>, <1.121244, 4.237260, -0.009847>, 
      <0.260194, 3.126806, 1.770097>, <0.384120, 3.615166, 1.378038>, <1.056102, 3.644414, 0.436386>, <1.224261, 4.237260, 0.269593>, 
      <-0.009184, 3.126806, 1.553953>, <0.151548, 3.536985, 1.441322>, <0.955202, 3.793829, 0.583522>, <1.055058, 4.237260, 0.570680>, 
      <-0.073467, 3.126806, 1.263149>, <0.087265, 3.536985, 1.150519>, <0.678819, 3.793829, 0.694477>, <0.778675, 4.237260, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.325290, 2.104019, 0.672703>, <0.058603, 2.104019, 0.730599>, <-0.122741, 2.104019, 1.002473>, <-0.057252, 2.104019, 1.267398>, 
      <0.352961, 2.406529, 0.715984>, <0.086273, 2.406529, 0.773880>, <-0.236885, 2.378022, 1.080366>, <-0.171396, 2.378022, 1.345291>, 
      <0.350494, 2.823872, 0.718909>, <0.082453, 2.823872, 0.770178>, <-0.240845, 2.849986, 1.072693>, <-0.181941, 2.849986, 1.339160>, 
      <0.323697, 3.126806, 0.678117>, <0.055656, 3.126806, 0.729386>, <-0.132371, 3.126806, 0.996682>, <-0.073467, 3.126806, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.712692, 2.104019, 1.100248>, <0.659257, 2.104019, 0.884086>, <0.542890, 2.104019, 0.625464>, <0.325290, 2.104019, 0.672703>, 
      <0.737887, 2.369360, 1.252370>, <0.684452, 2.369360, 1.036208>, <0.570560, 2.406529, 0.668745>, <0.352961, 2.406529, 0.715984>, 
      <0.726405, 2.858055, 1.261002>, <0.678344, 2.858055, 1.043582>, <0.569197, 2.823872, 0.677077>, <0.350494, 2.823872, 0.718909>, 
      <0.700384, 3.126806, 1.115132>, <0.652323, 3.126806, 0.897713>, <0.542400, 3.126806, 0.636285>, <0.323697, 3.126806, 0.678117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.579914, 2.104019, 1.702737>, <0.812597, 2.104019, 1.652223>, <0.769831, 2.104019, 1.331393>, <0.712692, 2.104019, 1.100248>, 
      <0.516103, 2.333612, 1.896236>, <0.748786, 2.333612, 1.845722>, <0.795026, 2.369360, 1.483515>, <0.737887, 2.369360, 1.252370>, 
      <0.493128, 2.891989, 1.902659>, <0.726992, 2.891989, 1.857927>, <0.777798, 2.858055, 1.493492>, <0.726405, 2.858055, 1.261002>, 
      <0.552715, 3.126806, 1.714146>, <0.786579, 3.126806, 1.669414>, <0.751777, 3.126806, 1.347623>, <0.700384, 3.126806, 1.115132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.579914, 2.104019, 1.702737>, <0.516103, 2.333612, 1.896236>, <0.493128, 2.891989, 1.902659>, <0.552715, 3.126806, 1.714146>, 
      <0.288870, 2.104019, 1.765921>, <0.225059, 2.333612, 1.959420>, <0.200607, 2.891989, 1.958610>, <0.260194, 3.126806, 1.770097>, 
      <0.014219, 2.104019, 1.556518>, <-0.099925, 2.378022, 1.634412>, <-0.117658, 2.849986, 1.629964>, <-0.009184, 3.126806, 1.553953>, 
      <-0.057252, 2.104019, 1.267398>, <-0.171396, 2.378022, 1.345291>, <-0.181941, 2.849986, 1.339160>, <-0.073467, 3.126806, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.136589, 1.081232, 0.385449>, <0.230985, 1.081232, 0.641503>, <0.525421, 1.081232, 0.783306>, <0.778675, 1.081232, 0.681636>, 
      <0.139470, 1.403868, 0.411465>, <0.233866, 1.403868, 0.667519>, <0.424876, 1.502667, 0.797505>, <0.678130, 1.502667, 0.695835>, 
      <0.296100, 1.784891, 0.627044>, <0.029412, 1.784891, 0.684940>, <0.038498, 1.716962, 0.892441>, <0.103988, 1.716962, 1.157366>, 
      <0.325290, 2.104019, 0.672703>, <0.058603, 2.104019, 0.730599>, <-0.122741, 2.104019, 1.002473>, <-0.057252, 2.104019, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.136589, 1.081232, 0.385449>, <0.133650, 0.752073, 0.358907>, <0.263214, 0.326017, 0.473085>, <0.306502, 0.000000, 0.503044>, 
      <0.230985, 1.081232, 0.641503>, <0.228046, 0.752073, 0.614961>, <0.111687, 0.326017, 0.700051>, <0.154975, 0.000000, 0.730010>, 
      <0.525421, 1.081232, 0.783306>, <0.611930, 0.718632, 0.771090>, <0.301283, 0.336303, 0.916217>, <0.213519, 0.000000, 1.051528>, 
      <0.778675, 1.081232, 0.681636>, <0.865183, 0.718632, 0.669420>, <0.532485, 0.336303, 1.061200>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506148, 1.081232, -0.057609>, <0.299510, 1.081232, 0.025347>, <0.059568, 1.081232, 0.176526>, <0.136589, 1.081232, 0.385449>, 
      <0.469852, 1.531785, 0.062096>, <0.263214, 1.531785, 0.145052>, <0.062449, 1.403868, 0.202542>, <0.139470, 1.403868, 0.411465>, 
      <0.674303, 1.699731, 0.868467>, <0.620868, 1.699731, 0.652306>, <0.513699, 1.784891, 0.579805>, <0.296100, 1.784891, 0.627044>, 
      <0.712692, 2.104019, 1.100248>, <0.659257, 2.104019, 0.884086>, <0.542890, 2.104019, 0.625464>, <0.325290, 2.104019, 0.672703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506148, 1.081232, -0.057609>, <0.536233, 0.707777, -0.156830>, <0.782503, 0.339233, 0.382492>, <0.882189, 0.000000, 0.541244>, 
      <0.299510, 1.081232, 0.025347>, <0.329595, 0.707777, -0.073874>, <0.593858, 0.339233, 0.264196>, <0.693544, 0.000000, 0.422947>, 
      <0.059568, 1.081232, 0.176526>, <0.056629, 0.752073, 0.149984>, <0.386850, 0.326017, 0.287895>, <0.430138, 0.000000, 0.317854>, 
      <0.136589, 1.081232, 0.385449>, <0.133650, 0.752073, 0.358907>, <0.263214, 0.326017, 0.473085>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <1.038884, 1.081232, -0.233252>, <0.727110, 1.081232, -0.146316>, <0.506148, 1.081232, -0.057609>, 
      <0.951527, 1.652112, 0.162718>, <0.869167, 1.652112, -0.060688>, <0.690815, 1.531785, -0.026611>, <0.469852, 1.531785, 0.062096>, 
      <0.708813, 1.640239, 1.311867>, <0.941496, 1.640239, 1.261353>, <0.731442, 1.699731, 1.099613>, <0.674303, 1.699731, 0.868467>, 
      <0.579914, 2.104019, 1.702737>, <0.812597, 2.104019, 1.652223>, <0.769831, 2.104019, 1.331393>, <0.712692, 2.104019, 1.100248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <1.246722, 0.659160, -0.137429>, <1.182372, 0.350362, 0.771983>, <1.205418, 0.000000, 1.066741>, 
      <1.038884, 1.081232, -0.233252>, <1.164362, 0.659160, -0.360834>, <1.314579, 0.350362, 0.573956>, <1.337625, 0.000000, 0.868714>, 
      <0.727110, 1.081232, -0.146316>, <0.757196, 0.707777, -0.245536>, <0.984225, 0.339233, 0.508989>, <1.083911, 0.000000, 0.667741>, 
      <0.506148, 1.081232, -0.057609>, <0.536233, 0.707777, -0.156830>, <0.782503, 0.339233, 0.382492>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <0.951527, 1.652112, 0.162718>, <0.708813, 1.640239, 1.311867>, <0.579914, 2.104019, 1.702737>, 
      <1.224261, 1.081232, 0.269593>, <1.054544, 1.652112, 0.442157>, <0.417769, 1.640239, 1.375051>, <0.288870, 2.104019, 1.765921>, 
      <1.055058, 1.081232, 0.570681>, <0.954513, 1.502667, 0.584879>, <0.175458, 1.716962, 1.446486>, <0.014219, 2.104019, 1.556518>, 
      <0.778675, 1.081232, 0.681636>, <0.678130, 1.502667, 0.695835>, <0.103988, 1.716962, 1.157366>, <-0.057252, 2.104019, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.121244, 1.081232, -0.009846>, <1.224261, 1.081232, 0.269593>, <1.055058, 1.081232, 0.570681>, <0.778675, 1.081232, 0.681636>, 
      <1.246722, 0.659160, -0.137429>, <1.349739, 0.659160, 0.142011>, <1.141566, 0.718632, 0.558464>, <0.865183, 0.718632, 0.669420>, 
      <1.182372, 0.350362, 0.771983>, <1.017006, 0.350362, 1.019678>, <0.784802, 0.336303, 1.219424>, <0.532485, 0.336303, 1.061200>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.169675, -0.058443, 0.568964>, <-0.427715, -0.058443, 0.480143>, <-0.742934, -0.049389, 0.605272>, <-0.824349, -0.049389, 0.865744>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.077858, -0.055343, 1.149915>, <-0.011429, -0.055343, 0.937387>, <0.040870, -0.058443, 0.641436>, <-0.169675, -0.058443, 0.568964>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.519688, -0.046232, 1.589722>, <-0.294549, -0.046232, 1.667217>, <-0.148892, -0.055343, 1.377175>, <-0.077858, -0.055343, 1.149915>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.519688, -0.046232, 1.589722>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.801295, -0.046232, 1.492789>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.913200, -0.049389, 1.150005>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.824349, -0.049389, 0.865744>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, 5.626361, 0.579594>, <-0.165728, 5.566828, 0.579594>, <-0.169374, 5.486522, 0.569774>, <-0.165728, 5.427918, 0.579594>, 
      <-0.423769, 5.626361, 0.490773>, <-0.423769, 5.566828, 0.490773>, <-0.427414, 5.486522, 0.480954>, <-0.423769, 5.427918, 0.490773>, 
      <-0.719824, 5.626361, 0.629163>, <-0.719824, 5.566828, 0.629163>, <-0.741634, 5.478515, 0.606616>, <-0.719824, 5.427918, 0.629163>, 
      <-0.801239, 5.626361, 0.889635>, <-0.801239, 5.566828, 0.889635>, <-0.823049, 5.478515, 0.867088>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, 5.626361, 1.146066>, <-0.056259, 5.566828, 1.146066>, <-0.076364, 5.483838, 1.149648>, <-0.056259, 5.427918, 1.146066>, 
      <0.010170, 5.626361, 0.933538>, <0.010170, 5.566828, 0.933538>, <-0.009935, 5.483838, 0.937120>, <0.010170, 5.427918, 0.933538>, 
      <0.044816, 5.626361, 0.652066>, <0.044816, 5.566828, 0.652066>, <0.041170, 5.486522, 0.642246>, <0.044816, 5.427918, 0.652066>, 
      <-0.165728, 5.626361, 0.579594>, <-0.165728, 5.566828, 0.579594>, <-0.169374, 5.486522, 0.569774>, <-0.165728, 5.427918, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, 5.626361, 1.592315>, <-0.482271, 5.566828, 1.592315>, <-0.517825, 5.475604, 1.589851>, <-0.482271, 5.427918, 1.592315>, 
      <-0.257132, 5.626361, 1.669811>, <-0.257132, 5.566828, 1.669811>, <-0.292686, 5.475604, 1.667346>, <-0.257132, 5.427918, 1.669811>, 
      <-0.127293, 5.626361, 1.373327>, <-0.127293, 5.566828, 1.373327>, <-0.147398, 5.483838, 1.376909>, <-0.127293, 5.427918, 1.373327>, 
      <-0.056259, 5.626361, 1.146066>, <-0.056259, 5.566828, 1.146066>, <-0.076364, 5.483838, 1.149648>, <-0.056259, 5.427918, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, 5.626361, 1.592315>, <-0.763878, 5.626361, 1.495382>, <-0.890089, 5.626361, 1.173896>, <-0.801239, 5.626361, 0.889635>, 
      <-0.482271, 5.566828, 1.592315>, <-0.763878, 5.566828, 1.495382>, <-0.890089, 5.566828, 1.173896>, <-0.801239, 5.566828, 0.889635>, 
      <-0.517825, 5.475604, 1.589851>, <-0.799432, 5.475604, 1.492918>, <-0.911900, 5.478515, 1.151348>, <-0.823049, 5.478515, 0.867088>, 
      <-0.482271, 5.427918, 1.592315>, <-0.763878, 5.427918, 1.495382>, <-0.890089, 5.427918, 1.173896>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079315, 4.237260, 0.812352>, <-0.302942, 4.237260, 0.968765>, <-0.365198, 4.237260, 1.289584>, <-0.202462, 4.237260, 1.508653>, 
      <-0.095667, 4.600611, 0.841447>, <-0.319294, 4.600611, 0.997861>, <-0.378389, 4.657299, 1.422767>, <-0.215653, 4.657299, 1.641836>, 
      <-0.143384, 5.068730, 0.639780>, <-0.401424, 5.068730, 0.550959>, <-0.558318, 5.053241, 0.796129>, <-0.639733, 5.053241, 1.056601>, 
      <-0.165728, 5.427918, 0.579594>, <-0.423769, 5.427918, 0.490773>, <-0.719824, 5.427918, 0.629163>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443163, 4.237260, 1.057078>, <0.310381, 4.237260, 0.878332>, <0.103150, 4.237260, 0.684729>, <-0.079315, 4.237260, 0.812352>, 
      <0.498345, 4.618864, 1.102730>, <0.365563, 4.618864, 0.923985>, <0.086798, 4.600611, 0.713825>, <-0.095667, 4.600611, 0.841447>, 
      <0.074864, 5.063210, 1.122702>, <0.141293, 5.063210, 0.910174>, <0.067160, 5.068730, 0.712251>, <-0.143384, 5.068730, 0.639780>, 
      <-0.056259, 5.427918, 1.146066>, <0.010170, 5.427918, 0.933538>, <0.044816, 5.427918, 0.652066>, <-0.165728, 5.427918, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 4.237260, 1.664096>, <0.748519, 4.237260, 1.527626>, <0.585149, 4.237260, 1.248215>, <0.443163, 4.237260, 1.057078>, 
      <0.654074, 4.679660, 1.800983>, <0.849187, 4.679660, 1.664513>, <0.640332, 4.618864, 1.293867>, <0.498345, 4.618864, 1.102730>, 
      <-0.199245, 5.048310, 1.611931>, <0.025894, 5.048310, 1.689427>, <0.003830, 5.063210, 1.349963>, <0.074864, 5.063210, 1.122702>, 
      <-0.482271, 5.427918, 1.592315>, <-0.257132, 5.427918, 1.669811>, <-0.127293, 5.427918, 1.373327>, <-0.056259, 5.427918, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 4.237260, 1.664096>, <0.654074, 4.679660, 1.800983>, <-0.199245, 5.048310, 1.611931>, <-0.482271, 5.427918, 1.592315>, 
      <0.309356, 4.237260, 1.834794>, <0.410023, 4.679660, 1.971681>, <-0.480853, 5.048310, 1.514998>, <-0.763878, 5.427918, 1.495382>, 
      <-0.024864, 4.237260, 1.747729>, <-0.038054, 4.657299, 1.880911>, <-0.728584, 5.053241, 1.340861>, <-0.890089, 5.427918, 1.173896>, 
      <-0.202462, 4.237260, 1.508653>, <-0.215653, 4.657299, 1.641836>, <-0.639733, 5.053241, 1.056601>, <-0.801239, 5.427918, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.062171, 3.126806, 0.395332>, <-0.179924, 3.126806, 0.149145>, <-0.486251, 3.126806, 0.035282>, <-0.728975, 3.126806, 0.160018>, 
      <-0.064112, 3.476210, 0.462942>, <-0.181865, 3.476210, 0.216754>, <-0.371764, 3.581238, 0.318136>, <-0.614488, 3.581238, 0.442872>, 
      <-0.063366, 3.882862, 0.783973>, <-0.286993, 3.882862, 0.940387>, <-0.348819, 3.715716, 1.124218>, <-0.186083, 3.715716, 1.343286>, 
      <-0.079315, 4.237260, 0.812352>, <-0.302942, 4.237260, 0.968765>, <-0.365198, 4.237260, 1.289584>, <-0.202462, 4.237260, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.389013, 3.126806, 0.870777>, <-0.190966, 3.126806, 0.769001>, <0.033908, 3.126806, 0.596205>, <-0.062171, 3.126806, 0.395332>, 
      <-0.237849, 3.517399, 0.902656>, <-0.039802, 3.517399, 0.800880>, <0.031967, 3.476210, 0.663814>, <-0.064112, 3.476210, 0.462942>, 
      <0.383466, 3.824432, 1.007690>, <0.250684, 3.824432, 0.828945>, <0.119099, 3.882862, 0.656351>, <-0.063366, 3.882862, 0.783973>, 
      <0.443163, 4.237260, 1.057078>, <0.310381, 4.237260, 0.878332>, <0.103150, 4.237260, 0.684729>, <-0.079315, 4.237260, 0.812352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005887, 3.126806, 0.880309>, <-0.903148, 3.126806, 1.095106>, <-0.600789, 3.126806, 0.979609>, <-0.389013, 3.126806, 0.870777>, 
      <-0.654901, 3.609153, 1.051319>, <-0.552162, 3.609153, 1.266116>, <-0.449625, 3.517399, 1.011488>, <-0.237849, 3.517399, 0.902656>, 
      <0.421587, 3.657960, 1.484850>, <0.616700, 3.657960, 1.348380>, <0.525452, 3.824432, 1.198827>, <0.383466, 3.824432, 1.007690>, 
      <0.553406, 4.237260, 1.664096>, <0.748519, 4.237260, 1.527626>, <0.585149, 4.237260, 1.248215>, <0.443163, 4.237260, 1.057078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.005887, 3.126806, 0.880309>, <-0.654901, 3.609153, 1.051319>, <0.421587, 3.657960, 1.484850>, <0.553406, 4.237260, 1.664096>, 
      <-1.134395, 3.126806, 0.611638>, <-0.783409, 3.609153, 0.782648>, <0.177536, 3.657960, 1.655548>, <0.309356, 4.237260, 1.834794>, 
      <-0.993867, 3.126806, 0.296146>, <-0.879380, 3.581238, 0.579000>, <-0.008485, 3.715716, 1.582362>, <-0.024864, 4.237260, 1.747729>, 
      <-0.728975, 3.126806, 0.160018>, <-0.614488, 3.581238, 0.442872>, <-0.186083, 3.715716, 1.343286>, <-0.202462, 4.237260, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.067467, 2.104019, 0.399568>, <-0.191285, 2.104019, 0.156375>, <-0.500339, 2.104019, 0.050139>, <-0.739897, 2.104019, 0.180852>, 
      <-0.064947, 2.404667, 0.338276>, <-0.188765, 2.404667, 0.095083>, <-0.564821, 2.354539, -0.115028>, <-0.804379, 2.354539, 0.015686>, 
      <-0.060498, 2.825556, 0.337040>, <-0.178251, 2.825556, 0.090852>, <-0.550444, 2.872004, -0.123316>, <-0.793168, 2.872004, 0.001420>, 
      <-0.062171, 3.126806, 0.395332>, <-0.179924, 3.126806, 0.149145>, <-0.486251, 3.126806, 0.035282>, <-0.728975, 3.126806, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.382426, 2.104019, 0.882967>, <-0.186963, 2.104019, 0.776314>, <0.033561, 2.104019, 0.597998>, <-0.067467, 2.104019, 0.399568>, 
      <-0.497652, 2.387256, 0.857171>, <-0.302188, 2.387256, 0.750518>, <0.036080, 2.404667, 0.536706>, <-0.064947, 2.404667, 0.338276>, 
      <-0.499449, 2.841451, 0.847487>, <-0.301402, 2.841451, 0.745711>, <0.035581, 2.825556, 0.537912>, <-0.060498, 2.825556, 0.337040>, 
      <-0.389013, 3.126806, 0.870777>, <-0.190966, 3.126806, 0.769001>, <0.033908, 3.126806, 0.596205>, <-0.062171, 3.126806, 0.395332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998874, 2.104019, 0.907784>, <-0.890843, 2.104019, 1.119969>, <-0.591439, 2.104019, 0.997014>, <-0.382426, 2.104019, 0.882967>, 
      <-1.176878, 2.337535, 0.818310>, <-1.068847, 2.337535, 1.030495>, <-0.706665, 2.387256, 0.971218>, <-0.497652, 2.387256, 0.857171>, 
      <-1.179499, 2.888217, 0.795721>, <-1.076760, 2.888217, 1.010518>, <-0.711224, 2.841451, 0.956319>, <-0.499449, 2.841451, 0.847487>, 
      <-1.005887, 3.126806, 0.880309>, <-0.903148, 3.126806, 1.095106>, <-0.600789, 3.126806, 0.979609>, <-0.389013, 3.126806, 0.870777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998874, 2.104019, 0.907784>, <-1.176878, 2.337535, 0.818310>, <-1.179499, 2.888217, 0.795721>, <-1.005887, 3.126806, 0.880309>, 
      <-1.134000, 2.104019, 0.642380>, <-1.312004, 2.337535, 0.552905>, <-1.308007, 2.888217, 0.527049>, <-1.134395, 3.126806, 0.611638>, 
      <-1.001334, 2.104019, 0.323503>, <-1.065815, 2.354539, 0.158337>, <-1.058060, 2.872004, 0.137549>, <-0.993867, 3.126806, 0.296146>, 
      <-0.739897, 2.104019, 0.180852>, <-0.804379, 2.354539, 0.015686>, <-0.793168, 2.872004, 0.001420>, <-0.728975, 3.126806, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079315, 1.081232, 0.812352>, <-0.302942, 1.081232, 0.968765>, <-0.365198, 1.081232, 1.289584>, <-0.202462, 1.081232, 1.508653>, 
      <-0.063934, 1.410573, 0.784173>, <-0.287561, 1.410573, 0.940586>, <-0.350615, 1.581443, 1.121077>, <-0.187879, 1.581443, 1.340146>, 
      <-0.070184, 1.779797, 0.465665>, <-0.194002, 1.779797, 0.222472>, <-0.389402, 1.673014, 0.334298>, <-0.628960, 1.673014, 0.465011>, 
      <-0.067467, 2.104019, 0.399568>, <-0.191285, 2.104019, 0.156375>, <-0.500339, 2.104019, 0.050139>, <-0.739897, 2.104019, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.079315, 1.081232, 0.812352>, <-0.094784, 0.749990, 0.840694>, <-0.143666, 0.326719, 0.639020>, <-0.165728, 0.000000, 0.579594>, 
      <-0.302942, 1.081232, 0.968765>, <-0.318411, 0.749990, 0.997107>, <-0.401706, 0.326719, 0.550200>, <-0.423769, 0.000000, 0.490773>, 
      <-0.365198, 1.081232, 1.289584>, <-0.376651, 0.688389, 1.421922>, <-0.558846, 0.344035, 0.795584>, <-0.719824, 0.000000, 0.629163>, 
      <-0.202462, 1.081232, 1.508653>, <-0.213915, 0.688389, 1.640991>, <-0.640260, 0.344035, 1.056055>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443163, 1.081232, 1.057078>, <0.310381, 1.081232, 0.878332>, <0.103150, 1.081232, 0.684729>, <-0.079315, 1.081232, 0.812352>, 
      <0.382688, 1.471339, 1.008297>, <0.249907, 1.471339, 0.829551>, <0.118531, 1.410573, 0.656550>, <-0.063934, 1.410573, 0.784173>, 
      <-0.233066, 1.736876, 0.916405>, <-0.037602, 1.736876, 0.809751>, <0.030843, 1.779797, 0.664095>, <-0.070184, 1.779797, 0.465665>, 
      <-0.382426, 2.104019, 0.882967>, <-0.186963, 2.104019, 0.776314>, <0.033561, 2.104019, 0.597998>, <-0.067467, 2.104019, 0.399568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443163, 1.081232, 1.057078>, <0.497637, 0.729837, 1.101018>, <0.073733, 0.333080, 1.122904>, <-0.056259, 0.000000, 1.146066>, 
      <0.310381, 1.081232, 0.878332>, <0.364855, 0.729837, 0.922273>, <0.140162, 0.333080, 0.910376>, <0.010170, 0.000000, 0.933538>, 
      <0.103150, 1.081232, 0.684729>, <0.087680, 0.749990, 0.713071>, <0.066878, 0.326719, 0.711492>, <0.044816, 0.000000, 0.652066>, 
      <-0.079315, 1.081232, 0.812352>, <-0.094784, 0.749990, 0.840694>, <-0.143666, 0.326719, 0.639020>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.748519, 1.081232, 1.527626>, <0.585149, 1.081232, 1.248215>, <0.443163, 1.081232, 1.057078>, 
      <0.416513, 1.638769, 1.482704>, <0.611626, 1.638769, 1.346234>, <0.524675, 1.471339, 1.199433>, <0.382688, 1.471339, 1.008297>, 
      <-0.649730, 1.645991, 1.083283>, <-0.541699, 1.645991, 1.295468>, <-0.442079, 1.736876, 1.030451>, <-0.233066, 1.736876, 0.916405>, 
      <-0.998874, 2.104019, 0.907784>, <-0.890843, 2.104019, 1.119969>, <-0.591439, 2.104019, 0.997014>, <-0.382426, 2.104019, 0.882967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.655651, 0.664810, 1.799576>, <-0.199640, 0.349216, 1.611903>, <-0.482271, 0.000000, 1.592315>, 
      <0.748519, 1.081232, 1.527626>, <0.850764, 0.664810, 1.663107>, <0.025499, 0.349216, 1.689399>, <-0.257132, 0.000000, 1.669811>, 
      <0.585149, 1.081232, 1.248215>, <0.639623, 0.729837, 1.292155>, <0.002699, 0.333080, 1.350164>, <-0.127293, 0.000000, 1.373327>, 
      <0.443163, 1.081232, 1.057078>, <0.497637, 0.729837, 1.101018>, <0.073733, 0.333080, 1.122904>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.416513, 1.638769, 1.482704>, <-0.649730, 1.645991, 1.083283>, <-0.998874, 2.104019, 0.907784>, 
      <0.309356, 1.081232, 1.834794>, <0.172463, 1.638769, 1.653403>, <-0.784857, 1.645991, 0.817879>, <-1.134000, 2.104019, 0.642380>, 
      <-0.024864, 1.081232, 1.747729>, <-0.010280, 1.581443, 1.579222>, <-0.890397, 1.673014, 0.607662>, <-1.001334, 2.104019, 0.323503>, 
      <-0.202462, 1.081232, 1.508653>, <-0.187879, 1.581443, 1.340146>, <-0.628960, 1.673014, 0.465011>, <-0.739897, 2.104019, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.553406, 1.081232, 1.664096>, <0.309356, 1.081232, 1.834794>, <-0.024864, 1.081232, 1.747729>, <-0.202462, 1.081232, 1.508653>, 
      <0.655651, 0.664810, 1.799576>, <0.411600, 0.664810, 1.970275>, <-0.036317, 0.688389, 1.880066>, <-0.213915, 0.688389, 1.640991>, 
      <-0.199640, 0.349216, 1.611903>, <-0.481248, 0.349216, 1.514971>, <-0.729111, 0.344035, 1.340316>, <-0.640260, 0.344035, 1.056055>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.527141, -0.052914, 0.002769>, <0.527141, -0.052914, -0.270131>, <0.303971, -0.046681, -0.527610>, <0.031183, -0.046681, -0.519816>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.009846, -0.057873, 0.277982>, <0.232423, -0.057873, 0.271622>, <0.527141, -0.052914, 0.225437>, <0.527141, -0.052914, 0.002769>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.552912, -0.050439, -0.000371>, <-0.552912, -0.050439, 0.237733>, <-0.228160, -0.057873, 0.284782>, <0.009846, -0.057873, 0.277982>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.552912, -0.050439, -0.000371>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.552912, -0.050439, -0.298194>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.266518, -0.046681, -0.511310>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.031183, -0.046681, -0.519816>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 5.626361, 0.000000>, <0.500000, 5.566828, 0.000000>, <0.525410, 5.481693, 0.002592>, <0.500000, 5.427918, 0.000000>, 
      <0.500000, 5.626361, -0.272899>, <0.500000, 5.566828, -0.272899>, <0.525410, 5.481693, -0.270307>, <0.500000, 5.427918, -0.272899>, 
      <0.272788, 5.626361, -0.507794>, <0.272788, 5.566828, -0.507794>, <0.302391, 5.476022, -0.526606>, <0.272788, 5.427918, -0.507794>, 
      <0.000000, 5.626361, -0.500000>, <0.000000, 5.566828, -0.500000>, <0.029603, 5.476022, -0.518812>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 5.626361, 0.287879>, <0.000000, 5.566828, 0.287879>, <0.009109, 5.486033, 0.278723>, <0.000000, 5.427918, 0.287879>, 
      <0.222577, 5.626361, 0.281520>, <0.222577, 5.566828, 0.281520>, <0.231686, 5.486033, 0.272364>, <0.222577, 5.427918, 0.281520>, 
      <0.500000, 5.626361, 0.222668>, <0.500000, 5.566828, 0.222668>, <0.525410, 5.481693, 0.225260>, <0.500000, 5.427918, 0.222668>, 
      <0.500000, 5.626361, 0.000000>, <0.500000, 5.566828, 0.000000>, <0.525410, 5.481693, 0.002592>, <0.500000, 5.427918, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, 5.626361, 0.030303>, <-0.560606, 5.566828, 0.030303>, <-0.553362, 5.479470, 0.001422>, <-0.560606, 5.427918, 0.030303>, 
      <-0.560606, 5.626361, 0.268407>, <-0.560606, 5.566828, 0.268407>, <-0.553362, 5.479470, 0.239525>, <-0.560606, 5.427918, 0.268407>, 
      <-0.238007, 5.626361, 0.294679>, <-0.238007, 5.566828, 0.294679>, <-0.228898, 5.486033, 0.285523>, <-0.238007, 5.427918, 0.294679>, 
      <0.000000, 5.626361, 0.287879>, <0.000000, 5.566828, 0.287879>, <0.009109, 5.486033, 0.278723>, <0.000000, 5.427918, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, 5.626361, 0.030303>, <-0.560606, 5.626361, -0.267520>, <-0.297702, 5.626361, -0.491494>, <0.000000, 5.626361, -0.500000>, 
      <-0.560606, 5.566828, 0.030303>, <-0.560606, 5.566828, -0.267520>, <-0.297702, 5.566828, -0.491494>, <0.000000, 5.566828, -0.500000>, 
      <-0.553362, 5.479470, 0.001422>, <-0.553362, 5.479470, -0.296401>, <-0.268099, 5.476022, -0.510306>, <0.029603, 5.476022, -0.518812>, 
      <-0.560606, 5.427918, 0.030303>, <-0.560606, 5.427918, -0.267520>, <-0.297702, 5.427918, -0.491494>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.156367, 4.237260, -0.066958>, <-0.377048, 4.237260, -0.227501>, <-0.700661, 4.237260, -0.181950>, <-0.854836, 4.237260, 0.043226>, 
      <-0.211176, 4.633984, -0.146791>, <-0.431857, 4.633984, -0.307334>, <-0.857792, 4.676394, -0.230798>, <-1.011967, 4.676394, -0.005622>, 
      <0.325701, 5.059040, -0.017781>, <0.325701, 5.059040, -0.290680>, <0.039604, 5.048995, -0.359611>, <-0.233184, 5.048995, -0.351817>, 
      <0.500000, 5.427918, 0.000000>, <0.500000, 5.427918, -0.272899>, <0.272788, 5.427918, -0.507794>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217716, 4.237260, 0.506724>, <-0.091919, 4.237260, 0.322995>, <0.023694, 4.237260, 0.064035>, <-0.156367, 4.237260, -0.066958>, 
      <-0.259454, 4.603884, 0.503398>, <-0.133658, 4.603884, 0.319669>, <-0.031115, 4.633984, -0.015799>, <-0.211176, 4.633984, -0.146791>, 
      <-0.056458, 5.067698, 0.344630>, <0.166119, 5.067698, 0.338270>, <0.325701, 5.059040, 0.204887>, <0.325701, 5.059040, -0.017781>, 
      <0.000000, 5.427918, 0.287879>, <0.222577, 5.427918, 0.281520>, <0.500000, 5.427918, 0.222668>, <0.500000, 5.427918, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 4.237260, 0.808531>, <-0.563259, 4.237260, 0.948604>, <-0.352233, 4.237260, 0.703189>, <-0.217716, 4.237260, 0.506724>, 
      <-0.865763, 4.650181, 0.862675>, <-0.673220, 4.650181, 1.002748>, <-0.393971, 4.603884, 0.699863>, <-0.259454, 4.603884, 0.503398>, 
      <-0.613017, 5.054936, 0.239262>, <-0.613017, 5.054936, 0.477366>, <-0.294464, 5.067698, 0.351430>, <-0.056458, 5.067698, 0.344630>, 
      <-0.560606, 5.427918, 0.030303>, <-0.560606, 5.427918, 0.268407>, <-0.238007, 5.427918, 0.294679>, <0.000000, 5.427918, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 4.237260, 0.808531>, <-0.865763, 4.650181, 0.862675>, <-0.613017, 5.054936, 0.239262>, <-0.560606, 5.427918, 0.030303>, 
      <-0.996637, 4.237260, 0.633326>, <-1.106599, 4.650181, 0.687470>, <-0.613017, 5.054936, -0.058561>, <-0.560606, 5.427918, -0.267520>, 
      <-1.023091, 4.237260, 0.288967>, <-1.180222, 4.676394, 0.240119>, <-0.530886, 5.048995, -0.343312>, <-0.297702, 5.427918, -0.491494>, 
      <-0.854836, 4.237260, 0.043226>, <-1.011967, 4.676394, -0.005622>, <-0.233184, 5.048995, -0.351817>, <0.000000, 5.427918, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.817907, 3.126806, 0.463057>, <1.012365, 3.126806, 0.271588>, <1.020327, 3.126806, -0.055119>, <0.823383, 3.126806, -0.244029>, 
      <0.627449, 3.545497, 0.362485>, <0.821907, 3.545497, 0.171016>, <0.648626, 3.605394, 0.013256>, <0.451682, 3.605394, -0.175654>, 
      <-0.093174, 3.779848, 0.025088>, <-0.313855, 3.779848, -0.135455>, <-0.496329, 3.666211, -0.118428>, <-0.650504, 3.666211, 0.106748>, 
      <-0.156367, 4.237260, -0.066958>, <-0.377048, 4.237260, -0.227501>, <-0.700661, 4.237260, -0.181950>, <-0.854836, 4.237260, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.261970, 3.126806, 0.308754>, <0.422664, 3.126806, 0.462892>, <0.659242, 3.126806, 0.619283>, <0.817907, 3.126806, 0.463057>, 
      <0.182844, 3.484314, 0.342564>, <0.343538, 3.484314, 0.496702>, <0.468784, 3.545497, 0.518711>, <0.627449, 3.545497, 0.362485>, 
      <-0.176124, 3.871918, 0.510038>, <-0.050327, 3.871918, 0.326309>, <0.086887, 3.779848, 0.156080>, <-0.093174, 3.779848, 0.025088>, 
      <-0.217716, 4.237260, 0.506724>, <-0.091919, 4.237260, 0.322995>, <0.023694, 4.237260, 0.064035>, <-0.156367, 4.237260, -0.066958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052183, 3.126806, -0.271430>, <-0.117481, 3.126806, -0.104375>, <0.090137, 3.126806, 0.143931>, <0.261970, 3.126806, 0.308754>, 
      <-0.111563, 3.571147, -0.046815>, <-0.281227, 3.571147, 0.120240>, <0.011011, 3.484314, 0.177740>, <0.182844, 3.484314, 0.342564>, 
      <-0.621998, 3.734806, 0.742647>, <-0.429455, 3.734806, 0.882720>, <-0.310640, 3.871918, 0.706503>, <-0.176124, 3.871918, 0.510038>, 
      <-0.755802, 4.237260, 0.808531>, <-0.563259, 4.237260, 0.948604>, <-0.352233, 4.237260, 0.703189>, <-0.217716, 4.237260, 0.506724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.052183, 3.126806, -0.271430>, <-0.111563, 3.571147, -0.046815>, <-0.621998, 3.734806, 0.742647>, <-0.755802, 4.237260, 0.808531>, 
      <0.264401, 3.126806, -0.480385>, <0.100654, 3.571147, -0.255771>, <-0.862833, 3.734806, 0.567442>, <-0.996637, 4.237260, 0.633326>, 
      <0.608452, 3.126806, -0.450192>, <0.236751, 3.605394, -0.381818>, <-0.818759, 3.666211, 0.352489>, <-1.023091, 4.237260, 0.288967>, 
      <0.823383, 3.126806, -0.244029>, <0.451682, 3.605394, -0.175654>, <-0.650504, 3.666211, 0.106748>, <-0.854836, 4.237260, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.814019, 2.104019, 0.445460>, <1.003672, 2.104019, 0.249231>, <1.003535, 2.104019, -0.077573>, <0.801970, 2.104019, -0.261544>, 
      <0.942511, 2.373799, 0.515361>, <1.132164, 2.373799, 0.319132>, <1.197087, 2.339938, -0.110702>, <0.995521, 2.339938, -0.294673>, 
      <0.942043, 2.853912, 0.528608>, <1.136501, 2.853912, 0.337139>, <1.207420, 2.885913, -0.089535>, <1.010475, 2.885913, -0.278445>, 
      <0.817907, 3.126806, 0.463057>, <1.012365, 3.126806, 0.271588>, <1.020327, 3.126806, -0.055119>, <0.823383, 3.126806, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254429, 2.104019, 0.304983>, <0.418893, 2.104019, 0.455091>, <0.659275, 2.104019, 0.605570>, <0.814019, 2.104019, 0.445460>, 
      <0.324175, 2.401444, 0.276198>, <0.488639, 2.401444, 0.426307>, <0.787767, 2.373799, 0.675471>, <0.942511, 2.373799, 0.515361>, 
      <0.327998, 2.828479, 0.280541>, <0.488692, 2.828479, 0.434680>, <0.783378, 2.853912, 0.684834>, <0.942043, 2.853912, 0.528608>, 
      <0.261970, 3.126806, 0.308754>, <0.422664, 3.126806, 0.462892>, <0.659242, 3.126806, 0.619283>, <0.817907, 3.126806, 0.463057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030328, 2.104019, -0.269824>, <-0.135143, 2.104019, -0.098615>, <0.078564, 2.104019, 0.144469>, <0.254429, 2.104019, 0.304983>, 
      <0.131534, 2.360242, -0.405097>, <-0.033937, 2.360242, -0.233888>, <0.148310, 2.401444, 0.115684>, <0.324175, 2.401444, 0.276198>, 
      <0.148067, 2.866616, -0.402956>, <-0.021597, 2.866616, -0.235901>, <0.156165, 2.828479, 0.115718>, <0.327998, 2.828479, 0.280541>, 
      <0.052183, 3.126806, -0.271430>, <-0.117481, 3.126806, -0.104375>, <0.090137, 3.126806, 0.143931>, <0.261970, 3.126806, 0.308754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.030328, 2.104019, -0.269824>, <0.131534, 2.360242, -0.405097>, <0.148067, 2.866616, -0.402956>, <0.052183, 3.126806, -0.271430>, 
      <0.237302, 2.104019, -0.483975>, <0.338508, 2.360242, -0.619248>, <0.360284, 2.866616, -0.611912>, <0.264401, 3.126806, -0.480385>, 
      <0.581996, 2.104019, -0.462317>, <0.775547, 2.339938, -0.495447>, <0.795544, 2.885913, -0.484608>, <0.608452, 3.126806, -0.450192>, 
      <0.801970, 2.104019, -0.261544>, <0.995521, 2.339938, -0.294673>, <1.010475, 2.885913, -0.278445>, <0.823383, 3.126806, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.156367, 1.081232, -0.066958>, <-0.377048, 1.081232, -0.227501>, <-0.700661, 1.081232, -0.181950>, <-0.854836, 1.081232, 0.043226>, 
      <-0.091347, 1.516885, 0.025278>, <-0.312028, 1.516885, -0.135265>, <-0.491255, 1.630623, -0.119685>, <-0.645429, 1.630623, 0.105491>, 
      <0.625591, 1.708398, 0.342953>, <0.815244, 1.708398, 0.146724>, <0.630723, 1.649599, -0.013760>, <0.429157, 1.649599, -0.197731>, 
      <0.814019, 2.104019, 0.445460>, <1.003672, 2.104019, 0.249231>, <1.003535, 2.104019, -0.077573>, <0.801970, 2.104019, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.156367, 1.081232, -0.066958>, <-0.211268, 0.713382, -0.144839>, <0.326766, 0.337743, -0.017672>, <0.500000, 0.000000, 0.000000>, 
      <-0.377048, 1.081232, -0.227501>, <-0.431948, 0.713382, -0.305381>, <0.326766, 0.337743, -0.290571>, <0.500000, 0.000000, -0.272899>, 
      <-0.700661, 1.081232, -0.181950>, <-0.858081, 0.668232, -0.228757>, <0.039983, 0.348506, -0.359852>, <0.272788, 0.000000, -0.507794>, 
      <-0.854836, 1.081232, 0.043226>, <-1.012256, 0.668232, -0.003581>, <-0.232805, 0.348506, -0.352058>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217716, 1.081232, 0.506724>, <-0.091919, 1.081232, 0.322995>, <0.023694, 1.081232, 0.064035>, <-0.156367, 1.081232, -0.066958>, 
      <-0.176501, 1.422066, 0.509495>, <-0.050704, 1.422066, 0.325766>, <0.088714, 1.516885, 0.156270>, <-0.091347, 1.516885, 0.025278>, 
      <0.176391, 1.771232, 0.337190>, <0.340855, 1.771232, 0.487299>, <0.470847, 1.708398, 0.503064>, <0.625591, 1.708398, 0.342953>, 
      <0.254429, 2.104019, 0.304983>, <0.418893, 2.104019, 0.455091>, <0.659275, 2.104019, 0.605570>, <0.814019, 2.104019, 0.445460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.217716, 1.081232, 0.506724>, <-0.258211, 0.746352, 0.504002>, <-0.055791, 0.327924, 0.343959>, <0.000000, 0.000000, 0.287879>, 
      <-0.091919, 1.081232, 0.322995>, <-0.132415, 0.746352, 0.320273>, <0.166786, 0.327924, 0.337600>, <0.222577, 0.000000, 0.281520>, 
      <0.023694, 1.081232, 0.064035>, <-0.031206, 0.713382, -0.013846>, <0.326766, 0.337743, 0.204996>, <0.500000, 0.000000, 0.222668>, 
      <-0.156367, 1.081232, -0.066958>, <-0.211268, 0.713382, -0.144839>, <0.326766, 0.337743, -0.017672>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.563259, 1.081232, 0.948604>, <-0.352233, 1.081232, 0.703189>, <-0.217716, 1.081232, 0.506724>, 
      <-0.620680, 1.562332, 0.739905>, <-0.428137, 1.562332, 0.879978>, <-0.311017, 1.422066, 0.705960>, <-0.176501, 1.422066, 0.509495>, 
      <-0.136006, 1.682913, -0.047501>, <-0.301477, 1.682913, 0.123708>, <0.000526, 1.771232, 0.176676>, <0.176391, 1.771232, 0.337190>, 
      <0.030328, 2.104019, -0.269824>, <-0.135143, 2.104019, -0.098615>, <0.078564, 2.104019, 0.144469>, <0.254429, 2.104019, 0.304983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.864006, 0.695973, 0.863486>, <-0.612807, 0.342219, 0.238422>, <-0.560606, 0.000000, 0.030303>, 
      <-0.563259, 1.081232, 0.948604>, <-0.671463, 0.695973, 1.003559>, <-0.612807, 0.342219, 0.476525>, <-0.560606, 0.000000, 0.268407>, 
      <-0.352233, 1.081232, 0.703189>, <-0.392728, 0.746352, 0.700467>, <-0.293797, 0.327924, 0.350760>, <-0.238007, 0.000000, 0.294679>, 
      <-0.217716, 1.081232, 0.506724>, <-0.258211, 0.746352, 0.504002>, <-0.055791, 0.327924, 0.343959>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.620680, 1.562332, 0.739905>, <-0.136006, 1.682913, -0.047501>, <0.030328, 2.104019, -0.269824>, 
      <-0.996637, 1.081232, 0.633326>, <-0.861516, 1.562332, 0.564700>, <0.070968, 1.682913, -0.261651>, <0.237302, 2.104019, -0.483975>, 
      <-1.023091, 1.081232, 0.288967>, <-0.813685, 1.630623, 0.351231>, <0.209183, 1.649599, -0.398504>, <0.581996, 2.104019, -0.462317>, 
      <-0.854836, 1.081232, 0.043226>, <-0.645429, 1.630623, 0.105491>, <0.429157, 1.649599, -0.197731>, <0.801970, 2.104019, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.755802, 1.081232, 0.808531>, <-0.996637, 1.081232, 0.633326>, <-1.023091, 1.081232, 0.288967>, <-0.854836, 1.081232, 0.043226>, 
      <-0.864006, 0.695973, 0.863486>, <-1.104841, 0.695973, 0.688281>, <-1.180511, 0.668232, 0.242160>, <-1.012256, 0.668232, -0.003581>, 
      <-0.612807, 0.342219, 0.238422>, <-0.612807, 0.342219, -0.059401>, <-0.530507, 0.348506, -0.343552>, <-0.232805, 0.348506, -0.352058>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.04242, -0.064368, 0.015153>
}
#declare segMstraightMB2 = union {
  object { // Blatt54->Blatt5
    Blatt5
    rotate <0.0, 0.0, 128.875092>
    translate  <-0.519128, -1.070326, -2.198448>
  }
  object { // Blatt55->Blatt5
    Blatt5
    rotate <0.0, 0.0, -115.116074>
    translate  <0.706542, -0.813839, 1.562842>
  }
  object { Blatt56 }
  object { sPatchObj19 }
  translate  <-0.099573, 0.695127, 5.900966>
}
#declare BezPtch020 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt59 = union {
  cone { // Cone020
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch020 }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 3.761748, 2.590573>
}
#declare sPatchObj20 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382950, -0.198443, 1.038181>, <0.231423, -0.198443, 1.265148>, <0.289967, -0.198443, 1.586665>, <0.521168, -0.198443, 1.731648>, 
      <0.382950, -0.138910, 1.038181>, <0.231423, -0.138910, 1.265148>, <0.289967, -0.138910, 1.586665>, <0.521168, -0.138910, 1.731648>, 
      <0.414651, -0.048850, 1.050547>, <0.263124, -0.048850, 1.277514>, <0.300659, -0.048722, 1.619162>, <0.531860, -0.048722, 1.764145>, 
      <0.382950, 0.000000, 1.038181>, <0.231423, 0.000000, 1.265148>, <0.289967, 0.000000, 1.586665>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.958637, -0.198443, 1.076381>, <0.769992, -0.198443, 0.958085>, <0.506586, -0.198443, 0.852992>, <0.382950, -0.198443, 1.038181>, 
      <0.958637, -0.138910, 1.076381>, <0.769992, -0.138910, 0.958085>, <0.506586, -0.138910, 0.852992>, <0.382950, -0.138910, 1.038181>, 
      <0.993774, -0.039753, 1.103386>, <0.805129, -0.039753, 0.985090>, <0.538288, -0.048850, 0.865358>, <0.414651, -0.048850, 1.050547>, 
      <0.958637, 0.000000, 1.076381>, <0.769992, 0.000000, 0.958085>, <0.506586, 0.000000, 0.852992>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.414073, -0.198443, 1.403851>, <1.160359, -0.198443, 1.202878>, <0.958637, -0.198443, 1.076381>, 
      <1.281866, -0.138910, 1.601878>, <1.414073, -0.138910, 1.403851>, <1.160359, -0.138910, 1.202878>, <0.958637, -0.138910, 1.076381>, 
      <1.305480, -0.035894, 1.643087>, <1.437687, -0.035894, 1.445060>, <1.195496, -0.039753, 1.229883>, <0.993774, -0.039753, 1.103386>, 
      <1.281866, 0.000000, 1.601878>, <1.414073, 0.000000, 1.403851>, <1.160359, 0.000000, 1.202878>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.281866, -0.138910, 1.601878>, <1.305480, -0.035894, 1.643087>, <1.281866, 0.000000, 1.601878>, 
      <1.116500, -0.198443, 1.849573>, <1.116500, -0.138910, 1.849573>, <1.140114, -0.035894, 1.890782>, <1.116500, 0.000000, 1.849573>, 
      <0.773485, -0.198443, 1.889873>, <0.773485, -0.138910, 1.889873>, <0.784177, -0.048722, 1.922369>, <0.773485, 0.000000, 1.889873>, 
      <0.521168, -0.198443, 1.731648>, <0.521168, -0.138910, 1.731648>, <0.531860, -0.048722, 1.764145>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>, 
      <0.467505, 5.626361, -1.348637>, <0.467505, 5.566828, -1.348637>, <0.509780, 5.466167, -1.365785>, <0.467505, 5.427918, -1.348637>, 
      <0.526073, 5.626361, -1.027124>, <0.526073, 5.566828, -1.027124>, <0.576188, 5.458817, -1.035948>, <0.526073, 5.427918, -1.027124>, 
      <0.757285, 5.626361, -0.882157>, <0.757285, 5.566828, -0.882157>, <0.807400, 5.458817, -0.890982>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>, 
      <1.006052, 5.626361, -1.655739>, <1.006052, 5.566828, -1.655739>, <1.048927, 5.459842, -1.681945>, <1.006052, 5.427918, -1.655739>, 
      <0.742638, 5.626361, -1.760813>, <0.742638, 5.566828, -1.760813>, <0.784913, 5.466167, -1.777961>, <0.742638, 5.427918, -1.760813>, 
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.517973, 5.566828, -1.011983>, <1.566262, 5.454522, -1.034444>, <1.517973, 5.427918, -1.011983>, 
      <1.650165, 5.626361, -1.210019>, <1.650165, 5.566828, -1.210019>, <1.698454, 5.454522, -1.232481>, <1.650165, 5.427918, -1.210019>, 
      <1.396437, 5.626361, -1.410974>, <1.396437, 5.566828, -1.410974>, <1.439313, 5.459842, -1.437179>, <1.396437, 5.427918, -1.410974>, 
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.352625, 5.626361, -0.764276>, <1.009613, 5.626361, -0.723951>, <0.757285, 5.626361, -0.882157>, 
      <1.517973, 5.566828, -1.011983>, <1.352625, 5.566828, -0.764276>, <1.009613, 5.566828, -0.723951>, <0.757285, 5.566828, -0.882157>, 
      <1.566262, 5.454522, -1.034444>, <1.400914, 5.454522, -0.786737>, <1.059728, 5.458817, -0.732776>, <0.807400, 5.458817, -0.890982>, 
      <1.517973, 5.427918, -1.011983>, <1.352625, 5.427918, -0.764276>, <1.009613, 5.427918, -0.723951>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>, 
      <-0.416768, 4.721273, -1.247418>, <-0.689604, 4.721273, -1.253336>, <-0.729103, 4.787694, -0.873656>, <-0.727227, 4.787694, -0.600763>, 
      <0.228340, 5.074441, -1.417145>, <0.076830, 5.074441, -1.190167>, <-0.060671, 5.066156, -0.923812>, <0.170541, 5.066156, -0.778846>, 
      <0.619016, 5.427918, -1.575614>, <0.467505, 5.427918, -1.348637>, <0.526073, 5.427918, -1.027124>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>, 
      <0.010389, 4.716106, -0.789508>, <0.008858, 4.716106, -1.012170>, <-0.194153, 4.721273, -1.242589>, <-0.416768, 4.721273, -1.247418>, 
      <0.710236, 5.067195, -1.241350>, <0.521582, 5.067195, -1.359633>, <0.351963, 5.074441, -1.602344>, <0.228340, 5.074441, -1.417145>, 
      <1.194706, 5.427918, -1.537457>, <1.006052, 5.427918, -1.655739>, <0.742638, 5.427918, -1.760813>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>, 
      <-0.061860, 4.746262, -0.146843>, <0.176188, 4.746262, -0.141679>, <0.012026, 4.716106, -0.551410>, <0.010389, 4.716106, -0.789508>, 
      <0.854156, 5.062198, -0.703210>, <0.986348, 5.062198, -0.901247>, <0.911968, 5.067195, -1.114868>, <0.710236, 5.067195, -1.241350>, 
      <1.517973, 5.427918, -1.011983>, <1.650165, 5.427918, -1.210019>, <1.396437, 5.427918, -1.410974>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.061860, 4.746262, -0.146843>, <0.854156, 5.062198, -0.703210>, <1.517973, 5.427918, -1.011983>, 
      <-1.059745, 4.370247, 0.042078>, <-0.359613, 4.746262, -0.153301>, <0.688808, 5.062198, -0.455503>, <1.352625, 5.427918, -0.764276>, 
      <-1.277965, 4.370247, -0.225622>, <-0.725179, 4.787694, -0.302946>, <0.422869, 5.066156, -0.620640>, <1.009613, 5.427918, -0.723951>, 
      <-1.280013, 4.370247, -0.523439>, <-0.727227, 4.787694, -0.600763>, <0.170541, 5.066156, -0.778846>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>, 
      <-1.479019, 3.584063, -0.349267>, <-1.529457, 3.584063, -0.617465>, <-1.933409, 3.620178, -0.614618>, <-2.200057, 3.620178, -0.556540>, 
      <-1.108076, 4.032892, -0.786688>, <-1.380911, 4.032892, -0.792606>, <-1.646320, 4.095040, -0.745355>, <-1.644443, 4.095040, -0.472462>, 
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>, 
      <-1.721332, 3.679914, 0.147818>, <-1.503764, 3.679914, 0.100430>, <-1.437864, 3.584063, -0.130435>, <-1.479019, 3.584063, -0.349267>, 
      <-0.975400, 4.037891, -0.234253>, <-0.976931, 4.037891, -0.456916>, <-0.885461, 4.032892, -0.781859>, <-1.108076, 4.032892, -0.786688>, 
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>, 
      <-2.344436, 3.751648, 0.263985>, <-2.300429, 3.751648, 0.497986>, <-1.953981, 3.679914, 0.198490>, <-1.721332, 3.679914, 0.147818>, 
      <-1.344142, 4.057594, 0.210992>, <-1.106095, 4.057594, 0.216155>, <-0.973762, 4.037891, 0.003845>, <-0.975400, 4.037891, -0.234253>, 
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.344436, 3.751648, 0.263985>, <-1.344142, 4.057594, 0.210992>, <-0.761991, 4.370247, 0.048536>, 
      <-2.739142, 3.171135, -0.132044>, <-2.399481, 3.751648, -0.028708>, <-1.641896, 4.057594, 0.204533>, <-1.059745, 4.370247, 0.042078>, 
      <-2.522163, 3.171135, -0.400751>, <-2.491058, 3.620178, -0.493158>, <-1.642395, 4.095040, -0.174646>, <-1.277965, 4.370247, -0.225622>, 
      <-2.231162, 3.171135, -0.464133>, <-2.200057, 3.620178, -0.556540>, <-1.644443, 4.095040, -0.472462>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>, 
      <-1.919775, 2.347050, 0.484065>, <-1.665213, 2.347050, 0.385715>, <-1.646940, 2.276974, 0.044790>, <-1.752520, 2.276974, -0.206858>, 
      <-1.775348, 2.857208, 0.150833>, <-1.825786, 2.857208, -0.117365>, <-1.994206, 2.742499, -0.434003>, <-2.260854, 2.742499, -0.375925>, 
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>, 
      <-2.413154, 2.272171, 0.257782>, <-2.327008, 2.272171, 0.463110>, <-2.127480, 2.347050, 0.564313>, <-1.919775, 2.347050, 0.484065>, 
      <-2.281834, 2.896930, 0.397674>, <-2.064266, 2.896930, 0.350287>, <-1.734194, 2.857208, 0.369665>, <-1.775348, 2.857208, 0.150833>, 
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>, 
      <-2.484832, 2.246145, -0.367567>, <-2.706935, 2.246145, -0.281756>, <-2.505273, 2.272171, 0.038220>, <-2.413154, 2.272171, 0.257782>, 
      <-2.891284, 2.817033, 0.097616>, <-2.847276, 2.817033, 0.331618>, <-2.514483, 2.896930, 0.448347>, <-2.281834, 2.896930, 0.397674>, 
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.484832, 2.246145, -0.367567>, <-2.891284, 2.817033, 0.097616>, <-2.684097, 3.171135, 0.160649>, 
      <-1.862034, 2.015361, -0.477984>, <-2.207022, 2.246145, -0.474900>, <-2.946329, 2.817033, -0.195077>, <-2.739142, 3.171135, -0.132044>, 
      <-1.558362, 2.015361, -0.313465>, <-1.867744, 2.276974, -0.481490>, <-2.551855, 2.742499, -0.312543>, <-2.522163, 3.171135, -0.400751>, 
      <-1.443138, 2.015361, -0.038834>, <-1.752520, 2.276974, -0.206858>, <-2.260854, 2.742499, -0.375925>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.304515, 1.081232, 0.946677>, <0.012086, 1.081232, 1.027701>, <0.240349, 1.081232, 0.878135>, 
      <-0.788855, 1.406922, 0.644678>, <-0.645869, 1.406922, 0.877120>, <-0.365873, 1.469014, 0.687036>, <-0.137609, 1.469014, 0.537470>, 
      <-1.503417, 1.621845, 0.754518>, <-1.248856, 1.621845, 0.656168>, <-0.886311, 1.633789, 0.457885>, <-0.991892, 1.633789, 0.206236>, 
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>, 
      <-0.304515, 1.081232, 0.946677>, <-0.003609, 0.794135, 1.007992>, <0.007566, 0.344951, 1.177824>, <0.231423, 0.000000, 1.265148>, 
      <0.012086, 1.081232, 1.027701>, <0.261255, 0.825587, 1.252283>, <0.214222, 0.345166, 1.356448>, <0.289967, 0.000000, 1.586665>, 
      <0.240349, 1.081232, 0.878135>, <0.489518, 0.825587, 1.102717>, <0.445423, 0.345166, 1.501431>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <-0.358708, 1.081232, 0.329096>, <-0.564168, 1.081232, 0.524578>, <-0.447501, 1.081232, 0.714236>, 
      <-0.717575, 1.431472, 0.062597>, <-0.903823, 1.431472, 0.184633>, <-0.905522, 1.406922, 0.455021>, <-0.788855, 1.406922, 0.644678>, 
      <-1.730134, 1.526020, 0.220968>, <-1.643987, 1.526020, 0.426296>, <-1.711122, 1.621845, 0.834766>, <-1.503417, 1.621845, 0.754518>, 
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>, 
      <-0.358708, 1.081232, 0.329096>, <0.082253, 0.797910, 0.445956>, <0.453044, 0.358581, 0.714490>, <0.769992, 0.000000, 0.958085>, 
      <-0.564168, 1.081232, 0.524578>, <-0.263262, 0.794135, 0.585893>, <0.282729, 0.344951, 0.765668>, <0.506586, 0.000000, 0.852992>, 
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.315237, 1.081232, -0.070085>, <0.026698, 1.081232, 0.076564>, <-0.172460, 1.081232, 0.207060>, 
      <-0.205809, 1.461603, -0.239568>, <-0.330563, 1.461603, -0.442372>, <-0.518416, 1.431472, -0.067899>, <-0.717575, 1.431472, 0.062597>, 
      <-1.444291, 1.550061, -0.376869>, <-1.666394, 1.550061, -0.291059>, <-1.822252, 1.526020, 0.001406>, <-1.730134, 1.526020, 0.220968>, 
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.905100, 0.807287, 0.400843>, <1.042798, 0.363391, 1.184679>, <1.281866, 0.000000, 1.601878>, 
      <0.315237, 1.081232, -0.070085>, <0.780346, 0.807287, 0.198039>, <1.175005, 0.363391, 0.986652>, <1.414073, 0.000000, 1.403851>, 
      <0.026698, 1.081232, 0.076564>, <0.467660, 0.797910, 0.193425>, <0.843411, 0.358581, 0.959283>, <1.160359, 0.000000, 1.202878>, 
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <-0.205809, 1.461603, -0.239568>, <-1.444291, 1.550061, -0.376869>, <-2.139844, 2.015361, -0.370651>, 
      <0.596036, 1.081232, 0.386390>, <-0.049764, 1.461603, 0.014103>, <-1.166480, 1.550061, -0.484202>, <-1.862034, 2.015361, -0.477984>, 
      <0.489460, 1.081232, 0.714909>, <0.111501, 1.469014, 0.374244>, <-1.107115, 1.633789, -0.068395>, <-1.558362, 2.015361, -0.313465>, 
      <0.240349, 1.081232, 0.878135>, <-0.137609, 1.469014, 0.537470>, <-0.991892, 1.633789, 0.206236>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.596036, 1.081232, 0.386390>, <0.489460, 1.081232, 0.714909>, <0.240349, 1.081232, 0.878135>, 
      <0.905100, 0.807287, 0.400843>, <1.061145, 0.807287, 0.654513>, <0.738629, 0.825587, 0.939491>, <0.489518, 0.825587, 1.102717>, 
      <1.042798, 0.363391, 1.184679>, <0.877432, 0.363391, 1.432374>, <0.697740, 0.345166, 1.659655>, <0.445423, 0.345166, 1.501431>, 
      <1.281866, 0.000000, 1.601878>, <1.116500, 0.000000, 1.849573>, <0.773485, 0.000000, 1.889873>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.089280, -0.198443, 1.114731>, <-0.347320, -0.198443, 1.025911>, <-0.643376, -0.198443, 1.164300>, <-0.724791, -0.198443, 1.424772>, 
      <-0.089280, -0.138910, 1.114731>, <-0.347320, -0.138910, 1.025911>, <-0.643376, -0.138910, 1.164300>, <-0.724791, -0.138910, 1.424772>, 
      <-0.068171, -0.055603, 1.112099>, <-0.326212, -0.055603, 1.023279>, <-0.650600, -0.055645, 1.144409>, <-0.732015, -0.055645, 1.404881>, 
      <-0.089280, 0.000000, 1.114731>, <-0.347320, 0.000000, 1.025911>, <-0.643376, 0.000000, 1.164300>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020189, -0.198443, 1.681203>, <0.086618, -0.198443, 1.468675>, <0.121264, -0.198443, 1.187203>, <-0.089280, -0.198443, 1.114731>, 
      <0.020189, -0.138910, 1.681203>, <0.086618, -0.138910, 1.468675>, <0.121264, -0.138910, 1.187203>, <-0.089280, -0.138910, 1.114731>, 
      <0.021745, -0.057184, 1.697688>, <0.088174, -0.057184, 1.485160>, <0.142373, -0.055603, 1.184571>, <-0.068171, -0.055603, 1.112099>, 
      <0.020189, 0.000000, 1.681203>, <0.086618, 0.000000, 1.468675>, <0.121264, 0.000000, 1.187203>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.180684, -0.198443, 2.204948>, <-0.050845, -0.198443, 1.908464>, <0.020189, -0.198443, 1.681203>, 
      <-0.405823, -0.138910, 2.127452>, <-0.180684, -0.138910, 2.204948>, <-0.050845, -0.138910, 1.908464>, <0.020189, -0.138910, 1.681203>, 
      <-0.431374, -0.052836, 2.137433>, <-0.206235, -0.052836, 2.214929>, <-0.049289, -0.057184, 1.924948>, <0.021745, -0.057184, 1.697688>, 
      <-0.405823, 0.000000, 2.127452>, <-0.180684, 0.000000, 2.204948>, <-0.050845, 0.000000, 1.908464>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.405823, -0.138910, 2.127452>, <-0.431374, -0.052836, 2.137433>, <-0.405823, 0.000000, 2.127452>, 
      <-0.687430, -0.198443, 2.030520>, <-0.687430, -0.138910, 2.030520>, <-0.712982, -0.052836, 2.040501>, <-0.687430, 0.000000, 2.030520>, 
      <-0.813641, -0.198443, 1.709033>, <-0.813641, -0.138910, 1.709033>, <-0.820866, -0.055645, 1.689142>, <-0.813641, 0.000000, 1.709033>, 
      <-0.724791, -0.198443, 1.424772>, <-0.724791, -0.138910, 1.424772>, <-0.732015, -0.055645, 1.404881>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>, 
      <-0.111256, 5.626361, -1.587831>, <-0.111256, 5.566828, -1.587831>, <-0.069643, 5.470267, -1.592191>, <-0.111256, 5.427918, -1.587831>, 
      <-0.407302, 5.626361, -1.449420>, <-0.407302, 5.566828, -1.449420>, <-0.368068, 5.468930, -1.431452>, <-0.407302, 5.427918, -1.449420>, 
      <-0.488697, 5.626361, -1.188943>, <-0.488697, 5.566828, -1.188943>, <-0.449464, 5.468930, -1.170975>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>, 
      <0.322715, 5.626361, -1.145098>, <0.322715, 5.566828, -1.145098>, <0.371190, 5.462459, -1.143983>, <0.322715, 5.427918, -1.145098>, 
      <0.357340, 5.626361, -1.426573>, <0.357340, 5.566828, -1.426573>, <0.398953, 5.470267, -1.430933>, <0.357340, 5.427918, -1.426573>, 
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.169677, 5.566828, -0.486286>, <-0.121324, 5.459192, -0.471185>, <-0.169677, 5.427918, -0.486286>, 
      <0.055468, 5.626361, -0.408806>, <0.055468, 5.566828, -0.408806>, <0.103821, 5.459192, -0.393705>, <0.055468, 5.427918, -0.408806>, 
      <0.185284, 5.626361, -0.705300>, <0.185284, 5.566828, -0.705300>, <0.233760, 5.462459, -0.704184>, <0.185284, 5.427918, -0.705300>, 
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.451292, 5.626361, -0.583198>, <-0.577527, 5.626361, -0.904675>, <-0.488697, 5.626361, -1.188943>, 
      <-0.169677, 5.566828, -0.486286>, <-0.451292, 5.566828, -0.583198>, <-0.577527, 5.566828, -0.904675>, <-0.488697, 5.566828, -1.188943>, 
      <-0.121324, 5.459192, -0.471185>, <-0.402939, 5.459192, -0.568097>, <-0.538293, 5.468930, -0.886707>, <-0.449464, 5.468930, -1.170975>, 
      <-0.169677, 5.427918, -0.486286>, <-0.451292, 5.427918, -0.583198>, <-0.577527, 5.427918, -0.904675>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>, 
      <-0.833708, 4.749489, -1.545964>, <-0.897374, 4.749489, -1.811333>, <-1.288948, 4.858728, -1.826220>, <-1.552390, 4.858728, -1.755001>, 
      <-0.195143, 5.079934, -1.463202>, <-0.453190, 5.079934, -1.552004>, <-0.741975, 5.078072, -1.602691>, <-0.823371, 5.078072, -1.342214>, 
      <0.146791, 5.427918, -1.499029>, <-0.111256, 5.427918, -1.587831>, <-0.407302, 5.427918, -1.449420>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>, 
      <-1.087471, 4.821855, -1.003961>, <-0.872520, 4.821855, -1.062071>, <-0.781761, 4.749489, -1.329441>, <-0.833708, 4.749489, -1.545964>, 
      <-0.245976, 5.070017, -0.944121>, <-0.179562, 5.070017, -1.156654>, <0.015406, 5.079934, -1.390746>, <-0.195143, 5.079934, -1.463202>, 
      <0.256302, 5.427918, -0.932566>, <0.322715, 5.427918, -1.145098>, <0.357340, 5.427918, -1.426573>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>, 
      <-1.721542, 4.895757, -0.881118>, <-1.665994, 4.895757, -0.649585>, <-1.317324, 4.821855, -0.941822>, <-1.087471, 4.821855, -1.003961>, 
      <-0.728416, 5.066532, -0.660782>, <-0.503271, 5.066532, -0.583303>, <-0.316993, 5.070017, -0.716856>, <-0.245976, 5.070017, -0.944121>, 
      <-0.169677, 5.427918, -0.486286>, <0.055468, 5.427918, -0.408806>, <0.185284, 5.427918, -0.705300>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-1.721542, 4.895757, -0.881118>, <-0.728416, 5.066532, -0.660782>, <-0.169677, 5.427918, -0.486286>, 
      <-2.181236, 4.370247, -1.382409>, <-1.791023, 4.895757, -1.170723>, <-1.010031, 5.066532, -0.757694>, <-0.451292, 5.427918, -0.583198>, 
      <-1.977838, 4.370247, -1.661536>, <-1.839893, 4.858728, -1.677277>, <-0.912200, 5.078072, -1.057946>, <-0.577527, 5.427918, -0.904675>, 
      <-1.690336, 4.370247, -1.739260>, <-1.552390, 4.858728, -1.755001>, <-0.823371, 5.078072, -1.342214>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>, 
      <-1.333099, 3.508092, -0.763045>, <-1.086548, 3.508092, -0.880034>, <-1.130598, 3.449089, -1.188097>, <-1.254581, 3.449089, -1.431206>, 
      <-1.326556, 4.012984, -1.203660>, <-1.390222, 4.012984, -1.469029>, <-1.546231, 3.947660, -1.796861>, <-1.809673, 3.947660, -1.725642>, 
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>, 
      <-1.899719, 3.499474, -0.954693>, <-1.798557, 3.499474, -0.756332>, <-1.534268, 3.508092, -0.667589>, <-1.333099, 3.508092, -0.763045>, 
      <-1.763151, 4.093690, -0.954238>, <-1.548200, 4.093690, -1.012348>, <-1.274609, 4.012984, -0.987137>, <-1.326556, 4.012984, -1.203660>, 
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>, 
      <-2.045189, 3.455457, -1.547973>, <-2.260304, 3.455457, -1.445900>, <-2.007895, 3.499474, -1.166804>, <-1.899719, 3.499474, -0.954693>, 
      <-2.327029, 4.080334, -1.209586>, <-2.271480, 4.080334, -0.978053>, <-1.993004, 4.093690, -0.892100>, <-1.763151, 4.093690, -0.954238>, 
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.045189, 3.455457, -1.547973>, <-2.327029, 4.080334, -1.209586>, <-2.111756, 4.370247, -1.092804>, 
      <-1.576368, 3.171135, -1.523036>, <-1.776121, 3.455457, -1.675647>, <-2.396509, 4.080334, -1.499191>, <-2.181236, 4.370247, -1.382409>, 
      <-1.261313, 3.171135, -1.381531>, <-1.389888, 3.449089, -1.696518>, <-2.097176, 3.947660, -1.647919>, <-1.977838, 4.370247, -1.661536>, 
      <-1.126006, 3.171135, -1.116219>, <-1.254581, 3.449089, -1.431206>, <-1.809673, 3.947660, -1.725642>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>, 
      <-1.446077, 2.404893, 0.514064>, <-1.286219, 2.404893, 0.735241>, <-0.928331, 2.423455, 0.509982>, <-0.711810, 2.423455, 0.343872>, 
      <-1.397225, 2.794648, -0.100544>, <-1.150674, 2.794648, -0.217534>, <-0.790649, 2.714186, -0.355280>, <-0.914633, 2.714186, -0.598389>, 
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>, 
      <-1.338930, 2.332180, -0.026128>, <-1.515597, 2.332180, 0.109406>, <-1.576511, 2.404893, 0.333598>, <-1.446077, 2.404893, 0.514064>, 
      <-1.751532, 2.713489, -0.532828>, <-1.650370, 2.713489, -0.334467>, <-1.598394, 2.794648, -0.005088>, <-1.397225, 2.794648, -0.100544>, 
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>, 
      <-0.792791, 2.355968, -0.363553>, <-0.932266, 2.355968, -0.556529>, <-1.150016, 2.332180, -0.171059>, <-1.338930, 2.332180, -0.026128>, 
      <-1.467895, 2.633755, -1.106922>, <-1.683010, 2.633755, -1.004849>, <-1.859707, 2.713489, -0.744940>, <-1.751532, 2.713489, -0.532828>, 
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.792791, 2.355968, -0.363553>, <-1.467895, 2.633755, -1.106922>, <-1.845436, 3.171135, -1.395362>, 
      <-0.282849, 2.015361, 0.412566>, <-0.618332, 2.355968, -0.122176>, <-1.198826, 2.633755, -1.234596>, <-1.576368, 3.171135, -1.523036>, 
      <-0.364726, 2.015361, 0.748095>, <-0.475513, 2.423455, 0.162591>, <-1.049940, 2.714186, -0.863701>, <-1.261313, 3.171135, -1.381531>, 
      <-0.601022, 2.015361, 0.929375>, <-0.711810, 2.423455, 0.343872>, <-0.914633, 2.714186, -0.598389>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.763513, 1.081232, 1.372705>, <-0.761351, 1.081232, 1.699502>, <-0.558650, 1.081232, 1.882221>, 
      <-0.764265, 1.396371, 1.128753>, <-0.952698, 1.396371, 1.326154>, <-0.737508, 1.469474, 1.604068>, <-0.534807, 1.469474, 1.786787>, 
      <-1.193420, 1.735064, 1.035033>, <-1.033561, 1.735064, 1.256210>, <-0.756108, 1.789057, 1.420169>, <-0.539586, 1.789057, 1.254059>, 
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>, 
      <-0.763513, 1.081232, 1.372705>, <-0.581696, 0.778367, 1.417443>, <-0.473571, 0.332564, 1.041652>, <-0.347320, 0.000000, 1.025911>, 
      <-0.761351, 1.081232, 1.699502>, <-0.782527, 0.736413, 1.784262>, <-0.600210, 0.332481, 1.283153>, <-0.643376, 0.000000, 1.164300>, 
      <-0.558650, 1.081232, 1.882221>, <-0.579826, 0.736413, 1.966981>, <-0.681624, 0.332481, 1.543625>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <-0.180022, 1.081232, 1.163226>, <-0.421330, 1.081232, 1.014239>, <-0.575080, 1.081232, 1.175304>, 
      <-0.225276, 1.473321, 1.041814>, <-0.390668, 1.473321, 0.892727>, <-0.610516, 1.396371, 0.967687>, <-0.764265, 1.396371, 1.128753>, 
      <-0.789139, 1.701959, 0.604355>, <-0.965806, 1.701959, 0.739890>, <-1.323854, 1.735064, 0.854567>, <-1.193420, 1.735064, 1.035033>, 
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>, 
      <-0.180022, 1.081232, 1.163226>, <-0.041346, 0.823106, 1.341305>, <0.077657, 0.329359, 1.373731>, <0.086618, 0.000000, 1.468675>, 
      <-0.421330, 1.081232, 1.014239>, <-0.239514, 0.778367, 1.058977>, <-0.004986, 0.332564, 1.202945>, <0.121264, 0.000000, 1.187203>, 
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.377436, 1.081232, 1.713488>, <0.162226, 1.081232, 1.471734>, <-0.014631, 1.081232, 1.312313>, 
      <0.201678, 1.525540, 1.454440>, <0.366085, 1.525540, 1.282209>, <-0.048420, 1.473321, 1.201235>, <-0.225276, 1.473321, 1.041814>, 
      <-0.167654, 1.721284, 0.632881>, <-0.307129, 1.721284, 0.439905>, <-0.600225, 1.701959, 0.459425>, <-0.789139, 1.701959, 0.604355>, 
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.220006, 0.808097, 2.150845>, <-0.242420, 0.337888, 2.063625>, <-0.405823, 0.000000, 2.127452>, 
      <0.377436, 1.081232, 1.713488>, <0.384413, 0.808097, 1.978614>, <-0.017281, 0.337888, 2.141120>, <-0.180684, 0.000000, 2.204948>, 
      <0.162226, 1.081232, 1.471734>, <0.300901, 0.823106, 1.649813>, <-0.059807, 0.329359, 1.813520>, <-0.050845, 0.000000, 1.908464>, 
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.201678, 1.525540, 1.454440>, <-0.167654, 1.721284, 0.632881>, <-0.457307, 2.015361, 0.171189>, 
      <0.007386, 1.081232, 2.101148>, <-0.003964, 1.525540, 1.669869>, <0.006805, 1.721284, 0.874259>, <-0.282849, 2.015361, 0.412566>, 
      <-0.337436, 1.081232, 2.081627>, <-0.313593, 1.469474, 1.986193>, <-0.303290, 1.789057, 1.072779>, <-0.364726, 2.015361, 0.748095>, 
      <-0.558650, 1.081232, 1.882221>, <-0.534807, 1.469474, 1.786787>, <-0.539586, 1.789057, 1.254059>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.007386, 1.081232, 2.101148>, <-0.337436, 1.081232, 2.081627>, <-0.558650, 1.081232, 1.882221>, 
      <0.220006, 0.808097, 2.150845>, <0.014363, 0.808097, 2.366274>, <-0.358612, 0.736413, 2.166387>, <-0.579826, 0.736413, 1.966981>, 
      <-0.242420, 0.337888, 2.063625>, <-0.524027, 0.337888, 1.966692>, <-0.770475, 0.332481, 1.827886>, <-0.681624, 0.332481, 1.543625>, 
      <-0.405823, 0.000000, 2.127452>, <-0.687430, 0.000000, 2.030520>, <-0.813641, 0.000000, 1.709033>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576448, -0.198443, 0.535137>, <0.576448, -0.198443, 0.262238>, <0.349236, -0.198443, 0.027343>, <0.076448, -0.198443, 0.035137>, 
      <0.576448, -0.138910, 0.535137>, <0.576448, -0.138910, 0.262238>, <0.349236, -0.138910, 0.027343>, <0.076448, -0.138910, 0.035137>, 
      <0.620136, -0.039925, 0.541587>, <0.620136, -0.039925, 0.268688>, <0.393748, -0.036435, 0.012000>, <0.120960, -0.036435, 0.019794>, 
      <0.576448, 0.000000, 0.535137>, <0.576448, 0.000000, 0.262238>, <0.349236, 0.000000, 0.027343>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076448, -0.198443, 0.823016>, <0.299025, -0.198443, 0.816657>, <0.576448, -0.198443, 0.757805>, <0.576448, -0.198443, 0.535137>, 
      <0.076448, -0.138910, 0.823016>, <0.299025, -0.138910, 0.816657>, <0.576448, -0.138910, 0.757805>, <0.576448, -0.138910, 0.535137>, 
      <0.109274, -0.049569, 0.819921>, <0.331851, -0.049569, 0.813561>, <0.620136, -0.039925, 0.764255>, <0.620136, -0.039925, 0.541587>, 
      <0.076448, 0.000000, 0.823016>, <0.299025, 0.000000, 0.816657>, <0.576448, 0.000000, 0.757805>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.198443, 0.803544>, <-0.161558, -0.198443, 0.829816>, <0.076448, -0.198443, 0.823016>, 
      <-0.484158, -0.138910, 0.565440>, <-0.484158, -0.138910, 0.803544>, <-0.161558, -0.138910, 0.829816>, <0.076448, -0.138910, 0.823016>, 
      <-0.457077, -0.045906, 0.538917>, <-0.457077, -0.045906, 0.777020>, <-0.128733, -0.049569, 0.826721>, <0.109274, -0.049569, 0.819921>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.803544>, <-0.161558, 0.000000, 0.829816>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.138910, 0.565440>, <-0.457077, -0.045906, 0.538917>, <-0.484158, 0.000000, 0.565440>, 
      <-0.484158, -0.198443, 0.267617>, <-0.484158, -0.138910, 0.267617>, <-0.457077, -0.045906, 0.241093>, <-0.484158, 0.000000, 0.267617>, 
      <-0.221254, -0.198443, 0.043643>, <-0.221254, -0.138910, 0.043643>, <-0.176742, -0.036435, 0.028300>, <-0.221254, 0.000000, 0.043643>, 
      <0.076448, -0.198443, 0.035137>, <0.076448, -0.138910, 0.035137>, <0.120960, -0.036435, 0.019794>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>, 
      <0.812457, 5.626361, -2.351572>, <0.812457, 5.566828, -2.351572>, <0.845476, 5.467288, -2.381637>, <0.812457, 5.427918, -2.351572>, 
      <0.585227, 5.626361, -2.586450>, <0.585227, 5.566828, -2.586450>, <0.600840, 5.476916, -2.616443>, <0.585227, 5.427918, -2.586450>, 
      <0.312440, 5.626361, -2.578635>, <0.312440, 5.566828, -2.578635>, <0.328052, 5.476916, -2.608629>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>, 
      <0.535075, 5.626361, -1.797132>, <0.535075, 5.566828, -1.797132>, <0.572463, 5.472019, -1.811323>, <0.535075, 5.427918, -1.797132>, 
      <0.812493, 5.626361, -1.856004>, <0.812493, 5.566828, -1.856004>, <0.845513, 5.467288, -1.886070>, <0.812493, 5.427918, -1.856004>, 
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248127, 5.566828, -2.048291>, <-0.222901, 5.481799, -2.050457>, <-0.248127, 5.427918, -2.048291>, 
      <-0.248110, 5.626361, -1.810188>, <-0.248110, 5.566828, -1.810188>, <-0.222884, 5.481799, -1.812353>, <-0.248110, 5.427918, -1.810188>, 
      <0.074492, 5.626361, -1.783939>, <0.074492, 5.566828, -1.783939>, <0.111880, 5.472019, -1.798129>, <0.074492, 5.427918, -1.783939>, 
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248149, 5.626361, -2.346115>, <0.014739, 5.626361, -2.570108>, <0.312440, 5.626361, -2.578635>, 
      <-0.248127, 5.566828, -2.048291>, <-0.248149, 5.566828, -2.346115>, <0.014739, 5.566828, -2.570108>, <0.312440, 5.566828, -2.578635>, 
      <-0.222901, 5.481799, -2.050457>, <-0.222923, 5.481799, -2.348280>, <0.030351, 5.476916, -2.600101>, <0.328052, 5.476916, -2.608629>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248149, 5.427918, -2.346115>, <0.014739, 5.427918, -2.570108>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>, 
      <0.053971, 4.666623, -1.448852>, <0.284170, 4.666623, -1.595421>, <0.174382, 4.607182, -1.900465>, <0.021298, 4.607182, -2.126384>, 
      <0.517220, 5.075879, -1.809835>, <0.517200, 5.075879, -2.082735>, <0.477637, 5.090263, -2.379763>, <0.204850, 5.090263, -2.371949>, 
      <0.812477, 5.427918, -2.078672>, <0.812457, 5.427918, -2.351572>, <0.585227, 5.427918, -2.586450>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>, 
      <-0.522392, 4.696657, -1.627402>, <-0.397485, 4.696657, -1.443067>, <-0.133856, 4.666623, -1.329261>, <0.053971, 4.666623, -1.448852>, 
      <0.019644, 5.082481, -1.679607>, <0.242221, 5.082481, -1.685983>, <0.517236, 5.075879, -1.587167>, <0.517220, 5.075879, -1.809835>, 
      <0.312498, 5.427918, -1.790756>, <0.535075, 5.427918, -1.797132>, <0.812493, 5.427918, -1.856004>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>, 
      <-0.779386, 4.656022, -2.214925>, <-0.980234, 4.656022, -2.087044>, <-0.655957, 4.696657, -1.824516>, <-0.522392, 4.696657, -1.627402>, 
      <-0.402100, 5.099049, -2.035075>, <-0.402082, 5.099049, -1.796971>, <-0.218362, 5.082481, -1.672789>, <0.019644, 5.082481, -1.679607>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248110, 5.427918, -1.810188>, <0.074492, 5.427918, -1.783939>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-0.779386, 4.656022, -2.214925>, <-0.402100, 5.099049, -2.035075>, <-0.248127, 5.427918, -2.048291>, 
      <-0.585001, 4.370247, -2.157766>, <-0.528163, 4.656022, -2.374880>, <-0.402121, 5.099049, -2.332898>, <-0.248149, 5.427918, -2.346115>, 
      <-0.254871, 4.370247, -2.056291>, <-0.145767, 4.607182, -2.372936>, <-0.092851, 5.090263, -2.363421>, <0.014739, 5.427918, -2.570108>, 
      <-0.087806, 4.370247, -1.809739>, <0.021298, 4.607182, -2.126384>, <0.204850, 5.090263, -2.371949>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>, 
      <-1.069952, 3.613722, 0.048729>, <-0.879086, 3.613722, 0.243780>, <-0.578520, 3.575232, 0.047883>, <-0.389001, 3.575232, -0.148476>, 
      <-0.622336, 3.987164, -0.693640>, <-0.392137, 3.987164, -0.840209>, <-0.144231, 3.915270, -0.975778>, <-0.297315, 3.915270, -1.201697>, 
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>, 
      <-1.142715, 3.545331, -0.498640>, <-1.297350, 3.545331, -0.338424>, <-1.225686, 3.613722, -0.110419>, <-1.069952, 3.613722, 0.048729>, 
      <-1.021373, 3.988560, -1.104980>, <-0.896467, 3.988560, -0.920645>, <-0.810163, 3.987164, -0.574049>, <-0.622336, 3.987164, -0.693640>, 
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>, 
      <-0.630548, 3.514007, -0.842063>, <-0.797077, 3.514007, -1.012244>, <-0.977360, 3.545331, -0.669961>, <-1.142715, 3.545331, -0.498640>, 
      <-0.932696, 3.885198, -1.629301>, <-1.133543, 3.885198, -1.501419>, <-1.154938, 3.988560, -1.302094>, <-1.021373, 3.988560, -1.104980>, 
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.630548, 3.514007, -0.842063>, <-0.932696, 3.885198, -1.629301>, <-0.836224, 4.370247, -1.997811>, 
      <-0.488683, 3.171135, -0.120865>, <-0.422251, 3.514007, -0.629199>, <-0.681473, 3.885198, -1.789256>, <-0.585001, 4.370247, -2.157766>, 
      <-0.519942, 3.171135, 0.223092>, <-0.182172, 3.575232, -0.362767>, <-0.464380, 3.915270, -1.448249>, <-0.254871, 4.370247, -2.056291>, 
      <-0.726770, 3.171135, 0.437383>, <-0.389001, 3.575232, -0.148476>, <-0.297315, 3.915270, -1.201697>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>, 
      <-2.299322, 2.433902, 0.927982>, <-2.456427, 2.433902, 1.151123>, <-2.067432, 2.609972, 1.414828>, <-1.839895, 2.609972, 1.565496>, 
      <-1.664665, 2.890382, 0.671393>, <-1.473799, 2.890382, 0.866444>, <-1.188084, 2.845969, 1.105167>, <-0.998565, 2.845969, 0.908809>, 
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>, 
      <-1.705847, 2.441113, 0.750588>, <-1.891503, 2.441113, 0.627653>, <-2.171134, 2.433902, 0.745913>, <-2.299322, 2.433902, 0.927982>, 
      <-1.398131, 2.837870, 0.206371>, <-1.552766, 2.837870, 0.366587>, <-1.820398, 2.890382, 0.512245>, <-1.664665, 2.890382, 0.671393>, 
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 2.015361, 1.493493>, <-1.155416, 2.015361, 1.298803>, <-1.404070, 2.015361, 1.091604>, <-1.602595, 2.015361, 0.960147>, 
      <-1.157934, 2.534113, 1.086776>, <-1.020861, 2.534113, 0.892087>, <-1.507322, 2.441113, 0.882046>, <-1.705847, 2.441113, 0.750588>, 
      <-0.769447, 2.797116, 0.220784>, <-0.935977, 2.797116, 0.050604>, <-1.232776, 2.837870, 0.035050>, <-1.398131, 2.837870, 0.206371>, 
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 2.015361, 1.493493>, <-1.157934, 2.534113, 1.086776>, <-0.769447, 2.797116, 0.220784>, <-0.696980, 3.171135, -0.333729>, 
      <-1.463942, 2.015361, 1.737014>, <-1.329388, 2.534113, 1.330297>, <-0.561151, 2.797116, 0.433648>, <-0.488683, 3.171135, -0.120865>, 
      <-1.807850, 2.015361, 1.768800>, <-1.591577, 2.609972, 1.729925>, <-0.791737, 2.845969, 0.694517>, <-0.519942, 3.171135, 0.223092>, 
      <-2.056168, 2.015361, 1.604371>, <-1.839895, 2.609972, 1.565496>, <-0.998565, 2.845969, 0.908809>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 1.081232, 0.328402>, <-1.071818, 1.081232, 0.214477>, <-1.380118, 1.081232, 0.322883>, <-1.486914, 1.081232, 0.574017>, 
      <-1.243411, 1.388319, 0.385170>, <-1.491394, 1.388319, 0.271244>, <-1.669056, 1.354284, 0.535491>, <-1.775853, 1.354284, 0.786626>, 
      <-2.030767, 1.513816, 0.883378>, <-2.187872, 1.513816, 1.106520>, <-2.437514, 1.592486, 1.481350>, <-2.209977, 1.592486, 1.632018>, 
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 1.081232, 0.328402>, <-0.395183, 0.767501, 0.270407>, <0.184320, 0.358354, 0.477244>, <0.576448, 0.000000, 0.535137>, 
      <-1.071818, 1.081232, 0.214477>, <-0.643165, 0.767501, 0.156481>, <0.184320, 0.358354, 0.204345>, <0.576448, 0.000000, 0.262238>, 
      <-1.380118, 1.081232, 0.322883>, <-1.000237, 0.722238, 0.043357>, <-0.093932, 0.362750, 0.180100>, <0.349236, 0.000000, 0.027343>, 
      <-1.486914, 1.081232, 0.574017>, <-1.107034, 0.722238, 0.294492>, <-0.366719, 0.362750, 0.187894>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 1.081232, 0.902929>, <-0.683835, 1.081232, 0.698019>, <-0.621499, 1.081232, 0.421358>, <-0.823836, 1.081232, 0.328402>, 
      <-1.011060, 1.369409, 0.922537>, <-0.923921, 1.369409, 0.717628>, <-1.041074, 1.388319, 0.478126>, <-1.243411, 1.388319, 0.385170>, 
      <-1.522739, 1.686080, 1.122222>, <-1.708394, 1.686080, 0.999287>, <-1.902580, 1.513816, 0.701310>, <-2.030767, 1.513816, 0.883378>, 
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 1.081232, 0.902929>, <-0.507092, 0.764493, 0.881377>, <-0.151174, 0.343728, 0.844481>, <0.076448, 0.000000, 0.823016>, 
      <-0.683835, 1.081232, 0.698019>, <-0.419952, 0.764493, 0.676467>, <0.071403, 0.343728, 0.838122>, <0.299025, 0.000000, 0.816657>, 
      <-0.621499, 1.081232, 0.421358>, <-0.192846, 0.767501, 0.363363>, <0.184320, 0.358354, 0.699912>, <0.576448, 0.000000, 0.757805>, 
      <-0.823836, 1.081232, 0.328402>, <-0.395183, 0.767501, 0.270407>, <0.184320, 0.358354, 0.477244>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.022701, 1.081232, 1.404218>, <-0.864153, 1.081232, 1.122042>, <-0.770974, 1.081232, 0.902929>, 
      <-1.337082, 1.325614, 1.417354>, <-1.120719, 1.325614, 1.516753>, <-1.104240, 1.369409, 1.141650>, <-1.011060, 1.369409, 0.922537>, 
      <-1.349758, 1.794570, 1.666600>, <-1.212685, 1.794570, 1.471910>, <-1.324214, 1.686080, 1.253680>, <-1.522739, 1.686080, 1.122222>, 
      <-1.292489, 2.015361, 1.493493>, <-1.155416, 2.015361, 1.298803>, <-1.404070, 2.015361, 1.091604>, <-1.602595, 2.015361, 0.960147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.083811, 0.694152, 1.126572>, <-0.690470, 0.349729, 0.767509>, <-0.484158, 0.000000, 0.565440>, 
      <-1.022701, 1.081232, 1.404218>, <-0.867448, 0.694152, 1.225971>, <-0.690470, 0.349729, 1.005612>, <-0.484158, 0.000000, 0.803544>, 
      <-0.864153, 1.081232, 1.122042>, <-0.600271, 0.764493, 1.100490>, <-0.389180, 0.343728, 0.851281>, <-0.161558, 0.000000, 0.829816>, 
      <-0.770974, 1.081232, 0.902929>, <-0.507092, 0.764493, 0.881377>, <-0.151174, 0.343728, 0.844481>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.337082, 1.325614, 1.417354>, <-1.349758, 1.794570, 1.666600>, <-1.292489, 2.015361, 1.493493>, 
      <-1.509694, 1.081232, 1.180488>, <-1.607712, 1.325614, 1.293024>, <-1.521212, 1.794570, 1.910121>, <-1.463942, 2.015361, 1.737014>, 
      <-1.603465, 1.081232, 0.848088>, <-1.892403, 1.354284, 1.060696>, <-1.961659, 1.592486, 1.796447>, <-1.807850, 2.015361, 1.768800>, 
      <-1.486914, 1.081232, 0.574017>, <-1.775853, 1.354284, 0.786626>, <-2.209977, 1.592486, 1.632018>, <-2.056168, 2.015361, 1.604371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.509694, 1.081232, 1.180488>, <-1.603465, 1.081232, 0.848088>, <-1.486914, 1.081232, 0.574017>, 
      <-1.083811, 0.694152, 1.126572>, <-1.354441, 0.694152, 1.002242>, <-1.223585, 0.722238, 0.568562>, <-1.107034, 0.722238, 0.294492>, 
      <-0.690470, 0.349729, 0.767509>, <-0.690470, 0.349729, 0.469685>, <-0.664421, 0.362750, 0.196400>, <-0.366719, 0.362750, 0.187894>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.267617>, <-0.221254, 0.000000, 0.043643>, <0.076448, 0.000000, 0.035137>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <0.1416, 0.361831, 0.0036>
}
#declare segMshiftMA3 = union {
  object { // Blatt57->Blatt8
    Blatt8
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <-0.903105, 1.458534, -0.800323>
  }
  object { // Blatt58->Blatt8
    Blatt8
    rotate <-20.233294, -23.362207, -124.43499>
    translate  <-3.56144, 0.669132, 2.694692>
  }
  object { Blatt59 }
  object { sPatchObj20 }
  translate  <-0.363682, 0.695127, 11.654475>
}
#declare BezPtch021 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt62 = union {
  cone { // Cone021
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch021 }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 1.280195, 3.05012>
}
#declare sPatchObj21 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382950, -0.375758, -1.399903>, <0.231423, -0.375758, -1.172937>, <0.289967, -0.375758, -0.851419>, <0.521168, -0.375758, -0.706436>, 
      <0.382950, -0.316225, -1.399903>, <0.231423, -0.316225, -1.172937>, <0.289967, -0.316225, -0.851419>, <0.521168, -0.316225, -0.706436>, 
      <0.414307, -0.227308, -1.407757>, <0.262780, -0.227308, -1.180790>, <0.301984, -0.233975, -0.837658>, <0.533186, -0.233975, -0.692675>, 
      <0.382950, -0.177315, -1.399903>, <0.231423, -0.177315, -1.172937>, <0.289967, -0.177315, -0.851419>, <0.521168, -0.177315, -0.706436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.958637, -0.375758, -1.361703>, <0.769992, -0.375758, -1.479999>, <0.506586, -0.375758, -1.585093>, <0.382950, -0.375758, -1.399903>, 
      <0.958637, -0.316225, -1.361703>, <0.769992, -0.316225, -1.479999>, <0.506586, -0.316225, -1.585093>, <0.382950, -0.316225, -1.399903>, 
      <0.996600, -0.221753, -1.350380>, <0.807955, -0.221753, -1.468676>, <0.537943, -0.227308, -1.592946>, <0.414307, -0.227308, -1.407757>, 
      <0.958637, -0.177315, -1.361703>, <0.769992, -0.177315, -1.479999>, <0.506586, -0.177315, -1.585093>, <0.382950, -0.177315, -1.399903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.375758, -0.836206>, <1.414073, -0.375758, -1.034233>, <1.160359, -0.375758, -1.235206>, <0.958637, -0.375758, -1.361703>, 
      <1.281866, -0.316225, -0.836206>, <1.414073, -0.316225, -1.034233>, <1.160359, -0.316225, -1.235206>, <0.958637, -0.316225, -1.361703>, 
      <1.309290, -0.220444, -0.805677>, <1.441497, -0.220444, -1.003704>, <1.198323, -0.221753, -1.223883>, <0.996600, -0.221753, -1.350380>, 
      <1.281866, -0.177315, -0.836206>, <1.414073, -0.177315, -1.034233>, <1.160359, -0.177315, -1.235206>, <0.958637, -0.177315, -1.361703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.375758, -0.836206>, <1.281866, -0.316225, -0.836206>, <1.309290, -0.220444, -0.805677>, <1.281866, -0.177315, -0.836206>, 
      <1.116500, -0.375758, -0.588511>, <1.116500, -0.316225, -0.588511>, <1.143924, -0.220444, -0.557982>, <1.116500, -0.177315, -0.588511>, 
      <0.773485, -0.375758, -0.548212>, <0.773485, -0.316225, -0.548212>, <0.785503, -0.233975, -0.534450>, <0.773485, -0.177315, -0.548212>, 
      <0.521168, -0.375758, -0.706436>, <0.521168, -0.316225, -0.706436>, <0.533186, -0.233975, -0.692675>, <0.521168, -0.177315, -0.706436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.619016, 6.025320, 1.926361>, <0.619016, 5.965787, 1.926361>, <0.658218, 5.866102, 1.948011>, <0.619016, 5.826877, 1.926361>, 
      <0.467505, 6.025320, 2.153338>, <0.467505, 5.965787, 2.153338>, <0.506707, 5.866102, 2.174989>, <0.467505, 5.826877, 2.153338>, 
      <0.526073, 6.025320, 2.474851>, <0.526073, 5.965787, 2.474851>, <0.571838, 5.858082, 2.496667>, <0.526073, 5.826877, 2.474851>, 
      <0.757285, 6.025320, 2.619818>, <0.757285, 5.965787, 2.619818>, <0.803050, 5.858082, 2.641634>, <0.757285, 5.826877, 2.619818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.194706, 6.025320, 1.964519>, <1.194706, 5.965787, 1.964519>, <1.240240, 5.864370, 1.972582>, <1.194706, 5.826877, 1.964519>, 
      <1.006052, 6.025320, 1.846236>, <1.006052, 5.965787, 1.846236>, <1.051586, 5.864370, 1.854299>, <1.006052, 5.826877, 1.846236>, 
      <0.742638, 6.025320, 1.741162>, <0.742638, 5.965787, 1.741162>, <0.781841, 5.866102, 1.762812>, <0.742638, 5.826877, 1.741162>, 
      <0.619016, 6.025320, 1.926361>, <0.619016, 5.965787, 1.926361>, <0.658218, 5.866102, 1.948011>, <0.619016, 5.826877, 1.926361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 6.025320, 2.489993>, <1.517973, 5.965787, 2.489993>, <1.568556, 5.857696, 2.495968>, <1.517973, 5.826877, 2.489993>, 
      <1.650165, 6.025320, 2.291956>, <1.650165, 5.965787, 2.291956>, <1.700748, 5.857696, 2.297932>, <1.650165, 5.826877, 2.291956>, 
      <1.396437, 6.025320, 2.091001>, <1.396437, 5.965787, 2.091001>, <1.441972, 5.864370, 2.099065>, <1.396437, 5.826877, 2.091001>, 
      <1.194706, 6.025320, 1.964519>, <1.194706, 5.965787, 1.964519>, <1.240240, 5.864370, 1.972582>, <1.194706, 5.826877, 1.964519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 6.025320, 2.489993>, <1.352625, 6.025320, 2.737700>, <1.009613, 6.025320, 2.778024>, <0.757285, 6.025320, 2.619818>, 
      <1.517973, 5.965787, 2.489993>, <1.352625, 5.965787, 2.737700>, <1.009613, 5.965787, 2.778024>, <0.757285, 5.965787, 2.619818>, 
      <1.568556, 5.857696, 2.495968>, <1.403208, 5.857696, 2.743675>, <1.055379, 5.858082, 2.799839>, <0.803050, 5.858082, 2.641634>, 
      <1.517973, 5.826877, 2.489993>, <1.352625, 5.826877, 2.737700>, <1.009613, 5.826877, 2.778024>, <0.757285, 5.826877, 2.619818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.769287, 4.636220, 1.159634>, <-1.042122, 4.636220, 1.153715>, <-1.281890, 4.636220, 1.375779>, <-1.280013, 4.636220, 1.648672>, 
      <-0.389811, 5.058622, 1.337220>, <-0.662646, 5.058622, 1.331302>, <-0.769451, 5.068804, 1.744969>, <-0.767575, 5.068804, 2.017862>, 
      <0.227243, 5.434879, 1.709994>, <0.075732, 5.434879, 1.936971>, <-0.062420, 5.425622, 2.194327>, <0.168792, 5.425622, 2.339293>, 
      <0.619016, 5.826877, 1.926361>, <0.467505, 5.826877, 2.153338>, <0.526073, 5.826877, 2.474851>, <0.757285, 5.826877, 2.619818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.492319, 4.636220, 1.665758>, <-0.493850, 4.636220, 1.443096>, <-0.546672, 4.636220, 1.164462>, <-0.769287, 4.636220, 1.159634>, 
      <-0.003580, 5.012096, 1.773547>, <-0.005111, 5.012096, 1.550885>, <-0.167196, 5.058622, 1.342049>, <-0.389811, 5.058622, 1.337220>, 
      <0.715967, 5.432682, 1.879737>, <0.527313, 5.432682, 1.761454>, <0.350866, 5.434879, 1.524795>, <0.227243, 5.434879, 1.709994>, 
      <1.194706, 5.826877, 1.964519>, <1.006052, 5.826877, 1.846236>, <0.742638, 5.826877, 1.741162>, <0.619016, 5.826877, 1.926361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.636220, 2.220647>, <-0.523943, 4.636220, 2.225811>, <-0.490682, 4.636220, 1.903856>, <-0.492319, 4.636220, 1.665758>, 
      <-0.122330, 5.020246, 2.433525>, <0.115718, 5.020246, 2.438689>, <-0.001943, 5.012096, 2.011645>, <-0.003580, 5.012096, 1.773547>, 
      <0.858747, 5.425234, 2.412114>, <0.990939, 5.425234, 2.214078>, <0.917698, 5.432682, 2.006220>, <0.715967, 5.432682, 1.879737>, 
      <1.517973, 5.826877, 2.489993>, <1.650165, 5.826877, 2.291956>, <1.396437, 5.826877, 2.091001>, <1.194706, 5.826877, 1.964519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.636220, 2.220647>, <-0.122330, 5.020246, 2.433525>, <0.858747, 5.425234, 2.412114>, <1.517973, 5.826877, 2.489993>, 
      <-1.059745, 4.636220, 2.214189>, <-0.420083, 5.020246, 2.427067>, <0.693399, 5.425234, 2.659822>, <1.352625, 5.826877, 2.737700>, 
      <-1.277965, 4.636220, 1.946489>, <-0.765527, 5.068804, 2.315679>, <0.421120, 5.425622, 2.497499>, <1.009613, 5.826877, 2.778024>, 
      <-1.280013, 4.636220, 1.648672>, <-0.767575, 5.068804, 2.017862>, <0.168792, 5.425622, 2.339293>, <0.757285, 5.826877, 2.619818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647364, 3.304121, 0.865746>, <-1.697803, 3.304121, 0.597548>, <-1.964514, 3.304121, 0.408694>, <-2.231162, 3.304121, 0.466772>, 
      <-1.500296, 3.712392, 1.086097>, <-1.550735, 3.712392, 0.817899>, <-1.937875, 3.739360, 0.829055>, <-2.204523, 3.739360, 0.887132>, 
      <-1.079714, 4.290676, 1.014361>, <-1.352549, 4.290676, 1.008443>, <-1.687329, 4.293960, 1.083678>, <-1.685452, 4.293960, 1.356571>, 
      <-0.769287, 4.636220, 1.159634>, <-1.042122, 4.636220, 1.153715>, <-1.281890, 4.636220, 1.375779>, <-1.280013, 4.636220, 1.648672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.085543, 3.304121, 1.241078>, <-1.867976, 3.304121, 1.193690>, <-1.606210, 3.304121, 1.084578>, <-1.647364, 3.304121, 0.865746>, 
      <-1.811197, 3.737864, 1.616564>, <-1.593630, 3.737864, 1.569176>, <-1.459142, 3.712392, 1.304928>, <-1.500296, 3.712392, 1.086097>, 
      <-0.988868, 4.254336, 1.556247>, <-0.990399, 4.254336, 1.333585>, <-0.857098, 4.290676, 1.019190>, <-1.079714, 4.290676, 1.014361>, 
      <-0.492319, 4.636220, 1.665758>, <-0.493850, 4.636220, 1.443096>, <-0.546672, 4.636220, 1.164462>, <-0.769287, 4.636220, 1.159634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.304121, 1.091554>, <-2.640090, 3.304121, 1.325555>, <-2.318192, 3.304121, 1.291751>, <-2.085543, 3.304121, 1.241078>, 
      <-2.450394, 3.756174, 1.681449>, <-2.406387, 3.756174, 1.915450>, <-2.043846, 3.737864, 1.667237>, <-1.811197, 3.737864, 1.616564>, 
      <-1.404295, 4.250606, 2.006890>, <-1.166248, 4.250606, 2.012053>, <-0.987231, 4.254336, 1.794345>, <-0.988868, 4.254336, 1.556247>, 
      <-0.761991, 4.636220, 2.220647>, <-0.523943, 4.636220, 2.225811>, <-0.490682, 4.636220, 1.903856>, <-0.492319, 4.636220, 1.665758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.304121, 1.091554>, <-2.450394, 3.756174, 1.681449>, <-1.404295, 4.250606, 2.006890>, <-0.761991, 4.636220, 2.220647>, 
      <-2.739142, 3.304121, 0.798861>, <-2.505439, 3.756174, 1.388756>, <-1.702049, 4.250606, 2.000432>, <-1.059745, 4.636220, 2.214189>, 
      <-2.522163, 3.304121, 0.530154>, <-2.495524, 3.739360, 0.950515>, <-1.683404, 4.293960, 1.654388>, <-1.277965, 4.636220, 1.946489>, 
      <-2.231162, 3.304121, 0.466772>, <-2.204523, 3.739360, 0.887132>, <-1.685452, 4.293960, 1.356571>, <-1.280013, 4.636220, 1.648672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.729344, 1.971033, -0.278813>, <-1.474783, 1.971033, -0.377163>, <-1.337557, 1.971033, -0.673761>, <-1.443138, 1.971033, -0.925410>, 
      <-1.918332, 2.342102, 0.045283>, <-1.663771, 2.342102, -0.053067>, <-1.751792, 2.365886, -0.423231>, <-1.857373, 2.365886, -0.674880>, 
      <-1.806818, 2.861465, 0.626837>, <-1.857257, 2.861465, 0.358639>, <-1.991991, 2.855205, -0.024877>, <-2.258639, 2.855205, 0.033201>, 
      <-1.647364, 3.304121, 0.865746>, <-1.697803, 3.304121, 0.597548>, <-1.964514, 3.304121, 0.408694>, <-2.231162, 3.304121, 0.466772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.178073, 1.971033, -0.641465>, <-2.091926, 1.971033, -0.436137>, <-1.937049, 1.971033, -0.198565>, <-1.729344, 1.971033, -0.278813>, 
      <-2.491640, 2.357176, -0.159554>, <-2.405493, 2.357176, 0.045774>, <-2.126037, 2.342102, 0.125531>, <-1.918332, 2.342102, 0.045283>, 
      <-2.384336, 2.831728, 0.832132>, <-2.166769, 2.831728, 0.784744>, <-1.765664, 2.861465, 0.845669>, <-1.806818, 2.861465, 0.626837>, 
      <-2.085543, 3.304121, 1.241078>, <-1.867976, 3.304121, 1.193690>, <-1.606210, 3.304121, 1.084578>, <-1.647364, 3.304121, 0.865746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 1.971033, -1.257227>, <-2.361947, 1.971033, -1.171416>, <-2.270192, 1.971033, -0.861027>, <-2.178073, 1.971033, -0.641465>, 
      <-2.672280, 2.372542, -0.768952>, <-2.894383, 2.372542, -0.683142>, <-2.583759, 2.357176, -0.379116>, <-2.491640, 2.357176, -0.159554>, 
      <-2.932030, 2.824543, 0.465739>, <-2.888023, 2.824543, 0.699741>, <-2.616985, 2.831728, 0.882805>, <-2.384336, 2.831728, 0.832132>, 
      <-2.684097, 3.304121, 1.091554>, <-2.640090, 3.304121, 1.325555>, <-2.318192, 3.304121, 1.291751>, <-2.085543, 3.304121, 1.241078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 1.971033, -1.257227>, <-2.672280, 2.372542, -0.768952>, <-2.932030, 2.824543, 0.465739>, <-2.684097, 3.304121, 1.091554>, 
      <-1.862034, 1.971033, -1.364560>, <-2.394470, 2.372542, -0.876285>, <-2.987075, 2.824543, 0.173046>, <-2.739142, 3.304121, 0.798861>, 
      <-1.558362, 1.971033, -1.200041>, <-1.972596, 2.365886, -0.949511>, <-2.549640, 2.855205, 0.096583>, <-2.522163, 3.304121, 0.530154>, 
      <-1.443138, 1.971033, -0.925410>, <-1.857373, 2.365886, -0.674880>, <-2.258639, 2.855205, 0.033201>, <-2.231162, 3.304121, 0.466772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 0.948245, -1.191903>, <-0.304515, 0.948245, -0.959461>, <0.012086, 0.948245, -0.878438>, <0.240349, 0.948245, -1.028004>, 
      <-0.817494, 1.324554, -0.995531>, <-0.674508, 1.324554, -0.763089>, <-0.386095, 1.383733, -0.922826>, <-0.157831, 1.383733, -1.072392>, 
      <-1.527676, 1.575066, -0.624654>, <-1.273115, 1.575066, -0.723005>, <-0.945179, 1.597013, -0.911072>, <-1.050760, 1.597013, -1.162721>, 
      <-1.729344, 1.971033, -0.278813>, <-1.474783, 1.971033, -0.377163>, <-1.337557, 1.971033, -0.673761>, <-1.443138, 1.971033, -0.925410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 0.948245, -1.191903>, <-0.168738, 0.664725, -1.339855>, <0.159497, 0.178941, -1.343935>, <0.382950, -0.177315, -1.399903>, 
      <-0.304515, 0.948245, -0.959461>, <-0.025752, 0.664725, -1.107413>, <0.007970, 0.178941, -1.116969>, <0.231423, -0.177315, -1.172937>, 
      <0.012086, 0.948245, -0.878438>, <0.255094, 0.682469, -0.851348>, <0.217065, 0.166400, -0.934899>, <0.289967, -0.177315, -0.851419>, 
      <0.240349, 0.948245, -1.028004>, <0.483358, 0.682469, -1.000914>, <0.448267, 0.166400, -0.789916>, <0.521168, -0.177315, -0.706436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 0.948245, -1.699079>, <-0.358708, 0.948245, -1.577043>, <-0.564168, 0.948245, -1.381560>, <-0.447501, 0.948245, -1.191903>, 
      <-0.777362, 1.362545, -1.560184>, <-0.963609, 1.362545, -1.438148>, <-0.934161, 1.324554, -1.185188>, <-0.817494, 1.324554, -0.995531>, 
      <-1.840222, 1.554985, -1.160697>, <-1.754076, 1.554985, -0.955369>, <-1.735381, 1.575066, -0.544407>, <-1.527676, 1.575066, -0.624654>, 
      <-2.178073, 1.971033, -0.641465>, <-2.091926, 1.971033, -0.436137>, <-1.937049, 1.971033, -0.198565>, <-1.729344, 1.971033, -0.278813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 0.948245, -1.699079>, <0.224172, 0.676590, -1.790152>, <0.646621, 0.187915, -1.454769>, <0.958637, -0.177315, -1.361703>, 
      <-0.358708, 0.948245, -1.577043>, <0.037924, 0.676590, -1.668116>, <0.457976, 0.187915, -1.573066>, <0.769992, -0.177315, -1.479999>, 
      <-0.564168, 0.948245, -1.381560>, <-0.285405, 0.664725, -1.529512>, <0.283133, 0.178941, -1.529125>, <0.506586, -0.177315, -1.585093>, 
      <-0.447501, 0.948245, -1.191903>, <-0.168738, 0.664725, -1.339855>, <0.159497, 0.178941, -1.343935>, <0.382950, -0.177315, -1.399903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 0.948245, -1.773419>, <0.315237, 0.948245, -1.976223>, <0.026698, 0.948245, -1.829575>, <-0.172460, 0.948245, -1.699079>, 
      <-0.273338, 1.396115, -1.861190>, <-0.398092, 1.396115, -2.063994>, <-0.578203, 1.362545, -1.690680>, <-0.777362, 1.362545, -1.560184>, 
      <-1.594312, 1.559646, -1.757512>, <-1.816415, 1.559646, -1.671701>, <-1.932341, 1.554985, -1.380259>, <-1.840222, 1.554985, -1.160697>, 
      <-2.139844, 1.971033, -1.257227>, <-2.361947, 1.971033, -1.171416>, <-2.270192, 1.971033, -0.861027>, <-2.178073, 1.971033, -0.641465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 0.948245, -1.773419>, <0.866905, 0.680204, -1.720890>, <1.048404, 0.189847, -1.096106>, <1.281866, -0.177315, -0.836206>, 
      <0.315237, 0.948245, -1.976223>, <0.742151, 0.680204, -1.923694>, <1.180611, 0.189847, -1.294133>, <1.414073, -0.177315, -1.034233>, 
      <0.026698, 0.948245, -1.829575>, <0.423330, 0.676590, -1.920648>, <0.848343, 0.187915, -1.328272>, <1.160359, -0.177315, -1.235206>, 
      <-0.172460, 0.948245, -1.699079>, <0.224172, 0.676590, -1.790152>, <0.646621, 0.187915, -1.454769>, <0.958637, -0.177315, -1.361703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 0.948245, -1.773419>, <-0.273338, 1.396115, -1.861190>, <-1.594312, 1.559646, -1.757512>, <-2.139844, 1.971033, -1.257227>, 
      <0.596036, 0.948245, -1.519748>, <-0.117293, 1.396115, -1.607519>, <-1.316502, 1.559646, -1.864845>, <-1.862034, 1.971033, -1.364560>, 
      <0.489460, 0.948245, -1.191230>, <0.091279, 1.383733, -1.235618>, <-1.165984, 1.597013, -1.437352>, <-1.558362, 1.971033, -1.200041>, 
      <0.240349, 0.948245, -1.028004>, <-0.157831, 1.383733, -1.072392>, <-1.050760, 1.597013, -1.162721>, <-1.443138, 1.971033, -0.925410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 0.948245, -1.773419>, <0.596036, 0.948245, -1.519748>, <0.489460, 0.948245, -1.191230>, <0.240349, 0.948245, -1.028004>, 
      <0.866905, 0.680204, -1.720890>, <1.022950, 0.680204, -1.467219>, <0.732468, 0.682469, -1.164140>, <0.483358, 0.682469, -1.000914>, 
      <1.048404, 0.189847, -1.096106>, <0.883038, 0.189847, -0.848411>, <0.700584, 0.166400, -0.631692>, <0.448267, 0.166400, -0.789916>, 
      <1.281866, -0.177315, -0.836206>, <1.116500, -0.177315, -0.588511>, <0.773485, -0.177315, -0.548212>, <0.521168, -0.177315, -0.706436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.089280, -0.375758, -1.323353>, <-0.347320, -0.375758, -1.412174>, <-0.643376, -0.375758, -1.273784>, <-0.724791, -0.375758, -1.013312>, 
      <-0.089280, -0.316225, -1.323353>, <-0.347320, -0.316225, -1.412174>, <-0.643376, -0.316225, -1.273784>, <-0.724791, -0.316225, -1.013312>, 
      <-0.070374, -0.228842, -1.346412>, <-0.328414, -0.228842, -1.435233>, <-0.649330, -0.224765, -1.309242>, <-0.730745, -0.224765, -1.048770>, 
      <-0.089280, -0.177315, -1.323353>, <-0.347320, -0.177315, -1.412174>, <-0.643376, -0.177315, -1.273784>, <-0.724791, -0.177315, -1.013312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020189, -0.375758, -0.756881>, <0.086618, -0.375758, -0.969409>, <0.121264, -0.375758, -1.250881>, <-0.089280, -0.375758, -1.323353>, 
      <0.020189, -0.316225, -0.756881>, <0.086618, -0.316225, -0.969409>, <0.121264, -0.316225, -1.250881>, <-0.089280, -0.316225, -1.323353>, 
      <0.021743, -0.236382, -0.764155>, <0.088172, -0.236382, -0.976683>, <0.140170, -0.228842, -1.273940>, <-0.070374, -0.228842, -1.346412>, 
      <0.020189, -0.177315, -0.756881>, <0.086618, -0.177315, -0.969409>, <0.121264, -0.177315, -1.250881>, <-0.089280, -0.177315, -1.323353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.375758, -0.310632>, <-0.180684, -0.375758, -0.233136>, <-0.050845, -0.375758, -0.529620>, <0.020189, -0.375758, -0.756881>, 
      <-0.405823, -0.316225, -0.310632>, <-0.180684, -0.316225, -0.233136>, <-0.050845, -0.316225, -0.529620>, <0.020189, -0.316225, -0.756881>, 
      <-0.430549, -0.230215, -0.322227>, <-0.205409, -0.230215, -0.244732>, <-0.049292, -0.236382, -0.536895>, <0.021743, -0.236382, -0.764155>, 
      <-0.405823, -0.177315, -0.310632>, <-0.180684, -0.177315, -0.233136>, <-0.050845, -0.177315, -0.529620>, <0.020189, -0.177315, -0.756881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.375758, -0.310632>, <-0.405823, -0.316225, -0.310632>, <-0.430549, -0.230215, -0.322227>, <-0.405823, -0.177315, -0.310632>, 
      <-0.687430, -0.375758, -0.407565>, <-0.687430, -0.316225, -0.407565>, <-0.712156, -0.230215, -0.419160>, <-0.687430, -0.177315, -0.407565>, 
      <-0.813641, -0.375758, -0.729051>, <-0.813641, -0.316225, -0.729051>, <-0.819596, -0.224765, -0.764509>, <-0.813641, -0.177315, -0.729051>, 
      <-0.724791, -0.375758, -1.013312>, <-0.724791, -0.316225, -1.013312>, <-0.730745, -0.224765, -1.048770>, <-0.724791, -0.177315, -1.013312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146791, 6.025320, 2.002946>, <0.146791, 5.965787, 2.002946>, <0.180005, 5.864257, 2.035252>, <0.146791, 5.826877, 2.002946>, 
      <-0.111256, 6.025320, 1.914144>, <-0.111256, 5.965787, 1.914144>, <-0.078042, 5.864257, 1.946450>, <-0.111256, 5.826877, 1.914144>, 
      <-0.407302, 6.025320, 2.052555>, <-0.407302, 5.965787, 2.052555>, <-0.380085, 5.858340, 2.095140>, <-0.407302, 5.826877, 2.052555>, 
      <-0.488697, 6.025320, 2.313033>, <-0.488697, 5.965787, 2.313033>, <-0.461481, 5.858340, 2.355618>, <-0.488697, 5.826877, 2.313033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256302, 6.025320, 2.569409>, <0.256302, 5.965787, 2.569409>, <0.296210, 5.858324, 2.600434>, <0.256302, 5.826877, 2.569409>, 
      <0.322715, 6.025320, 2.356877>, <0.322715, 5.965787, 2.356877>, <0.362624, 5.858324, 2.387901>, <0.322715, 5.826877, 2.356877>, 
      <0.357340, 6.025320, 2.075402>, <0.357340, 5.965787, 2.075402>, <0.390554, 5.864257, 2.107708>, <0.357340, 5.826877, 2.075402>, 
      <0.146791, 6.025320, 2.002946>, <0.146791, 5.965787, 2.002946>, <0.180005, 5.864257, 2.035252>, <0.146791, 5.826877, 2.002946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 6.025320, 3.015689>, <-0.169677, 5.965787, 3.015689>, <-0.132069, 5.853778, 3.053188>, <-0.169677, 5.826877, 3.015689>, 
      <0.055468, 6.025320, 3.093168>, <0.055468, 5.965787, 3.093168>, <0.093076, 5.853778, 3.130667>, <0.055468, 5.826877, 3.093168>, 
      <0.185284, 6.025320, 2.796675>, <0.185284, 5.965787, 2.796675>, <0.225193, 5.858324, 2.827700>, <0.185284, 5.826877, 2.796675>, 
      <0.256302, 6.025320, 2.569409>, <0.256302, 5.965787, 2.569409>, <0.296210, 5.858324, 2.600434>, <0.256302, 5.826877, 2.569409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 6.025320, 3.015689>, <-0.451292, 6.025320, 2.918777>, <-0.577527, 6.025320, 2.597300>, <-0.488697, 6.025320, 2.313033>, 
      <-0.169677, 5.965787, 3.015689>, <-0.451292, 5.965787, 2.918777>, <-0.577527, 5.965787, 2.597300>, <-0.488697, 5.965787, 2.313033>, 
      <-0.132069, 5.853778, 3.053188>, <-0.413683, 5.853778, 2.956276>, <-0.550310, 5.858340, 2.639885>, <-0.461481, 5.858340, 2.355618>, 
      <-0.169677, 5.826877, 3.015689>, <-0.451292, 5.826877, 2.918777>, <-0.577527, 5.826877, 2.597300>, <-0.488697, 5.826877, 2.313033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087486, 4.636220, 0.802407>, <-1.151152, 4.636220, 0.537038>, <-1.426894, 4.636220, 0.361633>, <-1.690336, 4.636220, 0.432852>, 
      <-0.801029, 5.114748, 1.091143>, <-0.864695, 5.114748, 0.825774>, <-1.292842, 5.166858, 0.887137>, <-1.556284, 5.166858, 0.958356>, 
      <-0.203592, 5.432543, 1.662140>, <-0.461639, 5.432543, 1.573338>, <-0.754180, 5.425884, 1.509801>, <-0.835576, 5.425884, 1.770279>, 
      <0.146791, 5.826877, 2.002946>, <-0.111256, 5.826877, 1.914144>, <-0.407302, 5.826877, 2.052555>, <-0.488697, 5.826877, 2.313033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.506528, 4.636220, 1.198989>, <-1.291576, 4.636220, 1.140879>, <-1.035539, 4.636220, 1.018930>, <-1.087486, 4.636220, 0.802407>, 
      <-1.116242, 5.106392, 1.649445>, <-0.901290, 5.106392, 1.591335>, <-0.749081, 5.114748, 1.307666>, <-0.801029, 5.114748, 1.091143>, 
      <-0.252595, 5.425869, 2.173794>, <-0.186182, 5.425869, 1.961261>, <0.006957, 5.432543, 1.734596>, <-0.203592, 5.432543, 1.662140>, 
      <0.256302, 5.826877, 2.569409>, <0.322715, 5.826877, 2.356877>, <0.357340, 5.826877, 2.075402>, <0.146791, 5.826877, 2.002946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.636220, 1.079308>, <-2.056207, 4.636220, 1.310841>, <-1.736380, 4.636220, 1.261127>, <-1.506528, 4.636220, 1.198989>, 
      <-1.785957, 5.126690, 1.755913>, <-1.730408, 5.126690, 1.987446>, <-1.346094, 5.106392, 1.711583>, <-1.116242, 5.106392, 1.649445>, 
      <-0.736301, 5.421591, 2.450727>, <-0.511157, 5.421591, 2.528207>, <-0.323613, 5.425869, 2.401059>, <-0.252595, 5.425869, 2.173794>, 
      <-0.169677, 5.826877, 3.015689>, <0.055468, 5.826877, 3.093168>, <0.185284, 5.826877, 2.796675>, <0.256302, 5.826877, 2.569409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.636220, 1.079308>, <-1.785957, 5.126690, 1.755913>, <-0.736301, 5.421591, 2.450727>, <-0.169677, 5.826877, 3.015689>, 
      <-2.181236, 4.636220, 0.789703>, <-1.855437, 5.126690, 1.466308>, <-1.017916, 5.421591, 2.353815>, <-0.451292, 5.826877, 2.918777>, 
      <-1.977839, 4.636220, 0.510575>, <-1.843786, 5.166858, 1.036079>, <-0.924405, 5.425884, 2.054546>, <-0.577527, 5.826877, 2.597300>, 
      <-1.690336, 4.636220, 0.432852>, <-1.556284, 5.166858, 0.958356>, <-0.835576, 5.425884, 1.770279>, <-0.488697, 5.826877, 2.313033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363385, 3.304121, 0.480757>, <-1.116834, 3.304121, 0.363767>, <-1.002023, 3.304121, 0.057795>, <-1.126006, 3.304121, -0.185314>, 
      <-1.331822, 3.701566, 0.610787>, <-1.085271, 3.701566, 0.493797>, <-1.178972, 3.737056, 0.121155>, <-1.302955, 3.737056, -0.121954>, 
      <-1.278768, 4.316682, 0.609603>, <-1.342434, 4.316682, 0.344235>, <-1.510279, 4.306142, 0.034749>, <-1.773722, 4.306142, 0.105968>, 
      <-1.087486, 4.636220, 0.802407>, <-1.151152, 4.636220, 0.537038>, <-1.426894, 4.636220, 0.361633>, <-1.690336, 4.636220, 0.432852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.837815, 3.304121, 0.152443>, <-1.736653, 3.304121, 0.350804>, <-1.564555, 3.304121, 0.576213>, <-1.363385, 3.304121, 0.480757>, 
      <-1.908695, 3.729605, 0.438964>, <-1.807533, 3.729605, 0.637325>, <-1.532991, 3.701566, 0.706242>, <-1.331822, 3.701566, 0.610787>, 
      <-1.772755, 4.315499, 0.891717>, <-1.557804, 4.315499, 0.833607>, <-1.226821, 4.316682, 0.826126>, <-1.278768, 4.316682, 0.609603>, 
      <-1.506528, 4.636220, 1.198989>, <-1.291576, 4.636220, 1.140879>, <-1.035539, 4.636220, 1.018930>, <-1.087486, 4.636220, 0.802407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.304121, -0.464457>, <-2.060551, 3.304121, -0.362384>, <-1.945990, 3.304121, -0.059669>, <-1.837815, 3.304121, 0.152443>, 
      <-2.127846, 3.759062, -0.158108>, <-2.342961, 3.759062, -0.056035>, <-2.016870, 3.729605, 0.226853>, <-1.908695, 3.729605, 0.438964>, 
      <-2.335837, 4.298878, 0.613944>, <-2.280289, 4.298878, 0.845477>, <-2.002608, 4.315499, 0.953855>, <-1.772755, 4.315499, 0.891717>, 
      <-2.111756, 4.636220, 1.079308>, <-2.056207, 4.636220, 1.310841>, <-1.736380, 4.636220, 1.261127>, <-1.506528, 4.636220, 1.198989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.304121, -0.464457>, <-2.127846, 3.759062, -0.158108>, <-2.335837, 4.298878, 0.613944>, <-2.111756, 4.636220, 1.079308>, 
      <-1.576368, 3.304121, -0.592132>, <-1.858777, 3.759062, -0.285782>, <-2.405318, 4.298878, 0.324339>, <-2.181236, 4.636220, 0.789703>, 
      <-1.261313, 3.304121, -0.450627>, <-1.438262, 3.737056, -0.387266>, <-2.061224, 4.306142, 0.183691>, <-1.977839, 4.636220, 0.510575>, 
      <-1.126006, 3.304121, -0.185314>, <-1.302955, 3.737056, -0.121954>, <-1.773722, 4.306142, 0.105968>, <-1.690336, 4.636220, 0.432852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299147, 1.971033, -0.069548>, <-1.139289, 1.971033, 0.151629>, <-0.817544, 1.971033, 0.208909>, <-0.601022, 1.971033, 0.042799>, 
      <-1.422668, 2.340179, 0.120298>, <-1.262810, 2.340179, 0.341476>, <-0.919221, 2.393234, 0.179985>, <-0.702700, 2.393234, 0.013875>, 
      <-1.395982, 2.893667, 0.346471>, <-1.149431, 2.893667, 0.229481>, <-0.838847, 2.904886, -0.000633>, <-0.962831, 2.904886, -0.243743>, 
      <-1.363385, 3.304121, 0.480757>, <-1.116834, 3.304121, 0.363767>, <-1.002023, 3.304121, 0.057795>, <-1.126006, 3.304121, -0.185314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.062544, 1.971033, -0.595754>, <-1.239211, 1.971033, -0.460219>, <-1.429581, 1.971033, -0.250014>, <-1.299147, 1.971033, -0.069548>, 
      <-1.367822, 2.365505, -0.470797>, <-1.544489, 2.365505, -0.335262>, <-1.553102, 2.340179, -0.060167>, <-1.422668, 2.340179, 0.120298>, 
      <-1.767431, 2.881613, -0.132075>, <-1.666269, 2.881613, 0.066286>, <-1.597152, 2.893667, 0.441927>, <-1.395982, 2.893667, 0.346471>, 
      <-1.837815, 3.304121, 0.152443>, <-1.736653, 3.304121, 0.350804>, <-1.564555, 3.304121, 0.576213>, <-1.363385, 3.304121, 0.480757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 1.971033, -0.715387>, <-0.596783, 1.971033, -0.908363>, <-0.873630, 1.971033, -0.740684>, <-1.062544, 1.971033, -0.595754>, 
      <-0.836619, 2.405149, -0.797210>, <-0.976095, 2.405149, -0.990186>, <-1.178908, 2.365505, -0.615727>, <-1.367822, 2.365505, -0.470797>, 
      <-1.578887, 2.874731, -0.753602>, <-1.794001, 2.874731, -0.651529>, <-1.875606, 2.881613, -0.344187>, <-1.767431, 2.881613, -0.132075>, 
      <-1.845436, 3.304121, -0.464457>, <-2.060551, 3.304121, -0.362384>, <-1.945990, 3.304121, -0.059669>, <-1.837815, 3.304121, 0.152443>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 1.971033, -0.715387>, <-0.836619, 2.405149, -0.797210>, <-1.578887, 2.874731, -0.753602>, <-1.845436, 3.304121, -0.464457>, 
      <-0.282849, 1.971033, -0.474010>, <-0.662161, 2.405149, -0.555832>, <-1.309818, 2.874731, -0.881276>, <-1.576368, 3.304121, -0.592132>, 
      <-0.364726, 1.971033, -0.138482>, <-0.466403, 2.393234, -0.167406>, <-1.098138, 2.904886, -0.509055>, <-1.261313, 3.304121, -0.450627>, 
      <-0.601022, 1.971033, 0.042799>, <-0.702700, 2.393234, 0.013875>, <-0.962831, 2.904886, -0.243743>, <-1.126006, 3.304121, -0.185314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 0.948245, -0.730834>, <-0.763513, 0.948245, -0.533434>, <-0.761351, 0.948245, -0.206637>, <-0.558650, 0.948245, -0.023918>, 
      <-0.761006, 1.278392, -0.538156>, <-0.949439, 1.278392, -0.340755>, <-0.745461, 1.224060, -0.071048>, <-0.542760, 1.224060, 0.111671>, 
      <-1.177912, 1.608718, -0.255881>, <-1.018053, 1.608718, -0.034704>, <-0.745649, 1.672497, 0.229361>, <-0.529127, 1.672497, 0.063251>, 
      <-1.299147, 1.971033, -0.069548>, <-1.139289, 1.971033, 0.151629>, <-0.817544, 1.971033, 0.208909>, <-0.601022, 1.971033, 0.042799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 0.948245, -0.730834>, <-0.396412, 0.630988, -0.915990>, <-0.219002, 0.176232, -1.165133>, <-0.089280, -0.177315, -1.323353>, 
      <-0.763513, 0.948245, -0.533434>, <-0.584846, 0.630988, -0.718589>, <-0.477043, 0.176232, -1.253954>, <-0.347320, -0.177315, -1.412174>, 
      <-0.761351, 0.948245, -0.206637>, <-0.784706, 0.542852, -0.405925>, <-0.598136, 0.183208, -1.004374>, <-0.643376, -0.177315, -1.273784>, 
      <-0.558650, 0.948245, -0.023918>, <-0.582005, 0.542852, -0.223206>, <-0.679551, 0.183208, -0.743902>, <-0.724791, -0.177315, -1.013312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 0.948245, -0.593826>, <-0.180022, 0.948245, -0.742912>, <-0.421330, 0.948245, -0.891900>, <-0.575080, 0.948245, -0.730834>, 
      <-0.211897, 1.339659, -0.564470>, <-0.377288, 1.339659, -0.713556>, <-0.607256, 1.278392, -0.699222>, <-0.761006, 1.278392, -0.538156>, 
      <-0.801745, 1.634034, -0.702504>, <-0.978412, 1.634034, -0.566970>, <-1.308346, 1.608718, -0.436347>, <-1.177912, 1.608718, -0.255881>, 
      <-1.062544, 1.971033, -0.595754>, <-1.239211, 1.971033, -0.460219>, <-1.429581, 1.971033, -0.250014>, <-1.299147, 1.971033, -0.069548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 0.948245, -0.593826>, <0.138655, 0.644099, -0.616637>, <0.011282, 0.161363, -0.715172>, <0.020189, -0.177315, -0.756881>, 
      <-0.180022, 0.948245, -0.742912>, <-0.026737, 0.644099, -0.765724>, <0.077712, 0.161363, -0.927700>, <0.086618, -0.177315, -0.969409>, 
      <-0.421330, 0.948245, -0.891900>, <-0.242663, 0.630988, -1.077056>, <-0.008458, 0.176232, -1.092662>, <0.121264, -0.177315, -1.250881>, 
      <-0.575080, 0.948245, -0.730834>, <-0.396412, 0.630988, -0.915990>, <-0.219002, 0.176232, -1.165133>, <-0.089280, -0.177315, -1.323353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 0.948245, -0.020419>, <0.377436, 0.948245, -0.192650>, <0.162226, 0.948245, -0.434405>, <-0.014631, 0.948245, -0.593826>, 
      <0.203094, 1.362805, -0.098523>, <0.367501, 1.362805, -0.270754>, <-0.035040, 1.339659, -0.405048>, <-0.211897, 1.339659, -0.564470>, 
      <-0.182417, 1.656426, -0.656089>, <-0.321893, 1.656426, -0.849065>, <-0.612831, 1.634034, -0.847435>, <-0.801745, 1.634034, -0.702504>, 
      <-0.457307, 1.971033, -0.715387>, <-0.596783, 1.971033, -0.908363>, <-0.873630, 1.971033, -0.740684>, <-1.062544, 1.971033, -0.595754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 0.948245, -0.020419>, <0.222330, 0.560129, 0.052703>, <-0.241746, 0.173721, -0.233687>, <-0.405823, -0.177315, -0.310632>, 
      <0.377436, 0.948245, -0.192650>, <0.386737, 0.560129, -0.119528>, <-0.016606, 0.173721, -0.156192>, <-0.180684, -0.177315, -0.233136>, 
      <0.162226, 0.948245, -0.434405>, <0.315511, 0.644099, -0.457216>, <-0.059752, 0.161363, -0.487911>, <-0.050845, -0.177315, -0.529620>, 
      <-0.014631, 0.948245, -0.593826>, <0.138655, 0.644099, -0.616637>, <0.011282, 0.161363, -0.715172>, <0.020189, -0.177315, -0.756881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 0.948245, -0.020419>, <0.203094, 1.362805, -0.098523>, <-0.182417, 1.656426, -0.656089>, <-0.457307, 1.971033, -0.715387>, 
      <0.007386, 0.948245, 0.195010>, <-0.002549, 1.362805, 0.116906>, <-0.007959, 1.656426, -0.414712>, <-0.282849, 1.971033, -0.474010>, 
      <-0.337436, 0.948245, 0.175488>, <-0.321546, 1.224060, 0.311077>, <-0.292831, 1.672497, -0.118029>, <-0.364726, 1.971033, -0.138482>, 
      <-0.558650, 0.948245, -0.023918>, <-0.542760, 1.224060, 0.111671>, <-0.529127, 1.672497, 0.063251>, <-0.601022, 1.971033, 0.042799>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 0.948245, -0.020419>, <0.007386, 0.948245, 0.195010>, <-0.337436, 0.948245, 0.175488>, <-0.558650, 0.948245, -0.023918>, 
      <0.222330, 0.560129, 0.052703>, <0.016687, 0.560129, 0.268132>, <-0.360791, 0.542852, -0.023800>, <-0.582005, 0.542852, -0.223206>, 
      <-0.241746, 0.173721, -0.233687>, <-0.523353, 0.173721, -0.330620>, <-0.768401, 0.183208, -0.459641>, <-0.679551, 0.183208, -0.743902>, 
      <-0.405823, -0.177315, -0.310632>, <-0.687430, -0.177315, -0.407565>, <-0.813641, -0.177315, -0.729051>, <-0.724791, -0.177315, -1.013312>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576448, -0.375758, -1.902947>, <0.576448, -0.375758, -2.175846>, <0.349236, -0.375758, -2.410741>, <0.076448, -0.375758, -2.402947>, 
      <0.576448, -0.316225, -1.902947>, <0.576448, -0.316225, -2.175846>, <0.349236, -0.316225, -2.410741>, <0.076448, -0.316225, -2.402947>, 
      <0.619103, -0.217646, -1.912853>, <0.619103, -0.217646, -2.185753>, <0.389498, -0.211413, -2.438318>, <0.116710, -0.211413, -2.430524>, 
      <0.576448, -0.177315, -1.902947>, <0.576448, -0.177315, -2.175846>, <0.349236, -0.177315, -2.410741>, <0.076448, -0.177315, -2.402947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076448, -0.375758, -1.615068>, <0.299025, -0.375758, -1.621427>, <0.576448, -0.375758, -1.680279>, <0.576448, -0.375758, -1.902947>, 
      <0.076448, -0.316225, -1.615068>, <0.299025, -0.316225, -1.621427>, <0.576448, -0.316225, -1.680279>, <0.576448, -0.316225, -1.902947>, 
      <0.106356, -0.224042, -1.636662>, <0.328933, -0.224042, -1.643021>, <0.619103, -0.217646, -1.690185>, <0.619103, -0.217646, -1.912853>, 
      <0.076448, -0.177315, -1.615068>, <0.299025, -0.177315, -1.621427>, <0.576448, -0.177315, -1.680279>, <0.576448, -0.177315, -1.902947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.375758, -1.872644>, <-0.484158, -0.375758, -1.634540>, <-0.161558, -0.375758, -1.608268>, <0.076448, -0.375758, -1.615068>, 
      <-0.484158, -0.316225, -1.872644>, <-0.484158, -0.316225, -1.634540>, <-0.161558, -0.316225, -1.608268>, <0.076448, -0.316225, -1.615068>, 
      <-0.461514, -0.217029, -1.910778>, <-0.461514, -0.217029, -1.672675>, <-0.131651, -0.224042, -1.629862>, <0.106356, -0.224042, -1.636662>, 
      <-0.484158, -0.177315, -1.872644>, <-0.484158, -0.177315, -1.634540>, <-0.161558, -0.177315, -1.608268>, <0.076448, -0.177315, -1.615068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.375758, -1.872644>, <-0.484158, -0.316225, -1.872644>, <-0.461514, -0.217029, -1.910778>, <-0.484158, -0.177315, -1.872644>, 
      <-0.484158, -0.375758, -2.170467>, <-0.484158, -0.316225, -2.170467>, <-0.461514, -0.217029, -2.208601>, <-0.484158, -0.177315, -2.170467>, 
      <-0.221254, -0.375758, -2.394441>, <-0.221254, -0.316225, -2.394441>, <-0.180992, -0.211413, -2.422019>, <-0.221254, -0.177315, -2.394441>, 
      <0.076448, -0.375758, -2.402947>, <0.076448, -0.316225, -2.402947>, <0.116710, -0.211413, -2.430524>, <0.076448, -0.177315, -2.402947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.812477, 6.025320, 1.423303>, <0.812477, 5.965787, 1.423303>, <0.847665, 5.873274, 1.435682>, <0.812477, 5.826877, 1.423303>, 
      <0.812457, 6.025320, 1.150403>, <0.812457, 5.965787, 1.150403>, <0.847645, 5.873274, 1.162782>, <0.812457, 5.826877, 1.150403>, 
      <0.585227, 6.025320, 0.915526>, <0.585227, 5.965787, 0.915526>, <0.600594, 5.880208, 0.937063>, <0.585227, 5.826877, 0.915526>, 
      <0.312440, 6.025320, 0.923340>, <0.312440, 5.965787, 0.923340>, <0.327806, 5.880208, 0.944877>, <0.312440, 5.826877, 0.923340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312498, 6.025320, 1.711219>, <0.312498, 5.965787, 1.711219>, <0.344516, 5.868643, 1.739051>, <0.312498, 5.826877, 1.711219>, 
      <0.535075, 6.025320, 1.704843>, <0.535075, 5.965787, 1.704843>, <0.567093, 5.868643, 1.732675>, <0.535075, 5.826877, 1.704843>, 
      <0.812493, 6.025320, 1.645971>, <0.812493, 5.965787, 1.645971>, <0.847681, 5.873274, 1.658350>, <0.812493, 5.826877, 1.645971>, 
      <0.812477, 6.025320, 1.423303>, <0.812477, 5.965787, 1.423303>, <0.847665, 5.873274, 1.435682>, <0.812477, 5.826877, 1.423303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 6.025320, 1.453684>, <-0.248127, 5.965787, 1.453684>, <-0.230427, 5.868687, 1.492191>, <-0.248127, 5.826877, 1.453684>, 
      <-0.248110, 6.025320, 1.691787>, <-0.248110, 5.965787, 1.691787>, <-0.230409, 5.868687, 1.730294>, <-0.248110, 5.826877, 1.691787>, 
      <0.074492, 6.025320, 1.718036>, <0.074492, 5.965787, 1.718036>, <0.106510, 5.868643, 1.745869>, <0.074492, 5.826877, 1.718036>, 
      <0.312498, 6.025320, 1.711219>, <0.312498, 5.965787, 1.711219>, <0.344516, 5.868643, 1.739051>, <0.312498, 5.826877, 1.711219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 6.025320, 1.453684>, <-0.248149, 6.025320, 1.155860>, <0.014739, 6.025320, 0.931867>, <0.312440, 6.025320, 0.923340>, 
      <-0.248127, 5.965787, 1.453684>, <-0.248149, 5.965787, 1.155860>, <0.014739, 5.965787, 0.931867>, <0.312440, 5.965787, 0.923340>, 
      <-0.230427, 5.868687, 1.492191>, <-0.230449, 5.868687, 1.194368>, <0.030105, 5.880208, 0.953404>, <0.327806, 5.880208, 0.944877>, 
      <-0.248127, 5.826877, 1.453684>, <-0.248149, 5.826877, 1.155860>, <0.014739, 5.826877, 0.931867>, <0.312440, 5.826877, 0.923340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241030, 4.636220, 1.052679>, <-0.010831, 4.636220, 0.906109>, <0.065278, 4.636220, 0.588292>, <-0.087806, 4.636220, 0.362373>, 
      <0.084590, 5.001912, 1.061765>, <0.314788, 5.001912, 0.915196>, <0.220423, 5.012845, 0.521865>, <0.067339, 5.012845, 0.295946>, 
      <0.523008, 5.445198, 1.321467>, <0.522988, 5.445198, 1.048568>, <0.478700, 5.457162, 0.766222>, <0.205913, 5.457162, 0.774036>, 
      <0.812477, 5.826877, 1.423303>, <0.812457, 5.826877, 1.150403>, <0.585227, 5.826877, 0.915526>, <0.312440, 5.826877, 0.923340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.752406, 4.636220, 0.785529>, <-0.627499, 4.636220, 0.969864>, <-0.428857, 4.636220, 1.172270>, <-0.241030, 4.636220, 1.052679>, 
      <-0.469798, 5.084529, 0.946540>, <-0.344892, 5.084529, 1.130875>, <-0.103238, 5.001912, 1.181356>, <0.084590, 5.001912, 1.061765>, 
      <0.014614, 5.438306, 1.452277>, <0.237191, 5.438306, 1.445901>, <0.523024, 5.445198, 1.544135>, <0.523008, 5.445198, 1.321467>, 
      <0.312498, 5.826877, 1.711219>, <0.535075, 5.826877, 1.704843>, <0.812493, 5.826877, 1.645971>, <0.812477, 5.826877, 1.423303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.636220, 0.174301>, <-1.037072, 4.636220, 0.302182>, <-0.885971, 4.636220, 0.588415>, <-0.752406, 4.636220, 0.785529>, 
      <-0.744318, 5.152773, 0.349677>, <-0.945166, 5.152773, 0.477558>, <-0.603364, 5.084529, 0.749427>, <-0.469798, 5.084529, 0.946540>, 
      <-0.412609, 5.438368, 1.095860>, <-0.412591, 5.438368, 1.333964>, <-0.223392, 5.438306, 1.459094>, <0.014614, 5.438306, 1.452277>, 
      <-0.248127, 5.826877, 1.453684>, <-0.248110, 5.826877, 1.691787>, <0.074492, 5.826877, 1.718036>, <0.312498, 5.826877, 1.711219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.636220, 0.174301>, <-0.744318, 5.152773, 0.349677>, <-0.412609, 5.438368, 1.095860>, <-0.248127, 5.826877, 1.453684>, 
      <-0.585001, 4.636220, 0.014345>, <-0.493095, 5.152773, 0.189721>, <-0.412631, 5.438368, 0.798037>, <-0.248149, 5.826877, 1.155860>, 
      <-0.254871, 4.636220, 0.115821>, <-0.099726, 5.012845, 0.049394>, <-0.091789, 5.457162, 0.782563>, <0.014739, 5.826877, 0.931867>, 
      <-0.087806, 4.636220, 0.362373>, <0.067339, 5.012845, 0.295946>, <0.205913, 5.457162, 0.774036>, <0.312440, 5.826877, 0.923340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.433836, 3.304121, 1.360621>, <-1.242971, 3.304121, 1.555671>, <-0.916290, 3.304121, 1.564646>, <-0.726770, 3.304121, 1.368288>, 
      <-1.128536, 3.724385, 1.523284>, <-0.937670, 3.724385, 1.718334>, <-0.599554, 3.732985, 1.507454>, <-0.410035, 3.732985, 1.311096>, 
      <-0.602945, 4.229766, 1.042580>, <-0.372746, 4.229766, 0.896010>, <-0.136291, 4.146896, 0.674596>, <-0.289375, 4.146896, 0.448677>, 
      <-0.241030, 4.636220, 1.052679>, <-0.010831, 4.636220, 0.906109>, <0.065278, 4.636220, 0.588292>, <-0.087806, 4.636220, 0.362373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277811, 3.304121, 0.805165>, <-1.432447, 3.304121, 0.965380>, <-1.589570, 3.304121, 1.201472>, <-1.433836, 3.304121, 1.360621>, 
      <-1.151276, 3.700787, 0.911127>, <-1.305911, 3.700787, 1.071343>, <-1.284269, 3.724385, 1.364136>, <-1.128536, 3.724385, 1.523284>, 
      <-0.971622, 4.288471, 0.660634>, <-0.846715, 4.288471, 0.844969>, <-0.790772, 4.229766, 1.162171>, <-0.602945, 4.229766, 1.042580>, 
      <-0.752406, 4.636220, 0.785529>, <-0.627499, 4.636220, 0.969864>, <-0.428857, 4.636220, 1.172270>, <-0.241030, 4.636220, 1.052679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.304121, 0.597176>, <-0.863509, 3.304121, 0.426996>, <-1.112457, 3.304121, 0.633843>, <-1.277811, 3.304121, 0.805165>, 
      <-0.626773, 3.714222, 0.530608>, <-0.793303, 3.714222, 0.360428>, <-0.985921, 3.700787, 0.739806>, <-1.151276, 3.700787, 0.911127>, 
      <-0.906227, 4.242774, 0.040721>, <-1.107074, 4.242774, 0.168602>, <-1.105187, 4.288471, 0.463521>, <-0.971622, 4.288471, 0.660634>, 
      <-0.836224, 4.636220, 0.174301>, <-1.037072, 4.636220, 0.302182>, <-0.885971, 4.636220, 0.588415>, <-0.752406, 4.636220, 0.785529>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.304121, 0.597176>, <-0.626773, 3.714222, 0.530608>, <-0.906227, 4.242774, 0.040721>, <-0.836224, 4.636220, 0.174301>, 
      <-0.488683, 3.304121, 0.810040>, <-0.418476, 3.714222, 0.743472>, <-0.655004, 4.242774, -0.119235>, <-0.585001, 4.636220, 0.014345>, 
      <-0.519942, 3.304121, 1.153996>, <-0.203207, 3.732985, 1.096804>, <-0.456441, 4.146896, 0.202124>, <-0.254871, 4.636220, 0.115821>, 
      <-0.726770, 3.304121, 1.368288>, <-0.410035, 3.732985, 1.311096>, <-0.289375, 4.146896, 0.448677>, <-0.087806, 4.636220, 0.362373>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.177158, 1.971033, 0.021116>, <-2.334263, 1.971033, 0.244258>, <-2.283705, 1.971033, 0.567127>, <-2.056168, 1.971033, 0.717795>, 
      <-2.274564, 2.347221, 0.490316>, <-2.431669, 2.347221, 0.713457>, <-2.159711, 2.355320, 1.007615>, <-1.932174, 2.355320, 1.158283>, 
      <-1.775538, 2.833751, 1.178563>, <-1.584672, 2.833751, 1.373614>, <-1.269269, 2.826184, 1.628383>, <-1.079749, 2.826184, 1.432024>, 
      <-1.433836, 3.304121, 1.360621>, <-1.242971, 3.304121, 1.555671>, <-0.916290, 3.304121, 1.564646>, <-0.726770, 3.304121, 1.368288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.602595, 1.971033, 0.073571>, <-1.788250, 1.971033, -0.049364>, <-2.048971, 1.971033, -0.160952>, <-2.177158, 1.971033, 0.021116>, 
      <-1.681069, 2.335795, 0.353564>, <-1.866725, 2.335795, 0.230628>, <-2.146376, 2.347221, 0.308247>, <-2.274564, 2.347221, 0.490316>, 
      <-1.415200, 2.873432, 0.690114>, <-1.569836, 2.873432, 0.850329>, <-1.931271, 2.833751, 1.019415>, <-1.775538, 2.833751, 1.178563>, 
      <-1.277811, 3.304121, 0.805165>, <-1.432447, 3.304121, 0.965380>, <-1.589570, 3.304121, 1.201472>, <-1.433836, 3.304121, 1.360621>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 1.971033, 0.606917>, <-1.155416, 1.971033, 0.412228>, <-1.404070, 1.971033, 0.205029>, <-1.602595, 1.971033, 0.073571>, 
      <-1.204488, 2.353482, 0.801480>, <-1.067415, 2.353482, 0.606790>, <-1.482544, 2.335795, 0.485021>, <-1.681069, 2.335795, 0.353564>, 
      <-0.769964, 2.877799, 0.666377>, <-0.936493, 2.877799, 0.496197>, <-1.249845, 2.873432, 0.518792>, <-1.415200, 2.873432, 0.690114>, 
      <-0.696980, 3.304121, 0.597176>, <-0.863509, 3.304121, 0.426996>, <-1.112457, 3.304121, 0.633843>, <-1.277811, 3.304121, 0.805165>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 1.971033, 0.606917>, <-1.204488, 2.353482, 0.801480>, <-0.769964, 2.877799, 0.666377>, <-0.696980, 3.304121, 0.597176>, 
      <-1.463942, 1.971033, 0.850438>, <-1.375941, 2.353482, 1.045000>, <-0.561667, 2.877799, 0.879241>, <-0.488683, 3.304121, 0.810040>, 
      <-1.807850, 1.971033, 0.882224>, <-1.683856, 2.355320, 1.322711>, <-0.872921, 2.826184, 1.217733>, <-0.519942, 3.304121, 1.153996>, 
      <-2.056168, 1.971033, 0.717795>, <-1.932174, 2.355320, 1.158283>, <-1.079749, 2.826184, 1.432024>, <-0.726770, 3.304121, 1.368288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 0.948245, -1.577736>, <-1.071818, 0.948245, -1.691661>, <-1.380118, 0.948245, -1.583255>, <-1.486914, 0.948245, -1.332121>, 
      <-1.306765, 1.325024, -1.240292>, <-1.554747, 1.325024, -1.354218>, <-1.727487, 1.298178, -1.074936>, <-1.834284, 1.298178, -0.823801>, 
      <-2.065347, 1.539209, -0.517473>, <-2.222453, 1.539209, -0.294332>, <-2.430650, 1.515613, 0.045105>, <-2.203113, 1.515613, 0.195773>, 
      <-2.177158, 1.971033, 0.021116>, <-2.334263, 1.971033, 0.244258>, <-2.283705, 1.971033, 0.567127>, <-2.056168, 1.971033, 0.717795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 0.948245, -1.577736>, <-0.445590, 0.653140, -1.842033>, <0.184004, 0.193751, -1.811803>, <0.576448, -0.177315, -1.902947>, 
      <-1.071818, 0.948245, -1.691661>, <-0.693572, 0.653140, -1.955958>, <0.184004, 0.193751, -2.084702>, <0.576448, -0.177315, -2.175846>, 
      <-1.380118, 0.948245, -1.583255>, <-1.055787, 0.621522, -2.057862>, <-0.097932, 0.201389, -2.104453>, <0.349236, -0.177315, -2.410741>, 
      <-1.486914, 0.948245, -1.332121>, <-1.162584, 0.621522, -1.806727>, <-0.370720, 0.201389, -2.096659>, <0.076448, -0.177315, -2.402947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 0.948245, -1.003210>, <-0.683835, 0.948245, -1.208119>, <-0.621499, 0.948245, -1.484780>, <-0.823836, 0.948245, -1.577736>, 
      <-1.038301, 1.290293, -0.734355>, <-0.951162, 1.290293, -0.939264>, <-1.104428, 1.325024, -1.147337>, <-1.306765, 1.325024, -1.240292>, 
      <-1.516694, 1.571749, -0.232920>, <-1.702350, 1.571749, -0.355855>, <-1.937160, 1.539209, -0.699542>, <-2.065347, 1.539209, -0.517473>, 
      <-1.602595, 1.971033, 0.073571>, <-1.788250, 1.971033, -0.049364>, <-2.048971, 1.971033, -0.160952>, <-2.177158, 1.971033, 0.021116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 0.948245, -1.003210>, <-0.529729, 0.639572, -1.245833>, <-0.155047, 0.184371, -1.447923>, <0.076448, -0.177315, -1.615068>, 
      <-0.683835, 0.948245, -1.208119>, <-0.442590, 0.639572, -1.450742>, <0.067530, 0.184371, -1.454282>, <0.299025, -0.177315, -1.621427>, 
      <-0.621499, 0.948245, -1.484780>, <-0.243253, 0.653140, -1.749077>, <0.184004, 0.193751, -1.589135>, <0.576448, -0.177315, -1.680279>, 
      <-0.823836, 0.948245, -1.577736>, <-0.445590, 0.653140, -1.842033>, <0.184004, 0.193751, -1.811803>, <0.576448, -0.177315, -1.902947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 0.948245, -0.601320>, <-1.022701, 0.948245, -0.501920>, <-0.864153, 0.948245, -0.784096>, <-0.770974, 0.948245, -1.003210>, 
      <-1.352739, 1.250367, -0.252621>, <-1.136376, 1.250367, -0.153221>, <-1.131480, 1.290293, -0.515241>, <-1.038301, 1.290293, -0.734355>, 
      <-1.387954, 1.556147, 0.395854>, <-1.250880, 1.556147, 0.201165>, <-1.318169, 1.571749, -0.101463>, <-1.516694, 1.571749, -0.232920>, 
      <-1.292489, 1.971033, 0.606917>, <-1.155416, 1.971033, 0.412228>, <-1.404070, 1.971033, 0.205029>, <-1.602595, 1.971033, 0.073571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 0.948245, -0.601320>, <-1.105701, 0.593800, -1.010411>, <-0.696196, 0.194572, -1.515554>, <-0.484158, -0.177315, -1.872644>, 
      <-1.022701, 0.948245, -0.501920>, <-0.889338, 0.593800, -0.911012>, <-0.696196, 0.194572, -1.277450>, <-0.484158, -0.177315, -1.634540>, 
      <-0.864153, 0.948245, -0.784096>, <-0.622909, 0.639572, -1.026720>, <-0.393054, 0.184371, -1.441123>, <-0.161558, -0.177315, -1.608268>, 
      <-0.770974, 0.948245, -1.003210>, <-0.529729, 0.639572, -1.245833>, <-0.155047, 0.184371, -1.447923>, <0.076448, -0.177315, -1.615068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 0.948245, -0.601320>, <-1.352739, 1.250367, -0.252621>, <-1.387954, 1.556147, 0.395854>, <-1.292489, 1.971033, 0.606917>, 
      <-1.509694, 0.948245, -0.725650>, <-1.623369, 1.250367, -0.376951>, <-1.559407, 1.556147, 0.639375>, <-1.463942, 1.971033, 0.850438>, 
      <-1.603465, 0.948245, -1.058050>, <-1.950835, 1.298178, -0.549731>, <-1.954795, 1.515613, 0.360202>, <-1.807850, 1.971033, 0.882224>, 
      <-1.486914, 0.948245, -1.332121>, <-1.834284, 1.298178, -0.823801>, <-2.203113, 1.515613, 0.195773>, <-2.056168, 1.971033, 0.717795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 0.948245, -0.601320>, <-1.509694, 0.948245, -0.725650>, <-1.603465, 0.948245, -1.058050>, <-1.486914, 0.948245, -1.332121>, 
      <-1.105701, 0.593800, -1.010411>, <-1.376331, 0.593800, -1.134741>, <-1.279134, 0.621522, -1.532656>, <-1.162584, 0.621522, -1.806727>, 
      <-0.696196, 0.194572, -1.515554>, <-0.696196, 0.194572, -1.813377>, <-0.668422, 0.201389, -2.088153>, <-0.370720, 0.201389, -2.096659>, 
      <-0.484158, -0.177315, -1.872644>, <-0.484158, -0.177315, -2.170467>, <-0.221254, -0.177315, -2.394441>, <0.076448, -0.177315, -2.402947>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.088174, -1.798039, 0.187419>
}
#declare segMshiftMB1 = union {
  object { // Blatt60->Blatt11
    Blatt11
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <-3.01702, -0.333698, -1.719416>
  }
  object { // Blatt61->Blatt11
    Blatt11
    rotate <-20.233294, -23.362207, -124.43499>
    translate  <-2.034715, -5.606219, 2.373009>
  }
  object { Blatt62 }
  object { sPatchObj21 }
  translate  <0.12552, 3.047826, 17.350668>
}
#declare BezPtch022 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt65 = union {
  cone { // Cone022
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch022 }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare sPatchObj22 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.277127, -0.051562, 0.507806>, <0.125600, -0.051562, 0.734772>, <0.174932, -0.040910, 1.071062>, <0.406133, -0.040910, 1.216045>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.865420, -0.051004, 0.566965>, <0.676775, -0.051004, 0.448668>, <0.400763, -0.051562, 0.322616>, <0.277127, -0.051562, 0.507806>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.184046, -0.040947, 1.104300>, <1.316252, -0.040947, 0.906273>, <1.067142, -0.051004, 0.693461>, <0.865420, -0.051004, 0.566965>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.184046, -0.040947, 1.104300>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.018680, -0.040947, 1.351995>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.658450, -0.040910, 1.374270>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.406133, -0.040910, 1.216045>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>, 
      <-0.855631, 5.429722, 0.730006>, <-0.803530, 5.400920, 0.730006>, <-0.733936, 5.361541, 0.721743>, <-0.681960, 5.333712, 0.730007>, 
      <-0.827295, 5.480978, 1.051520>, <-0.775194, 5.452176, 1.051520>, <-0.690273, 5.431881, 1.050960>, <-0.653624, 5.384969, 1.051520>, 
      <-0.715431, 5.683328, 1.196486>, <-0.663330, 5.654525, 1.196486>, <-0.578409, 5.634231, 1.195926>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>, 
      <-0.595074, 5.901042, 0.422904>, <-0.542973, 5.872240, 0.422904>, <-0.464206, 5.839552, 0.400091>, <-0.421402, 5.805032, 0.422904>, 
      <-0.722518, 5.670511, 0.317830>, <-0.670416, 5.641708, 0.317830>, <-0.600822, 5.602329, 0.309567>, <-0.548846, 5.574500, 0.317830>, 
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.295297, 6.320257, 1.066661>, <-0.202994, 6.299939, 1.044549>, <-0.173727, 6.253049, 1.066661>, 
      <-0.283442, 6.464750, 0.868624>, <-0.231340, 6.435948, 0.868624>, <-0.139038, 6.415630, 0.846512>, <-0.109770, 6.368740, 0.868624>, 
      <-0.406199, 6.242695, 0.667669>, <-0.354098, 6.213892, 0.667669>, <-0.275331, 6.181205, 0.644856>, <-0.232528, 6.146685, 0.667669>, 
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.427396, 6.204352, 1.314368>, <-0.593351, 5.904158, 1.354692>, <-0.715431, 5.683328, 1.196486>, 
      <-0.295297, 6.320257, 1.066661>, <-0.375294, 6.175549, 1.314368>, <-0.541249, 5.875356, 1.354692>, <-0.663330, 5.654525, 1.196486>, 
      <-0.202994, 6.299939, 1.044549>, <-0.282992, 6.155232, 1.292256>, <-0.456328, 5.855060, 1.354132>, <-0.578409, 5.634231, 1.195926>, 
      <-0.173727, 6.253049, 1.066661>, <-0.253725, 6.108342, 1.314368>, <-0.419679, 5.808149, 1.354692>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>, 
      <0.333387, 5.140495, 0.666297>, <0.146841, 4.941398, 0.660378>, <0.089060, 4.814777, 1.059697>, <0.090343, 4.816146, 1.332590>, 
      <-0.246561, 5.272440, 0.560594>, <-0.319864, 5.139843, 0.787572>, <-0.398275, 5.058113, 1.055421>, <-0.286411, 5.260462, 1.200388>, 
      <-0.608657, 5.466310, 0.503029>, <-0.681960, 5.333712, 0.730007>, <-0.653624, 5.384969, 1.051520>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>, 
      <0.632096, 5.471738, 1.114818>, <0.631049, 5.470621, 0.892155>, <0.485597, 5.302945, 0.671125>, <0.333387, 5.140495, 0.666297>, 
      <0.018129, 5.689274, 0.726800>, <-0.073145, 5.524170, 0.608517>, <-0.186750, 5.380631, 0.375396>, <-0.246561, 5.272440, 0.560594>, 
      <-0.330128, 5.970136, 0.541187>, <-0.421402, 5.805032, 0.422904>, <-0.548846, 5.574500, 0.317830>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>, 
      <0.559724, 5.359637, 1.785183>, <0.722485, 5.533348, 1.790346>, <0.633215, 5.472933, 1.352916>, <0.632096, 5.471738, 1.114818>, 
      <0.087598, 5.834381, 1.264095>, <0.151555, 5.950072, 1.066059>, <0.115730, 5.865823, 0.853283>, <0.018129, 5.689274, 0.726800>, 
      <-0.173727, 6.253049, 1.066661>, <-0.109770, 6.368740, 0.868624>, <-0.232528, 6.146685, 0.667669>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.559724, 5.359637, 1.785183>, <0.087598, 5.834381, 1.264095>, <-0.173727, 6.253049, 1.066661>, 
      <0.397381, 4.612405, 1.776704>, <0.356140, 5.142357, 1.778724>, <0.007600, 5.689674, 1.511802>, <-0.253725, 6.108342, 1.314368>, 
      <0.248176, 4.453163, 1.509005>, <0.091744, 4.817640, 1.630407>, <-0.164330, 5.481292, 1.358594>, <-0.419679, 5.808149, 1.354692>, 
      <0.246776, 4.451668, 1.211188>, <0.090343, 4.816146, 1.332590>, <-0.286411, 5.260462, 1.200388>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>, 
      <0.882376, 3.995773, 0.849049>, <0.841315, 3.966481, 0.580851>, <0.516590, 3.777855, 0.584002>, <0.299515, 3.623001, 0.642080>, 
      <0.833105, 4.538882, 0.772586>, <0.646558, 4.339785, 0.766668>, <0.405989, 4.076356, 0.813740>, <0.407272, 4.077726, 1.086633>, 
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>, 
      <0.621171, 3.839677, 1.368932>, <0.798289, 3.966028, 1.321545>, <0.915880, 4.019673, 1.067881>, <0.882376, 3.995773, 0.849049>, 
      <0.944036, 4.565423, 1.345753>, <0.942989, 4.564306, 1.123091>, <0.985314, 4.701332, 0.777415>, <0.833105, 4.538882, 0.772586>, 
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>, 
      <0.099322, 3.489870, 1.437820>, <0.135148, 3.515427, 1.671821>, <0.431775, 3.704567, 1.419605>, <0.621171, 3.839677, 1.368932>, 
      <0.647941, 4.226036, 1.780862>, <0.810702, 4.399747, 1.786026>, <0.945155, 4.566618, 1.583851>, <0.944036, 4.565423, 1.345753>, 
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.099322, 3.489870, 1.437820>, <0.647941, 4.226036, 1.780862>, <0.600965, 4.829686, 1.783163>, 
      <0.032918, 2.989836, 0.761653>, <0.054511, 3.457903, 1.145127>, <0.444357, 4.008756, 1.774404>, <0.397381, 4.612405, 1.776704>, 
      <0.209558, 3.115845, 0.492946>, <0.062615, 3.454004, 0.705462>, <0.408672, 4.079220, 1.384450>, <0.248176, 4.453163, 1.509005>, 
      <0.446457, 3.284843, 0.429564>, <0.299515, 3.623001, 0.642080>, <0.407272, 4.077726, 1.086633>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>, 
      <0.842239, 2.712652, 0.652879>, <1.079409, 2.805129, 0.554528>, <1.039943, 2.771892, 0.171966>, <0.941576, 2.733537, -0.079682>, 
      <0.963539, 3.228570, 0.806736>, <0.922478, 3.199278, 0.538538>, <0.788065, 3.153108, 0.191378>, <0.570991, 2.998253, 0.249456>, 
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>, 
      <0.313144, 2.546508, 0.450622>, <0.393406, 2.577804, 0.655950>, <0.648725, 2.637197, 0.733127>, <0.842239, 2.712652, 0.652879>, 
      <0.512441, 2.929325, 1.049401>, <0.689559, 3.055676, 1.002013>, <0.997042, 3.252470, 1.025568>, <0.963539, 3.228570, 0.806736>, 
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>, 
      <0.147649, 2.501586, -0.170179>, <-0.059280, 2.420900, -0.084369>, <0.227320, 2.513043, 0.231060>, <0.313144, 2.546508, 0.450622>, 
      <0.059256, 2.621347, 0.726264>, <0.095082, 2.646904, 0.960265>, <0.323045, 2.794215, 1.100074>, <0.512441, 2.929325, 1.049401>, 
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.147649, 2.501586, -0.170179>, <0.059256, 2.621347, 0.726264>, <0.077730, 3.021803, 1.054346>, 
      <0.737188, 2.272763, -0.501665>, <0.406479, 2.602509, -0.277512>, <0.014445, 2.589380, 0.433571>, <0.032918, 2.989836, 0.761653>, 
      <1.020113, 2.383082, -0.337147>, <0.834225, 2.691678, -0.354314>, <0.334091, 2.829256, 0.312838>, <0.209558, 3.115845, 0.492946>, 
      <1.127464, 2.424940, -0.062515>, <0.941576, 2.733537, -0.079682>, <0.570991, 2.998253, 0.249456>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <1.184052, 1.106319, 0.616299>, <1.499098, 1.137656, 0.697322>, <1.726240, 1.160250, 0.547756>, 
      <1.129392, 1.459057, 0.396667>, <1.271676, 1.473210, 0.629109>, <1.610121, 1.531984, 0.492588>, <1.837264, 1.554577, 0.343022>, 
      <0.878420, 1.949636, 0.518860>, <1.115590, 2.042113, 0.420509>, <1.461870, 2.071445, 0.210932>, <1.363502, 2.033089, -0.040716>, 
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>, 
      <1.184052, 1.106319, 0.616299>, <1.091978, 0.720794, 0.602838>, <0.350665, 0.343493, 0.698289>, <0.154975, 0.000000, 0.730010>, 
      <1.499098, 1.137656, 0.697322>, <1.364811, 0.660701, 0.944957>, <0.572554, 0.380657, 0.869770>, <0.213519, 0.000000, 1.051528>, 
      <1.726240, 1.160250, 0.547756>, <1.591953, 0.683295, 0.795391>, <0.803756, 0.380657, 1.014753>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.130124, 1.100955, -0.001283>, <0.925674, 1.080618, 0.194200>, <1.041768, 1.092166, 0.383857>, 
      <1.232537, 1.526577, -0.183665>, <1.047204, 1.508142, -0.061629>, <1.013298, 1.447509, 0.207010>, <1.129392, 1.459057, 0.396667>, 
      <0.558680, 1.810340, 0.016388>, <0.638942, 1.841635, 0.221717>, <0.684905, 1.874181, 0.599108>, <0.878420, 1.949636, 0.518860>, 
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>, 
      <1.130124, 1.100955, -0.001283>, <1.211405, 0.701818, 0.057870>, <0.809481, 0.352635, 0.245119>, <0.693544, 0.000000, 0.422947>, 
      <0.925674, 1.080618, 0.194200>, <0.833600, 0.695093, 0.180739>, <0.625828, 0.343493, 0.286133>, <0.430138, 0.000000, 0.317854>, 
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.800760, 1.167662, -0.400463>, <1.513638, 1.139103, -0.253815>, <1.315458, 1.119390, -0.123319>, 
      <1.783199, 1.603298, -0.482420>, <1.659057, 1.590950, -0.685224>, <1.430718, 1.546290, -0.314161>, <1.232537, 1.526577, -0.183665>, 
      <0.816377, 1.834805, -0.623440>, <0.609448, 1.754119, -0.537630>, <0.472855, 1.776875, -0.203174>, <0.558680, 1.810340, 0.016388>, 
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.075298, 0.730756, 0.104570>, <1.407161, 0.386517, 0.712205>, <1.205418, 0.000000, 1.066741>, 
      <1.800760, 1.167662, -0.400463>, <1.951156, 0.718408, -0.098234>, <1.539367, 0.386517, 0.514178>, <1.337625, 0.000000, 0.868714>, 
      <1.513638, 1.139103, -0.253815>, <1.594919, 0.739966, -0.194662>, <1.199848, 0.352635, 0.489912>, <1.083911, 0.000000, 0.667741>, 
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.783199, 1.603298, -0.482420>, <0.816377, 1.834805, -0.623440>, <0.478357, 2.171840, -0.394332>, 
      <2.080181, 1.195456, 0.056011>, <1.938478, 1.618744, -0.228749>, <1.075207, 1.935728, -0.730773>, <0.737188, 2.272763, -0.501665>, 
      <1.974128, 1.184907, 0.384530>, <2.085151, 1.579234, 0.179796>, <1.256151, 1.991230, -0.315348>, <1.020113, 2.383082, -0.337147>, 
      <1.726240, 1.160250, 0.547756>, <1.837264, 1.554577, 0.343022>, <1.363502, 2.033089, -0.040716>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.080181, 1.195456, 0.056011>, <1.974128, 1.184907, 0.384530>, <1.726240, 1.160250, 0.547756>, 
      <2.075298, 0.730756, 0.104570>, <2.230577, 0.746201, 0.358241>, <1.839840, 0.707952, 0.632165>, <1.591953, 0.683295, 0.795391>, 
      <1.407161, 0.386517, 0.712205>, <1.241794, 0.386517, 0.959900>, <1.056073, 0.380657, 1.172978>, <0.803756, 0.380657, 1.014753>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.203692, -0.044900, 0.570272>, <-0.461732, -0.044900, 0.481451>, <-0.765596, -0.033808, 0.611667>, <-0.847011, -0.033808, 0.872139>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.100977, -0.039005, 1.150867>, <-0.034548, -0.039005, 0.938339>, <0.006853, -0.044900, 0.642744>, <-0.203692, -0.044900, 0.570272>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.532826, -0.031427, 1.593172>, <-0.307686, -0.031427, 1.670667>, <-0.172011, -0.039005, 1.378128>, <-0.100977, -0.039005, 1.150867>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.532826, -0.031427, 1.593172>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.814433, -0.031427, 1.496239>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.935861, -0.033808, 1.156400>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.847011, -0.033808, 0.872139>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>, 
      <-1.135645, 4.923207, 0.490812>, <-1.083543, 4.894404, 0.490812>, <-1.016672, 4.849124, 0.499265>, <-0.961974, 4.827198, 0.490812>, 
      <-1.278876, 4.664117, 0.629223>, <-1.226775, 4.635314, 0.629223>, <-1.152234, 4.584241, 0.661968>, <-1.105205, 4.568108, 0.629223>, 
      <-1.318257, 4.592882, 0.889701>, <-1.266155, 4.564079, 0.889701>, <-1.191614, 4.513006, 0.922445>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>, 
      <-0.925682, 5.303006, 0.933545>, <-0.873581, 5.274203, 0.933545>, <-0.794448, 5.245746, 0.949092>, <-0.752011, 5.206996, 0.933545>, 
      <-0.908930, 5.333309, 0.652070>, <-0.856829, 5.304506, 0.652070>, <-0.789958, 5.259225, 0.660524>, <-0.735259, 5.237299, 0.652071>, 
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.111808, 4.843276, 1.592358>, <-1.020927, 4.813514, 1.627003>, <-0.990239, 4.776070, 1.592358>, 
      <-1.054981, 5.069119, 1.669837>, <-1.002880, 5.040316, 1.669837>, <-0.911999, 5.010554, 1.704482>, <-0.881310, 4.973110, 1.669837>, 
      <-0.992174, 5.182731, 1.373344>, <-0.940072, 5.153928, 1.373344>, <-0.860939, 5.125471, 1.388891>, <-0.818503, 5.086722, 1.373344>, 
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.300159, 4.625618, 1.495446>, <-1.361234, 4.515141, 1.173969>, <-1.318257, 4.592882, 0.889701>, 
      <-1.111808, 4.843276, 1.592358>, <-1.248058, 4.596816, 1.495446>, <-1.309132, 4.486338, 1.173969>, <-1.266155, 4.564079, 0.889701>, 
      <-1.020927, 4.813514, 1.627003>, <-1.157177, 4.567053, 1.530091>, <-1.234591, 4.435265, 1.206713>, <-1.191614, 4.513006, 0.922445>, 
      <-0.990239, 4.776070, 1.592358>, <-1.126488, 4.529609, 1.495446>, <-1.187563, 4.419132, 1.173969>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>, 
      <0.045326, 4.803767, 0.387696>, <0.001795, 4.757308, 0.122328>, <-0.247041, 4.434546, 0.099814>, <-0.427165, 4.242303, 0.171033>, 
      <-0.473949, 4.907449, 0.523488>, <-0.598796, 4.681614, 0.434686>, <-0.757509, 4.448831, 0.387136>, <-0.796890, 4.377596, 0.647614>, 
      <-0.837127, 5.053032, 0.579614>, <-0.961974, 4.827198, 0.490812>, <-1.105205, 4.568108, 0.629223>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>, 
      <-0.149898, 4.541390, 0.922230>, <-0.002929, 4.698247, 0.864120>, <0.080844, 4.841674, 0.604220>, <0.045326, 4.803767, 0.387696>, 
      <-0.508679, 4.897343, 1.045159>, <-0.476547, 4.955466, 0.832626>, <-0.372082, 5.091715, 0.595944>, <-0.473949, 4.907449, 0.523488>, 
      <-0.784143, 5.148873, 1.146078>, <-0.752011, 5.206996, 0.933545>, <-0.735259, 5.237299, 0.652071>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>, 
      <-0.581819, 4.032846, 0.952694>, <-0.543838, 4.073382, 1.184228>, <-0.307056, 4.373660, 0.984368>, <-0.149898, 4.541390, 0.922230>, 
      <-0.759944, 4.495076, 1.332377>, <-0.651016, 4.692116, 1.409856>, <-0.543038, 4.835191, 1.272425>, <-0.508679, 4.897343, 1.045159>, 
      <-0.990239, 4.776070, 1.592358>, <-0.881310, 4.973110, 1.669837>, <-0.818503, 5.086722, 1.373344>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.581819, 4.032846, 0.952694>, <-0.759944, 4.495076, 1.332377>, <-0.990239, 4.776070, 1.592358>, 
      <-0.369421, 3.794017, 0.352218>, <-0.629325, 3.982144, 0.663089>, <-0.896194, 4.248615, 1.235465>, <-1.126488, 4.529609, 1.495446>, 
      <-0.230350, 3.942443, 0.073090>, <-0.623741, 4.032504, 0.248756>, <-0.839867, 4.299855, 0.931882>, <-1.187563, 4.419132, 1.173969>, 
      <-0.033775, 4.152243, -0.004633>, <-0.427165, 4.242303, 0.171033>, <-0.796890, 4.377596, 0.647614>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>, 
      <1.025779, 4.093207, 0.381884>, <1.226493, 4.236390, 0.264894>, <1.126390, 4.232918, -0.129444>, <1.025457, 4.160915, -0.372554>, 
      <0.661213, 4.412504, 0.345586>, <0.617682, 4.366044, 0.080217>, <0.525790, 4.257618, -0.245289>, <0.345665, 4.065375, -0.174070>, 
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>, 
      <0.543731, 3.789628, 0.194518>, <0.626086, 3.848378, 0.392879>, <0.862010, 3.976379, 0.477340>, <1.025779, 4.093207, 0.381884>, 
      <0.319543, 4.046286, 0.610188>, <0.466513, 4.203143, 0.552078>, <0.696731, 4.450411, 0.562110>, <0.661213, 4.412504, 0.345586>, 
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>, 
      <0.327542, 3.702958, -0.411287>, <0.152420, 3.578032, -0.309213>, <0.455668, 3.726806, -0.017594>, <0.543731, 3.789628, 0.194518>, 
      <-0.040928, 3.641333, 0.305736>, <-0.002948, 3.681868, 0.537269>, <0.162385, 3.878556, 0.672326>, <0.319543, 4.046286, 0.610188>, 
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.327542, 3.702958, -0.411287>, <-0.040928, 3.641333, 0.305736>, <-0.321914, 3.844720, 0.641823>, 
      <0.979516, 3.665112, -0.629340>, <0.546587, 3.859218, -0.538961>, <-0.088435, 3.590630, 0.016131>, <-0.369421, 3.794017, 0.352218>, 
      <1.235997, 3.848078, -0.487834>, <0.915305, 4.082336, -0.637866>, <0.149090, 3.855576, -0.096347>, <-0.230350, 3.942443, 0.073090>, 
      <1.346149, 3.926657, -0.222522>, <1.025457, 4.160915, -0.372554>, <0.345665, 4.065375, -0.174070>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>, 
      <1.296997, 2.879843, 0.733703>, <1.445934, 2.937916, 0.954880>, <1.774379, 3.091461, 0.797898>, <1.976107, 3.170119, 0.631788>, 
      <1.307648, 3.418247, 0.518613>, <1.508362, 3.561430, 0.401624>, <1.841102, 3.710837, 0.204924>, <1.740168, 3.638834, -0.038185>, 
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>, 
      <1.385444, 2.888728, 0.148511>, <1.220847, 2.824548, 0.284046>, <1.175475, 2.832459, 0.553237>, <1.296997, 2.879843, 0.733703>, 
      <0.987091, 3.240061, 0.036852>, <1.069446, 3.298811, 0.235213>, <1.143879, 3.301419, 0.614069>, <1.307648, 3.418247, 0.518613>, 
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>, 
      <1.906742, 3.131796, -0.157567>, <1.776795, 3.081127, -0.350543>, <1.561452, 2.957357, 0.003581>, <1.385444, 2.888728, 0.148511>, 
      <1.194126, 3.314419, -0.592195>, <1.019004, 3.189493, -0.490122>, <0.899027, 3.177239, -0.175260>, <0.987091, 3.240061, 0.036852>, 
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.906742, 3.131796, -0.157567>, <1.194126, 3.314419, -0.592195>, <0.760471, 3.508852, -0.501665>, 
      <2.208483, 2.846450, 0.388885>, <2.069281, 3.195173, 0.083810>, <1.413171, 3.470679, -0.719869>, <0.979516, 3.665112, -0.629340>, 
      <2.132199, 2.816706, 0.724413>, <2.196260, 3.255960, 0.450507>, <1.630017, 3.560256, -0.303498>, <1.235997, 3.848078, -0.487834>, 
      <1.912047, 2.730864, 0.905694>, <1.976107, 3.170119, 0.631788>, <1.740168, 3.638834, -0.038185>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.727308, 1.060887, 1.042327>, <0.729459, 1.061101, 1.369123>, <0.931165, 1.081165, 1.551842>, 
      <1.130039, 1.453072, 0.877157>, <0.942531, 1.434421, 1.074558>, <1.157661, 1.492077, 1.371658>, <1.359367, 1.512140, 1.554376>, 
      <1.224179, 2.051219, 0.856463>, <1.373116, 2.109292, 1.077641>, <1.635704, 2.140586, 1.390835>, <1.837433, 2.219244, 1.224725>, 
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>, 
      <0.727308, 1.060887, 1.042327>, <0.495765, 0.659030, 1.007652>, <-0.127188, 0.350771, 0.563600>, <-0.423769, 0.000000, 0.490773>, 
      <0.729459, 1.061101, 1.369123>, <0.275535, 0.604236, 1.366437>, <-0.224661, 0.365743, 0.818438>, <-0.719824, 0.000000, 0.629163>, 
      <0.931165, 1.081165, 1.551842>, <0.477241, 0.624300, 1.549155>, <-0.306076, 0.365743, 1.078910>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.307934, 1.118641, 0.832847>, <1.067810, 1.094756, 0.683860>, <0.914816, 1.079538, 0.844926>, 
      <1.709058, 1.529154, 0.846782>, <1.544479, 1.512783, 0.697696>, <1.283033, 1.468290, 0.716091>, <1.130039, 1.453072, 0.877157>, 
      <1.610751, 2.129575, 0.425166>, <1.446154, 2.065395, 0.560700>, <1.102656, 2.003834, 0.675998>, <1.224179, 2.051219, 0.856463>, 
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>, 
      <1.307934, 1.118641, 0.832847>, <1.024882, 0.647009, 0.994571>, <0.440830, 0.375638, 0.887301>, <0.010170, 0.000000, 0.933538>, 
      <1.067810, 1.094756, 0.683860>, <0.836267, 0.692899, 0.649185>, <0.341396, 0.350771, 0.724892>, <0.044816, 0.000000, 0.652066>, 
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.862654, 1.173819, 1.383110>, <1.648500, 1.152517, 1.141355>, <1.472513, 1.135012, 0.981934>, 
      <2.109209, 1.609047, 1.320949>, <2.272809, 1.625320, 1.148717>, <1.885046, 1.546659, 1.006204>, <1.709058, 1.529154, 0.846782>, 
      <2.233965, 2.312047, 0.559578>, <2.104018, 2.261378, 0.366603>, <1.786758, 2.198203, 0.280236>, <1.610751, 2.129575, 0.425166>, 
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.234013, 0.645627, 1.821099>, <0.146906, 0.391119, 1.581650>, <-0.482271, 0.000000, 1.592315>, 
      <1.862654, 1.173819, 1.383110>, <1.397613, 0.661900, 1.648868>, <0.372045, 0.391119, 1.659146>, <-0.257132, 0.000000, 1.669811>, 
      <1.648500, 1.152517, 1.141355>, <1.365448, 0.680885, 1.303079>, <0.303367, 0.375638, 1.327090>, <-0.127293, 0.000000, 1.373327>, 
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <2.109209, 1.609047, 1.320949>, <2.233965, 2.312047, 0.559578>, <2.045943, 2.783073, 0.147508>, 
      <1.494421, 1.137191, 1.770770>, <1.904576, 1.588692, 1.536377>, <2.396504, 2.375424, 0.800956>, <2.208483, 2.846450, 0.388885>, 
      <1.151293, 1.103061, 1.751248>, <1.579494, 1.534036, 1.753783>, <2.057585, 2.305086, 1.043444>, <2.132199, 2.816706, 0.724413>, 
      <0.931165, 1.081165, 1.551842>, <1.359367, 1.512140, 1.554376>, <1.837433, 2.219244, 1.224725>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.494421, 1.137191, 1.770770>, <1.151293, 1.103061, 1.751248>, <0.931165, 1.081165, 1.551842>, 
      <1.234013, 0.645627, 1.821099>, <1.029380, 0.625272, 2.036528>, <0.697369, 0.646196, 1.748562>, <0.477241, 0.624300, 1.549155>, 
      <0.146906, 0.391119, 1.581650>, <-0.134701, 0.391119, 1.484718>, <-0.394926, 0.365743, 1.363171>, <-0.306076, 0.365743, 1.078910>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.492124, -0.059010, 0.000093>, <0.492124, -0.059010, -0.272806>, <0.272471, -0.050458, -0.539386>, <-0.000317, -0.050458, -0.531592>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <-0.029004, -0.050709, 0.276410>, <0.193573, -0.050709, 0.270050>, <0.492124, -0.059010, 0.222761>, <0.492124, -0.059010, 0.000093>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.588494, -0.041496, -0.002015>, <-0.588494, -0.041496, 0.236088>, <-0.267011, -0.050709, 0.283210>, <-0.029004, -0.050709, 0.276410>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.588494, -0.041496, -0.002015>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.588494, -0.041496, -0.299839>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.298019, -0.050458, -0.523086>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <-0.000317, -0.050458, -0.531592>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>, 
      <-0.688738, 5.731613, -0.272928>, <-0.636637, 5.702810, -0.272928>, <-0.568524, 5.652551, -0.292911>, <-0.515067, 5.635604, -0.272929>, 
      <-0.798675, 5.532749, -0.507806>, <-0.746574, 5.503946, -0.507806>, <-0.683223, 5.435931, -0.520220>, <-0.625004, 5.436739, -0.507806>, 
      <-0.930654, 5.294014, -0.499992>, <-0.878553, 5.265211, -0.499992>, <-0.815202, 5.197196, -0.512406>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>, 
      <-0.822940, 5.488857, 0.281511>, <-0.770839, 5.460054, 0.281511>, <-0.706292, 5.409803, 0.279281>, <-0.649269, 5.392847, 0.281511>, 
      <-0.688721, 5.731645, 0.222639>, <-0.636619, 5.702842, 0.222639>, <-0.568507, 5.652583, 0.202657>, <-0.515049, 5.635636, 0.222639>, 
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.149764, 4.774619, 0.030352>, <-1.086901, 4.708347, 0.040188>, <-1.028194, 4.707412, 0.030352>, 
      <-1.201857, 4.803437, 0.268456>, <-1.149755, 4.774634, 0.268456>, <-1.086893, 4.708363, 0.278291>, <-1.028186, 4.707428, 0.268456>, 
      <-1.045777, 5.085768, 0.294705>, <-0.993676, 5.056965, 0.294705>, <-0.929129, 5.006715, 0.292475>, <-0.872106, 4.989758, 0.294705>, 
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.201876, 4.803403, -0.267471>, <-1.074687, 5.033474, -0.491465>, <-0.930654, 5.294014, -0.499992>, 
      <-1.149764, 4.774619, 0.030352>, <-1.149774, 4.774600, -0.267471>, <-1.022585, 5.004672, -0.491465>, <-0.878553, 5.265211, -0.499992>, 
      <-1.086901, 4.708347, 0.040188>, <-1.086912, 4.708328, -0.257636>, <-0.959234, 4.936656, -0.503879>, <-0.815202, 5.197196, -0.512406>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028205, 4.707393, -0.267471>, <-0.901015, 4.937464, -0.491464>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>, 
      <0.673433, 5.542398, 0.382051>, <0.830828, 5.710382, 0.235482>, <0.742311, 5.615008, -0.169149>, <0.637642, 5.503297, -0.395068>, 
      <-0.070189, 5.494588, 0.166260>, <-0.070199, 5.494571, -0.106640>, <-0.075813, 5.444359, -0.390701>, <-0.207791, 5.205623, -0.382888>, 
      <-0.515057, 5.635621, -0.000029>, <-0.515067, 5.635604, -0.272929>, <-0.625004, 5.436739, -0.507806>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>, 
      <0.264924, 5.071978, 0.264958>, <0.350327, 5.163126, 0.449294>, <0.545009, 5.405335, 0.501642>, <0.673433, 5.542398, 0.382051>, 
      <-0.350982, 5.077334, 0.303765>, <-0.243295, 5.272127, 0.297389>, <-0.070181, 5.494603, 0.388928>, <-0.070189, 5.494588, 0.166260>, 
      <-0.756955, 5.198054, 0.287887>, <-0.649269, 5.392847, 0.281511>, <-0.515049, 5.635636, 0.222639>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>, 
      <0.085454, 4.866228, -0.353558>, <-0.051873, 4.719663, -0.225676>, <0.173601, 4.974511, 0.067845>, <0.264924, 5.071978, 0.264958>, 
      <-0.552806, 4.699840, -0.049293>, <-0.552798, 4.699856, 0.188811>, <-0.466133, 4.869038, 0.310582>, <-0.350982, 5.077334, 0.303765>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028186, 4.707428, 0.268456>, <-0.872106, 4.989758, 0.294705>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.085454, 4.866228, -0.353558>, <-0.552806, 4.699840, -0.049293>, <-1.028194, 4.707412, 0.030352>, 
      <0.721979, 4.958841, -0.423140>, <0.257223, 5.049553, -0.513513>, <-0.552817, 4.699822, -0.347116>, <-1.028205, 4.707393, -0.267471>, 
      <0.947700, 5.199747, -0.321664>, <0.523414, 5.381385, -0.641620>, <-0.351824, 4.945084, -0.374360>, <-0.901015, 4.937464, -0.491464>, 
      <1.061928, 5.321660, -0.075112>, <0.637642, 5.503297, -0.395068>, <-0.207791, 5.205623, -0.382888>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>, 
      <1.176418, 4.228400, 1.281084>, <1.331799, 4.339244, 1.476134>, <1.598674, 4.553109, 1.259562>, <1.752959, 4.663172, 1.063204>, 
      <1.237274, 4.881539, 0.845362>, <1.394669, 5.049523, 0.698793>, <1.602658, 5.246691, 0.479642>, <1.497990, 5.134981, 0.253723>, 
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>, 
      <1.168489, 4.198111, 0.682275>, <1.042602, 4.108307, 0.842491>, <1.049638, 4.137958, 1.121936>, <1.176418, 4.228400, 1.281084>, 
      <0.909517, 4.629264, 0.421284>, <0.994920, 4.720412, 0.605619>, <1.108851, 4.744476, 0.964953>, <1.237274, 4.881539, 0.845362>, 
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>, 
      <1.584124, 4.531858, 0.291211>, <1.448555, 4.435146, 0.121030>, <1.303102, 4.294140, 0.510954>, <1.168489, 4.198111, 0.682275>, 
      <0.993460, 4.689001, -0.176992>, <0.856133, 4.542436, -0.049111>, <0.818194, 4.531798, 0.224171>, <0.909517, 4.629264, 0.421284>, 
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.584124, 4.531858, 0.291211>, <0.993460, 4.689001, -0.176992>, <0.550210, 4.775516, -0.263184>, 
      <1.864985, 4.296779, 0.772832>, <1.753695, 4.652825, 0.504075>, <1.165229, 4.872326, -0.336948>, <0.721979, 4.958841, -0.423140>, 
      <1.839537, 4.278626, 1.116789>, <1.921335, 4.783286, 0.848912>, <1.383762, 5.013069, 0.007171>, <0.947700, 5.199747, -0.321664>, 
      <1.671161, 4.158511, 1.331080>, <1.752959, 4.663172, 1.063204>, <1.497990, 5.134981, 0.253723>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>, 
      <0.518744, 2.630839, 1.116586>, <0.372372, 2.573766, 1.339727>, <0.646578, 2.695348, 1.627582>, <0.858569, 2.778007, 1.778251>, 
      <1.007584, 3.225212, 1.369456>, <1.162965, 3.336056, 1.564507>, <1.420558, 3.454205, 1.842865>, <1.574843, 3.564268, 1.646507>, 
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>, 
      <1.058881, 2.809064, 0.967556>, <0.885910, 2.741619, 0.844621>, <0.638173, 2.677407, 0.934517>, <0.518744, 2.630839, 1.116586>, 
      <1.287745, 3.405068, 0.871225>, <1.161858, 3.315264, 1.031441>, <0.880804, 3.134771, 1.210308>, <1.007584, 3.225212, 1.369456>, 
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>, 
      <1.511433, 3.014108, 1.399758>, <1.639141, 3.063904, 1.205068>, <1.243843, 2.881184, 1.099014>, <1.058881, 2.809064, 0.967556>, 
      <1.838591, 3.717745, 0.905735>, <1.703022, 3.621034, 0.735555>, <1.422358, 3.501097, 0.699904>, <1.287745, 3.405068, 0.871225>, 
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.511433, 3.014108, 1.399758>, <1.838591, 3.717745, 0.905735>, <1.695413, 4.175812, 0.559968>, 
      <1.108081, 2.417382, 1.713333>, <1.351693, 2.951822, 1.643279>, <2.008162, 3.838712, 1.118599>, <1.864985, 4.296779, 0.772832>, 
      <0.787669, 2.292448, 1.745119>, <1.089922, 2.868216, 1.942679>, <1.743219, 3.684382, 1.432216>, <1.839537, 4.278626, 1.116789>, 
      <0.556317, 2.202239, 1.580690>, <0.858569, 2.778007, 1.778251>, <1.574843, 3.564268, 1.646507>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.420517, 1.030371, -0.115902>, <0.113731, 0.999855, -0.007496>, <0.007458, 0.989284, 0.243639>, 
      <0.656890, 1.452521, 0.160879>, <0.410125, 1.427975, 0.046953>, <0.215961, 1.404545, 0.374858>, <0.109689, 1.393974, 0.625992>, 
      <0.382882, 1.776536, 0.696127>, <0.236511, 1.719463, 0.919268>, <0.092582, 1.640028, 1.265476>, <0.304574, 1.722688, 1.416144>, 
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>, 
      <0.420517, 1.030371, -0.115902>, <0.428264, 0.733937, -0.237318>, <0.542391, 0.317613, -0.273400>, <0.500000, 0.000000, -0.272899>, 
      <0.113731, 0.999855, -0.007496>, <0.046675, 0.734409, -0.258291>, <0.274764, 0.314693, -0.310764>, <0.272788, 0.000000, -0.507794>, 
      <0.007458, 0.989284, 0.243639>, <-0.059597, 0.723838, -0.007156>, <0.001976, 0.314693, -0.302970>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.806595, 1.068774, 0.367641>, <0.868625, 1.074944, 0.090980>, <0.667281, 1.054916, -0.001976>, 
      <0.873382, 1.431312, 0.674253>, <0.960093, 1.439937, 0.469344>, <0.858233, 1.472548, 0.253834>, <0.656890, 1.452521, 0.160879>, 
      <0.905311, 1.960277, 0.907859>, <0.732340, 1.892832, 0.784924>, <0.502312, 1.823104, 0.514058>, <0.382882, 1.776536, 0.696127>, 
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>, 
      <0.806595, 1.068774, 0.367641>, <0.660698, 0.715990, 0.270974>, <0.414440, 0.335439, 0.357390>, <0.222577, 0.000000, 0.281520>, 
      <0.868625, 1.074944, 0.090980>, <0.876372, 0.778509, -0.030436>, <0.542391, 0.317613, 0.222167>, <0.500000, 0.000000, 0.222668>, 
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.469393, 1.035233, 1.073839>, <0.627162, 1.050926, 0.791664>, <0.719884, 1.060148, 0.572550>, 
      <0.552471, 1.418471, 1.209352>, <0.767772, 1.439887, 1.308751>, <0.780660, 1.422089, 0.893366>, <0.873382, 1.431312, 0.674253>, 
      <1.039269, 1.978267, 1.535535>, <1.166978, 2.028063, 1.340846>, <1.090273, 2.032397, 1.039317>, <0.905311, 1.960277, 0.907859>, 
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.005147, 0.662242, 0.770342>, <-0.334748, 0.336073, 0.292045>, <-0.560606, 0.000000, 0.030303>, 
      <0.469393, 1.035233, 1.073839>, <0.210153, 0.683658, 0.869742>, <-0.334748, 0.336073, 0.530148>, <-0.560606, 0.000000, 0.268407>, 
      <0.627162, 1.050926, 0.791664>, <0.481265, 0.698142, 0.694997>, <-0.046144, 0.335439, 0.370549>, <-0.238007, 0.000000, 0.294679>, 
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.552471, 1.418471, 1.209352>, <1.039269, 1.978267, 1.535535>, <1.267821, 2.479668, 1.469812>, 
      <-0.015209, 0.987030, 0.850110>, <0.283170, 1.391684, 1.085022>, <0.879530, 1.915981, 1.779056>, <1.108081, 2.417382, 1.713333>, 
      <-0.108520, 0.977748, 0.517710>, <-0.006289, 1.382438, 0.900063>, <0.535927, 1.812897, 1.580573>, <0.787669, 2.292448, 1.745119>, 
      <0.007458, 0.989284, 0.243639>, <0.109689, 1.393974, 0.625992>, <0.304574, 1.722688, 1.416144>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.015209, 0.987030, 0.850110>, <-0.108520, 0.977748, 0.517710>, <0.007458, 0.989284, 0.243639>, 
      <-0.005147, 0.662242, 0.770342>, <-0.274448, 0.635455, 0.646012>, <-0.175575, 0.712302, 0.266914>, <-0.059597, 0.723838, -0.007156>, 
      <-0.334748, 0.336073, 0.292045>, <-0.334748, 0.336073, -0.005778>, <-0.295726, 0.314693, -0.294464>, <0.001976, 0.314693, -0.302970>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.379391, -0.15447, -0.074957>
}
#declare segMcurvedMA4 = union {
  object { // Blatt63->Blatt14
    Blatt14
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <0.363186, -1.686824, -1.535598>
  }
  object { // Blatt64->Blatt14
    Blatt14
    rotate <-11.451855, -9.808147, -149.316727>
    translate  <0.806828, -1.041412, 1.867508>
  }
  object { Blatt65 }
  object { sPatchObj22 }
  translate  <0.729939, -0.024081, 23.76687>
}
#declare BezPtch023 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt68 = union {
  cone { // Cone023
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch023 }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-0.898673, 2.35502, 2.682482>
}
#declare sPatchObj23 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.340629, -0.048589, 0.507365>, <0.189102, -0.048589, 0.734332>, <0.231778, -0.052353, 1.073207>, <0.462979, -0.052353, 1.218190>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.919612, -0.041919, 0.560905>, <0.730967, -0.041919, 0.442608>, <0.464265, -0.048589, 0.322176>, <0.340629, -0.048589, 0.507365>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.233336, -0.039157, 1.101834>, <1.365543, -0.039157, 0.903807>, <1.121334, -0.041919, 0.687401>, <0.919612, -0.041919, 0.560905>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.233336, -0.039157, 1.101834>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.067970, -0.039157, 1.349529>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.715296, -0.052353, 1.376415>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.462979, -0.052353, 1.218190>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.927710, 5.273737, 0.503044>, <1.873548, 5.248850, 0.503044>, <1.806484, 5.195710, 0.506258>, <1.747169, 5.190782, 0.503044>, 
      <1.857771, 5.408004, 0.730086>, <1.803609, 5.383118, 0.730086>, <1.736545, 5.329978, 0.733299>, <1.677230, 5.325050, 0.730086>, 
      <1.884717, 5.356273, 1.051407>, <1.830555, 5.331386, 1.051407>, <1.759441, 5.288747, 1.067554>, <1.704177, 5.273318, 1.051407>, 
      <1.991485, 5.151303, 1.196511>, <1.937323, 5.126416, 1.196511>, <1.866209, 5.083778, 1.212658>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.193337, 4.763793, 0.541244>, <2.139175, 4.738906, 0.541244>, <2.070209, 4.678722, 0.557129>, <2.012797, 4.680837, 0.541244>, 
      <2.106324, 4.930838, 0.422988>, <2.052162, 4.905951, 0.422988>, <1.983195, 4.845766, 0.438872>, <1.925784, 4.847882, 0.422988>, 
      <1.984709, 5.164313, 0.318011>, <1.930546, 5.139426, 0.318011>, <1.863483, 5.086286, 0.321225>, <1.804168, 5.081358, 0.318011>, 
      <1.927710, 5.273737, 0.503044>, <1.873548, 5.248850, 0.503044>, <1.806484, 5.195710, 0.506258>, <1.747169, 5.190782, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.342479, 4.477476, 1.066741>, <2.288317, 4.452589, 1.066741>, <2.213522, 4.395900, 1.096576>, <2.161939, 4.394520, 1.066741>, 
      <2.403483, 4.360362, 0.868706>, <2.349321, 4.335476, 0.868706>, <2.274526, 4.278786, 0.898541>, <2.222943, 4.277406, 0.868706>, 
      <2.286464, 4.585010, 0.667810>, <2.232302, 4.560124, 0.667810>, <2.163336, 4.499938, 0.683694>, <2.105925, 4.502054, 0.667810>, 
      <2.193337, 4.763793, 0.541244>, <2.139175, 4.738906, 0.541244>, <2.070209, 4.678722, 0.557129>, <2.012797, 4.680837, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.342479, 4.477476, 1.066741>, <2.266240, 4.623838, 1.314234>, <2.107870, 4.927870, 1.354686>, <1.991485, 5.151303, 1.196511>, 
      <2.288317, 4.452589, 1.066741>, <2.212078, 4.598951, 1.314234>, <2.053708, 4.902983, 1.354686>, <1.937323, 5.126416, 1.196511>, 
      <2.213522, 4.395900, 1.096576>, <2.137283, 4.542262, 1.344069>, <1.982594, 4.860344, 1.370832>, <1.866209, 5.083778, 1.212658>, 
      <2.161939, 4.394520, 1.066741>, <2.085700, 4.540882, 1.314234>, <1.927330, 4.844914, 1.354686>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.242778, 5.093405, 0.385449>, <-0.173443, 5.029640, 0.641281>, <0.043064, 4.830526, 0.783311>, <0.229252, 4.659296, 0.681636>, 
      <0.261106, 5.414866, 0.350063>, <0.330441, 5.351100, 0.605895>, <0.513663, 5.036670, 0.772500>, <0.699851, 4.865440, 0.670825>, 
      <1.151354, 5.141280, 0.470763>, <1.081415, 5.275547, 0.697805>, <1.227729, 5.140296, 0.912202>, <1.334497, 4.935326, 1.057306>, 
      <1.747169, 5.190782, 0.503044>, <1.677230, 5.325050, 0.730086>, <1.704177, 5.273318, 1.051407>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.028904, 4.843549, -0.057609>, <-0.123091, 4.983332, 0.025393>, <-0.299380, 5.145459, 0.176600>, <-0.242778, 5.093405, 0.385449>, 
      <0.570190, 5.125650, -0.185329>, <0.418196, 5.265433, -0.102327>, <0.204504, 5.466920, 0.141214>, <0.261106, 5.414866, 0.350063>, 
      <1.412151, 4.702970, 0.375058>, <1.325137, 4.870015, 0.256802>, <1.208353, 5.031855, 0.285730>, <1.151354, 5.141280, 0.470763>, 
      <2.012797, 4.680837, 0.541244>, <1.925784, 4.847882, 0.422988>, <1.804168, 5.081358, 0.318011>, <1.747169, 5.190782, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481092, 4.427689, -0.009847>, <0.420610, 4.483312, -0.233013>, <0.191318, 4.694183, -0.146301>, <0.028904, 4.843549, -0.057609>, 
      <1.034920, 4.613283, -0.142190>, <0.974438, 4.668905, -0.365355>, <0.732604, 4.976284, -0.274022>, <0.570190, 5.125650, -0.185329>, 
      <1.643644, 4.380657, 0.766970>, <1.704648, 4.263543, 0.568935>, <1.505278, 4.524187, 0.501624>, <1.412151, 4.702970, 0.375058>, 
      <2.161939, 4.394520, 1.066741>, <2.222943, 4.277406, 0.868706>, <2.105925, 4.502054, 0.667810>, <2.012797, 4.680837, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481092, 4.427689, -0.009847>, <1.034920, 4.613283, -0.142190>, <1.643644, 4.380657, 0.766970>, <2.161939, 4.394520, 1.066741>, 
      <0.556818, 4.358047, 0.269566>, <1.110646, 4.543641, 0.137223>, <1.567404, 4.527019, 1.014463>, <2.085700, 4.540882, 1.314234>, 
      <0.432601, 4.472283, 0.570590>, <0.903201, 4.678427, 0.559779>, <1.450882, 4.711893, 1.215481>, <1.927330, 4.844914, 1.354686>, 
      <0.229252, 4.659296, 0.681636>, <0.699851, 4.865440, 0.670825>, <1.334497, 4.935326, 1.057306>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.745773, 3.600371, 0.678117>, <-0.978217, 3.733614, 0.729427>, <-1.140940, 3.826891, 0.996770>, <-1.089917, 3.797643, 1.263149>, 
      <-0.659245, 4.070709, 0.629152>, <-0.891689, 4.203952, 0.680462>, <-0.885404, 4.246575, 0.885237>, <-0.834381, 4.217327, 1.151616>, 
      <-0.647350, 4.835302, 0.413861>, <-0.578015, 4.771537, 0.669694>, <-0.418355, 4.628405, 0.793910>, <-0.232167, 4.457174, 0.692236>, 
      <-0.242778, 5.093405, 0.385449>, <-0.173443, 5.029640, 0.641281>, <0.043064, 4.830526, 0.783311>, <0.229252, 4.659296, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419372, 3.413269, 1.115132>, <-0.460998, 3.437130, 0.897814>, <-0.556140, 3.491668, 0.636257>, <-0.745773, 3.600371, 0.678117>, 
      <-0.338335, 3.930586, 0.887549>, <-0.379961, 3.954447, 0.670231>, <-0.469612, 3.962006, 0.587292>, <-0.659245, 4.070709, 0.629152>, 
      <-0.466672, 4.585270, 0.059326>, <-0.618667, 4.725054, 0.142328>, <-0.703951, 4.887356, 0.205012>, <-0.647350, 4.835302, 0.413861>, 
      <0.028904, 4.843549, -0.057609>, <-0.123091, 4.983332, 0.025393>, <-0.299380, 5.145459, 0.176600>, <-0.242778, 5.093405, 0.385449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.547328, 3.486617, 1.714146>, <-0.344458, 3.370326, 1.669364>, <-0.374840, 3.387742, 1.347620>, <-0.419372, 3.413269, 1.115132>, 
      <-0.323254, 3.978559, 1.326626>, <-0.120383, 3.862268, 1.281845>, <-0.293804, 3.905059, 1.120037>, <-0.338335, 3.930586, 0.887549>, 
      <-0.133971, 4.221575, 0.137128>, <-0.194453, 4.277198, -0.086037>, <-0.304258, 4.435904, -0.029366>, <-0.466672, 4.585270, 0.059326>, 
      <0.481092, 4.427689, -0.009847>, <0.420610, 4.483312, -0.233013>, <0.191318, 4.694183, -0.146301>, <0.028904, 4.843549, -0.057609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.547328, 3.486617, 1.714146>, <-0.323254, 3.978559, 1.326626>, <-0.133971, 4.221575, 0.137128>, <0.481092, 4.427689, -0.009847>, 
      <-0.800894, 3.631968, 1.770118>, <-0.576819, 4.123910, 1.382599>, <-0.058246, 4.151933, 0.416541>, <0.556818, 4.358047, 0.269566>, 
      <-1.034257, 3.765737, 1.553734>, <-0.778721, 4.185422, 1.442201>, <-0.028817, 4.270162, 0.581189>, <0.432601, 4.472283, 0.570590>, 
      <-1.089917, 3.797643, 1.263149>, <-0.834381, 4.217327, 1.151616>, <-0.232167, 4.457174, 0.692236>, <0.229252, 4.659296, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750394, 2.334157, 0.672703>, <-1.003252, 2.418574, 0.730646>, <-1.174829, 2.475855, 1.002549>, <-1.112804, 2.455148, 1.267398>, 
      <-0.769198, 2.710940, 0.717229>, <-1.022056, 2.795356, 0.775172>, <-1.321620, 2.842865, 1.080080>, <-1.259595, 2.822158, 1.344929>, 
      <-0.814147, 3.228713, 0.716809>, <-1.046590, 3.361956, 0.768119>, <-1.345228, 3.491374, 1.085935>, <-1.294205, 3.462127, 1.352314>, 
      <-0.745773, 3.600371, 0.678117>, <-0.978217, 3.733614, 0.729427>, <-1.140940, 3.826891, 0.996770>, <-1.089917, 3.797643, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.383381, 2.211630, 1.100248>, <-0.433979, 2.228522, 0.884191>, <-0.544119, 2.265292, 0.625434>, <-0.750394, 2.334157, 0.672703>, 
      <-0.405656, 2.533325, 1.261825>, <-0.456254, 2.550217, 1.045768>, <-0.562923, 2.642075, 0.669960>, <-0.769198, 2.710940, 0.717229>, 
      <-0.470565, 3.086466, 1.258902>, <-0.512191, 3.110327, 1.041584>, <-0.624513, 3.120011, 0.674949>, <-0.814147, 3.228713, 0.716809>, 
      <-0.419372, 3.413269, 1.115132>, <-0.460998, 3.437130, 0.897814>, <-0.556140, 3.491668, 0.636257>, <-0.745773, 3.600371, 0.678117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.509171, 2.253626, 1.702737>, <-0.288487, 2.179951, 1.652167>, <-0.329248, 2.193558, 1.331397>, <-0.383381, 2.211630, 1.100248>, 
      <-0.614355, 2.545119, 1.905061>, <-0.393671, 2.471444, 1.854490>, <-0.351524, 2.515253, 1.492974>, <-0.405656, 2.533325, 1.261825>, 
      <-0.672009, 3.212889, 1.929771>, <-0.469138, 3.096598, 1.884989>, <-0.426034, 3.060939, 1.491390>, <-0.470565, 3.086466, 1.258902>, 
      <-0.547328, 3.486617, 1.714146>, <-0.344458, 3.370326, 1.669364>, <-0.374840, 3.387742, 1.347620>, <-0.419372, 3.413269, 1.115132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.509171, 2.253626, 1.702737>, <-0.614355, 2.545119, 1.905061>, <-0.672009, 3.212889, 1.929771>, <-0.547328, 3.486617, 1.714146>, 
      <-0.784990, 2.345708, 1.765942>, <-0.890174, 2.637202, 1.968266>, <-0.925574, 3.358240, 1.985744>, <-0.800894, 3.631968, 1.770118>, 
      <-1.045147, 2.432561, 1.556297>, <-1.191938, 2.799572, 1.633827>, <-1.238546, 3.430221, 1.642898>, <-1.034257, 3.765737, 1.553734>, 
      <-1.112804, 2.455148, 1.267398>, <-1.259595, 2.822158, 1.344929>, <-1.294205, 3.462127, 1.352314>, <-1.089917, 3.797643, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.622173, 1.123786, 0.385449>, <-0.529479, 1.112239, 0.640395>, <-0.238747, 1.076023, 0.783329>, <0.011080, 1.044903, 0.681636>, 
      <-0.776587, 1.464810, 0.410237>, <-0.683893, 1.453264, 0.665183>, <-0.543365, 1.556197, 0.797193>, <-0.293538, 1.525078, 0.695500>, 
      <-0.731822, 1.962032, 0.628727>, <-0.984680, 2.046448, 0.686671>, <-0.967542, 1.957590, 0.893066>, <-0.905517, 1.936884, 1.157915>, 
      <-0.750394, 2.334157, 0.672703>, <-1.003252, 2.418574, 0.730646>, <-1.174829, 2.475855, 1.002549>, <-1.112804, 2.455148, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.622173, 1.123786, 0.385449>, <-0.441582, 0.724949, 0.356459>, <0.054978, 0.358114, 0.471194>, <0.306502, 0.000000, 0.503044>, 
      <-0.529479, 1.112239, 0.640395>, <-0.348887, 0.713402, 0.611406>, <-0.096549, 0.358114, 0.698161>, <0.154975, 0.000000, 0.730010>, 
      <-0.238747, 1.076023, 0.783329>, <-0.039053, 0.761243, 0.774240>, <0.099152, 0.327914, 0.915737>, <0.213519, 0.000000, 1.051528>, 
      <0.011080, 1.044903, 0.681636>, <0.210774, 0.730123, 0.672547>, <0.330354, 0.327914, 1.060720>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.257697, 1.078384, -0.057609>, <-0.462060, 1.103841, 0.025578>, <-0.697999, 1.133231, 0.176898>, <-0.622173, 1.123786, 0.385449>, 
      <-0.494200, 1.491681, 0.046855>, <-0.698563, 1.517138, 0.130041>, <-0.852413, 1.474256, 0.201685>, <-0.776587, 1.464810, 0.410237>, 
      <-0.353273, 1.776820, 0.881856>, <-0.403872, 1.793712, 0.665799>, <-0.525547, 1.893167, 0.581459>, <-0.731822, 1.962032, 0.628727>, 
      <-0.383381, 2.211630, 1.100248>, <-0.433979, 2.228522, 0.884191>, <-0.544119, 2.265292, 0.625434>, <-0.750394, 2.334157, 0.672703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.257697, 1.078384, -0.057609>, <-0.013258, 0.651218, -0.165578>, <0.565457, 0.354783, 0.374845>, <0.882189, 0.000000, 0.541244>, 
      <-0.462060, 1.103841, 0.025578>, <-0.217621, 0.676674, -0.082391>, <0.376812, 0.354783, 0.256548>, <0.693544, 0.000000, 0.422947>, 
      <-0.697999, 1.133231, 0.176898>, <-0.517407, 0.734395, 0.147908>, <0.178614, 0.358114, 0.286005>, <0.430138, 0.000000, 0.317854>, 
      <-0.622173, 1.123786, 0.385449>, <-0.441582, 0.724949, 0.356459>, <0.054978, 0.358114, 0.471194>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <0.268147, 1.012882, -0.232052>, <-0.039953, 1.051260, -0.146243>, <-0.257697, 1.078384, -0.057609>, 
      <-0.056527, 1.535754, 0.140554>, <-0.137318, 1.545818, -0.081653>, <-0.276456, 1.464558, -0.041779>, <-0.494200, 1.491681, 0.046855>, 
      <-0.314110, 1.713057, 1.327531>, <-0.093426, 1.639382, 1.276960>, <-0.299141, 1.758749, 1.113005>, <-0.353273, 1.776820, 0.881856>, 
      <-0.509171, 2.253626, 1.702737>, <-0.288487, 2.179951, 1.652167>, <-0.329248, 2.193558, 1.331397>, <-0.383381, 2.211630, 1.100248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <0.650663, 0.606236, -0.121766>, <0.965912, 0.335921, 0.765684>, <1.205418, 0.000000, 1.066741>, 
      <0.268147, 1.012882, -0.232052>, <0.569873, 0.616300, -0.343972>, <1.098118, 0.335921, 0.567657>, <1.337625, 0.000000, 0.868714>, 
      <-0.039953, 1.051260, -0.146243>, <0.204486, 0.624094, -0.254212>, <0.767179, 0.354783, 0.501342>, <1.083911, 0.000000, 0.667741>, 
      <-0.257697, 1.078384, -0.057609>, <-0.013258, 0.651218, -0.165578>, <0.565457, 0.354783, 0.374845>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <-0.056527, 1.535754, 0.140554>, <-0.314110, 1.713057, 1.327531>, <-0.509171, 2.253626, 1.702737>, 
      <0.450489, 0.990168, 0.269461>, <0.045024, 1.523104, 0.419861>, <-0.589929, 1.805140, 1.390736>, <-0.784990, 2.345708, 1.765942>, 
      <0.284778, 1.010809, 0.570226>, <-0.019841, 1.490984, 0.584090>, <-0.837860, 1.914297, 1.446814>, <-1.045147, 2.432561, 1.556297>, 
      <0.011080, 1.044903, 0.681636>, <-0.293538, 1.525078, 0.695500>, <-0.905517, 1.936884, 1.157915>, <-1.112804, 2.455148, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <0.450489, 0.990168, 0.269461>, <0.284778, 1.010809, 0.570226>, <0.011080, 1.044903, 0.681636>, 
      <0.650663, 0.606236, -0.121766>, <0.752215, 0.593585, 0.157542>, <0.484472, 0.696029, 0.561137>, <0.210774, 0.730123, 0.672547>, 
      <0.965912, 0.335921, 0.765684>, <0.800546, 0.335921, 1.013379>, <0.582671, 0.327914, 1.218945>, <0.330354, 0.327914, 1.060720>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.139573, -0.052701, 0.570499>, <-0.397614, -0.052701, 0.481679>, <-0.713684, -0.053921, 0.604690>, <-0.795098, -0.053921, 0.865162>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.044321, -0.058184, 1.150097>, <0.022108, -0.058184, 0.937569>, <0.070971, -0.052701, 0.642971>, <-0.139573, -0.052701, 0.570499>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.494674, -0.058134, 1.589032>, <-0.269535, -0.058134, 1.666527>, <-0.115355, -0.058184, 1.377357>, <-0.044321, -0.058184, 1.150097>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.494674, -0.058134, 1.589032>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.776281, -0.058134, 1.492099>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.883949, -0.053921, 1.149423>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.795098, -0.053921, 0.865162>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.709818, 5.692039, 0.579594>, <1.655656, 5.667152, 0.579594>, <1.587223, 5.621508, 0.573206>, <1.529277, 5.609084, 0.579594>, 
      <1.590743, 5.920637, 0.490764>, <1.536581, 5.895750, 0.490764>, <1.468148, 5.850104, 0.484376>, <1.410202, 5.837681, 0.490764>, 
      <1.454120, 6.182923, 0.629393>, <1.399958, 6.158036, 0.629393>, <1.324998, 6.125084, 0.612717>, <1.273580, 6.099967, 0.629393>, 
      <1.416587, 6.254977, 0.889635>, <1.362425, 6.230090, 0.889635>, <1.287466, 6.197138, 0.872958>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.760328, 5.595072, 1.146066>, <1.706166, 5.570185, 1.146066>, <1.635094, 5.534172, 1.148835>, <1.579788, 5.512116, 1.146066>, 
      <1.790981, 5.536225, 0.933524>, <1.736819, 5.511338, 0.933524>, <1.665747, 5.475325, 0.936293>, <1.610441, 5.453269, 0.933524>, 
      <1.807068, 5.505342, 0.652142>, <1.752905, 5.480455, 0.652142>, <1.684472, 5.434810, 0.645754>, <1.626527, 5.422387, 0.652142>, 
      <1.709818, 5.692039, 0.579594>, <1.655656, 5.667152, 0.579594>, <1.587223, 5.621508, 0.573206>, <1.529277, 5.609084, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.563761, 5.972434, 1.592315>, <1.509599, 5.947548, 1.592315>, <1.430327, 5.925932, 1.590061>, <1.383221, 5.889479, 1.592315>, 
      <1.667696, 5.772902, 1.669850>, <1.613534, 5.748016, 1.669850>, <1.534262, 5.726400, 1.667596>, <1.487156, 5.689948, 1.669850>, 
      <1.727568, 5.657964, 1.373218>, <1.673406, 5.633078, 1.373218>, <1.602334, 5.597064, 1.375987>, <1.547028, 5.575008, 1.373219>, 
      <1.760328, 5.595072, 1.146066>, <1.706166, 5.570185, 1.146066>, <1.635094, 5.534172, 1.148835>, <1.579788, 5.512116, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.563761, 5.972434, 1.592315>, <1.433709, 6.222104, 1.495296>, <1.375594, 6.333674, 1.173867>, <1.416587, 6.254977, 0.889635>, 
      <1.509599, 5.947548, 1.592315>, <1.379547, 6.197218, 1.495296>, <1.321432, 6.308786, 1.173867>, <1.362425, 6.230090, 0.889635>, 
      <1.430327, 5.925932, 1.590061>, <1.300275, 6.175602, 1.493042>, <1.246473, 6.275834, 1.157191>, <1.287466, 6.197138, 0.872958>, 
      <1.383221, 5.889479, 1.592315>, <1.253169, 6.139149, 1.495296>, <1.195055, 6.250717, 1.173867>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.401500, 5.239375, 0.812352>, <-0.566029, 5.390686, 0.968889>, <-0.611715, 5.432701, 1.289497>, <-0.492032, 5.322633, 1.508653>, 
      <0.085041, 5.578176, 0.846709>, <-0.079489, 5.729487, 1.003245>, <-0.126642, 5.776109, 1.411792>, <-0.006959, 5.666041, 1.630948>, 
      <0.951942, 5.485304, 0.643241>, <0.832867, 5.713901, 0.554411>, <0.750146, 5.844274, 0.799157>, <0.712614, 5.916328, 1.059399>, 
      <1.529277, 5.609084, 0.579594>, <1.410202, 5.837681, 0.490764>, <1.273580, 6.099967, 0.629393>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017399, 4.886133, 1.057078>, <-0.114958, 4.975854, 0.878435>, <-0.267385, 5.116036, 0.684752>, <-0.401500, 5.239375, 0.812352>, 
      <0.436524, 5.126386, 1.099536>, <0.338965, 5.216107, 0.920893>, <0.219156, 5.454836, 0.719109>, <0.085041, 5.578176, 0.846709>, 
      <1.101628, 5.321431, 1.122131>, <1.132281, 5.262584, 0.909589>, <1.049191, 5.298607, 0.715789>, <0.951942, 5.485304, 0.643241>, 
      <1.579788, 5.512116, 1.146066>, <1.610441, 5.453269, 0.933524>, <1.626527, 5.422387, 0.652142>, <1.529277, 5.609084, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.063646, 4.811598, 1.664096>, <0.207197, 4.679580, 1.527519>, <0.087024, 4.790099, 1.248290>, <-0.017399, 4.886133, 1.057078>, 
      <0.513483, 5.034893, 1.761712>, <0.657034, 4.902876, 1.625135>, <0.540947, 5.030352, 1.290749>, <0.436524, 5.126386, 1.099536>, 
      <0.978899, 5.576602, 1.611662>, <1.082833, 5.377070, 1.689197>, <1.068868, 5.384324, 1.349284>, <1.101628, 5.321431, 1.122131>, 
      <1.383221, 5.889479, 1.592315>, <1.487156, 5.689948, 1.669850>, <1.547028, 5.575008, 1.373219>, <1.579788, 5.512116, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.063646, 4.811598, 1.664096>, <0.513483, 5.034893, 1.761712>, <0.978899, 5.576602, 1.611662>, <1.383221, 5.889479, 1.592315>, 
      <-0.115705, 4.976539, 1.834734>, <0.334133, 5.199834, 1.932350>, <0.848847, 5.826272, 1.514643>, <1.253169, 6.139149, 1.495296>, 
      <-0.361567, 5.202649, 1.747552>, <0.123506, 5.546057, 1.869847>, <0.671621, 5.995024, 1.343631>, <1.195055, 6.250717, 1.173867>, 
      <-0.492032, 5.322633, 1.508653>, <-0.006959, 5.666041, 1.630948>, <0.712614, 5.916328, 1.059399>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.080129, 3.792033, 0.395332>, <-1.182074, 3.850471, 0.149358>, <-1.447621, 4.002690, 0.035297>, <-1.657917, 4.123237, 0.160018>, 
      <-0.957016, 4.266909, 0.465818>, <-1.058962, 4.325347, 0.219843>, <-1.194281, 4.532674, 0.300691>, <-1.404577, 4.653222, 0.425412>, 
      <-0.807537, 4.956633, 0.783680>, <-0.972067, 5.107944, 0.940216>, <-1.127017, 5.067893, 1.159581>, <-1.007334, 4.957825, 1.378737>, 
      <-0.401500, 5.239375, 0.812352>, <-0.566029, 5.390686, 0.968889>, <-0.611715, 5.432701, 1.289497>, <-0.492032, 5.322633, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363339, 3.954376, 0.870777>, <-1.191632, 3.855949, 0.768942>, <-0.996890, 3.744318, 0.596171>, <-1.080129, 3.792033, 0.395332>, 
      <-1.108684, 4.376812, 0.902369>, <-0.936976, 4.278384, 0.800534>, <-0.873777, 4.219194, 0.666657>, <-0.957016, 4.266909, 0.465818>, 
      <-0.452764, 4.655703, 1.016356>, <-0.550323, 4.745424, 0.837712>, <-0.673422, 4.833293, 0.656080>, <-0.807537, 4.956633, 0.783680>, 
      <-0.017399, 4.886133, 1.057078>, <-0.114958, 4.975854, 0.878435>, <-0.267385, 5.116036, 0.684752>, <-0.401500, 5.239375, 0.812352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.897863, 4.260780, 0.880309>, <-1.808928, 4.209800, 1.094892>, <-1.546796, 4.059539, 0.979581>, <-1.363339, 3.954376, 0.870777>, 
      <-1.448528, 4.707969, 1.044600>, <-1.359593, 4.656989, 1.259182>, <-1.292141, 4.481975, 1.011173>, <-1.108684, 4.376812, 0.902369>, 
      <-0.512167, 4.525770, 1.539143>, <-0.368616, 4.393752, 1.402566>, <-0.348341, 4.559669, 1.207568>, <-0.452764, 4.655703, 1.016356>, 
      <0.063646, 4.811598, 1.664096>, <0.207197, 4.679580, 1.527519>, <0.087024, 4.790099, 1.248290>, <-0.017399, 4.886133, 1.057078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.897863, 4.260780, 0.880309>, <-1.448528, 4.707969, 1.044600>, <-0.512167, 4.525770, 1.539143>, <0.063646, 4.811598, 1.664096>, 
      <-2.009223, 4.324615, 0.611619>, <-1.559888, 4.771804, 0.775909>, <-0.691518, 4.690711, 1.709781>, <-0.115705, 4.976539, 1.834734>, 
      <-1.887634, 4.254917, 0.296257>, <-1.634294, 4.784902, 0.561651>, <-0.876869, 4.837841, 1.617635>, <-0.361567, 5.202649, 1.747552>, 
      <-1.657917, 4.123237, 0.160018>, <-1.404577, 4.653222, 0.425412>, <-1.007334, 4.957825, 1.378737>, <-0.492032, 5.322633, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.122481, 2.458378, 0.399568>, <-1.239682, 2.497505, 0.156583>, <-1.532609, 2.595299, 0.050160>, <-1.759522, 2.671054, 0.180852>, 
      <-1.159002, 2.852133, 0.337410>, <-1.276203, 2.891260, 0.094426>, <-1.624723, 2.983765, -0.126964>, <-1.851635, 3.059519, 0.003727>, 
      <-1.179566, 3.408482, 0.338401>, <-1.281511, 3.466920, 0.092427>, <-1.619280, 3.643581, -0.144530>, <-1.829576, 3.764128, -0.019809>, 
      <-1.080129, 3.792033, 0.395332>, <-1.182074, 3.850471, 0.149358>, <-1.447621, 4.002690, 0.035297>, <-1.657917, 4.123237, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.420864, 2.557994, 0.882967>, <-1.235580, 2.496137, 0.776252>, <-1.026781, 2.426429, 0.597975>, <-1.122481, 2.458378, 0.399568>, 
      <-1.563949, 2.951281, 0.857422>, <-1.378665, 2.889424, 0.750707>, <-1.063302, 2.820184, 0.535817>, <-1.159002, 2.852133, 0.337410>, 
      <-1.579363, 3.596024, 0.843978>, <-1.407656, 3.497597, 0.742142>, <-1.096327, 3.360767, 0.539241>, <-1.179566, 3.408482, 0.338401>, 
      <-1.363339, 3.954376, 0.870777>, <-1.191632, 3.855949, 0.768942>, <-0.996890, 3.744318, 0.596171>, <-1.080129, 3.792033, 0.395332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.004869, 2.752963, 0.907784>, <-1.902623, 2.718829, 1.119763>, <-1.618822, 2.624082, 0.996982>, <-1.420864, 2.557994, 0.882967>, 
      <-2.212138, 3.144726, 0.811473>, <-2.109892, 3.110592, 1.023452>, <-1.761907, 3.017369, 0.971437>, <-1.563949, 2.951281, 0.857422>, 
      <-2.209063, 3.951066, 0.766525>, <-2.120128, 3.900086, 0.981108>, <-1.762821, 3.701187, 0.952781>, <-1.579363, 3.596024, 0.843978>, 
      <-1.897863, 4.260780, 0.880309>, <-1.808928, 4.209800, 1.094892>, <-1.546796, 4.059539, 0.979581>, <-1.363339, 3.954376, 0.870777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.004869, 2.752963, 0.907784>, <-2.212138, 3.144726, 0.811473>, <-2.209063, 3.951066, 0.766525>, <-1.897863, 4.260780, 0.880309>, 
      <-2.132899, 2.795705, 0.642350>, <-2.340168, 3.187468, 0.546038>, <-2.320423, 4.014902, 0.497835>, <-2.009223, 4.324615, 0.611619>, 
      <-2.007400, 2.753808, 0.323618>, <-2.099513, 3.142273, 0.146494>, <-2.059293, 3.895808, 0.116430>, <-1.887634, 4.254917, 0.296257>, 
      <-1.759522, 2.671054, 0.180852>, <-1.851635, 3.059519, 0.003727>, <-1.829576, 3.764128, -0.019809>, <-1.657917, 4.123237, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835108, 1.150311, 0.812352>, <-1.056529, 1.177893, 0.969382>, <-1.117379, 1.185473, 1.289147>, <-0.956561, 1.165440, 1.508653>, 
      <-0.987237, 1.541206, 0.783727>, <-1.208658, 1.568788, 0.940757>, <-1.329887, 1.777803, 1.131968>, <-1.169069, 1.757771, 1.351474>, 
      <-1.084124, 2.044823, 0.464851>, <-1.201325, 2.083950, 0.221867>, <-1.395814, 2.018397, 0.313204>, <-1.622726, 2.094152, 0.443896>, 
      <-1.122481, 2.458378, 0.399568>, <-1.239682, 2.497505, 0.156583>, <-1.532609, 2.595299, 0.050160>, <-1.759522, 2.671054, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835108, 1.150311, 0.812352>, <-0.688443, 0.773456, 0.839949>, <-0.343805, 0.358812, 0.641515>, <-0.165728, 0.000000, 0.579594>, 
      <-1.056529, 1.177893, 0.969382>, <-0.909864, 0.801038, 0.996979>, <-0.601845, 0.358812, 0.552694>, <-0.423769, 0.000000, 0.490773>, 
      <-1.117379, 1.185473, 1.289147>, <-0.986780, 0.821449, 1.385744>, <-0.760941, 0.361050, 0.793031>, <-0.719824, 0.000000, 0.629163>, 
      <-0.956561, 1.165440, 1.508653>, <-0.825962, 0.801416, 1.605249>, <-0.842356, 0.361050, 1.053503>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.319816, 1.086122, 1.057078>, <-0.450398, 1.102388, 0.878843>, <-0.655318, 1.127915, 0.684846>, <-0.835108, 1.150311, 0.812352>, 
      <-0.579462, 1.572836, 1.007018>, <-0.710044, 1.589102, 0.828783>, <-0.807446, 1.518810, 0.656221>, <-0.987237, 1.541206, 0.783727>, 
      <-1.231839, 2.038434, 0.916714>, <-1.046554, 1.976577, 0.809998>, <-0.988424, 2.012874, 0.663259>, <-1.084124, 2.044823, 0.464851>, 
      <-1.420864, 2.557994, 0.882967>, <-1.235580, 2.496137, 0.776252>, <-1.026781, 2.426429, 0.597975>, <-1.122481, 2.458378, 0.399568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.319816, 1.086122, 1.057078>, <-0.162149, 0.790570, 1.087477>, <-0.123706, 0.328734, 1.123293>, <-0.056259, 0.000000, 1.146066>, 
      <-0.450398, 1.102388, 0.878843>, <-0.292731, 0.806836, 0.909242>, <-0.057277, 0.328734, 0.910765>, <0.010170, 0.000000, 0.933538>, 
      <-0.655318, 1.127915, 0.684846>, <-0.508653, 0.751060, 0.712443>, <-0.133261, 0.358812, 0.713987>, <0.044816, 0.000000, 0.652066>, 
      <-0.835108, 1.150311, 0.812352>, <-0.688443, 0.773456, 0.839949>, <-0.343805, 0.358812, 0.641515>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.017902, 1.048514, 1.527089>, <-0.179504, 1.068644, 1.248594>, <-0.319816, 1.086122, 1.057078>, 
      <-0.575942, 1.732259, 1.500065>, <-0.382755, 1.708194, 1.363058>, <-0.439150, 1.555358, 1.198534>, <-0.579462, 1.572836, 1.007018>, 
      <-1.652308, 2.086582, 1.071607>, <-1.550062, 2.052448, 1.283586>, <-1.429796, 2.104522, 1.030729>, <-1.231839, 2.038434, 0.916714>, 
      <-2.004869, 2.752963, 0.907784>, <-1.902623, 2.718829, 1.119763>, <-1.618822, 2.624082, 0.996982>, <-1.420864, 2.557994, 0.882967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.053798, 0.788186, 1.734811>, <-0.412977, 0.324781, 1.610657>, <-0.482271, 0.000000, 1.592315>, 
      <-0.017902, 1.048514, 1.527089>, <0.139389, 0.764121, 1.597804>, <-0.187837, 0.324781, 1.688153>, <-0.257132, 0.000000, 1.669811>, 
      <-0.179504, 1.068644, 1.248594>, <-0.021837, 0.773092, 1.278993>, <-0.194740, 0.328734, 1.350554>, <-0.127293, 0.000000, 1.373327>, 
      <-0.319816, 1.086122, 1.057078>, <-0.162149, 0.790570, 1.087477>, <-0.123706, 0.328734, 1.123293>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.575942, 1.732259, 1.500065>, <-1.652308, 2.086582, 1.071607>, <-2.004869, 2.752963, 0.907784>, 
      <-0.451355, 1.102508, 1.834491>, <-0.816208, 1.762188, 1.670460>, <-1.780338, 2.129324, 0.806173>, <-2.132899, 2.795705, 0.642350>, 
      <-0.782056, 1.143703, 1.746841>, <-0.994564, 1.736033, 1.589662>, <-1.870604, 2.176906, 0.586662>, <-2.007400, 2.753808, 0.323618>, 
      <-0.956561, 1.165440, 1.508653>, <-1.169069, 1.757771, 1.351474>, <-1.622726, 2.094152, 0.443896>, <-1.759522, 2.671054, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.451355, 1.102508, 1.834491>, <-0.782056, 1.143703, 1.746841>, <-0.956561, 1.165440, 1.508653>, 
      <-0.053798, 0.788186, 1.734811>, <-0.294064, 0.818115, 1.905206>, <-0.651456, 0.779679, 1.843437>, <-0.825962, 0.801416, 1.605249>, 
      <-0.412977, 0.324781, 1.610657>, <-0.694584, 0.324781, 1.513724>, <-0.931207, 0.361050, 1.337764>, <-0.842356, 0.361050, 1.053503>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.542867, -0.041261, 0.002034>, <0.542867, -0.041261, -0.270865>, <0.315642, -0.038678, -0.522344>, <0.042854, -0.038678, -0.514550>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.034220, -0.048102, 0.280171>, <0.256797, -0.048102, 0.273812>, <0.542867, -0.041261, 0.224702>, <0.542867, -0.041261, 0.002034>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.530821, -0.045289, 0.005688>, <-0.530821, -0.045289, 0.243791>, <-0.203787, -0.048102, 0.286971>, <0.034220, -0.048102, 0.280171>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.530821, -0.045289, 0.005688>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.530821, -0.045289, -0.292135>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.254847, -0.038678, -0.506044>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.042854, -0.038678, -0.514550>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.016992, 5.102336, 0.000000>, <1.962830, 5.077449, 0.000000>, <1.895862, 5.014841, 0.001607>, <1.836451, 5.019381, 0.000000>, 
      <2.016992, 5.102336, -0.272732>, <1.962830, 5.077449, -0.272732>, <1.895862, 5.014841, -0.271125>, <1.836451, 5.019381, -0.272732>, 
      <1.912231, 5.303452, -0.507799>, <1.858069, 5.278566, -0.507799>, <1.789997, 5.215879, -0.519283>, <1.731691, 5.220498, -0.507799>, 
      <1.786286, 5.545237, -0.500000>, <1.732124, 5.520350, -0.500000>, <1.664052, 5.457664, -0.511485>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.786286, 5.545237, 0.287879>, <1.732124, 5.520350, 0.287879>, <1.664830, 5.467760, 0.282231>, <1.605746, 5.462282, 0.287879>, 
      <1.889017, 5.348018, 0.281518>, <1.834855, 5.323131, 0.281518>, <1.767561, 5.270541, 0.275870>, <1.708477, 5.265063, 0.281518>, 
      <2.016992, 5.102336, 0.222463>, <1.962830, 5.077449, 0.222463>, <1.895862, 5.014841, 0.224070>, <1.836451, 5.019381, 0.222463>, 
      <2.016992, 5.102336, 0.000000>, <1.962830, 5.077449, 0.000000>, <1.895862, 5.014841, 0.001607>, <1.836451, 5.019381, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527617, 6.041823, 0.030303>, <1.473455, 6.016936, 0.030303>, <1.403322, 5.966867, 0.012264>, <1.347077, 5.958868, 0.030303>, 
      <1.527617, 6.041823, 0.268165>, <1.473455, 6.016936, 0.268165>, <1.403322, 5.966867, 0.250126>, <1.347077, 5.958868, 0.268165>, 
      <1.676444, 5.756108, 0.294681>, <1.622282, 5.731222, 0.294681>, <1.554989, 5.678632, 0.289033>, <1.495904, 5.673154, 0.294681>, 
      <1.786286, 5.545237, 0.287879>, <1.732124, 5.520350, 0.287879>, <1.664830, 5.467760, 0.282231>, <1.605746, 5.462282, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527617, 6.041823, 0.030303>, <1.527617, 6.041823, -0.267327>, <1.648843, 5.809094, -0.491489>, <1.786286, 5.545237, -0.500000>, 
      <1.473455, 6.016936, 0.030303>, <1.473455, 6.016936, -0.267327>, <1.594682, 5.784208, -0.491489>, <1.732124, 5.520350, -0.500000>, 
      <1.403322, 5.966867, 0.012264>, <1.403322, 5.966867, -0.285366>, <1.526610, 5.721521, -0.502974>, <1.664052, 5.457664, -0.511485>, 
      <1.347077, 5.958868, 0.030303>, <1.347077, 5.958868, -0.267327>, <1.468304, 5.726140, -0.491489>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.458144, 5.291469, -0.066958>, <-0.620314, 5.440610, -0.227437>, <-0.858375, 5.659545, -0.181768>, <-0.971625, 5.763697, 0.043226>, 
      <0.082830, 5.709505, -0.183255>, <-0.079340, 5.858646, -0.343734>, <-0.325463, 6.245668, -0.252869>, <-0.438713, 6.349821, -0.027875>, 
      <1.145226, 5.072200, -0.018699>, <1.145226, 5.072200, -0.291431>, <0.953675, 5.282126, -0.354553>, <0.827730, 5.523910, -0.346754>, 
      <1.836451, 5.019381, 0.000000>, <1.836451, 5.019381, -0.272732>, <1.731691, 5.220498, -0.507799>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.503245, 5.332946, 0.506724>, <-0.410730, 5.247864, 0.322926>, <-0.325667, 5.169635, 0.064138>, <-0.458144, 5.291469, -0.066958>, 
      <0.003768, 5.719003, 0.502323>, <0.096283, 5.633921, 0.318525>, <0.215307, 5.587671, -0.052159>, <0.082830, 5.709505, -0.183255>, 
      <0.974046, 5.403709, 0.348260>, <1.076777, 5.206490, 0.341899>, <1.145226, 5.072200, 0.203763>, <1.145226, 5.072200, -0.018699>, 
      <1.605746, 5.462282, 0.287879>, <1.708477, 5.265063, 0.281518>, <1.836451, 5.019381, 0.222463>, <1.836451, 5.019381, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.898820, 5.696741, 0.808531>, <-0.757290, 5.566581, 0.948585>, <-0.602082, 5.423842, 0.703083>, <-0.503245, 5.332946, 0.506724>, 
      <-0.382301, 6.190080, 0.875474>, <-0.240771, 6.059920, 1.015528>, <-0.095068, 5.809899, 0.698682>, <0.003768, 5.719003, 0.502323>, 
      <0.670136, 5.862595, 0.247417>, <0.670136, 5.862595, 0.485279>, <0.864204, 5.614581, 0.355062>, <0.974046, 5.403709, 0.348260>, 
      <1.347077, 5.958868, 0.030303>, <1.347077, 5.958868, 0.268165>, <1.495904, 5.673154, 0.294681>, <1.605746, 5.462282, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.898820, 5.696741, 0.808531>, <-0.382301, 6.190080, 0.875474>, <0.670136, 5.862595, 0.247417>, <1.347077, 5.958868, 0.030303>, 
      <-1.076009, 5.859695, 0.633189>, <-0.559490, 6.353034, 0.700132>, <0.670136, 5.862595, -0.050213>, <1.347077, 5.958868, -0.267327>, 
      <-1.095364, 5.877495, 0.289058>, <-0.562453, 6.463619, 0.217957>, <0.690288, 5.787768, -0.338243>, <1.468304, 5.726140, -0.491489>, 
      <-0.971625, 5.763697, 0.043226>, <-0.438713, 6.349821, -0.027875>, <0.827730, 5.523910, -0.346754>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317538, 3.354895, 0.463057>, <-0.148934, 3.258247, 0.271469>, <-0.142030, 3.254290, -0.054998>, <-0.312792, 3.352175, -0.244029>, 
      <-0.350183, 3.949814, 0.365095>, <-0.181579, 3.853166, 0.173507>, <-0.280968, 3.993625, 0.007938>, <-0.451731, 4.091510, -0.181094>, 
      <-0.929162, 4.927492, 0.034300>, <-1.091332, 5.076634, -0.126180>, <-1.364183, 5.103231, -0.114283>, <-1.477433, 5.207383, 0.110711>, 
      <-0.458144, 5.291469, -0.066958>, <-0.620314, 5.440610, -0.227437>, <-0.858375, 5.659545, -0.181768>, <-0.971625, 5.763697, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.799259, 3.631031, 0.308754>, <-0.660087, 3.551254, 0.462815>, <-0.454951, 3.433664, 0.619202>, <-0.317538, 3.354895, 0.463057>, 
      <-0.744607, 4.148604, 0.343836>, <-0.605436, 4.068828, 0.497897>, <-0.487595, 4.028582, 0.521240>, <-0.350183, 3.949814, 0.365095>, 
      <-0.918252, 5.016946, 0.510326>, <-0.825737, 4.931864, 0.326528>, <-0.796685, 4.805658, 0.165396>, <-0.929162, 4.927492, 0.034300>, 
      <-0.503245, 5.332946, 0.506724>, <-0.410730, 5.247864, 0.322926>, <-0.325667, 5.169635, 0.064138>, <-0.458144, 5.291469, -0.066958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.981040, 3.735232, -0.271430>, <-1.128125, 3.819545, -0.104294>, <-0.948227, 3.716424, 0.143849>, <-0.799259, 3.631031, 0.308754>, 
      <-0.955477, 4.373141, -0.061020>, <-1.102562, 4.457454, 0.106116>, <-0.893575, 4.233997, 0.178930>, <-0.744607, 4.148604, 0.343836>, 
      <-1.382799, 5.234482, 0.745806>, <-1.241269, 5.104322, 0.885860>, <-1.017089, 5.107842, 0.706685>, <-0.918252, 5.016946, 0.510326>, 
      <-0.898820, 5.696741, 0.808531>, <-0.757290, 5.566581, 0.948585>, <-0.602082, 5.423842, 0.703083>, <-0.503245, 5.332946, 0.506724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.981040, 3.735232, -0.271430>, <-0.955477, 4.373141, -0.061020>, <-1.382799, 5.234482, 0.745806>, <-0.898820, 5.696741, 0.808531>, 
      <-0.797264, 3.629887, -0.480259>, <-0.771700, 4.267796, -0.269849>, <-1.559988, 5.397436, 0.570463>, <-1.076009, 5.859695, 0.633189>, 
      <-0.498921, 3.458869, -0.450071>, <-0.637860, 4.198204, -0.387136>, <-1.601173, 5.321181, 0.356543>, <-1.095364, 5.877495, 0.289058>, 
      <-0.312792, 3.352175, -0.244029>, <-0.451731, 4.091510, -0.181094>, <-1.477433, 5.207383, 0.110711>, <-0.971625, 5.763697, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287387, 2.179583, 0.445460>, <-0.107609, 2.119564, 0.249115>, <-0.107716, 2.119600, -0.077450>, <-0.298801, 2.183394, -0.261544>, 
      <-0.197714, 2.511214, 0.525533>, <-0.017936, 2.451195, 0.329188>, <0.073911, 2.416852, -0.117983>, <-0.117174, 2.480645, -0.302077>, 
      <-0.298467, 3.007342, 0.520287>, <-0.129863, 2.910694, 0.328699>, <-0.077484, 2.910824, -0.084235>, <-0.248247, 3.008709, -0.273266>, 
      <-0.317538, 3.354895, 0.463057>, <-0.148934, 3.258247, 0.271469>, <-0.142030, 3.254290, -0.054998>, <-0.312792, 3.352175, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.817526, 2.356570, 0.304983>, <-0.661793, 2.304579, 0.455018>, <-0.433905, 2.228498, 0.605480>, <-0.287387, 2.179583, 0.445460>, 
      <-0.790928, 2.736798, 0.274430>, <-0.635195, 2.684806, 0.424466>, <-0.344232, 2.560129, 0.685553>, <-0.197714, 2.511214, 0.525533>, 
      <-0.839321, 3.251627, 0.283038>, <-0.700149, 3.171850, 0.437099>, <-0.435880, 3.086111, 0.676432>, <-0.298467, 3.007342, 0.520287>, 
      <-0.799259, 3.631031, 0.308754>, <-0.660087, 3.551254, 0.462815>, <-0.454951, 3.433664, 0.619202>, <-0.317538, 3.354895, 0.463057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.029833, 2.427448, -0.269824>, <-1.186663, 2.479806, -0.098541>, <-0.984220, 2.412221, 0.144387>, <-0.817526, 2.356570, 0.304983>, 
      <-0.956069, 2.781487, -0.422653>, <-1.112900, 2.833845, -0.251370>, <-0.957622, 2.792448, 0.113834>, <-0.790928, 2.736798, 0.274430>, 
      <-0.995971, 3.362652, -0.394323>, <-1.143056, 3.446966, -0.227187>, <-0.988289, 3.337019, 0.118132>, <-0.839321, 3.251627, 0.283038>, 
      <-0.981040, 3.735232, -0.271430>, <-1.128125, 3.819545, -0.104294>, <-0.948227, 3.716424, 0.143849>, <-0.799259, 3.631031, 0.308754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.029833, 2.427448, -0.269824>, <-0.956069, 2.781487, -0.422653>, <-0.995971, 3.362652, -0.394323>, <-0.981040, 3.735232, -0.271430>, 
      <-0.833876, 2.362028, -0.483839>, <-0.760113, 2.716067, -0.636667>, <-0.812194, 3.257307, -0.603152>, <-0.797264, 3.629887, -0.480259>, 
      <-0.507082, 2.252928, -0.462205>, <-0.325455, 2.550180, -0.502738>, <-0.434376, 3.115403, -0.479308>, <-0.498921, 3.458869, -0.450071>, 
      <-0.298801, 2.183394, -0.261544>, <-0.117174, 2.480645, -0.302077>, <-0.248247, 3.008709, -0.273266>, <-0.312792, 3.352175, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.911099, 1.159776, -0.066958>, <-1.128313, 1.186834, -0.227182>, <-1.448521, 1.226722, -0.181041>, <-1.599961, 1.245586, 0.043226>, 
      <-1.041287, 1.520151, 0.006695>, <-1.258500, 1.547208, -0.153529>, <-1.514544, 1.709163, -0.128352>, <-1.665984, 1.728027, 0.095915>, 
      <-0.386576, 1.812758, 0.356890>, <-0.206798, 1.752740, 0.160544>, <-0.361373, 1.704464, -0.020841>, <-0.552458, 1.768257, -0.204936>, 
      <-0.287387, 2.179583, 0.445460>, <-0.107609, 2.119564, 0.249115>, <-0.107716, 2.119600, -0.077450>, <-0.298801, 2.183394, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.911099, 1.159776, -0.066958>, <-0.728144, 0.653335, -0.170464>, <0.105169, 0.380035, -0.018735>, <0.500000, 0.000000, 0.000000>, 
      <-1.128313, 1.186834, -0.227182>, <-0.945358, 0.680392, -0.330688>, <0.105169, 0.380035, -0.291635>, <0.500000, 0.000000, -0.272899>, 
      <-1.448521, 1.226722, -0.181041>, <-1.363630, 0.606411, -0.248787>, <-0.180531, 0.409138, -0.353881>, <0.272788, 0.000000, -0.507794>, 
      <-1.599961, 1.245586, 0.043226>, <-1.515071, 0.625276, -0.024520>, <-0.453319, 0.409138, -0.346087>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.971604, 1.167314, 0.506724>, <-0.847303, 1.151830, 0.322648>, <-0.732813, 1.137568, 0.064552>, <-0.911099, 1.159776, -0.066958>, 
      <-1.091169, 1.511969, 0.509226>, <-0.966869, 1.496485, 0.325150>, <-0.863000, 1.497942, 0.138205>, <-1.041287, 1.520151, 0.006695>, 
      <-0.842902, 1.993809, 0.334132>, <-0.687169, 1.941818, 0.484168>, <-0.533094, 1.861673, 0.516910>, <-0.386576, 1.812758, 0.356890>, 
      <-0.817526, 2.356570, 0.304983>, <-0.661793, 2.304579, 0.455018>, <-0.433905, 2.228498, 0.605480>, <-0.287387, 2.179583, 0.445460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.971604, 1.167314, 0.506724>, <-0.820732, 0.732417, 0.503567>, <-0.264601, 0.371943, 0.347478>, <0.000000, 0.000000, 0.287879>, 
      <-0.847303, 1.151830, 0.322648>, <-0.696432, 0.716933, 0.319492>, <-0.042024, 0.371943, 0.341119>, <0.222577, 0.000000, 0.281520>, 
      <-0.732813, 1.137568, 0.064552>, <-0.549858, 0.631126, -0.038954>, <0.105169, 0.380035, 0.203933>, <0.500000, 0.000000, 0.222668>, 
      <-0.911099, 1.159776, -0.066958>, <-0.728144, 0.653335, -0.170464>, <0.105169, 0.380035, -0.018735>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.312519, 1.209780, 0.948512>, <-1.103911, 1.183795, 0.702656>, <-0.971604, 1.167314, 0.506724>, 
      <-1.597066, 1.723727, 0.747910>, <-1.407296, 1.700088, 0.887891>, <-1.223476, 1.528450, 0.705157>, <-1.091169, 1.511969, 0.509226>, 
      <-1.124346, 1.973817, -0.074004>, <-1.281177, 2.026175, 0.097278>, <-1.009596, 2.049460, 0.173537>, <-0.842902, 1.993809, 0.334132>, 
      <-1.029833, 2.427448, -0.269824>, <-1.186663, 2.479806, -0.098541>, <-0.984220, 2.412221, 0.144387>, <-0.817526, 2.356570, 0.304983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.404168, 0.725808, 0.871292>, <-0.821170, 0.396197, 0.245639>, <-0.560606, 0.000000, 0.030303>, 
      <-1.312519, 1.209780, 0.948512>, <-1.214398, 0.702169, 1.011272>, <-0.821170, 0.396197, 0.483743>, <-0.560606, 0.000000, 0.268407>, 
      <-1.103911, 1.183795, 0.702656>, <-0.953039, 0.748898, 0.699499>, <-0.502608, 0.371943, 0.354278>, <-0.238007, 0.000000, 0.294679>, 
      <-0.971604, 1.167314, 0.506724>, <-0.820732, 0.732417, 0.503567>, <-0.264601, 0.371943, 0.347478>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.597066, 1.723727, 0.747910>, <-1.124346, 1.973817, -0.074004>, <-1.029833, 2.427448, -0.269824>, 
      <-1.740743, 1.263122, 0.632639>, <-1.835520, 1.753430, 0.572018>, <-0.928390, 1.908397, -0.288019>, <-0.833876, 2.362028, -0.483839>, 
      <-1.766210, 1.266295, 0.289423>, <-1.832233, 1.748737, 0.342112>, <-0.760739, 1.837792, -0.405597>, <-0.507082, 2.252928, -0.462205>, 
      <-1.599961, 1.245586, 0.043226>, <-1.665984, 1.728027, 0.095915>, <-0.552458, 1.768257, -0.204936>, <-0.298801, 2.183394, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.740743, 1.263122, 0.632639>, <-1.766210, 1.266295, 0.289423>, <-1.599961, 1.245586, 0.043226>, 
      <-1.404168, 0.725808, 0.871292>, <-1.642622, 0.755511, 0.695399>, <-1.681320, 0.645985, 0.221677>, <-1.515071, 0.625276, -0.024520>, 
      <-0.821170, 0.396197, 0.245639>, <-0.821170, 0.396197, -0.052184>, <-0.751020, 0.409138, -0.337581>, <-0.453319, 0.409138, -0.346087>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <0.1416, -0.015731, 0.024096>
}
#declare segMcurvedMB3 = union {
  object { // Blatt66->Blatt17
    Blatt17
    rotate <18.007225, -13.222313, 112.000534>
    translate  <-2.227054, -0.252009, -1.226408>
  }
  object { // Blatt67->Blatt17
    Blatt17
    rotate <-39.587894, -43.800213, -135.838745>
    translate  <-2.057443, -1.041412, 3.4756>
  }
  object { Blatt68 }
  object { sPatchObj23 }
  rotate <-0.0, -59.929058, 0.0>
  translate  <-0.64879, 0.047175, 28.889663>
}
#declare BezPtch024 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt71 = union {
  cone { // Cone024
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch024 }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare sPatchObj24 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.277127, -0.051562, 0.507806>, <0.125600, -0.051562, 0.734772>, <0.174932, -0.040910, 1.071062>, <0.406133, -0.040910, 1.216045>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.865420, -0.051004, 0.566965>, <0.676775, -0.051004, 0.448668>, <0.400763, -0.051562, 0.322616>, <0.277127, -0.051562, 0.507806>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.184046, -0.040947, 1.104300>, <1.316252, -0.040947, 0.906273>, <1.067142, -0.051004, 0.693461>, <0.865420, -0.051004, 0.566965>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.184046, -0.040947, 1.104300>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.018680, -0.040947, 1.351995>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.658450, -0.040910, 1.374270>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.406133, -0.040910, 1.216045>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>, 
      <-0.855631, 5.429722, 0.730006>, <-0.803530, 5.400920, 0.730006>, <-0.733936, 5.361541, 0.721743>, <-0.681960, 5.333712, 0.730007>, 
      <-0.827295, 5.480978, 1.051520>, <-0.775194, 5.452176, 1.051520>, <-0.690273, 5.431881, 1.050960>, <-0.653624, 5.384969, 1.051520>, 
      <-0.715431, 5.683328, 1.196486>, <-0.663330, 5.654525, 1.196486>, <-0.578409, 5.634231, 1.195926>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>, 
      <-0.595074, 5.901042, 0.422904>, <-0.542973, 5.872240, 0.422904>, <-0.464206, 5.839552, 0.400091>, <-0.421402, 5.805032, 0.422904>, 
      <-0.722518, 5.670511, 0.317830>, <-0.670416, 5.641708, 0.317830>, <-0.600822, 5.602329, 0.309567>, <-0.548846, 5.574500, 0.317830>, 
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.295297, 6.320257, 1.066661>, <-0.202994, 6.299939, 1.044549>, <-0.173727, 6.253049, 1.066661>, 
      <-0.283442, 6.464750, 0.868624>, <-0.231340, 6.435948, 0.868624>, <-0.139038, 6.415630, 0.846512>, <-0.109770, 6.368740, 0.868624>, 
      <-0.406199, 6.242695, 0.667669>, <-0.354098, 6.213892, 0.667669>, <-0.275331, 6.181205, 0.644856>, <-0.232528, 6.146685, 0.667669>, 
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.427396, 6.204352, 1.314368>, <-0.593351, 5.904158, 1.354692>, <-0.715431, 5.683328, 1.196486>, 
      <-0.295297, 6.320257, 1.066661>, <-0.375294, 6.175549, 1.314368>, <-0.541249, 5.875356, 1.354692>, <-0.663330, 5.654525, 1.196486>, 
      <-0.202994, 6.299939, 1.044549>, <-0.282992, 6.155232, 1.292256>, <-0.456328, 5.855060, 1.354132>, <-0.578409, 5.634231, 1.195926>, 
      <-0.173727, 6.253049, 1.066661>, <-0.253725, 6.108342, 1.314368>, <-0.419679, 5.808149, 1.354692>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>, 
      <0.333387, 5.140495, 0.666297>, <0.146841, 4.941398, 0.660378>, <0.089060, 4.814777, 1.059697>, <0.090343, 4.816146, 1.332590>, 
      <-0.246561, 5.272440, 0.560594>, <-0.319864, 5.139843, 0.787572>, <-0.398275, 5.058113, 1.055421>, <-0.286411, 5.260462, 1.200388>, 
      <-0.608657, 5.466310, 0.503029>, <-0.681960, 5.333712, 0.730007>, <-0.653624, 5.384969, 1.051520>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>, 
      <0.632096, 5.471738, 1.114818>, <0.631049, 5.470621, 0.892155>, <0.485597, 5.302945, 0.671125>, <0.333387, 5.140495, 0.666297>, 
      <0.018129, 5.689274, 0.726800>, <-0.073145, 5.524170, 0.608517>, <-0.186750, 5.380631, 0.375396>, <-0.246561, 5.272440, 0.560594>, 
      <-0.330128, 5.970136, 0.541187>, <-0.421402, 5.805032, 0.422904>, <-0.548846, 5.574500, 0.317830>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>, 
      <0.559724, 5.359637, 1.785183>, <0.722485, 5.533348, 1.790346>, <0.633215, 5.472933, 1.352916>, <0.632096, 5.471738, 1.114818>, 
      <0.087598, 5.834381, 1.264095>, <0.151555, 5.950072, 1.066059>, <0.115730, 5.865823, 0.853283>, <0.018129, 5.689274, 0.726800>, 
      <-0.173727, 6.253049, 1.066661>, <-0.109770, 6.368740, 0.868624>, <-0.232528, 6.146685, 0.667669>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.559724, 5.359637, 1.785183>, <0.087598, 5.834381, 1.264095>, <-0.173727, 6.253049, 1.066661>, 
      <0.397381, 4.612405, 1.776704>, <0.356140, 5.142357, 1.778724>, <0.007600, 5.689674, 1.511802>, <-0.253725, 6.108342, 1.314368>, 
      <0.248176, 4.453163, 1.509005>, <0.091744, 4.817640, 1.630407>, <-0.164330, 5.481292, 1.358594>, <-0.419679, 5.808149, 1.354692>, 
      <0.246776, 4.451668, 1.211188>, <0.090343, 4.816146, 1.332590>, <-0.286411, 5.260462, 1.200388>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>, 
      <0.882376, 3.995773, 0.849049>, <0.841315, 3.966481, 0.580851>, <0.516590, 3.777855, 0.584002>, <0.299515, 3.623001, 0.642080>, 
      <0.833105, 4.538882, 0.772586>, <0.646558, 4.339785, 0.766668>, <0.405989, 4.076356, 0.813740>, <0.407272, 4.077726, 1.086633>, 
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>, 
      <0.621171, 3.839677, 1.368932>, <0.798289, 3.966028, 1.321545>, <0.915880, 4.019673, 1.067881>, <0.882376, 3.995773, 0.849049>, 
      <0.944036, 4.565423, 1.345753>, <0.942989, 4.564306, 1.123091>, <0.985314, 4.701332, 0.777415>, <0.833105, 4.538882, 0.772586>, 
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>, 
      <0.099322, 3.489870, 1.437820>, <0.135148, 3.515427, 1.671821>, <0.431775, 3.704567, 1.419605>, <0.621171, 3.839677, 1.368932>, 
      <0.647941, 4.226036, 1.780862>, <0.810702, 4.399747, 1.786026>, <0.945155, 4.566618, 1.583851>, <0.944036, 4.565423, 1.345753>, 
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.099322, 3.489870, 1.437820>, <0.647941, 4.226036, 1.780862>, <0.600965, 4.829686, 1.783163>, 
      <0.032918, 2.989836, 0.761653>, <0.054511, 3.457903, 1.145127>, <0.444357, 4.008756, 1.774404>, <0.397381, 4.612405, 1.776704>, 
      <0.209558, 3.115845, 0.492946>, <0.062615, 3.454004, 0.705462>, <0.408672, 4.079220, 1.384450>, <0.248176, 4.453163, 1.509005>, 
      <0.446457, 3.284843, 0.429564>, <0.299515, 3.623001, 0.642080>, <0.407272, 4.077726, 1.086633>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>, 
      <0.842239, 2.712652, 0.652879>, <1.079409, 2.805129, 0.554528>, <1.039943, 2.771892, 0.171966>, <0.941576, 2.733537, -0.079682>, 
      <0.963539, 3.228570, 0.806736>, <0.922478, 3.199278, 0.538538>, <0.788065, 3.153108, 0.191378>, <0.570991, 2.998253, 0.249456>, 
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>, 
      <0.313144, 2.546508, 0.450622>, <0.393406, 2.577804, 0.655950>, <0.648725, 2.637197, 0.733127>, <0.842239, 2.712652, 0.652879>, 
      <0.512441, 2.929325, 1.049401>, <0.689559, 3.055676, 1.002013>, <0.997042, 3.252470, 1.025568>, <0.963539, 3.228570, 0.806736>, 
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>, 
      <0.147649, 2.501586, -0.170179>, <-0.059280, 2.420900, -0.084369>, <0.227320, 2.513043, 0.231060>, <0.313144, 2.546508, 0.450622>, 
      <0.059256, 2.621347, 0.726264>, <0.095082, 2.646904, 0.960265>, <0.323045, 2.794215, 1.100074>, <0.512441, 2.929325, 1.049401>, 
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.147649, 2.501586, -0.170179>, <0.059256, 2.621347, 0.726264>, <0.077730, 3.021803, 1.054346>, 
      <0.737188, 2.272763, -0.501665>, <0.406479, 2.602509, -0.277512>, <0.014445, 2.589380, 0.433571>, <0.032918, 2.989836, 0.761653>, 
      <1.020113, 2.383082, -0.337147>, <0.834225, 2.691678, -0.354314>, <0.334091, 2.829256, 0.312838>, <0.209558, 3.115845, 0.492946>, 
      <1.127464, 2.424940, -0.062515>, <0.941576, 2.733537, -0.079682>, <0.570991, 2.998253, 0.249456>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <1.184052, 1.106319, 0.616299>, <1.499098, 1.137656, 0.697322>, <1.726240, 1.160250, 0.547756>, 
      <1.129392, 1.459057, 0.396667>, <1.271676, 1.473210, 0.629109>, <1.610121, 1.531984, 0.492588>, <1.837264, 1.554577, 0.343022>, 
      <0.878420, 1.949636, 0.518860>, <1.115590, 2.042113, 0.420509>, <1.461870, 2.071445, 0.210932>, <1.363502, 2.033089, -0.040716>, 
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>, 
      <1.184052, 1.106319, 0.616299>, <1.091978, 0.720794, 0.602838>, <0.350665, 0.343493, 0.698289>, <0.154975, 0.000000, 0.730010>, 
      <1.499098, 1.137656, 0.697322>, <1.364811, 0.660701, 0.944957>, <0.572554, 0.380657, 0.869770>, <0.213519, 0.000000, 1.051528>, 
      <1.726240, 1.160250, 0.547756>, <1.591953, 0.683295, 0.795391>, <0.803756, 0.380657, 1.014753>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.130124, 1.100955, -0.001283>, <0.925674, 1.080618, 0.194200>, <1.041768, 1.092166, 0.383857>, 
      <1.232537, 1.526577, -0.183665>, <1.047204, 1.508142, -0.061629>, <1.013298, 1.447509, 0.207010>, <1.129392, 1.459057, 0.396667>, 
      <0.558680, 1.810340, 0.016388>, <0.638942, 1.841635, 0.221717>, <0.684905, 1.874181, 0.599108>, <0.878420, 1.949636, 0.518860>, 
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>, 
      <1.130124, 1.100955, -0.001283>, <1.211405, 0.701818, 0.057870>, <0.809481, 0.352635, 0.245119>, <0.693544, 0.000000, 0.422947>, 
      <0.925674, 1.080618, 0.194200>, <0.833600, 0.695093, 0.180739>, <0.625828, 0.343493, 0.286133>, <0.430138, 0.000000, 0.317854>, 
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.800760, 1.167662, -0.400463>, <1.513638, 1.139103, -0.253815>, <1.315458, 1.119390, -0.123319>, 
      <1.783199, 1.603298, -0.482420>, <1.659057, 1.590950, -0.685224>, <1.430718, 1.546290, -0.314161>, <1.232537, 1.526577, -0.183665>, 
      <0.816377, 1.834805, -0.623440>, <0.609448, 1.754119, -0.537630>, <0.472855, 1.776875, -0.203174>, <0.558680, 1.810340, 0.016388>, 
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.075298, 0.730756, 0.104570>, <1.407161, 0.386517, 0.712205>, <1.205418, 0.000000, 1.066741>, 
      <1.800760, 1.167662, -0.400463>, <1.951156, 0.718408, -0.098234>, <1.539367, 0.386517, 0.514178>, <1.337625, 0.000000, 0.868714>, 
      <1.513638, 1.139103, -0.253815>, <1.594919, 0.739966, -0.194662>, <1.199848, 0.352635, 0.489912>, <1.083911, 0.000000, 0.667741>, 
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.783199, 1.603298, -0.482420>, <0.816377, 1.834805, -0.623440>, <0.478357, 2.171840, -0.394332>, 
      <2.080181, 1.195456, 0.056011>, <1.938478, 1.618744, -0.228749>, <1.075207, 1.935728, -0.730773>, <0.737188, 2.272763, -0.501665>, 
      <1.974128, 1.184907, 0.384530>, <2.085151, 1.579234, 0.179796>, <1.256151, 1.991230, -0.315348>, <1.020113, 2.383082, -0.337147>, 
      <1.726240, 1.160250, 0.547756>, <1.837264, 1.554577, 0.343022>, <1.363502, 2.033089, -0.040716>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.080181, 1.195456, 0.056011>, <1.974128, 1.184907, 0.384530>, <1.726240, 1.160250, 0.547756>, 
      <2.075298, 0.730756, 0.104570>, <2.230577, 0.746201, 0.358241>, <1.839840, 0.707952, 0.632165>, <1.591953, 0.683295, 0.795391>, 
      <1.407161, 0.386517, 0.712205>, <1.241794, 0.386517, 0.959900>, <1.056073, 0.380657, 1.172978>, <0.803756, 0.380657, 1.014753>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.203692, -0.044900, 0.570272>, <-0.461732, -0.044900, 0.481451>, <-0.765596, -0.033808, 0.611667>, <-0.847011, -0.033808, 0.872139>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.100977, -0.039005, 1.150867>, <-0.034548, -0.039005, 0.938339>, <0.006853, -0.044900, 0.642744>, <-0.203692, -0.044900, 0.570272>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.532826, -0.031427, 1.593172>, <-0.307686, -0.031427, 1.670667>, <-0.172011, -0.039005, 1.378128>, <-0.100977, -0.039005, 1.150867>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.532826, -0.031427, 1.593172>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.814433, -0.031427, 1.496239>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.935861, -0.033808, 1.156400>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.847011, -0.033808, 0.872139>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>, 
      <-1.135645, 4.923207, 0.490812>, <-1.083543, 4.894404, 0.490812>, <-1.016672, 4.849124, 0.499265>, <-0.961974, 4.827198, 0.490812>, 
      <-1.278876, 4.664117, 0.629223>, <-1.226775, 4.635314, 0.629223>, <-1.152234, 4.584241, 0.661968>, <-1.105205, 4.568108, 0.629223>, 
      <-1.318257, 4.592882, 0.889701>, <-1.266155, 4.564079, 0.889701>, <-1.191614, 4.513006, 0.922445>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>, 
      <-0.925682, 5.303006, 0.933545>, <-0.873581, 5.274203, 0.933545>, <-0.794448, 5.245746, 0.949092>, <-0.752011, 5.206996, 0.933545>, 
      <-0.908930, 5.333309, 0.652070>, <-0.856829, 5.304506, 0.652070>, <-0.789958, 5.259225, 0.660524>, <-0.735259, 5.237299, 0.652071>, 
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.111808, 4.843276, 1.592358>, <-1.020927, 4.813514, 1.627003>, <-0.990239, 4.776070, 1.592358>, 
      <-1.054981, 5.069119, 1.669837>, <-1.002880, 5.040316, 1.669837>, <-0.911999, 5.010554, 1.704482>, <-0.881310, 4.973110, 1.669837>, 
      <-0.992174, 5.182731, 1.373344>, <-0.940072, 5.153928, 1.373344>, <-0.860939, 5.125471, 1.388891>, <-0.818503, 5.086722, 1.373344>, 
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.300159, 4.625618, 1.495446>, <-1.361234, 4.515141, 1.173969>, <-1.318257, 4.592882, 0.889701>, 
      <-1.111808, 4.843276, 1.592358>, <-1.248058, 4.596816, 1.495446>, <-1.309132, 4.486338, 1.173969>, <-1.266155, 4.564079, 0.889701>, 
      <-1.020927, 4.813514, 1.627003>, <-1.157177, 4.567053, 1.530091>, <-1.234591, 4.435265, 1.206713>, <-1.191614, 4.513006, 0.922445>, 
      <-0.990239, 4.776070, 1.592358>, <-1.126488, 4.529609, 1.495446>, <-1.187563, 4.419132, 1.173969>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>, 
      <0.045326, 4.803767, 0.387696>, <0.001795, 4.757308, 0.122328>, <-0.247041, 4.434546, 0.099814>, <-0.427165, 4.242303, 0.171033>, 
      <-0.473949, 4.907449, 0.523488>, <-0.598796, 4.681614, 0.434686>, <-0.757509, 4.448831, 0.387136>, <-0.796890, 4.377596, 0.647614>, 
      <-0.837127, 5.053032, 0.579614>, <-0.961974, 4.827198, 0.490812>, <-1.105205, 4.568108, 0.629223>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>, 
      <-0.149898, 4.541390, 0.922230>, <-0.002929, 4.698247, 0.864120>, <0.080844, 4.841674, 0.604220>, <0.045326, 4.803767, 0.387696>, 
      <-0.508679, 4.897343, 1.045159>, <-0.476547, 4.955466, 0.832626>, <-0.372082, 5.091715, 0.595944>, <-0.473949, 4.907449, 0.523488>, 
      <-0.784143, 5.148873, 1.146078>, <-0.752011, 5.206996, 0.933545>, <-0.735259, 5.237299, 0.652071>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>, 
      <-0.581819, 4.032846, 0.952694>, <-0.543838, 4.073382, 1.184228>, <-0.307056, 4.373660, 0.984368>, <-0.149898, 4.541390, 0.922230>, 
      <-0.759944, 4.495076, 1.332377>, <-0.651016, 4.692116, 1.409856>, <-0.543038, 4.835191, 1.272425>, <-0.508679, 4.897343, 1.045159>, 
      <-0.990239, 4.776070, 1.592358>, <-0.881310, 4.973110, 1.669837>, <-0.818503, 5.086722, 1.373344>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.581819, 4.032846, 0.952694>, <-0.759944, 4.495076, 1.332377>, <-0.990239, 4.776070, 1.592358>, 
      <-0.369421, 3.794017, 0.352218>, <-0.629325, 3.982144, 0.663089>, <-0.896194, 4.248615, 1.235465>, <-1.126488, 4.529609, 1.495446>, 
      <-0.230350, 3.942443, 0.073090>, <-0.623741, 4.032504, 0.248756>, <-0.839867, 4.299855, 0.931882>, <-1.187563, 4.419132, 1.173969>, 
      <-0.033775, 4.152243, -0.004633>, <-0.427165, 4.242303, 0.171033>, <-0.796890, 4.377596, 0.647614>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>, 
      <1.025779, 4.093207, 0.381884>, <1.226493, 4.236390, 0.264894>, <1.126390, 4.232918, -0.129444>, <1.025457, 4.160915, -0.372554>, 
      <0.661213, 4.412504, 0.345586>, <0.617682, 4.366044, 0.080217>, <0.525790, 4.257618, -0.245289>, <0.345665, 4.065375, -0.174070>, 
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>, 
      <0.543731, 3.789628, 0.194518>, <0.626086, 3.848378, 0.392879>, <0.862010, 3.976379, 0.477340>, <1.025779, 4.093207, 0.381884>, 
      <0.319543, 4.046286, 0.610188>, <0.466513, 4.203143, 0.552078>, <0.696731, 4.450411, 0.562110>, <0.661213, 4.412504, 0.345586>, 
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>, 
      <0.327542, 3.702958, -0.411287>, <0.152420, 3.578032, -0.309213>, <0.455668, 3.726806, -0.017594>, <0.543731, 3.789628, 0.194518>, 
      <-0.040928, 3.641333, 0.305736>, <-0.002948, 3.681868, 0.537269>, <0.162385, 3.878556, 0.672326>, <0.319543, 4.046286, 0.610188>, 
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.327542, 3.702958, -0.411287>, <-0.040928, 3.641333, 0.305736>, <-0.321914, 3.844720, 0.641823>, 
      <0.979516, 3.665112, -0.629340>, <0.546587, 3.859218, -0.538961>, <-0.088435, 3.590630, 0.016131>, <-0.369421, 3.794017, 0.352218>, 
      <1.235997, 3.848078, -0.487834>, <0.915305, 4.082336, -0.637866>, <0.149090, 3.855576, -0.096347>, <-0.230350, 3.942443, 0.073090>, 
      <1.346149, 3.926657, -0.222522>, <1.025457, 4.160915, -0.372554>, <0.345665, 4.065375, -0.174070>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>, 
      <1.296997, 2.879843, 0.733703>, <1.445934, 2.937916, 0.954880>, <1.774379, 3.091461, 0.797898>, <1.976107, 3.170119, 0.631788>, 
      <1.307648, 3.418247, 0.518613>, <1.508362, 3.561430, 0.401624>, <1.841102, 3.710837, 0.204924>, <1.740168, 3.638834, -0.038185>, 
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>, 
      <1.385444, 2.888728, 0.148511>, <1.220847, 2.824548, 0.284046>, <1.175475, 2.832459, 0.553237>, <1.296997, 2.879843, 0.733703>, 
      <0.987091, 3.240061, 0.036852>, <1.069446, 3.298811, 0.235213>, <1.143879, 3.301419, 0.614069>, <1.307648, 3.418247, 0.518613>, 
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>, 
      <1.906742, 3.131796, -0.157567>, <1.776795, 3.081127, -0.350543>, <1.561452, 2.957357, 0.003581>, <1.385444, 2.888728, 0.148511>, 
      <1.194126, 3.314419, -0.592195>, <1.019004, 3.189493, -0.490122>, <0.899027, 3.177239, -0.175260>, <0.987091, 3.240061, 0.036852>, 
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.906742, 3.131796, -0.157567>, <1.194126, 3.314419, -0.592195>, <0.760471, 3.508852, -0.501665>, 
      <2.208483, 2.846450, 0.388885>, <2.069281, 3.195173, 0.083810>, <1.413171, 3.470679, -0.719869>, <0.979516, 3.665112, -0.629340>, 
      <2.132199, 2.816706, 0.724413>, <2.196260, 3.255960, 0.450507>, <1.630017, 3.560256, -0.303498>, <1.235997, 3.848078, -0.487834>, 
      <1.912047, 2.730864, 0.905694>, <1.976107, 3.170119, 0.631788>, <1.740168, 3.638834, -0.038185>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.727308, 1.060887, 1.042327>, <0.729459, 1.061101, 1.369123>, <0.931165, 1.081165, 1.551842>, 
      <1.130039, 1.453072, 0.877157>, <0.942531, 1.434421, 1.074558>, <1.157661, 1.492077, 1.371658>, <1.359367, 1.512140, 1.554376>, 
      <1.224179, 2.051219, 0.856463>, <1.373116, 2.109292, 1.077641>, <1.635704, 2.140586, 1.390835>, <1.837433, 2.219244, 1.224725>, 
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>, 
      <0.727308, 1.060887, 1.042327>, <0.495765, 0.659030, 1.007652>, <-0.127188, 0.350771, 0.563600>, <-0.423769, 0.000000, 0.490773>, 
      <0.729459, 1.061101, 1.369123>, <0.275535, 0.604236, 1.366437>, <-0.224661, 0.365743, 0.818438>, <-0.719824, 0.000000, 0.629163>, 
      <0.931165, 1.081165, 1.551842>, <0.477241, 0.624300, 1.549155>, <-0.306076, 0.365743, 1.078910>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.307934, 1.118641, 0.832847>, <1.067810, 1.094756, 0.683860>, <0.914816, 1.079538, 0.844926>, 
      <1.709058, 1.529154, 0.846782>, <1.544479, 1.512783, 0.697696>, <1.283033, 1.468290, 0.716091>, <1.130039, 1.453072, 0.877157>, 
      <1.610751, 2.129575, 0.425166>, <1.446154, 2.065395, 0.560700>, <1.102656, 2.003834, 0.675998>, <1.224179, 2.051219, 0.856463>, 
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>, 
      <1.307934, 1.118641, 0.832847>, <1.024882, 0.647009, 0.994571>, <0.440830, 0.375638, 0.887301>, <0.010170, 0.000000, 0.933538>, 
      <1.067810, 1.094756, 0.683860>, <0.836267, 0.692899, 0.649185>, <0.341396, 0.350771, 0.724892>, <0.044816, 0.000000, 0.652066>, 
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.862654, 1.173819, 1.383110>, <1.648500, 1.152517, 1.141355>, <1.472513, 1.135012, 0.981934>, 
      <2.109209, 1.609047, 1.320949>, <2.272809, 1.625320, 1.148717>, <1.885046, 1.546659, 1.006204>, <1.709058, 1.529154, 0.846782>, 
      <2.233965, 2.312047, 0.559578>, <2.104018, 2.261378, 0.366603>, <1.786758, 2.198203, 0.280236>, <1.610751, 2.129575, 0.425166>, 
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.234013, 0.645627, 1.821099>, <0.146906, 0.391119, 1.581650>, <-0.482271, 0.000000, 1.592315>, 
      <1.862654, 1.173819, 1.383110>, <1.397613, 0.661900, 1.648868>, <0.372045, 0.391119, 1.659146>, <-0.257132, 0.000000, 1.669811>, 
      <1.648500, 1.152517, 1.141355>, <1.365448, 0.680885, 1.303079>, <0.303367, 0.375638, 1.327090>, <-0.127293, 0.000000, 1.373327>, 
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <2.109209, 1.609047, 1.320949>, <2.233965, 2.312047, 0.559578>, <2.045943, 2.783073, 0.147508>, 
      <1.494421, 1.137191, 1.770770>, <1.904576, 1.588692, 1.536377>, <2.396504, 2.375424, 0.800956>, <2.208483, 2.846450, 0.388885>, 
      <1.151293, 1.103061, 1.751248>, <1.579494, 1.534036, 1.753783>, <2.057585, 2.305086, 1.043444>, <2.132199, 2.816706, 0.724413>, 
      <0.931165, 1.081165, 1.551842>, <1.359367, 1.512140, 1.554376>, <1.837433, 2.219244, 1.224725>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.494421, 1.137191, 1.770770>, <1.151293, 1.103061, 1.751248>, <0.931165, 1.081165, 1.551842>, 
      <1.234013, 0.645627, 1.821099>, <1.029380, 0.625272, 2.036528>, <0.697369, 0.646196, 1.748562>, <0.477241, 0.624300, 1.549155>, 
      <0.146906, 0.391119, 1.581650>, <-0.134701, 0.391119, 1.484718>, <-0.394926, 0.365743, 1.363171>, <-0.306076, 0.365743, 1.078910>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.492124, -0.059010, 0.000093>, <0.492124, -0.059010, -0.272806>, <0.272471, -0.050458, -0.539386>, <-0.000317, -0.050458, -0.531592>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <-0.029004, -0.050709, 0.276410>, <0.193573, -0.050709, 0.270050>, <0.492124, -0.059010, 0.222761>, <0.492124, -0.059010, 0.000093>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.588494, -0.041496, -0.002015>, <-0.588494, -0.041496, 0.236088>, <-0.267011, -0.050709, 0.283210>, <-0.029004, -0.050709, 0.276410>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.588494, -0.041496, -0.002015>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.588494, -0.041496, -0.299839>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.298019, -0.050458, -0.523086>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <-0.000317, -0.050458, -0.531592>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>, 
      <-0.688738, 5.731613, -0.272928>, <-0.636637, 5.702810, -0.272928>, <-0.568524, 5.652551, -0.292911>, <-0.515067, 5.635604, -0.272929>, 
      <-0.798675, 5.532749, -0.507806>, <-0.746574, 5.503946, -0.507806>, <-0.683223, 5.435931, -0.520220>, <-0.625004, 5.436739, -0.507806>, 
      <-0.930654, 5.294014, -0.499992>, <-0.878553, 5.265211, -0.499992>, <-0.815202, 5.197196, -0.512406>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>, 
      <-0.822940, 5.488857, 0.281511>, <-0.770839, 5.460054, 0.281511>, <-0.706292, 5.409803, 0.279281>, <-0.649269, 5.392847, 0.281511>, 
      <-0.688721, 5.731645, 0.222639>, <-0.636619, 5.702842, 0.222639>, <-0.568507, 5.652583, 0.202657>, <-0.515049, 5.635636, 0.222639>, 
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.149764, 4.774619, 0.030352>, <-1.086901, 4.708347, 0.040188>, <-1.028194, 4.707412, 0.030352>, 
      <-1.201857, 4.803437, 0.268456>, <-1.149755, 4.774634, 0.268456>, <-1.086893, 4.708363, 0.278291>, <-1.028186, 4.707428, 0.268456>, 
      <-1.045777, 5.085768, 0.294705>, <-0.993676, 5.056965, 0.294705>, <-0.929129, 5.006715, 0.292475>, <-0.872106, 4.989758, 0.294705>, 
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.201876, 4.803403, -0.267471>, <-1.074687, 5.033474, -0.491465>, <-0.930654, 5.294014, -0.499992>, 
      <-1.149764, 4.774619, 0.030352>, <-1.149774, 4.774600, -0.267471>, <-1.022585, 5.004672, -0.491465>, <-0.878553, 5.265211, -0.499992>, 
      <-1.086901, 4.708347, 0.040188>, <-1.086912, 4.708328, -0.257636>, <-0.959234, 4.936656, -0.503879>, <-0.815202, 5.197196, -0.512406>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028205, 4.707393, -0.267471>, <-0.901015, 4.937464, -0.491464>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>, 
      <0.673433, 5.542398, 0.382051>, <0.830828, 5.710382, 0.235482>, <0.742311, 5.615008, -0.169149>, <0.637642, 5.503297, -0.395068>, 
      <-0.070189, 5.494588, 0.166260>, <-0.070199, 5.494571, -0.106640>, <-0.075813, 5.444359, -0.390701>, <-0.207791, 5.205623, -0.382888>, 
      <-0.515057, 5.635621, -0.000029>, <-0.515067, 5.635604, -0.272929>, <-0.625004, 5.436739, -0.507806>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>, 
      <0.264924, 5.071978, 0.264958>, <0.350327, 5.163126, 0.449294>, <0.545009, 5.405335, 0.501642>, <0.673433, 5.542398, 0.382051>, 
      <-0.350982, 5.077334, 0.303765>, <-0.243295, 5.272127, 0.297389>, <-0.070181, 5.494603, 0.388928>, <-0.070189, 5.494588, 0.166260>, 
      <-0.756955, 5.198054, 0.287887>, <-0.649269, 5.392847, 0.281511>, <-0.515049, 5.635636, 0.222639>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>, 
      <0.085454, 4.866228, -0.353558>, <-0.051873, 4.719663, -0.225676>, <0.173601, 4.974511, 0.067845>, <0.264924, 5.071978, 0.264958>, 
      <-0.552806, 4.699840, -0.049293>, <-0.552798, 4.699856, 0.188811>, <-0.466133, 4.869038, 0.310582>, <-0.350982, 5.077334, 0.303765>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028186, 4.707428, 0.268456>, <-0.872106, 4.989758, 0.294705>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.085454, 4.866228, -0.353558>, <-0.552806, 4.699840, -0.049293>, <-1.028194, 4.707412, 0.030352>, 
      <0.721979, 4.958841, -0.423140>, <0.257223, 5.049553, -0.513513>, <-0.552817, 4.699822, -0.347116>, <-1.028205, 4.707393, -0.267471>, 
      <0.947700, 5.199747, -0.321664>, <0.523414, 5.381385, -0.641620>, <-0.351824, 4.945084, -0.374360>, <-0.901015, 4.937464, -0.491464>, 
      <1.061928, 5.321660, -0.075112>, <0.637642, 5.503297, -0.395068>, <-0.207791, 5.205623, -0.382888>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>, 
      <1.176418, 4.228400, 1.281084>, <1.331799, 4.339244, 1.476134>, <1.598674, 4.553109, 1.259562>, <1.752959, 4.663172, 1.063204>, 
      <1.237274, 4.881539, 0.845362>, <1.394669, 5.049523, 0.698793>, <1.602658, 5.246691, 0.479642>, <1.497990, 5.134981, 0.253723>, 
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>, 
      <1.168489, 4.198111, 0.682275>, <1.042602, 4.108307, 0.842491>, <1.049638, 4.137958, 1.121936>, <1.176418, 4.228400, 1.281084>, 
      <0.909517, 4.629264, 0.421284>, <0.994920, 4.720412, 0.605619>, <1.108851, 4.744476, 0.964953>, <1.237274, 4.881539, 0.845362>, 
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>, 
      <1.584124, 4.531858, 0.291211>, <1.448555, 4.435146, 0.121030>, <1.303102, 4.294140, 0.510954>, <1.168489, 4.198111, 0.682275>, 
      <0.993460, 4.689001, -0.176992>, <0.856133, 4.542436, -0.049111>, <0.818194, 4.531798, 0.224171>, <0.909517, 4.629264, 0.421284>, 
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.584124, 4.531858, 0.291211>, <0.993460, 4.689001, -0.176992>, <0.550210, 4.775516, -0.263184>, 
      <1.864985, 4.296779, 0.772832>, <1.753695, 4.652825, 0.504075>, <1.165229, 4.872326, -0.336948>, <0.721979, 4.958841, -0.423140>, 
      <1.839537, 4.278626, 1.116789>, <1.921335, 4.783286, 0.848912>, <1.383762, 5.013069, 0.007171>, <0.947700, 5.199747, -0.321664>, 
      <1.671161, 4.158511, 1.331080>, <1.752959, 4.663172, 1.063204>, <1.497990, 5.134981, 0.253723>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>, 
      <0.518744, 2.630839, 1.116586>, <0.372372, 2.573766, 1.339727>, <0.646578, 2.695348, 1.627582>, <0.858569, 2.778007, 1.778251>, 
      <1.007584, 3.225212, 1.369456>, <1.162965, 3.336056, 1.564507>, <1.420558, 3.454205, 1.842865>, <1.574843, 3.564268, 1.646507>, 
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>, 
      <1.058881, 2.809064, 0.967556>, <0.885910, 2.741619, 0.844621>, <0.638173, 2.677407, 0.934517>, <0.518744, 2.630839, 1.116586>, 
      <1.287745, 3.405068, 0.871225>, <1.161858, 3.315264, 1.031441>, <0.880804, 3.134771, 1.210308>, <1.007584, 3.225212, 1.369456>, 
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>, 
      <1.511433, 3.014108, 1.399758>, <1.639141, 3.063904, 1.205068>, <1.243843, 2.881184, 1.099014>, <1.058881, 2.809064, 0.967556>, 
      <1.838591, 3.717745, 0.905735>, <1.703022, 3.621034, 0.735555>, <1.422358, 3.501097, 0.699904>, <1.287745, 3.405068, 0.871225>, 
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.511433, 3.014108, 1.399758>, <1.838591, 3.717745, 0.905735>, <1.695413, 4.175812, 0.559968>, 
      <1.108081, 2.417382, 1.713333>, <1.351693, 2.951822, 1.643279>, <2.008162, 3.838712, 1.118599>, <1.864985, 4.296779, 0.772832>, 
      <0.787669, 2.292448, 1.745119>, <1.089922, 2.868216, 1.942679>, <1.743219, 3.684382, 1.432216>, <1.839537, 4.278626, 1.116789>, 
      <0.556317, 2.202239, 1.580690>, <0.858569, 2.778007, 1.778251>, <1.574843, 3.564268, 1.646507>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.420517, 1.030371, -0.115902>, <0.113731, 0.999855, -0.007496>, <0.007458, 0.989284, 0.243639>, 
      <0.656890, 1.452521, 0.160879>, <0.410125, 1.427975, 0.046953>, <0.215961, 1.404545, 0.374858>, <0.109689, 1.393974, 0.625992>, 
      <0.382882, 1.776536, 0.696127>, <0.236511, 1.719463, 0.919268>, <0.092582, 1.640028, 1.265476>, <0.304574, 1.722688, 1.416144>, 
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>, 
      <0.420517, 1.030371, -0.115902>, <0.428264, 0.733937, -0.237318>, <0.542391, 0.317613, -0.273400>, <0.500000, 0.000000, -0.272899>, 
      <0.113731, 0.999855, -0.007496>, <0.046675, 0.734409, -0.258291>, <0.274764, 0.314693, -0.310764>, <0.272788, 0.000000, -0.507794>, 
      <0.007458, 0.989284, 0.243639>, <-0.059597, 0.723838, -0.007156>, <0.001976, 0.314693, -0.302970>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.806595, 1.068774, 0.367641>, <0.868625, 1.074944, 0.090980>, <0.667281, 1.054916, -0.001976>, 
      <0.873382, 1.431312, 0.674253>, <0.960093, 1.439937, 0.469344>, <0.858233, 1.472548, 0.253834>, <0.656890, 1.452521, 0.160879>, 
      <0.905311, 1.960277, 0.907859>, <0.732340, 1.892832, 0.784924>, <0.502312, 1.823104, 0.514058>, <0.382882, 1.776536, 0.696127>, 
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>, 
      <0.806595, 1.068774, 0.367641>, <0.660698, 0.715990, 0.270974>, <0.414440, 0.335439, 0.357390>, <0.222577, 0.000000, 0.281520>, 
      <0.868625, 1.074944, 0.090980>, <0.876372, 0.778509, -0.030436>, <0.542391, 0.317613, 0.222167>, <0.500000, 0.000000, 0.222668>, 
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.469393, 1.035233, 1.073839>, <0.627162, 1.050926, 0.791664>, <0.719884, 1.060148, 0.572550>, 
      <0.552471, 1.418471, 1.209352>, <0.767772, 1.439887, 1.308751>, <0.780660, 1.422089, 0.893366>, <0.873382, 1.431312, 0.674253>, 
      <1.039269, 1.978267, 1.535535>, <1.166978, 2.028063, 1.340846>, <1.090273, 2.032397, 1.039317>, <0.905311, 1.960277, 0.907859>, 
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.005147, 0.662242, 0.770342>, <-0.334748, 0.336073, 0.292045>, <-0.560606, 0.000000, 0.030303>, 
      <0.469393, 1.035233, 1.073839>, <0.210153, 0.683658, 0.869742>, <-0.334748, 0.336073, 0.530148>, <-0.560606, 0.000000, 0.268407>, 
      <0.627162, 1.050926, 0.791664>, <0.481265, 0.698142, 0.694997>, <-0.046144, 0.335439, 0.370549>, <-0.238007, 0.000000, 0.294679>, 
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.552471, 1.418471, 1.209352>, <1.039269, 1.978267, 1.535535>, <1.267821, 2.479668, 1.469812>, 
      <-0.015209, 0.987030, 0.850110>, <0.283170, 1.391684, 1.085022>, <0.879530, 1.915981, 1.779056>, <1.108081, 2.417382, 1.713333>, 
      <-0.108520, 0.977748, 0.517710>, <-0.006289, 1.382438, 0.900063>, <0.535927, 1.812897, 1.580573>, <0.787669, 2.292448, 1.745119>, 
      <0.007458, 0.989284, 0.243639>, <0.109689, 1.393974, 0.625992>, <0.304574, 1.722688, 1.416144>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.015209, 0.987030, 0.850110>, <-0.108520, 0.977748, 0.517710>, <0.007458, 0.989284, 0.243639>, 
      <-0.005147, 0.662242, 0.770342>, <-0.274448, 0.635455, 0.646012>, <-0.175575, 0.712302, 0.266914>, <-0.059597, 0.723838, -0.007156>, 
      <-0.334748, 0.336073, 0.292045>, <-0.334748, 0.336073, -0.005778>, <-0.295726, 0.314693, -0.294464>, <0.001976, 0.314693, -0.302970>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.379391, -0.15447, -0.074957>
}
#declare segMcurvedMA5 = union {
  object { // Blatt69->Blatt23
    Blatt23
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <0.363186, -1.686824, -1.535598>
  }
  object { // Blatt70->Blatt23
    Blatt23
    rotate <-11.451855, -9.808147, -149.316727>
    translate  <0.806828, -1.041412, 1.867508>
  }
  object { Blatt71 }
  object { sPatchObj24 }
  translate  <-4.142576, 0.228532, 39.210156>
}
#declare BezPtch025 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt74 = union {
  cone { // Cone025
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch025 }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <0.385118, 32.014065, 18.410421>
  translate  <-0.898673, 2.35502, 2.682482>
}
#declare sPatchObj25 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.340629, -0.048589, 0.507365>, <0.189102, -0.048589, 0.734332>, <0.231778, -0.052353, 1.073207>, <0.462979, -0.052353, 1.218190>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.919612, -0.041919, 0.560905>, <0.730967, -0.041919, 0.442608>, <0.464265, -0.048589, 0.322176>, <0.340629, -0.048589, 0.507365>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.233336, -0.039157, 1.101834>, <1.365543, -0.039157, 0.903807>, <1.121334, -0.041919, 0.687401>, <0.919612, -0.041919, 0.560905>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.233336, -0.039157, 1.101834>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.067970, -0.039157, 1.349529>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.715296, -0.052353, 1.376415>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.462979, -0.052353, 1.218190>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.927710, 5.273737, 0.503044>, <1.873548, 5.248850, 0.503044>, <1.806484, 5.195710, 0.506258>, <1.747169, 5.190782, 0.503044>, 
      <1.857771, 5.408004, 0.730086>, <1.803609, 5.383118, 0.730086>, <1.736545, 5.329978, 0.733299>, <1.677230, 5.325050, 0.730086>, 
      <1.884717, 5.356273, 1.051407>, <1.830555, 5.331386, 1.051407>, <1.759441, 5.288747, 1.067554>, <1.704177, 5.273318, 1.051407>, 
      <1.991485, 5.151303, 1.196511>, <1.937323, 5.126416, 1.196511>, <1.866209, 5.083778, 1.212658>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.193337, 4.763793, 0.541244>, <2.139175, 4.738906, 0.541244>, <2.070209, 4.678722, 0.557129>, <2.012797, 4.680837, 0.541244>, 
      <2.106324, 4.930838, 0.422988>, <2.052162, 4.905951, 0.422988>, <1.983195, 4.845766, 0.438872>, <1.925784, 4.847882, 0.422988>, 
      <1.984709, 5.164313, 0.318011>, <1.930546, 5.139426, 0.318011>, <1.863483, 5.086286, 0.321225>, <1.804168, 5.081358, 0.318011>, 
      <1.927710, 5.273737, 0.503044>, <1.873548, 5.248850, 0.503044>, <1.806484, 5.195710, 0.506258>, <1.747169, 5.190782, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.342479, 4.477476, 1.066741>, <2.288317, 4.452589, 1.066741>, <2.213522, 4.395900, 1.096576>, <2.161939, 4.394520, 1.066741>, 
      <2.403483, 4.360362, 0.868706>, <2.349321, 4.335476, 0.868706>, <2.274526, 4.278786, 0.898541>, <2.222943, 4.277406, 0.868706>, 
      <2.286464, 4.585010, 0.667810>, <2.232302, 4.560124, 0.667810>, <2.163336, 4.499938, 0.683694>, <2.105925, 4.502054, 0.667810>, 
      <2.193337, 4.763793, 0.541244>, <2.139175, 4.738906, 0.541244>, <2.070209, 4.678722, 0.557129>, <2.012797, 4.680837, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.342479, 4.477476, 1.066741>, <2.266240, 4.623838, 1.314234>, <2.107870, 4.927870, 1.354686>, <1.991485, 5.151303, 1.196511>, 
      <2.288317, 4.452589, 1.066741>, <2.212078, 4.598951, 1.314234>, <2.053708, 4.902983, 1.354686>, <1.937323, 5.126416, 1.196511>, 
      <2.213522, 4.395900, 1.096576>, <2.137283, 4.542262, 1.344069>, <1.982594, 4.860344, 1.370832>, <1.866209, 5.083778, 1.212658>, 
      <2.161939, 4.394520, 1.066741>, <2.085700, 4.540882, 1.314234>, <1.927330, 4.844914, 1.354686>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.242778, 5.093405, 0.385449>, <-0.173443, 5.029640, 0.641281>, <0.043064, 4.830526, 0.783311>, <0.229252, 4.659296, 0.681636>, 
      <0.261106, 5.414866, 0.350063>, <0.330441, 5.351100, 0.605895>, <0.513663, 5.036670, 0.772500>, <0.699851, 4.865440, 0.670825>, 
      <1.151354, 5.141280, 0.470763>, <1.081415, 5.275547, 0.697805>, <1.227729, 5.140296, 0.912202>, <1.334497, 4.935326, 1.057306>, 
      <1.747169, 5.190782, 0.503044>, <1.677230, 5.325050, 0.730086>, <1.704177, 5.273318, 1.051407>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.028904, 4.843549, -0.057609>, <-0.123091, 4.983332, 0.025393>, <-0.299380, 5.145459, 0.176600>, <-0.242778, 5.093405, 0.385449>, 
      <0.570190, 5.125650, -0.185329>, <0.418196, 5.265433, -0.102327>, <0.204504, 5.466920, 0.141214>, <0.261106, 5.414866, 0.350063>, 
      <1.412151, 4.702970, 0.375058>, <1.325137, 4.870015, 0.256802>, <1.208353, 5.031855, 0.285730>, <1.151354, 5.141280, 0.470763>, 
      <2.012797, 4.680837, 0.541244>, <1.925784, 4.847882, 0.422988>, <1.804168, 5.081358, 0.318011>, <1.747169, 5.190782, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481092, 4.427689, -0.009847>, <0.420610, 4.483312, -0.233013>, <0.191318, 4.694183, -0.146301>, <0.028904, 4.843549, -0.057609>, 
      <1.034920, 4.613283, -0.142190>, <0.974438, 4.668905, -0.365355>, <0.732604, 4.976284, -0.274022>, <0.570190, 5.125650, -0.185329>, 
      <1.643644, 4.380657, 0.766970>, <1.704648, 4.263543, 0.568935>, <1.505278, 4.524187, 0.501624>, <1.412151, 4.702970, 0.375058>, 
      <2.161939, 4.394520, 1.066741>, <2.222943, 4.277406, 0.868706>, <2.105925, 4.502054, 0.667810>, <2.012797, 4.680837, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481092, 4.427689, -0.009847>, <1.034920, 4.613283, -0.142190>, <1.643644, 4.380657, 0.766970>, <2.161939, 4.394520, 1.066741>, 
      <0.556818, 4.358047, 0.269566>, <1.110646, 4.543641, 0.137223>, <1.567404, 4.527019, 1.014463>, <2.085700, 4.540882, 1.314234>, 
      <0.432601, 4.472283, 0.570590>, <0.903201, 4.678427, 0.559779>, <1.450882, 4.711893, 1.215481>, <1.927330, 4.844914, 1.354686>, 
      <0.229252, 4.659296, 0.681636>, <0.699851, 4.865440, 0.670825>, <1.334497, 4.935326, 1.057306>, <1.810945, 5.068348, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.745773, 3.600371, 0.678117>, <-0.978217, 3.733614, 0.729427>, <-1.140940, 3.826891, 0.996770>, <-1.089917, 3.797643, 1.263149>, 
      <-0.659245, 4.070709, 0.629152>, <-0.891689, 4.203952, 0.680462>, <-0.885404, 4.246575, 0.885237>, <-0.834381, 4.217327, 1.151616>, 
      <-0.647350, 4.835302, 0.413861>, <-0.578015, 4.771537, 0.669694>, <-0.418355, 4.628405, 0.793910>, <-0.232167, 4.457174, 0.692236>, 
      <-0.242778, 5.093405, 0.385449>, <-0.173443, 5.029640, 0.641281>, <0.043064, 4.830526, 0.783311>, <0.229252, 4.659296, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.419372, 3.413269, 1.115132>, <-0.460998, 3.437130, 0.897814>, <-0.556140, 3.491668, 0.636257>, <-0.745773, 3.600371, 0.678117>, 
      <-0.338335, 3.930586, 0.887549>, <-0.379961, 3.954447, 0.670231>, <-0.469612, 3.962006, 0.587292>, <-0.659245, 4.070709, 0.629152>, 
      <-0.466672, 4.585270, 0.059326>, <-0.618667, 4.725054, 0.142328>, <-0.703951, 4.887356, 0.205012>, <-0.647350, 4.835302, 0.413861>, 
      <0.028904, 4.843549, -0.057609>, <-0.123091, 4.983332, 0.025393>, <-0.299380, 5.145459, 0.176600>, <-0.242778, 5.093405, 0.385449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.547328, 3.486617, 1.714146>, <-0.344458, 3.370326, 1.669364>, <-0.374840, 3.387742, 1.347620>, <-0.419372, 3.413269, 1.115132>, 
      <-0.323254, 3.978559, 1.326626>, <-0.120383, 3.862268, 1.281845>, <-0.293804, 3.905059, 1.120037>, <-0.338335, 3.930586, 0.887549>, 
      <-0.133971, 4.221575, 0.137128>, <-0.194453, 4.277198, -0.086037>, <-0.304258, 4.435904, -0.029366>, <-0.466672, 4.585270, 0.059326>, 
      <0.481092, 4.427689, -0.009847>, <0.420610, 4.483312, -0.233013>, <0.191318, 4.694183, -0.146301>, <0.028904, 4.843549, -0.057609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.547328, 3.486617, 1.714146>, <-0.323254, 3.978559, 1.326626>, <-0.133971, 4.221575, 0.137128>, <0.481092, 4.427689, -0.009847>, 
      <-0.800894, 3.631968, 1.770118>, <-0.576819, 4.123910, 1.382599>, <-0.058246, 4.151933, 0.416541>, <0.556818, 4.358047, 0.269566>, 
      <-1.034257, 3.765737, 1.553734>, <-0.778721, 4.185422, 1.442201>, <-0.028817, 4.270162, 0.581189>, <0.432601, 4.472283, 0.570590>, 
      <-1.089917, 3.797643, 1.263149>, <-0.834381, 4.217327, 1.151616>, <-0.232167, 4.457174, 0.692236>, <0.229252, 4.659296, 0.681636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.750394, 2.334157, 0.672703>, <-1.003252, 2.418574, 0.730646>, <-1.174829, 2.475855, 1.002549>, <-1.112804, 2.455148, 1.267398>, 
      <-0.769198, 2.710940, 0.717229>, <-1.022056, 2.795356, 0.775172>, <-1.321620, 2.842865, 1.080080>, <-1.259595, 2.822158, 1.344929>, 
      <-0.814147, 3.228713, 0.716809>, <-1.046590, 3.361956, 0.768119>, <-1.345228, 3.491374, 1.085935>, <-1.294205, 3.462127, 1.352314>, 
      <-0.745773, 3.600371, 0.678117>, <-0.978217, 3.733614, 0.729427>, <-1.140940, 3.826891, 0.996770>, <-1.089917, 3.797643, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.383381, 2.211630, 1.100248>, <-0.433979, 2.228522, 0.884191>, <-0.544119, 2.265292, 0.625434>, <-0.750394, 2.334157, 0.672703>, 
      <-0.405656, 2.533325, 1.261825>, <-0.456254, 2.550217, 1.045768>, <-0.562923, 2.642075, 0.669960>, <-0.769198, 2.710940, 0.717229>, 
      <-0.470565, 3.086466, 1.258902>, <-0.512191, 3.110327, 1.041584>, <-0.624513, 3.120011, 0.674949>, <-0.814147, 3.228713, 0.716809>, 
      <-0.419372, 3.413269, 1.115132>, <-0.460998, 3.437130, 0.897814>, <-0.556140, 3.491668, 0.636257>, <-0.745773, 3.600371, 0.678117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.509171, 2.253626, 1.702737>, <-0.288487, 2.179951, 1.652167>, <-0.329248, 2.193558, 1.331397>, <-0.383381, 2.211630, 1.100248>, 
      <-0.614355, 2.545119, 1.905061>, <-0.393671, 2.471444, 1.854490>, <-0.351524, 2.515253, 1.492974>, <-0.405656, 2.533325, 1.261825>, 
      <-0.672009, 3.212889, 1.929771>, <-0.469138, 3.096598, 1.884989>, <-0.426034, 3.060939, 1.491390>, <-0.470565, 3.086466, 1.258902>, 
      <-0.547328, 3.486617, 1.714146>, <-0.344458, 3.370326, 1.669364>, <-0.374840, 3.387742, 1.347620>, <-0.419372, 3.413269, 1.115132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.509171, 2.253626, 1.702737>, <-0.614355, 2.545119, 1.905061>, <-0.672009, 3.212889, 1.929771>, <-0.547328, 3.486617, 1.714146>, 
      <-0.784990, 2.345708, 1.765942>, <-0.890174, 2.637202, 1.968266>, <-0.925574, 3.358240, 1.985744>, <-0.800894, 3.631968, 1.770118>, 
      <-1.045147, 2.432561, 1.556297>, <-1.191938, 2.799572, 1.633827>, <-1.238546, 3.430221, 1.642898>, <-1.034257, 3.765737, 1.553734>, 
      <-1.112804, 2.455148, 1.267398>, <-1.259595, 2.822158, 1.344929>, <-1.294205, 3.462127, 1.352314>, <-1.089917, 3.797643, 1.263149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.622173, 1.123786, 0.385449>, <-0.529479, 1.112239, 0.640395>, <-0.238747, 1.076023, 0.783329>, <0.011080, 1.044903, 0.681636>, 
      <-0.776587, 1.464810, 0.410237>, <-0.683893, 1.453264, 0.665183>, <-0.543365, 1.556197, 0.797193>, <-0.293538, 1.525078, 0.695500>, 
      <-0.731822, 1.962032, 0.628727>, <-0.984680, 2.046448, 0.686671>, <-0.967542, 1.957590, 0.893066>, <-0.905517, 1.936884, 1.157915>, 
      <-0.750394, 2.334157, 0.672703>, <-1.003252, 2.418574, 0.730646>, <-1.174829, 2.475855, 1.002549>, <-1.112804, 2.455148, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.622173, 1.123786, 0.385449>, <-0.441582, 0.724949, 0.356459>, <0.054978, 0.358114, 0.471194>, <0.306502, 0.000000, 0.503044>, 
      <-0.529479, 1.112239, 0.640395>, <-0.348887, 0.713402, 0.611406>, <-0.096549, 0.358114, 0.698161>, <0.154975, 0.000000, 0.730010>, 
      <-0.238747, 1.076023, 0.783329>, <-0.039053, 0.761243, 0.774240>, <0.099152, 0.327914, 0.915737>, <0.213519, 0.000000, 1.051528>, 
      <0.011080, 1.044903, 0.681636>, <0.210774, 0.730123, 0.672547>, <0.330354, 0.327914, 1.060720>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.257697, 1.078384, -0.057609>, <-0.462060, 1.103841, 0.025578>, <-0.697999, 1.133231, 0.176898>, <-0.622173, 1.123786, 0.385449>, 
      <-0.494200, 1.491681, 0.046855>, <-0.698563, 1.517138, 0.130041>, <-0.852413, 1.474256, 0.201685>, <-0.776587, 1.464810, 0.410237>, 
      <-0.353273, 1.776820, 0.881856>, <-0.403872, 1.793712, 0.665799>, <-0.525547, 1.893167, 0.581459>, <-0.731822, 1.962032, 0.628727>, 
      <-0.383381, 2.211630, 1.100248>, <-0.433979, 2.228522, 0.884191>, <-0.544119, 2.265292, 0.625434>, <-0.750394, 2.334157, 0.672703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.257697, 1.078384, -0.057609>, <-0.013258, 0.651218, -0.165578>, <0.565457, 0.354783, 0.374845>, <0.882189, 0.000000, 0.541244>, 
      <-0.462060, 1.103841, 0.025578>, <-0.217621, 0.676674, -0.082391>, <0.376812, 0.354783, 0.256548>, <0.693544, 0.000000, 0.422947>, 
      <-0.697999, 1.133231, 0.176898>, <-0.517407, 0.734395, 0.147908>, <0.178614, 0.358114, 0.286005>, <0.430138, 0.000000, 0.317854>, 
      <-0.622173, 1.123786, 0.385449>, <-0.441582, 0.724949, 0.356459>, <0.054978, 0.358114, 0.471194>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <0.268147, 1.012882, -0.232052>, <-0.039953, 1.051260, -0.146243>, <-0.257697, 1.078384, -0.057609>, 
      <-0.056527, 1.535754, 0.140554>, <-0.137318, 1.545818, -0.081653>, <-0.276456, 1.464558, -0.041779>, <-0.494200, 1.491681, 0.046855>, 
      <-0.314110, 1.713057, 1.327531>, <-0.093426, 1.639382, 1.276960>, <-0.299141, 1.758749, 1.113005>, <-0.353273, 1.776820, 0.881856>, 
      <-0.509171, 2.253626, 1.702737>, <-0.288487, 2.179951, 1.652167>, <-0.329248, 2.193558, 1.331397>, <-0.383381, 2.211630, 1.100248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <0.650663, 0.606236, -0.121766>, <0.965912, 0.335921, 0.765684>, <1.205418, 0.000000, 1.066741>, 
      <0.268147, 1.012882, -0.232052>, <0.569873, 0.616300, -0.343972>, <1.098118, 0.335921, 0.567657>, <1.337625, 0.000000, 0.868714>, 
      <-0.039953, 1.051260, -0.146243>, <0.204486, 0.624094, -0.254212>, <0.767179, 0.354783, 0.501342>, <1.083911, 0.000000, 0.667741>, 
      <-0.257697, 1.078384, -0.057609>, <-0.013258, 0.651218, -0.165578>, <0.565457, 0.354783, 0.374845>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <-0.056527, 1.535754, 0.140554>, <-0.314110, 1.713057, 1.327531>, <-0.509171, 2.253626, 1.702737>, 
      <0.450489, 0.990168, 0.269461>, <0.045024, 1.523104, 0.419861>, <-0.589929, 1.805140, 1.390736>, <-0.784990, 2.345708, 1.765942>, 
      <0.284778, 1.010809, 0.570226>, <-0.019841, 1.490984, 0.584090>, <-0.837860, 1.914297, 1.446814>, <-1.045147, 2.432561, 1.556297>, 
      <0.011080, 1.044903, 0.681636>, <-0.293538, 1.525078, 0.695500>, <-0.905517, 1.936884, 1.157915>, <-1.112804, 2.455148, 1.267398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.348938, 1.002818, -0.009846>, <0.450489, 0.990168, 0.269461>, <0.284778, 1.010809, 0.570226>, <0.011080, 1.044903, 0.681636>, 
      <0.650663, 0.606236, -0.121766>, <0.752215, 0.593585, 0.157542>, <0.484472, 0.696029, 0.561137>, <0.210774, 0.730123, 0.672547>, 
      <0.965912, 0.335921, 0.765684>, <0.800546, 0.335921, 1.013379>, <0.582671, 0.327914, 1.218945>, <0.330354, 0.327914, 1.060720>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.139573, -0.052701, 0.570499>, <-0.397614, -0.052701, 0.481679>, <-0.713684, -0.053921, 0.604690>, <-0.795098, -0.053921, 0.865162>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.044321, -0.058184, 1.150097>, <0.022108, -0.058184, 0.937569>, <0.070971, -0.052701, 0.642971>, <-0.139573, -0.052701, 0.570499>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.494674, -0.058134, 1.589032>, <-0.269535, -0.058134, 1.666527>, <-0.115355, -0.058184, 1.377357>, <-0.044321, -0.058184, 1.150097>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.494674, -0.058134, 1.589032>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.776281, -0.058134, 1.492099>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.883949, -0.053921, 1.149423>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.795098, -0.053921, 0.865162>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.709818, 5.692039, 0.579594>, <1.655656, 5.667152, 0.579594>, <1.587223, 5.621508, 0.573206>, <1.529277, 5.609084, 0.579594>, 
      <1.590743, 5.920637, 0.490764>, <1.536581, 5.895750, 0.490764>, <1.468148, 5.850104, 0.484376>, <1.410202, 5.837681, 0.490764>, 
      <1.454120, 6.182923, 0.629393>, <1.399958, 6.158036, 0.629393>, <1.324998, 6.125084, 0.612717>, <1.273580, 6.099967, 0.629393>, 
      <1.416587, 6.254977, 0.889635>, <1.362425, 6.230090, 0.889635>, <1.287466, 6.197138, 0.872958>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.760328, 5.595072, 1.146066>, <1.706166, 5.570185, 1.146066>, <1.635094, 5.534172, 1.148835>, <1.579788, 5.512116, 1.146066>, 
      <1.790981, 5.536225, 0.933524>, <1.736819, 5.511338, 0.933524>, <1.665747, 5.475325, 0.936293>, <1.610441, 5.453269, 0.933524>, 
      <1.807068, 5.505342, 0.652142>, <1.752905, 5.480455, 0.652142>, <1.684472, 5.434810, 0.645754>, <1.626527, 5.422387, 0.652142>, 
      <1.709818, 5.692039, 0.579594>, <1.655656, 5.667152, 0.579594>, <1.587223, 5.621508, 0.573206>, <1.529277, 5.609084, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.563761, 5.972434, 1.592315>, <1.509599, 5.947548, 1.592315>, <1.430327, 5.925932, 1.590061>, <1.383221, 5.889479, 1.592315>, 
      <1.667696, 5.772902, 1.669850>, <1.613534, 5.748016, 1.669850>, <1.534262, 5.726400, 1.667596>, <1.487156, 5.689948, 1.669850>, 
      <1.727568, 5.657964, 1.373218>, <1.673406, 5.633078, 1.373218>, <1.602334, 5.597064, 1.375987>, <1.547028, 5.575008, 1.373219>, 
      <1.760328, 5.595072, 1.146066>, <1.706166, 5.570185, 1.146066>, <1.635094, 5.534172, 1.148835>, <1.579788, 5.512116, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.563761, 5.972434, 1.592315>, <1.433709, 6.222104, 1.495296>, <1.375594, 6.333674, 1.173867>, <1.416587, 6.254977, 0.889635>, 
      <1.509599, 5.947548, 1.592315>, <1.379547, 6.197218, 1.495296>, <1.321432, 6.308786, 1.173867>, <1.362425, 6.230090, 0.889635>, 
      <1.430327, 5.925932, 1.590061>, <1.300275, 6.175602, 1.493042>, <1.246473, 6.275834, 1.157191>, <1.287466, 6.197138, 0.872958>, 
      <1.383221, 5.889479, 1.592315>, <1.253169, 6.139149, 1.495296>, <1.195055, 6.250717, 1.173867>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.401500, 5.239375, 0.812352>, <-0.566029, 5.390686, 0.968889>, <-0.611715, 5.432701, 1.289497>, <-0.492032, 5.322633, 1.508653>, 
      <0.085041, 5.578176, 0.846709>, <-0.079489, 5.729487, 1.003245>, <-0.126642, 5.776109, 1.411792>, <-0.006959, 5.666041, 1.630948>, 
      <0.951942, 5.485304, 0.643241>, <0.832867, 5.713901, 0.554411>, <0.750146, 5.844274, 0.799157>, <0.712614, 5.916328, 1.059399>, 
      <1.529277, 5.609084, 0.579594>, <1.410202, 5.837681, 0.490764>, <1.273580, 6.099967, 0.629393>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.017399, 4.886133, 1.057078>, <-0.114958, 4.975854, 0.878435>, <-0.267385, 5.116036, 0.684752>, <-0.401500, 5.239375, 0.812352>, 
      <0.436524, 5.126386, 1.099536>, <0.338965, 5.216107, 0.920893>, <0.219156, 5.454836, 0.719109>, <0.085041, 5.578176, 0.846709>, 
      <1.101628, 5.321431, 1.122131>, <1.132281, 5.262584, 0.909589>, <1.049191, 5.298607, 0.715789>, <0.951942, 5.485304, 0.643241>, 
      <1.579788, 5.512116, 1.146066>, <1.610441, 5.453269, 0.933524>, <1.626527, 5.422387, 0.652142>, <1.529277, 5.609084, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.063646, 4.811598, 1.664096>, <0.207197, 4.679580, 1.527519>, <0.087024, 4.790099, 1.248290>, <-0.017399, 4.886133, 1.057078>, 
      <0.513483, 5.034893, 1.761712>, <0.657034, 4.902876, 1.625135>, <0.540947, 5.030352, 1.290749>, <0.436524, 5.126386, 1.099536>, 
      <0.978899, 5.576602, 1.611662>, <1.082833, 5.377070, 1.689197>, <1.068868, 5.384324, 1.349284>, <1.101628, 5.321431, 1.122131>, 
      <1.383221, 5.889479, 1.592315>, <1.487156, 5.689948, 1.669850>, <1.547028, 5.575008, 1.373219>, <1.579788, 5.512116, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.063646, 4.811598, 1.664096>, <0.513483, 5.034893, 1.761712>, <0.978899, 5.576602, 1.611662>, <1.383221, 5.889479, 1.592315>, 
      <-0.115705, 4.976539, 1.834734>, <0.334133, 5.199834, 1.932350>, <0.848847, 5.826272, 1.514643>, <1.253169, 6.139149, 1.495296>, 
      <-0.361567, 5.202649, 1.747552>, <0.123506, 5.546057, 1.869847>, <0.671621, 5.995024, 1.343631>, <1.195055, 6.250717, 1.173867>, 
      <-0.492032, 5.322633, 1.508653>, <-0.006959, 5.666041, 1.630948>, <0.712614, 5.916328, 1.059399>, <1.236047, 6.172021, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.080129, 3.792033, 0.395332>, <-1.182074, 3.850471, 0.149358>, <-1.447621, 4.002690, 0.035297>, <-1.657917, 4.123237, 0.160018>, 
      <-0.957016, 4.266909, 0.465818>, <-1.058962, 4.325347, 0.219843>, <-1.194281, 4.532674, 0.300691>, <-1.404577, 4.653222, 0.425412>, 
      <-0.807537, 4.956633, 0.783680>, <-0.972067, 5.107944, 0.940216>, <-1.127017, 5.067893, 1.159581>, <-1.007334, 4.957825, 1.378737>, 
      <-0.401500, 5.239375, 0.812352>, <-0.566029, 5.390686, 0.968889>, <-0.611715, 5.432701, 1.289497>, <-0.492032, 5.322633, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363339, 3.954376, 0.870777>, <-1.191632, 3.855949, 0.768942>, <-0.996890, 3.744318, 0.596171>, <-1.080129, 3.792033, 0.395332>, 
      <-1.108684, 4.376812, 0.902369>, <-0.936976, 4.278384, 0.800534>, <-0.873777, 4.219194, 0.666657>, <-0.957016, 4.266909, 0.465818>, 
      <-0.452764, 4.655703, 1.016356>, <-0.550323, 4.745424, 0.837712>, <-0.673422, 4.833293, 0.656080>, <-0.807537, 4.956633, 0.783680>, 
      <-0.017399, 4.886133, 1.057078>, <-0.114958, 4.975854, 0.878435>, <-0.267385, 5.116036, 0.684752>, <-0.401500, 5.239375, 0.812352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.897863, 4.260780, 0.880309>, <-1.808928, 4.209800, 1.094892>, <-1.546796, 4.059539, 0.979581>, <-1.363339, 3.954376, 0.870777>, 
      <-1.448528, 4.707969, 1.044600>, <-1.359593, 4.656989, 1.259182>, <-1.292141, 4.481975, 1.011173>, <-1.108684, 4.376812, 0.902369>, 
      <-0.512167, 4.525770, 1.539143>, <-0.368616, 4.393752, 1.402566>, <-0.348341, 4.559669, 1.207568>, <-0.452764, 4.655703, 1.016356>, 
      <0.063646, 4.811598, 1.664096>, <0.207197, 4.679580, 1.527519>, <0.087024, 4.790099, 1.248290>, <-0.017399, 4.886133, 1.057078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.897863, 4.260780, 0.880309>, <-1.448528, 4.707969, 1.044600>, <-0.512167, 4.525770, 1.539143>, <0.063646, 4.811598, 1.664096>, 
      <-2.009223, 4.324615, 0.611619>, <-1.559888, 4.771804, 0.775909>, <-0.691518, 4.690711, 1.709781>, <-0.115705, 4.976539, 1.834734>, 
      <-1.887634, 4.254917, 0.296257>, <-1.634294, 4.784902, 0.561651>, <-0.876869, 4.837841, 1.617635>, <-0.361567, 5.202649, 1.747552>, 
      <-1.657917, 4.123237, 0.160018>, <-1.404577, 4.653222, 0.425412>, <-1.007334, 4.957825, 1.378737>, <-0.492032, 5.322633, 1.508653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.122481, 2.458378, 0.399568>, <-1.239682, 2.497505, 0.156583>, <-1.532609, 2.595299, 0.050160>, <-1.759522, 2.671054, 0.180852>, 
      <-1.159002, 2.852133, 0.337410>, <-1.276203, 2.891260, 0.094426>, <-1.624723, 2.983765, -0.126964>, <-1.851635, 3.059519, 0.003727>, 
      <-1.179566, 3.408482, 0.338401>, <-1.281511, 3.466920, 0.092427>, <-1.619280, 3.643581, -0.144530>, <-1.829576, 3.764128, -0.019809>, 
      <-1.080129, 3.792033, 0.395332>, <-1.182074, 3.850471, 0.149358>, <-1.447621, 4.002690, 0.035297>, <-1.657917, 4.123237, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.420864, 2.557994, 0.882967>, <-1.235580, 2.496137, 0.776252>, <-1.026781, 2.426429, 0.597975>, <-1.122481, 2.458378, 0.399568>, 
      <-1.563949, 2.951281, 0.857422>, <-1.378665, 2.889424, 0.750707>, <-1.063302, 2.820184, 0.535817>, <-1.159002, 2.852133, 0.337410>, 
      <-1.579363, 3.596024, 0.843978>, <-1.407656, 3.497597, 0.742142>, <-1.096327, 3.360767, 0.539241>, <-1.179566, 3.408482, 0.338401>, 
      <-1.363339, 3.954376, 0.870777>, <-1.191632, 3.855949, 0.768942>, <-0.996890, 3.744318, 0.596171>, <-1.080129, 3.792033, 0.395332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.004869, 2.752963, 0.907784>, <-1.902623, 2.718829, 1.119763>, <-1.618822, 2.624082, 0.996982>, <-1.420864, 2.557994, 0.882967>, 
      <-2.212138, 3.144726, 0.811473>, <-2.109892, 3.110592, 1.023452>, <-1.761907, 3.017369, 0.971437>, <-1.563949, 2.951281, 0.857422>, 
      <-2.209063, 3.951066, 0.766525>, <-2.120128, 3.900086, 0.981108>, <-1.762821, 3.701187, 0.952781>, <-1.579363, 3.596024, 0.843978>, 
      <-1.897863, 4.260780, 0.880309>, <-1.808928, 4.209800, 1.094892>, <-1.546796, 4.059539, 0.979581>, <-1.363339, 3.954376, 0.870777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.004869, 2.752963, 0.907784>, <-2.212138, 3.144726, 0.811473>, <-2.209063, 3.951066, 0.766525>, <-1.897863, 4.260780, 0.880309>, 
      <-2.132899, 2.795705, 0.642350>, <-2.340168, 3.187468, 0.546038>, <-2.320423, 4.014902, 0.497835>, <-2.009223, 4.324615, 0.611619>, 
      <-2.007400, 2.753808, 0.323618>, <-2.099513, 3.142273, 0.146494>, <-2.059293, 3.895808, 0.116430>, <-1.887634, 4.254917, 0.296257>, 
      <-1.759522, 2.671054, 0.180852>, <-1.851635, 3.059519, 0.003727>, <-1.829576, 3.764128, -0.019809>, <-1.657917, 4.123237, 0.160018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835108, 1.150311, 0.812352>, <-1.056529, 1.177893, 0.969382>, <-1.117379, 1.185473, 1.289147>, <-0.956561, 1.165440, 1.508653>, 
      <-0.987237, 1.541206, 0.783727>, <-1.208658, 1.568788, 0.940757>, <-1.329887, 1.777803, 1.131968>, <-1.169069, 1.757771, 1.351474>, 
      <-1.084124, 2.044823, 0.464851>, <-1.201325, 2.083950, 0.221867>, <-1.395814, 2.018397, 0.313204>, <-1.622726, 2.094152, 0.443896>, 
      <-1.122481, 2.458378, 0.399568>, <-1.239682, 2.497505, 0.156583>, <-1.532609, 2.595299, 0.050160>, <-1.759522, 2.671054, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.835108, 1.150311, 0.812352>, <-0.688443, 0.773456, 0.839949>, <-0.343805, 0.358812, 0.641515>, <-0.165728, 0.000000, 0.579594>, 
      <-1.056529, 1.177893, 0.969382>, <-0.909864, 0.801038, 0.996979>, <-0.601845, 0.358812, 0.552694>, <-0.423769, 0.000000, 0.490773>, 
      <-1.117379, 1.185473, 1.289147>, <-0.986780, 0.821449, 1.385744>, <-0.760941, 0.361050, 0.793031>, <-0.719824, 0.000000, 0.629163>, 
      <-0.956561, 1.165440, 1.508653>, <-0.825962, 0.801416, 1.605249>, <-0.842356, 0.361050, 1.053503>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.319816, 1.086122, 1.057078>, <-0.450398, 1.102388, 0.878843>, <-0.655318, 1.127915, 0.684846>, <-0.835108, 1.150311, 0.812352>, 
      <-0.579462, 1.572836, 1.007018>, <-0.710044, 1.589102, 0.828783>, <-0.807446, 1.518810, 0.656221>, <-0.987237, 1.541206, 0.783727>, 
      <-1.231839, 2.038434, 0.916714>, <-1.046554, 1.976577, 0.809998>, <-0.988424, 2.012874, 0.663259>, <-1.084124, 2.044823, 0.464851>, 
      <-1.420864, 2.557994, 0.882967>, <-1.235580, 2.496137, 0.776252>, <-1.026781, 2.426429, 0.597975>, <-1.122481, 2.458378, 0.399568>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.319816, 1.086122, 1.057078>, <-0.162149, 0.790570, 1.087477>, <-0.123706, 0.328734, 1.123293>, <-0.056259, 0.000000, 1.146066>, 
      <-0.450398, 1.102388, 0.878843>, <-0.292731, 0.806836, 0.909242>, <-0.057277, 0.328734, 0.910765>, <0.010170, 0.000000, 0.933538>, 
      <-0.655318, 1.127915, 0.684846>, <-0.508653, 0.751060, 0.712443>, <-0.133261, 0.358812, 0.713987>, <0.044816, 0.000000, 0.652066>, 
      <-0.835108, 1.150311, 0.812352>, <-0.688443, 0.773456, 0.839949>, <-0.343805, 0.358812, 0.641515>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.017902, 1.048514, 1.527089>, <-0.179504, 1.068644, 1.248594>, <-0.319816, 1.086122, 1.057078>, 
      <-0.575942, 1.732259, 1.500065>, <-0.382755, 1.708194, 1.363058>, <-0.439150, 1.555358, 1.198534>, <-0.579462, 1.572836, 1.007018>, 
      <-1.652308, 2.086582, 1.071607>, <-1.550062, 2.052448, 1.283586>, <-1.429796, 2.104522, 1.030729>, <-1.231839, 2.038434, 0.916714>, 
      <-2.004869, 2.752963, 0.907784>, <-1.902623, 2.718829, 1.119763>, <-1.618822, 2.624082, 0.996982>, <-1.420864, 2.557994, 0.882967>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.053798, 0.788186, 1.734811>, <-0.412977, 0.324781, 1.610657>, <-0.482271, 0.000000, 1.592315>, 
      <-0.017902, 1.048514, 1.527089>, <0.139389, 0.764121, 1.597804>, <-0.187837, 0.324781, 1.688153>, <-0.257132, 0.000000, 1.669811>, 
      <-0.179504, 1.068644, 1.248594>, <-0.021837, 0.773092, 1.278993>, <-0.194740, 0.328734, 1.350554>, <-0.127293, 0.000000, 1.373327>, 
      <-0.319816, 1.086122, 1.057078>, <-0.162149, 0.790570, 1.087477>, <-0.123706, 0.328734, 1.123293>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.575942, 1.732259, 1.500065>, <-1.652308, 2.086582, 1.071607>, <-2.004869, 2.752963, 0.907784>, 
      <-0.451355, 1.102508, 1.834491>, <-0.816208, 1.762188, 1.670460>, <-1.780338, 2.129324, 0.806173>, <-2.132899, 2.795705, 0.642350>, 
      <-0.782056, 1.143703, 1.746841>, <-0.994564, 1.736033, 1.589662>, <-1.870604, 2.176906, 0.586662>, <-2.007400, 2.753808, 0.323618>, 
      <-0.956561, 1.165440, 1.508653>, <-1.169069, 1.757771, 1.351474>, <-1.622726, 2.094152, 0.443896>, <-1.759522, 2.671054, 0.180852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.211089, 1.072579, 1.664096>, <-0.451355, 1.102508, 1.834491>, <-0.782056, 1.143703, 1.746841>, <-0.956561, 1.165440, 1.508653>, 
      <-0.053798, 0.788186, 1.734811>, <-0.294064, 0.818115, 1.905206>, <-0.651456, 0.779679, 1.843437>, <-0.825962, 0.801416, 1.605249>, 
      <-0.412977, 0.324781, 1.610657>, <-0.694584, 0.324781, 1.513724>, <-0.931207, 0.361050, 1.337764>, <-0.842356, 0.361050, 1.053503>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.542867, -0.041261, 0.002034>, <0.542867, -0.041261, -0.270865>, <0.315642, -0.038678, -0.522344>, <0.042854, -0.038678, -0.514550>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.034220, -0.048102, 0.280171>, <0.256797, -0.048102, 0.273812>, <0.542867, -0.041261, 0.224702>, <0.542867, -0.041261, 0.002034>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.530821, -0.045289, 0.005688>, <-0.530821, -0.045289, 0.243791>, <-0.203787, -0.048102, 0.286971>, <0.034220, -0.048102, 0.280171>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.530821, -0.045289, 0.005688>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.530821, -0.045289, -0.292135>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.254847, -0.038678, -0.506044>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.042854, -0.038678, -0.514550>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.016992, 5.102336, 0.000000>, <1.962830, 5.077449, 0.000000>, <1.895862, 5.014841, 0.001607>, <1.836451, 5.019381, 0.000000>, 
      <2.016992, 5.102336, -0.272732>, <1.962830, 5.077449, -0.272732>, <1.895862, 5.014841, -0.271125>, <1.836451, 5.019381, -0.272732>, 
      <1.912231, 5.303452, -0.507799>, <1.858069, 5.278566, -0.507799>, <1.789997, 5.215879, -0.519283>, <1.731691, 5.220498, -0.507799>, 
      <1.786286, 5.545237, -0.500000>, <1.732124, 5.520350, -0.500000>, <1.664052, 5.457664, -0.511485>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.786286, 5.545237, 0.287879>, <1.732124, 5.520350, 0.287879>, <1.664830, 5.467760, 0.282231>, <1.605746, 5.462282, 0.287879>, 
      <1.889017, 5.348018, 0.281518>, <1.834855, 5.323131, 0.281518>, <1.767561, 5.270541, 0.275870>, <1.708477, 5.265063, 0.281518>, 
      <2.016992, 5.102336, 0.222463>, <1.962830, 5.077449, 0.222463>, <1.895862, 5.014841, 0.224070>, <1.836451, 5.019381, 0.222463>, 
      <2.016992, 5.102336, 0.000000>, <1.962830, 5.077449, 0.000000>, <1.895862, 5.014841, 0.001607>, <1.836451, 5.019381, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527617, 6.041823, 0.030303>, <1.473455, 6.016936, 0.030303>, <1.403322, 5.966867, 0.012264>, <1.347077, 5.958868, 0.030303>, 
      <1.527617, 6.041823, 0.268165>, <1.473455, 6.016936, 0.268165>, <1.403322, 5.966867, 0.250126>, <1.347077, 5.958868, 0.268165>, 
      <1.676444, 5.756108, 0.294681>, <1.622282, 5.731222, 0.294681>, <1.554989, 5.678632, 0.289033>, <1.495904, 5.673154, 0.294681>, 
      <1.786286, 5.545237, 0.287879>, <1.732124, 5.520350, 0.287879>, <1.664830, 5.467760, 0.282231>, <1.605746, 5.462282, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527617, 6.041823, 0.030303>, <1.527617, 6.041823, -0.267327>, <1.648843, 5.809094, -0.491489>, <1.786286, 5.545237, -0.500000>, 
      <1.473455, 6.016936, 0.030303>, <1.473455, 6.016936, -0.267327>, <1.594682, 5.784208, -0.491489>, <1.732124, 5.520350, -0.500000>, 
      <1.403322, 5.966867, 0.012264>, <1.403322, 5.966867, -0.285366>, <1.526610, 5.721521, -0.502974>, <1.664052, 5.457664, -0.511485>, 
      <1.347077, 5.958868, 0.030303>, <1.347077, 5.958868, -0.267327>, <1.468304, 5.726140, -0.491489>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.458144, 5.291469, -0.066958>, <-0.620314, 5.440610, -0.227437>, <-0.858375, 5.659545, -0.181768>, <-0.971625, 5.763697, 0.043226>, 
      <0.082830, 5.709505, -0.183255>, <-0.079340, 5.858646, -0.343734>, <-0.325463, 6.245668, -0.252869>, <-0.438713, 6.349821, -0.027875>, 
      <1.145226, 5.072200, -0.018699>, <1.145226, 5.072200, -0.291431>, <0.953675, 5.282126, -0.354553>, <0.827730, 5.523910, -0.346754>, 
      <1.836451, 5.019381, 0.000000>, <1.836451, 5.019381, -0.272732>, <1.731691, 5.220498, -0.507799>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.503245, 5.332946, 0.506724>, <-0.410730, 5.247864, 0.322926>, <-0.325667, 5.169635, 0.064138>, <-0.458144, 5.291469, -0.066958>, 
      <0.003768, 5.719003, 0.502323>, <0.096283, 5.633921, 0.318525>, <0.215307, 5.587671, -0.052159>, <0.082830, 5.709505, -0.183255>, 
      <0.974046, 5.403709, 0.348260>, <1.076777, 5.206490, 0.341899>, <1.145226, 5.072200, 0.203763>, <1.145226, 5.072200, -0.018699>, 
      <1.605746, 5.462282, 0.287879>, <1.708477, 5.265063, 0.281518>, <1.836451, 5.019381, 0.222463>, <1.836451, 5.019381, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.898820, 5.696741, 0.808531>, <-0.757290, 5.566581, 0.948585>, <-0.602082, 5.423842, 0.703083>, <-0.503245, 5.332946, 0.506724>, 
      <-0.382301, 6.190080, 0.875474>, <-0.240771, 6.059920, 1.015528>, <-0.095068, 5.809899, 0.698682>, <0.003768, 5.719003, 0.502323>, 
      <0.670136, 5.862595, 0.247417>, <0.670136, 5.862595, 0.485279>, <0.864204, 5.614581, 0.355062>, <0.974046, 5.403709, 0.348260>, 
      <1.347077, 5.958868, 0.030303>, <1.347077, 5.958868, 0.268165>, <1.495904, 5.673154, 0.294681>, <1.605746, 5.462282, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.898820, 5.696741, 0.808531>, <-0.382301, 6.190080, 0.875474>, <0.670136, 5.862595, 0.247417>, <1.347077, 5.958868, 0.030303>, 
      <-1.076009, 5.859695, 0.633189>, <-0.559490, 6.353034, 0.700132>, <0.670136, 5.862595, -0.050213>, <1.347077, 5.958868, -0.267327>, 
      <-1.095364, 5.877495, 0.289058>, <-0.562453, 6.463619, 0.217957>, <0.690288, 5.787768, -0.338243>, <1.468304, 5.726140, -0.491489>, 
      <-0.971625, 5.763697, 0.043226>, <-0.438713, 6.349821, -0.027875>, <0.827730, 5.523910, -0.346754>, <1.605746, 5.462282, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.317538, 3.354895, 0.463057>, <-0.148934, 3.258247, 0.271469>, <-0.142030, 3.254290, -0.054998>, <-0.312792, 3.352175, -0.244029>, 
      <-0.350183, 3.949814, 0.365095>, <-0.181579, 3.853166, 0.173507>, <-0.280968, 3.993625, 0.007938>, <-0.451731, 4.091510, -0.181094>, 
      <-0.929162, 4.927492, 0.034300>, <-1.091332, 5.076634, -0.126180>, <-1.364183, 5.103231, -0.114283>, <-1.477433, 5.207383, 0.110711>, 
      <-0.458144, 5.291469, -0.066958>, <-0.620314, 5.440610, -0.227437>, <-0.858375, 5.659545, -0.181768>, <-0.971625, 5.763697, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.799259, 3.631031, 0.308754>, <-0.660087, 3.551254, 0.462815>, <-0.454951, 3.433664, 0.619202>, <-0.317538, 3.354895, 0.463057>, 
      <-0.744607, 4.148604, 0.343836>, <-0.605436, 4.068828, 0.497897>, <-0.487595, 4.028582, 0.521240>, <-0.350183, 3.949814, 0.365095>, 
      <-0.918252, 5.016946, 0.510326>, <-0.825737, 4.931864, 0.326528>, <-0.796685, 4.805658, 0.165396>, <-0.929162, 4.927492, 0.034300>, 
      <-0.503245, 5.332946, 0.506724>, <-0.410730, 5.247864, 0.322926>, <-0.325667, 5.169635, 0.064138>, <-0.458144, 5.291469, -0.066958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.981040, 3.735232, -0.271430>, <-1.128125, 3.819545, -0.104294>, <-0.948227, 3.716424, 0.143849>, <-0.799259, 3.631031, 0.308754>, 
      <-0.955477, 4.373141, -0.061020>, <-1.102562, 4.457454, 0.106116>, <-0.893575, 4.233997, 0.178930>, <-0.744607, 4.148604, 0.343836>, 
      <-1.382799, 5.234482, 0.745806>, <-1.241269, 5.104322, 0.885860>, <-1.017089, 5.107842, 0.706685>, <-0.918252, 5.016946, 0.510326>, 
      <-0.898820, 5.696741, 0.808531>, <-0.757290, 5.566581, 0.948585>, <-0.602082, 5.423842, 0.703083>, <-0.503245, 5.332946, 0.506724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.981040, 3.735232, -0.271430>, <-0.955477, 4.373141, -0.061020>, <-1.382799, 5.234482, 0.745806>, <-0.898820, 5.696741, 0.808531>, 
      <-0.797264, 3.629887, -0.480259>, <-0.771700, 4.267796, -0.269849>, <-1.559988, 5.397436, 0.570463>, <-1.076009, 5.859695, 0.633189>, 
      <-0.498921, 3.458869, -0.450071>, <-0.637860, 4.198204, -0.387136>, <-1.601173, 5.321181, 0.356543>, <-1.095364, 5.877495, 0.289058>, 
      <-0.312792, 3.352175, -0.244029>, <-0.451731, 4.091510, -0.181094>, <-1.477433, 5.207383, 0.110711>, <-0.971625, 5.763697, 0.043226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287387, 2.179583, 0.445460>, <-0.107609, 2.119564, 0.249115>, <-0.107716, 2.119600, -0.077450>, <-0.298801, 2.183394, -0.261544>, 
      <-0.197714, 2.511214, 0.525533>, <-0.017936, 2.451195, 0.329188>, <0.073911, 2.416852, -0.117983>, <-0.117174, 2.480645, -0.302077>, 
      <-0.298467, 3.007342, 0.520287>, <-0.129863, 2.910694, 0.328699>, <-0.077484, 2.910824, -0.084235>, <-0.248247, 3.008709, -0.273266>, 
      <-0.317538, 3.354895, 0.463057>, <-0.148934, 3.258247, 0.271469>, <-0.142030, 3.254290, -0.054998>, <-0.312792, 3.352175, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.817526, 2.356570, 0.304983>, <-0.661793, 2.304579, 0.455018>, <-0.433905, 2.228498, 0.605480>, <-0.287387, 2.179583, 0.445460>, 
      <-0.790928, 2.736798, 0.274430>, <-0.635195, 2.684806, 0.424466>, <-0.344232, 2.560129, 0.685553>, <-0.197714, 2.511214, 0.525533>, 
      <-0.839321, 3.251627, 0.283038>, <-0.700149, 3.171850, 0.437099>, <-0.435880, 3.086111, 0.676432>, <-0.298467, 3.007342, 0.520287>, 
      <-0.799259, 3.631031, 0.308754>, <-0.660087, 3.551254, 0.462815>, <-0.454951, 3.433664, 0.619202>, <-0.317538, 3.354895, 0.463057>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.029833, 2.427448, -0.269824>, <-1.186663, 2.479806, -0.098541>, <-0.984220, 2.412221, 0.144387>, <-0.817526, 2.356570, 0.304983>, 
      <-0.956069, 2.781487, -0.422653>, <-1.112900, 2.833845, -0.251370>, <-0.957622, 2.792448, 0.113834>, <-0.790928, 2.736798, 0.274430>, 
      <-0.995971, 3.362652, -0.394323>, <-1.143056, 3.446966, -0.227187>, <-0.988289, 3.337019, 0.118132>, <-0.839321, 3.251627, 0.283038>, 
      <-0.981040, 3.735232, -0.271430>, <-1.128125, 3.819545, -0.104294>, <-0.948227, 3.716424, 0.143849>, <-0.799259, 3.631031, 0.308754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.029833, 2.427448, -0.269824>, <-0.956069, 2.781487, -0.422653>, <-0.995971, 3.362652, -0.394323>, <-0.981040, 3.735232, -0.271430>, 
      <-0.833876, 2.362028, -0.483839>, <-0.760113, 2.716067, -0.636667>, <-0.812194, 3.257307, -0.603152>, <-0.797264, 3.629887, -0.480259>, 
      <-0.507082, 2.252928, -0.462205>, <-0.325455, 2.550180, -0.502738>, <-0.434376, 3.115403, -0.479308>, <-0.498921, 3.458869, -0.450071>, 
      <-0.298801, 2.183394, -0.261544>, <-0.117174, 2.480645, -0.302077>, <-0.248247, 3.008709, -0.273266>, <-0.312792, 3.352175, -0.244029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.911099, 1.159776, -0.066958>, <-1.128313, 1.186834, -0.227182>, <-1.448521, 1.226722, -0.181041>, <-1.599961, 1.245586, 0.043226>, 
      <-1.041287, 1.520151, 0.006695>, <-1.258500, 1.547208, -0.153529>, <-1.514544, 1.709163, -0.128352>, <-1.665984, 1.728027, 0.095915>, 
      <-0.386576, 1.812758, 0.356890>, <-0.206798, 1.752740, 0.160544>, <-0.361373, 1.704464, -0.020841>, <-0.552458, 1.768257, -0.204936>, 
      <-0.287387, 2.179583, 0.445460>, <-0.107609, 2.119564, 0.249115>, <-0.107716, 2.119600, -0.077450>, <-0.298801, 2.183394, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.911099, 1.159776, -0.066958>, <-0.728144, 0.653335, -0.170464>, <0.105169, 0.380035, -0.018735>, <0.500000, 0.000000, 0.000000>, 
      <-1.128313, 1.186834, -0.227182>, <-0.945358, 0.680392, -0.330688>, <0.105169, 0.380035, -0.291635>, <0.500000, 0.000000, -0.272899>, 
      <-1.448521, 1.226722, -0.181041>, <-1.363630, 0.606411, -0.248787>, <-0.180531, 0.409138, -0.353881>, <0.272788, 0.000000, -0.507794>, 
      <-1.599961, 1.245586, 0.043226>, <-1.515071, 0.625276, -0.024520>, <-0.453319, 0.409138, -0.346087>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.971604, 1.167314, 0.506724>, <-0.847303, 1.151830, 0.322648>, <-0.732813, 1.137568, 0.064552>, <-0.911099, 1.159776, -0.066958>, 
      <-1.091169, 1.511969, 0.509226>, <-0.966869, 1.496485, 0.325150>, <-0.863000, 1.497942, 0.138205>, <-1.041287, 1.520151, 0.006695>, 
      <-0.842902, 1.993809, 0.334132>, <-0.687169, 1.941818, 0.484168>, <-0.533094, 1.861673, 0.516910>, <-0.386576, 1.812758, 0.356890>, 
      <-0.817526, 2.356570, 0.304983>, <-0.661793, 2.304579, 0.455018>, <-0.433905, 2.228498, 0.605480>, <-0.287387, 2.179583, 0.445460>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.971604, 1.167314, 0.506724>, <-0.820732, 0.732417, 0.503567>, <-0.264601, 0.371943, 0.347478>, <0.000000, 0.000000, 0.287879>, 
      <-0.847303, 1.151830, 0.322648>, <-0.696432, 0.716933, 0.319492>, <-0.042024, 0.371943, 0.341119>, <0.222577, 0.000000, 0.281520>, 
      <-0.732813, 1.137568, 0.064552>, <-0.549858, 0.631126, -0.038954>, <0.105169, 0.380035, 0.203933>, <0.500000, 0.000000, 0.222668>, 
      <-0.911099, 1.159776, -0.066958>, <-0.728144, 0.653335, -0.170464>, <0.105169, 0.380035, -0.018735>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.312519, 1.209780, 0.948512>, <-1.103911, 1.183795, 0.702656>, <-0.971604, 1.167314, 0.506724>, 
      <-1.597066, 1.723727, 0.747910>, <-1.407296, 1.700088, 0.887891>, <-1.223476, 1.528450, 0.705157>, <-1.091169, 1.511969, 0.509226>, 
      <-1.124346, 1.973817, -0.074004>, <-1.281177, 2.026175, 0.097278>, <-1.009596, 2.049460, 0.173537>, <-0.842902, 1.993809, 0.334132>, 
      <-1.029833, 2.427448, -0.269824>, <-1.186663, 2.479806, -0.098541>, <-0.984220, 2.412221, 0.144387>, <-0.817526, 2.356570, 0.304983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.404168, 0.725808, 0.871292>, <-0.821170, 0.396197, 0.245639>, <-0.560606, 0.000000, 0.030303>, 
      <-1.312519, 1.209780, 0.948512>, <-1.214398, 0.702169, 1.011272>, <-0.821170, 0.396197, 0.483743>, <-0.560606, 0.000000, 0.268407>, 
      <-1.103911, 1.183795, 0.702656>, <-0.953039, 0.748898, 0.699499>, <-0.502608, 0.371943, 0.354278>, <-0.238007, 0.000000, 0.294679>, 
      <-0.971604, 1.167314, 0.506724>, <-0.820732, 0.732417, 0.503567>, <-0.264601, 0.371943, 0.347478>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.597066, 1.723727, 0.747910>, <-1.124346, 1.973817, -0.074004>, <-1.029833, 2.427448, -0.269824>, 
      <-1.740743, 1.263122, 0.632639>, <-1.835520, 1.753430, 0.572018>, <-0.928390, 1.908397, -0.288019>, <-0.833876, 2.362028, -0.483839>, 
      <-1.766210, 1.266295, 0.289423>, <-1.832233, 1.748737, 0.342112>, <-0.760739, 1.837792, -0.405597>, <-0.507082, 2.252928, -0.462205>, 
      <-1.599961, 1.245586, 0.043226>, <-1.665984, 1.728027, 0.095915>, <-0.552458, 1.768257, -0.204936>, <-0.298801, 2.183394, -0.261544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.502289, 1.233419, 0.808531>, <-1.740743, 1.263122, 0.632639>, <-1.766210, 1.266295, 0.289423>, <-1.599961, 1.245586, 0.043226>, 
      <-1.404168, 0.725808, 0.871292>, <-1.642622, 0.755511, 0.695399>, <-1.681320, 0.645985, 0.221677>, <-1.515071, 0.625276, -0.024520>, 
      <-0.821170, 0.396197, 0.245639>, <-0.821170, 0.396197, -0.052184>, <-0.751020, 0.409138, -0.337581>, <-0.453319, 0.409138, -0.346087>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <0.1416, -0.015731, 0.024096>
}
#declare segMcurvedMB4 = union {
  object { // Blatt72->Blatt26
    Blatt26
    rotate <14.984076, -12.010209, 112.661034>
    translate  <-1.664782, -0.252009, -1.434033>
  }
  object { // Blatt73->Blatt26
    Blatt26
    rotate <-29.607376, -34.884117, -142.194717>
    translate  <-1.821675, -1.041412, 2.885714>
  }
  object { Blatt74 }
  object { sPatchObj25 }
  rotate <0.0, -58.908363, -0.0>
  translate  <-10.383466, 2.693717, 47.385983>
}
#declare BezPtch026 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt77 = union {
  cone { // Cone026
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch026 }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 3.761748, 2.590573>
}
#declare sPatchObj26 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382950, -0.198443, 1.038181>, <0.231423, -0.198443, 1.265148>, <0.289967, -0.198443, 1.586665>, <0.521168, -0.198443, 1.731648>, 
      <0.382950, -0.138910, 1.038181>, <0.231423, -0.138910, 1.265148>, <0.289967, -0.138910, 1.586665>, <0.521168, -0.138910, 1.731648>, 
      <0.414651, -0.048850, 1.050547>, <0.263124, -0.048850, 1.277514>, <0.300659, -0.048722, 1.619162>, <0.531860, -0.048722, 1.764145>, 
      <0.382950, 0.000000, 1.038181>, <0.231423, 0.000000, 1.265148>, <0.289967, 0.000000, 1.586665>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.958637, -0.198443, 1.076381>, <0.769992, -0.198443, 0.958085>, <0.506586, -0.198443, 0.852992>, <0.382950, -0.198443, 1.038181>, 
      <0.958637, -0.138910, 1.076381>, <0.769992, -0.138910, 0.958085>, <0.506586, -0.138910, 0.852992>, <0.382950, -0.138910, 1.038181>, 
      <0.993774, -0.039753, 1.103386>, <0.805129, -0.039753, 0.985090>, <0.538288, -0.048850, 0.865358>, <0.414651, -0.048850, 1.050547>, 
      <0.958637, 0.000000, 1.076381>, <0.769992, 0.000000, 0.958085>, <0.506586, 0.000000, 0.852992>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.414073, -0.198443, 1.403851>, <1.160359, -0.198443, 1.202878>, <0.958637, -0.198443, 1.076381>, 
      <1.281866, -0.138910, 1.601878>, <1.414073, -0.138910, 1.403851>, <1.160359, -0.138910, 1.202878>, <0.958637, -0.138910, 1.076381>, 
      <1.305480, -0.035894, 1.643087>, <1.437687, -0.035894, 1.445060>, <1.195496, -0.039753, 1.229883>, <0.993774, -0.039753, 1.103386>, 
      <1.281866, 0.000000, 1.601878>, <1.414073, 0.000000, 1.403851>, <1.160359, 0.000000, 1.202878>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.281866, -0.138910, 1.601878>, <1.305480, -0.035894, 1.643087>, <1.281866, 0.000000, 1.601878>, 
      <1.116500, -0.198443, 1.849573>, <1.116500, -0.138910, 1.849573>, <1.140114, -0.035894, 1.890782>, <1.116500, 0.000000, 1.849573>, 
      <0.773485, -0.198443, 1.889873>, <0.773485, -0.138910, 1.889873>, <0.784177, -0.048722, 1.922369>, <0.773485, 0.000000, 1.889873>, 
      <0.521168, -0.198443, 1.731648>, <0.521168, -0.138910, 1.731648>, <0.531860, -0.048722, 1.764145>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>, 
      <0.467505, 5.626361, -1.348637>, <0.467505, 5.566828, -1.348637>, <0.509780, 5.466167, -1.365785>, <0.467505, 5.427918, -1.348637>, 
      <0.526073, 5.626361, -1.027124>, <0.526073, 5.566828, -1.027124>, <0.576188, 5.458817, -1.035948>, <0.526073, 5.427918, -1.027124>, 
      <0.757285, 5.626361, -0.882157>, <0.757285, 5.566828, -0.882157>, <0.807400, 5.458817, -0.890982>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>, 
      <1.006052, 5.626361, -1.655739>, <1.006052, 5.566828, -1.655739>, <1.048927, 5.459842, -1.681945>, <1.006052, 5.427918, -1.655739>, 
      <0.742638, 5.626361, -1.760813>, <0.742638, 5.566828, -1.760813>, <0.784913, 5.466167, -1.777961>, <0.742638, 5.427918, -1.760813>, 
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.517973, 5.566828, -1.011983>, <1.566262, 5.454522, -1.034444>, <1.517973, 5.427918, -1.011983>, 
      <1.650165, 5.626361, -1.210019>, <1.650165, 5.566828, -1.210019>, <1.698454, 5.454522, -1.232481>, <1.650165, 5.427918, -1.210019>, 
      <1.396437, 5.626361, -1.410974>, <1.396437, 5.566828, -1.410974>, <1.439313, 5.459842, -1.437179>, <1.396437, 5.427918, -1.410974>, 
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.352625, 5.626361, -0.764276>, <1.009613, 5.626361, -0.723951>, <0.757285, 5.626361, -0.882157>, 
      <1.517973, 5.566828, -1.011983>, <1.352625, 5.566828, -0.764276>, <1.009613, 5.566828, -0.723951>, <0.757285, 5.566828, -0.882157>, 
      <1.566262, 5.454522, -1.034444>, <1.400914, 5.454522, -0.786737>, <1.059728, 5.458817, -0.732776>, <0.807400, 5.458817, -0.890982>, 
      <1.517973, 5.427918, -1.011983>, <1.352625, 5.427918, -0.764276>, <1.009613, 5.427918, -0.723951>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>, 
      <-0.416768, 4.721273, -1.247418>, <-0.689604, 4.721273, -1.253336>, <-0.729103, 4.787694, -0.873656>, <-0.727227, 4.787694, -0.600763>, 
      <0.228340, 5.074441, -1.417145>, <0.076830, 5.074441, -1.190167>, <-0.060671, 5.066156, -0.923812>, <0.170541, 5.066156, -0.778846>, 
      <0.619016, 5.427918, -1.575614>, <0.467505, 5.427918, -1.348637>, <0.526073, 5.427918, -1.027124>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>, 
      <0.010389, 4.716106, -0.789508>, <0.008858, 4.716106, -1.012170>, <-0.194153, 4.721273, -1.242589>, <-0.416768, 4.721273, -1.247418>, 
      <0.710236, 5.067195, -1.241350>, <0.521582, 5.067195, -1.359633>, <0.351963, 5.074441, -1.602344>, <0.228340, 5.074441, -1.417145>, 
      <1.194706, 5.427918, -1.537457>, <1.006052, 5.427918, -1.655739>, <0.742638, 5.427918, -1.760813>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>, 
      <-0.061860, 4.746262, -0.146843>, <0.176188, 4.746262, -0.141679>, <0.012026, 4.716106, -0.551410>, <0.010389, 4.716106, -0.789508>, 
      <0.854156, 5.062198, -0.703210>, <0.986348, 5.062198, -0.901247>, <0.911968, 5.067195, -1.114868>, <0.710236, 5.067195, -1.241350>, 
      <1.517973, 5.427918, -1.011983>, <1.650165, 5.427918, -1.210019>, <1.396437, 5.427918, -1.410974>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.061860, 4.746262, -0.146843>, <0.854156, 5.062198, -0.703210>, <1.517973, 5.427918, -1.011983>, 
      <-1.059745, 4.370247, 0.042078>, <-0.359613, 4.746262, -0.153301>, <0.688808, 5.062198, -0.455503>, <1.352625, 5.427918, -0.764276>, 
      <-1.277965, 4.370247, -0.225622>, <-0.725179, 4.787694, -0.302946>, <0.422869, 5.066156, -0.620640>, <1.009613, 5.427918, -0.723951>, 
      <-1.280013, 4.370247, -0.523439>, <-0.727227, 4.787694, -0.600763>, <0.170541, 5.066156, -0.778846>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>, 
      <-1.479019, 3.584063, -0.349267>, <-1.529457, 3.584063, -0.617465>, <-1.933409, 3.620178, -0.614618>, <-2.200057, 3.620178, -0.556540>, 
      <-1.108076, 4.032892, -0.786688>, <-1.380911, 4.032892, -0.792606>, <-1.646320, 4.095040, -0.745355>, <-1.644443, 4.095040, -0.472462>, 
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>, 
      <-1.721332, 3.679914, 0.147818>, <-1.503764, 3.679914, 0.100430>, <-1.437864, 3.584063, -0.130435>, <-1.479019, 3.584063, -0.349267>, 
      <-0.975400, 4.037891, -0.234253>, <-0.976931, 4.037891, -0.456916>, <-0.885461, 4.032892, -0.781859>, <-1.108076, 4.032892, -0.786688>, 
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>, 
      <-2.344436, 3.751648, 0.263985>, <-2.300429, 3.751648, 0.497986>, <-1.953981, 3.679914, 0.198490>, <-1.721332, 3.679914, 0.147818>, 
      <-1.344142, 4.057594, 0.210992>, <-1.106095, 4.057594, 0.216155>, <-0.973762, 4.037891, 0.003845>, <-0.975400, 4.037891, -0.234253>, 
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.344436, 3.751648, 0.263985>, <-1.344142, 4.057594, 0.210992>, <-0.761991, 4.370247, 0.048536>, 
      <-2.739142, 3.171135, -0.132044>, <-2.399481, 3.751648, -0.028708>, <-1.641896, 4.057594, 0.204533>, <-1.059745, 4.370247, 0.042078>, 
      <-2.522163, 3.171135, -0.400751>, <-2.491058, 3.620178, -0.493158>, <-1.642395, 4.095040, -0.174646>, <-1.277965, 4.370247, -0.225622>, 
      <-2.231162, 3.171135, -0.464133>, <-2.200057, 3.620178, -0.556540>, <-1.644443, 4.095040, -0.472462>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>, 
      <-1.919775, 2.347050, 0.484065>, <-1.665213, 2.347050, 0.385715>, <-1.646940, 2.276974, 0.044790>, <-1.752520, 2.276974, -0.206858>, 
      <-1.775348, 2.857208, 0.150833>, <-1.825786, 2.857208, -0.117365>, <-1.994206, 2.742499, -0.434003>, <-2.260854, 2.742499, -0.375925>, 
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>, 
      <-2.413154, 2.272171, 0.257782>, <-2.327008, 2.272171, 0.463110>, <-2.127480, 2.347050, 0.564313>, <-1.919775, 2.347050, 0.484065>, 
      <-2.281834, 2.896930, 0.397674>, <-2.064266, 2.896930, 0.350287>, <-1.734194, 2.857208, 0.369665>, <-1.775348, 2.857208, 0.150833>, 
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>, 
      <-2.484832, 2.246145, -0.367567>, <-2.706935, 2.246145, -0.281756>, <-2.505273, 2.272171, 0.038220>, <-2.413154, 2.272171, 0.257782>, 
      <-2.891284, 2.817033, 0.097616>, <-2.847276, 2.817033, 0.331618>, <-2.514483, 2.896930, 0.448347>, <-2.281834, 2.896930, 0.397674>, 
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.484832, 2.246145, -0.367567>, <-2.891284, 2.817033, 0.097616>, <-2.684097, 3.171135, 0.160649>, 
      <-1.862034, 2.015361, -0.477984>, <-2.207022, 2.246145, -0.474900>, <-2.946329, 2.817033, -0.195077>, <-2.739142, 3.171135, -0.132044>, 
      <-1.558362, 2.015361, -0.313465>, <-1.867744, 2.276974, -0.481490>, <-2.551855, 2.742499, -0.312543>, <-2.522163, 3.171135, -0.400751>, 
      <-1.443138, 2.015361, -0.038834>, <-1.752520, 2.276974, -0.206858>, <-2.260854, 2.742499, -0.375925>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.304515, 1.081232, 0.946677>, <0.012086, 1.081232, 1.027701>, <0.240349, 1.081232, 0.878135>, 
      <-0.788855, 1.406922, 0.644678>, <-0.645869, 1.406922, 0.877120>, <-0.365873, 1.469014, 0.687036>, <-0.137609, 1.469014, 0.537470>, 
      <-1.503417, 1.621845, 0.754518>, <-1.248856, 1.621845, 0.656168>, <-0.886311, 1.633789, 0.457885>, <-0.991892, 1.633789, 0.206236>, 
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>, 
      <-0.304515, 1.081232, 0.946677>, <-0.003609, 0.794135, 1.007992>, <0.007566, 0.344951, 1.177824>, <0.231423, 0.000000, 1.265148>, 
      <0.012086, 1.081232, 1.027701>, <0.261255, 0.825587, 1.252283>, <0.214222, 0.345166, 1.356448>, <0.289967, 0.000000, 1.586665>, 
      <0.240349, 1.081232, 0.878135>, <0.489518, 0.825587, 1.102717>, <0.445423, 0.345166, 1.501431>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <-0.358708, 1.081232, 0.329096>, <-0.564168, 1.081232, 0.524578>, <-0.447501, 1.081232, 0.714236>, 
      <-0.717575, 1.431472, 0.062597>, <-0.903823, 1.431472, 0.184633>, <-0.905522, 1.406922, 0.455021>, <-0.788855, 1.406922, 0.644678>, 
      <-1.730134, 1.526020, 0.220968>, <-1.643987, 1.526020, 0.426296>, <-1.711122, 1.621845, 0.834766>, <-1.503417, 1.621845, 0.754518>, 
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>, 
      <-0.358708, 1.081232, 0.329096>, <0.082253, 0.797910, 0.445956>, <0.453044, 0.358581, 0.714490>, <0.769992, 0.000000, 0.958085>, 
      <-0.564168, 1.081232, 0.524578>, <-0.263262, 0.794135, 0.585893>, <0.282729, 0.344951, 0.765668>, <0.506586, 0.000000, 0.852992>, 
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.315237, 1.081232, -0.070085>, <0.026698, 1.081232, 0.076564>, <-0.172460, 1.081232, 0.207060>, 
      <-0.205809, 1.461603, -0.239568>, <-0.330563, 1.461603, -0.442372>, <-0.518416, 1.431472, -0.067899>, <-0.717575, 1.431472, 0.062597>, 
      <-1.444291, 1.550061, -0.376869>, <-1.666394, 1.550061, -0.291059>, <-1.822252, 1.526020, 0.001406>, <-1.730134, 1.526020, 0.220968>, 
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.905100, 0.807287, 0.400843>, <1.042798, 0.363391, 1.184679>, <1.281866, 0.000000, 1.601878>, 
      <0.315237, 1.081232, -0.070085>, <0.780346, 0.807287, 0.198039>, <1.175005, 0.363391, 0.986652>, <1.414073, 0.000000, 1.403851>, 
      <0.026698, 1.081232, 0.076564>, <0.467660, 0.797910, 0.193425>, <0.843411, 0.358581, 0.959283>, <1.160359, 0.000000, 1.202878>, 
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <-0.205809, 1.461603, -0.239568>, <-1.444291, 1.550061, -0.376869>, <-2.139844, 2.015361, -0.370651>, 
      <0.596036, 1.081232, 0.386390>, <-0.049764, 1.461603, 0.014103>, <-1.166480, 1.550061, -0.484202>, <-1.862034, 2.015361, -0.477984>, 
      <0.489460, 1.081232, 0.714909>, <0.111501, 1.469014, 0.374244>, <-1.107115, 1.633789, -0.068395>, <-1.558362, 2.015361, -0.313465>, 
      <0.240349, 1.081232, 0.878135>, <-0.137609, 1.469014, 0.537470>, <-0.991892, 1.633789, 0.206236>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.596036, 1.081232, 0.386390>, <0.489460, 1.081232, 0.714909>, <0.240349, 1.081232, 0.878135>, 
      <0.905100, 0.807287, 0.400843>, <1.061145, 0.807287, 0.654513>, <0.738629, 0.825587, 0.939491>, <0.489518, 0.825587, 1.102717>, 
      <1.042798, 0.363391, 1.184679>, <0.877432, 0.363391, 1.432374>, <0.697740, 0.345166, 1.659655>, <0.445423, 0.345166, 1.501431>, 
      <1.281866, 0.000000, 1.601878>, <1.116500, 0.000000, 1.849573>, <0.773485, 0.000000, 1.889873>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.089280, -0.198443, 1.114731>, <-0.347320, -0.198443, 1.025911>, <-0.643376, -0.198443, 1.164300>, <-0.724791, -0.198443, 1.424772>, 
      <-0.089280, -0.138910, 1.114731>, <-0.347320, -0.138910, 1.025911>, <-0.643376, -0.138910, 1.164300>, <-0.724791, -0.138910, 1.424772>, 
      <-0.068171, -0.055603, 1.112099>, <-0.326212, -0.055603, 1.023279>, <-0.650600, -0.055645, 1.144409>, <-0.732015, -0.055645, 1.404881>, 
      <-0.089280, 0.000000, 1.114731>, <-0.347320, 0.000000, 1.025911>, <-0.643376, 0.000000, 1.164300>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020189, -0.198443, 1.681203>, <0.086618, -0.198443, 1.468675>, <0.121264, -0.198443, 1.187203>, <-0.089280, -0.198443, 1.114731>, 
      <0.020189, -0.138910, 1.681203>, <0.086618, -0.138910, 1.468675>, <0.121264, -0.138910, 1.187203>, <-0.089280, -0.138910, 1.114731>, 
      <0.021745, -0.057184, 1.697688>, <0.088174, -0.057184, 1.485160>, <0.142373, -0.055603, 1.184571>, <-0.068171, -0.055603, 1.112099>, 
      <0.020189, 0.000000, 1.681203>, <0.086618, 0.000000, 1.468675>, <0.121264, 0.000000, 1.187203>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.180684, -0.198443, 2.204948>, <-0.050845, -0.198443, 1.908464>, <0.020189, -0.198443, 1.681203>, 
      <-0.405823, -0.138910, 2.127452>, <-0.180684, -0.138910, 2.204948>, <-0.050845, -0.138910, 1.908464>, <0.020189, -0.138910, 1.681203>, 
      <-0.431374, -0.052836, 2.137433>, <-0.206235, -0.052836, 2.214929>, <-0.049289, -0.057184, 1.924948>, <0.021745, -0.057184, 1.697688>, 
      <-0.405823, 0.000000, 2.127452>, <-0.180684, 0.000000, 2.204948>, <-0.050845, 0.000000, 1.908464>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.405823, -0.138910, 2.127452>, <-0.431374, -0.052836, 2.137433>, <-0.405823, 0.000000, 2.127452>, 
      <-0.687430, -0.198443, 2.030520>, <-0.687430, -0.138910, 2.030520>, <-0.712982, -0.052836, 2.040501>, <-0.687430, 0.000000, 2.030520>, 
      <-0.813641, -0.198443, 1.709033>, <-0.813641, -0.138910, 1.709033>, <-0.820866, -0.055645, 1.689142>, <-0.813641, 0.000000, 1.709033>, 
      <-0.724791, -0.198443, 1.424772>, <-0.724791, -0.138910, 1.424772>, <-0.732015, -0.055645, 1.404881>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>, 
      <-0.111256, 5.626361, -1.587831>, <-0.111256, 5.566828, -1.587831>, <-0.069643, 5.470267, -1.592191>, <-0.111256, 5.427918, -1.587831>, 
      <-0.407302, 5.626361, -1.449420>, <-0.407302, 5.566828, -1.449420>, <-0.368068, 5.468930, -1.431452>, <-0.407302, 5.427918, -1.449420>, 
      <-0.488697, 5.626361, -1.188943>, <-0.488697, 5.566828, -1.188943>, <-0.449464, 5.468930, -1.170975>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>, 
      <0.322715, 5.626361, -1.145098>, <0.322715, 5.566828, -1.145098>, <0.371190, 5.462459, -1.143983>, <0.322715, 5.427918, -1.145098>, 
      <0.357340, 5.626361, -1.426573>, <0.357340, 5.566828, -1.426573>, <0.398953, 5.470267, -1.430933>, <0.357340, 5.427918, -1.426573>, 
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.169677, 5.566828, -0.486286>, <-0.121324, 5.459192, -0.471185>, <-0.169677, 5.427918, -0.486286>, 
      <0.055468, 5.626361, -0.408806>, <0.055468, 5.566828, -0.408806>, <0.103821, 5.459192, -0.393705>, <0.055468, 5.427918, -0.408806>, 
      <0.185284, 5.626361, -0.705300>, <0.185284, 5.566828, -0.705300>, <0.233760, 5.462459, -0.704184>, <0.185284, 5.427918, -0.705300>, 
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.451292, 5.626361, -0.583198>, <-0.577527, 5.626361, -0.904675>, <-0.488697, 5.626361, -1.188943>, 
      <-0.169677, 5.566828, -0.486286>, <-0.451292, 5.566828, -0.583198>, <-0.577527, 5.566828, -0.904675>, <-0.488697, 5.566828, -1.188943>, 
      <-0.121324, 5.459192, -0.471185>, <-0.402939, 5.459192, -0.568097>, <-0.538293, 5.468930, -0.886707>, <-0.449464, 5.468930, -1.170975>, 
      <-0.169677, 5.427918, -0.486286>, <-0.451292, 5.427918, -0.583198>, <-0.577527, 5.427918, -0.904675>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>, 
      <-0.833708, 4.749489, -1.545964>, <-0.897374, 4.749489, -1.811333>, <-1.288948, 4.858728, -1.826220>, <-1.552390, 4.858728, -1.755001>, 
      <-0.195143, 5.079934, -1.463202>, <-0.453190, 5.079934, -1.552004>, <-0.741975, 5.078072, -1.602691>, <-0.823371, 5.078072, -1.342214>, 
      <0.146791, 5.427918, -1.499029>, <-0.111256, 5.427918, -1.587831>, <-0.407302, 5.427918, -1.449420>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>, 
      <-1.087471, 4.821855, -1.003961>, <-0.872520, 4.821855, -1.062071>, <-0.781761, 4.749489, -1.329441>, <-0.833708, 4.749489, -1.545964>, 
      <-0.245976, 5.070017, -0.944121>, <-0.179562, 5.070017, -1.156654>, <0.015406, 5.079934, -1.390746>, <-0.195143, 5.079934, -1.463202>, 
      <0.256302, 5.427918, -0.932566>, <0.322715, 5.427918, -1.145098>, <0.357340, 5.427918, -1.426573>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>, 
      <-1.721542, 4.895757, -0.881118>, <-1.665994, 4.895757, -0.649585>, <-1.317324, 4.821855, -0.941822>, <-1.087471, 4.821855, -1.003961>, 
      <-0.728416, 5.066532, -0.660782>, <-0.503271, 5.066532, -0.583303>, <-0.316993, 5.070017, -0.716856>, <-0.245976, 5.070017, -0.944121>, 
      <-0.169677, 5.427918, -0.486286>, <0.055468, 5.427918, -0.408806>, <0.185284, 5.427918, -0.705300>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-1.721542, 4.895757, -0.881118>, <-0.728416, 5.066532, -0.660782>, <-0.169677, 5.427918, -0.486286>, 
      <-2.181236, 4.370247, -1.382409>, <-1.791023, 4.895757, -1.170723>, <-1.010031, 5.066532, -0.757694>, <-0.451292, 5.427918, -0.583198>, 
      <-1.977838, 4.370247, -1.661536>, <-1.839893, 4.858728, -1.677277>, <-0.912200, 5.078072, -1.057946>, <-0.577527, 5.427918, -0.904675>, 
      <-1.690336, 4.370247, -1.739260>, <-1.552390, 4.858728, -1.755001>, <-0.823371, 5.078072, -1.342214>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>, 
      <-1.333099, 3.508092, -0.763045>, <-1.086548, 3.508092, -0.880034>, <-1.130598, 3.449089, -1.188097>, <-1.254581, 3.449089, -1.431206>, 
      <-1.326556, 4.012984, -1.203660>, <-1.390222, 4.012984, -1.469029>, <-1.546231, 3.947660, -1.796861>, <-1.809673, 3.947660, -1.725642>, 
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>, 
      <-1.899719, 3.499474, -0.954693>, <-1.798557, 3.499474, -0.756332>, <-1.534268, 3.508092, -0.667589>, <-1.333099, 3.508092, -0.763045>, 
      <-1.763151, 4.093690, -0.954238>, <-1.548200, 4.093690, -1.012348>, <-1.274609, 4.012984, -0.987137>, <-1.326556, 4.012984, -1.203660>, 
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>, 
      <-2.045189, 3.455457, -1.547973>, <-2.260304, 3.455457, -1.445900>, <-2.007895, 3.499474, -1.166804>, <-1.899719, 3.499474, -0.954693>, 
      <-2.327029, 4.080334, -1.209586>, <-2.271480, 4.080334, -0.978053>, <-1.993004, 4.093690, -0.892100>, <-1.763151, 4.093690, -0.954238>, 
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.045189, 3.455457, -1.547973>, <-2.327029, 4.080334, -1.209586>, <-2.111756, 4.370247, -1.092804>, 
      <-1.576368, 3.171135, -1.523036>, <-1.776121, 3.455457, -1.675647>, <-2.396509, 4.080334, -1.499191>, <-2.181236, 4.370247, -1.382409>, 
      <-1.261313, 3.171135, -1.381531>, <-1.389888, 3.449089, -1.696518>, <-2.097176, 3.947660, -1.647919>, <-1.977838, 4.370247, -1.661536>, 
      <-1.126006, 3.171135, -1.116219>, <-1.254581, 3.449089, -1.431206>, <-1.809673, 3.947660, -1.725642>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>, 
      <-1.446077, 2.404893, 0.514064>, <-1.286219, 2.404893, 0.735241>, <-0.928331, 2.423455, 0.509982>, <-0.711810, 2.423455, 0.343872>, 
      <-1.397225, 2.794648, -0.100544>, <-1.150674, 2.794648, -0.217534>, <-0.790649, 2.714186, -0.355280>, <-0.914633, 2.714186, -0.598389>, 
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>, 
      <-1.338930, 2.332180, -0.026128>, <-1.515597, 2.332180, 0.109406>, <-1.576511, 2.404893, 0.333598>, <-1.446077, 2.404893, 0.514064>, 
      <-1.751532, 2.713489, -0.532828>, <-1.650370, 2.713489, -0.334467>, <-1.598394, 2.794648, -0.005088>, <-1.397225, 2.794648, -0.100544>, 
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>, 
      <-0.792791, 2.355968, -0.363553>, <-0.932266, 2.355968, -0.556529>, <-1.150016, 2.332180, -0.171059>, <-1.338930, 2.332180, -0.026128>, 
      <-1.467895, 2.633755, -1.106922>, <-1.683010, 2.633755, -1.004849>, <-1.859707, 2.713489, -0.744940>, <-1.751532, 2.713489, -0.532828>, 
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.792791, 2.355968, -0.363553>, <-1.467895, 2.633755, -1.106922>, <-1.845436, 3.171135, -1.395362>, 
      <-0.282849, 2.015361, 0.412566>, <-0.618332, 2.355968, -0.122176>, <-1.198826, 2.633755, -1.234596>, <-1.576368, 3.171135, -1.523036>, 
      <-0.364726, 2.015361, 0.748095>, <-0.475513, 2.423455, 0.162591>, <-1.049940, 2.714186, -0.863701>, <-1.261313, 3.171135, -1.381531>, 
      <-0.601022, 2.015361, 0.929375>, <-0.711810, 2.423455, 0.343872>, <-0.914633, 2.714186, -0.598389>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.763513, 1.081232, 1.372705>, <-0.761351, 1.081232, 1.699502>, <-0.558650, 1.081232, 1.882221>, 
      <-0.764265, 1.396371, 1.128753>, <-0.952698, 1.396371, 1.326154>, <-0.737508, 1.469474, 1.604068>, <-0.534807, 1.469474, 1.786787>, 
      <-1.193420, 1.735064, 1.035033>, <-1.033561, 1.735064, 1.256210>, <-0.756108, 1.789057, 1.420169>, <-0.539586, 1.789057, 1.254059>, 
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>, 
      <-0.763513, 1.081232, 1.372705>, <-0.581696, 0.778367, 1.417443>, <-0.473571, 0.332564, 1.041652>, <-0.347320, 0.000000, 1.025911>, 
      <-0.761351, 1.081232, 1.699502>, <-0.782527, 0.736413, 1.784262>, <-0.600210, 0.332481, 1.283153>, <-0.643376, 0.000000, 1.164300>, 
      <-0.558650, 1.081232, 1.882221>, <-0.579826, 0.736413, 1.966981>, <-0.681624, 0.332481, 1.543625>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <-0.180022, 1.081232, 1.163226>, <-0.421330, 1.081232, 1.014239>, <-0.575080, 1.081232, 1.175304>, 
      <-0.225276, 1.473321, 1.041814>, <-0.390668, 1.473321, 0.892727>, <-0.610516, 1.396371, 0.967687>, <-0.764265, 1.396371, 1.128753>, 
      <-0.789139, 1.701959, 0.604355>, <-0.965806, 1.701959, 0.739890>, <-1.323854, 1.735064, 0.854567>, <-1.193420, 1.735064, 1.035033>, 
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>, 
      <-0.180022, 1.081232, 1.163226>, <-0.041346, 0.823106, 1.341305>, <0.077657, 0.329359, 1.373731>, <0.086618, 0.000000, 1.468675>, 
      <-0.421330, 1.081232, 1.014239>, <-0.239514, 0.778367, 1.058977>, <-0.004986, 0.332564, 1.202945>, <0.121264, 0.000000, 1.187203>, 
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.377436, 1.081232, 1.713488>, <0.162226, 1.081232, 1.471734>, <-0.014631, 1.081232, 1.312313>, 
      <0.201678, 1.525540, 1.454440>, <0.366085, 1.525540, 1.282209>, <-0.048420, 1.473321, 1.201235>, <-0.225276, 1.473321, 1.041814>, 
      <-0.167654, 1.721284, 0.632881>, <-0.307129, 1.721284, 0.439905>, <-0.600225, 1.701959, 0.459425>, <-0.789139, 1.701959, 0.604355>, 
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.220006, 0.808097, 2.150845>, <-0.242420, 0.337888, 2.063625>, <-0.405823, 0.000000, 2.127452>, 
      <0.377436, 1.081232, 1.713488>, <0.384413, 0.808097, 1.978614>, <-0.017281, 0.337888, 2.141120>, <-0.180684, 0.000000, 2.204948>, 
      <0.162226, 1.081232, 1.471734>, <0.300901, 0.823106, 1.649813>, <-0.059807, 0.329359, 1.813520>, <-0.050845, 0.000000, 1.908464>, 
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.201678, 1.525540, 1.454440>, <-0.167654, 1.721284, 0.632881>, <-0.457307, 2.015361, 0.171189>, 
      <0.007386, 1.081232, 2.101148>, <-0.003964, 1.525540, 1.669869>, <0.006805, 1.721284, 0.874259>, <-0.282849, 2.015361, 0.412566>, 
      <-0.337436, 1.081232, 2.081627>, <-0.313593, 1.469474, 1.986193>, <-0.303290, 1.789057, 1.072779>, <-0.364726, 2.015361, 0.748095>, 
      <-0.558650, 1.081232, 1.882221>, <-0.534807, 1.469474, 1.786787>, <-0.539586, 1.789057, 1.254059>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.007386, 1.081232, 2.101148>, <-0.337436, 1.081232, 2.081627>, <-0.558650, 1.081232, 1.882221>, 
      <0.220006, 0.808097, 2.150845>, <0.014363, 0.808097, 2.366274>, <-0.358612, 0.736413, 2.166387>, <-0.579826, 0.736413, 1.966981>, 
      <-0.242420, 0.337888, 2.063625>, <-0.524027, 0.337888, 1.966692>, <-0.770475, 0.332481, 1.827886>, <-0.681624, 0.332481, 1.543625>, 
      <-0.405823, 0.000000, 2.127452>, <-0.687430, 0.000000, 2.030520>, <-0.813641, 0.000000, 1.709033>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576448, -0.198443, 0.535137>, <0.576448, -0.198443, 0.262238>, <0.349236, -0.198443, 0.027343>, <0.076448, -0.198443, 0.035137>, 
      <0.576448, -0.138910, 0.535137>, <0.576448, -0.138910, 0.262238>, <0.349236, -0.138910, 0.027343>, <0.076448, -0.138910, 0.035137>, 
      <0.620136, -0.039925, 0.541587>, <0.620136, -0.039925, 0.268688>, <0.393748, -0.036435, 0.012000>, <0.120960, -0.036435, 0.019794>, 
      <0.576448, 0.000000, 0.535137>, <0.576448, 0.000000, 0.262238>, <0.349236, 0.000000, 0.027343>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076448, -0.198443, 0.823016>, <0.299025, -0.198443, 0.816657>, <0.576448, -0.198443, 0.757805>, <0.576448, -0.198443, 0.535137>, 
      <0.076448, -0.138910, 0.823016>, <0.299025, -0.138910, 0.816657>, <0.576448, -0.138910, 0.757805>, <0.576448, -0.138910, 0.535137>, 
      <0.109274, -0.049569, 0.819921>, <0.331851, -0.049569, 0.813561>, <0.620136, -0.039925, 0.764255>, <0.620136, -0.039925, 0.541587>, 
      <0.076448, 0.000000, 0.823016>, <0.299025, 0.000000, 0.816657>, <0.576448, 0.000000, 0.757805>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.198443, 0.803544>, <-0.161558, -0.198443, 0.829816>, <0.076448, -0.198443, 0.823016>, 
      <-0.484158, -0.138910, 0.565440>, <-0.484158, -0.138910, 0.803544>, <-0.161558, -0.138910, 0.829816>, <0.076448, -0.138910, 0.823016>, 
      <-0.457077, -0.045906, 0.538917>, <-0.457077, -0.045906, 0.777020>, <-0.128733, -0.049569, 0.826721>, <0.109274, -0.049569, 0.819921>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.803544>, <-0.161558, 0.000000, 0.829816>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.138910, 0.565440>, <-0.457077, -0.045906, 0.538917>, <-0.484158, 0.000000, 0.565440>, 
      <-0.484158, -0.198443, 0.267617>, <-0.484158, -0.138910, 0.267617>, <-0.457077, -0.045906, 0.241093>, <-0.484158, 0.000000, 0.267617>, 
      <-0.221254, -0.198443, 0.043643>, <-0.221254, -0.138910, 0.043643>, <-0.176742, -0.036435, 0.028300>, <-0.221254, 0.000000, 0.043643>, 
      <0.076448, -0.198443, 0.035137>, <0.076448, -0.138910, 0.035137>, <0.120960, -0.036435, 0.019794>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>, 
      <0.812457, 5.626361, -2.351572>, <0.812457, 5.566828, -2.351572>, <0.845476, 5.467288, -2.381637>, <0.812457, 5.427918, -2.351572>, 
      <0.585227, 5.626361, -2.586450>, <0.585227, 5.566828, -2.586450>, <0.600840, 5.476916, -2.616443>, <0.585227, 5.427918, -2.586450>, 
      <0.312440, 5.626361, -2.578635>, <0.312440, 5.566828, -2.578635>, <0.328052, 5.476916, -2.608629>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>, 
      <0.535075, 5.626361, -1.797132>, <0.535075, 5.566828, -1.797132>, <0.572463, 5.472019, -1.811323>, <0.535075, 5.427918, -1.797132>, 
      <0.812493, 5.626361, -1.856004>, <0.812493, 5.566828, -1.856004>, <0.845513, 5.467288, -1.886070>, <0.812493, 5.427918, -1.856004>, 
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248127, 5.566828, -2.048291>, <-0.222901, 5.481799, -2.050457>, <-0.248127, 5.427918, -2.048291>, 
      <-0.248110, 5.626361, -1.810188>, <-0.248110, 5.566828, -1.810188>, <-0.222884, 5.481799, -1.812353>, <-0.248110, 5.427918, -1.810188>, 
      <0.074492, 5.626361, -1.783939>, <0.074492, 5.566828, -1.783939>, <0.111880, 5.472019, -1.798129>, <0.074492, 5.427918, -1.783939>, 
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248149, 5.626361, -2.346115>, <0.014739, 5.626361, -2.570108>, <0.312440, 5.626361, -2.578635>, 
      <-0.248127, 5.566828, -2.048291>, <-0.248149, 5.566828, -2.346115>, <0.014739, 5.566828, -2.570108>, <0.312440, 5.566828, -2.578635>, 
      <-0.222901, 5.481799, -2.050457>, <-0.222923, 5.481799, -2.348280>, <0.030351, 5.476916, -2.600101>, <0.328052, 5.476916, -2.608629>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248149, 5.427918, -2.346115>, <0.014739, 5.427918, -2.570108>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>, 
      <0.053971, 4.666623, -1.448852>, <0.284170, 4.666623, -1.595421>, <0.174382, 4.607182, -1.900465>, <0.021298, 4.607182, -2.126384>, 
      <0.517220, 5.075879, -1.809835>, <0.517200, 5.075879, -2.082735>, <0.477637, 5.090263, -2.379763>, <0.204850, 5.090263, -2.371949>, 
      <0.812477, 5.427918, -2.078672>, <0.812457, 5.427918, -2.351572>, <0.585227, 5.427918, -2.586450>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>, 
      <-0.522392, 4.696657, -1.627402>, <-0.397485, 4.696657, -1.443067>, <-0.133856, 4.666623, -1.329261>, <0.053971, 4.666623, -1.448852>, 
      <0.019644, 5.082481, -1.679607>, <0.242221, 5.082481, -1.685983>, <0.517236, 5.075879, -1.587167>, <0.517220, 5.075879, -1.809835>, 
      <0.312498, 5.427918, -1.790756>, <0.535075, 5.427918, -1.797132>, <0.812493, 5.427918, -1.856004>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>, 
      <-0.779386, 4.656022, -2.214925>, <-0.980234, 4.656022, -2.087044>, <-0.655957, 4.696657, -1.824516>, <-0.522392, 4.696657, -1.627402>, 
      <-0.402100, 5.099049, -2.035075>, <-0.402082, 5.099049, -1.796971>, <-0.218362, 5.082481, -1.672789>, <0.019644, 5.082481, -1.679607>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248110, 5.427918, -1.810188>, <0.074492, 5.427918, -1.783939>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-0.779386, 4.656022, -2.214925>, <-0.402100, 5.099049, -2.035075>, <-0.248127, 5.427918, -2.048291>, 
      <-0.585001, 4.370247, -2.157766>, <-0.528163, 4.656022, -2.374880>, <-0.402121, 5.099049, -2.332898>, <-0.248149, 5.427918, -2.346115>, 
      <-0.254871, 4.370247, -2.056291>, <-0.145767, 4.607182, -2.372936>, <-0.092851, 5.090263, -2.363421>, <0.014739, 5.427918, -2.570108>, 
      <-0.087806, 4.370247, -1.809739>, <0.021298, 4.607182, -2.126384>, <0.204850, 5.090263, -2.371949>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>, 
      <-1.069952, 3.613722, 0.048729>, <-0.879086, 3.613722, 0.243780>, <-0.578520, 3.575232, 0.047883>, <-0.389001, 3.575232, -0.148476>, 
      <-0.622336, 3.987164, -0.693640>, <-0.392137, 3.987164, -0.840209>, <-0.144231, 3.915270, -0.975778>, <-0.297315, 3.915270, -1.201697>, 
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>, 
      <-1.142715, 3.545331, -0.498640>, <-1.297350, 3.545331, -0.338424>, <-1.225686, 3.613722, -0.110419>, <-1.069952, 3.613722, 0.048729>, 
      <-1.021373, 3.988560, -1.104980>, <-0.896467, 3.988560, -0.920645>, <-0.810163, 3.987164, -0.574049>, <-0.622336, 3.987164, -0.693640>, 
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>, 
      <-0.630548, 3.514007, -0.842063>, <-0.797077, 3.514007, -1.012244>, <-0.977360, 3.545331, -0.669961>, <-1.142715, 3.545331, -0.498640>, 
      <-0.932696, 3.885198, -1.629301>, <-1.133543, 3.885198, -1.501419>, <-1.154938, 3.988560, -1.302094>, <-1.021373, 3.988560, -1.104980>, 
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.630548, 3.514007, -0.842063>, <-0.932696, 3.885198, -1.629301>, <-0.836224, 4.370247, -1.997811>, 
      <-0.488683, 3.171135, -0.120865>, <-0.422251, 3.514007, -0.629199>, <-0.681473, 3.885198, -1.789256>, <-0.585001, 4.370247, -2.157766>, 
      <-0.519942, 3.171135, 0.223092>, <-0.182172, 3.575232, -0.362767>, <-0.464380, 3.915270, -1.448249>, <-0.254871, 4.370247, -2.056291>, 
      <-0.726770, 3.171135, 0.437383>, <-0.389001, 3.575232, -0.148476>, <-0.297315, 3.915270, -1.201697>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>, 
      <-2.299322, 2.433902, 0.927982>, <-2.456427, 2.433902, 1.151123>, <-2.067432, 2.609972, 1.414828>, <-1.839895, 2.609972, 1.565496>, 
      <-1.664665, 2.890382, 0.671393>, <-1.473799, 2.890382, 0.866444>, <-1.188084, 2.845969, 1.105167>, <-0.998565, 2.845969, 0.908809>, 
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>, 
      <-1.705847, 2.441113, 0.750588>, <-1.891503, 2.441113, 0.627653>, <-2.171134, 2.433902, 0.745913>, <-2.299322, 2.433902, 0.927982>, 
      <-1.398131, 2.837870, 0.206371>, <-1.552766, 2.837870, 0.366587>, <-1.820398, 2.890382, 0.512245>, <-1.664665, 2.890382, 0.671393>, 
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 2.015361, 1.493493>, <-1.155416, 2.015361, 1.298803>, <-1.404070, 2.015361, 1.091604>, <-1.602595, 2.015361, 0.960147>, 
      <-1.157934, 2.534113, 1.086776>, <-1.020861, 2.534113, 0.892087>, <-1.507322, 2.441113, 0.882046>, <-1.705847, 2.441113, 0.750588>, 
      <-0.769447, 2.797116, 0.220784>, <-0.935977, 2.797116, 0.050604>, <-1.232776, 2.837870, 0.035050>, <-1.398131, 2.837870, 0.206371>, 
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 2.015361, 1.493493>, <-1.157934, 2.534113, 1.086776>, <-0.769447, 2.797116, 0.220784>, <-0.696980, 3.171135, -0.333729>, 
      <-1.463942, 2.015361, 1.737014>, <-1.329388, 2.534113, 1.330297>, <-0.561151, 2.797116, 0.433648>, <-0.488683, 3.171135, -0.120865>, 
      <-1.807850, 2.015361, 1.768800>, <-1.591577, 2.609972, 1.729925>, <-0.791737, 2.845969, 0.694517>, <-0.519942, 3.171135, 0.223092>, 
      <-2.056168, 2.015361, 1.604371>, <-1.839895, 2.609972, 1.565496>, <-0.998565, 2.845969, 0.908809>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 1.081232, 0.328402>, <-1.071818, 1.081232, 0.214477>, <-1.380118, 1.081232, 0.322883>, <-1.486914, 1.081232, 0.574017>, 
      <-1.243411, 1.388319, 0.385170>, <-1.491394, 1.388319, 0.271244>, <-1.669056, 1.354284, 0.535491>, <-1.775853, 1.354284, 0.786626>, 
      <-2.030767, 1.513816, 0.883378>, <-2.187872, 1.513816, 1.106520>, <-2.437514, 1.592486, 1.481350>, <-2.209977, 1.592486, 1.632018>, 
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 1.081232, 0.328402>, <-0.395183, 0.767501, 0.270407>, <0.184320, 0.358354, 0.477244>, <0.576448, 0.000000, 0.535137>, 
      <-1.071818, 1.081232, 0.214477>, <-0.643165, 0.767501, 0.156481>, <0.184320, 0.358354, 0.204345>, <0.576448, 0.000000, 0.262238>, 
      <-1.380118, 1.081232, 0.322883>, <-1.000237, 0.722238, 0.043357>, <-0.093932, 0.362750, 0.180100>, <0.349236, 0.000000, 0.027343>, 
      <-1.486914, 1.081232, 0.574017>, <-1.107034, 0.722238, 0.294492>, <-0.366719, 0.362750, 0.187894>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 1.081232, 0.902929>, <-0.683835, 1.081232, 0.698019>, <-0.621499, 1.081232, 0.421358>, <-0.823836, 1.081232, 0.328402>, 
      <-1.011060, 1.369409, 0.922537>, <-0.923921, 1.369409, 0.717628>, <-1.041074, 1.388319, 0.478126>, <-1.243411, 1.388319, 0.385170>, 
      <-1.522739, 1.686080, 1.122222>, <-1.708394, 1.686080, 0.999287>, <-1.902580, 1.513816, 0.701310>, <-2.030767, 1.513816, 0.883378>, 
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 1.081232, 0.902929>, <-0.507092, 0.764493, 0.881377>, <-0.151174, 0.343728, 0.844481>, <0.076448, 0.000000, 0.823016>, 
      <-0.683835, 1.081232, 0.698019>, <-0.419952, 0.764493, 0.676467>, <0.071403, 0.343728, 0.838122>, <0.299025, 0.000000, 0.816657>, 
      <-0.621499, 1.081232, 0.421358>, <-0.192846, 0.767501, 0.363363>, <0.184320, 0.358354, 0.699912>, <0.576448, 0.000000, 0.757805>, 
      <-0.823836, 1.081232, 0.328402>, <-0.395183, 0.767501, 0.270407>, <0.184320, 0.358354, 0.477244>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.022701, 1.081232, 1.404218>, <-0.864153, 1.081232, 1.122042>, <-0.770974, 1.081232, 0.902929>, 
      <-1.337082, 1.325614, 1.417354>, <-1.120719, 1.325614, 1.516753>, <-1.104240, 1.369409, 1.141650>, <-1.011060, 1.369409, 0.922537>, 
      <-1.349758, 1.794570, 1.666600>, <-1.212685, 1.794570, 1.471910>, <-1.324214, 1.686080, 1.253680>, <-1.522739, 1.686080, 1.122222>, 
      <-1.292489, 2.015361, 1.493493>, <-1.155416, 2.015361, 1.298803>, <-1.404070, 2.015361, 1.091604>, <-1.602595, 2.015361, 0.960147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.083811, 0.694152, 1.126572>, <-0.690470, 0.349729, 0.767509>, <-0.484158, 0.000000, 0.565440>, 
      <-1.022701, 1.081232, 1.404218>, <-0.867448, 0.694152, 1.225971>, <-0.690470, 0.349729, 1.005612>, <-0.484158, 0.000000, 0.803544>, 
      <-0.864153, 1.081232, 1.122042>, <-0.600271, 0.764493, 1.100490>, <-0.389180, 0.343728, 0.851281>, <-0.161558, 0.000000, 0.829816>, 
      <-0.770974, 1.081232, 0.902929>, <-0.507092, 0.764493, 0.881377>, <-0.151174, 0.343728, 0.844481>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.337082, 1.325614, 1.417354>, <-1.349758, 1.794570, 1.666600>, <-1.292489, 2.015361, 1.493493>, 
      <-1.509694, 1.081232, 1.180488>, <-1.607712, 1.325614, 1.293024>, <-1.521212, 1.794570, 1.910121>, <-1.463942, 2.015361, 1.737014>, 
      <-1.603465, 1.081232, 0.848088>, <-1.892403, 1.354284, 1.060696>, <-1.961659, 1.592486, 1.796447>, <-1.807850, 2.015361, 1.768800>, 
      <-1.486914, 1.081232, 0.574017>, <-1.775853, 1.354284, 0.786626>, <-2.209977, 1.592486, 1.632018>, <-2.056168, 2.015361, 1.604371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.509694, 1.081232, 1.180488>, <-1.603465, 1.081232, 0.848088>, <-1.486914, 1.081232, 0.574017>, 
      <-1.083811, 0.694152, 1.126572>, <-1.354441, 0.694152, 1.002242>, <-1.223585, 0.722238, 0.568562>, <-1.107034, 0.722238, 0.294492>, 
      <-0.690470, 0.349729, 0.767509>, <-0.690470, 0.349729, 0.469685>, <-0.664421, 0.362750, 0.196400>, <-0.366719, 0.362750, 0.187894>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.267617>, <-0.221254, 0.000000, 0.043643>, <0.076448, 0.000000, 0.035137>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <0.1416, 0.361831, 0.0036>
}
#declare segMshiftMA4 = union {
  object { // Blatt75->Blatt29
    Blatt29
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <-0.903105, 1.458534, -0.800323>
  }
  object { // Blatt76->Blatt29
    Blatt29
    rotate <-20.233294, -23.362207, -124.43499>
    translate  <-3.56144, 0.669132, 2.694692>
  }
  object { Blatt77 }
  object { sPatchObj26 }
  rotate -59.866249*y
  translate  <-5.652217, 0.257935, 44.257397>
}
#declare BezPtch027 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt80 = union {
  cone { // Cone027
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch027 }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare sPatchObj27 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.277127, -0.051562, 0.507806>, <0.125600, -0.051562, 0.734772>, <0.174932, -0.040910, 1.071062>, <0.406133, -0.040910, 1.216045>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.865420, -0.051004, 0.566965>, <0.676775, -0.051004, 0.448668>, <0.400763, -0.051562, 0.322616>, <0.277127, -0.051562, 0.507806>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.184046, -0.040947, 1.104300>, <1.316252, -0.040947, 0.906273>, <1.067142, -0.051004, 0.693461>, <0.865420, -0.051004, 0.566965>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.184046, -0.040947, 1.104300>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.018680, -0.040947, 1.351995>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.658450, -0.040910, 1.374270>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.406133, -0.040910, 1.216045>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>, 
      <-0.855631, 5.429722, 0.730006>, <-0.803530, 5.400920, 0.730006>, <-0.733936, 5.361541, 0.721743>, <-0.681960, 5.333712, 0.730007>, 
      <-0.827295, 5.480978, 1.051520>, <-0.775194, 5.452176, 1.051520>, <-0.690273, 5.431881, 1.050960>, <-0.653624, 5.384969, 1.051520>, 
      <-0.715431, 5.683328, 1.196486>, <-0.663330, 5.654525, 1.196486>, <-0.578409, 5.634231, 1.195926>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>, 
      <-0.595074, 5.901042, 0.422904>, <-0.542973, 5.872240, 0.422904>, <-0.464206, 5.839552, 0.400091>, <-0.421402, 5.805032, 0.422904>, 
      <-0.722518, 5.670511, 0.317830>, <-0.670416, 5.641708, 0.317830>, <-0.600822, 5.602329, 0.309567>, <-0.548846, 5.574500, 0.317830>, 
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.295297, 6.320257, 1.066661>, <-0.202994, 6.299939, 1.044549>, <-0.173727, 6.253049, 1.066661>, 
      <-0.283442, 6.464750, 0.868624>, <-0.231340, 6.435948, 0.868624>, <-0.139038, 6.415630, 0.846512>, <-0.109770, 6.368740, 0.868624>, 
      <-0.406199, 6.242695, 0.667669>, <-0.354098, 6.213892, 0.667669>, <-0.275331, 6.181205, 0.644856>, <-0.232528, 6.146685, 0.667669>, 
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.427396, 6.204352, 1.314368>, <-0.593351, 5.904158, 1.354692>, <-0.715431, 5.683328, 1.196486>, 
      <-0.295297, 6.320257, 1.066661>, <-0.375294, 6.175549, 1.314368>, <-0.541249, 5.875356, 1.354692>, <-0.663330, 5.654525, 1.196486>, 
      <-0.202994, 6.299939, 1.044549>, <-0.282992, 6.155232, 1.292256>, <-0.456328, 5.855060, 1.354132>, <-0.578409, 5.634231, 1.195926>, 
      <-0.173727, 6.253049, 1.066661>, <-0.253725, 6.108342, 1.314368>, <-0.419679, 5.808149, 1.354692>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>, 
      <0.333387, 5.140495, 0.666297>, <0.146841, 4.941398, 0.660378>, <0.089060, 4.814777, 1.059697>, <0.090343, 4.816146, 1.332590>, 
      <-0.246561, 5.272440, 0.560594>, <-0.319864, 5.139843, 0.787572>, <-0.398275, 5.058113, 1.055421>, <-0.286411, 5.260462, 1.200388>, 
      <-0.608657, 5.466310, 0.503029>, <-0.681960, 5.333712, 0.730007>, <-0.653624, 5.384969, 1.051520>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>, 
      <0.632096, 5.471738, 1.114818>, <0.631049, 5.470621, 0.892155>, <0.485597, 5.302945, 0.671125>, <0.333387, 5.140495, 0.666297>, 
      <0.018129, 5.689274, 0.726800>, <-0.073145, 5.524170, 0.608517>, <-0.186750, 5.380631, 0.375396>, <-0.246561, 5.272440, 0.560594>, 
      <-0.330128, 5.970136, 0.541187>, <-0.421402, 5.805032, 0.422904>, <-0.548846, 5.574500, 0.317830>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>, 
      <0.559724, 5.359637, 1.785183>, <0.722485, 5.533348, 1.790346>, <0.633215, 5.472933, 1.352916>, <0.632096, 5.471738, 1.114818>, 
      <0.087598, 5.834381, 1.264095>, <0.151555, 5.950072, 1.066059>, <0.115730, 5.865823, 0.853283>, <0.018129, 5.689274, 0.726800>, 
      <-0.173727, 6.253049, 1.066661>, <-0.109770, 6.368740, 0.868624>, <-0.232528, 6.146685, 0.667669>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.559724, 5.359637, 1.785183>, <0.087598, 5.834381, 1.264095>, <-0.173727, 6.253049, 1.066661>, 
      <0.397381, 4.612405, 1.776704>, <0.356140, 5.142357, 1.778724>, <0.007600, 5.689674, 1.511802>, <-0.253725, 6.108342, 1.314368>, 
      <0.248176, 4.453163, 1.509005>, <0.091744, 4.817640, 1.630407>, <-0.164330, 5.481292, 1.358594>, <-0.419679, 5.808149, 1.354692>, 
      <0.246776, 4.451668, 1.211188>, <0.090343, 4.816146, 1.332590>, <-0.286411, 5.260462, 1.200388>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>, 
      <0.882376, 3.995773, 0.849049>, <0.841315, 3.966481, 0.580851>, <0.516590, 3.777855, 0.584002>, <0.299515, 3.623001, 0.642080>, 
      <0.833105, 4.538882, 0.772586>, <0.646558, 4.339785, 0.766668>, <0.405989, 4.076356, 0.813740>, <0.407272, 4.077726, 1.086633>, 
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>, 
      <0.621171, 3.839677, 1.368932>, <0.798289, 3.966028, 1.321545>, <0.915880, 4.019673, 1.067881>, <0.882376, 3.995773, 0.849049>, 
      <0.944036, 4.565423, 1.345753>, <0.942989, 4.564306, 1.123091>, <0.985314, 4.701332, 0.777415>, <0.833105, 4.538882, 0.772586>, 
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>, 
      <0.099322, 3.489870, 1.437820>, <0.135148, 3.515427, 1.671821>, <0.431775, 3.704567, 1.419605>, <0.621171, 3.839677, 1.368932>, 
      <0.647941, 4.226036, 1.780862>, <0.810702, 4.399747, 1.786026>, <0.945155, 4.566618, 1.583851>, <0.944036, 4.565423, 1.345753>, 
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.099322, 3.489870, 1.437820>, <0.647941, 4.226036, 1.780862>, <0.600965, 4.829686, 1.783163>, 
      <0.032918, 2.989836, 0.761653>, <0.054511, 3.457903, 1.145127>, <0.444357, 4.008756, 1.774404>, <0.397381, 4.612405, 1.776704>, 
      <0.209558, 3.115845, 0.492946>, <0.062615, 3.454004, 0.705462>, <0.408672, 4.079220, 1.384450>, <0.248176, 4.453163, 1.509005>, 
      <0.446457, 3.284843, 0.429564>, <0.299515, 3.623001, 0.642080>, <0.407272, 4.077726, 1.086633>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>, 
      <0.842239, 2.712652, 0.652879>, <1.079409, 2.805129, 0.554528>, <1.039943, 2.771892, 0.171966>, <0.941576, 2.733537, -0.079682>, 
      <0.963539, 3.228570, 0.806736>, <0.922478, 3.199278, 0.538538>, <0.788065, 3.153108, 0.191378>, <0.570991, 2.998253, 0.249456>, 
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>, 
      <0.313144, 2.546508, 0.450622>, <0.393406, 2.577804, 0.655950>, <0.648725, 2.637197, 0.733127>, <0.842239, 2.712652, 0.652879>, 
      <0.512441, 2.929325, 1.049401>, <0.689559, 3.055676, 1.002013>, <0.997042, 3.252470, 1.025568>, <0.963539, 3.228570, 0.806736>, 
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>, 
      <0.147649, 2.501586, -0.170179>, <-0.059280, 2.420900, -0.084369>, <0.227320, 2.513043, 0.231060>, <0.313144, 2.546508, 0.450622>, 
      <0.059256, 2.621347, 0.726264>, <0.095082, 2.646904, 0.960265>, <0.323045, 2.794215, 1.100074>, <0.512441, 2.929325, 1.049401>, 
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.147649, 2.501586, -0.170179>, <0.059256, 2.621347, 0.726264>, <0.077730, 3.021803, 1.054346>, 
      <0.737188, 2.272763, -0.501665>, <0.406479, 2.602509, -0.277512>, <0.014445, 2.589380, 0.433571>, <0.032918, 2.989836, 0.761653>, 
      <1.020113, 2.383082, -0.337147>, <0.834225, 2.691678, -0.354314>, <0.334091, 2.829256, 0.312838>, <0.209558, 3.115845, 0.492946>, 
      <1.127464, 2.424940, -0.062515>, <0.941576, 2.733537, -0.079682>, <0.570991, 2.998253, 0.249456>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <1.184052, 1.106319, 0.616299>, <1.499098, 1.137656, 0.697322>, <1.726240, 1.160250, 0.547756>, 
      <1.129392, 1.459057, 0.396667>, <1.271676, 1.473210, 0.629109>, <1.610121, 1.531984, 0.492588>, <1.837264, 1.554577, 0.343022>, 
      <0.878420, 1.949636, 0.518860>, <1.115590, 2.042113, 0.420509>, <1.461870, 2.071445, 0.210932>, <1.363502, 2.033089, -0.040716>, 
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>, 
      <1.184052, 1.106319, 0.616299>, <1.091978, 0.720794, 0.602838>, <0.350665, 0.343493, 0.698289>, <0.154975, 0.000000, 0.730010>, 
      <1.499098, 1.137656, 0.697322>, <1.364811, 0.660701, 0.944957>, <0.572554, 0.380657, 0.869770>, <0.213519, 0.000000, 1.051528>, 
      <1.726240, 1.160250, 0.547756>, <1.591953, 0.683295, 0.795391>, <0.803756, 0.380657, 1.014753>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.130124, 1.100955, -0.001283>, <0.925674, 1.080618, 0.194200>, <1.041768, 1.092166, 0.383857>, 
      <1.232537, 1.526577, -0.183665>, <1.047204, 1.508142, -0.061629>, <1.013298, 1.447509, 0.207010>, <1.129392, 1.459057, 0.396667>, 
      <0.558680, 1.810340, 0.016388>, <0.638942, 1.841635, 0.221717>, <0.684905, 1.874181, 0.599108>, <0.878420, 1.949636, 0.518860>, 
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>, 
      <1.130124, 1.100955, -0.001283>, <1.211405, 0.701818, 0.057870>, <0.809481, 0.352635, 0.245119>, <0.693544, 0.000000, 0.422947>, 
      <0.925674, 1.080618, 0.194200>, <0.833600, 0.695093, 0.180739>, <0.625828, 0.343493, 0.286133>, <0.430138, 0.000000, 0.317854>, 
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.800760, 1.167662, -0.400463>, <1.513638, 1.139103, -0.253815>, <1.315458, 1.119390, -0.123319>, 
      <1.783199, 1.603298, -0.482420>, <1.659057, 1.590950, -0.685224>, <1.430718, 1.546290, -0.314161>, <1.232537, 1.526577, -0.183665>, 
      <0.816377, 1.834805, -0.623440>, <0.609448, 1.754119, -0.537630>, <0.472855, 1.776875, -0.203174>, <0.558680, 1.810340, 0.016388>, 
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.075298, 0.730756, 0.104570>, <1.407161, 0.386517, 0.712205>, <1.205418, 0.000000, 1.066741>, 
      <1.800760, 1.167662, -0.400463>, <1.951156, 0.718408, -0.098234>, <1.539367, 0.386517, 0.514178>, <1.337625, 0.000000, 0.868714>, 
      <1.513638, 1.139103, -0.253815>, <1.594919, 0.739966, -0.194662>, <1.199848, 0.352635, 0.489912>, <1.083911, 0.000000, 0.667741>, 
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.783199, 1.603298, -0.482420>, <0.816377, 1.834805, -0.623440>, <0.478357, 2.171840, -0.394332>, 
      <2.080181, 1.195456, 0.056011>, <1.938478, 1.618744, -0.228749>, <1.075207, 1.935728, -0.730773>, <0.737188, 2.272763, -0.501665>, 
      <1.974128, 1.184907, 0.384530>, <2.085151, 1.579234, 0.179796>, <1.256151, 1.991230, -0.315348>, <1.020113, 2.383082, -0.337147>, 
      <1.726240, 1.160250, 0.547756>, <1.837264, 1.554577, 0.343022>, <1.363502, 2.033089, -0.040716>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.080181, 1.195456, 0.056011>, <1.974128, 1.184907, 0.384530>, <1.726240, 1.160250, 0.547756>, 
      <2.075298, 0.730756, 0.104570>, <2.230577, 0.746201, 0.358241>, <1.839840, 0.707952, 0.632165>, <1.591953, 0.683295, 0.795391>, 
      <1.407161, 0.386517, 0.712205>, <1.241794, 0.386517, 0.959900>, <1.056073, 0.380657, 1.172978>, <0.803756, 0.380657, 1.014753>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.203692, -0.044900, 0.570272>, <-0.461732, -0.044900, 0.481451>, <-0.765596, -0.033808, 0.611667>, <-0.847011, -0.033808, 0.872139>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.100977, -0.039005, 1.150867>, <-0.034548, -0.039005, 0.938339>, <0.006853, -0.044900, 0.642744>, <-0.203692, -0.044900, 0.570272>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.532826, -0.031427, 1.593172>, <-0.307686, -0.031427, 1.670667>, <-0.172011, -0.039005, 1.378128>, <-0.100977, -0.039005, 1.150867>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.532826, -0.031427, 1.593172>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.814433, -0.031427, 1.496239>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.935861, -0.033808, 1.156400>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.847011, -0.033808, 0.872139>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>, 
      <-1.135645, 4.923207, 0.490812>, <-1.083543, 4.894404, 0.490812>, <-1.016672, 4.849124, 0.499265>, <-0.961974, 4.827198, 0.490812>, 
      <-1.278876, 4.664117, 0.629223>, <-1.226775, 4.635314, 0.629223>, <-1.152234, 4.584241, 0.661968>, <-1.105205, 4.568108, 0.629223>, 
      <-1.318257, 4.592882, 0.889701>, <-1.266155, 4.564079, 0.889701>, <-1.191614, 4.513006, 0.922445>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>, 
      <-0.925682, 5.303006, 0.933545>, <-0.873581, 5.274203, 0.933545>, <-0.794448, 5.245746, 0.949092>, <-0.752011, 5.206996, 0.933545>, 
      <-0.908930, 5.333309, 0.652070>, <-0.856829, 5.304506, 0.652070>, <-0.789958, 5.259225, 0.660524>, <-0.735259, 5.237299, 0.652071>, 
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.111808, 4.843276, 1.592358>, <-1.020927, 4.813514, 1.627003>, <-0.990239, 4.776070, 1.592358>, 
      <-1.054981, 5.069119, 1.669837>, <-1.002880, 5.040316, 1.669837>, <-0.911999, 5.010554, 1.704482>, <-0.881310, 4.973110, 1.669837>, 
      <-0.992174, 5.182731, 1.373344>, <-0.940072, 5.153928, 1.373344>, <-0.860939, 5.125471, 1.388891>, <-0.818503, 5.086722, 1.373344>, 
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.300159, 4.625618, 1.495446>, <-1.361234, 4.515141, 1.173969>, <-1.318257, 4.592882, 0.889701>, 
      <-1.111808, 4.843276, 1.592358>, <-1.248058, 4.596816, 1.495446>, <-1.309132, 4.486338, 1.173969>, <-1.266155, 4.564079, 0.889701>, 
      <-1.020927, 4.813514, 1.627003>, <-1.157177, 4.567053, 1.530091>, <-1.234591, 4.435265, 1.206713>, <-1.191614, 4.513006, 0.922445>, 
      <-0.990239, 4.776070, 1.592358>, <-1.126488, 4.529609, 1.495446>, <-1.187563, 4.419132, 1.173969>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>, 
      <0.045326, 4.803767, 0.387696>, <0.001795, 4.757308, 0.122328>, <-0.247041, 4.434546, 0.099814>, <-0.427165, 4.242303, 0.171033>, 
      <-0.473949, 4.907449, 0.523488>, <-0.598796, 4.681614, 0.434686>, <-0.757509, 4.448831, 0.387136>, <-0.796890, 4.377596, 0.647614>, 
      <-0.837127, 5.053032, 0.579614>, <-0.961974, 4.827198, 0.490812>, <-1.105205, 4.568108, 0.629223>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>, 
      <-0.149898, 4.541390, 0.922230>, <-0.002929, 4.698247, 0.864120>, <0.080844, 4.841674, 0.604220>, <0.045326, 4.803767, 0.387696>, 
      <-0.508679, 4.897343, 1.045159>, <-0.476547, 4.955466, 0.832626>, <-0.372082, 5.091715, 0.595944>, <-0.473949, 4.907449, 0.523488>, 
      <-0.784143, 5.148873, 1.146078>, <-0.752011, 5.206996, 0.933545>, <-0.735259, 5.237299, 0.652071>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>, 
      <-0.581819, 4.032846, 0.952694>, <-0.543838, 4.073382, 1.184228>, <-0.307056, 4.373660, 0.984368>, <-0.149898, 4.541390, 0.922230>, 
      <-0.759944, 4.495076, 1.332377>, <-0.651016, 4.692116, 1.409856>, <-0.543038, 4.835191, 1.272425>, <-0.508679, 4.897343, 1.045159>, 
      <-0.990239, 4.776070, 1.592358>, <-0.881310, 4.973110, 1.669837>, <-0.818503, 5.086722, 1.373344>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.581819, 4.032846, 0.952694>, <-0.759944, 4.495076, 1.332377>, <-0.990239, 4.776070, 1.592358>, 
      <-0.369421, 3.794017, 0.352218>, <-0.629325, 3.982144, 0.663089>, <-0.896194, 4.248615, 1.235465>, <-1.126488, 4.529609, 1.495446>, 
      <-0.230350, 3.942443, 0.073090>, <-0.623741, 4.032504, 0.248756>, <-0.839867, 4.299855, 0.931882>, <-1.187563, 4.419132, 1.173969>, 
      <-0.033775, 4.152243, -0.004633>, <-0.427165, 4.242303, 0.171033>, <-0.796890, 4.377596, 0.647614>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>, 
      <1.025779, 4.093207, 0.381884>, <1.226493, 4.236390, 0.264894>, <1.126390, 4.232918, -0.129444>, <1.025457, 4.160915, -0.372554>, 
      <0.661213, 4.412504, 0.345586>, <0.617682, 4.366044, 0.080217>, <0.525790, 4.257618, -0.245289>, <0.345665, 4.065375, -0.174070>, 
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>, 
      <0.543731, 3.789628, 0.194518>, <0.626086, 3.848378, 0.392879>, <0.862010, 3.976379, 0.477340>, <1.025779, 4.093207, 0.381884>, 
      <0.319543, 4.046286, 0.610188>, <0.466513, 4.203143, 0.552078>, <0.696731, 4.450411, 0.562110>, <0.661213, 4.412504, 0.345586>, 
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>, 
      <0.327542, 3.702958, -0.411287>, <0.152420, 3.578032, -0.309213>, <0.455668, 3.726806, -0.017594>, <0.543731, 3.789628, 0.194518>, 
      <-0.040928, 3.641333, 0.305736>, <-0.002948, 3.681868, 0.537269>, <0.162385, 3.878556, 0.672326>, <0.319543, 4.046286, 0.610188>, 
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.327542, 3.702958, -0.411287>, <-0.040928, 3.641333, 0.305736>, <-0.321914, 3.844720, 0.641823>, 
      <0.979516, 3.665112, -0.629340>, <0.546587, 3.859218, -0.538961>, <-0.088435, 3.590630, 0.016131>, <-0.369421, 3.794017, 0.352218>, 
      <1.235997, 3.848078, -0.487834>, <0.915305, 4.082336, -0.637866>, <0.149090, 3.855576, -0.096347>, <-0.230350, 3.942443, 0.073090>, 
      <1.346149, 3.926657, -0.222522>, <1.025457, 4.160915, -0.372554>, <0.345665, 4.065375, -0.174070>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>, 
      <1.296997, 2.879843, 0.733703>, <1.445934, 2.937916, 0.954880>, <1.774379, 3.091461, 0.797898>, <1.976107, 3.170119, 0.631788>, 
      <1.307648, 3.418247, 0.518613>, <1.508362, 3.561430, 0.401624>, <1.841102, 3.710837, 0.204924>, <1.740168, 3.638834, -0.038185>, 
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>, 
      <1.385444, 2.888728, 0.148511>, <1.220847, 2.824548, 0.284046>, <1.175475, 2.832459, 0.553237>, <1.296997, 2.879843, 0.733703>, 
      <0.987091, 3.240061, 0.036852>, <1.069446, 3.298811, 0.235213>, <1.143879, 3.301419, 0.614069>, <1.307648, 3.418247, 0.518613>, 
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>, 
      <1.906742, 3.131796, -0.157567>, <1.776795, 3.081127, -0.350543>, <1.561452, 2.957357, 0.003581>, <1.385444, 2.888728, 0.148511>, 
      <1.194126, 3.314419, -0.592195>, <1.019004, 3.189493, -0.490122>, <0.899027, 3.177239, -0.175260>, <0.987091, 3.240061, 0.036852>, 
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.906742, 3.131796, -0.157567>, <1.194126, 3.314419, -0.592195>, <0.760471, 3.508852, -0.501665>, 
      <2.208483, 2.846450, 0.388885>, <2.069281, 3.195173, 0.083810>, <1.413171, 3.470679, -0.719869>, <0.979516, 3.665112, -0.629340>, 
      <2.132199, 2.816706, 0.724413>, <2.196260, 3.255960, 0.450507>, <1.630017, 3.560256, -0.303498>, <1.235997, 3.848078, -0.487834>, 
      <1.912047, 2.730864, 0.905694>, <1.976107, 3.170119, 0.631788>, <1.740168, 3.638834, -0.038185>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.727308, 1.060887, 1.042327>, <0.729459, 1.061101, 1.369123>, <0.931165, 1.081165, 1.551842>, 
      <1.130039, 1.453072, 0.877157>, <0.942531, 1.434421, 1.074558>, <1.157661, 1.492077, 1.371658>, <1.359367, 1.512140, 1.554376>, 
      <1.224179, 2.051219, 0.856463>, <1.373116, 2.109292, 1.077641>, <1.635704, 2.140586, 1.390835>, <1.837433, 2.219244, 1.224725>, 
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>, 
      <0.727308, 1.060887, 1.042327>, <0.495765, 0.659030, 1.007652>, <-0.127188, 0.350771, 0.563600>, <-0.423769, 0.000000, 0.490773>, 
      <0.729459, 1.061101, 1.369123>, <0.275535, 0.604236, 1.366437>, <-0.224661, 0.365743, 0.818438>, <-0.719824, 0.000000, 0.629163>, 
      <0.931165, 1.081165, 1.551842>, <0.477241, 0.624300, 1.549155>, <-0.306076, 0.365743, 1.078910>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.307934, 1.118641, 0.832847>, <1.067810, 1.094756, 0.683860>, <0.914816, 1.079538, 0.844926>, 
      <1.709058, 1.529154, 0.846782>, <1.544479, 1.512783, 0.697696>, <1.283033, 1.468290, 0.716091>, <1.130039, 1.453072, 0.877157>, 
      <1.610751, 2.129575, 0.425166>, <1.446154, 2.065395, 0.560700>, <1.102656, 2.003834, 0.675998>, <1.224179, 2.051219, 0.856463>, 
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>, 
      <1.307934, 1.118641, 0.832847>, <1.024882, 0.647009, 0.994571>, <0.440830, 0.375638, 0.887301>, <0.010170, 0.000000, 0.933538>, 
      <1.067810, 1.094756, 0.683860>, <0.836267, 0.692899, 0.649185>, <0.341396, 0.350771, 0.724892>, <0.044816, 0.000000, 0.652066>, 
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.862654, 1.173819, 1.383110>, <1.648500, 1.152517, 1.141355>, <1.472513, 1.135012, 0.981934>, 
      <2.109209, 1.609047, 1.320949>, <2.272809, 1.625320, 1.148717>, <1.885046, 1.546659, 1.006204>, <1.709058, 1.529154, 0.846782>, 
      <2.233965, 2.312047, 0.559578>, <2.104018, 2.261378, 0.366603>, <1.786758, 2.198203, 0.280236>, <1.610751, 2.129575, 0.425166>, 
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.234013, 0.645627, 1.821099>, <0.146906, 0.391119, 1.581650>, <-0.482271, 0.000000, 1.592315>, 
      <1.862654, 1.173819, 1.383110>, <1.397613, 0.661900, 1.648868>, <0.372045, 0.391119, 1.659146>, <-0.257132, 0.000000, 1.669811>, 
      <1.648500, 1.152517, 1.141355>, <1.365448, 0.680885, 1.303079>, <0.303367, 0.375638, 1.327090>, <-0.127293, 0.000000, 1.373327>, 
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <2.109209, 1.609047, 1.320949>, <2.233965, 2.312047, 0.559578>, <2.045943, 2.783073, 0.147508>, 
      <1.494421, 1.137191, 1.770770>, <1.904576, 1.588692, 1.536377>, <2.396504, 2.375424, 0.800956>, <2.208483, 2.846450, 0.388885>, 
      <1.151293, 1.103061, 1.751248>, <1.579494, 1.534036, 1.753783>, <2.057585, 2.305086, 1.043444>, <2.132199, 2.816706, 0.724413>, 
      <0.931165, 1.081165, 1.551842>, <1.359367, 1.512140, 1.554376>, <1.837433, 2.219244, 1.224725>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.494421, 1.137191, 1.770770>, <1.151293, 1.103061, 1.751248>, <0.931165, 1.081165, 1.551842>, 
      <1.234013, 0.645627, 1.821099>, <1.029380, 0.625272, 2.036528>, <0.697369, 0.646196, 1.748562>, <0.477241, 0.624300, 1.549155>, 
      <0.146906, 0.391119, 1.581650>, <-0.134701, 0.391119, 1.484718>, <-0.394926, 0.365743, 1.363171>, <-0.306076, 0.365743, 1.078910>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.492124, -0.059010, 0.000093>, <0.492124, -0.059010, -0.272806>, <0.272471, -0.050458, -0.539386>, <-0.000317, -0.050458, -0.531592>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <-0.029004, -0.050709, 0.276410>, <0.193573, -0.050709, 0.270050>, <0.492124, -0.059010, 0.222761>, <0.492124, -0.059010, 0.000093>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.588494, -0.041496, -0.002015>, <-0.588494, -0.041496, 0.236088>, <-0.267011, -0.050709, 0.283210>, <-0.029004, -0.050709, 0.276410>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.588494, -0.041496, -0.002015>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.588494, -0.041496, -0.299839>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.298019, -0.050458, -0.523086>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <-0.000317, -0.050458, -0.531592>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>, 
      <-0.688738, 5.731613, -0.272928>, <-0.636637, 5.702810, -0.272928>, <-0.568524, 5.652551, -0.292911>, <-0.515067, 5.635604, -0.272929>, 
      <-0.798675, 5.532749, -0.507806>, <-0.746574, 5.503946, -0.507806>, <-0.683223, 5.435931, -0.520220>, <-0.625004, 5.436739, -0.507806>, 
      <-0.930654, 5.294014, -0.499992>, <-0.878553, 5.265211, -0.499992>, <-0.815202, 5.197196, -0.512406>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>, 
      <-0.822940, 5.488857, 0.281511>, <-0.770839, 5.460054, 0.281511>, <-0.706292, 5.409803, 0.279281>, <-0.649269, 5.392847, 0.281511>, 
      <-0.688721, 5.731645, 0.222639>, <-0.636619, 5.702842, 0.222639>, <-0.568507, 5.652583, 0.202657>, <-0.515049, 5.635636, 0.222639>, 
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.149764, 4.774619, 0.030352>, <-1.086901, 4.708347, 0.040188>, <-1.028194, 4.707412, 0.030352>, 
      <-1.201857, 4.803437, 0.268456>, <-1.149755, 4.774634, 0.268456>, <-1.086893, 4.708363, 0.278291>, <-1.028186, 4.707428, 0.268456>, 
      <-1.045777, 5.085768, 0.294705>, <-0.993676, 5.056965, 0.294705>, <-0.929129, 5.006715, 0.292475>, <-0.872106, 4.989758, 0.294705>, 
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.201876, 4.803403, -0.267471>, <-1.074687, 5.033474, -0.491465>, <-0.930654, 5.294014, -0.499992>, 
      <-1.149764, 4.774619, 0.030352>, <-1.149774, 4.774600, -0.267471>, <-1.022585, 5.004672, -0.491465>, <-0.878553, 5.265211, -0.499992>, 
      <-1.086901, 4.708347, 0.040188>, <-1.086912, 4.708328, -0.257636>, <-0.959234, 4.936656, -0.503879>, <-0.815202, 5.197196, -0.512406>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028205, 4.707393, -0.267471>, <-0.901015, 4.937464, -0.491464>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>, 
      <0.673433, 5.542398, 0.382051>, <0.830828, 5.710382, 0.235482>, <0.742311, 5.615008, -0.169149>, <0.637642, 5.503297, -0.395068>, 
      <-0.070189, 5.494588, 0.166260>, <-0.070199, 5.494571, -0.106640>, <-0.075813, 5.444359, -0.390701>, <-0.207791, 5.205623, -0.382888>, 
      <-0.515057, 5.635621, -0.000029>, <-0.515067, 5.635604, -0.272929>, <-0.625004, 5.436739, -0.507806>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>, 
      <0.264924, 5.071978, 0.264958>, <0.350327, 5.163126, 0.449294>, <0.545009, 5.405335, 0.501642>, <0.673433, 5.542398, 0.382051>, 
      <-0.350982, 5.077334, 0.303765>, <-0.243295, 5.272127, 0.297389>, <-0.070181, 5.494603, 0.388928>, <-0.070189, 5.494588, 0.166260>, 
      <-0.756955, 5.198054, 0.287887>, <-0.649269, 5.392847, 0.281511>, <-0.515049, 5.635636, 0.222639>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>, 
      <0.085454, 4.866228, -0.353558>, <-0.051873, 4.719663, -0.225676>, <0.173601, 4.974511, 0.067845>, <0.264924, 5.071978, 0.264958>, 
      <-0.552806, 4.699840, -0.049293>, <-0.552798, 4.699856, 0.188811>, <-0.466133, 4.869038, 0.310582>, <-0.350982, 5.077334, 0.303765>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028186, 4.707428, 0.268456>, <-0.872106, 4.989758, 0.294705>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.085454, 4.866228, -0.353558>, <-0.552806, 4.699840, -0.049293>, <-1.028194, 4.707412, 0.030352>, 
      <0.721979, 4.958841, -0.423140>, <0.257223, 5.049553, -0.513513>, <-0.552817, 4.699822, -0.347116>, <-1.028205, 4.707393, -0.267471>, 
      <0.947700, 5.199747, -0.321664>, <0.523414, 5.381385, -0.641620>, <-0.351824, 4.945084, -0.374360>, <-0.901015, 4.937464, -0.491464>, 
      <1.061928, 5.321660, -0.075112>, <0.637642, 5.503297, -0.395068>, <-0.207791, 5.205623, -0.382888>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>, 
      <1.176418, 4.228400, 1.281084>, <1.331799, 4.339244, 1.476134>, <1.598674, 4.553109, 1.259562>, <1.752959, 4.663172, 1.063204>, 
      <1.237274, 4.881539, 0.845362>, <1.394669, 5.049523, 0.698793>, <1.602658, 5.246691, 0.479642>, <1.497990, 5.134981, 0.253723>, 
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>, 
      <1.168489, 4.198111, 0.682275>, <1.042602, 4.108307, 0.842491>, <1.049638, 4.137958, 1.121936>, <1.176418, 4.228400, 1.281084>, 
      <0.909517, 4.629264, 0.421284>, <0.994920, 4.720412, 0.605619>, <1.108851, 4.744476, 0.964953>, <1.237274, 4.881539, 0.845362>, 
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>, 
      <1.584124, 4.531858, 0.291211>, <1.448555, 4.435146, 0.121030>, <1.303102, 4.294140, 0.510954>, <1.168489, 4.198111, 0.682275>, 
      <0.993460, 4.689001, -0.176992>, <0.856133, 4.542436, -0.049111>, <0.818194, 4.531798, 0.224171>, <0.909517, 4.629264, 0.421284>, 
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.584124, 4.531858, 0.291211>, <0.993460, 4.689001, -0.176992>, <0.550210, 4.775516, -0.263184>, 
      <1.864985, 4.296779, 0.772832>, <1.753695, 4.652825, 0.504075>, <1.165229, 4.872326, -0.336948>, <0.721979, 4.958841, -0.423140>, 
      <1.839537, 4.278626, 1.116789>, <1.921335, 4.783286, 0.848912>, <1.383762, 5.013069, 0.007171>, <0.947700, 5.199747, -0.321664>, 
      <1.671161, 4.158511, 1.331080>, <1.752959, 4.663172, 1.063204>, <1.497990, 5.134981, 0.253723>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>, 
      <0.518744, 2.630839, 1.116586>, <0.372372, 2.573766, 1.339727>, <0.646578, 2.695348, 1.627582>, <0.858569, 2.778007, 1.778251>, 
      <1.007584, 3.225212, 1.369456>, <1.162965, 3.336056, 1.564507>, <1.420558, 3.454205, 1.842865>, <1.574843, 3.564268, 1.646507>, 
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>, 
      <1.058881, 2.809064, 0.967556>, <0.885910, 2.741619, 0.844621>, <0.638173, 2.677407, 0.934517>, <0.518744, 2.630839, 1.116586>, 
      <1.287745, 3.405068, 0.871225>, <1.161858, 3.315264, 1.031441>, <0.880804, 3.134771, 1.210308>, <1.007584, 3.225212, 1.369456>, 
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>, 
      <1.511433, 3.014108, 1.399758>, <1.639141, 3.063904, 1.205068>, <1.243843, 2.881184, 1.099014>, <1.058881, 2.809064, 0.967556>, 
      <1.838591, 3.717745, 0.905735>, <1.703022, 3.621034, 0.735555>, <1.422358, 3.501097, 0.699904>, <1.287745, 3.405068, 0.871225>, 
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.511433, 3.014108, 1.399758>, <1.838591, 3.717745, 0.905735>, <1.695413, 4.175812, 0.559968>, 
      <1.108081, 2.417382, 1.713333>, <1.351693, 2.951822, 1.643279>, <2.008162, 3.838712, 1.118599>, <1.864985, 4.296779, 0.772832>, 
      <0.787669, 2.292448, 1.745119>, <1.089922, 2.868216, 1.942679>, <1.743219, 3.684382, 1.432216>, <1.839537, 4.278626, 1.116789>, 
      <0.556317, 2.202239, 1.580690>, <0.858569, 2.778007, 1.778251>, <1.574843, 3.564268, 1.646507>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.420517, 1.030371, -0.115902>, <0.113731, 0.999855, -0.007496>, <0.007458, 0.989284, 0.243639>, 
      <0.656890, 1.452521, 0.160879>, <0.410125, 1.427975, 0.046953>, <0.215961, 1.404545, 0.374858>, <0.109689, 1.393974, 0.625992>, 
      <0.382882, 1.776536, 0.696127>, <0.236511, 1.719463, 0.919268>, <0.092582, 1.640028, 1.265476>, <0.304574, 1.722688, 1.416144>, 
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>, 
      <0.420517, 1.030371, -0.115902>, <0.428264, 0.733937, -0.237318>, <0.542391, 0.317613, -0.273400>, <0.500000, 0.000000, -0.272899>, 
      <0.113731, 0.999855, -0.007496>, <0.046675, 0.734409, -0.258291>, <0.274764, 0.314693, -0.310764>, <0.272788, 0.000000, -0.507794>, 
      <0.007458, 0.989284, 0.243639>, <-0.059597, 0.723838, -0.007156>, <0.001976, 0.314693, -0.302970>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.806595, 1.068774, 0.367641>, <0.868625, 1.074944, 0.090980>, <0.667281, 1.054916, -0.001976>, 
      <0.873382, 1.431312, 0.674253>, <0.960093, 1.439937, 0.469344>, <0.858233, 1.472548, 0.253834>, <0.656890, 1.452521, 0.160879>, 
      <0.905311, 1.960277, 0.907859>, <0.732340, 1.892832, 0.784924>, <0.502312, 1.823104, 0.514058>, <0.382882, 1.776536, 0.696127>, 
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>, 
      <0.806595, 1.068774, 0.367641>, <0.660698, 0.715990, 0.270974>, <0.414440, 0.335439, 0.357390>, <0.222577, 0.000000, 0.281520>, 
      <0.868625, 1.074944, 0.090980>, <0.876372, 0.778509, -0.030436>, <0.542391, 0.317613, 0.222167>, <0.500000, 0.000000, 0.222668>, 
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.469393, 1.035233, 1.073839>, <0.627162, 1.050926, 0.791664>, <0.719884, 1.060148, 0.572550>, 
      <0.552471, 1.418471, 1.209352>, <0.767772, 1.439887, 1.308751>, <0.780660, 1.422089, 0.893366>, <0.873382, 1.431312, 0.674253>, 
      <1.039269, 1.978267, 1.535535>, <1.166978, 2.028063, 1.340846>, <1.090273, 2.032397, 1.039317>, <0.905311, 1.960277, 0.907859>, 
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.005147, 0.662242, 0.770342>, <-0.334748, 0.336073, 0.292045>, <-0.560606, 0.000000, 0.030303>, 
      <0.469393, 1.035233, 1.073839>, <0.210153, 0.683658, 0.869742>, <-0.334748, 0.336073, 0.530148>, <-0.560606, 0.000000, 0.268407>, 
      <0.627162, 1.050926, 0.791664>, <0.481265, 0.698142, 0.694997>, <-0.046144, 0.335439, 0.370549>, <-0.238007, 0.000000, 0.294679>, 
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.552471, 1.418471, 1.209352>, <1.039269, 1.978267, 1.535535>, <1.267821, 2.479668, 1.469812>, 
      <-0.015209, 0.987030, 0.850110>, <0.283170, 1.391684, 1.085022>, <0.879530, 1.915981, 1.779056>, <1.108081, 2.417382, 1.713333>, 
      <-0.108520, 0.977748, 0.517710>, <-0.006289, 1.382438, 0.900063>, <0.535927, 1.812897, 1.580573>, <0.787669, 2.292448, 1.745119>, 
      <0.007458, 0.989284, 0.243639>, <0.109689, 1.393974, 0.625992>, <0.304574, 1.722688, 1.416144>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.015209, 0.987030, 0.850110>, <-0.108520, 0.977748, 0.517710>, <0.007458, 0.989284, 0.243639>, 
      <-0.005147, 0.662242, 0.770342>, <-0.274448, 0.635455, 0.646012>, <-0.175575, 0.712302, 0.266914>, <-0.059597, 0.723838, -0.007156>, 
      <-0.334748, 0.336073, 0.292045>, <-0.334748, 0.336073, -0.005778>, <-0.295726, 0.314693, -0.294464>, <0.001976, 0.314693, -0.302970>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.379391, -0.15447, -0.074957>
}
#declare segMcurvedMA6 = union {
  object { // Blatt78->Blatt32
    Blatt32
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <0.363186, -1.686824, -1.535598>
  }
  object { // Blatt79->Blatt32
    Blatt32
    rotate <-11.451855, -9.808147, -149.316727>
    translate  <0.806828, -1.041412, 1.867508>
  }
  object { Blatt80 }
  object { sPatchObj27 }
  rotate 2.286723*y
  translate  <-13.754727, 2.846781, 52.096871>
}
#declare BezPtch028 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskin
  }
}
#declare Blatt83 = union {
  cone { // Cone028
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch028 }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.72843, 3.761748, 2.590573>
}
#declare sPatchObj28 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382950, -0.198443, 1.038181>, <0.231423, -0.198443, 1.265148>, <0.289967, -0.198443, 1.586665>, <0.521168, -0.198443, 1.731648>, 
      <0.382950, -0.138910, 1.038181>, <0.231423, -0.138910, 1.265148>, <0.289967, -0.138910, 1.586665>, <0.521168, -0.138910, 1.731648>, 
      <0.414651, -0.048850, 1.050547>, <0.263124, -0.048850, 1.277514>, <0.300659, -0.048722, 1.619162>, <0.531860, -0.048722, 1.764145>, 
      <0.382950, 0.000000, 1.038181>, <0.231423, 0.000000, 1.265148>, <0.289967, 0.000000, 1.586665>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.958637, -0.198443, 1.076381>, <0.769992, -0.198443, 0.958085>, <0.506586, -0.198443, 0.852992>, <0.382950, -0.198443, 1.038181>, 
      <0.958637, -0.138910, 1.076381>, <0.769992, -0.138910, 0.958085>, <0.506586, -0.138910, 0.852992>, <0.382950, -0.138910, 1.038181>, 
      <0.993774, -0.039753, 1.103386>, <0.805129, -0.039753, 0.985090>, <0.538288, -0.048850, 0.865358>, <0.414651, -0.048850, 1.050547>, 
      <0.958637, 0.000000, 1.076381>, <0.769992, 0.000000, 0.958085>, <0.506586, 0.000000, 0.852992>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.414073, -0.198443, 1.403851>, <1.160359, -0.198443, 1.202878>, <0.958637, -0.198443, 1.076381>, 
      <1.281866, -0.138910, 1.601878>, <1.414073, -0.138910, 1.403851>, <1.160359, -0.138910, 1.202878>, <0.958637, -0.138910, 1.076381>, 
      <1.305480, -0.035894, 1.643087>, <1.437687, -0.035894, 1.445060>, <1.195496, -0.039753, 1.229883>, <0.993774, -0.039753, 1.103386>, 
      <1.281866, 0.000000, 1.601878>, <1.414073, 0.000000, 1.403851>, <1.160359, 0.000000, 1.202878>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.281866, -0.138910, 1.601878>, <1.305480, -0.035894, 1.643087>, <1.281866, 0.000000, 1.601878>, 
      <1.116500, -0.198443, 1.849573>, <1.116500, -0.138910, 1.849573>, <1.140114, -0.035894, 1.890782>, <1.116500, 0.000000, 1.849573>, 
      <0.773485, -0.198443, 1.889873>, <0.773485, -0.138910, 1.889873>, <0.784177, -0.048722, 1.922369>, <0.773485, 0.000000, 1.889873>, 
      <0.521168, -0.198443, 1.731648>, <0.521168, -0.138910, 1.731648>, <0.531860, -0.048722, 1.764145>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>, 
      <0.467505, 5.626361, -1.348637>, <0.467505, 5.566828, -1.348637>, <0.509780, 5.466167, -1.365785>, <0.467505, 5.427918, -1.348637>, 
      <0.526073, 5.626361, -1.027124>, <0.526073, 5.566828, -1.027124>, <0.576188, 5.458817, -1.035948>, <0.526073, 5.427918, -1.027124>, 
      <0.757285, 5.626361, -0.882157>, <0.757285, 5.566828, -0.882157>, <0.807400, 5.458817, -0.890982>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>, 
      <1.006052, 5.626361, -1.655739>, <1.006052, 5.566828, -1.655739>, <1.048927, 5.459842, -1.681945>, <1.006052, 5.427918, -1.655739>, 
      <0.742638, 5.626361, -1.760813>, <0.742638, 5.566828, -1.760813>, <0.784913, 5.466167, -1.777961>, <0.742638, 5.427918, -1.760813>, 
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.517973, 5.566828, -1.011983>, <1.566262, 5.454522, -1.034444>, <1.517973, 5.427918, -1.011983>, 
      <1.650165, 5.626361, -1.210019>, <1.650165, 5.566828, -1.210019>, <1.698454, 5.454522, -1.232481>, <1.650165, 5.427918, -1.210019>, 
      <1.396437, 5.626361, -1.410974>, <1.396437, 5.566828, -1.410974>, <1.439313, 5.459842, -1.437179>, <1.396437, 5.427918, -1.410974>, 
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.352625, 5.626361, -0.764276>, <1.009613, 5.626361, -0.723951>, <0.757285, 5.626361, -0.882157>, 
      <1.517973, 5.566828, -1.011983>, <1.352625, 5.566828, -0.764276>, <1.009613, 5.566828, -0.723951>, <0.757285, 5.566828, -0.882157>, 
      <1.566262, 5.454522, -1.034444>, <1.400914, 5.454522, -0.786737>, <1.059728, 5.458817, -0.732776>, <0.807400, 5.458817, -0.890982>, 
      <1.517973, 5.427918, -1.011983>, <1.352625, 5.427918, -0.764276>, <1.009613, 5.427918, -0.723951>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>, 
      <-0.416768, 4.721273, -1.247418>, <-0.689604, 4.721273, -1.253336>, <-0.729103, 4.787694, -0.873656>, <-0.727227, 4.787694, -0.600763>, 
      <0.228340, 5.074441, -1.417145>, <0.076830, 5.074441, -1.190167>, <-0.060671, 5.066156, -0.923812>, <0.170541, 5.066156, -0.778846>, 
      <0.619016, 5.427918, -1.575614>, <0.467505, 5.427918, -1.348637>, <0.526073, 5.427918, -1.027124>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>, 
      <0.010389, 4.716106, -0.789508>, <0.008858, 4.716106, -1.012170>, <-0.194153, 4.721273, -1.242589>, <-0.416768, 4.721273, -1.247418>, 
      <0.710236, 5.067195, -1.241350>, <0.521582, 5.067195, -1.359633>, <0.351963, 5.074441, -1.602344>, <0.228340, 5.074441, -1.417145>, 
      <1.194706, 5.427918, -1.537457>, <1.006052, 5.427918, -1.655739>, <0.742638, 5.427918, -1.760813>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>, 
      <-0.061860, 4.746262, -0.146843>, <0.176188, 4.746262, -0.141679>, <0.012026, 4.716106, -0.551410>, <0.010389, 4.716106, -0.789508>, 
      <0.854156, 5.062198, -0.703210>, <0.986348, 5.062198, -0.901247>, <0.911968, 5.067195, -1.114868>, <0.710236, 5.067195, -1.241350>, 
      <1.517973, 5.427918, -1.011983>, <1.650165, 5.427918, -1.210019>, <1.396437, 5.427918, -1.410974>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.061860, 4.746262, -0.146843>, <0.854156, 5.062198, -0.703210>, <1.517973, 5.427918, -1.011983>, 
      <-1.059745, 4.370247, 0.042078>, <-0.359613, 4.746262, -0.153301>, <0.688808, 5.062198, -0.455503>, <1.352625, 5.427918, -0.764276>, 
      <-1.277965, 4.370247, -0.225622>, <-0.725179, 4.787694, -0.302946>, <0.422869, 5.066156, -0.620640>, <1.009613, 5.427918, -0.723951>, 
      <-1.280013, 4.370247, -0.523439>, <-0.727227, 4.787694, -0.600763>, <0.170541, 5.066156, -0.778846>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>, 
      <-1.479019, 3.584063, -0.349267>, <-1.529457, 3.584063, -0.617465>, <-1.933409, 3.620178, -0.614618>, <-2.200057, 3.620178, -0.556540>, 
      <-1.108076, 4.032892, -0.786688>, <-1.380911, 4.032892, -0.792606>, <-1.646320, 4.095040, -0.745355>, <-1.644443, 4.095040, -0.472462>, 
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>, 
      <-1.721332, 3.679914, 0.147818>, <-1.503764, 3.679914, 0.100430>, <-1.437864, 3.584063, -0.130435>, <-1.479019, 3.584063, -0.349267>, 
      <-0.975400, 4.037891, -0.234253>, <-0.976931, 4.037891, -0.456916>, <-0.885461, 4.032892, -0.781859>, <-1.108076, 4.032892, -0.786688>, 
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>, 
      <-2.344436, 3.751648, 0.263985>, <-2.300429, 3.751648, 0.497986>, <-1.953981, 3.679914, 0.198490>, <-1.721332, 3.679914, 0.147818>, 
      <-1.344142, 4.057594, 0.210992>, <-1.106095, 4.057594, 0.216155>, <-0.973762, 4.037891, 0.003845>, <-0.975400, 4.037891, -0.234253>, 
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.344436, 3.751648, 0.263985>, <-1.344142, 4.057594, 0.210992>, <-0.761991, 4.370247, 0.048536>, 
      <-2.739142, 3.171135, -0.132044>, <-2.399481, 3.751648, -0.028708>, <-1.641896, 4.057594, 0.204533>, <-1.059745, 4.370247, 0.042078>, 
      <-2.522163, 3.171135, -0.400751>, <-2.491058, 3.620178, -0.493158>, <-1.642395, 4.095040, -0.174646>, <-1.277965, 4.370247, -0.225622>, 
      <-2.231162, 3.171135, -0.464133>, <-2.200057, 3.620178, -0.556540>, <-1.644443, 4.095040, -0.472462>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>, 
      <-1.919775, 2.347050, 0.484065>, <-1.665213, 2.347050, 0.385715>, <-1.646940, 2.276974, 0.044790>, <-1.752520, 2.276974, -0.206858>, 
      <-1.775348, 2.857208, 0.150833>, <-1.825786, 2.857208, -0.117365>, <-1.994206, 2.742499, -0.434003>, <-2.260854, 2.742499, -0.375925>, 
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>, 
      <-2.413154, 2.272171, 0.257782>, <-2.327008, 2.272171, 0.463110>, <-2.127480, 2.347050, 0.564313>, <-1.919775, 2.347050, 0.484065>, 
      <-2.281834, 2.896930, 0.397674>, <-2.064266, 2.896930, 0.350287>, <-1.734194, 2.857208, 0.369665>, <-1.775348, 2.857208, 0.150833>, 
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>, 
      <-2.484832, 2.246145, -0.367567>, <-2.706935, 2.246145, -0.281756>, <-2.505273, 2.272171, 0.038220>, <-2.413154, 2.272171, 0.257782>, 
      <-2.891284, 2.817033, 0.097616>, <-2.847276, 2.817033, 0.331618>, <-2.514483, 2.896930, 0.448347>, <-2.281834, 2.896930, 0.397674>, 
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.484832, 2.246145, -0.367567>, <-2.891284, 2.817033, 0.097616>, <-2.684097, 3.171135, 0.160649>, 
      <-1.862034, 2.015361, -0.477984>, <-2.207022, 2.246145, -0.474900>, <-2.946329, 2.817033, -0.195077>, <-2.739142, 3.171135, -0.132044>, 
      <-1.558362, 2.015361, -0.313465>, <-1.867744, 2.276974, -0.481490>, <-2.551855, 2.742499, -0.312543>, <-2.522163, 3.171135, -0.400751>, 
      <-1.443138, 2.015361, -0.038834>, <-1.752520, 2.276974, -0.206858>, <-2.260854, 2.742499, -0.375925>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.304515, 1.081232, 0.946677>, <0.012086, 1.081232, 1.027701>, <0.240349, 1.081232, 0.878135>, 
      <-0.788855, 1.406922, 0.644678>, <-0.645869, 1.406922, 0.877120>, <-0.365873, 1.469014, 0.687036>, <-0.137609, 1.469014, 0.537470>, 
      <-1.503417, 1.621845, 0.754518>, <-1.248856, 1.621845, 0.656168>, <-0.886311, 1.633789, 0.457885>, <-0.991892, 1.633789, 0.206236>, 
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>, 
      <-0.304515, 1.081232, 0.946677>, <-0.003609, 0.794135, 1.007992>, <0.007566, 0.344951, 1.177824>, <0.231423, 0.000000, 1.265148>, 
      <0.012086, 1.081232, 1.027701>, <0.261255, 0.825587, 1.252283>, <0.214222, 0.345166, 1.356448>, <0.289967, 0.000000, 1.586665>, 
      <0.240349, 1.081232, 0.878135>, <0.489518, 0.825587, 1.102717>, <0.445423, 0.345166, 1.501431>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <-0.358708, 1.081232, 0.329096>, <-0.564168, 1.081232, 0.524578>, <-0.447501, 1.081232, 0.714236>, 
      <-0.717575, 1.431472, 0.062597>, <-0.903823, 1.431472, 0.184633>, <-0.905522, 1.406922, 0.455021>, <-0.788855, 1.406922, 0.644678>, 
      <-1.730134, 1.526020, 0.220968>, <-1.643987, 1.526020, 0.426296>, <-1.711122, 1.621845, 0.834766>, <-1.503417, 1.621845, 0.754518>, 
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>, 
      <-0.358708, 1.081232, 0.329096>, <0.082253, 0.797910, 0.445956>, <0.453044, 0.358581, 0.714490>, <0.769992, 0.000000, 0.958085>, 
      <-0.564168, 1.081232, 0.524578>, <-0.263262, 0.794135, 0.585893>, <0.282729, 0.344951, 0.765668>, <0.506586, 0.000000, 0.852992>, 
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.315237, 1.081232, -0.070085>, <0.026698, 1.081232, 0.076564>, <-0.172460, 1.081232, 0.207060>, 
      <-0.205809, 1.461603, -0.239568>, <-0.330563, 1.461603, -0.442372>, <-0.518416, 1.431472, -0.067899>, <-0.717575, 1.431472, 0.062597>, 
      <-1.444291, 1.550061, -0.376869>, <-1.666394, 1.550061, -0.291059>, <-1.822252, 1.526020, 0.001406>, <-1.730134, 1.526020, 0.220968>, 
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.905100, 0.807287, 0.400843>, <1.042798, 0.363391, 1.184679>, <1.281866, 0.000000, 1.601878>, 
      <0.315237, 1.081232, -0.070085>, <0.780346, 0.807287, 0.198039>, <1.175005, 0.363391, 0.986652>, <1.414073, 0.000000, 1.403851>, 
      <0.026698, 1.081232, 0.076564>, <0.467660, 0.797910, 0.193425>, <0.843411, 0.358581, 0.959283>, <1.160359, 0.000000, 1.202878>, 
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <-0.205809, 1.461603, -0.239568>, <-1.444291, 1.550061, -0.376869>, <-2.139844, 2.015361, -0.370651>, 
      <0.596036, 1.081232, 0.386390>, <-0.049764, 1.461603, 0.014103>, <-1.166480, 1.550061, -0.484202>, <-1.862034, 2.015361, -0.477984>, 
      <0.489460, 1.081232, 0.714909>, <0.111501, 1.469014, 0.374244>, <-1.107115, 1.633789, -0.068395>, <-1.558362, 2.015361, -0.313465>, 
      <0.240349, 1.081232, 0.878135>, <-0.137609, 1.469014, 0.537470>, <-0.991892, 1.633789, 0.206236>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.596036, 1.081232, 0.386390>, <0.489460, 1.081232, 0.714909>, <0.240349, 1.081232, 0.878135>, 
      <0.905100, 0.807287, 0.400843>, <1.061145, 0.807287, 0.654513>, <0.738629, 0.825587, 0.939491>, <0.489518, 0.825587, 1.102717>, 
      <1.042798, 0.363391, 1.184679>, <0.877432, 0.363391, 1.432374>, <0.697740, 0.345166, 1.659655>, <0.445423, 0.345166, 1.501431>, 
      <1.281866, 0.000000, 1.601878>, <1.116500, 0.000000, 1.849573>, <0.773485, 0.000000, 1.889873>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.089280, -0.198443, 1.114731>, <-0.347320, -0.198443, 1.025911>, <-0.643376, -0.198443, 1.164300>, <-0.724791, -0.198443, 1.424772>, 
      <-0.089280, -0.138910, 1.114731>, <-0.347320, -0.138910, 1.025911>, <-0.643376, -0.138910, 1.164300>, <-0.724791, -0.138910, 1.424772>, 
      <-0.068171, -0.055603, 1.112099>, <-0.326212, -0.055603, 1.023279>, <-0.650600, -0.055645, 1.144409>, <-0.732015, -0.055645, 1.404881>, 
      <-0.089280, 0.000000, 1.114731>, <-0.347320, 0.000000, 1.025911>, <-0.643376, 0.000000, 1.164300>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020189, -0.198443, 1.681203>, <0.086618, -0.198443, 1.468675>, <0.121264, -0.198443, 1.187203>, <-0.089280, -0.198443, 1.114731>, 
      <0.020189, -0.138910, 1.681203>, <0.086618, -0.138910, 1.468675>, <0.121264, -0.138910, 1.187203>, <-0.089280, -0.138910, 1.114731>, 
      <0.021745, -0.057184, 1.697688>, <0.088174, -0.057184, 1.485160>, <0.142373, -0.055603, 1.184571>, <-0.068171, -0.055603, 1.112099>, 
      <0.020189, 0.000000, 1.681203>, <0.086618, 0.000000, 1.468675>, <0.121264, 0.000000, 1.187203>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.180684, -0.198443, 2.204948>, <-0.050845, -0.198443, 1.908464>, <0.020189, -0.198443, 1.681203>, 
      <-0.405823, -0.138910, 2.127452>, <-0.180684, -0.138910, 2.204948>, <-0.050845, -0.138910, 1.908464>, <0.020189, -0.138910, 1.681203>, 
      <-0.431374, -0.052836, 2.137433>, <-0.206235, -0.052836, 2.214929>, <-0.049289, -0.057184, 1.924948>, <0.021745, -0.057184, 1.697688>, 
      <-0.405823, 0.000000, 2.127452>, <-0.180684, 0.000000, 2.204948>, <-0.050845, 0.000000, 1.908464>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.405823, -0.138910, 2.127452>, <-0.431374, -0.052836, 2.137433>, <-0.405823, 0.000000, 2.127452>, 
      <-0.687430, -0.198443, 2.030520>, <-0.687430, -0.138910, 2.030520>, <-0.712982, -0.052836, 2.040501>, <-0.687430, 0.000000, 2.030520>, 
      <-0.813641, -0.198443, 1.709033>, <-0.813641, -0.138910, 1.709033>, <-0.820866, -0.055645, 1.689142>, <-0.813641, 0.000000, 1.709033>, 
      <-0.724791, -0.198443, 1.424772>, <-0.724791, -0.138910, 1.424772>, <-0.732015, -0.055645, 1.404881>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>, 
      <-0.111256, 5.626361, -1.587831>, <-0.111256, 5.566828, -1.587831>, <-0.069643, 5.470267, -1.592191>, <-0.111256, 5.427918, -1.587831>, 
      <-0.407302, 5.626361, -1.449420>, <-0.407302, 5.566828, -1.449420>, <-0.368068, 5.468930, -1.431452>, <-0.407302, 5.427918, -1.449420>, 
      <-0.488697, 5.626361, -1.188943>, <-0.488697, 5.566828, -1.188943>, <-0.449464, 5.468930, -1.170975>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>, 
      <0.322715, 5.626361, -1.145098>, <0.322715, 5.566828, -1.145098>, <0.371190, 5.462459, -1.143983>, <0.322715, 5.427918, -1.145098>, 
      <0.357340, 5.626361, -1.426573>, <0.357340, 5.566828, -1.426573>, <0.398953, 5.470267, -1.430933>, <0.357340, 5.427918, -1.426573>, 
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.169677, 5.566828, -0.486286>, <-0.121324, 5.459192, -0.471185>, <-0.169677, 5.427918, -0.486286>, 
      <0.055468, 5.626361, -0.408806>, <0.055468, 5.566828, -0.408806>, <0.103821, 5.459192, -0.393705>, <0.055468, 5.427918, -0.408806>, 
      <0.185284, 5.626361, -0.705300>, <0.185284, 5.566828, -0.705300>, <0.233760, 5.462459, -0.704184>, <0.185284, 5.427918, -0.705300>, 
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.451292, 5.626361, -0.583198>, <-0.577527, 5.626361, -0.904675>, <-0.488697, 5.626361, -1.188943>, 
      <-0.169677, 5.566828, -0.486286>, <-0.451292, 5.566828, -0.583198>, <-0.577527, 5.566828, -0.904675>, <-0.488697, 5.566828, -1.188943>, 
      <-0.121324, 5.459192, -0.471185>, <-0.402939, 5.459192, -0.568097>, <-0.538293, 5.468930, -0.886707>, <-0.449464, 5.468930, -1.170975>, 
      <-0.169677, 5.427918, -0.486286>, <-0.451292, 5.427918, -0.583198>, <-0.577527, 5.427918, -0.904675>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>, 
      <-0.833708, 4.749489, -1.545964>, <-0.897374, 4.749489, -1.811333>, <-1.288948, 4.858728, -1.826220>, <-1.552390, 4.858728, -1.755001>, 
      <-0.195143, 5.079934, -1.463202>, <-0.453190, 5.079934, -1.552004>, <-0.741975, 5.078072, -1.602691>, <-0.823371, 5.078072, -1.342214>, 
      <0.146791, 5.427918, -1.499029>, <-0.111256, 5.427918, -1.587831>, <-0.407302, 5.427918, -1.449420>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>, 
      <-1.087471, 4.821855, -1.003961>, <-0.872520, 4.821855, -1.062071>, <-0.781761, 4.749489, -1.329441>, <-0.833708, 4.749489, -1.545964>, 
      <-0.245976, 5.070017, -0.944121>, <-0.179562, 5.070017, -1.156654>, <0.015406, 5.079934, -1.390746>, <-0.195143, 5.079934, -1.463202>, 
      <0.256302, 5.427918, -0.932566>, <0.322715, 5.427918, -1.145098>, <0.357340, 5.427918, -1.426573>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>, 
      <-1.721542, 4.895757, -0.881118>, <-1.665994, 4.895757, -0.649585>, <-1.317324, 4.821855, -0.941822>, <-1.087471, 4.821855, -1.003961>, 
      <-0.728416, 5.066532, -0.660782>, <-0.503271, 5.066532, -0.583303>, <-0.316993, 5.070017, -0.716856>, <-0.245976, 5.070017, -0.944121>, 
      <-0.169677, 5.427918, -0.486286>, <0.055468, 5.427918, -0.408806>, <0.185284, 5.427918, -0.705300>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-1.721542, 4.895757, -0.881118>, <-0.728416, 5.066532, -0.660782>, <-0.169677, 5.427918, -0.486286>, 
      <-2.181236, 4.370247, -1.382409>, <-1.791023, 4.895757, -1.170723>, <-1.010031, 5.066532, -0.757694>, <-0.451292, 5.427918, -0.583198>, 
      <-1.977838, 4.370247, -1.661536>, <-1.839893, 4.858728, -1.677277>, <-0.912200, 5.078072, -1.057946>, <-0.577527, 5.427918, -0.904675>, 
      <-1.690336, 4.370247, -1.739260>, <-1.552390, 4.858728, -1.755001>, <-0.823371, 5.078072, -1.342214>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>, 
      <-1.333099, 3.508092, -0.763045>, <-1.086548, 3.508092, -0.880034>, <-1.130598, 3.449089, -1.188097>, <-1.254581, 3.449089, -1.431206>, 
      <-1.326556, 4.012984, -1.203660>, <-1.390222, 4.012984, -1.469029>, <-1.546231, 3.947660, -1.796861>, <-1.809673, 3.947660, -1.725642>, 
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>, 
      <-1.899719, 3.499474, -0.954693>, <-1.798557, 3.499474, -0.756332>, <-1.534268, 3.508092, -0.667589>, <-1.333099, 3.508092, -0.763045>, 
      <-1.763151, 4.093690, -0.954238>, <-1.548200, 4.093690, -1.012348>, <-1.274609, 4.012984, -0.987137>, <-1.326556, 4.012984, -1.203660>, 
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>, 
      <-2.045189, 3.455457, -1.547973>, <-2.260304, 3.455457, -1.445900>, <-2.007895, 3.499474, -1.166804>, <-1.899719, 3.499474, -0.954693>, 
      <-2.327029, 4.080334, -1.209586>, <-2.271480, 4.080334, -0.978053>, <-1.993004, 4.093690, -0.892100>, <-1.763151, 4.093690, -0.954238>, 
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.045189, 3.455457, -1.547973>, <-2.327029, 4.080334, -1.209586>, <-2.111756, 4.370247, -1.092804>, 
      <-1.576368, 3.171135, -1.523036>, <-1.776121, 3.455457, -1.675647>, <-2.396509, 4.080334, -1.499191>, <-2.181236, 4.370247, -1.382409>, 
      <-1.261313, 3.171135, -1.381531>, <-1.389888, 3.449089, -1.696518>, <-2.097176, 3.947660, -1.647919>, <-1.977838, 4.370247, -1.661536>, 
      <-1.126006, 3.171135, -1.116219>, <-1.254581, 3.449089, -1.431206>, <-1.809673, 3.947660, -1.725642>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>, 
      <-1.446077, 2.404893, 0.514064>, <-1.286219, 2.404893, 0.735241>, <-0.928331, 2.423455, 0.509982>, <-0.711810, 2.423455, 0.343872>, 
      <-1.397225, 2.794648, -0.100544>, <-1.150674, 2.794648, -0.217534>, <-0.790649, 2.714186, -0.355280>, <-0.914633, 2.714186, -0.598389>, 
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>, 
      <-1.338930, 2.332180, -0.026128>, <-1.515597, 2.332180, 0.109406>, <-1.576511, 2.404893, 0.333598>, <-1.446077, 2.404893, 0.514064>, 
      <-1.751532, 2.713489, -0.532828>, <-1.650370, 2.713489, -0.334467>, <-1.598394, 2.794648, -0.005088>, <-1.397225, 2.794648, -0.100544>, 
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>, 
      <-0.792791, 2.355968, -0.363553>, <-0.932266, 2.355968, -0.556529>, <-1.150016, 2.332180, -0.171059>, <-1.338930, 2.332180, -0.026128>, 
      <-1.467895, 2.633755, -1.106922>, <-1.683010, 2.633755, -1.004849>, <-1.859707, 2.713489, -0.744940>, <-1.751532, 2.713489, -0.532828>, 
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.792791, 2.355968, -0.363553>, <-1.467895, 2.633755, -1.106922>, <-1.845436, 3.171135, -1.395362>, 
      <-0.282849, 2.015361, 0.412566>, <-0.618332, 2.355968, -0.122176>, <-1.198826, 2.633755, -1.234596>, <-1.576368, 3.171135, -1.523036>, 
      <-0.364726, 2.015361, 0.748095>, <-0.475513, 2.423455, 0.162591>, <-1.049940, 2.714186, -0.863701>, <-1.261313, 3.171135, -1.381531>, 
      <-0.601022, 2.015361, 0.929375>, <-0.711810, 2.423455, 0.343872>, <-0.914633, 2.714186, -0.598389>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.763513, 1.081232, 1.372705>, <-0.761351, 1.081232, 1.699502>, <-0.558650, 1.081232, 1.882221>, 
      <-0.764265, 1.396371, 1.128753>, <-0.952698, 1.396371, 1.326154>, <-0.737508, 1.469474, 1.604068>, <-0.534807, 1.469474, 1.786787>, 
      <-1.193420, 1.735064, 1.035033>, <-1.033561, 1.735064, 1.256210>, <-0.756108, 1.789057, 1.420169>, <-0.539586, 1.789057, 1.254059>, 
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>, 
      <-0.763513, 1.081232, 1.372705>, <-0.581696, 0.778367, 1.417443>, <-0.473571, 0.332564, 1.041652>, <-0.347320, 0.000000, 1.025911>, 
      <-0.761351, 1.081232, 1.699502>, <-0.782527, 0.736413, 1.784262>, <-0.600210, 0.332481, 1.283153>, <-0.643376, 0.000000, 1.164300>, 
      <-0.558650, 1.081232, 1.882221>, <-0.579826, 0.736413, 1.966981>, <-0.681624, 0.332481, 1.543625>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <-0.180022, 1.081232, 1.163226>, <-0.421330, 1.081232, 1.014239>, <-0.575080, 1.081232, 1.175304>, 
      <-0.225276, 1.473321, 1.041814>, <-0.390668, 1.473321, 0.892727>, <-0.610516, 1.396371, 0.967687>, <-0.764265, 1.396371, 1.128753>, 
      <-0.789139, 1.701959, 0.604355>, <-0.965806, 1.701959, 0.739890>, <-1.323854, 1.735064, 0.854567>, <-1.193420, 1.735064, 1.035033>, 
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>, 
      <-0.180022, 1.081232, 1.163226>, <-0.041346, 0.823106, 1.341305>, <0.077657, 0.329359, 1.373731>, <0.086618, 0.000000, 1.468675>, 
      <-0.421330, 1.081232, 1.014239>, <-0.239514, 0.778367, 1.058977>, <-0.004986, 0.332564, 1.202945>, <0.121264, 0.000000, 1.187203>, 
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.377436, 1.081232, 1.713488>, <0.162226, 1.081232, 1.471734>, <-0.014631, 1.081232, 1.312313>, 
      <0.201678, 1.525540, 1.454440>, <0.366085, 1.525540, 1.282209>, <-0.048420, 1.473321, 1.201235>, <-0.225276, 1.473321, 1.041814>, 
      <-0.167654, 1.721284, 0.632881>, <-0.307129, 1.721284, 0.439905>, <-0.600225, 1.701959, 0.459425>, <-0.789139, 1.701959, 0.604355>, 
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.220006, 0.808097, 2.150845>, <-0.242420, 0.337888, 2.063625>, <-0.405823, 0.000000, 2.127452>, 
      <0.377436, 1.081232, 1.713488>, <0.384413, 0.808097, 1.978614>, <-0.017281, 0.337888, 2.141120>, <-0.180684, 0.000000, 2.204948>, 
      <0.162226, 1.081232, 1.471734>, <0.300901, 0.823106, 1.649813>, <-0.059807, 0.329359, 1.813520>, <-0.050845, 0.000000, 1.908464>, 
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.201678, 1.525540, 1.454440>, <-0.167654, 1.721284, 0.632881>, <-0.457307, 2.015361, 0.171189>, 
      <0.007386, 1.081232, 2.101148>, <-0.003964, 1.525540, 1.669869>, <0.006805, 1.721284, 0.874259>, <-0.282849, 2.015361, 0.412566>, 
      <-0.337436, 1.081232, 2.081627>, <-0.313593, 1.469474, 1.986193>, <-0.303290, 1.789057, 1.072779>, <-0.364726, 2.015361, 0.748095>, 
      <-0.558650, 1.081232, 1.882221>, <-0.534807, 1.469474, 1.786787>, <-0.539586, 1.789057, 1.254059>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.007386, 1.081232, 2.101148>, <-0.337436, 1.081232, 2.081627>, <-0.558650, 1.081232, 1.882221>, 
      <0.220006, 0.808097, 2.150845>, <0.014363, 0.808097, 2.366274>, <-0.358612, 0.736413, 2.166387>, <-0.579826, 0.736413, 1.966981>, 
      <-0.242420, 0.337888, 2.063625>, <-0.524027, 0.337888, 1.966692>, <-0.770475, 0.332481, 1.827886>, <-0.681624, 0.332481, 1.543625>, 
      <-0.405823, 0.000000, 2.127452>, <-0.687430, 0.000000, 2.030520>, <-0.813641, 0.000000, 1.709033>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576448, -0.198443, 0.535137>, <0.576448, -0.198443, 0.262238>, <0.349236, -0.198443, 0.027343>, <0.076448, -0.198443, 0.035137>, 
      <0.576448, -0.138910, 0.535137>, <0.576448, -0.138910, 0.262238>, <0.349236, -0.138910, 0.027343>, <0.076448, -0.138910, 0.035137>, 
      <0.620136, -0.039925, 0.541587>, <0.620136, -0.039925, 0.268688>, <0.393748, -0.036435, 0.012000>, <0.120960, -0.036435, 0.019794>, 
      <0.576448, 0.000000, 0.535137>, <0.576448, 0.000000, 0.262238>, <0.349236, 0.000000, 0.027343>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076448, -0.198443, 0.823016>, <0.299025, -0.198443, 0.816657>, <0.576448, -0.198443, 0.757805>, <0.576448, -0.198443, 0.535137>, 
      <0.076448, -0.138910, 0.823016>, <0.299025, -0.138910, 0.816657>, <0.576448, -0.138910, 0.757805>, <0.576448, -0.138910, 0.535137>, 
      <0.109274, -0.049569, 0.819921>, <0.331851, -0.049569, 0.813561>, <0.620136, -0.039925, 0.764255>, <0.620136, -0.039925, 0.541587>, 
      <0.076448, 0.000000, 0.823016>, <0.299025, 0.000000, 0.816657>, <0.576448, 0.000000, 0.757805>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.198443, 0.803544>, <-0.161558, -0.198443, 0.829816>, <0.076448, -0.198443, 0.823016>, 
      <-0.484158, -0.138910, 0.565440>, <-0.484158, -0.138910, 0.803544>, <-0.161558, -0.138910, 0.829816>, <0.076448, -0.138910, 0.823016>, 
      <-0.457077, -0.045906, 0.538917>, <-0.457077, -0.045906, 0.777020>, <-0.128733, -0.049569, 0.826721>, <0.109274, -0.049569, 0.819921>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.803544>, <-0.161558, 0.000000, 0.829816>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.138910, 0.565440>, <-0.457077, -0.045906, 0.538917>, <-0.484158, 0.000000, 0.565440>, 
      <-0.484158, -0.198443, 0.267617>, <-0.484158, -0.138910, 0.267617>, <-0.457077, -0.045906, 0.241093>, <-0.484158, 0.000000, 0.267617>, 
      <-0.221254, -0.198443, 0.043643>, <-0.221254, -0.138910, 0.043643>, <-0.176742, -0.036435, 0.028300>, <-0.221254, 0.000000, 0.043643>, 
      <0.076448, -0.198443, 0.035137>, <0.076448, -0.138910, 0.035137>, <0.120960, -0.036435, 0.019794>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>, 
      <0.812457, 5.626361, -2.351572>, <0.812457, 5.566828, -2.351572>, <0.845476, 5.467288, -2.381637>, <0.812457, 5.427918, -2.351572>, 
      <0.585227, 5.626361, -2.586450>, <0.585227, 5.566828, -2.586450>, <0.600840, 5.476916, -2.616443>, <0.585227, 5.427918, -2.586450>, 
      <0.312440, 5.626361, -2.578635>, <0.312440, 5.566828, -2.578635>, <0.328052, 5.476916, -2.608629>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>, 
      <0.535075, 5.626361, -1.797132>, <0.535075, 5.566828, -1.797132>, <0.572463, 5.472019, -1.811323>, <0.535075, 5.427918, -1.797132>, 
      <0.812493, 5.626361, -1.856004>, <0.812493, 5.566828, -1.856004>, <0.845513, 5.467288, -1.886070>, <0.812493, 5.427918, -1.856004>, 
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248127, 5.566828, -2.048291>, <-0.222901, 5.481799, -2.050457>, <-0.248127, 5.427918, -2.048291>, 
      <-0.248110, 5.626361, -1.810188>, <-0.248110, 5.566828, -1.810188>, <-0.222884, 5.481799, -1.812353>, <-0.248110, 5.427918, -1.810188>, 
      <0.074492, 5.626361, -1.783939>, <0.074492, 5.566828, -1.783939>, <0.111880, 5.472019, -1.798129>, <0.074492, 5.427918, -1.783939>, 
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248149, 5.626361, -2.346115>, <0.014739, 5.626361, -2.570108>, <0.312440, 5.626361, -2.578635>, 
      <-0.248127, 5.566828, -2.048291>, <-0.248149, 5.566828, -2.346115>, <0.014739, 5.566828, -2.570108>, <0.312440, 5.566828, -2.578635>, 
      <-0.222901, 5.481799, -2.050457>, <-0.222923, 5.481799, -2.348280>, <0.030351, 5.476916, -2.600101>, <0.328052, 5.476916, -2.608629>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248149, 5.427918, -2.346115>, <0.014739, 5.427918, -2.570108>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>, 
      <0.053971, 4.666623, -1.448852>, <0.284170, 4.666623, -1.595421>, <0.174382, 4.607182, -1.900465>, <0.021298, 4.607182, -2.126384>, 
      <0.517220, 5.075879, -1.809835>, <0.517200, 5.075879, -2.082735>, <0.477637, 5.090263, -2.379763>, <0.204850, 5.090263, -2.371949>, 
      <0.812477, 5.427918, -2.078672>, <0.812457, 5.427918, -2.351572>, <0.585227, 5.427918, -2.586450>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>, 
      <-0.522392, 4.696657, -1.627402>, <-0.397485, 4.696657, -1.443067>, <-0.133856, 4.666623, -1.329261>, <0.053971, 4.666623, -1.448852>, 
      <0.019644, 5.082481, -1.679607>, <0.242221, 5.082481, -1.685983>, <0.517236, 5.075879, -1.587167>, <0.517220, 5.075879, -1.809835>, 
      <0.312498, 5.427918, -1.790756>, <0.535075, 5.427918, -1.797132>, <0.812493, 5.427918, -1.856004>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>, 
      <-0.779386, 4.656022, -2.214925>, <-0.980234, 4.656022, -2.087044>, <-0.655957, 4.696657, -1.824516>, <-0.522392, 4.696657, -1.627402>, 
      <-0.402100, 5.099049, -2.035075>, <-0.402082, 5.099049, -1.796971>, <-0.218362, 5.082481, -1.672789>, <0.019644, 5.082481, -1.679607>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248110, 5.427918, -1.810188>, <0.074492, 5.427918, -1.783939>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-0.779386, 4.656022, -2.214925>, <-0.402100, 5.099049, -2.035075>, <-0.248127, 5.427918, -2.048291>, 
      <-0.585001, 4.370247, -2.157766>, <-0.528163, 4.656022, -2.374880>, <-0.402121, 5.099049, -2.332898>, <-0.248149, 5.427918, -2.346115>, 
      <-0.254871, 4.370247, -2.056291>, <-0.145767, 4.607182, -2.372936>, <-0.092851, 5.090263, -2.363421>, <0.014739, 5.427918, -2.570108>, 
      <-0.087806, 4.370247, -1.809739>, <0.021298, 4.607182, -2.126384>, <0.204850, 5.090263, -2.371949>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>, 
      <-1.069952, 3.613722, 0.048729>, <-0.879086, 3.613722, 0.243780>, <-0.578520, 3.575232, 0.047883>, <-0.389001, 3.575232, -0.148476>, 
      <-0.622336, 3.987164, -0.693640>, <-0.392137, 3.987164, -0.840209>, <-0.144231, 3.915270, -0.975778>, <-0.297315, 3.915270, -1.201697>, 
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>, 
      <-1.142715, 3.545331, -0.498640>, <-1.297350, 3.545331, -0.338424>, <-1.225686, 3.613722, -0.110419>, <-1.069952, 3.613722, 0.048729>, 
      <-1.021373, 3.988560, -1.104980>, <-0.896467, 3.988560, -0.920645>, <-0.810163, 3.987164, -0.574049>, <-0.622336, 3.987164, -0.693640>, 
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>, 
      <-0.630548, 3.514007, -0.842063>, <-0.797077, 3.514007, -1.012244>, <-0.977360, 3.545331, -0.669961>, <-1.142715, 3.545331, -0.498640>, 
      <-0.932696, 3.885198, -1.629301>, <-1.133543, 3.885198, -1.501419>, <-1.154938, 3.988560, -1.302094>, <-1.021373, 3.988560, -1.104980>, 
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.630548, 3.514007, -0.842063>, <-0.932696, 3.885198, -1.629301>, <-0.836224, 4.370247, -1.997811>, 
      <-0.488683, 3.171135, -0.120865>, <-0.422251, 3.514007, -0.629199>, <-0.681473, 3.885198, -1.789256>, <-0.585001, 4.370247, -2.157766>, 
      <-0.519942, 3.171135, 0.223092>, <-0.182172, 3.575232, -0.362767>, <-0.464380, 3.915270, -1.448249>, <-0.254871, 4.370247, -2.056291>, 
      <-0.726770, 3.171135, 0.437383>, <-0.389001, 3.575232, -0.148476>, <-0.297315, 3.915270, -1.201697>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>, 
      <-2.299322, 2.433902, 0.927982>, <-2.456427, 2.433902, 1.151123>, <-2.067432, 2.609972, 1.414828>, <-1.839895, 2.609972, 1.565496>, 
      <-1.664665, 2.890382, 0.671393>, <-1.473799, 2.890382, 0.866444>, <-1.188084, 2.845969, 1.105167>, <-0.998565, 2.845969, 0.908809>, 
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>, 
      <-1.705847, 2.441113, 0.750588>, <-1.891503, 2.441113, 0.627653>, <-2.171134, 2.433902, 0.745913>, <