// bloodcell.inc

#macro RedCell(Size, xTrans, yTrans, zTrans, xRot, yRot, zRot)
#local NumComps = 40;
#local R = 1.8;
#local S = 0.8;
#local W = 0.4;
#local PosSize = 4;
#local NegSize = 1.7;
#local NegVert = 0.75;

blob { threshold 0.5
    // spin torus shape out of blob spheres
    #local i = 0;
    #while (i < NumComps)
        #local Angle = 2 * pi * (i / NumComps);
        sphere { <R*cos(Angle), W*sin(Angle*2), R*sin(Angle)> S, 1 }
        #local i = i + 1;
    #end
    // add flat central disc
    sphere { <0,0,0> 1, 1
        scale <PosSize, 1, PosSize>
    }
    // subtract components to make central disc concave
    sphere { <0,0,0> 1, -1
        scale <NegSize, 1, NegSize>
        translate <0,NegVert,0>
    }
    sphere { <0,0,0> 1, -1
        scale <NegSize, 1, NegSize>
        translate <0,-NegVert,0>
    }
    // basic red blood colour
    texture {
        pigment { rgb <1,0,0> }
    }

    // move cell to final location
    scale Size
    rotate <xRot, yRot, zRot>
    translate <xTrans, yTrans, zTrans>
}
#end

#macro WhiteCell(Detailed, Size, xTrans, yTrans, zTrans, xRot, yRot, zRot, R1)
#local NumComps = 7;
#local NumNuc = 3;

// white cell plasma body
blob { threshold 0.5
    // make random blobby shape out of blob spheres
    #local i = 0;
    #while (i < NumComps)
        sphere { <0,0,0> 1, 1
            scale <1.5+rand(R1), 0.4, 0.4>
            translate <rand(R1)-0.5, rand(R1)-0.5, rand(R1)-0.5>
            rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        #local i = i + 1;
    #end

    // basic white blood cell colour
    texture {
        #if (Detailed)
        pigment { bozo
            colour_map {
                [0.0 rgbt <1,0.95,0.9,0.8>]
                [0.4 rgbt <1,0.95,0.85,0.7>]
                [0.7 rgbt <1,0.95,0.85,0.6>]
                [1.0 rgbt <1,0.95,0.85,0.4>]
            }
            scale 0.3
            turbulence 0.4
        }
        normal { bumps 0.5
            scale 0.2
        }
        #else // (!Detailed)
        pigment { rgb <1,0.95,0.85> }
        #end // #if (Detailed)
    }
    interior {
        ior 1.03
    }

    // move cell to final location
    scale Size
    rotate <xRot, yRot, zRot>
    translate <xTrans, yTrans, zTrans>
}

#if (Detailed)
// white cell nucleus
blob { threshold 0.5
    // make random blobby shape out of blob spheres
    #local i = 0;
    #while (i < NumNuc)
        sphere { <0,0,0> 0.2, 1
            scale <0.5+rand(R1), 0.4+rand(R1), 0.4>
            translate <rand(R1)-0.5, rand(R1)-0.5, rand(R1)-0.5>*0.2
            rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        #local i = i + 1;
    #end

    // basic white blood cell nucleus colour
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgbt <1,0.75,0.79,0.3>]
                [0.4 rgbt <1,0.95,0.65,0.2>]
                [0.7 rgbt <1,0.85,0.65,0.1>]
                [1.0 rgbt <1,0.95,0.55,0>]
            }
            scale 0.05
            turbulence 0.4
            translate <rand(R1), rand(R1), rand(R1)>
        }
    }

    // move nucleus to final location
    scale Size
    rotate <xRot, yRot, zRot>
    translate <xTrans, yTrans, zTrans>
}
#end // #if (Detailed)
#end // #macro WhiteCell()
