// starship.inc
// Include file defining the Legacy starship

#declare ShipTexture =
texture {
    pigment { planar
        colour_map {
            [0.0 rgb <1.0,1.0,1.0>]
            [0.3 rgb <1.0,1.0,1.0>]
            [0.3 rgb <0.3,0.9,0.3>]
            [0.4 rgb <0.3,0.9,0.3>]
            [0.4 rgb <1.0,1.0,1.0>]
            [0.9 rgb <1.0,1.0,1.0>]
            [0.9 rgb <0.5,0.5,1.0>]
            [1.0 rgb <0.5,0.5,1.0>]
        }
        scale 3
    }
    normal { brick -0.3
        brick_size <12,6,5>
        mortar 0.1
        translate <0,-2,0>
    }
}
#declare Dirt =
texture {
    pigment { bozo
        colour_map {
            [0.0 rgbt <0.5,0.4,0.2,0.5>]
            [0.3 rgbt <1,1,1,1>]
            [1.0 rgbt <1,1,1,1>]
        }
        scale 5
        turbulence 0.4
    }
}
#declare Glass =
material {
    texture {
        pigment { rgbt <1,0.9,0.6,0.8> }
        finish {
            reflection 0.5
        }
    }
    interior {
        ior 1.33
    }
}

// the rocket exhaust funnels
#declare Rocket =
union {
    // basic rocket funnel shape
    intersection {
        superellipsoid { <1, 1.5> }
        superellipsoid { <1, 1.5>
            scale <0.9,0.9,0.9>
            inverse
            // texture for inside of exhaust funnel
            texture {
                pigment { rgb <0.7,0.9,1> }
                finish {
                    ambient 0.7
                }
            }
        }
        plane {z, 0}
        scale <1,1,2>
        // exterior texture
        texture {
            pigment { rgb <1,0.6,0.5> }
            finish {
                reflection 0.2
                metallic
            }
        }
    }
    // torus provides lip at edge of funnel
    torus { 1, 0.1
        rotate <90,0,0>
        texture {
            pigment { rgb <0.6,0.6,0.6> }
        }
    }
}

#declare NoseTransform = transform {
    matrix <2.6, 0,   0,
            0,   1.5, 0,
            0,   0.5, 3.2,
            0,   0,   0>
    translate <0,0,-9>
}

#macro Legacy(Slow, Size, xTrans, yTrans, zTrans, xRot, yRot, zRot)
union {
    // hull, minus pieces for windows
    difference {
        // main hull shape
        union {
            // nose
            superellipsoid { <0.2,1.5>
                transform NoseTransform
            }
            // midsection
            union {
                // port midsection
                intersection {
                    superellipsoid { <0.2, 0.02>
                        matrix <3.9, 0,   0,
                                0,    1.5, 0,
                                1.3, 0,   5.1,
                                0,    0,   0>
                    }
                    plane {-x, 0}
                }
                // starboard midsection
                intersection {
                    superellipsoid { <0.2, 0.02>
                        matrix <3.9, 0,   0,
                                0,    1.5, 0,
                                -1.3,0,   5.1,
                                0,    0,   0>
                    }
                    plane {x, 0}
                }
                translate <0,0,-4>
            }
            // stern
            superellipsoid { <0.2, 0.02>
                scale <5.2,1.5,5.1>
                translate <0,0,6.1>
            }
            // wings
            union {
                // port wing
                superellipsoid { <0.6,0.2>
                    matrix <3.5, 0, 0,
                            0, 0.2, 0,
                            3, 0, 6,
                            4.3, 0, 0>
                }
                cylinder { <5.15,0.15,6>, <5.15,0.15,-4>, 0.1}
                cylinder { <5.15,0.15,-4>, <4.63,0.13,-5.9>, 0.1}
                // starboard wing
                superellipsoid { <0.6,0.2>
                    matrix <3.5, 0, 0,
                            0, 0.2, 0,
                            -3, 0, 6,
                            -4.3, 0, 0>
                }
                cylinder { <-5.15,0.15,6>, <-5.15,0.15,-4>, 0.1}
                cylinder { <-5.15,0.15,-4>, <-4.63,0.13,-5.9>, 0.1}
                // move wings down and back
                translate <0,-1.3,5.2>
            }
            // tail fin
            difference {
                superellipsoid { <0.8,0.2>
                    matrix <0.5, 0, 0,
                            0, 4, 0,
                            0, 3, 6,
                            0, 0, 5.2>
                }
                plane { y, 0 }
            }
            cylinder { <0.45,1.5,11.2>, <0.45,1.5,0.7>, 0.1 }
            
            // layered texture
            texture { ShipTexture }
            texture { Dirt }
            hollow
        }
        // end hull

        #if (Slow)
        // components subtracted to make portholes
        union {
            // front viewport
            box { <2,0.2,-13>, <-2,1.2,-8> }
            // side portholes
            #declare pos = -7;
            #while (pos < 10)
                cylinder { <10,0.4,pos>, <-10,0.4,pos>, 0.4 }
                #declare pos = pos + 2;
            #end
            texture {
                pigment { rgbt <1,1,1,1> }
            }
        }
        #end // #if (Slow)
    }

    #if (Slow)
    // glass in windows
    union {
        // front viewport glass
        difference {
            superellipsoid { <0.2, 1.5>
                scale 0.99
                transform NoseTransform
            }
            superellipsoid { <0.2, 1.5>
                scale 0.9
                transform NoseTransform
            }
        }
        // side porthole glass
        box { <4.99,-1,1> <4.9,1,10.9> }
        box { <0,-1,0> <-0.1, 1, -10>
            rotate <0,degrees(atan2(2.5,10)),0>
            translate <4.99,0,1>
        }
        box { <-4.99,-1,1> <-4.9,1,10.9> }
        box { <0,-1,0> <0.1, 1, -10>
            rotate <0,-degrees(atan2(2.5,10)),0>
            translate <-4.99,0,1>
        }
        material { Glass }
    }
    
    // rocket funnels
    union {
        object { Rocket
            translate <0,0,12.5>
        }
        object { Rocket
            translate <3,0,12.5>
        }
        object { Rocket
            translate <-3,0,12.5>
        }
    }
    // end rockets
    
    // internal lights
    light_source { <0,0,-10> rgb <1.2,1.2,1> }
    light_source { <0,0,7> rgb <1.2,1.2,1> }

    #end // if (Slow)

    // external running lights
    light_source { <-5,0,-1>
        rgb <2,1.9,1.6>
        spotlight
        radius 12
        falloff 18
        point_at <-10,0,-3>
    }
    
    // move whole ship to final location
    scale Size
    rotate <xRot, yRot, zRot>
    translate <xTrans, yTrans, zTrans>
}
#end // #macro Legacy()
