// Persistence of Vision Ray Tracer Scene Description File
// File: unbelievable.pov
// Vers: 3.1
// Desc: A box made with 6 heightfields, two lightening spheres, two viruses and some bacterias.
//       Only very simples shapes !
// Date: 05/18/1999
// Auth: E.P. JEANTON

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"

// --------------------------------------------------------------------------------
// TEXTURES & PIGMENTS

// Made by E.P. JEANTON 02/04/1999
#declare Liquid_Soap =
texture {
 pigment {
  bozo
  turbulence 0.5
  color_map {
   [0.00 color rgb <1.000, 0.000, 0.647>]
   [0.41 color rgb <0.996, 1.000, 0.000>]
   [0.55 color rgb <0.000, 1.000, 0.416>]
   [1.00 color rgb <0.000, 0.000, 1.000>]
  }
 }
 finish {
  diffuse 0.65
  brilliance 6.0
  reflection 0.1
 }
}
texture {
 pigment { color rgbf <0.827, 0.827, 0.827, 0.996> }
 normal {
  ripples 0.8
  frequency 4
  scale 2
 }
 finish {
  diffuse 0.65
  brilliance 6.0
  phong 1.0    phong_size 100
  reflection 0.25
 }
}

#declare pig_E =
pigment {
 marble
 turbulence 1.14  octaves 4
 color_map {
  [0.00 color rgbf <1.0, 1.0, 1.0, 0.85>]
  [0.06 color rgbf <1.0, 1.0, 1.0, 1.00>]
  [0.11 color rgbf <0.0, 0.4, 1.0, 1.00>]
  [0.16 color rgbf <1.0, 1.0, 1.0, 1.00>]
  [0.84 color rgbf <1.0, 1.0, 1.0, 1.00>]
  [0.89 color rgbf <0.0, 0.4, 1.0, 1.00>]
  [0.94 color rgbf <1.0, 1.0, 1.0, 1.00>]
  [1.00 color rgbf <1.0, 1.0, 1.0, 0.85>]
 }
}

#declare pigv_E =
pigment {
 marble
 turbulence 1.14  octaves 4
 color_map {
  [0.00 color rgbf <0.59, 1.00, 0.10, 0.85>]
  [0.06 color rgbf <0.59, 1.00, 0.10, 1.00>]
  [0.11 color rgbf <0.24, 1.00, 0.66, 1.00>]
  [0.16 color rgbf <1.00, 1.00, 1.00, 1.00>]
  [0.84 color rgbf <1.00, 1.00, 1.00, 1.00>]
  [0.89 color rgbf <0.24, 1.00, 0.66, 1.00>]
  [0.94 color rgbf <0.59, 1.00, 0.10, 1.00>]
  [1.00 color rgbf <0.59, 1.00, 0.10, 0.85>]
 }
}

#declare E1 =
texture {
 pigment { pig_E }
 finish { ambient 10 }
}

#declare E2 =
texture {
 pigment { color rgb <0.039,0.000,0.408> }
 finish {
  ambient 0.01
  phong 0.1    phong_size 10
  reflection 0.15
 }
}
texture {
 pigment {
  marble
  turbulence 1.14  octaves 4
  color_map {
   [0.00 color rgbf <0.996, 0.996, 0.996, 0.298>]
   [0.06 color rgbf <0.976, 0.976, 0.976, 0.976>]
   [0.11 color rgbf <0.000, 0.408, 0.996, 0.678>]
   [0.16 color rgbf <0.000, 0.000, 0.000, 0.647>]
   [0.84 color rgbf <0.298, 0.298, 0.298, 0.867>]
   [0.88 color rgbf <0.000, 0.349, 0.996, 0.847>]
   [0.92 color rgbf <0.996, 0.996, 0.996, 0.847>]
   [1.00 color rgbf <1.000, 1.000, 1.000, 0.996>]
  }
 }
 finish {
  ambient 10
  diffuse 0.8
 }
}

#declare Eclair_vert =
texture {
 pigment { pigv_E }
 finish { ambient 10 }
}

#declare Gradient_jaune_Y =
texture {
 pigment {
  gradient y
  color_map {
   [0.00 color rgbf <1.000, 1.000, 1.000, 1.000>]
   [0.50 color rgbf <1.000, 1.000, 0.000, 1.000>]
   [1.00 color rgbf <1.000, 1.000, 0.000, 0.000>]
  }
 }
}

// --------------------------------------------------------------------------------
// STATEMENTS
light_source {
 <0.5, 0.5, 0.5>
 color 2*White
 fade_distance 0.5
 fade_power 25
 shadowless
}

camera { ultra_wide_angle
 location  0.7*<1, 1, 1>
 look_at   <0, 0, 0>
 angle 360
}

// --------------------------------------------------------------------------------
// DEFINITION DES OBJECTS - OBJECTS DEFINITION
#declare hf =
union {
 height_field {
  tga "epj_unb.tga"
  scale <1, 0.4, 1>
  smooth
 }
 cone { <0.5, 0, 0.5>, 0.11, <0.5, 0.41, 0.5>, 0
  texture { Eclair_vert scale 0.1 }
 }
}

#declare Capside =
sphere { <0, 0, 0> 0.1
 texture { Liquid_Soap scale 0.02 }
}

#macro Pointes (ry, lp, nb)
 // ry  : rayon de la sphre - sphere radius
 // lp  : longueur des pointes - length of the spikes
 // nb  : nombre de tours (et nombre de pointes sur un tour) - number of steps and number of spikes at each step
 union {
  #local i = 0;
  #local ang = -pi/2;
  #while (ang<=pi/2)
   #local n = 0;
   #while (n<nb)
    #local x1 = ry*cos(ang)*cos(2*pi*n/nb);
    #local x2 = (ry+lp)*cos(ang)*cos(2*pi*n/nb);
    #local y1 = ry*sin(ang);
    #local y2 = (ry+lp)*sin(ang);
    #local z1 = ry*cos(ang)*sin(2*pi*n/nb);
    #local z2 = (ry+lp)*cos(ang)*sin(2*pi*n/nb);
    #if (i-2*int(i/2)=0)
     cone { <x1,y1,z1>, ry/10, <x2,y2,z2>, 0 texture { EMBWood1 scale 0.01 } }
    #else
     cone { <x1,y1,z1>, ry/20, <x2,y2,z2>, ry/40 texture { EMBWood1 scale 0.01 } }
     sphere { <x2,y2,z2> ry/15 texture { Liquid_Soap scale 0.02 } }
    #end
    #local n = n + 1;
    #local i = i + 1;
   #end
   #local ang = ang + 2*pi/nb;
  #end
 }
#end

#declare Virus =
union {
 object { Capside }
 object { Pointes (0.1, 0.025, 20) }
}

#declare Bacille =
merge {
 sphere { -y, 0.5 }
 cylinder { -y, y, 0.5 }
 sphere { y, 0.5 }
}

// --------------------------------------------------------------------------------
// AGENCEMENT DES OBJECTS - OBJECTS SET UP

// Sphre centrale - central sphere
sphere { <0.5, 0.5, 0.5> 0.07
 texture { E2 scale 0.1 }
 hollow
}

// Eclairs autour de la sphere centrale - lightenings around the central sphere
sphere { <0.5, 0.5, 0.5> 0.2
 texture { E1 scale 0.4 rotate 40*x }
 hollow
 no_shadow
}

// Dcor (boite de hf) - background (box of hfs)
merge {
 object { hf }
 object { hf
  rotate 180*x
  translate <0, 1, 1>
 }
 object { hf
  rotate 90*x
  translate <0, 1, 0>
 }
 object { hf
  rotate -90*x
  translate <0, 0, 1>
 }
 object { hf
  rotate 90*z
  translate <1, 0, 0>
 }
 object { hf
  rotate -90*z
  translate <0, 1, 0>
 }
 texture { T_Copper_4C }
 texture { Gradient_jaune_Y }
}

// Les trois virus - The three viruses
object { Virus
 rotate 77*x
 translate <0.7, 0.7, 0.1>
}

object { Virus
 rotate <23, 10, 140>
 translate <0.1, 0.8, 0.7>
}

object { Virus
 rotate 53*z
 translate <0.05, 0.7, 0.4>
}

// Quelques bacilles dissemins dans la scne - Some bacilli spread into the box
#local rx = seed(0);
#local ry = seed(100);
#local rz = seed(513);
#declare diff = 0.375;  // dsordre - noise
#local pas = 1/5;
#local cpz = 0;
#local cpy = 0;
#local cpx = 0;
#while (cpz < 1)
 #while (cpy < 1)
  #while (cpx < 1)
   object { Bacille scale 0.025
    texture { T_Silver_1A }
    rotate <360*rand(rx), 360*rand(ry), 360*rand(rz)>
    translate <cpx + diff*pas*(2*rand(rx)-1), cpy + diff*pas*(2*rand(ry)-1), cpz + diff*pas*(2*rand(rz)-1)>
   }
   #local cpx = cpx + pas;
  #end
  #local cpx = 0;
  #local cpy = cpy + pas;
 #end
 #local cpy = 0;
 #local cpz = cpz + pas;
#end
