


// Persistence of Vision Ray Tracer Scene Description File
// File: favparis.pov
// Vers: 3.02
// Desc: Mir Crashing
// Date: 6/25/99
// Auth: Franck Angella & Arnaud Vallat



#include "colors.inc"
#include "textures.inc"

camera
{
  location <830.0, 40.0, 370.0>
  look_at <500.0, 0.0, 370.0>
  aperture 0.5
  blur_samples 15
  focal_point <670.0, 30.0, 400.0>
}

light_source
{
  <850.0, 500.0, 300.0>
  color rgb 0.6*<3.5, 3.0, 3.2>
  area_light
  <-5.0, 0.0, -5.0> <5.0, 0.0, 5.0>
  4, 4
  adaptive 0
  jitter
  atmosphere off
}


#include "..\tmp\unreal.pov"

#include "textures.pov"
#include "objects.pov"
#include "lampadaire.pov"
#declare TREE_RAND = seed(0)
#include "tree.pov"
#include "PAVEE_PROC.POV"
object { Pavees translate <685.0, 0.0, 436.0> }

//#include "city_simple.pov"
#include "city.pov"
#include "city_little.pov"
#include "lampadaire_pos.pov"
#include "arbre_pos.pov"

plane { y, 0.0 texture { T14 } }

#include "arc.pov"
#include "trottoirs.pov"


box
{
  <-50.0, -10.0, -1000.0>
  <1000.0, 600.0, 1000.0>
  pigment { Black }
  inverse
  hollow
}

atmosphere
{
    type 1
    samples 50
    distance 800
    scattering 0.02
    aa_level 4
    aa_threshold 0.005
    jitter 0.5
}

fog
{
  distance 300 //200
  fog_type 2
  fog_offset 0.0
  fog_alt 15.0 //10.0
  turbulence 0.2
  turb_depth 0.2
  color <0.5, 0.5, 0.7>
}

fog
{
  distance 400 //300
  fog_type 2
  fog_offset 0.0
  fog_alt 10.0 //5.0
  turbulence 0.4
  turb_depth 0.2
  color <0.5, 0.5, 0.5>
}
