//   "Hell's Gate"
//   Robert J Becraft
//   June, 1999                                       
//
//
// You move slowly towards the light, a sense of awareness builds within you and you
// find your body drifting forward.  The light grows more intense and you begin to see
// details around you.  You feel heat, hotter than holding your hand over the barbeque
// grill with hot searing coals.  HOT Heat... then you see it and the realization sinks
// in.  You are entering HELL.  The portal lies just in front of you.  The victim in front
// of you enters the gate and in a vaporizing flash of energy, his flesh is ripped from his
// body, leaving his soul exposed, engulfed in flames.  Beyond him you see the searing globes
// of others extending off into the vaste distances their souls in flames the heat reaching 
// you even at the distance you are from them.  In a moment you will experience what you
// can only anticipate as "Indescribable pain".  Part of you doesn't want to enter, part of
// you knows that it is inevitable and it will last... "forever".
//

   global_settings {
                                    max_trace_level 10          // default POV setting is 5
                                    max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                                  }

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"
#include "glass.inc"

camera
{
  location <-.5,150 ,-4000> up y right 4/3*x look_at <0,1,0>   // look at (IRTC View)
//  location <0,150 ,-4500> up y right 4/3*x look_at <0,1,0>   // look at
}

text{ ttf "timrom.ttf",
    "Hell's Gate, (c) Copyright Robert J Becraft, 1999",.3,0 
      pigment{color Wheat} 
      finish{ambient .75 phong 1 phong_size 60}
      scale .35 translate<-4,142,-3985>}  

light_source {  <0,400,-2500> color White }
light_source {  <550,400,-4900> color White }  // second light 
//light_source {  <0,20,-3000> color Orange shadowless}
                        
//#declare TheRest=off  // uncomment to turn off everything else                        
                                                             
#ifndef(TheRest)                                                             
#declare Testpig=pigment{bumps scale <200,1500,200> rotate z*30 turbulence 2.75
              color_map{
                        [.25 rgbf<1 .5 0 1>]
                        [.95 rgbf<1 1 1 .85>]
                       }
              }   
              
#declare Flamed=pigment{crackle
              color_map{
                        [.15 rgbf<1 0 0 .59>]
                        [.35 rgbf<1 .55 0 .59>]
                        [.95 rgbf<1 .5 0 .595>] 
                        [.99 rgbf<1 1 1 .59>]
                       }
              }
                            
plane{y,-205 
      pigment{Testpig}
      normal{bumps .001}
      finish{diffuse 1.3}
      hollow
     }
plane{y,605 
      pigment{Testpig}
      normal{bumps .001}
      finish{diffuse 1.3}
      hollow
     }
                                           
box{<-10,0,-10><10,20,10> texture{pigment{color Blue}}}  
#declare Man=union{
  sphere{<0,0,0>1 scale <1,1.5,1> translate<0,.5,0>}
  cone{<0,-1,0> 1.2 <0,-3,0> .5}
  cone{<0,-3,0> .5 <0,-6,0> 1}

  cone{<-.5,-1.2,0>.2 <-2,-1.2,0>.15}  // arms
  cone{<.5,-1.2,0>.2 <2,-1.2,0> .15}

  cone{<.3,-6,0> .2 <.4,-9,0> .15}     // legs
  cone{<-.3,-6,0> .2 <-.4,-9,0> .15}
  cone{<.4,-9,0> .15 <.4,-12,0> .12}
  cone{<-.4,-9,0> .15 <-.4,-12,0> .12}
  translate<0,6,0> // center
}
                                      
//box{<-2000,0,-.01><20000,1000,.01>   

#declare Victims=union{

  #declare RRR=seed(2839);
  #declare Count=1;
  #while (Count<250)
     #declare RX=rand(RRR)*5000-2500;
     #declare RZ=rand(RRR)*8000-2000;
     #declare ROY=rand(RRR)*360;
     #declare RR=rand(RRR)*100+50; 
     #declare RHY=rand(RRR)*10+10;    
     #declare RXOFF=rand(RRR)*500-250;    
     #declare RS=rand(RRR)*.20+.80;
   
//cone{<0,0,0> RR <RXOFF,1000,0> RR/4
     sphere{<0,0,0> RR 
          pigment{Testpig scale RS} 
          normal{bumps .001}
          finish{diffuse 2.3}
          hollow            
          rotate<0,ROY,0>
          translate<RX,RXOFF,RZ>
     }                                         
    
     object{Man scale RR/12 pigment{color Red} translate<RX,RXOFF,RZ>}
    
     #declare Count=Count+1;
  #end
}  // Victims
    
#declare Victims2=union{

  #declare RRR=seed(3339);
  #declare Count=1;
  #while (Count<150)
     #declare RX=rand(RRR)*8000-4000;
     #declare RZ=rand(RRR)*8000-4000;
     #declare ROY=rand(RRR)*360;
     #declare RR=rand(RRR)*100+50; 
     #declare RHY=rand(RRR)*10+10;    
     #declare RXOFF=rand(RRR)*500-250;    
     #declare RS=rand(RRR)*.20+.80;
   
//cone{<0,0,0> RR <RXOFF,1000,0> RR/4
     sphere{<0,0,0> RR 
          pigment{Testpig scale RS} 
          normal{bumps .001}
          finish{diffuse 2.3}
          hollow            
          rotate<0,ROY,0>
          translate<RX,RXOFF,RZ>
     }                                         
    
//     object{Man scale RR/12 pigment{color Red} translate<RX,RXOFF,RZ>}
    
     #declare Count=Count+1;
  #end
}  // Victims    
    
    
object{Victims rotate<0,30,0> translate<0,-200,1800> }   // set in front of dias


object{Victims2 rotate<0,90,0> translate<1200,1800,6000>} 
object{Victims2 rotate<0,180,0> translate<1800,900,13500>}
object{Victims2 rotate<0,0,0> translate<-8000,2300,18000>}
                         
                         
                         
                         
                         
                         
#end  // ifndef(TheRest) 
    
//cylinder{<0,0,0><0,1000,0> 200
//          pigment{Testpig} 
//          normal{bumps .001}
//          finish{diffuse 1.3}
//          hollow         
//          rotate<0,90,0>
//          translate<100,0,0>
//    }                 
                                
#declare DiasColor=    
texture {
    pigment {
        crackle
        turbulence 0.1
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.75
        frequency 1
        phase 0.25
        rotate <0, 0, 0>
        color_map {
            [0.00 color Gray80 ]
            [0.25 color Orange ]
       //     [0.30 color Gray90 ]
            [0.35 color White ]
       //     [0.40 color Gray60  ]
            [0.75 color Wheat  ]
            [1.00 color Gray90 ]
        }
    }    
    finish{ambient 0.35 diffuse 0.9 crand 0.08 phong 1 phong_size 120}
    scale 5
}
#declare LBolts=    
texture {
    pigment {
        crackle
        turbulence 0.1
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.75
        frequency 1
        phase 0.25
        rotate <0, 0, 0>
        color_map {
            [0.00 color Orange ]
            [0.10 color Blue ]  
            [0.20 color Orange]
            [0.30 color Clear ]
            [0.75 color Clear  ]
            [1.00 color Clear ]
        }
    }    
    finish{ambient 0.95 diffuse 0.9 crand 0.02 phong 1 phong_size 60}
    scale 2.3
}                                                          
#declare LBolts2=    
texture {
    pigment {
        crackle
        turbulence 0.1
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.75
        frequency 1
        phase 0.25
        rotate <0, 0, 0>
        color_map {
            [0.00 color Blue ]
            [0.10 color Orange ]  
            [0.20  color Blue]
            [0.30 color Clear ]
            [0.75 color Clear  ]
            [1.00 color Clear ]
        }
    }    
    finish{ambient 0.95 diffuse 0.9 crand 0.02 phong 1 phong_size 60}
    scale 1.7
}                  
  
#declare Spike_P1=union{
     cylinder{<0,0,0><0,0.1,0> .5 texture{Bright_Bronze}}
     cylinder{<0,0.02,0><0,0.08,0> .53 texture{Bright_Bronze}} 
     cylinder{<0,-.5,0><0,.5,0> .2 texture{LBolts scale .2 }}
     sphere{<0,0,0> .5  texture{T_Green_Glass} hollow}    
}  
  
#declare Spike=union{                     
     difference{
        sphere{<0,3.25,0> .2 texture{Bright_Bronze}}
        cylinder{<0,3,0><0,3.24,0> .22 texture{Bright_Bronze}}
     }                   
     object{Spike_P1 translate<0,2.75,0>}
     object{Spike_P1 translate<0,2.25,0>}
     object{Spike_P1 translate<0,1.75,0>}
     object{Spike_P1 translate<0,1.25,0>}
//     object{Spike_P1 translate<0,0,0>}
     
//     cylinder{<0,2.5,0><0,2.6,0> .5 texture{Bright_Bronze}}
//     cylinder{<0,2.52,0><0,2.58,0> .53 texture{Bright_Bronze}} 
//     sphere{<0,2.55,0> .5  texture{T_Green_Glass} hollow}     
//     cylinder{<0,2,0><0,2.1,0> .5 texture{Bright_Bronze}} 
//     sphere{<0,2.05,0> .5 texture{T_Green_Glass} hollow}                            
//     cylinder{<0,1.5,0><0,1.6,0> .5 texture{Bright_Bronze}}
//     sphere{<0,1.55,0> .5 texture{T_Green_Glass} hollow}
//     cylinder{<0,1,0><0,1.1,0> .5 texture{Bright_Bronze}}
     
     cone{<0,0,0> .3 <0,-2,0> 0 texture{T_Ruby_Glass} }                
     torus{.16,.03 texture{pigment{color Orange}} finish{ambient 1} translate<0,-1.25,0>}
     torus{.13,.03 texture{pigment{color Orange}} finish{ambient 1} translate<0,-1.5,0>}
     torus{.1,.03 texture{pigment{color Orange}} finish{ambient 1} translate<0,-1.75,0>}     
     
     sphere{<0,-.75,0> .05 texture{pigment{color White}} finish{ambient 1} }
     sphere{<0,-.5,0> .07 texture{pigment{color White}} finish{ambient 1} }
     sphere{<0,-.25,0> .09 texture{pigment{color White}} finish{ambient 1} }
     sphere{<0,0,0> .11 texture{pigment{color White}} finish{ambient 1} }

     sphere{<0,.50,0> .25 hollow  texture{T_Ruby_Glass}}
     sphere{<0,.50,0> .05 texture{pigment{color Wheat}} finish{ambient 1}}
}
    
#declare Arch=union{       
  difference{
       cylinder{<0,0,-.25><0,0,.25> 10 }
       cylinder{<0,0,-.251><0,0,.251> 9}
       #declare Count=0;
       #while (Count<360)
          cylinder{<0,0,-.251><0,0,.251>.4 translate<9.5,0,0> rotate<0,0,Count>}
          #declare Count=Count+15;
       #end 
  }
  #declare Count=0;
  #while (Count<360)   
     #declare ROY=rand(RRR)*360; 
     cylinder{<0,0,-.28><0,0,.28> .4 texture{Bright_Bronze} translate<9.5,0,0> rotate<0,0,Count+7.5>}                                                                
     sphere{<0,0,0>.35 rotate<0,ROY,0> translate<0,0,-.28>
       texture{LBolts scale .25} translate<9.5,0,0> rotate<0,0,Count+7.5>}
     sphere{<0,0,0> .35 rotate<0,ROY,0> translate<0,0,.28>
       texture{LBolts scale .25} translate<9.5,0,0> rotate<0,0,Count+7.5>}
     
    
     object{Spike translate<0,9,0> rotate<0,0,Count>}

     #declare Count=Count+15;
  #end
 // cylinder{<0,0,-.001><0,0,.001> 7 hollow texture{LBolts2}} 
  sphere{<0,0,0> 7 hollow texture{LBolts2}}     
//  sphere{<0,0,0> 2.5 hollow texture{LBolts scale .2} }  
}
           
object{Arch texture{Bright_Bronze} translate<0,145,-3984>}                                
cylinder{<0,0,0> <0,.1,0> 20 texture{DiasColor} translate<0,140,-3985>}
torus{19.5,.25 texture{Bright_Bronze} translate<0,140.5,-3985>}


#declare EyeVeins=texture {
    pigment {
        crackle
        turbulence 0.1
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.75
        frequency 1
        phase 0.25
        rotate <0, 0, 0>
        color_map {
            [0.00 color Red ]
            [0.15 color Blue ]  
            [0.30  color Red]
            [0.35 color Wheat ]
            [0.75 color Wheat  ]
            [1.00 color Wheat ]
        }
    }    
    finish{ambient 0.95 diffuse 0.9 crand 0.02 phong 1 phong_size 60}
    scale .05
}  


#declare Head=union{
  difference{
    union{
      sphere{<0,.2,0> .8 hollow}                                                         // skull
      sphere{<0,-.35,0> .65 scale<1,1.2,.8> hollow}                                        // chin
      cone{<0,.45,-.041>0 <0,-.35,-.18>.19 scale<.65,1,1.2> translate<0,0,-.45> hollow}  // nose
 //     cylinder{<0,0,.2> <0,-1.4,.25> .35}                                                                                           // neck
     }
    sphere{<0,0,0> .4 scale<.9,.7,1> translate<0,-.6,-.4> 
             pigment{color rgbf <.3,.5,.8,.95>}  
             scale<1,1,.8>}   // mouth
    sphere{<0,0,0> .164  scale<1.5,1,1> translate<.27,0,-.76>}  // eye sockets
    sphere{<0,0,0> .164 scale<1.5,1,1> translate<-.27,0,-.76>}
   }
  sphere{<.2,0,-.635> .12 texture{EyeVeins}}                            // eyes
  sphere{<.2,0,-.6> .092 pigment{color Black} scale<1,1,1.1>}
  sphere{<-.2,0,-.635> .12 texture{EyeVeins}}
  sphere{<-.2,0,-.6> .092 pigment{color Black} scale <1,1,1.1>} 
  
  box{<-.06,0,-.01><.06,.15,.01> pigment{color Wheat} translate<-.07,-.55,-.4>}  // tooth
  box{<-.06,0,-.01><.06,.15,.01> pigment{color Wheat} translate<.07,-.55,-.4>}
  box{<-.06,0,-.01><.06,.1,.01> pigment{color Wheat} translate<-.07,-.85,-.4>}  // tooth
  box{<-.06,0,-.01><.06,.1,.01> pigment{color Wheat} translate<.07,-.85,-.4>}

  texture{LBolts scale .2}
//  pigment{color White}
//  scale .3/2
//  translate<0,1.8-.15,.02>
 }      

#declare build=0.5
#declare skin=NewTan    // rgb<.9,.7,.6>
#declare Handtext=    
texture {
    pigment {
        crackle
        turbulence 0.1
        lambda 2.5
        omega 0.75
        octaves 5
        scale 0.75
        frequency 1
        phase 0.25
        rotate <0, 0, 0>
        color_map {
            [0.00 color Orange ]
            [0.10 color Blue ]  
            [0.20  color Orange]
            [0.30 color skin ]
            [0.35 color Clear  ]
            [1.00 color Clear ]
        }
    }    
    finish{ambient 0.15 diffuse 0.9 crand 0.02 phong 1 phong_size 6}
    scale 1.7
}    
#declare Hand= union {
  blob {
    threshold build
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb
    sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
    sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
    sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
    sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
    sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
    sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
    sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    scale <.8,1,1.75> 
    translate <0,1,0>
//    scale 3.8
//    rotate y*90
//    scale <1,-1,1>
//    rotate LH_Rot
//    rotate LH_E2W
//    translate LH_Elbow+LH_Wrist+<9,-11,1>
  }         
//  pigment{rgb skin}
//  finish{phong .3 phong_size 40}
//  normal{crackle .2 turbulence .7 scale .7}
}

#declare Hand2=union{
 blob {
    threshold build
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    cylinder { <-.41, -.95,0>, <-.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <-.85,-.68,-.05>, <-1.2, -.4, -.2>, .25, 1 }  //upper thumb
    sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
    sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
    sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
    sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
    sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
    sphere { <-.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
    sphere { <-.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    scale <.8,1,1.75>
//    translate <0,1,0>
//    scale 3.8
//    rotate y*90
//    scale <-1,-1,1>
//    rotate RH_Rot
//    rotate RH_E2W
//    translate RH_Elbow+RH_Wrist+<-9,-11,1>
  } 
//  pigment{rgb skin}
//  finish{phong .3 phong_size 40}
//  normal{crackle .2 turbulence .7 scale .7}
}       

#declare Skin=texture{
  pigment{rgb skin}
  finish{phong .3 phong_size 40}
  normal{crackle .2 turbulence .7 scale .7}
}
 
//object{Hand  rotate<0,0,0> scale .12 translate<-.65,1.750,0>  texture{Handtext scale .05} translate<0,145,-3985>}
//object{Hand2 rotate<0,0,0> scale .12 translate<.65,1.850,0>   texture{Handtext scale .05} translate<0,145,-3985>} 
//object{Head scale 2 rotate<55,0,0> translate<0,145,-3985>}          
                                                                                        
#declare HeadnHands=union{                                                                                        
  object{Head  rotate<55,0,0>}
  object{Hand  rotate<0,0,0> scale .38 translate<-.95,.40,0>  texture{Handtext scale .1}}
  object{Hand2 rotate<0,0,0> scale .38 translate<.95,.50,0>   texture{Handtext scale .1}}  
}

object{HeadnHands scale 2 translate<0,145,-3985>}