/*

Designed by Jeff Goeson, May 1999

*/

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metals.inc"	// Standard Texture definitions
#include "shapes.inc"	// Standard Texture definitions

camera {
  location <0, 0, -200>
  right <4/3, 0, 0>
  up <0, 1, 0>
  sky <0, 1, 0>
  direction <0, 0, 1.8>
  look_at <0, 0, 0>
}

light_source {<0, 0, -300> colour White}

background {color Black}

#declare DataStreams =
pigment {
    bozo
    color_map {
        [0.0, 0.249 color Clear color Clear]
        [0.25, 0.255   color red 0 green 1.5*3 blue 0
                    color red 0 green .95*3 blue 0]
        [0.255, 0.35   color red 0 green .75*3 blue 0
                    color Clear]
        [0.35, 0.649 color Clear color Clear]
        [0.65, 0.745   color red 0 green 0 blue .75*6
                    color Clear]
        [0.745, 0.75   color red 0 green 0 blue .95*6
                    color red 0 green 0 blue 1.5*6]
        [0.751, 1 color Clear color Clear]
    }
    scale <40,1,15>
}

#declare DumpData = 
union {
        difference {
                cylinder {<-80,40,150>, <-80,75,150>, 30 open texture {T_Gold_5E}}
                cylinder {<-80,57.5,150>, <80,57.5,150>, 10 pigment {Clear}}
        }
        difference {
                cylinder {<80,40,150>, <80,75,150>, 30 open texture {T_Silver_5E}}
                cylinder {<-80,57.5,150>, <80,57.5,150>, 10 pigment {Clear}}
        }
        light_source {<75,57.5,150> colour Green}
        light_source {<-75,57.5,150> colour Blue}
        light_source {<-75,57.5,150> colour Blue}
        light_source {<-75,57.5,150> colour Blue}
        light_source {<-75,57.5,150> colour Blue}
        light_source {<-75,57.5,150> colour Blue}
        light_source {<-75,57.5,150> colour Blue}
        cylinder {<-80,57.5,150>, <80,57.5,150>, 8 pigment {DataStreams}}
}

//sky
background { color Black }

#declare Sky = sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.75  color Gray05]
      [1.00  color MidnightBlue]
    }
    scale 2
    translate <-1, -1, -1>
  }
  pigment {
    bozo
    turbulence 0.3
    octaves 15
    omega .49876
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.95, .95, .95, 0.1>]
      [0.4 color rgbf<.8, .8, .8, .8>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega .5123
    lambda 2.56578
    color_map {
      [0.0 color rgbf<.375, .375, .375, 0.2>]
      [0.4 color rgbf<.45, .45, .45, .9>]
      [0.6 color rgbf<0.5, 0.5, 0.5, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  }
}

sky_sphere { Sky }
object{DumpData translate <0,-50,-40>}



