 
rhouse.mcrlDl
rhouse.mcrL    L     TEXTMPS          3E  ulDl                       S  // Persistence Of Vision INCLUDE file
// File:        rhouse.mcr
// Vers:        3.1d Mac PPC
// Desc:        Randomisable houses
// Auth:        Peter Murray

#debug "\r  rhouse.mcr - Macros for randomisable houses.\r"

// Measurements might already be defined.
#ifndef(in)
  #declare in = 1;
  #declare ft = 12;
#end

#declare DP=seed(837);#declare RDP=seed(2823);#declare RH=seed(5131);

// Textures should all be in unbtex.inc

/*
  Parameters:
    pLoc:   Door centre
	pRtn:   Door rotation (combination of which way it faces and how open it is)
	pSiz:   Door size vector
	pStyle: Door style (-1=random)
	pTxtr:  Texture of door - apart from glazed parts
	pHinge: 1=hinged at left, 2=hinged at right
*/
#macro MakeDoor(pLoc,pRtn,pSiz,pStyle,pTxtr,pHinge)
union{
  #if (pHinge=1)
    #local tX=pSiz.x;
  #else
	#local tX=-pSiz.x;
  #end
  // No choice of styles yet
  // 0=plain door
  box{
    <0,0,0>,<tX,pSiz.y,pSiz.z>
  }
  texture{pTxtr}
  rotate pRtn translate pLoc
}
#end

/*
  Parameters:
    pLoc:   Window centre
	pRtn:   Window rotation (which way it faces)
	pOpn:   Degree of window rotation (how open it is)
	pSiz:   Window size vector
	pStyle: Window style (-1=random)
	pTxtr:  Texture of solid parts of window
	pHinge: 1=hinged at left, 2=hinged at right, 3=hinged at top, 4=hinged at base
*/
#macro MakeWindow(pLoc,pRtn,pOpn,pSiz,pStyle,pTxtr,pHinge)
#local CurtainWd=abs(pSiz.x)/4;
union{
  #if (pHinge=1)
    #local tX=pSiz.x;
  #else
	#local tX=-pSiz.x;
  #end
  // No choice of styles yet
  // 0=plain window
  difference{
    box{
      <0,0,1*in>,<tX,pSiz.y,pSiz.z>
    }
	box{
	  <3*in,3*in,0*in>,<tX-3*in,pSiz.y-3*in,pSiz.z+1*in>
	}
  }
  box{//Sill
    <0,0,0>,<tX,3*in,pSiz.z+6*in>
  }
  box{//window glass
    <3*in,3*in,-1*in>,<tX-3*in,pSiz.y-3*in,pSiz.z-1*in>
	interior{ior 1.5} texture{Glass}
  }
  //#write(DebugFile,"pSiz.x: ",pSiz.x,", CurtainWd: ",CurtainWd,"\n")
  box{
    <-1*in,-2*in,pSiz.z+7*in>,<CurtainWd,pSiz.y+2*in,pSiz.z+9*in>
	texture{Curtain}
  }
  box{
    <1*in+abs(pSiz.x),-2*in,pSiz.z+7*in>,<abs(pSiz.x)-CurtainWd,pSiz.y+2*in,pSiz.z+9*in>
	texture{Curtain}
  }
  texture{pTxtr}
  rotate pRtn translate pLoc
}
#end

/*
  Parameters:
   pLoc: Location of origin of house - _house_ left front lower wall, not garden!
   pRtn: Rotation of house before moving it to pLoc.
   pHSiz: <house width,number of floors,house zdist>.
   pGSiz: <garden width,depth below 0,garden zdist>.
   pHOff: <house x offset,ignored?,house z offset>.
   pOptions: 1-Eaves at front (0=side)
             2-Windows at side
			 4-Fence round garden (0=hedge)
*/
#macro RandHouse(pLoc,pRtn,pHSiz,pGSiz,pHOff,pOptions)
  #local SwitchPaint=int(rand(RH)*4+.5);
  #switch (SwitchPaint)
     #case (0)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.95, 0.75, 0.75>}}
     #break
     #case (1)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.75, 0.95, 0.75>}}
     #break
     #case (2)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.75, 0.75, 0.95>}}
     #break
     #case (3)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.95, 0.95, 0.75>}}
     #break
     #case (4)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.75, 0.95, 0.95>}}
     #break
     #case (5)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.95, 0.45, 0.45>}}
     #break
     #case (6)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.45, 0.95, 0.45>}}
     #break
     #case (7)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.45, 0.45, 0.95>}}
     #break
     #case (8)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.95, 0.95, 0.45>}}
     #break
     #case (9)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.45, 0.95, 0.95>}}
     #break
     #case (10)
         #local TxMain=texture{Housewall pigment{colour rgb < 0.95, 0.95, 0.95>}}
     #break
  #end
  #local TxSecond=texture{Flooring}
  #local TxFrame=texture{WindowFrame}
  #local TxRoof=texture{Roof}
  #local TxGdn=texture{MownLawn}
  #local TxFence=texture{PicketTex}
  #local TxPath=texture{Stone}
  RHouse(pLoc,pRtn,pHSiz,pGSiz,pHOff,pOptions,TxMain,TxSecond,TxFrame,TxRoof,TxGdn,TxFence,TxPath)
#end

/*
  Parameters:
   pLoc: Location of origin of house - _house_ left front lower wall, not garden!
   pRtn: Rotation of house before moving it to pLoc.
   pHSiz: <house width,number of floors,house zdist>.
   pGSiz: <garden width,depth below 0,garden zdist>.
   pHOff: <house x offset,ignored?,house z offset>.
   pOptions: 1-Eaves at front (0=side)
             2-Windows at side
			 4-Fence round garden (0=hedge)
   TxMain: Main texture of house walls.
   TxSecond: Secondary texture of house walls.
   TxFrame: Door and window frame texture.
   TxRoof: Roof texture.
   TxGdn: Garden texture.
   TxFence: Texture to use for hedge or fence.
   TxPath: Texture to use for garden path.
*/
#macro RHouse(pLoc,pRtn,pHSiz,pGSiz,pHOff,pOptions,TxMain,TxSecond,TxFrame,TxRoof,TxGdn,TxFence,TxPath)
union{
  #local RmHt=7.75*ft;#local FloorSep=8*ft;
  #local RoofHt=8*ft;#local SillHt=28*in;
  #local WindowHt=6*ft+10*in;#local DoorHt=6.75*ft;
  #local FrontEaves=mod(pOptions,2);#local pOptions=floor(pOptions/2);
  #local SideWindows=mod(pOptions,2);#local pOptions=floor(pOptions/2);
  #local DrawFence=mod(pOptions,2);#local pOptions=floor(pOptions/2);
  #if (Detailed=1)
    #local FrontDiv=floor(pHSiz.x/(12*ft));#local FrontWid=pHSiz.x/FrontDiv;
    #local SideDiv=floor(pHSiz.z/(12*ft));#local SideWid=pHSiz.z/SideDiv;
    //#local FrontDiv=floor(pHSiz.x/(5*ft));#local FrontWid=pHSiz.x/FrontDiv;
    //#local SideDiv=floor(pHSiz.z/(5*ft));#local SideWid=pHSiz.z/SideDiv;
    #local DoorPanel=1+floor(rand(DP)*(FrontDiv-1)+.5);
    #local RearDoorPanel=1+floor(rand(RDP)*(FrontDiv-1)+.5);
  #end
  // Garden
  box{
    <-pHOff.x,-pGSiz.y,-pHOff.z>,<pGSiz.x-pHOff.x,0,pGSiz.z-pHOff.z>
	texture{TxGdn}
  }
  #if (Detailed=1)
    box{
      <((DoorPanel-.5)-.25)*FrontWid,-pGSiz.y,0>,
	  <((DoorPanel-.5)+.25)*FrontWid,.5*in,-pHOff.z-1*in>
	  texture{TxPath}
    }
    box{
	  <((RearDoorPanel-.5)-.25)*FrontWid,-pGSiz.y,pHSiz.z-1*in>,
	  <((RearDoorPanel-.5)+.25)*FrontWid,.5*in,pGSiz.z-pHOff.z+1*in>
	  texture{TxPath}
    }
  #end
  // Hedge/Fence
  #if (DrawFence=1)
  #else
    box{//left
      <-pHOff.x,0,-pHOff.z>,<-pHOff.x+4*in,3*ft,pGSiz.z-pHOff.z>
      texture{TxFence}
	}
    box{//right
      <pGSiz.x-pHOff.x-4*in,0,-pHOff.z>,<pGSiz.x-pHOff.x,3*ft,pGSiz.z-pHOff.z>
      texture{TxFence}
	}
    #if (Detailed=1)
	  difference{//front
        box{
          <-pHOff.x,0,-pHOff.z>,<pGSiz.x-pHOff.x,3*ft,-pHOff.z+4*in>
	    }
        box{
          <(DoorPanel-.5)*FrontWid-.25*FrontWid,.3*in,-pHOff.z+5*in>,
		  <(DoorPanel-.5)*FrontWid+.25*FrontWid,3.5*ft,-pHOff.z-1*in>
        }
        texture{TxFence}
	  }
	  difference{//back
        box{
          <-pHOff.x,0,pGSiz.z-pHOff.z>,<pGSiz.x-pHOff.x,3*ft,pGSiz.z-pHOff.z-4*in>
	    }
        box{
          <((RearDoorPanel-.5)-.25)*FrontWid,.3*in,pGSiz.z-pHOff.z-8*in>,
		  <((RearDoorPanel-.5)+.25)*FrontWid,3.5*ft,pGSiz.z-pHOff.z+4*in>
        }
        texture{TxFence}
	  }
	#else
      box{
        <-pHOff.x,0,-pHOff.z>,<pGSiz.x-pHOff.x,3*ft,-pHOff.z+4*in>
	  }
      box{
        <-pHOff.x,0,pGSiz.z-pHOff.z>,<pGSiz.x-pHOff.x,3*ft,pGSiz.z-pHOff.z-4*in>
	  }
    #end
  #end
  // House
  #if (Detailed=1)
    difference{
  #end
      union{
        box{
          <0,0,0>,pHSiz*<1,FloorSep,1>
	      texture{TxMain}
        }
	    box{
	      <-.5,-.5,-.5>,<.5,.5,.5>
          #if (FrontEaves=1)
		    rotate z*45
		    scale <1/sqrt(2),1,1>
		  #else
		    rotate x*45
		    scale <1,1,1/sqrt(2)>
		  #end
          #if (Detailed=1)
	        texture{TxMain}
		  #else
	        texture{TxRoof}
		  #end
		  scale <pHSiz.x,2*FloorSep,pHSiz.z>
		  translate pHSiz*<.5,FloorSep,.5>
	    }
	  }
	#if (Detailed=1)
      box{
	    <6*in,-1*in,6*in>,(pHSiz+<-6*in,1.5,-6*in>)*<1,FloorSep,1>
        texture{TxSecond}//texture{TxMain}
	  }
	  #local ii=0;
	  #while (ii<pHSiz.y)
        #local jj=1;
	    #while (jj<=FrontDiv)
	      #local CentreLine=(jj-.5)*FrontWid;
		  #if ((ii=0)&(jj=DoorPanel))
	        box{
	          <CentreLine-.25*FrontWid,3*in+ii*FloorSep,-1*in>,
		      <CentreLine+.25*FrontWid,WindowHt+ii*FloorSep,7*in>
		      texture{TxSecond}//texture{TxMain}
	        }
		  #else
	        box{
	          <CentreLine-.32*FrontWid,SillHt+ii*FloorSep,-1*in>,
		      <CentreLine+.32*FrontWid,WindowHt+ii*FloorSep,7*in>
		      texture{TxSecond}//texture{TxMain}
	        }
		  #end
		  #if ((ii=0)&(jj=RearDoorPanel))
	        box{
	          <CentreLine-.25*FrontWid,3*in+ii*FloorSep,pHSiz.z+1*in>,
		      <CentreLine+.25*FrontWid,WindowHt+ii*FloorSep,pHSiz.z-7*in>
		      texture{TxSecond}//texture{TxMain}
	        }
		  #else
	        box{
	          <CentreLine-.32*FrontWid,SillHt+ii*FloorSep,pHSiz.z+1*in>,
		      <CentreLine+.32*FrontWid,WindowHt+ii*FloorSep,pHSiz.z-7*in>
		      texture{TxSecond}//texture{TxMain}
	        }
		  #end
	      #local jj=jj+1;
	    #end
	    #if (SideWindows=1)
          #local jj=1;
	      #while (jj<=SideDiv)
	        #local CentreLine=(jj-.5)*SideWid;
            box{
	          <-1*in,SillHt+ii*FloorSep,CentreLine-.32*SideWid>,
	          <7*in,WindowHt+ii*FloorSep,CentreLine+.32*SideWid>
		      texture{TxSecond}//texture{TxMain}
	        }
            box{
	          <pHSiz.x+1*in,SillHt+ii*FloorSep,CentreLine-.32*SideWid>,
	          <pHSiz.x-7*in,WindowHt+ii*FloorSep,CentreLine+.32*SideWid>
		      texture{TxSecond}//texture{TxMain}
	        }
  	        #local jj=jj+1;
          #end
	    #end
	    #local ii=ii+1;
	  #end
    }
    #local ii=0;
    #while (ii<pHSiz.y)
	  //#debug concat("\rDrawing floor ",str(ii,2,0),"\r")
	  box{
	    <6*in,ii*FloorSep-6*in,6*in>,<pHSiz.x-6*in,ii*FloorSep,pHSiz.z-6*in>
        texture{TxSecond}//texture{TxMain}
	  }
	  #local ii=ii+1;
    #end
    // House - added components
    // Roof
    box{
      <0*in,0,0*in>,<1*in,3*in/FloorSep,1*in>
	  #if (FrontEaves=1)
	    rotate z*-45
	    scale <sqrt(2)/2,-1,1>
	  #else
	    rotate x*45
	    scale <1,-1,sqrt(2)/2>
	  #end
      texture{TxRoof}
	  scale <pHSiz.x+6*in,2*FloorSep,pHSiz.z+6*in>
	  translate pHSiz*<0,FloorSep,0>+<-3*in,0,-3*in>
    }
    box{
      <0*in,0,0*in>,<-1*in,3*in/FloorSep,-1*in>
	  #if (FrontEaves=1)
	    rotate z*45
	    scale <sqrt(2)/2,-1,1>
	  #else
	    rotate x*-45
	    scale <1,-1,sqrt(2)/2>
	  #end
      texture{TxRoof}
	  scale <pHSiz.x+6*in,2*FloorSep,pHSiz.z+6*in>
	  translate pHSiz*<1,FloorSep,1>+<3*in,0,3*in>
    }
	// ridge tiles
    #if (FrontEaves=1)
	  cylinder{
 	    vrotate(<1*in,3*in/FloorSep,1*in>,z*-45)*<sqrt(2)/2,-1,1>*<pHSiz.x+6*in,2*FloorSep,pHSiz.z+6*in>+pHSiz*<0,FloorSep,0>+<-3*in,3*in,-3*in>,
        vrotate(<-1*in,3*in/FloorSep,-1*in>,z*45)*<sqrt(2)/2,-1,1>*<pHSiz.x+6*in,2*FloorSep,pHSiz.z+6*in>+pHSiz*<1,FloorSep,1>+<-3*in,3*in,-3*in>,
        3*in
        texture{TxRoof}
	  }
    #else
	  cylinder{
 	    vrotate(<1*in,3*in/FloorSep,1*in>,x*45)*<1,-1,sqrt(2)/2>*<pHSiz.x+6*in,2*FloorSep,pHSiz.z+6*in>+pHSiz*<0,FloorSep,0>+<-3*in,3*in,-3*in>,
        vrotate(<-1*in,3*in/FloorSep,-1*in>,x*-45)*<1,-1,sqrt(2)/2>*<pHSiz.x+6*in,2*FloorSep,pHSiz.z+6*in>+pHSiz*<1,FloorSep,1>+<-3*in,3*in,-3*in>,
        3*in
        texture{TxRoof}
	  }
	#end
    // Windows and Doors
	#local ii=0;
	#while (ii<pHSiz.y)
      #local jj=1;
	  #while (jj<=FrontDiv)
	    #local CentreLine=(jj-.5)*FrontWid;
		#if ((ii=0)&(jj=DoorPanel))
		  MakeDoor(<CentreLine-.25*FrontWid,3*in,0>,<0,0,0>,<.5*FrontWid,WindowHt-3*in,6*in>,0,TxSecond,1)
		#else
		  MakeWindow(<CentreLine-.32*FrontWid,SillHt+ii*FloorSep,0>,<0,0,0>,<0,0,0>,<.64*FrontWid,WindowHt-SillHt,6*in>,0,TxSecond,1)
		#end
		#if ((ii=0)&(jj=RearDoorPanel))
		  MakeDoor(<CentreLine-.32*FrontWid,3*in,pHSiz.z+1*in>,<0,180,0>,<.5*FrontWid,WindowHt-3*in,6*in>,0,TxSecond,1)
		#else
		  MakeWindow(<CentreLine+.32*FrontWid,SillHt+ii*FloorSep,pHSiz.z+1*in>,<0,180,0>,<0,0,0>,<.64*FrontWid,WindowHt-SillHt,6*in>,0,TxSecond,1)
		#end
	    #local jj=jj+1;
	  #end
	  #if (SideWindows=1)
        #local jj=1;
	    #while (jj<=SideDiv)
	      #local CentreLine=(jj-.5)*SideWid;
		  MakeWindow(<0,SillHt+ii*FloorSep,CentreLine+.32*SideWid>,<0,90,0>,<0,0,0>,<.64*SideWid,WindowHt-SillHt,6*in>,0,TxSecond,1)
		  MakeWindow(<pHSiz.x,SillHt+ii*FloorSep,CentreLine+.32*SideWid>,<0,-90,0>,<0,0,0>,<.64*SideWid,WindowHt-SillHt,6*in>,0,TxSecond,1)
  	      #local jj=jj+1;
        #end
	  #end
	  #local ii=ii+1;
	#end
    // Garden elements, eg gates
  #end
  rotate pRtn  translate pLoc
}
#declare SamplerBBox = array[2]{
  pLoc+vrotate(<-pHOff.x,-pGSiz.y,-pHOff.z>,pRtn),
  pLoc+vrotate(<pGSiz.x-pHOff.x,FloorSep*pHSiz.y+RoofHt,pGSiz.z-pHOff.z>,pRtn)
}
#end

#declare SamplerName=object{RHouse(
  <0,0,0>,<0,0,0>,<35*ft,4,50*ft>,<45*ft,1*ft,120*ft>,<5*ft,0,20*ft>,
  2,WallStone,ChimneyMaterial,DoorWood,Roof,Lawn,PicketTex,WallStone
)}
/* SamplerBBox is declared as an array[2]
  {<Xmin+0,0,Zmin+0>,<Xmax+0,Ymax+0,Zmax+0>}
  while the #local values above are still known.
*/

                                                                     e  Icon
           @         
rhouse.mcr-4(EX)crectsurfaces- TEXTMPS                      l  3E  u  
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         <    (         x       x ttxt8BIM   	                           >                               ?  f$` 9  FhR     H 	Monaco 
 !5             
   cQ cQDl           cQ cQ                      ebPl    R MPSR  FPRF   *          a@,          POV-Ray File Prefs           