 
unbehouse.inc
unbehouse.inc  L     TEXTMPS         ~                         D  // Persistence Of Vision INCLUDE file
// File:        unbehouse.inc
// Vers:        3.1d Mac PPC
// Desc:        House from my IRTC Unbelievable round
// Auth:        Peter Murray
// Date:        22 June 1999

#debug "\r  unbehouse.inc - House from my IRTC Unbelievable round.\r"

//Textures are all predeclared in unbtex.inc

#declare FloorHt=8*ft;
#declare RmHt=7.75*ft;
#declare SillHt=28*in;
#declare WindowHt=6*ft+10*in;
#declare DoorHt=6.75*ft;

#declare Tree3=
union{
  union{
    //roots
    cone{
      <0,-1*ft,0>,1.75*ft,<6*in,1.75*ft,0>,1.5*ft
    }
    cone{
      <0,-1*ft,-1*ft+10*in>,8*in,<0,1.25*ft,-1*ft>,6*in
    }
    //trunk
    cone{
      <6*in,1*ft+2*in,0>,1.4*ft,<8*in,1*ft+10*in,0>,1.4*ft
    }
    cone{
      <6*in,1.5*ft,0>,1.5*ft,<5*in,8*ft,0>,1*ft+4*in
    }
    //major branches
    cone{//1
      <1*in,7*ft,-8*in>,10*in,<-1*ft,15*ft,-2*ft>,8*in
    }
    cone{
      <-1*ft,15*ft,-2*ft>,8*in,<-4*ft,22*ft,-3*ft>,7.8*in
    }
    cone{//1.1
      <-4*ft,22*ft,-3*ft>,7*in,<-5*ft,27*ft,-4*ft>,5*in
    }
    cone{
      <-5*ft,27*ft,-4*ft>,5*in,<-6*ft,32*ft,-4.5*ft>,3*in
    }
    cone{//1.2
      <-3.75*ft,21.75*ft,-3*ft>,7*in,<-3*ft,24*ft,-3.5*ft>,6*in
    }
    cone{//1.2.1
      <-3*ft,24*ft,-3.5*ft>,6*in,<0,27*ft,-4.5*ft>,5*in
    }
    cone{
      <0,27*ft,-4.5*ft>,5*in,<2*ft,28*ft,-5*ft>,4*in
    }
    cone{
      <2*ft,28*ft,-5*ft>,4*in,<6*ft,28.5*ft,-7*ft>,3*in
    }
    cone{
      <6*ft,28.5*ft,-7*ft>,3*in,<9*ft,27*ft,-8*ft>,1.5*in
    }
    cone{//1.2.2
      <-3*ft,24*ft,-3.5*ft>,6*in,<-2.5*ft,26*ft,-2.5*ft>,5*in
    }
    cone{
      <-2.5*ft,26*ft,-2.5*ft>,5*in,<-1.5*ft,29*ft,-1*ft>,4*in
    }
    cone{
      <-1.5*ft,29*ft,-1*ft>,4*in,<-1*ft,30.5*ft,2*ft>,3*in
    }
    cone{
      <-1*ft,30.5*ft,2*ft>,3*in,<-2.5*ft,30*ft,4*ft>,1.5*in
    }
    cone{//2
      <10*in,7*ft,8*in>,11*in,<13*in,14*ft,1.5*ft>,9*in
    }
    sphere{//2.1
      <13*in,14*ft,1.5*ft>,9*in
    }
    cone{
      <13*in,14*ft,1.5*ft>,9*in,<5*in,19*ft,3*ft>,8*in
    }
    cone{
      <5*in,19*ft,3*ft>,8*in,<1*ft,23*ft,4*ft>,7*in
    }
    cone{
      <1*ft,23*ft,4*ft>,7*in,<5*ft,25*ft,3*ft>,6*in
    }
    cone{
      <5*ft,25*ft,3*ft>,6*in,<7*ft,25*ft,2*ft>,5*in
    }
    cone{//2.3.1
      <7*ft,25*ft,2*ft>,5*in,<11*ft,22*ft,1*ft>,4*in
    }
    cone{
      <11*ft,22*ft,1*ft>,4*in,<15*ft,21*ft,1*ft>,3*in
    }
    cone{//2.3.2
      <9*ft,23.5*ft,1.5*ft>,4.5*in,<10*ft,21*ft,2.5*ft>,3.5*in
    }
    cone{
      <10*ft,21*ft,2.5*ft>,3.5*in,<12*ft,19*ft,4*ft>,2.5*in
    }
    cone{//2.1.1
      <7.3*in,20*ft+4*in,3*ft+4*in>,7.5*in,<7*in,25.5*ft,3.75*ft>,7*in
    }
    cone{
      <7*in,25.5*ft,3.75*ft>,7*in,<1*ft,29*ft,7*ft>,6*in
    }
    cone{
      <1*ft,29*ft,7*ft>,6*in,<5*ft,32*ft,10*ft>,5*in
    }
    cone{
      <5*ft,32*ft,10*ft>,5*in,<7*ft,32*ft,12*ft>,4*in
    }
    cone{
      <7*ft,32*ft,12*ft>,4*in,<10*ft,30*ft,14*ft>,2.5*in
    }
    cone{//2.2
      <9*in,16.5*ft,2.25*ft>,8*in,<1.75*ft,17*ft,2.5*ft>,7*in
    }
    texture{Trunk2}
  }
  blob{//Now foliage
    threshold 0.7
	#local Str=4*ft;
    //major branches
    cylinder{<1*in,7*ft,-8*in>,<-4*ft,22*ft,-3*ft>,Str,3*ft}//1
    cylinder{<-4*ft,22*ft,-3*ft>,<-5*ft,27*ft,-4*ft>,Str,6*ft}//1.1
    cylinder{<-5*ft,27*ft,-4*ft>,<-6.5*ft,34.5*ft,-4.75*ft>,Str,12*in}
    cylinder{<-3.75*ft,21.75*ft,-3*ft>,<-3*ft,24*ft,-3.5*ft>,Str,2*ft}//1.2
    cylinder{<-3*ft,24*ft,-3.5*ft>,<0,27*ft,-4.5*ft>,Str,4*ft}//1.2.1
    cylinder{<0,25*ft,-4.5*ft>,<10*ft,29*ft,-9*ft>,Str,6*ft}
    cylinder{<-3*ft,24*ft,-3.5*ft>,<-1.5*ft,29*ft,-1*ft>,Str,3*ft}//1.2.2
    cylinder{<-1.5*ft,29*ft,-1*ft>,<-2.5*ft,30*ft,4*ft>,Str,1.5*ft}
    sphere{<0,0,0>,Str/2,1*ft scale <7,5,10> translate <1.5*ft,30*ft,4*ft>}
    sphere{<0,0,0>,Str/1.5,1*ft scale <8,5,6> translate <15*ft,30*ft,4*ft>}
    sphere{<0,0,0>,Str,1*ft scale <5,2.5,7> translate <5,25*ft,0>}
    cylinder{<13*in,14*ft,1.5*ft>,<1*ft,23*ft,4*ft>,Str,4*ft}
    cylinder{<1*ft,23*ft,4*ft>,<7*ft,25*ft,2*ft>,Str,5*ft}
    cylinder{<10*in,7*ft,8*in>,<13*in,14*ft,1.5*ft>,Str,3*ft}//2
    cylinder{<7*ft,25*ft,2*ft>,<15*ft,21*ft,1*ft>,Str,3*ft}//2.3.1
    cylinder{<9*ft,23.5*ft,1.5*ft>,<12*ft,19*ft,4*ft>,Str,4*ft}//2.3.2
    cylinder{<7.3*in,20*ft+4*in,3*ft+4*in>,<1*ft,29*ft,7*ft>,Str,3*ft}//2.1.1
    cylinder{<1*ft,29*ft,7*ft>,<10*ft,30*ft,14*ft>,Str,4*ft}
    cylinder{<9*in,16.5*ft,2.25*ft>,<1.75*ft,17*ft,2.5*ft>,Str,4*ft}//2.2
    texture{Foliage3}
  }
}

//Windows are defined so y=floor, x,z=midpoint on outer wall.
#declare Window1=
union{
  box{//sill
    <-2*ft,SillHt-1*in,-2*in>,<2*ft,SillHt,6.25*in>
  }
  //frame
  box{
    <-2*ft,SillHt,-.25*in>,<-2*ft+1*in,WindowHt-1*in,6.25*in>
  }
  box{
    <2*ft,SillHt,-.25*in>,<2*ft-1*in,WindowHt-1*in,6.25*in>
  }
  box{
    <-2*ft,WindowHt-1*in,-.25*in>,<2*ft,WindowHt,6.25*in>
  }
  //glass
  box{
    <-1*ft-11*in,SillHt,0>,<1*ft+11*in,WindowHt-1*in,1*in>
    interior{ior 1.5} texture{Glass}
  }
  //curtains
  box{
    <-2.1*ft,SillHt-2*in,7*in>,<-1.5*ft,WindowHt+2*in,9*in>
	texture{Curtain}
  }
  box{
    <2.1*ft,SillHt-2*in,7*in>,<1.5*ft,WindowHt+2*in,9*in>
	texture{Curtain}
  }
  texture{WindowFrame}
}

#declare W1Hole=
box{
  <-2*ft,SillHt,-10*in>,<2*ft,WindowHt,10*in>
}

#declare Window3=
union{
  box{//sill
    <-5*ft,SillHt-1*in,-2*in>,<5*ft,SillHt,6.25*in>
  }
  //frame
  box{
    <-5*ft,SillHt,-.25*in>,<-5*ft+1*in,WindowHt-1*in,6.25*in>
  }
  box{
    <5*ft,SillHt,-.25*in>,<5*ft-1*in,WindowHt-1*in,6.25*in>
  }
  box{
    <-5*ft,WindowHt-1*in,-.25*in>,<5*ft,WindowHt,6.25*in>
  }
  //separators
  box{
    <-21*in,SillHt,-.25*in>,<-19*in,WindowHt-1*in,2.25*in>
  }
  box{
    <21*in,SillHt,-.25*in>,<19*in,WindowHt-1*in,2.25*in>
  }
  //glass
  box{
    <-4*ft-11*in,SillHt,0>,<-1*ft-9*in,WindowHt-1*in,1*in>
    interior{ior 1.5} texture{Glass}
  }
  box{
    <-1*ft-7*in,SillHt,0>,<1*ft+7*in,WindowHt-1*in,1*in>
    interior{ior 1.5} texture{Glass}
  }
  box{
    <1*ft+9*in,SillHt,0>,<4*ft+11*in,WindowHt-1*in,1*in>
    interior{ior 1.5} texture{Glass}
  }
  //curtains
  box{
    <-5.1*ft,SillHt-2*in,7*in>,<-4.1*ft,WindowHt+2*in,9*in>
	texture{Curtain}
  }
  box{
    <5.1*ft,SillHt-2*in,7*in>,<4.1*ft,WindowHt+2*in,9*in>
	texture{Curtain}
  }

  texture{WindowFrame}
}

#declare W3Hole=
box{
  <-5*ft,SillHt,-1*in>,<5*ft,WindowHt,7*in>
}

//#declare OuterDoor=

//#declare InnerDoor=

//#declare InnerDDoor=

//#declare CupboardDoor=

#declare ODHole=
box{
  <-18*in,3*in,-1*in>,<18*in,DoorHt,7*in>
}

#declare IDHole=
box{
  <-15*in,3*in,-1*in>,<15*in,DoorHt,7*in>
}

#declare ID2Hole=
box{
  <-30*in,3*in,-1*in>,<30*in,DoorHt,7*in>
}

#declare CpdHole=
box{
  <-36*in,3*in,-1*in>,<36*in,DoorHt,7*in>
}

#declare Stairs=
union{
  box{//mini-landing
    <-5*ft,3.5*ft,20*in>,<5*ft,4*ft,5*ft>
  }
  #declare jj=1;
  #while (jj<8)
    box{
      <5*in,4*ft-6*in*jj,30*in-10*jj*in>,<5*ft,3.5*ft-6*in*jj,20*in-10*jj*in>
    }
    box{
      <-5*in,4*ft+6*in*jj,30*in-10*jj*in>,<-5*ft,3.5*ft+6*in*jj,20*in-10*jj*in>
    }
    #declare jj=jj+1;
  #end
  texture{WindowFrame}
  //texture{pigment{colour rgb .99}}
}

#declare FrontStairs=
union{
  box{
    <-18*in,0,1*ft>,<18*in,-6*in,-6*ft>
  }
  cylinder{
	<16,36,13>*in,<16,36,-38>*in,1*in
  }
  cylinder{
	<-16,36,13>*in,<-16,36,-70>*in,1*in
  }
  cylinder{
	<-16,36,-70>*in,<16,36,-70>*in,1*in
  }
  cylinder{
	<16,36,-38>*in,<68,-42,-38>*in,1*in
  }
  cylinder{
	<16,36,-70>*in,<68,-42,-70>*in,1*in
  }
  box{
    <66*in,-78*in,-3*ft>,<84*in,-84*in,-6*ft>
  }
  cylinder{
	<68,-42,-38>*in,<82,-42,-38>*in,1*in
  }
  cylinder{
	<68,-42,-70>*in,<82,-42,-70>*in,1*in
  }
  box{
    <132*in,-156*in,-3*ft>,<168*in,-162*in,-6*ft>
  }
  cylinder{
	<82,-42,-38>*in,<134,-120,-38>*in,1*in
  }
  cylinder{
	<82,-42,-70>*in,<134,-120,-70>*in,1*in
  }
  cylinder{
	<134,-120,-38>*in,<166,-120,-38>*in,1*in
  }
  cylinder{
	<134,-120,-70>*in,<166,-120,-70>*in,1*in
  }
  box{
    <216*in,-234*in,-3*ft>,<220*in,-240*in,-6*ft>
  }
  cylinder{
	<218,-198,-38>*in,<250,-198,-38>*in,1*in
  }
  cylinder{
	<218,-198,-70>*in,<250,-198,-70>*in,1*in
  }
  cylinder{
	<166,-120,-38>*in,<266,-270,-38>*in,1*in
  }
  cylinder{
	<166,-120,-70>*in,<266,-270,-70>*in,1*in
  }
  #local Step=1;
  #while (Step<20)
    cylinder{
	  <-16,0,10-4*Step>*in,<-16,36,10-4*Step>*in,1*in
    }
	#local Step=Step+1;
  #end
  // Rails in batches of 9:
  #local Step=1;
  #while (Step<10)
	cylinder{
	  <-20+4*Step,0,-70>*in,<-20+4*Step,36,-70>*in,1*in
	}
	cylinder{
	  <130+4*Step,-156,-38>*in,<130+4*Step,-120,-38>*in,1*in
	}
	cylinder{
	  <130+4*Step,-156,-70>*in,<130+4*Step,-120,-70>*in,1*in
	}
	/*
	cylinder{
	  <214+4*Step,-234,-38>*in,<214+4*Step,-198,-38>*in,1*in
	}
	cylinder{
	  <214+4*Step,-234,-70>*in,<214+4*Step,-198,-70>*in,1*in
	}
	*/
    #local Step=Step+1;
  #end
  #local Step=1;
  #while (Step<5)
	cylinder{
	  <64+4*Step,-78,-38>*in,<64+4*Step,-42,-38>*in,1*in
	}
	cylinder{
	  <64+4*Step,-78,-70>*in,<64+4*Step,-42,-70>*in,1*in
	}
    #local Step=Step+1;
  #end
  // Stairs in batches of 12:
  #local Step=1;
  #while (Step<13)
    box{
	  <14+4*Step,-6*Step,-36>*in,<18+4*Step,-6-6*Step,-72>*in
	}
	cylinder{
	  <16+4*Step,-6*Step,-38>*in,<16+4*Step,36-6*Step,-38>*in,1*in
	}
	cylinder{
	  <16+4*Step,-6*Step,-70>*in,<16+4*Step,36-6*Step,-70>*in,1*in
	}
    box{
	  <80+4*Step,-78-6*Step,-36>*in,<84+4*Step,-84-6*Step,-72>*in
	}
	cylinder{
	  <82+4*Step,-78-6*Step,-38>*in,<82+4*Step,-42-6*Step,-38>*in,1*in
	}
	cylinder{
	  <82+4*Step,-78-6*Step,-70>*in,<82+4*Step,-42-6*Step,-70>*in,1*in
	}
    box{
	  <164+4*Step,-156-6*Step,-36>*in,<168+4*Step,-162-6*Step,-72>*in
	}
	cylinder{
	  <166+4*Step,-156-6*Step,-38>*in,<166+4*Step,-120-6*Step,-38>*in,1*in
	}
	cylinder{
	  <166+4*Step,-156-6*Step,-70>*in,<166+4*Step,-120-6*Step,-70>*in,1*in
	}
    box{
	  <216+4*Step,-234-6*Step,-36>*in,<220+4*Step,-240-6*Step,-72>*in
	}
	cylinder{
	  <218+4*Step,-234-6*Step,-38>*in,<218+4*Step,-198-6*Step,-38>*in,1*in
	}
	cylinder{
	  <218+4*Step,-234-6*Step,-70>*in,<218+4*Step,-198-6*Step,-70>*in,1*in
	}
	//go to -312*in = -26*ft
    #local Step=Step+1;
  #end
  texture{WindowFrame}
}

#declare Picket=
union{
  box{
    <-3*in,0,0>,<3*in,4*ft+4.5*in,1*in>
  }
  box{
    <-1*in,-1*in,0>,<1*in,1*in,1*in>
    rotate z*45
    translate <0,4*ft+4.5*in,0>
  }
  texture{WhitePaint}
}

#declare LightBulb=
union{// light should be emitted from y=2.5*in
  //bulb
  lathe{
    quadratic_spline 8,
    <8*sx,14*sx>,<9.5*sx,16*sx>,<10*sx,22*sx>,<16*sx,32*sx>,
    <17*sx,40*sx>,<16*sx,48*sx>,<12*sx,52*sx>,<0*sx,56*sx>
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
  //bayonet filling
  union{
    cylinder{
      <0,9*sx,0>,<0,14*sx,0>,8*sx
    }
    cone{
      <0,8*sx,0>,6*sx,<0,9*sx,0>,8*sx
    }
    cylinder{
      <0,0*sx,0>,<0,8*sx,0>,6*sx
    }
    texture{
      pigment{
        colour rgb <.7,.7,.7>
      }
      finish{Metal}
    }
  }
  //contacts - not yet modelled
}

#declare CeilingFitting=
union{
  cylinder{ //rose
    <0,0,0><0,-1*in,0>,1.125*in
  }
  cylinder{ //cable
    <0,-1*in,0>,<0,-9.5*in,0>,.125*in
  }
  cylinder{ //fitting
    <0,-9.5*in,0>,<0,-12*in,0>,.75*in
  }
  object{LightBulb rotate z*90 translate <0,-11*in,0>}
  texture{WhitePlastic}
  // Adjust so that y=0 is the emission point.
  translate <0,13.5*in,0>
}

#declare CeilingLight=
#if (LitLights=1)
  light_source{
    <0,RmHt-13.5*in,0> colour rgb <.75,.75,.3> looks_like{CeilingFitting}
    fade_distance 7*ft fade_power 1
  }
#else
  object{CeilingFitting translate <0,RmHt-13.5*in,0>}
#end

#declare FluoFitting=
union{
  cylinder{//tube
    <-1.5*ft,0,0>,<1.5*ft,0,0>,1*in
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
  cylinder{//end fittings
    <-1.5*ft,0,0>,<-1.75*ft,0,0>,1.2*in
  }
  box{
    <-1.5*ft,0,-1.2*in>,<-1.75*ft,1.2*in,1.2*in>
  }
  cylinder{
    <1.5*ft,0,0>,<1.75*ft,0,0>,1.2*in
  }
  box{
    <1.5*ft,0,-1.2*in>,<1.75*ft,1.2*in,1.2*in>
  }
  box{
    <-1.75*ft,1.2*in,-1.2*in>,<1.75*ft,2*in,1.2*in>
  }
  texture{
    pigment{colour rgb <.7,.73,.7>}
  }
}

#declare FluoLight=
#if (LitLights=1)
  light_source{
    <0,RmHt-2*in,0> colour rgb <.75,.8,.75> looks_like{FluoFitting}
    fade_distance 5*ft fade_power 1
  }
#else
  object{FluoFitting translate <0,RmHt-2*in,0>}
#end

// House
#declare House=
union{
  difference{
    union{
	  difference{// basic shape with roof line cut in.
        box{
          <-62.5*ft,-1*in,0>,<27.5*ft,30.7*ft-0*7*ft,50*ft>
          texture{Housewall}
        }
	    box{
	      <-63*ft,0,0>,<28*ft,15*ft,50*ft>
	      rotate x*-30
	      translate <0,16*ft,0>
		}
	    box{
	      <-63*ft,0,-50*ft>,<28*ft,15*ft,0>
	      rotate x*30
	      translate <0,16*ft,50*ft>
		}
	    box{
	      <0,0,-.5*ft>,<91*ft,15*ft,50.5*ft>
	      rotate z*50
	      translate <-62.5*ft,16*ft,0>
		}
	    box{
	      <-91*ft,0,-.5*ft>,<0,15*ft,50.5*ft>
	      rotate z*-50
	      translate <27.5*ft,16*ft,0>
		}
        texture{RoofTex}
	  }
      cylinder{// add the tower
        <-17.5*ft,-1*in,0>,<-17.5*ft,23.7*ft,0>,10*ft
      }
	  box{
	    <-27.5,15.7,0>*ft,<-7.5,23.7,13>*ft
	  }
	  box{
	    <-1,-1,0>*ft,<1,1,25>*ft
		rotate z*45
		scale <10/sqrt(2),6/sqrt(2),1>
		translate <-17.5,23.7,0>*ft
        texture{RoofTex}
	  }
	  cone{
	    <-17.5,23.7,0>*ft,10*ft,<-17.5,29.7,0>*ft,0
        texture{RoofTex}
	  }
      texture{Housewall}
    }
	//Cut the roof shape first...
	//slope at front
	//slope at rear
	//slope at left
	//slope at right
	//Ground floor/first storey
    //Games
    box{
      <7.75*ft,-.5*in,.25*ft>,<27.25*ft,36.001*in,49.75*ft>
      texture{GamesWallLow}
    }
    box{
      <7.75*ft,36*in,.25*ft>,<27.25*ft,RmHt,49.75*ft>
      texture{GamesWall}
    }
    //Hall
    box{
      <-7.25*ft,-.5*in,.25*ft>,<7.25*ft,RmHt,24.75*ft>
    }
    //Lounge
    union{
      box{
        <-27.25*ft,-.5*in,.25*ft>,<-7.75*ft,36.001*in,29.75*ft>
        texture{GamesWallLow}
      }
      box{
        <-27.25*ft,36*in,.25*ft>,<-7.75*ft,RmHt,29.75*ft>
        texture{LoungeWall}
      }
      cylinder{
        <-17.5*ft,-.5*in,.25*ft>,<-17.5*ft,36.001*in,.25*ft>,9.5*ft
        texture{GamesWallLow}
      }
      cylinder{
        <-17.5*ft,36*in,.25*ft>,<-17.5*ft,RmHt,.25*ft>,9.5*ft
        texture{LoungeWall}
      }
    }
    //Library
    box{
      <-42.25*ft,-.5*in,.25*ft>,<-27.75*ft,RmHt,29.75*ft>
      texture{StudyWall}
    }
    //Study
    box{
      <-62.25*ft,-.5*in,.25*ft>,<-42.75*ft,RmHt,19.75*ft>
      texture{StudyWall}
    }
    //Kitchen
    box{
      <-7.25*ft,-.5*in,35.25*ft>,<7.25*ft,36.001,49.75*ft>
      texture{Tiled}
    }
    box{
      <-7.25*ft,36*in,35.25*ft>,<7.25*ft,RmHt,49.75*ft>
      texture{BreakfastWall}
    }
    //Breakfast room
    box{
      <-32.25*ft,-.5*in,35.25*ft>,<-7.75*ft,RmHt,49.75*ft>
      texture{BreakfastWall}
    }
    //Workshop
    box{
      <-62.25*ft,-.5*in,35.25*ft>,<-37.75*ft,RmHt,49.75*ft>
    }
    box{
      <-62.25*ft,-.5*in,25.25*ft>,<-47.75*ft,RmHt,35.5*ft>
    }
    //Corridor
    box{
      <-7.25*ft,-.5*in,24.5*ft>,<-2*ft,RmHt,34.75*ft>
    }
    box{
      <-47.25*ft,-.5*in,30.25*ft>,<-7*ft,RmHt,34.75*ft>
    }
    box{
      <-47.25*ft,-.5*in,20.25*ft>,<-42.75*ft,RmHt,34.75*ft>
    }
    box{
      <-62.25*ft,-.5*in,20.25*ft>,<-42.75*ft,RmHt,24.75*ft>
    }
    box{
      <-37.25*ft,-.5*in,34*ft>,<-32.75*ft,RmHt,49.75*ft>
    }
    //Stairs
    box{
      <-2.25*ft,-.5*in,24*ft>,<7.25*ft,24*ft,34.75*ft>
    }
	//First floor/second storey
	//Playroom
    box{
      <7.75*ft,FloorHt-.5*in,.25*ft>,<27.25*ft,FloorHt+RmHt,49.75*ft>
      texture{PlayWall}
    }
	//Bridge
    union{
      box{
        <-42.25*ft,FloorHt-.5*in,.25*ft>,<7.25*ft,FloorHt+36.001*in,19.75*ft>
        texture{BridgeWallLow}
      }
      box{
        <-42.25*ft,FloorHt+36*in,.25*ft>,<7.25*ft,FloorHt+RmHt,19.75*ft>
        texture{BridgeWall}
      }
      cylinder{
        <-17.5*ft,FloorHt-.5*in,.25*ft>,<-17.5*ft,FloorHt+36.001*in,.25*ft>,9.5*ft
        texture{BridgeWallLow}
      }
      cylinder{
        <-17.5*ft,FloorHt+36*in,.25*ft>,<-17.5*ft,FloorHt+RmHt,.25*ft>,9.5*ft
        texture{BridgeWall}
      }
    }
	//Slide
    box{
      <-7.25*ft,FloorHt-.5*in,40.25*ft>,<7.25*ft,FloorHt+RmHt,49.75*ft>
      texture{LoungeWall}
    }
	//Sauna
    box{
      <-22.25*ft,FloorHt-.5*in,35.25*ft>,<-7.75*ft,FloorHt+RmHt,49.75*ft>
      texture{SaunaWall}
    }
	//Cupboards
    box{
      <-42.25*ft,FloorHt-.5*in,20.25*ft>,<-7.75*ft,FloorHt+RmHt,29.75*ft>
      texture{SaunaWall}
    }
	//Bathroom
    box{
      <-47.25*ft,FloorHt-.5*in,35.25*ft>,<-22.75*ft,FloorHt+36.001*in,49.75*ft>
      texture{Tiled}
    }
    box{
      <-47.25*ft,FloorHt+36*in,35.25*ft>,<-22.75*ft,FloorHt+RmHt,49.75*ft>
      texture{BreakfastWall}
    }
	//Bedroom 2
    box{
      <-62.25*ft,FloorHt-.5*in,0.25*ft>,<-42.75*ft,FloorHt+RmHt,24.75*ft>
      texture{Bed3Wall}
    }
	//Bedroom 3
    box{
      <-62.25*ft,FloorHt-.5*in,25.25*ft>,<-47.75*ft,FloorHt+RmHt,49.75*ft>
      texture{Bed3Wall}
    }
	//Corridor
    box{
      <-7.25*ft,FloorHt-.5*in,35.25*ft>,<7.25*ft,FloorHt+RmHt,39.75*ft>
    }
    box{
      <-7.25*ft,FloorHt-.5*in,20.25*ft>,<-2.75*ft,FloorHt+RmHt,39.7*ft>
    }
    box{
      <-7.25*ft,FloorHt-.5*in,20.25*ft>,<7.25*ft,FloorHt+RmHt,24.75*ft>
    }
    box{
      <-47.25*ft,FloorHt-.5*in,30.25*ft>,<-2.75*ft,FloorHt+RmHt,34.7*ft>
    }
    box{
      <-47.25*ft,FloorHt-.5*in,25.25*ft>,<-42.75*ft,FloorHt+RmHt,34.75*ft>
    }
	//Attic
	//Bedroom 5
    box{
      <7.75*ft,2*FloorHt-.5*in,25.25*ft>,<20*ft,2*FloorHt+RmHt,35*ft>
    }
	//Boxroom
    box{
      <2.75*ft,2*FloorHt-.5*in,15*ft>,<20*ft,2*FloorHt+RmHt,19.75*ft>
    }
	//Other room
    box{
      <-7.25*ft,2*FloorHt-.5*in,35.25*ft>,<7.25*ft,2*FloorHt+RmHt,35*ft>
    }
	//Bedroom 1
    box{
      <-37.25*ft,2*FloorHt-.5*in,15*ft>,<2.25*ft,2*FloorHt+RmHt,19.75*ft>
    }
    cylinder{
      <-17.5*ft,2*FloorHt-.5*in,.25*ft>,<-17.5*ft,2*FloorHt+RmHt,.25*ft>,9.5*ft
    }
	//Bedroom 4
    box{
      <-37.25*ft,2*FloorHt-.5*in,25.25*ft>,<-7.75*ft,2*FloorHt+RmHt,35*ft>
    }
	//Bathroom
    box{
      <-55*ft,2*FloorHt-.5*in,15*ft>,<-37.75*ft,2*FloorHt+RmHt,35*ft>
    }
	//Corridor
    box{
      <-37.25*ft,2*FloorHt-.5*in,20.25*ft>,<12.25*ft,2*FloorHt+RmHt,24.75*ft>
    }
    box{
      <-7.25*ft,2*FloorHt-.5*in,20.25*ft>,<-2.75*ft,2*FloorHt+RmHt,34.75*ft>
    }
    box{
      <12.75*ft,2*FloorHt-.5*in,20.25*ft>,<22.25*ft,2*FloorHt+RmHt,24.75*ft>
    }
    //Cut out holes for windows and doors
    object{W3Hole rotate y*0 translate <17.5*ft,0,0>}
    object{W1Hole rotate y*0 translate <5*ft,0,0>}
    object{ODHole rotate y*0 translate <0*ft,0,0>}
    object{W1Hole rotate y*0 translate <-5*ft,0,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*-60 translate <-17.5*ft,0,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*-30 translate <-17.5*ft,0,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*0 translate <-17.5*ft,0,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*30 translate <-17.5*ft,0,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*60 translate <-17.5*ft,0,0>}
    object{W1Hole rotate y*0 translate <-30*ft,0,0>}
    object{W1Hole rotate y*0 translate <-40*ft,0,0>}
    object{W3Hole rotate y*0 translate <-52.5*ft,0,0>}
    object{W3Hole rotate y*0 translate <17.5*ft,FloorHt,0>}
    object{W1Hole rotate y*0 translate <5*ft,FloorHt,0>}
    object{W1Hole rotate y*0 translate <-5*ft,FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*-60 translate <-17.5*ft,FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*-30 translate <-17.5*ft,FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*0 translate <-17.5*ft,FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*30 translate <-17.5*ft,FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*60 translate <-17.5*ft,FloorHt,0>}
    object{W1Hole rotate y*0 translate <-30*ft,FloorHt,0>}
    object{W1Hole rotate y*0 translate <-40*ft,FloorHt,0>}
    object{W3Hole rotate y*0 translate <-52.5*ft,FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*-60 translate <-17.5*ft,2*FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*-30 translate <-17.5*ft,2*FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*0 translate <-17.5*ft,2*FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*30 translate <-17.5*ft,2*FloorHt,0>}
    object{W1Hole translate <0,0,-10*ft> rotate y*60 translate <-17.5*ft,2*FloorHt,0>}
    //rear wall
    object{W3Hole rotate y*180 translate <17.5*ft,0,50*ft>}
    object{W1Hole rotate y*180 translate <5*ft,0,50*ft>}
    object{W1Hole rotate y*180 translate <-5*ft,0,50*ft>}
    object{W3Hole rotate y*180 translate <-17.5*ft,0,50*ft>}
    object{W1Hole rotate y*180 translate <-30*ft,0,50*ft>}
    object{ODHole rotate y*180 translate <-35*ft,0,50*ft>}
    object{W1Hole rotate y*180 translate <-40*ft,0,50*ft>}
    object{W3Hole rotate y*180 translate <-52.5*ft,0,50*ft>}
    object{W3Hole rotate y*180 translate <17.5*ft,FloorHt,50*ft>}
    object{W1Hole rotate y*180 translate <5*ft,FloorHt,50*ft>}
    object{W1Hole rotate y*180 translate <-5*ft,FloorHt,50*ft>}
    object{W3Hole rotate y*180 translate <-17.5*ft,FloorHt,50*ft>}
    object{W1Hole rotate y*180 translate <-30*ft,FloorHt,50*ft>}
    object{ODHole rotate y*180 translate <-35*ft,FloorHt,50*ft>}
    object{W1Hole rotate y*180 translate <-40*ft,FloorHt,50*ft>}
    object{W3Hole rotate y*180 translate <-52.5*ft,FloorHt,50*ft>}
    //side walls
    object{W3Hole rotate y*-90 translate <27.5*ft,0,10*ft>}
    object{W3Hole rotate y*-90 translate <27.5*ft,0,40*ft>}
    object{W3Hole rotate y*90 translate <-62.5*ft,0,10*ft>}
    object{W3Hole rotate y*90 translate <-62.5*ft,0,40*ft>}
    object{W3Hole rotate y*-90 translate <27.5*ft,FloorHt,10*ft>}
    object{W3Hole rotate y*-90 translate <27.5*ft,FloorHt,40*ft>}
    object{W3Hole rotate y*90 translate <-62.5*ft,FloorHt,10*ft>}
    object{ODHole rotate y*90 translate <-62.5*ft,FloorHt,22.5*ft>}
    object{W3Hole rotate y*90 translate <-62.5*ft,FloorHt,40*ft>}
    //interior
    object{IDHole rotate y*90 translate <7.25*ft,0,12.5*ft>}//hall-games
    object{IDHole rotate y*-90 translate <-7.25*ft,0,7.5*ft>}//hall-lounge
    object{IDHole rotate y*90 translate <-27.75*ft,0,17.5*ft>}//lounge-lib
    object{IDHole rotate y*180 translate <-17.5*ft,0,30.25*ft>}//lounge-corr
    object{IDHole rotate y*180 translate <-37.5*ft,0,30.25*ft>}//lib-corr
    object{IDHole rotate y*-90 translate <-42.25*ft,0,17.5*ft>}//lib-study
    object{IDHole rotate y*180 translate <-52.5*ft,0,20.25*ft>}//study-corr
    box{<-7.2*ft,3*ft,44*ft>,<-7.8*ft,DoorHt,41*ft>}//kitchen-games
    object{IDHole rotate y*0 translate <-5*ft,0,34.75*ft>}//kitchen-corr
    box{<7.2*ft,3*ft,44*ft>,<7.8*ft,DoorHt,41*ft>}//kitchen-games
    object{IDHole rotate y*0 translate <-20*ft,0,34.75*ft>}//brkfst-corr
    object{IDHole rotate y*0 translate <-52.5*ft,0,24.75*ft>}//wkshp-corr
    object{IDHole rotate y*90 translate <7.25*ft,FloorHt,22.5*ft>}//corr-play
    object{IDHole rotate y*90 translate <7.25*ft,FloorHt,37.5*ft>}//corr-play
    object{ID2Hole rotate y*0 translate <0*ft,FloorHt,39.75*ft>}//corr-slide
    object{IDHole rotate y*180 translate <-5*ft,FloorHt,20.25*ft>}//bridge-corr
    object{CpdHole rotate y*180 translate <-12.5*ft,FloorHt,30.25*ft>}//corr-cpd
    object{CpdHole rotate y*180 translate <-25.5*ft,FloorHt,30.25*ft>}
    object{CpdHole rotate y*180 translate <-37.5*ft,FloorHt,30.25*ft>}
    object{IDHole rotate y*0 translate <-15*ft,FloorHt,34.75*ft>}//sauna-corr
    object{IDHole rotate y*0 translate <-25*ft,FloorHt,34.75*ft>}//bath-corr
    object{IDHole rotate y*-90 translate <-47.25*ft,FloorHt,32.5*ft>}//corr-bed3
    object{IDHole rotate y*180 translate <-45*ft,FloorHt,25.25*ft>}//bed2-corr
  }
  difference{//flooring
    union{
      box{
        <-62.25*ft,0,.25*ft>,<27.25*ft,-.5*in,49.75*ft>
      }
      cylinder{
        <-17.5*ft,0,.25*ft>,<-17.5*ft,-.5*in,.25*ft>,9.5*ft
      }
      box{
        <-62.25*ft,FloorHt,.25*ft>,<27.25*ft,FloorHt-.5*in,49.75*ft>
      }
      cylinder{
        <-17.5*ft,FloorHt,.25*ft>,<-17.5*ft,FloorHt-.5*in,.25*ft>,9.5*ft
      }
      box{
        <-62.25*ft,2*FloorHt,.25*ft>,<27.25*ft,2*FloorHt-.5*in,49.75*ft>
      }
      cylinder{
        <-17.5*ft,2*FloorHt,.25*ft>,<-17.5*ft,2*FloorHt-.5*in,.25*ft>,9.5*ft
      }
      texture{Flooring}
    }
    box{
      <-2.25*ft,-.5*in,24*ft>,<7.25*ft,24*ft,34.75*ft>
    }
  }
  //Add fittings for windows and doors
  //front wall
  object{Window3 rotate y*0 translate <17.5*ft,0,0>}
  object{Window1 rotate y*0 translate <5*ft,0,0>}
  object{MakeDoor(<-18*in,3*in,0>,<0,0,0>,<3*ft,DoorHt-3*in,6*in>,
    0,FrontDoor,1)}
  object{FrontStairs translate <0,0,-1*ft>}
  object{Window1 rotate y*0 translate <-5*ft,0,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*-60 translate <-17.5*ft,0,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*-30 translate <-17.5*ft,0,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*0 translate <-17.5*ft,0,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*30 translate <-17.5*ft,0,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*60 translate <-17.5*ft,0,0>}
  object{Window1 rotate y*0 translate <-30*ft,0,0>}
  object{Window1 rotate y*0 translate <-40*ft,0,0>}
  object{Window3 rotate y*0 translate <-52.5*ft,0,0>}
  object{Window3 rotate y*0 translate <17.5*ft,FloorHt,0>}
  object{Window1 rotate y*0 translate <5*ft,FloorHt,0>}
  object{Window1 rotate y*0 translate <-5*ft,FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*-60 translate <-17.5*ft,FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*-30 translate <-17.5*ft,FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*0 translate <-17.5*ft,FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*30 translate <-17.5*ft,FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*60 translate <-17.5*ft,FloorHt,0>}
  object{Window1 rotate y*0 translate <-30*ft,FloorHt,0>}
  object{Window1 rotate y*0 translate <-40*ft,FloorHt,0>}
  object{Window3 rotate y*0 translate <-52.5*ft,FloorHt,0>}
  object{
    TeddyBear(
      <0,0,0>,<0,180,0>,
      <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,
	  array[5]{dFurTx,dContrastTx,dEyeTx,dMouthTx,dNoseTx}
    )
	scale 4 translate <-52.5*ft,FloorHt+SillHt,0>
  }
  object{Window1 translate <0,0,-10*ft> rotate y*-60 translate <-17.5*ft,2*FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*-30 translate <-17.5*ft,2*FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*0 translate <-17.5*ft,2*FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*30 translate <-17.5*ft,2*FloorHt,0>}
  object{Window1 translate <0,0,-10*ft> rotate y*60 translate <-17.5*ft,2*FloorHt,0>}
  //rear wall
  object{Window3 rotate y*180 translate <17.5*ft,0,50*ft>}
  object{Window1 rotate y*180 translate <5*ft,0,50*ft>}
  object{Window1 rotate y*180 translate <-5*ft,0,50*ft>}
  object{Window3 rotate y*180 translate <-17.5*ft,0,50*ft>}
  object{Window1 rotate y*180 translate <-30*ft,0,50*ft>}
  object{Window1 rotate y*180 translate <-40*ft,0,50*ft>}
  object{Window3 rotate y*180 translate <-52.5*ft,0,50*ft>}
  object{Window3 rotate y*180 translate <17.5*ft,FloorHt,50*ft>}
  object{Window1 rotate y*180 translate <5*ft,FloorHt,50*ft>}
  object{Window1 rotate y*180 translate <-5*ft,FloorHt,50*ft>}
  object{Window3 rotate y*180 translate <-17.5*ft,FloorHt,50*ft>}
  object{Window1 rotate y*180 translate <-30*ft,FloorHt,50*ft>}
  object{Window1 rotate y*180 translate <-40*ft,FloorHt,50*ft>}
  object{Window3 rotate y*180 translate <-52.5*ft,FloorHt,50*ft>}
  //side walls
  object{Window3 rotate y*-90 translate <27.5*ft,0,10*ft>}
  object{Window3 rotate y*-90 translate <27.5*ft,0,40*ft>}
  object{Window3 rotate y*90 translate <-62.5*ft,0,10*ft>}
  object{Window3 rotate y*90 translate <-62.5*ft,0,40*ft>}
  object{Window3 rotate y*-90 translate <27.5*ft,FloorHt,10*ft>}
  object{Window3 rotate y*-90 translate <27.5*ft,FloorHt,40*ft>}
  object{Window3 rotate y*90 translate <-62.5*ft,FloorHt,10*ft>}
  object{Window3 rotate y*90 translate <-62.5*ft,FloorHt,40*ft>}
  object{Stairs translate <2.5*ft,0,30*ft>}
  object{Stairs translate <2.5*ft,8*ft,30*ft>}
  //Put in the lights
  object{CeilingLight translate < 17.5*ft,0,  7.5*ft>}//games
  object{CeilingLight translate < 17.5*ft,0, 42.5*ft>}
  object{CeilingLight translate <    0*ft,0, 17.5*ft>}//hall
  object{CeilingLight translate <-17.5*ft,0,  7.5*ft>}//lounge
  object{CeilingLight translate <-17.5*ft,0, 22.5*ft>}
  object{CeilingLight translate <-40.0*ft,0, 15.0*ft>}//library
  object{CeilingLight translate <-52.5*ft,0, 10.0*ft>}//study
  object{FluoLight    translate <    0*ft,0, 42.5*ft>}//kitchen
  object{CeilingLight translate <-20.0*ft,0, 42.5*ft>}//brkfst
  object{FluoLight    rotate y*180 translate <-42.5*ft,0, 22.5*ft>}//wkshp
  object{FluoLight    rotate y*180 translate <-57.5*ft,0, 22.5*ft>}
  object{CeilingLight translate <-15.0*ft,0, 32.5*ft>}//corridor
  object{CeilingLight translate <-35.0*ft,0, 32.5*ft>}
  object{CeilingLight translate <-45.0*ft,0, 22.5*ft>}
  object{CeilingLight translate < 17.5*ft,FloorHt,  7.5*ft>}//play
  object{CeilingLight translate < 17.5*ft,FloorHt, 42.5*ft>}
  //Detail the rooms
  #if (RoomFill=1)
    #if (People=1)
	  /*
      object{CrADAM(<25*ft,0,25*ft>,<0,90,0>)}//games
      object{CrADAM(<2.5*ft,0,5*ft>,<0,180,0>)}//hall
      object{CrADAM(<-17.5*ft,0,-5*ft>,<0,180,0>)}//lounge
      object{CrADAM(<-17.5*ft,0,25*ft>,<0,0,0>)}
      object{CrADAM(<-35*ft,0,2.5*ft>,<0,180,0>)}//library
      object{CrADAM(<-55*ft,0,7.5*ft>,<0,-90,0>)}//study
      object{CrADAM(<0*ft,0,42.5*ft>,<0,90,0>)}//kitchen
      object{CrADAM(<-12.5*ft,0,42.5*ft>,<0,90,0>)}//brkfst room
      object{CrADAM(<-27.5*ft,0,42.5*ft>,<0,-90,0>)}
      object{CrADAM(<-55*ft,0,42.5*ft>,<0,-90,0>)}//workshop
      object{CrADAM(<-45*ft,0,32.5*ft>,<0,-90,0>)}//corridor
      object{CrADAM(<-5*ft,0,32.5*ft>,<0,90,0>)}
	  */
    #end
  #end
  //Garden
  box{
    <-92.5*ft,-1*in,0>,<-62.5*ft,0,95*ft>
    texture{MownLawn}
  }
  box{
    <-92.5*ft,-1*in,60*ft>,<-22.5*ft,0,95*ft>
    texture{MownLawn}
  }
  #if (People=1)
    object{CrDEBBIE(<-20*ft,0,80*ft>,<0,-90,0>)}
    object{CrSHELDON(<-52.5*ft,0,72.5*ft>,<0,0,0>)}
    object{CrSHELDON(<-17.5*ft,FloorHt,-9*ft>,<0,0,0>)}
  #end
  //fence
  union{
    box{
      <27.5*ft-1*in,11*in,50*ft>,<27.5*ft-2*in,13*in,95*ft-1*in>
    }
    box{
      <27.5*ft-1*in,47*in,50*ft>,<27.5*ft-2*in,49*in,95*ft-1*in>
    }
    #declare jj=50.5*ft;
    #while (jj<95*ft)
      object{Picket rotate y*-90 translate <27.5*ft,0,jj>}
      #declare jj=jj+1*ft;
    #end
    box{
      <27.5*ft-1*in,11*in,95*ft-1*in>,<-92.5*ft+1*in,13*in,95*ft-2*in>
    }
    box{
      <27.5*ft-1*in,47*in,95*ft-1*in>,<-92.5*ft+1*in,49*in,95*ft-2*in>
    }
    #declare jj=27*ft;
    #while (jj>-93*ft)
      object{Picket rotate y*180 translate <jj,0,95*ft>}
      #declare jj=jj-1*ft;
    #end
    box{
      <-92.5*ft+1*in,11*in,95*ft-1*in>,<-92.5*ft+2*in,13*in,1*in>
    }
    box{
      <-92.5*ft+1*in,47*in,95*ft-1*in>,<-92.5*ft+2*in,49*in,1*in>
    }
    #declare jj=94.5*ft;
    #while (jj>0*ft)
      object{Picket rotate y*90 translate <-92.5*ft,0,jj>}
      #declare jj=jj-1*ft;
    #end
    box{
      <-92.5*ft+1*in,11*in,2*in>,<-62.5*ft,13*in,1*in>
    }
    box{
      <-92.5*ft+1*in,47*in,2*in>,<-62.5*ft,49*in,1*in>
    }
    #declare jj=-92*ft;
    #while (jj<-62.5*ft)
      object{Picket translate <jj,0,0>}
      #declare jj=jj+1*ft;
    #end
    texture{WhitePaint}
  }
  box{//patio
    <-62.5*ft,-1*in,50*ft>,<27.5*ft,2*in,60*ft>
    texture{Stone}
  }
  box{//pool surround
    <-22.5*ft,-1*in,90*ft>,<27.5*ft,0*in,95*ft>
    texture{Stone}
  }
  box{
    <-22.5*ft,-1*in,90*ft>,<-17.5*ft,0*in,60*ft>
    texture{Stone}
  }
  box{
    <22.5*ft,-1*in,90*ft>,<27.5*ft,0*in,60*ft>
    texture{Stone}
  }
  box{//water
    <-17.5*ft,-7*ft,90*ft>,<22.5*ft,-6*in*in,60*ft>
    texture{PoolWater}
  }
  box{//paths
    <-92.5*ft,0,21*ft>,<-62.5*ft,.1*in,24*ft>
    texture{Stone}
  }
  box{
    <-77.5*ft,0,90*ft>,<-73.5*ft,.1*in,24*ft>
    texture{Stone}
  }
  box{
    <-73.5*ft,0,74*ft>,<-49.5*ft,.1*in,71*ft>
    texture{Stone}
  }
  box{//path to gazebo
    <-46.5*ft,0,80*ft>,<-49.5*ft,.1*in,60*ft>
    texture{Stone}
  }
  object{Gazebo translate <-48*ft,0,85*ft>}
  object{Tree3 rotate y*45 translate <-85,0,10>*ft}
  texture{Housewall}
}                                     6  6   e u i l t - i n )        s0
unbehouse.inc-18Buffer File326oiTEXTMPS                       ~  r                                                                                                                         @    /  0 ttxt8BIMGKONGKONTVOD     	                         >                               ?  rpza                  > 
  8     d     F     H 	Monaco  x     M M  f  f  a     M M  a               6  6   eP    R MPSR  FPRF   *         6          POV-Ray File Prefs                                                                                                     