 
unbtex.incl
unbtex.incL    L     TEXTMPS          .  ul                       F  // Persistence Of Vision INCLUDE file
// File:        unbtex.inc
// Vers:        3.1d Mac PPC
// Desc:        All the textures from my "Unbelievable" IRTC entry
// Auth:        Peter Murray

#debug "\r  unbtex.inc - Collected textures.\r"

//a
//b
#declare Bed3Wall=
texture{
  pigment{
    colour rgb <0.9,0.7,0.1>
  }
  finish{
    ambient 0.4
  }
}

#declare Blackness=
texture{
  pigment{
    colour rgb <0,0,0>
  }
}

#declare BreakfastWall=
texture{
  pigment{
    colour rgb <.9,.9,.4>
  }
  finish{ambient .3 brilliance .25 diffuse .4
    specular .0 reflection .0}
}

#declare BridgeWall=
texture{
  pigment{
    colour rgb <.7,.7,.7>
  }
  finish{Metal ambient .4 brilliance .25 diffuse .25
    specular .0 roughness .2 reflection .1}
}

#declare BridgeWallLow=
texture{
  pigment{
    colour rgb <.45,.45,.45>
  }
  finish{Metal ambient .2 brilliance .2 diffuse .2
    specular .0 roughness .1 reflection .0}
}

//c
#declare ChimneyMaterial=
texture{
  pigment{
    marble
    colour_map{
      [0.0 {colour < 0.56, 0.14, 0.14>]
	  [0.8 {colour < 0.49, 0.21, 0.21>]
      [0.9 {colour < 0.49, 0.14, 0.14>]
      [1.0 {colour < 0.49, 0.28, 0.28>]
	}
    turbulence 2.3
  }
  normal{
    dents 0.4 scale .25*in
  }
  finish{
    roughness 0.40 ambient 0.25 diffuse 0.33 reflection 0.05
  }
}

#declare Curtain=
texture{
  pigment{
    colour rgb <.85,.9,.9>*1.2
  }
  normal{
    gradient x+z,in sine_wave
  }
  finish{
    roughness 0.2
  }
}

//d
#declare DoorWood=
texture{
  pigment{
    wood
    turbulence 0.3
    colour_map{
      [0.0, 0.8 colour rgb <0.50, 0.35, 0.18>
                colour rgb <0.50, 0.35, 0.18>]
      [0.8, 1.0 colour rgb <0.33, 0.14, 0.05>
                colour rgb <0.16, 0.07, 0.02>]
    }
  }
  normal{
    dents .4 scale .1*in
  }
  finish{
    roughness 0.20 ambient 0.25 diffuse 0.33 reflection 0.05
  }
}

//e
#declare Earth=
texture{
  pigment{
    colour rgb <.6,.45,.2>
  }
  finish {
    roughness 0.4
  }
  normal{bumps 5*in frequency 5
    turbulence 1  omega .8  lambda 1.5 octaves 3
  }
}

//f
#declare Floor=
texture{
  pigment{
    spotted turbulence 0.8 octaves 4 scale 5
    colour_map{
      [0.00 colour rgb <0.74, 0.53, 0.31>]
      [0.60 colour rgb <0.62, 0.44, 0.26>]
      [0.80 colour rgb <0.77, 0.55, 0.32>]
      [1.00 colour rgb <0.92, 0.66, 0.26>]
    }
  }
  normal{
    wrinkles .4 scale .2*in
  }
  finish{
    roughness 0.40 ambient 0.20 diffuse 0.40
  }
}

#declare Flooring=
texture{
  pigment{
    wood
    turbulence 0.3
    color_map {
      [0.0, 0.8 colour rgb <0.50, 0.35, 0.18>
                colour rgb <0.50, 0.35, 0.18>]
      [0.8, 1.0 colour rgb <0.33, 0.14, 0.05>
                colour rgb <0.16, 0.07, 0.02>]
    }
    warp{
      repeat 4*in*z offset <0,1*in,0>
    }
  }
  finish{ambient .3 brilliance .2 diffuse .4
    specular .0 roughness .3 reflection .0
  }
}

#declare Foliage2=
texture{
  pigment{
    agate colour_map{
	  [0.0 colour rgbf<1  ,1  ,1  ,1 >]
	  [0.6 colour rgbf<1  ,1  ,1  ,1 >]
	  [0.7 colour rgbf<.17,.44,.11, 0>]
	  [1.0 colour rgbf<.1,.3,.05, 0>]
	}
	agate_turb 1.0 // octaves 2.0 omega 2.0
  }
}

#declare Foliage3=
texture{
  pigment{
    agate colour_map{
	  [0.0 colour rgbf<1.00,1.00,1.00,1.00>]
	  [0.6 colour rgbf<1.00,1.00,1.00,1.00>]
	  [0.7 colour rgbf<0.17,0.44,0.11,0.00>]
	  [0.8 colour rgbf<0.35,0.35,0.11,0.00>]
	  [1.0 colour rgbf<0.25,0.25,0.05,0.00>]
	}
	agate_turb 1.0 // octaves 2.0 omega 2.0
  }
}

#declare FrontDoor=
texture{
  pigment{
    wood
    turbulence 0.3
    colour_map{
      [0.0 colour rgb < 0.60, 0.48, 0.25>]
      [0.6 colour rgb < 0.50, 0.35, 0.18>]
      [0.9 colour rgb < 0.33, 0.14, 0.05>]
      [1.0 colour rgb < 0.65, 0.52, 0.27>]
    }
  }
  finish {
    roughness 0.1
  }
}

//g
#declare GamesWall=
texture{
  pigment{
    colour rgb <.6,.95,.7>
  }
  normal{bumps .1 scale 5}
  finish{ambient .3 brilliance .2 diffuse .2
    specular .0 roughness .1 reflection .0}
}

//below the dado rail
#declare GamesWallLow=
texture{
  pigment{
    colour rgb <.85,.75,.5>
  }
  normal{bumps .1 scale 5}
  finish{ambient .2 brilliance .2 diffuse .3
    specular .0 roughness .3 reflection .0}
}

#declare Grass=
texture{
  pigment{
    colour rgb < 0.4, 0.8, 0.6>
  }
  #if (Detailed=1)
    finish {
      roughness 0.4
    }
    normal{bumps 6*in scale <0.1,1,0.1> frequency 5
      turbulence 1 omega .8 lambda 1.5 octaves 3
    }
  #end
}

//h
#declare Hedge=
texture{
  pigment{
    colour rgb < 0.3, 0.8, 0.5>
  }
  finish{
    roughness 0.2
  }
  normal{
    bumps 4*in scale <0.25,1.00,0.25> frequency 3
    turbulence 1 omega 0.4 lambda 0.5 octaves 3
  }
}

#declare Highlight=
texture{
  pigment{
    colour rgb <1.5,1,1>
  }
  finish{
    ambient 0.4 phong 0.8 phong_size 20
  }
}

#declare Housewall=
texture{
  pigment{
    colour rgb < 0.95, 0.95, 0.80>
  }
  normal{bumps .1 scale .125}
}

//i
//j
//k
//l
#declare Lawn=
texture{
  pigment{
    colour rgb <.3,.8,.5>
  }
  normal{
    bumps 4*in scale <0.1,1,0.1> frequency 3
    turbulence 1  omega .4  lambda .5 octaves 3
  }
}

#declare LoungeWall=
texture{
  pigment{
    colour rgb < 0.50, 0.95, 0.50>
  }
  normal{
    bumps .1 scale 5
  }
  finish{
    ambient .1 brilliance .2 diffuse .2
    specular .0 roughness .3 reflection .0
  }
}

//m
#declare MownLawn=
texture{
  gradient x
  texture_map{
    [0.00 Lawn scale 1/(24*in) rotate x*15]
    [0.50 Lawn scale 1/(24*in) rotate x*15]
    [0.51 Lawn scale 1/(24*in) rotate x*-15]
    [1.00 Lawn scale 1/(24*in) rotate x*-15]
  }
  scale 24*in
}

//n
//o
//p
#declare Pavement=
texture{
  pigment{
    brick colour rgb < 0.2, 0.2, 0.2>, colour rgb < 0.45, 0.45, 0.45>
    brick_size <18*in,3*ft,3*ft> mortar .1*in
  }
  normal{
    bumps .5*in frequency 3
    turbulence 1 omega .4 lambda .5 octaves 3
  }
}

#declare PicketTex=
texture{
  pigment{
    gradient x+z
	colour_map{
      [0.00 colour rgbt < 1, 1, 1, 1>]
      [0.60 colour rgbt < 1, 1, 1, 1>]
      [0.61 colour rgbt <.8,.8,.8, 0>]
      [1.00 colour rgbt <.8,.8,.8, 0>]
	}
	scale 6*in
  }
  finish {
    roughness 0.2
  }
}
texture{
  pigment{
    gradient y
	colour_map{
      [0.00 colour rgbt < 1, 1, 1, 1>]
      [0.69 colour rgbt < 1, 1, 1, 1>]
      [0.80 colour rgbt <.8,.8,.8, 0>]
      [1.00 colour rgbt <.8,.8,.8, 0>]
	}
	scale <1,2*ft,1>
  }
  finish {
    roughness 0.2
  }
}

#declare PlayWall=
texture{
  pigment{
    colour rgb <.7,.7,.9>
  }
  finish{ambient .2 brilliance .2 diffuse .2
    specular .0 roughness .3 reflection .0}
}

#declare PoolWater=
texture{
  pigment{
    colour rgbf <.7,.7,.8,.9>
  }
  finish{
    reflection 0.3
  }
  normal{
    waves .2 frequency 20
    turbulence 1  omega .8  lambda 1.5 octaves 3
    scale .1  translate <0,0,-50>
  }
}

#declare PoolWater2=
texture{
  pigment{
    colour rgbf < 0.7, 0.7, 0.9, 0.8>
  }
  finish{
    ambient .2 brilliance .2 diffuse .2
    specular .0 roughness .3 reflection .0
  }
  normal{
    ripples frequency 4 scale <1.5*ft,10*ft,1.5*ft>
  }
}

//q
//r
#declare Roadmarks= //for a road running along the z axis
texture{
  pigment{
    gradient x
    colour_map{
      [0.00 rgbf <1,1,1,1>]
      [0.33 rgbf <1,1,1,1>]
      [0.34 rgbf <.85,.85,.8,0>*1.2]
      [1.00 rgbf <.85,.85,.8,0>*1.2]
    }
    scale 6*ft
  }
}

#declare Roadmarks2= //for yield lines on a road running -z..z axis
texture{
  pigment{
    gradient z
    colour_map{
      [0.00 rgbf <1,1,1,1>]
      [0.33 rgbf <1,1,1,1>]
      [0.34 rgbf <.85,.85,.8,0>*1.2]
      [1.00 rgbf <.85,.85,.8,0>*1.2]
    }
    scale 2*ft
  }
}

#declare RoadTar=
texture{
  pigment{
    colour rgb <.15,.15,.15>
  }
  normal{
    bumps 1*in frequency 3
    turbulence 1  omega .4  lambda .5 octaves 3
  }
}

#declare Roof=
texture{
  pigment{
    brick colour rgb < 0.15, 0.15, 0.15>, colour rgb < 0.30, 0.15, 0.05>*1.5
    brick_size <3.8*in,5.8*in,10*ft> mortar 0.5*in
  }
}

#declare RoofTex=texture{Roof}

//s
#declare SaunaWall=
texture{
  pigment{
    gradient <1,0,1>
    colour_map{
      [0.00 colour rgb <.65,.55,.4>]
      [0.99 colour rgb <.65,.55,.4>]
      [1.00 colour rgb <.65,.55,.4>*.1]
    }
    scale 6*in
  }
}

#declare Stone=
texture{
  pigment{
    brick colour rgb < 0.2, 0.2, 0.2>, colour rgb < 0.85, 0.85, 0.85>
    brick_size <2*ft,2*ft,2*ft> mortar .25*in
  }
  normal{
    bumps .1 scale <0.125,1,0.125> frequency 3
    turbulence 1 omega .4 lambda .5 octaves 3
  }
  rotate x*90
}

#declare StonePaving=texture{Stone}

// based on Dark_Wood and DMFWood6
#declare StructureWood=
texture{
  pigment{
    wood
    turbulence 0.2
    colour_map{
      [0.00 colour rgb <0.40, 0.40, 0.20>]
      [0.75 colour rgb <0.40, 0.40, 0.20>]
      [0.80 colour rgb <0.35, 0.30, 0.10>]
      [1.00 colour rgb <0.20, 0.03, 0.03>]
    }
  }
  normal{
    dents .75 scale .2*in
  }
  finish{
    roughness 0.20 ambient 0.1 diffuse 0.33 reflection 0.05
  }
}

#declare StudyWall=
texture{
  pigment{
    colour rgb <.75,.6,.2>
  }
  finish{
    ambient .3 brilliance .2 diffuse .2
    specular .05 roughness .3 reflection .0
  }
}

//t
#declare TiledMortar=
texture{
  pigment{
    colour rgb < 0.7, 0.7, 0.7>
  }
  finish{
    ambient .1 brilliance .2 diffuse .2
  }
  normal{
    bumps .1*in
  }
}

#declare TiledTiles=
texture{
  pigment{
    colour rgb < 0.9, 0.9, 0.4>
  }
  finish{
    ambient .3 brilliance .3 diffuse .3
    specular .2 roughness .3 reflection .1
  }
}

#declare Tiled=
texture{
  brick texture{TiledMortar},texture{TiledTiles}
  brick_size <4*in,4*in,4*in> mortar .1*in
  rotate x*90
}

#declare Trunk=
texture{
  pigment{
    radial
    colour_map{
      [0.0 colour rgb<.5,.25,.2>]
      [1.0 colour rgb<.25,.125,.1>]
    }
    turbulence .2 omega 2 lambda 1.2 octaves 3
    frequency 36  //rotate <-1,0,-3>
  }
}

#declare Trunk2=
texture{
  pigment{
    radial
    colour_map{
      [0.0 colour rgb<.4,.3,.15>]
      [1.0 colour rgb<.3,.22,.11>]
    }
    turbulence .2 omega 2 lambda 1.2 octaves 3
    frequency 48  rotate <7,-21,14>
  }
}

#declare Trunk3=
texture{
  pigment{
    radial
    colour_map{
      [0.0 colour rgb<.4,.3,.15>]
      [1.0 colour rgb<.3,.22,.11>]
    }
    turbulence .2 omega 2 lambda 1.2 octaves 3
    frequency 16  rotate <2,6,4>
  }
}

//u
//v
//w
#declare Wall=
texture{
  pigment{
    wrinkles turbulence 0.8 octaves 4 scale 3
    colour_map{
      [0.00 colour rgb <.60,.70,.30>]
	  [0.75 colour rgb <.70,.60,.30>]
      [0.75 colour rgb <.60,.60,.30>]
      [1.00 colour rgb <.60,.60,.38>]
    }
  }
  normal{
    wrinkles .4 scale 1*in
  }
  finish{ 
    roughness 0.40 ambient 0.20 diffuse 0.40
  }
}

#declare WallStone=
texture{
  pigment{
    wrinkles turbulence 0.8 octaves 4 scale 3
    colour_map{
      [0.00 colour rgb <.80,.92,.40>]
      [0.75 colour rgb <.92,.80,.40>]
      [0.75 colour rgb <.80,.80,.40>]
      [1.00 colour rgb <.80,.80,.50>]
    }
  }
  normal{
    wrinkles .4 scale 1*in
  }
  finish{ 
    ambient 0.20 diffuse 0.40
  }
}

#declare WhitePaint=
texture{
  pigment{
    colour rgb <.99,.99,.99>
  }
  normal{
    bumps -0.05*in
    scale <1, 0.01, 1>
  }
}

#declare WhitePlastic=
texture{
  pigment{
    colour rgb <.9,.9,.9>
  }
  finish{
    specular .2 roughness .1
  }
}

#declare Wicker=
texture{
  pigment{
    marble
    colour_map{
      [0.0  colour rgb <.5,.4,.2>]
      [1.0  colour rgb <.25,.2,.1>]
    }
  }
  scale .25
  rotate z*90
  finish{
    roughness 0.4
  }
}

#declare Wicker2=
texture{
  pigment{
    onion
    colour_map{
      [0.0  colour rgb <.5,.4,.2>]
      [1.0  colour rgb <.25,.2,.1>]
    }
  }
  scale .25
  rotate z*90
  finish{
    roughness 0.4
  }
}

#declare WindowFrame=
texture{
  pigment{
    wood
    turbulence 0.3
    colour_map{
      [0.0 colour rgb < 0.56, 0.44, 0.25>]
      [0.6 colour rgb < 0.34, 0.28, 0.15>]
      [0.9 colour rgb < 0.45, 0.35, 0.20>]
      [1.0 colour rgb < 0.67, 0.53, 0.30>]
    }
  }
  finish {
    specular 0.3 roughness 0.2
  }
  scale .25*ft
}

//x
//y
//z
//===================================================================================
                               e  Icon
           @         
unbtex.inc-20EX)crectsurfaces- TEXTMPS                      l  .  u  
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         <    (         x       x ttxt8BIM   	                           >                               ?  f$` 9  FhR     H 	Monaco 
 !P             
   M M  9  9       M M                      eP    R MPSR  FPRF   *          ,          POV-Ray File Prefs           