//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 59 materials and 111 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 06/27/1999    (27.06.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       2.0
    count            800                //200
    distance_maximum 0.0
    error_bound      0.2                //0.5
    gray_threshold   0.5
    low_error_factor 0.7           //0.015
    nearest_count    8
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     33.150,     -67.990,      26.170>
  direction <        0.0,         0.0,      2.9641> // Aperture is 0.33 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      1.124,       0.719,       2.072>
}

//
// *******  L I G H T S *******
//

light_source {   // Filler_Light
  <33.150, -67.990, 26.170>
  color rgb <1.000, 1.000, 1.000>*0.1500
}

light_source { // Arealight001
  <78.490, -56.680, 53.950>
  color rgb <1.000, 1.000, 1.000>*0.6000       //*0.5
  area_light <5.675, -3.277, -4.589>, <4.000, 6.928, 0.000>, 5, 5
  adaptive 1
  jitter
}



//
// ********  MATERIALS  *******
//

#include "shelter2.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#include "C:\Moray For Windows\Udo\magazine test.inc"

#declare New_Bottom_Cover_Ref = object {
  ObjectOne
  material {
    RobotMag_2
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Bottom_Edge_Ref = object {
  ObjectTwo
  material {
    Spine_Edge
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Top_Cover_Ref = object {
  ObjectThree
  material {
    RobotMag_2
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Top_Edge_Ref = object {
  ObjectFour
  material {
    Spine_Edge
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Spine_Ref = object {
  ObjectFive
  material {
    Spine_Letters
    scale <90.0, 5.0, 1.0>
    rotate <-90.0, -180.0, -270.0>
    translate <0.000000, 45.000000, 0.040000>
  }
}
#declare New_Pages_Ref = object {
  ObjectSix
  material {
    Edge_1
    scale <5.0, 65.0, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate <60.090000, 0.000000, -0.080000>
  }
}
#declare New_Robot_Magazine = union {
  object { New_Bottom_Cover_Ref }
  object { New_Bottom_Edge_Ref }
  object { New_Top_Cover_Ref }
  object { New_Top_Edge_Ref }
  object { New_Spine_Ref }
  object { New_Pages_Ref }
  scale 0.15
  rotate <-0.0, 0.0, 88.0>
  translate  <-7.8, -10.07, 2.85>
}
#declare New_Bottom_Cover1_Ref = object {
  ObjectOne
  material {
    DinoMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Bottom_Edge1_Ref = object {
  ObjectTwo
  material {
    Spine_Edge_5
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Top_Cover1_Ref = object {
  ObjectThree
  material {
    DinoMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Top_Edge1_Ref = object {
  ObjectFour
  material {
    Spine_Edge_5
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Spine1_Ref = object {
  ObjectFive
  material {
    Spine_Letters_5
    scale <90.0, 5.0, 1.0>
    rotate <-90.0, -180.0, -270.0>
    translate <0.000000, 45.000000, 0.040000>
  }
}
#declare New_Pages1_Ref = object {
  ObjectSix
  material {
    Edge_1
    scale <5.0, 65.0, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate <60.000000, 0.000000, -0.250000>
  }
}
#declare New_DinoMagazine = union {
  object { New_Bottom_Cover1_Ref }
  object { New_Bottom_Edge1_Ref }
  object { New_Top_Cover1_Ref }
  object { New_Top_Edge1_Ref }
  object { New_Spine1_Ref }
  object { New_Pages1_Ref }
  scale 0.15
  rotate <98.0, 0.0, 90.0>
  translate  <1.15, -10.08, 7.34>
}
#declare New_Bottom_Cover2_Ref = object {
  ObjectOne
  material {
    PinkMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Bottom_Edge2_Ref = object {
  ObjectTwo
  material {
    Spine_Edge_6
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Top_Cover2_Ref = object {
  ObjectThree
  material {
    PinkMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Top_Edge2_Ref = object {
  ObjectFour
  material {
    Spine_Edge_6
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Spine2_Ref = object {
  ObjectFive
  material {
    Spine_Letters_6
    scale <90.0, 5.0, 1.0>
    rotate <-90.0, -180.0, -270.0>
    translate <0.000000, 45.000000, 0.040000>
  }
}
#declare New_Pages2_Ref = object {
  ObjectSix
  material {
    Edge_1
    scale <5.0, 65.0, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate <60.060001, 0.000000, 0.010000>
  }
}
#declare New_Pink_Magazine = union {
  object { New_Bottom_Cover2_Ref }
  object { New_Bottom_Edge2_Ref }
  object { New_Top_Cover2_Ref }
  object { New_Top_Edge2_Ref }
  object { New_Spine2_Ref }
  object { New_Pages2_Ref }
  scale 0.15
  rotate <-78.0, 0.0, 90.0>
  translate  <0.67, -9.83, 7.15>
}
#declare New_Bottom_Cover3_Ref = object {
  ObjectOne
  material {
    BlueMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Bottom_Edge3_Ref = object {
  ObjectTwo
  material {
    Spine_Edge_7
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Top_Cover3_Ref = object {
  ObjectThree
  material {
    BlueMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Top_Edge3_Ref = object {
  ObjectFour
  material {
    Spine_Edge_7
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Spine3_Ref = object {
  ObjectFive
  material {
    Spine_Letters_7
    scale <90.0, 5.0, 1.0>
    rotate <-90.0, -180.0, -270.0>
    translate <0.000000, 45.000000, 0.040000>
  }
}
#declare New_Pages3_Ref = object {
  ObjectSix
  material {
    Edge_1
    scale <5.0, 65.0, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate <59.950001, 0.000000, -0.120000>
  }
}
#declare New_Blue_Magazine = union {
  object { New_Bottom_Cover3_Ref }
  object { New_Bottom_Edge3_Ref }
  object { New_Top_Cover3_Ref }
  object { New_Top_Edge3_Ref }
  object { New_Spine3_Ref }
  object { New_Pages3_Ref }
  scale 0.15
  rotate 95.0*z
  translate  <-8.0, -12.39, 0.55>
}
#declare New_Bottom_Cover4_Ref = object {
  ObjectOne
  material {
    GreenMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Bottom_Edge4_Ref = object {
  ObjectTwo
  material {
    Spine_Edge_8
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Top_Cover4_Ref = object {
  ObjectThree
  material {
    GreenMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Top_Edge4_Ref = object {
  ObjectFour
  material {
    Spine_Edge_8
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Spine4_Ref = object {
  ObjectFive
  material {
    Spine_Letters_8
    scale <90.0, 5.0, 1.0>
    rotate <-90.0, -180.0, -270.0>
    translate <0.000000, 45.000000, 0.040000>
  }
}
#declare New_Pages4_Ref = object {
  ObjectSix
  material {
    Edge_1
    scale <5.0, 65.0, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate <60.000000, 0.000000, 0.020000>
  }
}
#declare New_Green_Magazine = union {
  object { New_Bottom_Cover4_Ref }
  object { New_Bottom_Edge4_Ref }
  object { New_Top_Cover4_Ref }
  object { New_Top_Edge4_Ref }
  object { New_Spine4_Ref }
  object { New_Pages4_Ref }
  scale 0.15
  rotate 90.0*z
  translate  <-8.03, -11.55, 1.39>
}
#declare New_Bottom_Cover5_Ref = object {
  ObjectOne
  material {
    PinkMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Bottom_Edge5_Ref = object {
  ObjectTwo
  material {
    Spine_Edge_6
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Top_Cover5_Ref = object {
  ObjectThree
  material {
    PinkMag
    scale <60.0, 90.0, 1.0>
    translate <0.120000, -45.000000, 0.000000>
  }
}
#declare New_Top_Edge5_Ref = object {
  ObjectFour
  material {
    Spine_Edge_6
    scale <90.0, 2.0, 1.0>
    rotate -90.0*z
    translate <-4.940000, 45.000000, 0.000000>
  }
}
#declare New_Spine5_Ref = object {
  ObjectFive
  material {
    Spine_Letters_6
    scale <90.0, 5.0, 1.0>
    rotate <-90.0, -180.0, -270.0>
    translate <0.000000, 45.000000, 0.040000>
  }
}
#declare New_Pages5_Ref = object {
  ObjectSix
  material {
    Edge_1
    scale <5.0, 65.0, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate <60.419998, 0.000000, 0.010000>
  }
}
#declare New_Pink_Magazine1 = union {
  object { New_Bottom_Cover5_Ref }
  object { New_Bottom_Edge5_Ref }
  object { New_Top_Cover5_Ref }
  object { New_Top_Edge5_Ref }
  object { New_Spine5_Ref }
  object { New_Pages5_Ref }
  scale 0.15
  rotate -90.0*z
  translate  <-7.96, -2.57, 2.12>
}
union { // Magazines
  object { New_Robot_Magazine }
  object { New_DinoMagazine }
  object { New_Pink_Magazine }
  object { New_Blue_Magazine }
  object { New_Green_Magazine }
  object { New_Pink_Magazine1 }
}






#include "C:\Moray For Windows\Udo\radiation.inc"

#declare Screw_Ref = object {
  Object1
  rotate <0.0, -0.0, -0.0>
  translate  <-30.04, 0.668453, -0.505913>
  material {
    Brace_Metal
  }
  rotate <-8.0, -15.0, -0.0>
  translate  <13.77, -30.78, 39.5>
}
#declare Sign_Screw_Ref = object {
  Object2
  material {
    Test_Chrome
  }
}
#declare Object30_Ref = object {
  Object3
  material {
    Sign
    scale <30.0, 40.0, 30.0>
    translate <-15.040000, -19.910000, 0.000000>
  }
}
union { // Radiation_Sign
  object { Screw_Ref }
  object { Sign_Screw_Ref }
  object { Object30_Ref }
  scale 0.4
  rotate 90.0*x
  translate  <-11.5, -0.99, 13.07>
}


#include "C:\Moray For Windows\Udo\can.inc"

#declare Object1_Ref = object {
  Object1
  material {
    Metal
  }
}
#declare UserDefGroup1 = union {
  object { Object1_Ref }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Label
      scale <1.0, 1.0, 0.5>
      translate <0.000000, 0.000000, 0.500000>
    }
    // Rotation fixed
    scale <37.25, 37.25, 78.75>
    translate  -47.2*z
  }
  material {
    Label
    scale <1.0, 1.0, 100.0>
    rotate <0.000034, 0.000023, 120.0>
    translate <0.000000, 0.000000, -46.700001>
  }
  scale 0.07
  rotate <-0.0, -0.0, 60.0>
  translate  <4.56, -4.03, 4.77>
}
#declare Object2_Ref = object {
  Object1
  material {
    Metal
  }
}
#declare UserDefGroup2 = union {
  object { Object2_Ref }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Label
      scale <1.0, 1.0, 0.5>
      translate <0.000000, 0.000000, 0.500000>
    }
    // Rotation fixed
    scale <37.25, 37.25, 78.75>
    translate  -47.2*z
  }
  material {
    Label
    scale <1.0, 1.0, 100.0>
    rotate <0.000034, 0.000023, 120.0>
    translate <0.000000, 0.000000, -46.700001>
  }
  scale 0.07
  rotate 30.0*z
  translate  <10.56, -4.06, 4.77>
}
#declare Object3_Ref = object {
  Object1
  material {
    Metal
  }
}
#declare UserDefGroup3 = union {
  object { Object3_Ref }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Label
      scale <1.0, 1.0, 0.5>
      translate <0.000000, 0.000000, 0.500000>
    }
    // Rotation fixed
    scale <37.25, 37.25, 78.75>
    translate  -47.2*z
  }
  material {
    Label
    scale <1.0, 1.0, 100.0>
    rotate <0.000034, 0.000023, 120.0>
    translate <0.000000, 0.000000, -46.700001>
  }
  scale 0.07
  rotate -170.0*z
  translate  <16.01, -4.3, 4.77>
}
#declare Object4_Ref = object {
  Object1
  material {
    Metal
  }
}
#declare UserDefGroup4 = union {
  object { Object4_Ref }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Label
      scale <1.0, 1.0, 0.5>
      translate <0.000000, 0.000000, 0.500000>
    }
    // Rotation fixed
    scale <37.25, 37.25, 78.75>
    translate  -47.2*z
  }
  material {
    Label
    scale <1.0, 1.0, 100.0>
    rotate <0.000034, 0.000023, 120.0>
    translate <0.000000, 0.000000, -46.700001>
  }
  scale 0.07
  rotate <-0.0, -0.0, -20.0>
  translate  <7.64, -4.03, 11.67>
}
#declare Object5_Ref = object {
  Object1
  material {
    Metal
  }
}
#declare UserDefGroup5 = union {
  object { Object5_Ref }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Label
      scale <1.0, 1.0, 0.5>
      translate <0.000000, 0.000000, 0.500000>
    }
    // Rotation fixed
    scale <37.25, 37.25, 78.75>
    translate  -47.2*z
  }
  material {
    Label
    scale <1.0, 1.0, 100.0>
    rotate <0.000034, 0.000023, 120.0>
    translate <0.000000, 0.000000, -46.700001>
  }
  scale 0.07
  rotate 30.0*z
  translate  <14.01, -4.03, 11.74>
}
#declare Object6_Ref = object {
  Object1
  material {
    Metal
  }
}
#declare UserDefGroup6 = union {
  object { Object6_Ref }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Label
      scale <1.0, 1.0, 0.5>
      translate <0.000000, 0.000000, 0.500000>
    }
    // Rotation fixed
    scale <37.25, 37.25, 78.75>
    translate  -47.2*z
  }
  material {
    Label
    scale <1.0, 1.0, 100.0>
    rotate <0.000034, 0.000023, 120.0>
    translate <0.000000, 0.000000, -46.700001>
  }
  scale 0.07
  rotate <90.0, 0.0, 55.0>
  translate  <13.49, -11.25, 3.35>
}
union { // Cans
  object { UserDefGroup1 }
  object { UserDefGroup2 }
  object { UserDefGroup3 }
  object { UserDefGroup4 }
  object { UserDefGroup5 }
  object { UserDefGroup6 }
}


#include "C:\Moray For Windows\Udo\brace.inc"

#declare Object21_Ref = object {
  Object1
}
#declare Object22_Ref = object {
  Object2
}
#declare Object23_Ref = object {
  Object3
  rotate <-0.0, 0.0, -0.0>
  translate  <-1.73, 0.81, 7.98>
  rotate -35.0*y
  translate  <1.73, -0.81, -7.98>
}
#declare Object24_Ref = object {
  Object4
}
#declare Object25_Ref = object {
  Object5
}
#declare Object26_Ref = object {
  Object6
}
#declare UserDefGroup8 = union {
  object { Object21_Ref }
  object { Object22_Ref }
  object { Object23_Ref }
  object { Object24_Ref }
  object { Object25_Ref }
  object { Object26_Ref }
  material {
    Brace_Metal
  }
  scale 0.6
  translate  <17.71, -0.59, -0.6>
}
#declare Object29_Ref = object {
  Object3
  rotate <-0.0, -0.0, 0.0>
  translate  <-0.0, 0.583333, 8.0>
  scale <0.6, 0.3, 0.6>
  rotate <-90.0, -0.0, -0.0>
  translate  <17.88, -5.38, 0.54>
}
union { // Brackets
  object { UserDefGroup8 }
  object { Object29_Ref }
  material {
    Brace_Metal
  }
}


merge {  // RndCube001
  sphere { <29.9000, 4.9000, 0.4000>, 0.1000 }
  sphere { <29.9000, -4.9000, 0.4000>, 0.1000 }
  sphere { <-29.9000, -4.9000, 0.4000>, 0.1000 }
  sphere { <-29.9000, 4.9000, 0.4000>, 0.1000 }
  sphere { <29.9000, 4.9000, -0.4000>, 0.1000 }
  sphere { <29.9000, -4.9000, -0.4000>, 0.1000 }
  sphere { <-29.9000, -4.9000, -0.4000>, 0.1000 }
  sphere { <-29.9000, 4.9000, -0.4000>, 0.1000 }
  cylinder { <29.9000, 4.9000, 0.4000>, <-29.9000, 4.9000, 0.4000>, 0.1000 }
  cylinder { <29.9000, -4.9000, 0.4000>, <-29.9000, -4.9000, 0.4000>, 0.1000 }
  cylinder { <29.9000, -4.9000, -0.4000>, <-29.9000, -4.9000, -0.4000>, 0.1000 }
  cylinder { <29.9000, 4.9000, -0.4000>, <-29.9000, 4.9000, -0.4000>, 0.1000 }
  cylinder { <29.9000, 4.9000, -0.4000>, <29.9000, 4.9000, 0.4000>, 0.1000 }
  cylinder { <29.9000, -4.9000, -0.4000>, <29.9000, -4.9000, 0.4000>, 0.1000 }
  cylinder { <-29.9000, -4.9000, -0.4000>, <-29.9000, -4.9000, 0.4000>, 0.1000 }
  cylinder { <-29.9000, 4.9000, -0.4000>, <-29.9000, 4.9000, 0.4000>, 0.1000 }
  cylinder { <29.9000, 4.9000, 0.4000>, <29.9000, -4.9000, 0.4000>, 0.1000 }
  cylinder { <29.9000, 4.9000, -0.4000>, <29.9000, -4.9000, -0.4000>, 0.1000 }
  cylinder { <-29.9000, 4.9000, -0.4000>, <-29.9000, -4.9000, -0.4000>, 0.1000 }
  cylinder { <-29.9000, 4.9000, 0.4000>, <-29.9000, -4.9000, 0.4000>, 0.1000 }
  box { <-29.9000, -4.9000, -0.5000> <29.9000, 4.9000, 0.5000> }
  box { <-29.9000, -5.0000, -0.4000> <29.9000, 5.0000, 0.4000> }
  box { <-30.0000, -4.9000, -0.4000> <30.0000, 4.9000, 0.4000> }
// Attributes returned success!
  material {
    Wood_2
    scale 0.7
    rotate 2.0*y
    translate <1.410000, 0.490000, 1.340000>
  }
  translate  <-10.24, -5.56, 0.0>
}


merge {  // RndCube002
  sphere { <29.9000, 4.9000, 0.4500>, 0.1000 }
  sphere { <29.9000, -4.9000, 0.4500>, 0.1000 }
  sphere { <-29.9000, -4.9000, 0.4500>, 0.1000 }
  sphere { <-29.9000, 4.9000, 0.4500>, 0.1000 }
  sphere { <29.9000, 4.9000, -0.4500>, 0.1000 }
  sphere { <29.9000, -4.9000, -0.4500>, 0.1000 }
  sphere { <-29.9000, -4.9000, -0.4500>, 0.1000 }
  sphere { <-29.9000, 4.9000, -0.4500>, 0.1000 }
  cylinder { <29.9000, 4.9000, 0.4500>, <-29.9000, 4.9000, 0.4500>, 0.1000 }
  cylinder { <29.9000, -4.9000, 0.4500>, <-29.9000, -4.9000, 0.4500>, 0.1000 }
  cylinder { <29.9000, -4.9000, -0.4500>, <-29.9000, -4.9000, -0.4500>, 0.1000 }
  cylinder { <29.9000, 4.9000, -0.4500>, <-29.9000, 4.9000, -0.4500>, 0.1000 }
  cylinder { <29.9000, 4.9000, -0.4500>, <29.9000, 4.9000, 0.4500>, 0.1000 }
  cylinder { <29.9000, -4.9000, -0.4500>, <29.9000, -4.9000, 0.4500>, 0.1000 }
  cylinder { <-29.9000, -4.9000, -0.4500>, <-29.9000, -4.9000, 0.4500>, 0.1000 }
  cylinder { <-29.9000, 4.9000, -0.4500>, <-29.9000, 4.9000, 0.4500>, 0.1000 }
  cylinder { <29.9000, 4.9000, 0.4500>, <29.9000, -4.9000, 0.4500>, 0.1000 }
  cylinder { <29.9000, 4.9000, -0.4500>, <29.9000, -4.9000, -0.4500>, 0.1000 }
  cylinder { <-29.9000, 4.9000, -0.4500>, <-29.9000, -4.9000, -0.4500>, 0.1000 }
  cylinder { <-29.9000, 4.9000, 0.4500>, <-29.9000, -4.9000, 0.4500>, 0.1000 }
  box { <-29.9000, -4.9000, -0.5500> <29.9000, 4.9000, 0.5500> }
  box { <-29.9000, -5.0000, -0.4500> <29.9000, 5.0000, 0.4500> }
  box { <-30.0000, -4.9000, -0.4500> <30.0000, 4.9000, 0.4500> }
// Attributes returned success!
  material {
    Wood_2
    scale 0.7
    rotate -2.0*z
    translate <0.000000, 0.140000, -3.530000>
  }
  translate  <-10.27, -15.74, 0.0>
}


#include "C:\Moray For Windows\Udo\car.inc"

#declare Object8_Ref = object {
  Object1
}
#declare Object9_Ref = object {
  Object2
}
#declare Object10_Ref = object {
  Object3
  material {
    Test_Chrome
  }
}
#declare Object11_Ref = object {
  Object4
  material {
    Test_Chrome
  }
}
#declare Object12_Ref = object {
  Object5
  material {
    Test_Chrome
  }
}
#declare Object13_Ref = object {
  Object6
  material {
    Test_Chrome
  }
}
#declare Object14_Ref = object {
  Object7
  material {
    No_Stripe
  }
}
#declare Object15_Ref = object {
  Object8
  material {
    No_Stripe
  }
}
#declare Object16_Ref = object {
  Object9
  material {
    No_Stripe
  }
}
#declare Object17_Ref = object {
  Object10
}
#declare Object18_Ref = object {
  Object11
}
#declare Object19_Ref = object {
  Object12
  material {
    No_Stripe
  }
}
#declare Object20_Ref = object {
  Object13
  material {
    Dome
  }
}
union { // Flying_Car
  object { Object8_Ref }
  object { Object9_Ref }
  object { Object10_Ref }
  object { Object11_Ref }
  object { Object12_Ref }
  object { Object13_Ref }
  object { Object14_Ref }
  object { Object15_Ref }
  object { Object16_Ref }
  object { Object17_Ref }
  object { Object18_Ref }
  object { Object19_Ref }
  object { Object20_Ref }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Test_Chrome
    }
    scale 0.6
    rotate -0.0*z
    translate  <-15.0, -3.2, 26.6>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Test_Chrome
    }
    scale <0.2, 0.2, 30.0>
    rotate <-15.0, 0.0, -0.0>
    translate  <-15.0, -11.0, -2.4>
  }
  material {
    Test_Hull
    scale <-12.75, -42.400002, 1.0>
    rotate 90.0*z
  }
  scale 0.08
  rotate -30.0*z
  translate  <17.81, -17.68, 1.96>
}


#declare Bricks = union {
  superellipsoid { // SuperQ001
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-3.37, 0.35, 1.4>
  }
  superellipsoid { // SuperQ002
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <2.99, 0.35, 1.38>
  }
  superellipsoid { // SuperQ003
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <6.31, 0.35, 4.6>
  }
  superellipsoid { // SuperQ004
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-0.06, 0.35, 4.63>
  }
  superellipsoid { // SuperQ005
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-6.42, 0.35, 4.66>
  }
  superellipsoid { // SuperQ006
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-9.65, 0.35, 1.46>
  }
  superellipsoid { // SuperQ007
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <9.37, 0.35, 1.46>
  }
  superellipsoid { // SuperQ008
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <6.22, 0.35, -1.8>
  }
  superellipsoid { // SuperQ009
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-0.06, 0.35, -1.8>
  }
  superellipsoid { // SuperQ010
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-6.37, 0.35, -1.76>
  }
  superellipsoid { // SuperQ011
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-9.67, 0.35, -4.94>
  }
  superellipsoid { // SuperQ012
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <-3.34, 0.35, -4.93>
  }
  superellipsoid { // SuperQ013
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <2.99, 0.35, -4.95>
  }
  superellipsoid { // SuperQ014
    <0.05, 0.05>
    scale <3.05, 1.0, 1.45>
    translate  <9.33, 0.35, -5.05>
  }
  material {
    Brick
  }
}
#declare HgtFld002 = object { 
  height_field {
    tga "C:\MORAY FOR WINDOWS\Maps\Mortar3.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Wall
  }
  scale <8.0, 6.0, 0.1>
  rotate 90.0*x
  translate  <0.0, -0.53, -0.01>
}
union { // Brick_Wall
  object { Bricks }
  object { HgtFld002 }
  scale <4.0, 4.0, -4.0>
  translate  <5.03, 2.35, -0.11>
}


#include "C:\Moray For Windows\Udo\can opener.inc"

#declare Disk_Ref = object {
  Object1
  material {
    Dark_Metal
  }
}
#declare Panel_Ref = object {
  Object2
  material {
    Dark_Metal
  }
}
#declare Round_Cap_Ref = object {
  Object3
  material {
    Test_Chrome_1
  }
}
#declare Twisty_Handle_Ref = object {
  Object4
  material {
    Test_Chrome_1
  }
}
#declare Round_Handle_Ref = object {
  Object5
  material {
    Test_Chrome_1
  }
}
#declare Turner_Ref = object {
  Object6
  material {
    Test_Chrome_1
  }
}
#declare Cutting_Disk_Ref = object {
  Object7
  material {
    Test_Chrome_1
  }
}
union { // Can_Opener
  object { Disk_Ref }
  object { Panel_Ref }
  object { Round_Cap_Ref }
  object { Twisty_Handle_Ref }
  object { Round_Handle_Ref }
  object { Turner_Ref }
  object { Cutting_Disk_Ref }
  rotate <0.0, 0.0, -0.0>
  translate  <-7.5, 0.0, 5.0>
  scale 0.12
  rotate <-0.0, 10.0, -135.118561>
  translate  <12.49, -19.83, 0.59>
}


#declare Blob001 = blob {
  threshold 0.6
  component 1.0, 1.138134, <0.312236, 0.0, -0.075949>
  component 1.0, 0.739734, <-0.008439, 0.0, 0.379747>
  component 1.0, 0.782085, <-0.362869, 0.0, 0.160338>
  component 1.0, 0.826856, <-0.396624, 0.0, -0.345992>
  component 1.0, 0.583052, <-0.227848, 0.0, -1.004219>
  component 1.0, 0.414573, <0.953587, 0.0, -1.105485>
  component 1.0, 0.305807, <1.240506, 0.0, -1.223629>
  component 1.0, 0.732006, <1.105485, 0.0, -0.092827>
  component 1.0, 0.414573, <-0.481013, 0.0, 0.632911>
  material {
    Puddle
  }
  scale <1.25, 0.5, 1.35>
  rotate <90.0, -0.0, -20.0>
  translate  <0.13, -1.91, 0.0>
}

#include "C:\Moray For Windows\Udo\spoon.inc"

#declare SpoonObject1_Ref = object {
  SpoonObject1
  material {
    Spoon_Metal
  }
  scale 0.15
}
union { // Spoon_and_Spill
  object { Blob001 }
  object { SpoonObject1_Ref }
  rotate -15.0*z
  translate  <3.44, -16.88, 0.54>
}


#declare RndCube003 = merge {
  sphere { <2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, 3.8500, -0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  box { <-2.3500, -3.8500, -1.0000> <2.3500, 3.8500, 1.0000> }
  box { <-2.3500, -4.3500, -0.5000> <2.3500, 4.3500, 0.5000> }
  box { <-2.8500, -3.8500, -0.5000> <2.8500, 3.8500, 0.5000> }
// Attributes returned success!
}
#declare King_Card = intersection {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 0.025>
  }
  object { RndCube003 }
  material {
    King
    scale <5.7, 8.7, 1.0>
    translate <-2.840000, -4.340000, 0.000000>
  }
  rotate -10.0*z
  translate  <0.16, 1.9, 0.19>
}
#declare RndCube004 = merge {
  sphere { <2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, 3.8500, -0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  box { <-2.3500, -3.8500, -1.0000> <2.3500, 3.8500, 1.0000> }
  box { <-2.3500, -4.3500, -0.5000> <2.3500, 4.3500, 0.5000> }
  box { <-2.8500, -3.8500, -0.5000> <2.8500, 3.8500, 0.5000> }
// Attributes returned success!
}
#declare Back_Card = intersection {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 0.025>
  }
  object { RndCube004 }
  material {
    Back
    scale <5.7, 8.7, 1.0>
    translate <-2.840000, -4.340000, 0.000000>
  }
  rotate -45.0*z
  translate  <3.05, 1.81, 0.06>
}
#declare RndCube005 = merge {
  sphere { <2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, 3.8500, -0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  box { <-2.3500, -3.8500, -1.0000> <2.3500, 3.8500, 1.0000> }
  box { <-2.3500, -4.3500, -0.5000> <2.3500, 4.3500, 0.5000> }
  box { <-2.8500, -3.8500, -0.5000> <2.8500, 3.8500, 0.5000> }
// Attributes returned success!
}
#declare Eight_Card = intersection {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 0.025>
  }
  object { RndCube005 }
  material {
    Eight
    scale <5.7, 8.7, 1.0>
    translate <-2.840000, -4.340000, 0.000000>
  }
}
#declare RndCube006 = merge {
  sphere { <2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, 0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, 0.5000>, 0.5000 }
  sphere { <2.3500, 3.8500, -0.5000>, 0.5000 }
  sphere { <2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, -3.8500, -0.5000>, 0.5000 }
  sphere { <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, -0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, -3.8500, -0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, -3.8500, -0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, 3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, 0.5000>, <2.3500, -3.8500, 0.5000>, 0.5000 }
  cylinder { <2.3500, 3.8500, -0.5000>, <2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, -0.5000>, <-2.3500, -3.8500, -0.5000>, 0.5000 }
  cylinder { <-2.3500, 3.8500, 0.5000>, <-2.3500, -3.8500, 0.5000>, 0.5000 }
  box { <-2.3500, -3.8500, -1.0000> <2.3500, 3.8500, 1.0000> }
  box { <-2.3500, -4.3500, -0.5000> <2.3500, 4.3500, 0.5000> }
  box { <-2.8500, -3.8500, -0.5000> <2.8500, 3.8500, 0.5000> }
// Attributes returned success!
}
#declare Nine_Card = intersection {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 0.025>
  }
  object { RndCube006 }
  material {
    Nine
    scale <5.7, 8.7, 1.0>
    translate <-2.840000, -4.340000, 0.000000>
  }
  rotate 60.0*z
  translate  <-1.08, 1.6, 0.12>
}
union { // Pile_of_Cards
  object { King_Card }
  object { Back_Card }
  object { Eight_Card }
  object { Nine_Card }
  scale 0.75
  rotate 3.0*z
  translate  <-5.04, -18.89, 0.6>
}


