// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions



//debut de fichier
camera {
   location <-30, 1, -52>
   //location <-100,50,-500>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <10, 30, 10>
     //look_at <10,200,6>
}

#default {
  pigment {rgb <1,1,1>} finish {ambient 0.2 diffuse 0.7}
 }
// area light (creation d'ombre douce)
// ATTENTION : l'utilisation de cette source lumineuse augmente le temps de rendu
light_source {
    0*x //<POSITION> (on bouge apres)
    color rgb 1.0 //<COULEUR>
    area_light 
    <8,0,0> <0,0,8>//<AXIS1>, <AXIS2>, SIZE1, SIZE2
    4, 4 // nombre total de lumiere sur la grille (4x*4y = 16 lumieres)
    adaptive 0//ADAPTIVE 0,1,2,3...
    jitter //JITTER
    //FADE_DISTANCE // attnuation de la lumire avec la distance
    //FADE_POWER 		// idem
    translate <-10,1400,-10> // <xyz> position de la lumiere 
}

//creation d'une source de lumiere ponctuelle
light_source {
    0*x   //POSITION de base
    color rgb 1 shadowless //COULEUR
    //fade_distance FADE_DISTANCE // attnuation de la lumire avec la distance
    // fade_power FADE_POWER 		// idem
    translate <-200, 400, -200>// deplace  la lumiere
    } 

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
texture {
    pigment { color rgbf<0.1, 1, 0, 0>
    }
    normal {
        bumps 0.2
        scale <0.01, 0.01, 0.01>
    }
    finish {
        crand 0.3
        ambient 0.3
        phong 0.2  phong_size 40
    }
}

}


#declare trou =
sphere {
  <0,0.25,-0.2> 0.09
  finish {
      ambient 0.1
      diffuse 0.6
      phong 0.8
      phong_size 80
    }
  pigment {Black}
  }

#declare sdom =
difference {
superellipsoid
{
  <0.1,  // east-west exponent (0.0 ... 1.0)
  0.1>  // north-south exponent (0.0 ... 1.0)
  scale 0.5  scale <0.5,1,0.25> translate 0.5*y 
}
cylinder {
<-0.2,0.5,-0.2><0.2,0.5,-0.2>0.08 
finish {
      ambient 0.1
      diffuse 0.6
    }
  pigment {Black}
}
}
#declare d0=
object {trou scale 0.01 translate 0.2*z}
#declare d1 =
object {trou}
#declare d2 =
union {
object {trou translate <-0.12,0.12,0>}
object {trou translate <0.12,-0.12,0>}
}
#declare d3 =
union {
object {trou }             
object {d2}
}
#declare d4 =
union {
object {trou translate <-0.12,0.12,0>}
object {trou translate <0.12,-0.12,0>}
object {trou translate <0.12,0.12,0>}
object {trou translate <-0.12,-0.12,0>}
}
#declare d5 =
union {
object {d4}
object {trou}   
}
#declare d6 =
union {
object {d4}
object {trou translate -0.12*x}
object {trou translate 0.12*x}
}

//#declare rsd=seed(1);
//debut macro
#macro domplac (
        pdx,
        pdy,
        pdz,
        rot
        ) 


//#declare rsl=seed(rsd);

#if (rot = 0 )
       #declare movx = 0.5;
       #declare movz = 0.25;
#end

#if (rot = 90 )
     #declare movx = 0.25;
     #declare movz = 0.5;   
#end 

#if (rot = 180 )
     #declare movx = 0.5;
     #declare movz = 0.25;   
#end 

#if (rot = -90 )
     #declare movx = 0.25;
     #declare movz = 0.5;   
#end

//au dessus c'est bon
#declare chif = 0.142857142857142857142857142857143;

#declare rd=rand(rsd);
#declare rdl=rand(rsd);
#declare domino=
difference {
object {sdom }

union {
//creation inf
#if (rd < chif)
object {d0}
 #else
 #if (rd < (chif*2))
 object {d1}
   #else
   #if (rd < (chif*3))
   object {d2}
   #else
    #if (rd<(chif*4))
    object {d3}
    #else
     #if (rd<(chif*5))
     object {d4}
     #else
      #if (rd<(chif*6))
      object {d5}
      #else 
      object {d6}
      #end
     #end
    #end
   #end
  #end
#end
//trou sup
#if (rdl<chif)
object {d0}
 #else
 #if (rdl<(chif*2))
 object {d1 translate 0.5*y}
   #else
   #if (rdl<(chif*3))
   object {d2 translate 0.5*y}
   #else
    #if (rdl<(chif*4))
    object {d3 translate 0.5*y}
    #else
     #if (rdl<(chif*5))
     object {d4 translate 0.5*y}
     #else
      #if (rdl<(chif*6))
      object {d5 translate 0.5*y}
      #else 
      object {d6 translate 0.5*y} 
      #end
     #end
    #end
   #end
  #end
#end
}scale 2}

//au dessous c'est bon
object {domino rotate rot*y translate <pdx+movx,pdy,pdz+movz>}

#end        

//fin macro


#declare nba=0;

//rdc
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<-1)
domplac (pdx,0,0,0)
#declare pdx=pdx+1;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=1;
#while (pdx<7)
domplac (pdx,0,0,0)
#declare pdx=pdx+1;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<-5)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-4;
#while (pdx<-3)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-2;
#while (pdx<2)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=3;
#while (pdx<4)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=5;
#while (pdx<7)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<7)
domplac (pdx,4,0,0)
#declare pdx=pdx+1;
#end

//mur gauche
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<14.5)
domplac (-7,0,pdz,90)
#declare pdz=pdz+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<7.25)
domplac (-7,2,pdz,90)
#declare pdz=pdz+2;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=7.5;
#while (pdz<14)
domplac (-7,2,pdz,90)
#declare pdz=pdz+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<14.5)
domplac (-7,4,pdz,90)
#declare pdz=pdz+1;
#end

//mur du fond
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<7)
domplac (pdx,0,14.5,180)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<0)
domplac (pdx,2,14.5,180)
#declare pdx=pdx+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=0;
#while (pdx<7)
domplac (pdx,2,14.5,180)
#declare pdx=pdx+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<7)
domplac (pdx,4,14.5,180)
#declare pdx=pdx+1;
#end


//mur droite
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<14.5)
domplac (6.5,0,pdz,-90)
#declare pdz=pdz+1;
#end  

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<7.25)
domplac (6.5,2,pdz,-90)
#declare pdz=pdz+2;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=7.5;
#while (pdz<14)
domplac (6.5,2,pdz,-90)
#declare pdz=pdz+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<14.5)
domplac (6.5,4,pdz,-90)
#declare pdz=pdz+1;
#end


#declare etage =
union { 
//mur du fond
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<0)
domplac (pdx,2,14.5,180)
#declare pdx=pdx+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=0;
#while (pdx<7)
domplac (pdx,2,14.5,180)
#declare pdx=pdx+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<7)
domplac (pdx,4,14.5,180)
#declare pdx=pdx+1;
#end

//mur de gauche
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<7.25)
domplac (-7,2,pdz,90)
#declare pdz=pdz+2;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=7.5;
#while (pdz<14)
domplac (-7,2,pdz,90)
#declare pdz=pdz+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<14.5)
domplac (-7,4,pdz,90)
#declare pdz=pdz+1;
#end

//mur de droite
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<7.25)
domplac (6.5,2,pdz,-90)
#declare pdz=pdz+2;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=7.5;
#while (pdz<14)
domplac (6.5,2,pdz,-90)
#declare pdz=pdz+2;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdz=.5;
#while (pdz<14.5)
domplac (6.5,4,pdz,-90)
#declare pdz=pdz+1;
#end

//mur de face
#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<-5)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-4;
#while (pdx<-3)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-2;
#while (pdx<2)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=3;
#while (pdx<4)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end 

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=5;
#while (pdx<7)
domplac (pdx,2,0,0)
#declare pdx=pdx+1;
#end

#declare nba=nba+1;
#declare rsd=seed(nba);
#declare pdx=-7;
#while (pdx<7)
domplac (pdx,4,0,0)
#declare pdx=pdx+1;
#end
}

#declare et=4;
#declare rota=0; 
#while (et<68)   //68
#if (rota=0)
object {etage translate <0,0,-3.5> rotate rota*y translate <0,0,3.5> translate et*y}
#end
#if (rota=180)
object {etage translate <0,0,-3.5> rotate rota*y translate <0,0,11.5> translate et*y}
#end
#declare et=et+4;
#declare rota=rota+180;
#if (rota > 181)
#declare rota=0;
#end
 
#end


//un arbre
#declare rsd=1431;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

#include "arbre.inc"
#declare Arbre =
object{
        #if (leafproba>0)
        #declare Leaf=object{MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
                 ndents,nlobes,alobes,qlobes,ls,ws,as,dofile,ffname)
                 #if (dotexture=false)  // no texture applied to tree segments, so the leaf texture must be used for the individual leaf
                        texture{txtLeaf}
                 #end
        } 
        
        #end              
        MakeTree()
        
        #if (dotexture = true) // texture is already applied to tree so that we can safely apply the leaf texture to the leaves
                texture {txtLeaf}
        #else

                texture {txtTree} // apply tree texture  regardless of the tree structure
        #end
}

object {Arbre scale 10 translate <250,0,250>}


// Create an infinite sphere around scene and allow any texture on it
#include "skies.inc"
sky_sphere
{ 
   S_Cloud1

}
 
#declare brique =
union {
//box {<0,0,0.1><1,1,1>}
superellipsoid
{
  <0.2,  // east-west exponent (0.0 ... 1.0)
  0.2,>  // north-south exponent (0.0 ... 1.0)
scale <0.45,0.45,0.45> translate .5
}
}


#declare brique1 =
union{
box {<0,0,0.1><2,1,1>}
superellipsoid
{
  <0.2,  // east-west exponent (0.0 ... 1.0)
  0.2,>  // north-south exponent (0.0 ... 1.0)
scale <.47*2,0.45,0.45> translate <1,.5,.5> 
}                    
}

#declare tex_1=
texture {pigment {color rgb<0.784,0.376,0.137>}}
#declare tex_2=
texture {pigment {color rgb<0.27,0.152,0.27>}}




#declare nx=-10;
#declare ny=0;
#declare nz=500;

#declare fx=100;
#declare fy=5;//attention multiple de 2
#declare fz=0;
//#declare atex=0.6;    
#declare ndx=nx;

    
#declare nb=0;
#declare rsd=seed(1);

#declare mur =
union {
box {<nx,ny,nz+0.1><fx+1,fy+1,nz+1> pigment {color rgb 0.478} }

#while (nb<1)
//#declare rsd=seed(nx);
#declare atex=rand(rsd);

object {brique translate <nx,ny,nz>  
#if (atex < 0.5)
texture {tex_1}}
 #else
 texture {tex_2}}
#end


#if (ny=fy)
 #if (nx=fx)
 #declare nb=1;
 #end
#end

#if (nx=fx)
 #if (ny<fy)
 #declare nx=ndx-1;
 #declare ny=ny+1;
 #end
#end 

#declare nx=nx+1;

#end 
}
object {mur scale <10,10,1>}

#include "city.pov"
     