/****************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File: TG_Globe.pov
 Vers: 3.1
 Desc: Globe City on a distant planet, using Media.
 Date: 06/28/1999    (28.06.1999)
 Auth: Thomas de Groot (t.degroot@inter.nl.net)

 This file was generated for POV-Ray V3.1 by
 Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar

 Scene inspired by the cover from the Science Fiction book:
 "Best SF Stories from New Worlds 3", edited by Michael Moorcock,
 Berkley Medallion Book, New York, 1970.
*****************************************************************/
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <0.310,0.204,0.000> }



#declare Atmosphere = 
   media  // Atmosphere
   {
      samples 20,100
      variance 1.0/1000.0
      ratio 0.999
      scattering
      {
         1 ,  rgb <0.01, 0.01, 0.01> // isotropic scattering
         extinction 0.01
      }
   }

media { Atmosphere }

fog {
  fog_type 1    // Constant
  distance     2000.0
  color <0.952941,0.960784,0.803922,0.8,0.6>
  turbulence   <0.2,0.5,0.8>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.4
}

fog {
  fog_type 2    // Ground Fog
  distance     100.0
  color <0.666667,0.6,0.6,0.6,0.6>
  turbulence   <0.5,0.8,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.4
  up           <0,0,1>
  fog_offset   -1.0
  fog_alt      10.0
}

camera {  //  Camera StdCam
  location  <   -347.954,    -514.090,     130.000>
  direction <        0.0,         0.0,      1.4297> // Aperture is 0.67 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,     130.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <      0.000,       0.000,     281.000> // Attached to Spot1
  direction <        0.0,         0.0,      1.3737> // Aperture is 0.70 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.490,      -0.473,     280.268> // Following Spot1
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spot1
  <0.000, 0.000, 281.000>
  color rgb <1.000, 0.000, 0.000>
  spotlight
    point_at  <0.979, -0.947, 279.536>
    falloff    20.000  // outer radius (in deg)
    radius     10.000  // inner radius
    tightness  0.000
  media_attenuation on
}

light_source {   // Sunlight
  <-8000.000, 4000.000, 3000.000>
  color rgb <1.000, 1.000, 0.857>
  media_interaction off
  media_attenuation on
}


//
// ********  MATERIALS  *******
//

#include "tg_globe.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Strut1 = object {
  cone { // Strut1
    <0,0,0>, 3.0, <0,0,1>, 1.0
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.0, -20.000548, -1.061727>
    scale <-1.0, -0.676274, -116.553185>
    rotate <151.996704, 0.0, 180.0>
    translate  <0.0, 17.0, 100.506739>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
}
#declare Satellite1 = object {
  sphere { // Satellite1
    <0,0,0>,1
    scale 10.0
    translate  -150.0*x
    material {
      Bronze_Metal
      // Transform to world space
      translate  -130.0*z
      rotate 0.0*z rotate 10.0*y rotate 20.0*x
    }
  }
}
#declare Cone1 = object {
  cone { // Cone1
    <0,0,0>, 20.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 15.0>
    translate  <0.0, -150.0, -0.1>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
}
#declare Cone15 = object {
  cone { // Cone15
    <0,0,0>, 20.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 25.0>
    translate  <0.0, -250.0, -0.1>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
}


#declare PlatformPost1 = object {
  cylinder { // PlatformPost1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate 10.0*x
    translate  <0.0, 4.8, 0.2>
  }
}




//
// ********  OBJECTS  *******
//

#declare MainGlobeDif = difference {
  sphere { // MainGlobeOut
    <0,0,0>,1
    scale 100.0
    translate  130.0*z
    material {
      PlexiglasOut
      // Transform to world space
    }
  }
  sphere { // MainGlobeIn
    <0,0,0>,1
    hollow
    scale 98.0
    translate  130.0*z
    material {
      PlexiglasIn
      // Transform to world space
    }
  }
}
#declare Domes = union {
  sphere { // Dome1
    <0,0,0>,1
    material {
      Bronze_Metal
    }
    scale <15.0, 15.0, 20.0>
    translate  <-36.857084, -33.108296, 100.0>
  }
  sphere { // Dome2
    <0,0,0>,1
    material {
      Bronze_Metal
    }
    scale 15.0
    translate  <-57.639207, 4.888386, 100.0>
  }
  sphere { // Dome3
    <0,0,0>,1
    material {
      Bronze_Metal
    }
    scale <15.0, 15.0, 20.0>
    translate  <64.907928, -7.616851, 100.0>
  }
  sphere { // Dome4
    <0,0,0>,1
    material {
      Bronze_Metal
    }
    scale <15.0, 15.0, 38.0>
    translate  <38.354158, -51.385181, 100.0>
  }
  sphere { // Dome5
    <0,0,0>,1
    material {
      Bronze_Metal
    }
    scale <15.0, 15.0, 30.0>
    translate  <-13.691058, 24.127213, 100.0>
  }
  sphere { // Dome6
    <0,0,0>,1
    material {
      Bronze_Metal
    }
    scale <15.0, 15.0, 25.0>
    translate  <34.882536, 56.68677, 100.0>
  }
}
#declare LivingSpace = difference {
  object { Domes }
  box { // Dif
    <-1, -1, -1>, <1, 1, 1>
    material {
      Bronze_Metal
    }
    scale <100.0, 100.0, 20.0>
    translate  80.0*z
  }
}
#declare Struts = union {
  object { Strut1 }
  object { // Strut2->Strut1
    Strut1
    rotate <0.0, -0.0, -30.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Strut3->Strut1
    Strut1
    rotate <0.0, -0.0, -60.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Strut4->Strut1
    Strut1
    rotate <0.0, -0.0, -90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Strut5->Strut1
    Strut1
    rotate <0.0, -0.0, -120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Strut6->Strut1
    Strut1
    rotate <0.0, -0.0, -150.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Strut7->Strut1
    Strut1
    rotate <0.0, -0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Strut8->Strut1
    Strut1
    rotate <0.0, -0.0, 150.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Strut9->Strut1
    Strut1
    rotate <0.0, -0.0, 120.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Strut10->Strut1
    Strut1
    rotate <0.0, -0.0, 90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Strut11->Strut1
    Strut1
    rotate <0.0, -0.0, 60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Strut12->Strut1
    Strut1
    rotate <0.0, -0.0, 30.0>
    translate  <0.0, -0.0, 0.0>
  }
}
#declare Satellites = union {
  object { Satellite1 }
  object { // Satellite2->Satellite1
    Satellite1
    rotate -10.0*z
  }
  object { // Satellite3->Satellite1
    Satellite1
    rotate -20.0*z
    translate  0.0*x
  }
  object { // Satellite4->Satellite1
    Satellite1
    rotate -30.0*z
    translate  0.0*x
  }
  object { // Satellite5->Satellite1
    Satellite1
    rotate -40.0*z
    translate  -0.0*y
  }
  object { // Satellite6->Satellite1
    Satellite1
    rotate -50.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite7->Satellite1
    Satellite1
    rotate -60.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite8->Satellite1
    Satellite1
    rotate -70.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite9->Satellite1
    Satellite1
    rotate -80.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite10->Satellite1
    Satellite1
    rotate -90.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite11->Satellite1
    Satellite1
    rotate -100.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite12->Satellite1
    Satellite1
    rotate -110.0*z
    translate  -0.0*x
  }
  object { // Satellite13->Satellite1
    Satellite1
    rotate -120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Satellite14->Satellite1
    Satellite1
    rotate -130.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Satellite15->Satellite1
    Satellite1
    rotate -140.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Satellite16->Satellite1
    Satellite1
    rotate -150.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Satellite17->Satellite1
    Satellite1
    rotate -160.0*z
    translate  0.0*y
  }
  object { // Satellite18->Satellite1
    Satellite1
    rotate -170.0*z
    translate  0.0*y
  }
  object { // Satellite19->Satellite1
    Satellite1
    rotate 180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Satellite20->Satellite1
    Satellite1
    rotate 170.0*z
    translate  0.0*y
  }
  object { // Satellite21->Satellite1
    Satellite1
    rotate 160.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Satellite22->Satellite1
    Satellite1
    rotate 150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Satellite23->Satellite1
    Satellite1
    rotate 140.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Satellite24->Satellite1
    Satellite1
    rotate 130.0*z
    translate  0.0*x
  }
  object { // Satellite25->Satellite1
    Satellite1
    rotate 120.0*z
    translate  0.0*x
  }
  object { // Satellite26->Satellite1
    Satellite1
    rotate 110.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite27->Satellite1
    Satellite1
    rotate 100.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite28->Satellite1
    Satellite1
    rotate 90.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite29->Satellite1
    Satellite1
    rotate 80.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite30->Satellite1
    Satellite1
    rotate 70.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite31->Satellite1
    Satellite1
    rotate 60.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Satellite32->Satellite1
    Satellite1
    rotate 50.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite33->Satellite1
    Satellite1
    rotate 40.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite34->Satellite1
    Satellite1
    rotate 30.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite35->Satellite1
    Satellite1
    rotate 20.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Satellite36->Satellite1
    Satellite1
    rotate 10.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  rotate <-20.0, -10.0, 0.0>
  translate  130.0*z
}
#declare GlobeCity = union {
  object { MainGlobeDif }
  cylinder { // Floor
    <0,0,1>, <0,0,0>, 1 
    scale <90.0, 90.0, 2.0>
    translate  <-0.028787, 0.0, 100.0>
    material {
      DryGrass
      // Transform to world space
    }
  }
  cone { // CentralAntenna
    <0,0,0>, 5.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 276.0>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
  box { // Dome7
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 15.0>
    translate  <27.267611, 15.148673, 115.0>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
  box { // Dome8
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 10.0>
    translate  <-0.099115, -62.614514, 110.0>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
  box { // Dome9
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 5.0, 10.0>
    translate  <58.376638, 31.307257, 110.0>
    material {
      Bronze_Metal
      // Transform to world space
    }
  }
  object { LivingSpace }
  object { Struts }
  object { Satellites }
  sphere { // Spotlamp
    <0,0,0>,1
    hollow
    scale 5.0
    translate  281.0*z
    material {
      PlexiglasOut
      // Transform to world space
    }
  }
}
#declare GroundCones_InnerCircle = union {
  object { Cone1 }
  object { // Cone2->Cone1
    Cone1
    rotate -25.0*z
  }
  object { // Cone3->Cone1
    Cone1
    rotate -50.0*z
    translate  -0.0*x
  }
  object { // Cone4->Cone1
    Cone1
    rotate -75.0*z
    translate  -0.0*y
  }
  object { // Cone5->Cone1
    Cone1
    rotate -100.0*z
    translate  0.0*y
  }
  object { // Cone6->Cone1
    Cone1
    rotate -125.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone7->Cone1
    Cone1
    rotate -150.0*z
    translate  -0.0*x
  }
  object { // Cone8->Cone1
    Cone1
    rotate -175.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone9->Cone1
    Cone1
    rotate 160.0*z
    translate  0.0*x
  }
  object { // Cone10->Cone1
    Cone1
    rotate 135.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone11->Cone1
    Cone1
    rotate 110.0*z
    translate  -0.0*y
  }
  object { // Cone12->Cone1
    Cone1
    rotate 85.0*z
    translate  0.0*y
  }
  object { // Cone13->Cone1
    Cone1
    rotate 60.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone14->Cone1
    Cone1
    rotate 35.0*z
  }
}
#declare GroundCones_OuterCircle = union {
  object { Cone15 }
  object { // Cone16->Cone15
    Cone15
    rotate -25.0*z
  }
  object { // Cone17->Cone15
    Cone15
    rotate -50.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cone18->Cone15
    Cone15
    rotate -75.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cone19->Cone15
    Cone15
    rotate -100.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cone20->Cone15
    Cone15
    rotate -125.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone21->Cone15
    Cone15
    rotate -150.0*z
    translate  -0.0*x
  }
  object { // Cone22->Cone15
    Cone15
    rotate -175.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone23->Cone15
    Cone15
    rotate 160.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone24->Cone15
    Cone15
    rotate 135.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone25->Cone15
    Cone15
    rotate 110.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone26->Cone15
    Cone15
    rotate 85.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone27->Cone15
    Cone15
    rotate 60.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone28->Cone15
    Cone15
    rotate 35.0*z
    translate  <0.0, -0.0, 0.0>
  }
}
union { // GlobalCity
  object { GlobeCity }
  object { GroundCones_InnerCircle }
  object { GroundCones_OuterCircle }
}


#declare LeftFoot = union {
  sphere { // LeftAnkle
    <0,0,0>,1
    // All transformations fixed
    scale 0.2
    translate  <0.4, 0.0, -0.879902>
  }
  superellipsoid { // LeftHeel
    <0.1, 0.5>
    // All transformations fixed
    scale <0.2, 0.3, 0.15>
    translate  <0.4, -0.087572, -1.027955>
  }
  superellipsoid { // LeftMiddleFoot
    <0.1, 0.5>
    // All transformations fixed
    scale <0.18, 0.3, 0.11>
    rotate 10.0*x
    translate  <0.4, -0.424898, -1.04076>
  }
  superellipsoid { // LeftToes
    <0.1, 0.5>
    rotate <0.0, 0.0, -0.0>
    translate  <-0.016327, -0.50164, 0.073657>
    // Scaling fixed
    // Rot X limited (-60.0 to     0.0)
    // Translation fixed
    scale <0.16, 0.2, 0.08>
    rotate 5.0*z
    translate  <0.393858, -0.605363, -1.102191>
  }
  translate  <-0.399221, 0.0, 0.866002>
  // Scaling fixed
  // Rot X limited (-20.0 to   30.0)
  // Translation fixed
  translate  <0.399221, 0.0, -0.866002>
}
#declare LeftLowerLeg = union {
  sphere { // LeftKnee
    <0,0,0>,1
    // All transformations fixed
    scale 0.25
    translate  <0.4, 0.0, 0.925618>
  }
  superellipsoid { // LeftCalf
    <1.0, 0.5>
    // All transformations fixed
    scale <0.25, 0.3, 0.9>
    translate  <0.4, 0.0, 0.02687>
  }
  object { LeftFoot }
  translate  <-0.401108, 0.0, -0.914494>
  // Scaling fixed
  // Rot X limited (0.0 to   90.0)
  // Translation fixed
  rotate 33.854935*x
  translate  <0.401108, 0.0, 0.914494>
}
#declare LeftLeg = union {
  superellipsoid { // LeftThigh
    <1.0, 0.5>
    // All transformations fixed
    scale <0.3, 0.3, 1.2>
    translate  <0.4, 0.0, 2.078793>
  }
  object { LeftLowerLeg }
  translate  <-0.39984, 0.0, -3.187908>
  // Scaling fixed
  // Rot X limited (-90.0 to   20.0)
  // Translation fixed
  rotate -32.490852*x
  translate  <0.39984, 0.0, 3.187908>
}
#declare RightFoot = union {
  sphere { // RightAnkle
    <0,0,0>,1
    // All transformations fixed
    scale 0.2
    translate  <0.4, 0.0, -0.879902>
  }
  superellipsoid { // RightHeel
    <0.1, 0.5>
    // All transformations fixed
    scale <0.2, 0.3, 0.15>
    translate  <0.4, -0.087572, -1.027955>
  }
  superellipsoid { // RightMiddleFoot
    <0.1, 0.5>
    // All transformations fixed
    scale <0.18, 0.3, 0.11>
    rotate 10.0*x
    translate  <0.4, -0.424898, -1.04076>
  }
  superellipsoid { // RightToes
    <0.1, 0.5>
    rotate <0.0, 0.0, -0.0>
    translate  <-0.016327, -0.50164, 0.073657>
    // Scaling fixed
    // Rot X limited (-60.0 to     0.0)
    // Translation fixed
    scale <0.16, 0.2, 0.08>
    rotate 5.0*z
    translate  <0.393858, -0.605363, -1.102191>
  }
  translate  <-0.399221, 0.0, 0.866002>
  // Scaling fixed
  // Rot X limited (-20.0 to   30.0)
  // Translation fixed
  rotate -15.788975*x
  translate  <0.399221, 0.0, -0.866002>
}
#declare RightLowerLeg = union {
  sphere { // RightKnee
    <0,0,0>,1
    // All transformations fixed
    scale 0.25
    translate  <0.4, 0.0, 0.925618>
  }
  superellipsoid { // RightCalf
    <1.0, 0.5>
    // All transformations fixed
    scale <0.25, 0.3, 0.9>
    translate  <0.4, 0.0, 0.02687>
  }
  object { RightFoot }
  translate  <-0.401108, 0.0, -0.914494>
  // Scaling fixed
  // Rot X limited (0.0 to   90.0)
  // Translation fixed
  rotate 8.302689*x
  translate  <0.401108, 0.0, 0.914494>
}
#declare RightLeg = union {
  superellipsoid { // RightThigh
    <1.0, 0.5>
    // All transformations fixed
    scale <0.3, 0.3, 1.2>
    translate  <0.4, 0.0, 2.078793>
  }
  object { RightLowerLeg }
  translate  <-0.39984, 0.0, -3.187908>
  // Scaling fixed
  // Rot X limited (-90.0 to   20.0)
  // Translation fixed
  rotate 4.00625*x
  translate  <-0.4, 0.0, 3.187908>
}
#declare LowerBody = union {
  superellipsoid { // Hips
    <1.0, 0.5>
    // All transformations fixed
    scale <0.7, 0.5, 0.7>
    rotate 10.0*x
    translate  3.7*z
  }
  object { LeftLeg }
  object { RightLeg }
  translate  <-0.003574, 0.0, -4.275159>
  // Scaling fixed
  // Rot Z limited (-20.0 to   20.0)
  // Translation fixed
  translate  <0.003574, 0.0, 4.275159>
}
#declare JawIntersection = intersection {
  cylinder { // Jaw
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.4, 0.45, 0.4>
    translate  6.1*z
  }
  cylinder { // Jaw1
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.4, 0.4, 0.5>
    rotate 10.0*x
    translate  <0.0, -0.1, 6.1>
  }
  // All transformations fixed
}
#declare HeadVert = union {
  sphere { // Cranium
    <0,0,0>,1
    // All transformations fixed
    scale <0.4, 0.45, 0.5>
    translate  6.5*z
  }
  object { JawIntersection }
  cone { // Nose
    <0,0,0>, 0.0, <0,0,1>, 0.1
    // All transformations fixed
    scale <1.0, 1.0, 0.25>
    rotate <5.0, -180.0, 0.0>
    translate  <0.0, -0.44, 6.6>
  }
  translate  <0.030137, -0.056092, -6.098299>
  // Scaling fixed
  // Rot X limited (-20.0 to   40.0)
  // Translation fixed
  translate  <-0.030137, 0.056092, 6.098299>
}
#declare HeadHor = union {
  object { HeadVert }
  rotate <0.0, -0.0, -0.0>
  // Scaling fixed
  // Rot Z limited (-55.0 to   110.0)
  // Translation fixed
  rotate 27.0*z
  translate  <0.007734, 0.004155, 0.0>
}
#declare NeckAndHead = union {
  cylinder { // Neck
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -24.507715>
    translate  <-0.0, -0.0, 0.0>
    no_shadow
    // All transformations fixed
    scale <0.2, 0.2, 0.6>
    rotate <0.0, -0.0, 24.507715>
    translate  <-0.048233, 0.06948, 5.613586>
  }
  object { HeadHor }
  rotate <0.0, -0.0, -27.9543>
  translate  <0.0, -0.0, 0.0>
  rotate <0.0, 0.0, -0.294366>
  translate  <-0.000462, 0.090701, -4.27139>
}
#declare RightHand = union {
  sphere { // RightWrist
    <0,0,0>,1
    // All transformations fixed
    scale 0.1
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.902017, 0.0, 2.957697>
  }
  cylinder { // RightPalm
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.15, 0.19, 0.09>
    rotate <90.0, 0.0, -90.0>
    translate  <-0.857498, -0.0, 2.735664>
  }
  cylinder { // RightFingers
    <0,0,1>, <0,0,0>, 1 
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, -0.939872, -0.463919>
    // Scaling fixed
    // Rot X limited (-100.0 to     45.0)
    // Translation fixed
    scale <0.14, 0.18, 0.05>
    rotate <-73.298698, -180.0, 90.0>
    translate  <-0.905365, 0.0, 2.595469>
  }
  translate  <0.903206, -0.0, -2.952686>
  // Scaling fixed
  // Rot Y limited (-80.0 to   10.0)
  // Translation fixed
  rotate -12.717326*y
  translate  <-0.903206, 0.0, 2.952686>
}
#declare RightLowerArm = union {
  sphere { // RightElbow
    <0,0,0>,1
    // All transformations fixed
    scale 0.16
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.899762, 0.0, 4.157498>
  }
  superellipsoid { // LowerArm1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    translate  <-0.901889, 0.0, 3.565216>
  }
  object { RightHand }
  rotate <0.0, -0.0, 0.0>
  translate  <0.901646, -0.0, -4.156718>
  // Scaling fixed
  // Rot X limited (-140.0 to   0.0)
  // Translation fixed
  rotate <-11.55164, -0.0, -0.0>
  translate  <-1.781549, 0.0, 9.743965>
}
#declare RightArmWave = union {
  superellipsoid { // UpperArm1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    rotate <0.0, -0.0, -0.0>
    translate  <-1.782067, 0.0, 10.331356>
  }
  object { RightLowerArm }
  rotate <0.0, 0.0, 0.0>
  translate  <1.778854, -0.0, -11.129205>
  // Scaling fixed
  // Rot Y limited (0.0 to   90.0)
  // Translation fixed
  rotate <0.0, 11.119993, -0.0>
  translate  <-0.890398, 0.032979, 5.47792>
}
#declare RightArmSwing = union {
  object { RightArmWave }
  rotate <-0.0, -0.0, 0.0>
  translate  <0.889929, -0.0, -5.479229>
  // Scaling fixed
  // Rot X limited (-180.0 to   50.0)
  // Translation fixed
  rotate <-103.702148, 0.0, 0.0>
  translate  <-0.890852, 0.114262, 1.115247>
}
#declare LeftHand = union {
  sphere { // LeftWrist
    <0,0,0>,1
    // All transformations fixed
    scale 0.1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.89914, 0.0, 3.042082>
  }
  cylinder { // LeftPalm
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.15, 0.19, 0.09>
    rotate <90.0, 0.0, -90.0>
    translate  <0.943532, 0.0, 2.833366>
  }
  cylinder { // LeftFingers
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  <-0.0, -0.895083, -0.400993>
    // Scaling fixed
    // Rot X limited (-45.0 to     100.0)
    // Translation fixed
    scale <0.14, 0.18, 0.05>
    rotate <90.0, 0.0, -90.0>
    translate  <0.913132, -0.0, 2.653577>
  }
  translate  <-0.899236, 0.0, -3.040689>
  // Scaling fixed
  // Rot Y limited (-10.0 to   90.0)
  // Translation fixed
  translate  <0.899236, -0.0, 3.033504>
}
#declare LeftLowerArm = union {
  sphere { // LeftElbow
    <0,0,0>,1
    // All transformations fixed
    scale 0.16
    rotate <-0.0, 0.0, -0.0>
    translate  <0.899086, 0.0, 4.222453>
  }
  superellipsoid { // LowerArm2
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    translate  <0.898761, 0.0, 3.627029>
  }
  object { LeftHand }
  rotate 0.0*x
  translate  <-0.901191, 0.0, -4.225013>
  // Scaling fixed
  // Rot X limited (-140.0 to   0.0)
  // Translation fixed
  rotate <-11.191736, 0.0, 0.0>
  translate  <0.901191, -0.0, 4.225013>
}
#declare LeftArmWave = union {
  superellipsoid { // UpperArm2
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    translate  <0.9, -0.0, 4.821486>
  }
  object { LeftLowerArm }
  rotate <0.0, 0.0, 0.0>
  translate  <-0.903978, -0.0, -5.600276>
  // Scaling fixed
  // Rot Y limited (-180.0 to   -0.0)
  // Translation fixed
  rotate <-0.0, -9.690302, -0.0>
  translate  <0.899851, 0.032979, 5.481104>
}
#declare LeftArmSwing = union {
  object { LeftArmWave }
  rotate <0.0, -0.0, 0.0>
  translate  <-0.899956, -0.0, -5.481007>
  // Scaling fixed
  // Rot X limited (-180.0 to   50.0)
  // Translation fixed
  rotate <18.982725, 0.0, 0.0>
  translate  <0.899033, 0.114262, 1.117025>
}
#declare ChestRotation = union {
  superellipsoid { // Chest
    <1.0, 0.5>
    // All transformations fixed
    scale <0.7, 0.5, 0.9>
    rotate <-5.0, 0.0, 0.0>
    translate  <-0.000462, 0.090701, 0.62861>
  }
  sphere { // LeftShoulder
    <0,0,0>,1
    // All transformations fixed
    scale <0.4, 0.3, 0.3>
    rotate <-0.1215, 8.654, 0.0>
    translate  <0.74, 0.14, 1.07>
  }
  object { NeckAndHead }
  object { RightArmSwing }
  object { LeftArmSwing }
  sphere { // RightShoulder
    <0,0,0>,1
    // All transformations fixed
    scale <0.4, 0.3, 0.3>
    rotate <0.121593, -8.65408, 0.0>
    translate  <-0.74, 0.14, 1.07>
  }
  rotate -0.0*x
  translate  <-0.00843, -0.081276, 0.209661>
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate <-0.0, 0.0, 13.063303>
  translate  <0.002045, -0.133105, 4.269532>
}
#declare UpperBodySideways = union {
  object { ChestRotation }
  rotate <0.0, -0.0, -0.0>
  translate  <0.0, 0.06714, -4.27676>
  // Scaling fixed
  // Rot Y limited (-20.0 to   20.0)
  // Translation fixed
  rotate 0.583192*y
  translate  <0.011434, 0.0, 4.280722>
}
#declare UpperBodyBending = union {
  object { UpperBodySideways }
  translate  <0.0, 0.067143, -4.276763>
  // Scaling fixed
  // Rot X limited (-20.0 to   90.0)
  // Translation fixed
  rotate -2.768118*x
  translate  <0.0, -0.067143, 4.276763>
}
#declare Middle = union {
  sphere { // MiddleJoint
    <0,0,0>,1
    // All transformations fixed
    scale 0.45
    translate  <0.0, -0.1, 4.25>
  }
  object { LowerBody }
  object { UpperBodyBending }
}
#declare Male = union {
  object { Middle }
  scale 0.22
  rotate 137.359177*z
  translate  <-344.974238, -504.543333, 128.0>
  material {
    Flesh
    // Transform to world space
  }
}
#declare LeftFoot1 = union {
  sphere { // LeftAnkle1
    <0,0,0>,1
    // All transformations fixed
    scale 0.2
    translate  <0.4, 0.0, -0.879902>
  }
  superellipsoid { // LeftHeel1
    <0.1, 0.5>
    // All transformations fixed
    scale <0.2, 0.3, 0.15>
    translate  <0.4, -0.087572, -1.027955>
  }
  superellipsoid { // LeftMiddleFoot1
    <0.1, 0.5>
    // All transformations fixed
    scale <0.18, 0.3, 0.11>
    rotate 10.0*x
    translate  <0.4, -0.424898, -1.04076>
  }
  superellipsoid { // LeftToes1
    <0.1, 0.5>
    rotate <0.0, 0.0, -0.0>
    translate  <-0.016327, -0.50164, 0.073657>
    // Scaling fixed
    // Rot X limited (-60.0 to     0.0)
    // Translation fixed
    scale <0.16, 0.2, 0.08>
    rotate <-22.142523, 0.0, 5.0>
    translate  <0.393858, -0.605363, -1.102191>
  }
  translate  <-0.399221, 0.0, 0.866002>
  // Scaling fixed
  // Rot X limited (-20.0 to   30.0)
  // Translation fixed
  translate  <0.399221, 0.0, -0.866002>
}
#declare LeftLowerLeg1 = union {
  sphere { // LeftKnee1
    <0,0,0>,1
    // All transformations fixed
    scale 0.25
    translate  <0.4, 0.0, 0.925618>
  }
  superellipsoid { // LeftCalf1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.25, 0.3, 0.9>
    translate  <0.4, 0.0, 0.02687>
  }
  object { LeftFoot1 }
  translate  <-0.401108, 0.0, -0.914494>
  // Scaling fixed
  // Rot X limited (0.0 to   90.0)
  // Translation fixed
  rotate 17.28581*x
  translate  <0.401108, 0.0, 0.914494>
}
#declare LeftLeg1 = union {
  superellipsoid { // LeftThigh1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.3, 0.3, 1.2>
    translate  <0.4, 0.0, 2.078793>
  }
  object { LeftLowerLeg1 }
  translate  <-0.39984, 0.0, -3.187908>
  // Scaling fixed
  // Rot X limited (-90.0 to   20.0)
  // Translation fixed
  rotate 3.131028*x
  translate  <0.39984, 0.0, 3.187908>
}
#declare RightFoot1 = union {
  sphere { // RightAnkle1
    <0,0,0>,1
    // All transformations fixed
    scale 0.2
    translate  <0.4, 0.0, -0.879902>
  }
  superellipsoid { // RightHeel1
    <0.1, 0.5>
    // All transformations fixed
    scale <0.2, 0.3, 0.15>
    translate  <0.4, -0.087572, -1.027955>
  }
  superellipsoid { // RightMiddleFoot1
    <0.1, 0.5>
    // All transformations fixed
    scale <0.18, 0.3, 0.11>
    rotate 10.0*x
    translate  <0.4, -0.424898, -1.04076>
  }
  superellipsoid { // RightToes1
    <0.1, 0.5>
    rotate <0.0, 0.0, -0.0>
    translate  <-0.016327, -0.50164, 0.073657>
    // Scaling fixed
    // Rot X limited (-60.0 to     0.0)
    // Translation fixed
    scale <0.16, 0.2, 0.08>
    rotate 5.0*z
    translate  <0.393858, -0.605363, -1.102191>
  }
  translate  <-0.399221, 0.0, 0.866002>
  // Scaling fixed
  // Rot X limited (-20.0 to   30.0)
  // Translation fixed
  rotate -15.788975*x
  translate  <0.399221, 0.0, -0.866002>
}
#declare RightLowerLeg1 = union {
  sphere { // RightKnee1
    <0,0,0>,1
    // All transformations fixed
    scale 0.25
    translate  <0.4, 0.0, 0.925618>
  }
  superellipsoid { // RightCalf1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.25, 0.3, 0.9>
    translate  <0.4, 0.0, 0.02687>
  }
  object { RightFoot1 }
  translate  <-0.401108, 0.0, -0.914494>
  // Scaling fixed
  // Rot X limited (0.0 to   90.0)
  // Translation fixed
  rotate 8.302689*x
  translate  <0.401108, 0.0, 0.914494>
}
#declare RightLeg1 = union {
  superellipsoid { // RightThigh1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.3, 0.3, 1.2>
    translate  <0.4, 0.0, 2.078793>
  }
  object { RightLowerLeg1 }
  translate  <-0.39984, 0.0, -3.187908>
  // Scaling fixed
  // Rot X limited (-90.0 to   20.0)
  // Translation fixed
  rotate -13.46356*x
  translate  <-0.4, 0.0, 3.187908>
}
#declare LowerBody1 = union {
  superellipsoid { // Hips1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.7, 0.5, 0.7>
    rotate 10.0*x
    translate  3.7*z
  }
  object { LeftLeg1 }
  object { RightLeg1 }
  translate  <-0.003574, 0.0, -4.275159>
  // Scaling fixed
  // Rot Z limited (-20.0 to   20.0)
  // Translation fixed
  translate  <0.003574, 0.0, 4.275159>
}
#declare JawIntersection1 = intersection {
  cylinder { // Jaw2
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.4, 0.45, 0.4>
    translate  6.1*z
  }
  cylinder { // Jaw3
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.4, 0.4, 0.5>
    rotate 10.0*x
    translate  <0.0, -0.1, 6.1>
  }
  // All transformations fixed
}
#declare HeadVert1 = union {
  sphere { // Cranium1
    <0,0,0>,1
    // All transformations fixed
    scale <0.4, 0.45, 0.5>
    translate  6.5*z
  }
  object { JawIntersection1 }
  cone { // Nose1
    <0,0,0>, 0.0, <0,0,1>, 0.1
    // All transformations fixed
    scale <1.0, 1.0, 0.25>
    rotate <5.0, -180.0, 0.0>
    translate  <0.0, -0.44, 6.6>
  }
  translate  <0.030137, -0.056092, -6.098299>
  // Scaling fixed
  // Rot X limited (-20.0 to   40.0)
  // Translation fixed
  translate  <-0.030137, 0.056092, 6.098299>
}
#declare HeadHor1 = union {
  object { HeadVert1 }
  rotate <0.0, -0.0, -0.0>
  // Scaling fixed
  // Rot Z limited (-55.0 to   110.0)
  // Translation fixed
  rotate 27.0*z
  translate  <0.007734, 0.004155, 0.0>
}
#declare NeckAndHead1 = union {
  cylinder { // Neck1
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -24.507715>
    translate  <-0.0, -0.0, 0.0>
    no_shadow
    // All transformations fixed
    scale <0.2, 0.2, 0.6>
    rotate <0.0, -0.0, 24.507715>
    translate  <-0.048233, 0.06948, 5.613586>
  }
  object { HeadHor1 }
  rotate <0.0, -0.0, -27.9543>
  translate  <0.0, -0.0, 0.0>
  rotate <0.0, 0.0, -0.294366>
  translate  <-0.000462, 0.090701, -4.27139>
}
#declare RightHand1 = union {
  sphere { // RightWrist1
    <0,0,0>,1
    // All transformations fixed
    scale 0.1
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.902017, 0.0, 2.957697>
  }
  cylinder { // RightPalm1
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.15, 0.19, 0.09>
    rotate <90.0, 0.0, -90.0>
    translate  <-0.857498, -0.0, 2.735664>
  }
  cylinder { // RightFingers1
    <0,0,1>, <0,0,0>, 1 
    rotate <0.0, -0.0, -0.0>
    translate  <-0.0, -0.939872, -0.463919>
    // Scaling fixed
    // Rot X limited (-100.0 to     45.0)
    // Translation fixed
    scale <0.14, 0.18, 0.05>
    rotate <-73.298698, -180.0, 90.0>
    translate  <-0.905365, 0.0, 2.595469>
  }
  translate  <0.903206, -0.0, -2.952686>
  // Scaling fixed
  // Rot Y limited (-80.0 to   10.0)
  // Translation fixed
  rotate -12.717326*y
  translate  <-0.903206, 0.0, 2.952686>
}
#declare RightLowerArm1 = union {
  sphere { // RightElbow1
    <0,0,0>,1
    // All transformations fixed
    scale 0.16
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.899762, 0.0, 4.157498>
  }
  superellipsoid { // LowerArm3
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    translate  <-0.901889, 0.0, 3.565216>
  }
  object { RightHand1 }
  rotate <0.0, -0.0, 0.0>
  translate  <0.901646, -0.0, -4.156718>
  // Scaling fixed
  // Rot X limited (-140.0 to   0.0)
  // Translation fixed
  rotate <-30.22163, -0.0, -0.0>
  translate  <-1.781549, 0.0, 9.743965>
}
#declare RightArmWave1 = union {
  superellipsoid { // UpperArm3
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    rotate <0.0, -0.0, -0.0>
    translate  <-1.782067, 0.0, 10.331356>
  }
  object { RightLowerArm1 }
  rotate <0.0, 0.0, 0.0>
  translate  <1.778854, -0.0, -11.129205>
  // Scaling fixed
  // Rot Y limited (0.0 to   90.0)
  // Translation fixed
  rotate <0.0, 11.119993, -0.0>
  translate  <-0.890398, 0.032979, 5.47792>
}
#declare RightArmSwing1 = union {
  object { RightArmWave1 }
  rotate <-0.0, -0.0, 0.0>
  translate  <0.889929, -0.0, -5.479229>
  // Scaling fixed
  // Rot X limited (-180.0 to   50.0)
  // Translation fixed
  rotate <36.94799, 0.0, 0.0>
  translate  <-0.890852, 0.114262, 1.115247>
}
#declare LeftHand1 = union {
  sphere { // LeftWrist1
    <0,0,0>,1
    // All transformations fixed
    scale 0.1
    rotate <-0.0, 0.0, -0.0>
    translate  <0.89914, 0.0, 3.042082>
  }
  cylinder { // LeftPalm1
    <0,0,1>, <0,0,0>, 1 
    // All transformations fixed
    scale <0.15, 0.19, 0.09>
    rotate <90.0, 0.0, -90.0>
    translate  <0.943532, 0.0, 2.833366>
  }
  cylinder { // LeftFingers1
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, 0.0>
    translate  <-0.0, -0.895083, -0.400993>
    // Scaling fixed
    // Rot X limited (-45.0 to     100.0)
    // Translation fixed
    scale <0.14, 0.18, 0.05>
    rotate <90.0, 0.0, -90.0>
    translate  <0.913132, -0.0, 2.653577>
  }
  translate  <-0.899236, 0.0, -3.040689>
  // Scaling fixed
  // Rot Y limited (-10.0 to   90.0)
  // Translation fixed
  translate  <0.899236, -0.0, 3.033504>
}
#declare LeftLowerArm1 = union {
  sphere { // LeftElbow1
    <0,0,0>,1
    // All transformations fixed
    scale 0.16
    rotate <-0.0, 0.0, -0.0>
    translate  <0.899086, 0.0, 4.222453>
  }
  superellipsoid { // LowerArm4
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    translate  <0.898761, 0.0, 3.627029>
  }
  object { LeftHand1 }
  rotate 0.0*x
  translate  <-0.901191, 0.0, -4.225013>
  // Scaling fixed
  // Rot X limited (-140.0 to   0.0)
  // Translation fixed
  rotate <-11.191736, 0.0, 0.0>
  translate  <0.901191, -0.0, 4.225013>
}
#declare LeftArmWave1 = union {
  superellipsoid { // UpperArm4
    <1.0, 0.5>
    // All transformations fixed
    scale <0.18, 0.18, 0.6>
    translate  <0.9, -0.0, 4.821486>
  }
  object { LeftLowerArm1 }
  rotate <0.0, 0.0, 0.0>
  translate  <-0.903978, -0.0, -5.600276>
  // Scaling fixed
  // Rot Y limited (-180.0 to   -0.0)
  // Translation fixed
  rotate <-0.0, -9.690302, -0.0>
  translate  <0.899851, 0.032979, 5.481104>
}
#declare LeftArmSwing1 = union {
  object { LeftArmWave1 }
  rotate <0.0, -0.0, 0.0>
  translate  <-0.899956, -0.0, -5.481007>
  // Scaling fixed
  // Rot X limited (-180.0 to   50.0)
  // Translation fixed
  rotate <-14.024788, 0.0, 0.0>
  translate  <0.899033, 0.114262, 1.117025>
}
#declare ChestRotation1 = union {
  superellipsoid { // Chest1
    <1.0, 0.5>
    // All transformations fixed
    scale <0.7, 0.5, 0.9>
    rotate <-5.0, 0.0, 0.0>
    translate  <-0.000462, 0.090701, 0.62861>
  }
  sphere { // LeftShoulder1
    <0,0,0>,1
    // All transformations fixed
    scale <0.4, 0.3, 0.3>
    rotate <-0.1215, 8.654, 0.0>
    translate  <0.74, 0.14, 1.07>
  }
  object { NeckAndHead1 }
  object { RightArmSwing1 }
  object { LeftArmSwing1 }
  sphere { // RightShoulder1
    <0,0,0>,1
    // All transformations fixed
    scale <0.4, 0.3, 0.3>
    rotate <0.121593, -8.65408, 0.0>
    translate  <-0.74, 0.14, 1.07>
  }
  rotate -0.0*x
  translate  <-0.00843, -0.081276, 0.209661>
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate <-0.0, 0.0, 13.063303>
  translate  <0.002045, -0.133105, 4.269532>
}
#declare UpperBodySideways1 = union {
  object { ChestRotation1 }
  rotate <0.0, -0.0, -0.0>
  translate  <0.0, 0.06714, -4.27676>
  // Scaling fixed
  // Rot Y limited (-20.0 to   20.0)
  // Translation fixed
  rotate 0.583192*y
  translate  <0.011434, 0.0, 4.280722>
}
#declare UpperBodyBending1 = union {
  object { UpperBodySideways1 }
  translate  <0.0, 0.067143, -4.276763>
  // Scaling fixed
  // Rot X limited (-20.0 to   90.0)
  // Translation fixed
  rotate -2.768118*x
  translate  <0.0, -0.067143, 4.276763>
}
#declare Middle1 = union {
  sphere { // MiddleJoint1
    <0,0,0>,1
    // All transformations fixed
    scale 0.45
    translate  <0.0, -0.1, 4.25>
  }
  object { LowerBody1 }
  object { UpperBodyBending1 }
}
#declare Male1 = union {
  object { Middle1 }
  scale 0.22
  rotate 120.684624*z
  translate  <-345.970873, -504.98306, 128.041039>
  material {
    Flesh
    // Transform to world space
  }
}
#declare Posts = union {
  object { PlatformPost1 }
  object { // PlatformPost2->PlatformPost1
    PlatformPost1
    rotate -20.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // PlatformPost3->PlatformPost1
    PlatformPost1
    rotate -40.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // PlatformPost4->PlatformPost1
    PlatformPost1
    rotate -60.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // PlatformPost5->PlatformPost1
    PlatformPost1
    rotate -80.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // PlatformPost6->PlatformPost1
    PlatformPost1
    rotate -100.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // PlatformPost7->PlatformPost1
    PlatformPost1
    rotate -120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost8->PlatformPost1
    PlatformPost1
    rotate -140.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // PlatformPost9->PlatformPost1
    PlatformPost1
    rotate -160.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // PlatformPost10->PlatformPost1
    PlatformPost1
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost11->PlatformPost1
    PlatformPost1
    rotate 160.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost12->PlatformPost1
    PlatformPost1
    rotate 140.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost13->PlatformPost1
    PlatformPost1
    rotate 120.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost14->PlatformPost1
    PlatformPost1
    rotate 100.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost15->PlatformPost1
    PlatformPost1
    rotate 80.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // PlatformPost16->PlatformPost1
    PlatformPost1
    rotate 60.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // PlatformPost17->PlatformPost1
    PlatformPost1
    rotate 40.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // PlatformPost18->PlatformPost1
    PlatformPost1
    rotate 20.0*z
    translate  <0.0, -0.0, 0.0>
  }
  rotate <0.0, -0.0, -0.0>
}
#declare ViewingPlatform = union {
  torus { // Handrail
    4.628, 0.05  rotate -x*90
    rotate <0.0, -0.0, -0.0>
    translate  1.2*z
  }
  cylinder { // Platform
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 0.3>
    rotate <0.0, -0.0, -0.0>
  }
  object { Posts }
  translate  <-348.73703, -505.54, 127.45678>
  material {
    Bronze_Metal
    // Transform to world space
  }
}
union { // Gazebo
  object { Male }
  object { Male1 }
  object { ViewingPlatform }
}


object {   // Landscape
  height_field {
    gif "C:\tg_globe.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    OldRedSandstone
  }
  scale <3000.0, 3000.0, 250.0>
  translate  250.0*z
}


union { // Moons
  sphere { // Moon1
    <0,0,0>,1
    material {
      Asteroid
    }
    scale 400.0
    translate  <3300.0, 3500.0, 1500.0>
  }
  sphere { // Moon2
    <0,0,0>,1
    material {
      Asteroid
    }
    scale 200.0
    translate  <1000.0, 3500.0, 900.0>
  }
  sphere { // Moon3
    <0,0,0>,1
    material {
      Asteroid
    }
    scale 350.0
    translate  <5800.0, 4300.0, 1100.0>
  }
}




difference { // Sky
  sphere { // SkyOut
    <0,0,0>,1
    material {
      Summer_Sky
    }
  }
  sphere { // SkyIN
    <0,0,0>,1
    material {
      Summer_Sky
    }
    scale 0.98
  }
  no_shadow
  scale <3000.0, 3000.0, 500.0>
}


