#declare Switch_Radiosity 	= on; 
#declare Switch_Figures		= on;
#declare Switch_Woman		= on;
#declare Switch_Man			= on; 
#declare Switch_City		= on; 
#declare Switch_Water		= on;
#declare Switch_Beach		= on; 
#declare Switch_Rubble		= on; 
#declare Switch_Liberty		= on;


#include "colors.inc"
#include "woods.inc"
#include "textures.inc" 

#include "T_Land.inc"

camera {
	location <0,.35,-1>
	look_at  <0,.35,0>
}

	#if (Switch_Radiosity = on)
#include "consts.inc"
	#declare Rad_Quality = Radiosity_Final;
	#include "rad_def.inc"
#end


light_source {<0,.35,-1> color Gray30 shadowless}

#include "13sky.inc"

#if (Switch_Water = on)
	plane {y,-.075 texture{T_Water1 scale <2,.05,1> }} 
	plane {y,-.1 texture{T_Water1 scale <2,.05,1> }}  
	plane {y,-2.5 texture{T_Sand3 scale .05}}
#end

#if (Switch_Liberty = on)

#include "liberty2.inc"
object {Liberty2 texture{T_Lib2 scale <.5,1.5,.5>} scale .2 rotate <35,0,0> translate <-2.5,-12,3>}     

#end

#if (Switch_Figures = on)

#if (Switch_Man = on)

#declare Man =
union {
	#include "man.inc"
}
object {Man rotate <0,180,0> rotate <0,0,-4> translate <0,-.055,0> finish {phong .5 phong_size 10}} 

#end

#if (Switch_Woman = on)

#declare Woman =
union {
	#include "woman.inc"
}
object {Woman rotate <0,180,0> translate <-.1,0,.1> finish {phong .5 phong_size 10}} 

#include "loin.inc" 
object {Loin rotate <0,180,0> translate <-.1,0,.1>
	texture {pigment {
		crackle
		color_map {
			[0.0 rgb <.8,.6,.4>]
			[1.0 rgb <.7,.4,.2>]
		}
		turbulence .5
		scale .01
	}}
	finish {phong .2 phong_size 10}
	normal {wrinkles .75 scale .01}
} 

#end

#else 

#include "man1.inc"
#include "woman1.inc" 

object {Man rotate <0,180,0> pigment{White} finish {phong .5 phong_size 10}} 
object {Woman rotate <0,180,0> translate <-.1,0,.1> pigment{White} finish {phong .5 phong_size 10}} 

#end

// *****************
// THE BEACH
// *****************

#if (Switch_Beach = on)
	#include "beach.inc"
#end

#if (Switch_Rubble = on) 
	#include "rubble.inc" 
#end

// *****************
// THE CITY
// *****************

#if (Switch_City = on)

#include "newyork.inc"

object {New_York translate <300,-.075,800>}  

fog {
  fog_type   2
  distance   300
  color      rgbf <.5,.6,.85,.2>
  fog_offset 5
  fog_alt    10
  turbulence 0.8
}

fog {
  fog_type   2
  distance   600
  color      rgbft <.75,.8,.85,.5,.5>
  fog_offset 10
  fog_alt    100
  turbulence 0.8
}

#end



// eof