/*
 * THE SKY MACRO
 * Nathan G B O'Brien
 * no13@no13.net
 * http://www.no13.net
 * July 1999
 */



#include "colors.inc"

/*

camera {
	location <0,0,-5>
	look_at  <0,0,0>
}

*/

light_source {<1500,2500,-2000> color <1,1,1>}


// *******************************

#declare Zenith_Sky  	= <.2,.25,.4>;
#declare Horizon_Sky 	= <.75,.8,.85>;
#declare Cloud_Colour	= <1,1,1>;

#declare Cloud_Type1 	= 4;
#declare Cloud_Density1 = .5;		
#declare Cloud_Scale1	= 5;

#declare Cloud_Type2 	= 0;
#declare Cloud_Density2 = 1;	// distribution density
#declare Cloud_Density3	= 1;	// individual cloud density		 
#declare Cloud_Scale2	= 1;
#declare Cloud_Scale3	= 1;    // sky box scale
#declare Cloud_Elevation= 500; 
#declare Cloud_QUality	= 1;	// 1 = fast

#declare SKY_Rand = 13;

// *******************************

#declare SKYRAND 	= seed(SKY_Rand);
#declare DENSITY1   = (Cloud_Density1 * .5);
#declare DENSITY2   = (DENSITY1 / 5);

#declare SKY_Cloud1 =
pigment {
	gradient y
    color_map {
		[0.0 rgb Horizon_Sky] 
		[0.75 rgb  Zenith_Sky]  
		[1.0 rgb  Zenith_Sky]
	} 
}

#if (Cloud_Type1 > 0)

#declare SKY_Cloud2 =
pigment {                             

	#if (Cloud_Type1 = 1) crackle #end
	#if (Cloud_Type1 = 2) wrinkles #end
	#if (Cloud_Type1 = 3) bozo #end
	#if (Cloud_Type1 = 4) leopard #end
	#if (Cloud_Type1 = 5) granite #end  
	
	turbulence (0.5 + (.3 * rand(SKYRAND)))
    octaves 6
    omega 0.7
    lambda (1.5 + (2 * rand(SKYRAND)))
	color_map {
		[0.0, DENSITY2   	color rgb (Cloud_Colour * 2.5)
                    		color rgb (Cloud_Colour * 2)]
        [DENSITY2,DENSITY1 	color rgb (Cloud_Colour * 2)
                    		color rgb Zenith_Sky]
        [DENSITY1, 1.001 	color rgb Zenith_Sky
                    		color rgb Zenith_Sky]
	}
	scale <6, 1, 6>
	#if (Cloud_Type1 = 5) scale 10 #end 
	scale (rand(SKYRAND) * 2)    
	scale Cloud_Scale1

	translate <(rand(SKYRAND) * 100),(rand(SKYRAND) * 100),(rand(SKYRAND) * 100)> 
	rotate <0,(rand(SKYRAND) * 360),0>

}

#declare SKY_Cloud3 =
pigment {
	gradient y
	pigment_map {
		[0.01 rgb Horizon_Sky]
		[0.35 SKY_Cloud2 scale .05]
		[0.8  SKY_Cloud2 scale .15]
	}
}

#declare SKY_Cloud4 =
pigment {
	average
	pigment_map {
		[2.5 SKY_Cloud1]
		[1 SKY_Cloud3]
	}
}

#end

sky_sphere {
    pigment { 
    	#if (Cloud_Type1 > 0)
       		SKY_Cloud4
       	#else
       		SKY_Cloud1
       	#end
    }
} 


// *****************************

#if (Cloud_Type2 > 0)

#declare DENSITY3   = (Cloud_Density2 * .5);
#declare DENSITY4   = (DENSITY3 / 5);
#declare HAZE = (Zenith_Sky * 2);

fog{fog_type 1 color rgbft <HAZE.x,HAZE.y,HAZE.z,.3,.7> distance 1000}  

#declare SKY_Density =
density {

	#if (Cloud_Type2 = 1) crackle #end
	#if (Cloud_Type2 = 2) wrinkles #end
	#if (Cloud_Type2 = 3) bozo #end
	#if (Cloud_Type2 = 4) leopard #end
	#if (Cloud_Type2 = 5) granite #end  

	turbulence (0.5 + (.3 * rand(SKYRAND)))
    octaves 6
    omega 0.7
    lambda (1.5 + (2 * rand(SKYRAND)))
    
    color_map{
    	[0.0 		Black]
    	[DENSITY3 	Black]
    	[DENSITY4 	Gray30]
    	[1.0 		White]
	}

}

#declare Sample1 	= (Cloud_QUality * 1);
#declare Sample2 	= (Cloud_QUality * 2);
#declare CloudWhite = (.1 * Cloud_Density3);
#declare CloudDark	= (.2 * Cloud_Density3);

#declare SKY_Media =
media {
	scattering {3, CloudWhite extinction CloudDark}
	intervals 3 samples Sample1, Sample2 confidence 0.9999 variance 1/10
	density {SKY_Density}
}

#declare SKY_Box = box {<-1,-0.013,-1>,<1,0.023,1> 
	texture {
		pigment {Clear} 
		finish {ambient 0 diffuse 0}
	}
	interior{
		media{SKY_Media 
			scale 0.2 
			#if (Cloud_Type2 = 5) scale 10 #end 
			scale (rand(SKYRAND) * 2)    

			scale Cloud_Scale2

			translate <(rand(SKYRAND) * 100),0,(rand(SKYRAND) * 100)> 
			rotate <0,(rand(SKYRAND) * 360),0> 
		}
	}
	hollow 
}

object{SKY_Box scale (4500 * Cloud_Scale3) translate <0,Cloud_Elevation,0>}

#end