#include "13rocks.inc"

#declare Rock1  = Rock13 (1,10,13)
#declare Rock2  = Rock13 (1,20,31)
#declare Rock3  = Rock13 (1,30,33)
#declare Rock4  = Rock13 (1,40,11)
#declare Rock5  = Rock13 (1,30,66)
#declare Rock6  = Rock13 (1,20,99)
#declare Rock7  = Rock13 (1,10,15)
#declare Rock8  = Rock13 (1,20,51)
#declare Rock9  = Rock13 (1,30,55)
#declare Rock10 = Rock13 (1,40,43)

#declare RB_Size_Max  = .3;
#declare RB_Size_Min  = .05;
#declare RB_Size_Av	  = .1;	
#declare RB_Plus_Val  = .2; 
#declare RB_Tex_Scale = .05;

// Dark brown and tan swirl granite with gray undertones,
#declare T_Stone2 =
texture {
  pigment
  {
    colour rgb<0.000,0.000,0.000>
  }
}
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgb<0.024, 0.012, 0.012>]
      [0.03 color rgbf<0.851, 0.812, 0.737, 0.231>]
      [0.34 color rgbf<0.788, 0.690, 0.686, 0.835>]
      [0.46 color rgbf<0.627, 0.506, 0.471, 0.608>]
      [0.63 color rgbf<0.851, 0.812, 0.737, 0.922>]
      [0.98 color rgbf<0.643, 0.655, 0.655, 0.278>]
      [1.00 color rgb<0.024, 0.012, 0.012>]
    }
  }
  rotate <0.0, 0.0, 50.0>
  scale <3.0, 6.0, 2.0>
}
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgbf<0.827, 0.627, 0.569, 0.443>]
      [0.18 color rgbf<0.922, 0.827, 0.714, 0.675>]
      [0.36 color rgbf<0.871, 0.702, 0.659, 0.475>]
      [0.52 color rgbf<0.988, 0.922, 0.659, 0.918>]
      [0.73 color rgbf<0.902, 0.812, 0.714, 0.655>]
      [1.00 color rgbf<0.827, 0.627, 0.569, 0.443>]
    }
  }
  rotate <0.0, 0.0, -50.0>
  scale <1.0, 2.0, 1.0>
}


// Peach and yellow marble with white veining.
#declare T_Stone1 =
texture {
  pigment
  {
    granite
    turbulence 0.4
    color_map
    {
      [0.00 color rgb<1.000, 0.718, 0.537>]
      [0.20 color rgb<0.886, 0.651, 0.612>]
      [0.30 color rgb<1.000, 0.820, 0.675>]
      [0.47 color rgb<0.933, 0.725, 0.561>]
      [0.54 color rgb<0.875, 0.604, 0.565>]
      [0.64 color rgb<0.980, 0.776, 0.655>]
      [0.86 color rgb<1.000, 0.863, 0.631>]
      [0.98 color rgb<1.000, 0.765, 0.620>]
      [1.00 color rgb<1.000, 0.718, 0.537>]
    }
  }
  finish {
    ambient 0.2
    diffuse 0.9
  }
  rotate <0.0, 0.0, -30.0>
  scale <1.3, 2.0, 2.0>
}
texture {
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<1.000, 1.000, 1.000>]
      [0.30 color rgb<0.329, 0.329, 0.329>]
      [0.40 color rgb<0.329, 0.329, 0.329>]
      [0.60 color rgb<0.329, 0.329, 0.329>]
      [1.00 color rgb<0.392, 0.392, 0.392>]
    }
  }
  finish {
    ambient 0.2
    diffuse 0.9
  }
  rotate <0.0, 0.0, -30.0>
  scale <2.0, 4.0, 2.0>
}
texture {
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<1.000, 1.000, 1.000>]
      [0.20 color rgbf<1.000, 1.000, 1.000, 0.698>]
      [0.30 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
  }
  rotate <0.0, 0.0, 40.0>
  scale <1.0, 2.0, 1.0>
}


// Medium gray blue marble.
#declare T_Stone3 =
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgb<0.886, 0.882, 0.882>]
      [0.15 color rgb<0.741, 0.741, 0.753>]
      [0.31 color rgb<0.902, 0.902, 0.859>]
      [0.44 color rgb<0.725, 0.706, 0.690>]
      [0.62 color rgb<0.584, 0.588, 0.631>]
      [0.80 color rgb<0.608, 0.616, 0.659>]
      [1.00 color rgb<0.890, 0.882, 0.882>]
    }
  }
  finish {
    ambient 0.2
  }
  rotate <0.0, 0.0, 50.0>
  scale <2.0, 5.0, 2.0>
}
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgbf<0.310, 0.380, 0.420, 0.627>]
      [0.12 color rgbf<0.322, 0.369, 0.416, 0.843>]
      [0.32 color rgbf<0.424, 0.369, 0.420, 0.545>]
      [0.45 color rgbf<0.373, 0.424, 0.518, 0.965>]
      [0.73 color rgbf<0.478, 0.573, 0.529, 0.737>]
      [1.00 color rgbf<0.310, 0.380, 0.420, 0.627>]
    }
  }
  rotate <0.0, 0.0, -30.0>
  scale <1.0, 3.0, 2.0>
}






#macro RUBBLE (LENGTH,WIDTH,QTY,RAND)

	#declare RB_Rand 		= seed(RAND);  
	#declare RB_Rand2 		= seed((RAND * 13));

	#local RB_Dif_Rnge  = (RB_Size_Av - RB_Size_Min);
	#local RB_Dif_Plus  = (RB_Size_Max - RB_Size_Av - RB_Dif_Rnge);
	
	#local Count1 = 0;
	#while (Count1 < QTY) 
	
		#local RB_OriginX = (rand(RB_Rand) * LENGTH);
		#local RB_OriginZ = (rand(RB_Rand) * WIDTH);
		
		#local RB_Sign    = rand(RB_Rand);
		#if (RB_Sign > .5) #local RB_Sign = 1; #else #local RB_Sign = -1; #end
		
		#local RB_Scale   = rand(RB_Rand);
		#local RB_Scale = (RB_Scale * RB_Dif_Rnge * RB_Sign);
		
		#if (RB_Sign = 1)
			#local RB_Plus2	  = rand(RB_Rand);
			#if (RB_Plus2 < RB_Plus_Val)
				#local RB_Plus3 = rand(RB_Rand);
				#local RB_Plus3 = (RB_Plus3 * RB_Dif_Plus);
				#local RB_Scale = (RB_Scale + RB_Plus3);
			#end
		#end      
		
		#local RB_Rock_Type = int(rand(RB_Rand) * 11);
		#if (RB_Rock_Type = 0) #local RB_Rock_Type = 1; #end 
		#if (RB_Rock_Type = 11) #local RB_Rock_Type = 10; #end
		
		object {
		
            #if (RB_Rock_Type = 1) Rock1 #end
            #if (RB_Rock_Type = 2) Rock2 #end
            #if (RB_Rock_Type = 3) Rock3 #end
            #if (RB_Rock_Type = 4) Rock4 #end
            #if (RB_Rock_Type = 5) Rock5 #end
            #if (RB_Rock_Type = 6) Rock6 #end
            #if (RB_Rock_Type = 7) Rock7 #end
            #if (RB_Rock_Type = 8) Rock8 #end
            #if (RB_Rock_Type = 9) Rock9 #end
            #if (RB_Rock_Type = 10) Rock10 #end
	
			scale RB_Scale    
			
			#local RB_Rotate = rand(RB_Rand);
			#if (RB_Rotate < .5) rotate <180,0,0> #end
			
			rotate <0,(rand(RB_Rand) * 360),0>
			translate <RB_OriginX,(RB_Scale / 2),RB_OriginZ>
		    
		    #local RB_Tex_Opt = int(rand(RB_Rand2) * 5);
		    #if (RB_Tex_Opt = 0) #local RB_Tex_Opt = 1; #end
		    #if (RB_Tex_Opt = 5) #local RB_Tex_Opt = 4; #end
		    
		    #if (RB_Tex_Opt = 1) texture{T_Stone2 scale (.5 * RB_Tex_Scale)} #end
			#if (RB_Tex_Opt = 2) texture{T_Stone2 scale (.5 * RB_Tex_Scale)} #end 
			#if (RB_Tex_Opt = 3) texture{T_Stone2 scale (.5 * RB_Tex_Scale)} #end
			#if (RB_Tex_Opt = 4) texture{T_Stone2 scale (.5 * RB_Tex_Scale)} #end
			
			
			finish {phong .3 phong_size 5 reflection .1} 
			normal {crackle .4 scale (.5 * RB_Tex_Scale) turbulence .5 scallop_wave}
			
		}
	
		#local Count1 = (Count1 + 1);
	#end

#end    



object {union {RUBBLE (5,5,500,13)} translate <-2.5,0,0> rotate <0,0,Beach_Slope> translate <0,Beach_Height,0>}    

#declare RB_Size_Max  = .2;
#declare RB_Size_Min  = .03;
#declare RB_Size_Av	  = .09;	
#declare RB_Plus_Val  = .1; 
#declare RB_Tex_Scale = .05; 

object {union {RUBBLE (1,1,150,13)} translate <-1.2,0,0> rotate <0,0,Beach_Slope> translate <0,Beach_Height,-1>} 
object {union {RUBBLE (1,1,100,66)} translate <.2,0,0> rotate <0,0,Beach_Slope> translate <0,Beach_Height,-1>} 

#declare RB_Size_Max  = .6;
#declare RB_Size_Min  = .1;
#declare RB_Size_Av	  = .2;	
#declare RB_Plus_Val  = .2; 
#declare RB_Tex_Scale = .05; 
                                                          
object {union {RUBBLE (2,5,100,13)} scale <1,3,1> translate <-5,.1,4>}
object {union {RUBBLE (2,5,100,31)} scale <1,2,1> translate <-6,.6,4>} 

#declare RB_Size_Max  = .3;
#declare RB_Size_Min  = .05;
#declare RB_Size_Av	  = .1;	
#declare RB_Plus_Val  = .2; 
#declare RB_Tex_Scale = .05;

object {union {RUBBLE (4,5,100,13)} translate <-5,.1,4>} 



// ************** 
// FAR BEACH AREA
// **************

blob {
	threshold .75
	
	cylinder {<-10,2,13><-4,0,13>,2,1}
	sphere   {<-8.5,2,13.5>,1.5,1}    
	sphere   {<-7.5,1.8,13>,.75,1}
	sphere   {<-9,2.2,14>,1.5,1}
	
	texture {
		crackle
		texture_map {
			[0.0 T_Grass1 scale .1]
			[1.0 T_Stone3 scale .1]
		}
		turbulence .5
	}
}  

object {Rock10 translate <-8,1.8,13.5>
	texture{T_Stone2 scale (.5 * RB_Tex_Scale)}
	finish {phong .3 phong_size 5 reflection .1} 
	normal {crackle .4 scale (.5 * RB_Tex_Scale) turbulence .5 scallop_wave}
}

object {Rock4 rotate <0,0,90> scale <.5,.75,.5> translate <-9,2.5,13.5>
	texture{T_Stone2 scale (.5 * RB_Tex_Scale)}
	finish {phong .3 phong_size 5 reflection .1} 
	normal {crackle .4 scale (.5 * RB_Tex_Scale) turbulence .5 scallop_wave}
}

object {Rock10 scale .35 rotate <0,180,0> translate <-9,3.85,13.5>
	texture{T_Stone2 scale (.5 * RB_Tex_Scale)}
	finish {phong .3 phong_size 5 reflection .1} 
	normal {crackle .4 scale (.5 * RB_Tex_Scale) turbulence .5 scallop_wave}
}  

object {Rock10 scale .5 translate <-2,0,8>
	texture{T_Stone2 scale (.5 * RB_Tex_Scale)}
	finish {phong .3 phong_size 5 reflection .1} 
	normal {crackle .4 scale (.5 * RB_Tex_Scale) turbulence .5 scallop_wave}
}

// eof
