// Persistence of Vision Ray Tracer Scene Description File
// File: l_house.pov
// Vers: 3.1
// Desc: Lighthouse for Aug 99 IRTC
// Date: 8/31/99
// Auth: Frank David

#include "Lens2.inc"
#include "sailboat.inc"

camera {
     location <100,750,-600> //final location for camera
     look_at <100,650,-0>
     }

light_source {< 0, 100000, -10000> White shadowless}
light_source {<-3000,80000,80000>  White }
light_source {<1000000,100,8000>  White shadowless}       

//=============My colors/finishes=====================================

#declare Tower = texture {
  pigment { White*.8} //color rgb <1.0,0.72,0.62> }
  normal {
    spotted 6
    turbulence 4
    lambda .3
    scale 0.1
  }
  finish { 
    ambient 0.4
   // phong 0.5
  //  reflection 0.1
  }
}

//glass for top of light house
#declare OldGlass = texture {
  pigment { 
    rgbf <1.0, 1.0, 1.0, 0.98> 
  }
  finish {
    ambient 0
    diffuse 0
    //reflection 0.12
  }
}

//Roof texture
#declare roofcolor = texture {
  pigment { color rgb <0.6550000, 0.350000, 0.1590000>
  }
   normal {
    spotted .52
    turbulence .14
   }
  finish {
   ambient 0
   diffuse 0.20
   specular .5
   roughness .1
   reflection .2
   metallic
   }
  //
 }  

// >>> P_Cloud3 (from File "skies.inc") <<<
#declare P_Cloud3 = pigment {
  bozo
  color_map {
    [0.0, 0.1 color red 0.75 green 0.75 blue 0.75
    color red 0.45 green 0.50 blue 0.55]
    [0.1, 0.5 color red 0.45 green 0.50 blue 0.55
    color rgb <0.084, 0.084, 0.209> ]
    [0.5, 1.001 color rgb <0.084, 0.084, 0.209>
    color rgb <0.0, 0.0, 0.1>]
  }
  turbulence 0.65
  octaves 6
  omega 0.707
  lambda 2
  scale <6, 4, 6>
}

#declare P_Lighthaze = pigment {
  bozo
  turbulence 2
  octaves 6
  omega 0.7
  lambda 2
  color_map {
    [0.0, 0.1 color red 0.50 green 0.50 blue 0.4
    color red 0.55 green 0.55 blue 0.4]
    [0.1, 0.20 color red 0.55 green 0.55 blue 0.45
    color Clear]
    [0.10, 1.001 color Clear
    color Clear]
  }
  scale <6, 1, 6>
}


//================End of my colors=======================
 
plane {<0,1,0>,-100 
    texture {
    pigment {color rgb <0.258824, 0.258824, 0.435294>} 
    finish { 
      ambient 0.1
      diffuse 0
      reflection 0.36 
     }
    normal{  
      bumps 0.25 
      scale 100 }
     }
   }   
 
   
sky_sphere {  
  pigment { P_Cloud3
    scale .11 
    rotate <-15,0,0>
  } 
}

//moon  
sphere {<0,0,0>,1  pigment {
     image_map
     {
       gif "povmoon.gif" 
       map_type 1 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
       once
     
     } // image_map
     }
       finish {
    ambient 1.7
    diffuse 0
     } 
     scale 16000
     rotate <-22.5,240,0> 
     translate <50000,152000,500000>  
     }


     //window sash 
     #declare window = union{
     box{<-18,-30,-2> <-14,30,2> pigment{White*1.2}} //left side
     box{<14,-30,-2> <18,30,2> pigment{White*1.2}} //right side
     box{<-14,26,-2> <14,30,2> pigment{White*1.2}} // top
     box{<-14,-30,-2> <14,-26,2> pigment{White*1.2}} //bottom
     box{<-14,-1,-1> <14,1,1> pigment{White*1.2}} //horizontal mutton
     box{<-1,-26,-1> <1,26,1> pigment{White*1.2}} //vertical mutton
     }


//light house body
#declare house= union{
          cylinder {<0,500,0> <0,510,0>,110 pigment {Black}} //top deck floor
          difference {
               cone {<0,-100,0>,150 <0,500,0>,90 texture {Tower scale 100}}
               //window holes
               box {<-18,-30,-200> <18,50,200> rotate -65*y translate 300*y pigment {Gray95}}
          } 
          
          object {window scale <1,1.2,1> rotate -65*y translate <90,310,-40> }
          
           //top walls
          box{<-30,510,-70> <30,530,-68> pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 45*y pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 90*y pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 135*y pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 180*y pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 225*y pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 270*y pigment {Gray95}}
          box{<-30,510,-70> <30,530,-68> rotate 315*y pigment {Gray95}}
          
           //top glass
          box{<-30,530,-70> <30,610,-68> texture {OldGlass}}
          box{<-30,530,-70> <30,610,-68> rotate 45*y texture {OldGlass}}
          box{<-30,530,-70> <30,610,-68> rotate 90*y texture {OldGlass}}
          box{<-30,530,-70> <30,610,-68> rotate 135*y texture {OldGlass}}
          box{<-30,530,-70> <30,610,-68> rotate 180*y texture {OldGlass}}
        //  box{<-30,530,-70> <30,610,-68> rotate 225*y texture {OldGlass}}   //three removed for
        //  box{<-30,530,-70> <30,610,-68> rotate 270*y texture {OldGlass}}   //clarity of the
        //  box{<-30,530,-70> <30,610,-68> rotate 315*y texture {OldGlass}}   //light beam
         
           //railing at top 
          #declare railing = union {
               torus {108, 1 translate 551*y pigment {Brown}}
               torus {108, 1 translate 538*y pigment {Brown}}
               torus {108, 1 translate 525*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 0*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 40*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 80*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 120*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 160*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 200*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 240*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 280*y pigment {Brown}}
               cylinder {<0,509,-107.5> <0,551,-107.5>,1  rotate 320*y pigment {Brown}}
          }
          object {railing scale <0.95, 1, 0.95>} 
           //roof
          #declare roof= difference {
            box {<-40,0,0> <40,76,1> rotate 65*x texture {roofcolor}}
            box {<-30,0,-1> <30,100,20> rotate 65*x rotate 22.5*y translate -65*x pigment {Black}}
            box {<-30,0,-1> <30,100,20> rotate 65*x rotate -22.5*y translate 65*x pigment {Black}}
           }
            object {roof translate <0,610,-75> rotate 0*y}
            object {roof translate <0,610,-75> rotate 45*y}
            object {roof translate <0,610,-75> rotate 90*y}
            object {roof translate <0,610,-75> rotate 135*y}
            object {roof translate <0,610,-75> rotate 180*y}
            object {roof translate <0,610,-75> rotate 225*y}
            object {roof translate <0,610,-75> rotate 270*y}
            object {roof translate <0,610,-75> rotate 315*y}

           //lighting rod and ball
          cone {<0,640,0>,2.5 <0,700,0>,.1 texture {roofcolor}}
          cylinder {<0,640,0> <0,650,0>,6.7 texture {roofcolor}}
          sphere {<0,652,0>,10 texture {roofcolor}} 
        }  //end of house declare
 
//light beam
cone {<-150,750,-100>,40 <10000000,7580,40000000>,80000 
     pigment {rgbf <1,1,1,.95>}
     finish { 
      ambient 1
      diffuse 0
      phong 1 
      phong_size 50 
      reflection 0.6 
     }
     normal{  
      bumps 0.05 
      scale  1}
     }

//haze around light beam
cone {<-150,750,-100>,45 <10000000,7580,40000000>,160000
     pigment {P_Lighthaze} }
  
#declare shipwreck = difference {
        object {sailboat2 rotate <215,70,120> scale <3,1,2.5> translate <300,-40,1200> }
        box {<350,-200,1050> <550,100,100> pigment{P_WoodGrain12B}}
        }
        
#declare lighthouse = object {house translate 100*y}

height_field
{
  gif "lhland1b.gif"
  texture {
    pigment {
      image_map { gif "lhland1b.gif" map_type 0 interpolate 2 once }
      rotate x*90 // lay X-Y image map down onto X-Z height field plane
    }
  }
scale <100000,700,10000> 
translate <-29500,-180,-3500>
}

object {sailboat rotate -45*y scale 4 translate <2000,-100,3500>}
object {lighthouse  translate <-150,100,-100>}
object {thelens scale 1.5 translate <-150,728,-100> }
object {shipwreck translate <0,-15,-200> }
