#include "colors.inc"
#include "textures.inc"
/* commented out when used as an inc file
camera {
     location <0,100,-400> //final location for camera
     look_at <0, 0,0>
     }

light_source {< 0, 60, -10000> White shadowless}
light_source {<-5000,10000,0>  White shadowless}
background {White}       
  */


//=============My colors/finishes=====================================
   
#declare P_WoodGrain12B = pigment {
  wood
  turbulence <0.1, 0.04, 1>
  scale <0.15, 0.5, 1>
  rotate x*2
}

// >>> P_Cloud1 (from File "skies.inc") <<<
// Constants from file "colors.inc"
#declare Clear = rgbf 1;

#declare P_Cloud1 = pigment {
  bozo
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2
  color_map {
    [0.0, 0.1 color red 0.85 green 0.85 blue 0.85
    color red 0.75 green 0.75 blue 0.75]
    [0.1, 0.5 color red 0.75 green 0.75 blue 0.75
    color Clear]
    [0.5, 1.001 color Clear
    color Clear]
  }
  scale <6, 1, 6>
}


//================End of my colors=======================

//boat
#declare boat = difference {
intersection {
sphere {<-10,0,0>,50  pigment {P_WoodGrain12B rotate 90*z translate 10*y scale 20}}
sphere {<10,0,0>,50  pigment {P_WoodGrain12B rotate 90*z translate 10*y scale 20}}
}
box {<-50,-10,-50> <50,50,50> pigment {P_WoodGrain12B }finish{ ambient 0.6 diffuse 0} scale 1}
scale 0.5
}

//Sail boat
#declare sboat = union {
          // mast
        #declare mast = union {
                cone {<0,-30,-50>,3 <0,150,-50>,1 pigment {P_WoodGrain12B scale 1.0}}
                sphere {<0,152,-50>,4 pigment{Orange*1.2}}
                }
          //sail
        #declare sail = difference {
        box {<-1,0,100> <1,140,-50> }
        sphere {<0,185,145>,200 }
        }
        object {boat scale <1,2.5,6>}
        object {mast}
        object {sail scale <1,1,1.3> translate 18*z pigment {White*1.5}}
        object {sail rotate 180*y translate <0,1,-158> scale <1,.8,.5> pigment {Yellow*1.5}}
        translate 40*y
        rotate 90*y
}

//wake
#declare wake = 
torus {50,  10  pigment {P_Cloud1}finish {ambient 0.5 diffuse 0}}

#declare sailboat = union {
     object {wake scale <3,1,.46> translate <-30,10,0>}
     object {sboat rotate 180*y} 
    }
#declare sailboat2 = union {
          // mast
        #declare mast = union {
                cone {<0,-30,-50>,3 <0,150,-50>,1 pigment {P_WoodGrain12B scale 1.0}}
                sphere {<0,152,-50>,4 pigment{Orange*1.2}}
                }
          //sail
        #declare sail = difference {
        box {<-1,0,100> <1,140,-50> }
        sphere {<0,185,145>,200 }
        }
        object {boat scale <1,2.5,6>}
        object {mast}
        object {sail scale <1,1,1.3> translate 18*z pigment { White*.5}}
        object {sail rotate 180*y translate <0,1,-158> scale <1,.8,.5> pigment {Red*.5}}
        translate 40*y
        rotate 90*y
}    
//object {sailboat}   //commented out when used as an inc file 