// Persistence of Vision Ray Tracer Scene Description File
// File: base.inc
// Vers: 3.1
// Desc: include file for bbsunset.pov. Base of the Cape Hatteras Lighthouse
// Date: 7/31/99
// Auth: Bill Bobzien

#declare step_tex = texture { pigment { White } }
#declare step_rad = 22.5;
#declare step_ht = 0;
#declare step_ct = 0;

#declare Steps = 
union
{
	#while (step_ct < 4)
		MakeComponent (1,step_rad,step_ht,step_ht + 1.5,0,step_tex)
		#declare step_ht = step_ht + 1.5;
		#declare step_rad = step_rad - (4/3);
		#declare step_ct = step_ct + 1;
	#end
}


#declare brick_tex = texture { pigment { Red } }
#declare inset = 12*tan(radians(3));
#declare inset_step = inset/64;
#declare brick_rad = step_rad;
#declare brick_ht = step_ht;
#declare brick_ct = 0;

#declare Bricks = 
union
{
	#while (brick_ct < 64)
		MakeComponent (1,brick_rad,brick_ht,brick_ht + .1875,0, brick_tex)
		#declare brick_ht = brick_ht + .1875;
		#declare brick_rad = brick_rad - inset_step;
		#declare brick_ct = brick_ct + 1;
	#end
}

#declare AccentTex = step_tex

#declare inset = 12*tan(radians(3));
#declare inset_step = inset/10;
#declare accent_rad = step_rad;
#declare accent_ht = step_ht;
#declare accent_ct = 0;

#declare Accents = 
union
{
	#while (accent_ct < 10)
		MakeComponent (2,accent_rad,accent_ht,accent_ht+1.2,(45*mod(accent_ct,2)),AccentTex)
		#declare accent_ht = accent_ht + 1.2;
		#declare accent_rad = accent_rad - inset_step;
		#declare accent_ct = accent_ct + 1;
	#end
}
#declare DiffTex = texture { pigment { Blue } }


object { Steps }
object { Bricks }
object { Accents }
MakeComponent (1,brick_rad+.25,18,21,0,step_tex)
MakeComponent (1,brick_rad+.25+1/12,21,21.125,0,step_tex)
MakeCylSet (brick_rad+.25+1/12,22,.875,step_tex)
MakeComponent (1,brick_rad+.75+1/12+.875,22,23,0,step_tex)
MakeDiffSet (brick_rad+1.5+1/12+.875,23,.5,step_tex)

