#declare UsePhotons=yes;
#declare phd=1;
#declare PhotonsMaxTraceLevel=9;
//#declare PhotonsADCBailout=.01;

#include "textures.inc"
#include "photons.inc"

#declare Fast=no;

global_settings
{ max_trace_level 12
  ambient_light 2
  radiosity
  { brightness 8
    count 500
    distance_maximum .5
    error_bound .2
    gray_threshold .1
    low_error_factor .5
    minimum_reuse .001
    nearest_count 6
    recursion_limit 2
  }
}

// Textures and materials
//===================================================================
#declare CorkTexture=
  texture
  { pigment
    { marble color_map
      { [0 rgb <1,.6,.2>]
        [.2 rgb <1,.7,.2>]
        [1 rgb <1,.8,.4>]
      }
      turbulence 1
      rotate <20,30,40>
    }
    normal
    { spotted .3 slope_map
      { [0 <0,0>]
        [.2 <0,0>]
        [.21 <1,0>]
        [1 <1,0>]
      }
      scale .15
    }
  }
#declare GlassMaterial=
  material
  { texture
    { pigment { rgbf <1,1,1,.93> }
      finish
      { specular .4 roughness .01
        #if(!Fast) reflection .1 #end
      }
    }
    #if(!Fast) interior { ior 1.5 } #end
  }

#declare GreenGlassMaterial=
  material
  { texture
    { pigment { rgbf <0,.3,0,.7> }
      finish
      { specular .4 roughness .01
        #if(!Fast) reflection .1 #end
      }
      normal { dents .3 scale .08 }
    }
    #if(!Fast) interior { ior 1.5 } #end
  }
  
#declare LiquidMaterial=
  material
  { texture
    { pigment { rgbf <.9,.5,.1,.7> }
      finish { phong .2 }
    }
    #if(!Fast) interior { ior 1.33 } #end
  }    
  
#declare LabelTexture=
  texture
  { pigment
    { quilted color_map
      { [0 rgb <.9,.7,.4>]
        [.2 rgb <1,.9,.5>]
        [.5 rgb <1,.8,.4>]
        [1 rgb <1,.8,.4>]
      }
      turbulence .8
    }
    scale <.5,5,1>
  }
  texture
  { pigment
    { image_map { gif "blabel.gif" interpolate 2 once transmit 11,1 }
      translate -.5
      scale 6 rotate y*-90
      translate y*9
    }
  }

// Objects
//===================================================================
#declare Bottle=
  lathe
  { cubic_spline
    23,
    <-1,.5>,<0,.5>,<3,0>,<4,.5>,<4,2>,
    <3.5,8>,<4,15>,<1.25,18>,<1.5,19.5>,<1.25,23>,
    <1.25,23.2>,<1.5,23.3>,<1.5,23.6>,<.8,23.5>,<.9,22>,
    <1,19.5>,<.7,18>,<3.5,15>,<3,9>,<3,6>,
    <3,1.5>,<0,1.25>,<1,1.25>
    sturm
    material { GlassMaterial }
  }
#declare BottleLiquid=
  lathe
  { cubic_spline
    6,
    <3.5,15>,<3,9>,<3,6>,<3,1.5>,<0,1.25>,<1,1.25>
    sturm
    material { LiquidMaterial }
  }
#declare BottleCork=
  lathe
  { cubic_spline
    5,
    <.91,26>,<.9,25>,<.8,23.5>,<.9,22>,
    <1,19.5>
    sturm
    texture { CorkTexture }
  }
#declare BottleLabel=
  difference
  { lathe { cubic_spline 5,<4,.5>,<4,2>,<3.5,8>,<4,15>,<1.25,18> }
    lathe { cubic_spline 5,<4,.5>,<4,2>,<3.5,8>,<4,15>,<1.25,18> scale .9999 }
    cylinder { y*6,y*12,5 inverse }
    box { <1.5,5.99,-5><-5,12.01,5> }
    texture { LabelTexture }
  }
  
#declare WaterGlass=
  difference
  { lathe
    { cubic_spline
      13,
      <-1,.2>,<0,.2>,<1,0>,<1.79,0>,<1.8,.1>,<2.2,1><2.5,5>,
      <2.51,5.1>,<2.35,5.5>,<2.25,5>,<1.5,1>,
      <0,.5>,<-1,.5>
      sturm
    }
    cylinder { -y*1.5,y*5.5,8 rotate x*10 translate z*9.8 }
    cylinder { -y*1.5,y*5.5,8 rotate x*10 translate z*9.8 rotate y*90 }
    cylinder { -y*1.5,y*5.5,8 rotate x*10 translate z*9.8 rotate y*180 }
    cylinder { -y*1.5,y*5.5,8 rotate x*10 translate z*9.8 rotate y*270 }
    cylinder { -y*1.5,y*5.5,1 rotate x*10 translate z*2.9 rotate y*45 }
    cylinder { -y*1.5,y*5.5,1 rotate x*10 translate z*2.9 rotate y*(90+45) }
    cylinder { -y*1.5,y*5.5,1 rotate x*10 translate z*2.9 rotate y*(180+45) }
    cylinder { -y*1.5,y*5.5,1 rotate x*10 translate z*2.9 rotate y*(270+45) }
    material { GlassMaterial }
  }
  
#declare Cigar=
  union
  { cylinder { -x,x*.6,.16 pigment { rgb 1 } }
    cylinder { x*.6,x*1.2,.16 pigment { rgb <1,.7,.2> } }
  }

#declare Ashtray=
  union
  { difference
    { lathe
      { cubic_spline
        8,
        <2,-.1>,<2,0>,<1.8,.8>,<1.5,1>,<1.3,.8>,<1.2,.3>,<0,.2>,<-1,.2>
      }
      cylinder { <-2,.9,0><2,.9,0>,.2 }
      box { <-2,.9,-.2><2,1.1,.2> }
      union
      { cylinder { <-2,.9,0><2,.9,0>,.2 }
        box { <-2,.9,-.2><2,1.1,.2> }
        rotate y*90
      }
      material { GreenGlassMaterial }
    }
    object { Cigar rotate z*168 translate <-1.6,.87,0> }
  }

#declare Painting=
  union
  { difference
    { box { <-5,0,0><5,1,.4> }
      box { <-5.01,0,0><5.01,1.2,-.4> rotate x*15 }
      translate <0,-3,-.4>
    }
    difference
    { box { <-5,0,0><5,1,.4> }
      box { <-5.01,0,0><5.01,1.2,-.4> rotate x*15 }
      rotate z*180
      translate <0,3,-.4>
    }
    difference
    { box { <-3,0,0><3,1,.4> }
      box { <-3.01,0,0><3.01,1.2,-.4> rotate x*15 }
      rotate z*90
      translate <5,0,-.4>
    }
    difference
    { box { <-3,0,0><3,1,.4> }
      box { <-3.01,0,0><3.01,1.2,-.4> rotate x*15 }
      rotate z*-90
      translate <-5,0,-.4>
    }
    box
    { <-4,-3,-.01><4,3,0>
      pigment
      { mandel 35 color_map
        { [0 rgb <.5,0,0>]
          [.5 rgb <1,0,0>]
          [1 rgb <1,1,.5>]
        }
        translate <1,-.5,0> scale 10
        translate <2.5,1.5,0> scale 5
      }
    }
    pigment { Tom_Wood scale .3 }
  }
  
#declare Chair=
  union
  { superellipsoid
    { <.1,.1> scale <2,1,.2>
      pigment { rgb <.8,.2,.2> } finish { specular .1 }
    }
    union
    { cylinder { <-1,0,-.3>,<-12,-5,-.3>,.1 }
      cylinder { <1,0,-.3>,<1,-5,-.3>,.1 }
      pigment { rgb 1 } finish { specular .5 metallic }
    }
  }  

// Scene
//===================================================================
camera { location <2.5,-2.5,-1> look_at -z*8-y*1.5 angle 60 }

// Chair
object { Chair rotate y*10 translate <-7,-3,-10> }

// Painting
object { Painting rotate y*180 translate -z*11+y*5 }

// Bottle
union
{ object { Bottle Photons(yes,yes,no) }
  object { BottleLabel scale 1.001 }
  object { BottleCork scale .999999 }
  object
  { BottleLiquid Photons(no,yes,no)
    translate -y*5 scale .999999 translate y*5
  }
  scale .2
  rotate y*220
  translate <0,-3.99999,-8>
} 

// Glass
object
{ WaterGlass Photons(yes,yes,no)
  scale .3
  rotate y*-45
  translate <-2,-3.96,-8>
} 

// Ashtray
object
{ Ashtray Photons(yes,yes,yes)
  scale .5
  rotate y*20
  translate <2.5,-3.999,-9>
} 

// Room
difference
{ box { <-12,-9,-12><12,9,12> }
  box { <-11,-8,-11><11,8,11> }
  pigment { DMFWood4 turbulence .1 scale 3 rotate x*90 translate x*20 rotate x*10 }
  normal
  { gradient x 1 slope_map
    { [0 <0,1>]
      [.05 <.9,1>]
      [.06 <1,0>]
      [.94 <1,0>]
      [.95 <.9,-1>]
      [1 <0,-1>]
    }
    scale 3
    translate -x*12
  }
}
box
{ <-11,-8,-18><-10.99,8,11>
  pigment { rgb <1,.5,.5>*.8 }
  normal { waves .2 scale .5 translate -z*1000 }
}
box
{ <11,-8,-18><10.99,8,11>
  pigment { rgb <.5,.75,1>*.8 }
  normal { waves .2 scale .5 translate -z*1000 }
} 

// Table
#macro Gradient(Width)
  gradient x color_map
  { [0 rgb x]
    [Width rgb x]
    [Width rgbt 1]
    [1 rgbt 1]
  }
#end  
#if(Fast)
box { -1,1
#else
superellipsoid { <.1,.1>
#end
  scale <4.5,2,2> translate -y*6
  texture
  { pigment { rgb 1 }
    normal { quilted .3 rotate <45,0,45> scale .1 }
  }
  texture
  { pigment
    { average pigment_map
      { [1 Gradient(.2)]
        [1 Gradient(.2) rotate y*90]
        [1 Gradient(.2) rotate z*90 translate y*.1]
      }
      scale .25
      translate -10
    }
    normal { quilted .3 rotate <45,0,45> scale .1 }
  }
  texture
  { pigment { Gradient(.1) translate -10 }
    normal { quilted .3 rotate <45,0,45> scale .1 }
  }
  texture
  { pigment { Gradient(.1) rotate y*90 translate -10 }
    normal { quilted .3 rotate <45,0,45> scale .1 }
  }
  translate -z*9
}

// Carpet
box
{ <-7,-8,-5><7,-7.95,6>
  pigment { rgb <.6,.8,.3> }
  normal
  { gradient x normal_map
    { [0 bumps .5 scale .1]
      [.2 bumps .4 scale .1]
      [.3 bumps .1 scale .1]
      [.9 bumps .1 scale .1]
      [1 bumps .5 scale .1]
    }
  }
}

// Shelves
union
{ box { <-2,-8,8><-1.7,4.2,11> }
  box { <11,-8,8><10.7,4.2,11> }
  #declare yCoord=-8;
  #while(yCoord<=4)
    box { <-2,0,8><11,.2,11> translate y*yCoord }
    #declare yCoord=yCoord+3;
  #end

  pigment { rgb <.9,.7,.5> }
}
cylinder
{ 0,y*1.5,.5 pigment { rgb <.5,.9,1> } finish { reflection .2 }
  translate <9,-2,9.5>
}
cylinder
{ 0,y*1.5,.5 pigment { rgb <1,.2,0> } finish { reflection .1 }
  translate <7,-2,9>
}
light_source
{ 0, 1
  area_light x*2,z*2,10,10 adaptive 0
  rotate x*90 translate <-8.5,6.5,10.2>
}