#ifndef(UsePhotons) #declare UsePhotons=yes; #end
#ifndef(phd) #declare phd=1; #end

global_settings
{ 
  #if(UsePhotons)
    photons
    { gather 20,100
      radius 0.1*phd, 2, 0.1*phd
      autostop 0
      jitter .4
      expand_thresholds 0.2, 40
      #ifdef(PhotonsMaxTraceLevel) max_trace_level PhotonsMaxTraceLevel #end
      #ifdef(PhotonsADCBailout) adc_bailout PhotonsADCBailout #end
    }
  #end  
}

#macro Photons(Refl,Refr,Ignore)
  #if(UsePhotons)
    photons
    { separation .01*phd
      reflection Refl
      refraction Refr
      #if(Ignore) ignore_photons #end
    }
  #end
#end
