/*
   HF Generator : water surface
*/

#version 3.0
global_settings {
 assumed_gamma 2.2 hf_gray_16
}

#include "colors.inc"
#include "textures.inc"


plane {z,16
 texture{
  pigment{
   bumps
   cubic_wave
   turbulence 0.1
   color_map{
    [0.0 White*.8]
    [1.0 White*.9]
   }
   scale <1,2,1>
  }
  finish{Luminous}
  translate -130*x
 }
 texture{
  pigment{
   dents
   turbulence 0.4
   color_map{
    [0.0 White*.1 filter .75]
    [1.0 Clear]
   }
   scale <1,3,1>
   rotate -20*z
  }
  finish{Luminous}
  translate -100*x
  translate -10*y
  translate 10*z
 }
 texture{
  pigment{
   dents
   turbulence 0.4
   color_map{
    [0.0 White*.1 filter .75]
    [1.0 Clear]
   }
   scale <1,3,1>
   rotate 20*z
  }
  finish{Luminous}
  translate 100*x
  translate -10*y
  translate 10*z
 }
}


camera{location <0,0,-20> translate 0*x}

