//===================================================================================================
// THE LATEST SUPERPATCH (3.1g)IS REQUIRED TO RENDER THIS SCENE,
// or any other patch that contains the "function {pigment}" isosurface capability
//
// given the small size of the source file, I managed to comment and indent everything.
// dont expect such thing from me otherwise ;-)

#declare White=rgb 1;
#declare Black=rgb 0;

#declare sky_vect = y;
#declare cam_loc = <5,50,-50>;
#declare lookat = <10,5,2>;

camera {  //  Camera StdCam
  location  cam_loc
  direction <0.0,     0.0,  12>
  sky       sky_vect   // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   lookat
}

#max_trace_level 30
/*
#declare light_loc = <-3.5,5,3>
#include "105mm.flr"
#include "nkflare.inc"
*/
#declare light_loc = <0,5,3>
#include "tv-day.flr"
#include "nkflare.inc"

//===================================================================================================
//

#declare Pig3= //defines the earth's surface displacement pattern
 function{
  pigment{
          wrinkles
          color_map{[0 rgb 1][1 rgb 0]} 
          translate x*-.2 //shifted to push an annoying tumulus out of the image
         }
  }          

#declare Pig4= //defines a pseudo-height_field, that will be carved out the basic earth surface
 function{
  pigment{
         image_map {gif "d:\pov3\nazc-hf.gif"}
         rotate x*90
         }
  }

#declare PampaTex= //defines the earth's texture, a neutral greyinsh-brownish-geenish,
                   //with the help of the Moray texture editor     
   texture
   {  pigment
      {  wrinkles
         color_map
         {  [ 0.0     rgbft <0.387827, 0.391144, 0.33799, 0.0, 0.0> ]
            [ 0.166667  rgbft <0.365664, 0.368791, 0.318675, 0.0, 0.0> ]
            [ 0.333333  rgbft <0.371689, 0.383548, 0.345585, 0.0, 0.0> ]
            [ 0.5     rgbft <0.398926, 0.402338, 0.347662, 0.0, 0.0> ]
            [ 0.666667  rgbft <0.376466, 0.386712, 0.363288, 0.0, 0.0> ]
            [ 0.833333  rgbft <0.356752, 0.360834, 0.295416, 0.0, 0.0> ]
            [ 1.0     rgbft <0.38118, 0.383548, 0.345585, 0.0, 0.0> ]
         }
         scale  0.2
      }   
      
      finish {ambient 0.4892 specular .2}
   }

//===================================================================================================
// DEFININIG THE COMPLEX SURFACE
   
#declare Plane1=
   isosurface{
        function (x*0+y*1+z*0) //this is the equation of the flat plane
  //                     +(Pig4(x,y,z)*.003) //this adds the wrinkled displacement
    //                   +(Pig3(x,y,z)*.6) //this adds the carving image
        
        method 2 //check the manual about the isosurface, I'm not an expert !
        threshold 1 sign 1
        max_gradient 5
        
        finish {phong 1}
}

//===================================================================================================
//

object {Plane1 scale <20,1,15> 
        texture {PampaTex scale 20} //earth's texture

        texture {pigment {image_map {gif "nazc-map" //image layer, defining whiter areas
                                      transmit 255 1 //normal earth
                                      filter 240 .6 //gypsum (big lines and surfaces)
                                      filter 239 .7 //gypsum (fine lines and animals)
                                      }
                           rotate x*90 scale <20,1,15>
                           }                           
                 }
        }

//===================================================================================================
// PLACING SOME FAKE HUMANS (no need to worry at such a distance !!)

#declare human=cylinder {<0,0,0>,<0,.04,0>,.005 pigment {Black}}

#declare r1=seed(0);
#declare boucle=0; 
 #while (boucle < 10)
  object {human translate <rand(r1)*.5,0,rand(r1)*.5> translate <10,.71,7>}
 #declare boucle=boucle+1;
 #end 

//===================================================================================================
// LIGHT AND ATMOSPHERE

light_source {x*50000 White*2 rotate z*18 rotate y*-45}

fog {distance 2000 rgb <.2,.3,.4>}
