// This macro constructs a cross braced, or lattice girder
// of cross section  Depth x Width.
// The girder lies along a centre line extending from Vec1 to Vec2. 
// Four Tee sections Run along the length of the girder at the corners
// of the girder 
// The top of the tee is FlWidth wide and FLthick thick.
// The vertical part of the Tee is FlWidth/2 deep.
// Cross bracing extends the length of the girder on all four sides.
// Created by David Wilkinson  <davidwilkinson@cwcom.net>
//  http:www.hamiltonite.mcmail.com
// August 1999 


// *****  Reorient is a macro devised by John Van Sickle  ******
// This and other useful macros can be downloaded from;
//      http://www.erols.com/vansickl/povray.htm
#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
#if (vlength(vY)>0)
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
#end
// End of reorient macro


#macro BracedGirder(Vec1,Vec2,Depth,Width,FlWidth,FlThick)
#local Length=vlength(Vec1-Vec2);
#local NX=int(Length/(Depth-(2*FlThick)));
#local Pitch=Length/NX; 
union {
   #local TeeBar=
      union{
         box { <0,0,0> <Length,FlThick,FlWidth> }
         box { <0,0.01,(FlWidth-FlThick)/2><Length,FlThick+FlWidth/2,(FlWidth+FlThick)/2> }
      }
      
   union {
      object { TeeBar }  
      object { TeeBar translate z*(Width-FlWidth) }
      object { TeeBar rotate x*180 translate <0,Depth,FlWidth> }
      object { TeeBar rotate x*180 translate <0,Depth,Width> }
   }
               
      #local AngleD = atan2((Depth-(2*FlThick)),Pitch);
      #local AngleW = atan2((Width-(FlWidth+FlThick)),Pitch);
      #local LD=Pitch/cos(AngleD);// length of depth crossmember
      #local LW=Pitch/cos(AngleW);// length of width crossmember
      #local DX=   
         box { 0 <FlWidth/4,LD,FlThick> }
      #local WX=   
         box { 0 <FlWidth/4,FlThick,LW> }
      #local Count=0;
      
   #local DXmembers=
      union{         
         #while (Count<NX) // define depth cross members
           object { DX 
                  rotate z*(90-degrees(AngleD))
                  translate <Pitch*(Count+1),0,0>
            }   
           object { DX 
                  rotate -z*(90-degrees(AngleD))
                  translate <Pitch*Count,0,0>
            }
            #local Count=Count+1;
         #end        
      }
        
   #local Count=0;
   #local WXmembers=
      union{         
         #while (Count<NX) // define width cross members
           object { WX 
                  rotate y*(90-degrees(AngleW))
                  translate <Pitch*Count,0,0>
            }   
           object { WX 
                  rotate -y*(90-degrees(AngleW))
                  translate <Pitch*(Count+1),0,0>
            }
            #local Count=Count+1;
         #end        
      }
    
   object { DXmembers  translate <0,FlThick,-FlThick+(FlWidth-FlThick)/2> }
   object { DXmembers  translate <0,FlThick,Width-(FlWidth+FlThick)/2> }
   object { WXmembers  translate <0,-FlThick,FlThick+(FlWidth+FlThick)/2> }
   object { WXmembers  translate <0,Depth,FlThick+(FlWidth+FlThick)/2> }   
      
      translate <0,-Depth/2,-Width/2>
      Reorient(x,(Vec1-Vec2))
      translate Vec2    
}
#end 

