// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Date: mm/dd/yy
// Auth: D.G.Wilkinson

#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

global_settings
{
  assumed_gamma 1.0
}

camera
{
  location  <300,100, -300>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 100,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  <200, 500, 500>
  color rgb 1
}

light_source
{
  <200, 500, -500>
  color rgb 1
} 

plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}

#declare BridgePier=
union {

// top of bridge pier 
   box{ 0 <32,-4,57> translate <-16,211,-57/2> }
   difference {
      box{ 0 <26.5,-75,52> translate <-26.5/2,211,-52/2> }
      union {
         box{ 0 <30,32-27/2,27> translate <-15,157,-27/2> }
         cylinder { 0 <30,0,0> 27/2 translate <-15,157+32-27/2,0> }
      }
   }
   box { 0 <34,6,58> translate <-17,211-81,-29> }

/* tried conic prisms to start with.  These are useable, but the CSG below is more accurate and was used to try to avoid brick pattern artifacts.
   prism { conic_sweep   1,57/66, 5,
           <-43/2,-66/2> <43/2,-66/2> <43/2,66/2> <-43/2,66/2> <-43/2,-66/2>
           scale <1,(211-81)/(1-57/66),1>
           rotate 180*z
           translate y*(211-81)/(1-57/66)           
         }
   prism { conic_sweep   1,97/100, 5,
           <-48/2,-100/2> <48/2,-100/2> <48/2,100/2> <-48/2,100/2> <-48/2,-100/2> 
           scale <1,18/(1-97/100),1>           
           rotate 180*z
           translate y*18/(1-97/100)                     
         }
*/            
#local Bricks= texture { brick texture { T_Grnt21 }//T_Grnt18a }
                 texture{ T_Grnt16 }                
                 brick_size <4.5, 3, 4.5>
                 mortar 0.2
                 scale 0.7
               }
#local Slope1=10; // this gave the best rendition of brick pattern            
   intersection {
      plane { y, 211-81 }
      plane { y, 17 inverse}
      plane { x, -43/2 texture {Bricks rotate -z*degrees(atan2((43-30)/2,157-18)-Slope1)}
                rotate -z*degrees(atan2((43-30)/2,157-18)) inverse }
      plane { x, 43/2 texture {Bricks rotate z*degrees(atan2((43-30)/2,157-18)+Slope1)}
                rotate  z*degrees(atan2((43-30)/2,157-18))}              
      plane { z, -66/2 texture {Bricks rotate x*degrees(atan2((64-57)/2,157-18)+Slope1)}
                rotate x*degrees(atan2((64-57)/2,157-18)) inverse }
      plane { z, 66/2 texture {Bricks rotate -x*degrees(atan2((64-57)/2,157-18)-Slope1)}
                rotate -x*degrees(atan2((64-57)/2,157-18)) }   
   } 
   
      intersection {
      plane { y, 18 }
      plane { y, -1 inverse}
      plane { x, -48/2 texture {Bricks rotate -z*degrees(atan2((48-45)/2,18)-Slope1)}
                       rotate -z*degrees(atan2((48-45)/2,18)) inverse}
      plane { x, 48/2 texture {Bricks rotate z*degrees(atan2((48-45)/2,18)+Slope1)}
                      rotate  z*degrees(atan2((48-45)/2,18)) }              
      plane { z, -100/2 texture {Bricks rotate x*degrees(atan2((100-97)/2,18)+Slope1)}
                      rotate x*degrees(atan2((100-97)/2,18)) inverse}
      plane { z, 100/2 texture {Bricks rotate -x*degrees(atan2((100-97)/2,18)-Slope1)}
                      rotate -x*degrees(atan2((100-97)/2,18)) }   
   }
}   
object { BridgePier 
  texture { brick texture { T_Grnt21 }
                 texture{ T_Grnt16 }                
                 brick_size <4.5, 3, 4.5>
                 mortar 0.2
                 scale 0.7
  }
} 