//------------------------------------------------------------------------
//
//  Author:  Robert J Becraft
//------------------------------------------------------------------------
#include "colors.inc"
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"

//************************* CAMERA ***********************************
camera {
//   location  <-15,5,0> look_at <0,2,0>     // view inside  (*******)
//   location  <30,35,20> look_at <0,2,0>     // view  (*******)   
//   location  <-5,6,-9> look_at <0,.2,0>     // view  (*******)
//   location  <18,5.5,-.5> look_at <0,2,0>     // view through a window  (*******)       
//   location  <16,6.5,6.5> look_at <0,2,-4.5>     // view from 2nd floor balcony  (*******)       
//   location  <15,6.5,7> look_at <0,2,-4.5>     // view from 2nd floor balcony view 2  (*******)  
//   location  <-5,5,0> look_at <0,5,0>     // view from  (*******)         
   location  <12.75,2,-6> look_at <-5,3,1>     // view from General Admin area  (*******)       
//   location  <16,6.5,5.5> look_at <16,2,-5>     // view from 2nd floor balcony  (*******) 
//   location  <3,6.5,-17.5> look_at <-3.5,2,16>     // view from 2nd floor balcony side  (*******)
}
 
#declare BayLightOn=off;  // uncomment to turn off 
#declare LampOff=off; // uncomment to turn off
#declare Special=off; // uncomment to turn off
#declare Fog=on;        // uncomment to turn on

//#ifdef(BayLightOn)
  light_source { <275,1000,-300 >  color White*2 }  
//  light_source { <0,6,0> color Orange}
//#end
//------------------------------------------------------------------------

#include "..\med\cloud.inc"
#include "..\med\brick.inc" 
//------------------------------------------------------- ROOF103 Textures 
    #declare P_Roof103A = pigment { 
      bozo
      pigment_map {
        [0.00 colour  DarkBrown]
        [0.30 colour  Tan]
        [0.40 colour  DarkBrown]
        [0.60 colour  Gray20]
        [1.00 colour  Tan]
      }
      scale 100
    }
 
    #declare P_Roof103B = pigment {P_Roof103A  warp { repeat x*8 offset <0,45,0> } }
    #declare P_Roof103C = pigment {P_Roof103B  warp { repeat y*3 offset <60,0,0> } }

    #declare T_Roof103 = texture {
      pigment { P_Roof103C }   //turbulence 0.075 }
      normal { granite 0.2 }
    }
#declare RoofText103=texture{T_Roof103 scale .005}
//-------------------------------------------------------------------


#declare ChairBack=difference{
   cone{<0,0,0>.29<0,.1,0> .3}
   cone{<0,-.01,0>.27<0,.11,0> .28}
   box{<-.35,-.1,-.35><.22,.11,.35>}
   texture{T_Wood1 scale .25 rotate<90,0,0>}
}
#declare ChairRail=union{
   cone{<0,0,0>.005<0,.15,0>.012}
   cone{<0,.15,0>.012<0,.3,0>.005}
   sphere{<0,.15,0> .015}
   texture{T_Wood1 scale .25 rotate<90,0,0>}
} 
#declare ChairRailBack=union{
  #declare ROY=-30;
  #while (ROY<=30)
     object{ChairRail translate<.3,0,0> rotate<0,ROY,0>}
     #declare ROY=ROY+10;
  #end 
  object{ChairBack translate<0,.28,0> rotate<0,0,0>} 
}
#declare ChairLeg=object{
  cone{<0,0,0>.02<.025,-.3,.025>.01}
//  sphere{<.025,-.2,.025> .02 }
   texture{T_Wood1 rotate<90,90,0>}
}   
#declare Chair=union{
  object{ChairRailBack translate<0,0,0>}
  intersection{
    cylinder{<0,0,0><0,.02,0> .24 texture{T_Wood1 scale .25 rotate<90,0,0>}}
    box{<-.22,0,-.19><.22,.021,.19>}
     translate<.12,0,0> 
  } 
  object{ChairLeg translate<.18,0,0> rotate<0,45,0> translate<.12,0,0>}
  object{ChairLeg translate<.18,0,0> rotate<0,-45,0> translate<.12,0,0>}
  object{ChairLeg translate<.18,0,0> rotate<0,135,0> translate<.12,0,0>}
  object{ChairLeg translate<.18,0,0> rotate<0,-135,0> translate<.12,0,0>}  
 scale 1.5 
 translate<0,.3,0>  // make bottom of chairlegs at y=0
}                                                     


#declare GlassGlobe=difference{
   union{
     sphere{<0,0,0> .075}
     cone{<0,.074,0> .04 <0,.135,0> .045}
   }
   sphere{<0,0,0> .074}
   cone{<0,.0739,0> .039 <0,.136,0> .044}
  texture{T_Old_Glass}
} 
#declare Flame=union{
   cone{<0,0,0>.01 <0,.025,0> 0}
   sphere{<0,0,0>.01}
  texture{pigment{color Orange} finish{ambient 10} }
}  
     
#declare Lamp=union{
   sphere{<0,0,0>.075 texture{Bright_Bronze}}
   torus{.075,.005 texture{Bright_Bronze}}
   cylinder{<0,0,0><0,.085,0> .03 texture{Bright_Bronze}}
   cylinder{<0,.085,0><0,.145,0>.022 texture{pigment{color Wheat}}} // candle
   
   object{Flame translate<0,.155,0>}

#ifndef(LampOff)   
   light_source {  <0,.205,0> color Orange fade_power 2 fade_distance 1 }
#end
   
   object{GlassGlobe translate<0,.12,0>}
}

#declare Wood1=texture{T_Wood7 scale .25}   
#declare Wood2=texture{T_Wood11 scale .25}       
#declare Timber=box{<-.12,0,-.12><.12,3.7,.12> texture{Wood1 scale .5 rotate<90,0,0>}}
#declare Joist1=box{<-.03,-.1,-1.85><.03,.1,1.8> translate<0,0,0> texture{Wood1 rotate<0,0,0>}}       
#declare Board1=box{<-1.9,-.05,-.2><1.9,.05,.2> texture{Wood1 rotate<0,90,0>}}

#declare Frame=union{
  box{<-1.85,.1,-1.85><1.85,.4,-1.75> texture{Wood1 rotate<0,90,0>}}
  box{<-2.3,.1,1.75><2.3,.4,1.85> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.23,.1,-1.85><-2.15,.4,1.95> rotate<0,-7,0> translate<.2,0,0> texture{Wood1}}
  box{<2.15,.1,-1.85><2.23,.4,1.95> rotate<0,7,0> translate<-.2,0,0> texture{Wood1}} 
  
  #declare FS=-1.85;
  #while (FS<=1.85)
     object{Joist1 translate<FS,.4,0>}
     #declare FS=FS+1.85/4;
  #end       
  
  #declare FS=-1.85;
  #while (FS<=1.85)
     object{Board1 translate<0,.5,FS>}
     #declare FS=FS+.45;
  #end       
}
#declare Frame_Seats=union{
  box{<-1.85,.45,-1.2><1.85,.95,-.7> texture{Wood2 rotate<0,90,0>}}
  box{<-1.95,.45,-.7><1.95,1.4,-.3> texture{Wood2 rotate<0,90,0>}}
  box{<-2.05,.45,-.3><2.05,1.8,.1> texture{Wood2 rotate<0,90,0>}}
  box{<-2.15,.45,.1><2.15,2.2,.5> texture{Wood2 rotate<0,90,0>}}
  box{<-2.25,.45,.5><2.25,2.6,.9> texture{Wood2 rotate<0,90,0>}}
}
#declare Frame_Seats2=union{
  box{<-1.55,.45,-1.5><1.55,.95,-1> texture{Wood2 rotate<0,90,0>}}
  box{<-1.55,.45,-1><1.55,1.4,-.5> texture{Wood2 rotate<0,90,0>}}
  box{<-1.55,.45,-.5><1.55,1.8,0> texture{Wood2 rotate<0,90,0>}}
  box{<-1.55,.45,0><1.55,2.2,.5> texture{Wood2 rotate<0,90,0>}}
  box{<-1.55,.45,.5><1.55,2.6,.51> texture{Wood2 rotate<0,90,0>}}
  box{<-1.55,.45,.48><1.55,2.7,.52> texture{Wood1 rotate<0,90,0>}} // top rail 
}
#declare Frame_Seats3=union{
  box{<-1.85,.45,-1.3><1.85,.95,-.9> texture{Wood2 rotate<0,90,0>}}
  box{<-1.95,.95,-.9><1.95,1.4,-.5> texture{Wood2 rotate<0,90,0>}} 
  box{<-2.05,1.4,-.5><2.05,1.8,-.45> texture{Wood2 rotate<0,90,0>}}  
  box{<-2.05,1.8,-.53><2.05,1.9,-.42> texture{Wood1 rotate<0,90,0>}} // top rail 
}

        
#declare Joist2=box{<-.03,-.1,-2.45><.03,.1,2.5> translate<0,0,-.85> texture{Wood1 rotate<0,0,0>}}
#declare Board2=box{<-2.,-.05,-.2><2.,.05,.2> texture{Wood1 rotate<0,90,0>}}
#declare Frame2=union{
  box{<-1.85,.1,-3.2><1.85,.4,-3> texture{Wood1 rotate<0,90,0>}}
  box{<-2.3,.1,1.75><2.3,.4,1.95> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.32,.1,-3><-2.15,.4,1.95> rotate<0,-7,0> translate<.2,0,0> texture{Wood1}}
  box{<2.15,.1,-3><2.32,.4,1.95> rotate<0,7,0> translate<-.2,0,0> texture{Wood1}} 
  
  #declare FS=-1.85;
  #while (FS<=1.85)
     object{Joist2 translate<FS,.4,0>}
     #declare FS=FS+1.85/4;
  #end                  
  
  #declare FS=-3;
  #while (FS<=1.75)
     object{Board2 translate<0,.5,FS>}
     #declare FS=FS+.45;
  #end       
}
#declare Gentlemen_Room=union{

// Walls
  box{<-2.26,.1,-2.85><-2.25,3.8,.4> rotate<0,-7,0> translate<.2,0,0> texture{pigment{color Wheat}}}
  box{<2.25,.1,-2.85><2.26,3.8,.4> rotate<0,7,0> translate<-.2,0,0> texture{pigment{color Wheat}}}   
  
  box{<-2.27,.1,.4><-2.24,3.8,.6> rotate<0,-7,0> translate<.2,0,0> texture{Wood1}} // wood frame
  box{<2.24,.1,.4><2.27,3.8,.6> rotate<0,7,0> translate<-.2,0,0> texture{Wood1}}   
// Framing in walls  
  box{<-2.34,2.7,-2.85><-2.15,2.8,.4> rotate<0,-7,0> translate<.2,0,0> texture{Wood1}}
  box{<2.15,2.7,-2.85><2.34,2.8,.4> rotate<0,7,0> translate<-.2,0,0> texture{Wood1}} 
  
// Back wall
  box{<-2.15,.1,.34><-.35,2.6,.35> texture{pigment{color Wheat}}}
  box{<-2.15,2.6,.33><-.35,2.7,.36> texture{Wood1}} // top rail
  box{<-.35,.1,.33><-.32,2.7,.36> texture{Wood1}} 
    
  box{<.35,.1,.34><2.15,2.6,.35> texture{pigment{color Wheat}}}
  box{<.35,2.6,.33><2.15,2.7,.36> texture{Wood1}} // top rail   
  box{<.35,.1,.33><.32,2.7,.36> texture{Wood1}} 

// Chairs
#declare C1=-1.3;
#while (C1<=1.3)
   #declare C2=-2.5;
   #while (C2<=1.4)
      object{Chair rotate <0,90,0>  translate<C1,.7,C2>}
      #declare C2=C2+1;
   #end
   #declare C1=C1+.75;
#end

}

#declare Joist3=box{<-.03,-.1,-3.2><.03,.1,3.0> translate<0,0,-1.2> texture{Wood1 rotate<0,0,0>}}
#declare Board3=box{<-1.85,-.05,-.2><1.85,.05,.2> texture{Wood1 rotate<0,90,0>}}
#declare Frame3=union{
  box{<-1.65,.1,-4.2><1.65,.4,-4> texture{Wood1 rotate<0,90,0>}}
  box{<-2.3,.1,1.75><2.3,.4,1.95> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.32,.1,-4><-2.15,.4,2.2> rotate<0,-7,0> translate<.2,0,0> texture{Wood1}}
  box{<2.15,.1,-4><2.32,.4,2.2> rotate<0,7,0> translate<-.2,0,0> texture{Wood1}} 
  
  #declare FS=-1.65;
  #while (FS<=1.65)
     object{Joist3 translate<FS,.4,0>}
     #declare FS=FS+1.85/4;
  #end
  
  #declare FS=-4;
  #while (FS<=1.75)
     object{Board2 translate<0,.5,FS>}
     #declare FS=FS+.45;
  #end                
}  
#declare Truss1=box{<-.067,-.15,-2.2><.067,.15,2.2> texture{Wood1}}
#declare Truss2=box{<-.065,-.15,-.75><.065,.15,.75> texture{Wood1}}
#declare Truss=union{    
  box{<-.07,-.15,-3.2><.07,.15,3.2> translate<0,0,-1.2> texture{Wood1}}
  object{Truss1 rotate<-40,0,0> translate<0,1.3,-2.75>}
  object{Truss1 rotate<40,0,0> translate<0,1.3,.40>}
  object{Truss2 rotate<-45,0,0> translate<0,.6,0>}
  object{Truss2 rotate<45,0,0> translate<0,.6,-2.25>}
}
#declare Roof1=union{
   triangle{<-1.85,0,-2.2><-1.60,0,2.2><1.85,0,-2.2> texture{RoofText103}}
   triangle{<-1.60,0,2.2><1.85,0,-2.2><1.60,0,2.2> texture{RoofText103}}
}
#declare RoofBay=union{
   object{Roof1 rotate<0,180,0> rotate<40,0,0> scale<1.22,1,1> translate<0,1.95,.50>}
   object{Roof1 rotate<0,180,0> rotate<-40,0,0> translate<0,1.95,-2.85>}
}
  
#declare FrameR=union{
  box{<-1.65,.1,-4.2><1.65,.4,-4> texture{Wood1 rotate<0,90,0>}}
  box{<-2.3,.1,1.75><2.3,.4,1.95> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.34,.1,-4><-2.15,.4,2.2> rotate<0,-7,0> translate<.2,0,0> texture{Wood1}}
  box{<2.15,.1,-4><2.34,.4,2.2> rotate<0,7,0> translate<-.2,0,0> texture{Wood1}} 
  
  #declare RT=-1.60;
  #while (RT<=1.60)
    object{Truss translate<RT,.5,0>}
    #declare RT=RT+1.60;
  #end
  
  object{RoofBay}
}
                                                          
#declare Balus=union{
   cone{<0,.2,0>.04 <0,.5,0>.05 texture{Wood2 rotate<90,0,0>}} 
   cylinder{<0,.3,0><0,.35,0>.05 texture{T_Wood2}}
   sphere{<0,.6,0>.065 texture{Wood1 rotate<90,0,0>}}
   cylinder{<0,.3,0><0,.7,0> .03 texture{Wood2 rotate<90,0,0>}}
   cone{<0,.7,0>.05 <0,1,0>.04 texture{Wood2 rotate<90,0,0>}}   
   cylinder{<0,.9,0><0,.95,0>.05 texture{T_Wood2}}
} 
#declare Post1=union{
   box{<-.06,0,-.06><.06,1.5,.06> texture{Wood2 rotate<90,0,0>}}
   sphere{<0,1.55,0>.065 texture{Wood2 rotate<90,0,0>}}
}    
#declare Rail1=union{
  box{<-1.7,0,-.05><.75,.2,.05> texture{Wood2 rotate<0,90,0>}}  // bottom rail
  box{<-1.7,1,-.05><.75,1.2,.05> texture{Wood2 rotate<0,90,0>}} // top rail

  #declare XX=-1.4;
  #while (XX<=.7)
     object{Balus translate<XX,0,0>}
     #declare XX=XX+.3;
  #end
}  
#declare Rail2=union{
  box{<-1.7,0,-.05><1.7,.2,.05> texture{Wood2 rotate<0,90,0>}}  // bottom rail
  box{<-1.7,1,-.05><1.7,1.2,.05> texture{Wood2 rotate<0,90,0>}} // top rail

  #declare XX=-1.4;
  #while (XX<=1.4)
     object{Balus translate<XX,0,0>}
     #declare XX=XX+.3;
  #end
}
#declare Stair_Support=object{
  box{<-.05,0,0><.05,.4,3> texture{Wood1} rotate<-38,0,0>}
}
#declare Stairs=union{
  #declare CountT=0;  // Tread
  #declare CountR=0;  // Rise
  #while (CountR<1.5)
     box{<-.752,CountR-2.6,CountT><.752,CountR+.05-2.6,CountT+.23> texture{Wood1}}
     #declare CountR=CountR+.15;  // approx 6 inches
     #declare CountT=CountT+.23;  // approx 9 inches
  #end
}
#declare Stair_RailsL=union{
  object{Stair_Support translate<-.75,-3,0>}
  object{Stairs}
}
#declare Stair_RailsR=union{
  object{Stair_Support translate<.75,-3,0>}
  object{Stairs}
}
        
#declare Bay=union{ 

#ifndef(BayLightOn)
  light_source{<1.5,1.5,1.5> color Orange fade_distance 1.5 fade_power 2}
  light_source{<1.5,4.8,-1.5> color Orange fade_distance 1.5 fade_power 2}
  light_source{<1.5,8.2,1.5> color Orange fade_distance 1.5 fade_power 2}
#end                                     
  box{<-1.8,-1,-1.5><1.8,0,-1.49> texture{Wood2}}  // panel to block under bays
  object{Timber translate<-1.8,-1,-1.8>}
  object{Timber translate<-2.3,-1,1.85>}
  object{Timber translate<2.3,-1,1.85>}
  object{Timber translate<1.8,-1,-1.8>}

  object{Timber translate<-1.8,0,-1.8>}
  object{Timber translate<-2.3,0,1.85>}
  object{Timber translate<2.3,0,1.85>}
  object{Timber translate<1.8,0,-1.8>}
  
  box{<-2.2,-1,1.8><2.2,5,1.84> texture{pigment{color Wheat}}} // outer wall
  box{<-2.3,5,1.75><2.3,5.2,1.85> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.3,6,1.75><2.3,6.2,1.85> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.2,6.2,1.8><2.2,10.8,1.84> texture{pigment{color Wheat}}} // outer wall 
  box{<-2.2,5,1.8><-1.4,6,1.84> texture{pigment{color Wheat}}} 
  box{<-.8,5,1.8><.8,6,1.84> texture{pigment{color Wheat}}}
  box{<1.4,5,1.8><2.2,6,1.84> texture{pigment{color Wheat}}}
  box{<-1.6,5,1.75><-1.4,6,1.85> texture{Wood1}}
  box{<-.8,5,1.75><-.6,6,1.85> texture{Wood1}}
  box{<.6,5,1.75><.8,6,1.85> texture{Wood1}}  
  box{<1.4,5,1.75><1.6,6,1.85> texture{Wood1}}
  
  object{Frame translate<0,0,0>}
  object{Frame_Seats}
//  object{Frame translate<0,3.1,0>}  

  object{Frame2 translate<0,3.3,0>}   // base of 2nd floor   
//  object{Frame_Seats2 translate<0,3.3,0>}

  object{Timber translate<-1.6,3.70,-3>}
  object{Timber translate<-2.3,3.70,1.85>}
  object{Timber translate<2.3,3.70,1.85>}
  object{Timber translate<1.6,3.70,-3>}    

  object{Rail2 translate<0,4.0,-3>}  

  object{Frame3 translate<0,7,0>}     // base of 3rd floor
  object{Frame_Seats3 translate<0,7,0>}
  
  object{Timber translate<-1.4,7.4,-4>}
  object{Timber translate<-2.3,7.4,1.85>}
  object{Timber translate<2.3,7.4,1.85>}
  object{Timber translate<1.4,7.4,-4>}
                                    
  object{Rail2 translate<0,7.7,-4>}                                    
                                    
  object{FrameR translate<0,10.7,0>}  // roof frame
  
}

#declare BayStage=union{ 
//  object{Timber translate<-1.85,-1,-1.85>}
  object{Timber translate<-2.3,-1,1.85>}
  object{Timber translate<2.3,-1,1.85>}
//  object{Timber translate<1.85,-1,-1.85>}

//  object{Timber translate<-1.85,0,-1.85>}
  object{Timber translate<-2.3,0,1.85>}
  object{Timber translate<2.3,0,1.85>}
//  object{Timber translate<1.85,0,-1.85>}
  
  box{<-2.2,-1,1.8><2.2,5,1.84> texture{pigment{color Wheat}}} // outer wall
  box{<-2.3,5,1.75><2.3,5.2,1.85> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.3,6,1.75><2.3,6.2,1.85> texture{Wood1 rotate<0,90,0>}} 
  box{<-2.2,6.2,1.8><2.2,10.8,1.84> texture{pigment{color Wheat}}} // outer wall 
  box{<-2.2,5,1.8><-1.4,6,1.84> texture{pigment{color Wheat}}} 
  box{<-.8,5,1.8><.8,6,1.84> texture{pigment{color Wheat}}}
  box{<1.4,5,1.8><2.2,6,1.84> texture{pigment{color Wheat}}}
  box{<-1.6,5,1.75><-1.4,6,1.85> texture{Wood1}}
  box{<-.8,5,1.75><-.6,6,1.85> texture{Wood1}}
  box{<.6,5,1.75><.8,6,1.85> texture{Wood1}}  
  box{<1.4,5,1.75><1.6,6,1.85> texture{Wood1}}

//  object{Rail2 translate<0,.4,-1.85>}
    
  object{Frame translate<0,0,0>}
//  object{Frame translate<0,3.1,0>}  
  
//  object{Frame2 translate<0,3.3,0>}   // base of 2nd floor   
//  object{Timber translate<-1.6,3.70,-3>}
  object{Timber translate<-2.3,3.70,1.85>}
  object{Timber translate<2.3,3.70,1.85>}
//  object{Timber translate<1.6,3.70,-3>}    

//  object{Rail2 translate<0,4.0,-3>}  

//  object{Frame3 translate<0,7,0>}     // base of 3rd floor  
//  object{Timber translate<-1.4,7.4,-4>}
  object{Timber translate<-2.3,7.4,1.85>}
  object{Timber translate<2.3,7.4,1.85>}
//  object{Timber translate<1.4,7.4,-4>}
                                    
//  object{Rail2 translate<0,7.7,-4>}                                    
                                    
  object{FrameR translate<0,10.7,0>}  // roof frame
  
}
#declare BayL=union{  // bay w stairs on the left
  object{Bay}
  object{Rail1 translate<0,.6,-1.85>}
  object{Post1 translate<.75,.4,-1.86>}
  object{Stair_RailsL translate<1.2,1.4,-4.2>}
}
#declare BayR=union{  // bay w stairs on the right
  object{Bay}
  object{Rail1 translate<.9,.6,-1.85>}
  object{Post1 translate<-.75,.4,-1.86>}
  object{Stair_RailsR translate<-1.2,1.4,-4.2>}  
}
#declare BayDoor=union{  // Bay w entry through center
  difference{
    object{Bay}
    box{<-1.25,-1.1,-2.5><1.25,1.5,1.7> texture{Wood1}}
    box{<-1,-1.1,1.6><1,1.5,2> texture{Wood1}}
  }
  difference{
    box{<-1.1,-1,1.75><1.1,1.7,1.85> texture{Wood1}}  // door 
    box{<-.9,-1.1,1.74><.9,1.5,1.86> texture{Wood1}}
  }
  box{<-.9,-1.1,1.77><.01,1.49,1.78> texture{Wood2 rotate<90,90,0>}}
  box{<.01,-1.1,1.77><.9,1.49,1.78> texture{Wood2 rotate<90,90,0>}}
  
  box{<-1.26,-1.1,-1.5><-1.25,.4,1.85> texture{Wood2}}
  box{<1.25,-1.1,-1.5><1.26,.4,1.85> texture{Wood2}}
  
  object{Stair_RailsL translate<1.8,1.4,-4.2>}  
  object{Stair_RailsR translate<-1.8,1.4,-4.2>} 
}

#declare BayStairs=union{
  box{<-1.85,-1,-1.85><1.85,10.7,1.85> texture{pigment{color Wheat}}} 
  triangle{<-1.85,11.1,1.85><0,15,1.85><1.85,11.1,1.85> texture{pigment{color Wheat}}}
  triangle{<-1.85,11.1,1.9><0,15,1.9><-1.85,11.1,-5> texture{RoofText103}}
  triangle{<-1.85,11.1,-5><0,15,1.9><0,15,-5> texture{RoofText103}}
  triangle{<1.85,11.1,1.9><0,15,1.9><1.85,11.1,-5> texture{RoofText103}}
  triangle{<1.85,11.1,-5><0,15,1.9><0,15,-5> texture{RoofText103}}
    
  box{<-1.95,-1,-1.95><-1.75,10.7,-1.75> texture{Wood1}}
  box{<1.75,-1,-1.95><1.95,10.7,-1.75> texture{Wood1}}  
  box{<-1.93,.1,-1.93><1.93,.4,1.93> texture{Wood1}}
  box{<-1.93,3.3,-1.93><1.93,3.7,1.93> texture{Wood1}}
  box{<-1.93,7,-1.93><1.93,7.4,1.93> texture{Wood1}}
  box{<-1.93,10.7,-1.93><1.93,11.1,1.93> texture{Wood1}}
} 



// STAGE *******************************************<<<===
#declare Qarch=difference{
  cylinder{<0,0,-.12><0,0,.12> 1}
  cylinder{<0,0,-.121><0,0,.121> .8}
  box{<-.01,-1.2,-.21><1.2,1.2,.21> }
  box{<-1.2,-1.2,-.21><0,0,.21>}
  texture{T_Wood1}
}
#declare TrimBox=union{
  difference{
    box{<-.35,.15,-.451><.35,.85,.451> }
    box{<-.3,.2,-.452><.3,.8,.452> }
    texture{T_Wood1 scale .25}
  }
  box{<-.1,.35,-.451><.1,.6,.451> texture{T_Wood1 scale .25 rotate<0,45,0>}}
}
#declare Leaf1=difference{
   torus{.08,.01 rotate<90,0,0>}
   sphere{<0,-.05,.02>.12}
   box{<.01,-.1,-.1><.1,.1,.1>}
  texture{pigment{color Gold}}
}     
#declare Leaf=union{
  #declare Count=0;
  #while (Count<65)
      object{Leaf1 rotate<0,Count,0>}
      #declare Count=Count+10;
  #end
  rotate<0,0,0>
}
#declare Column=union{
  box{<-.451,0,-.451><.451,.05,.451> texture{T_Wood1 scale .25}}
  box{<-.45,0,-.45><.45,.1,.45> texture{T_Wood1 scale .25}}
  box{<-.425,0,-.425><.425,1,.425> texture{T_Wood2 scale .25}}
  box{<-.451,.99,-.451><.451,1,.451> texture{T_Wood1 scale .25}}  
  box{<-.45,.9,-.45><.45,1,.45> texture{T_Wood1 scale .25}}
  object{TrimBox}
  object{TrimBox rotate<0,90,0>}

  cone{<0,1,0>.35 <0,6,0> .25 texture{T_Stone21 scale 1.25}}
  torus{.35,.09 translate<0,1.03,0> texture{pigment{color Gold}}}
  torus{.35,.06 translate<0,1.09,0> texture{pigment{color Gold}}}
                                                                
  cone{<0,5.5,0>.28 <0,6,0>.35 texture{pigment{color Gold}}}                                                                   
  torus{.28,.07 translate<0,5.59,0> texture{pigment{color Gold}}}
  torus{.28,.06 translate<0,5.53,0> texture{pigment{color Gold}}}

  #declare Count=0;
  #while (Count<=360)
     box{<-.23,6,-.23><.23,6.75,.23> rotate<0,Count+22.5,0> texture{T_Wood1 scale .25}}
     object{Leaf scale 2.5 translate<-.30,5.75,0> rotate<0,Count,0>}
     object{Leaf scale 2 translate<-.280,5.65,0> rotate<0,Count+22.5,0>}
     #declare Count=Count+45;
  #end

  cylinder{<0,5.9,0><0,6.1,0> .33 texture{T_Wood1 scale .25 rotate<45,0,0>}}
  torus{.32,.06 translate<0,6,0> texture{pigment{color Gold}}}
                                                                     
  object{Qarch translate<1,6,0>}
  object{Qarch translate<1,6,0> rotate<0,90,0>}
  object{Qarch translate<1,6,0> rotate<0,180,0>}
  object{Qarch translate<1,6,0> rotate<0,-90,0>}
}


#declare Column2=union{
//  box{<-.2,0,-.2><.2,.15,.2> texture{T_Stone2}}
  cylinder{<0,0,0><0,.15,0> .25 texture{T_Stone2}}
  torus{.17,.05 translate<0,.18,0> texture{T_Stone1}}
  cone{<0,0,0>.17 <0,2.7,0> .13 texture{T_Stone1}}
  cylinder{<0,2.75,0><0,2.95,0> .2 texture{T_Stone1}}
  torus{.15,.04 translate<0,2.7,0> texture{T_Stone1}}
}
#declare Column3=union{
  box{<-.17,0,-.17><.17,.15,.17> texture{T_Stone18}}
  cone{<0,0,0>.12 <0,2.95,0> .13 texture{T_Stone1}}
  cylinder{<0,2.95,0><0,3.05,0> .15 texture{T_Stone1}}
  torus{.15,.04 translate<0,2.9,0> texture{T_Stone1}}
}
#declare Stage_Deco=union{
    box{<.2,0,-.75><0,1.7,.75> texture{T_Stone2}}
    box{<-.1,.05,-.70><.12,1.65,.7> texture{T_Stone18}}
    box{<-.15,.2,-.55><-.1,1.5,.55> texture{T_Stone2}}
    box{<-.2,.35,-.4><-.15,1.35,.4> texture{T_Stone18 rotate<0,0,38>}}
    torus{.25,.02 rotate<0,0,90> translate<-.2,.85,0> texture{pigment{color Gold}}}
}                    
#declare Railing=union{
  box{<.05,4.25,-.51><.15,4.35,.51> texture{Wood2}}      // top rail
  box{<.05,3.35,-.51><.15,3.45,.51> texture{Wood2}}      // bottom rail 
  #declare XX=-.4;
  #while (XX<=.4)
     object{Balus translate<.1,3.25,XX>}
     #declare XX=XX+.2;
  #end
}
#declare StageDoor=union{
  object{Column2 translate<0,0,-.95>}                    // stage level
  object{Column2 translate<0,0,-1.55>}
  object{Column2 translate<0,0,.95>}
  object{Column2 translate<0,0,1.55>}  
  
  object{Column3 translate<-.41,3.7,-.95>}               // 2nd floor
  object{Column3 translate<-.41,3.7,-1.55>}
  object{Column3 translate<-.41,3.7,.95>}
  object{Column3 translate<-.41,3.7,1.55>}  
  
  box{<-.4,0,-.5><-.42,3.2,.5> texture{Wood1 scale .5 rotate<90,0,0>}}           // door
  object{Stage_Deco rotate<0,180,0> translate<.20,2.8,-1.2>}
  object{Stage_Deco rotate<0,180,0> translate<.20,2.8,1.2>}
//  box{<.2,3.3,-1.7><0,5,-.5> texture{T_Stone2}}
//  box{<.2,3.3,.5><0,5,1.7> texture{T_Stone2}}

  object{Railing}
}     

#declare CenterRail=union{  
  box{<.05,4.25,-5><.15,4.35,-2> texture{Wood2}}      // top rail left side
  box{<.05,3.35,-5><.15,3.45,-2> texture{Wood2}}   // bottom rail    
  box{<.05,4.25,5><.15,4.35,2> texture{Wood2}}      // top rail right side
  box{<.05,3.35,5><.15,3.45,2> texture{Wood2}}   // bottom rail  
  #declare XX=-4;
  #while (XX<=-2)
     object{Balus translate<.1,3.25,XX>}
     object{Balus translate<.1,3.25,abs(XX)>}
     #declare XX=XX+.25;
  #end
  box{<.3,4.25,-1><.2,4.35,1> texture{Wood2}}  // top rail center
  box{<.3,3.35,-1><.2,3.45,1> texture{Wood2}} // bottom rail center
  #declare XX=-.75;
  #while (XX<=.75)
     object{Balus translate<.25,3.25,XX>}
     #declare XX=XX+.25;
  #end
  box{<.35,2.95,-2><0,4.4,-.85> texture{T_Stone2}}
  box{<.35,2.95,2><0,4.4,.85> texture{T_Stone2}}  
  object{Column2 translate<0,0,-1.6>}                    // stage level center pillars
  object{Column2 translate<0,0,1.6>}  
  object{Column3 translate<-.41,3.7,-1.6>}               // 2nd floor
  object{Column3 translate<-.41,3.7,1.6>}
}

#declare Roof_Beam1=box{<-.025,-.075,-7.2><.025,.075,7.2> texture{Wood1}}  
#declare Roof_Beam2=box{<-10,-.075,-.025><.20,.075,.025> texture{Wood1}}
#declare Stage_Roof=union{  
  box{<-2.45,8.5,-7><-2.55,8.8,7> texture{Wood1}}  // cross beam of stage  
  box{<-10,8.5,-3.85><0,8.8,-3.75> texture{Wood1}}
  box{<-10,8.5,3.75><0,8.8,3.85> texture{Wood1}}

#declare XX=-0.025;
#while (XX>-10)
  object{Roof_Beam1 translate<XX,8.82,0>}
  #declare XX=XX-1;
#end
#declare ZZ=-6.9;
#while (ZZ<=6.9)
  object{Roof_Beam2 translate<0,8.82,ZZ>}
  #declare ZZ=ZZ+.9857;
#end 

  box{<-2,8.83,-4><-8,8.84,4> texture{pigment{color MidnightBlue}}}
                                            
  #declare RB=8.82+.075;                                            
  #declare RF1=1.5;
  #declare RFP=6;    // Roof Peak 
  
  triangle{<-10.5,RB,-7><-10.5,RB+RF1,-5><0,RB,-7> texture{RoofText103}}
  triangle{<-10.5,RB+RF1,-5><-2,RB+RF1,-5><0,RB,-7> texture{RoofText103 }}
  
  triangle{<-10.5,RB,7><-10.5,RB+RF1,5><0,RB,7> texture{RoofText103 }}
  triangle{<-10.5,RB+RF1,5><-2,RB+RF1,5><0,RB,7> texture{RoofText103 }}
  
  triangle{<0,RB,-7><-2,RB+RF1,-5><-2,RB+RF1,5> texture{RoofText103 rotate<0,90,0> }}
  triangle{<0,RB,-7><-2,RB+RF1,5><0,RB,7> texture{RoofText103 rotate<0,90,0> }} 
  
  triangle{<-2,RB+RF1,-5><-2,RB+RF1,5><-2,RB+RFP,0> texture{pigment{color Wheat}}}   
  triangle{<-10,RB+RF1,-5><-10,RB+RF1,5><-10,RB+RFP,0> texture{pigment{color Wheat}}} 
    
  triangle{<-2,RB+RF1,-5><-2,RB+RFP,0><-16.5,RB+RFP,0> texture{RoofText103 }}
  triangle{<-2,RB+RF1,-5><-16.5,RB+RFP,0><-16.5,RB+RF1,-5> texture{RoofText103 }}                                                                                                  
  triangle{<-2,RB+RF1,5><-2,RB+RFP,0><-16.5,RB+RFP,0> texture{RoofText103 }}
  triangle{<-2,RB+RF1,5><-16.5,RB+RFP,0><-16.5,RB+RF1,5> texture{RoofText103 }}                                                                                                         

  box{<-.1,0,-.1><.1,RFP-RF1-.2,.1> translate<-1.98,RB+RF1,0> texture{T_Wood1 scale .25 rotate<90,0,0>}}   
  box{<-.1,0,-.1><.1,RFP/2,.1> rotate<45,0,0> translate<-1.97,RB+RF1,0> texture{T_Wood1 scale .25 rotate<-45,0,0>}}   
  box{<-.1,0,-.1><.1,RFP/2,.1> rotate<-45,0,0> translate<-1.97,RB+RF1,0> texture{T_Wood1 scale .25 rotate<45,0,0>}}       
 
  box{<-.1,-.3,-.1><.1,RFP+.2,.1> rotate<49.,0,0> translate<-1.975,RB+RF1,-4.7> texture{T_Wood1 scale .25 rotate<-45,0,0>}}   
  box{<-.1,-.3,-.1><.1,RFP+.2,.1> rotate<-49.,0,0> translate<-1.975,RB+RF1,4.7> texture{T_Wood1 scale .25 rotate<45,0,0>}}       
    

}  

                                      
#declare Stage=union{
#ifndef(StageLightOn)
  light_source{<-.75,1.65,0> color Orange fade_distance 3.0 fade_power 2}
  light_source{<-.75,1.65,-1.5> color Yellow fade_distance 2.0 fade_power 2}
  light_source{<-.75,1.65,1.5> color Orange fade_distance 3.0 fade_power 2}
  light_source{<-.75,1.65,4.5> color Orange fade_distance 3.0 fade_power 2}
  light_source{<-.75,1.65,-6.0> color Orange fade_distance 4 fade_power 2}    
    
#end
  box{<-9.6,0,-7.61><0,1.5,7.61> texture{T_GrayBrick scale .0625}}
  box{<-12.65,1.5,-7.65><0.05,1.6,7.65> texture{pigment{checker Gray90,Gray80}}}
  
  object{Column translate<-2.5,1.6,-3.8>}
  object{Column translate<-2.5,1.6,3.8>} 

  object{Stage_Roof}
//  box{<-2.45,8.5,-7><-2.55,8.8,7> texture{Wood1}}  // cross beam of stage  
//  box{<-10,8.5,-4.85><0,8.8,-4.75> texture{Wood1}}
//  box{<-10,8.5,4.75><0,8.8,4.85> texture{Wood1}}
  
                               
  difference{                               
      box{<-9.6,0,-7.60><-10,4.7,7.60> }
      box{<-9.5,1.6,-6.5><-10.1,3.7,-5.5>}       // left door
      cylinder{<-9.5,3.7,-6><-10.1,3.7,-6> .5 }
      box{<-9.5,1.6,6.5><-10.1,3.7,5.5> }        // right door
      cylinder{<-9.5,3.7,6><-10.1,3.7,6> .5 }
      box{<-9.5,1.6,-1><-10.1,4,1> }     // center door
    texture{T_TanBrick scale .0623}
  }
  
  difference{
    box{<-9.45,1.6,-1.1><-10.15,4.1,1.1>}
    box{<-9.44,1.6,-.91><-10.2,3.91,.91> }        // center door trim
   texture{T_Wood11}
  }
  object{StageDoor translate<-9.5,1.60,-6>}
  object{StageDoor translate<-9.5,1.60,6>} 
  object{CenterRail translate<-9.5,1.6,0>}

// object{Column2 translate<-5.4,1.60,-5.2>}
// object{Column2 translate<-5.4,1.60,-4.8>}
// object{Column2 translate<-5.4,1.60,-3>}
// object{Column2 translate<-5.4,1.60,-1.6>} 
// object{Column2 translate<-5.4,1.60,5.2>}
// object{Column2 translate<-5.4,1.60,4.8>}
// object{Column2 translate<-5.4,1.60,3.0>} 
// object{Column2 translate<-5.4,1.60,1.6>}
 
 box{<-9.5,4.7,-7.6><-12,4.85,7.6> texture{Wood1}}

// 2nd floor of stage
  difference{                               
      box{<-10,4.85,-7.60><-10.3,8.4,7.60> }
      box{<-9.95,4.9,-6.5><-10.4,7.3,-5.5> } // left door
      box{<-9.95,4.9,6.5><-10.4,7.3,5.5> }   // right door
      box{<-9.95,4.9,-.75><-10.4,7.3,.75> }  // center door
    texture{T_TanBrick scale .0623} 
  }          
  difference{
      box{<-9.93,4.9,-6.6><-10.43,7.4,-5.4> } // left door
      box{<-9.8,4.9,-6.49><-10.44,7.29,-5.29>}
     texture{T_Wood11}
  }
  difference{    
      box{<-9.93,4.9,6.6><-10.43,7.4,5.4> }   // right door
      box{<-9.8,4.9,6.49><-10.44,7.29,5.29>}
     texture{T_Wood11}
  }
  difference{
      box{<-9.93,4.9,-.85><-10.43,7.4,.85> }  // center door
      box{<-9.8,4.9,-.74><-10.44,7.29,.74>}
     texture{T_Wood11}
  }

  box{<-9.7,8.4,-7.65><-10.3,8.6,7.65> texture{T_TanBrick scale .03125}}
  box{<-9.5,8.6,-7.7><-10.3,9,7.7> texture{T_TanBrick scale .03125}} 
//  box{<-6.3,6.8,-5.2><0,6.85,5.2> texture{pigment{color Blue}}}
  
     
}

//-----------------------------------------
// place chairs across front of stage

#declare CC=1;
#declare C1=-4;  // First chair at
#declare S1=seed(383);  
#while (CC<=10)            
  #declare ROY=rand(S1)*360;
  #declare RX=rand(S1)*2-1;
  object{Chair rotate<0,ROY,0> translate<RX,-.8,C1>}
  #declare C1=C1+rand(S1)*1+1;
  #declare CC=CC+1;
#end
  



//--------------------------------------------------------------
//  object{Timber translate<-1.6,3.70,-3>}
//  object{Timber translate<-2.3,3.70,1.85>}
//  object{Timber translate<2.3,3.70,1.85>}
//  object{Timber translate<1.6,3.70,-3>}    

#ifndef(Special)
#declare Count=4;
#while (Count<20)
  object{Lamp translate<-2.35,6.20,1.7> translate<0,0,16> rotate<0,Count*14-45,0>}     
  object{Lamp translate<-1.63,6.20,-2.85> translate<0,0,16> rotate<0,Count*14-45,0>}  
  #declare Count=Count+1;
#end


//#declare Lamps=union{
//  object{Lamp translate<1.2,1.,-.9>}  
//  object{Lamp translate<1,6.075,.5>}  
//  object{Lamp translate<-.71,8.95,-.45>}
//} 
//
//  object{Lamps translate<0,0,16> rotate<0,1*14-45,0>} 
//  object{Lamps translate<0,0,16> rotate<0,19*14-45,0>}
//  object{Lamps translate<0,0,16> rotate<0,20*14-45,0>}  
#end // ifndef(Special)  


//object{Gentlemen_Room translate<0,3.3,0> rotate<0,-90,0>}
//object{Frame_Seats2 translate<0,3.3,0> rotate<0,-90,0>}
//object{BayDoor rotate<0,-90,0>}  
 
//#declare Stuff=union{
cylinder{<0,-1,0><0,-.9,0> 16000 texture{pigment{color Khaki}}}              
cylinder{<0,-1,0><0,-.8,0> 16 texture{checker texture{T_Stone13},texture{T_Stone21} scale .5 rotate<0,45,0>}}

// Apply seating to 2nd floor w/ exception to 3 Gentlemen's rooms on either side of stage
#declare B1=3;
#while (B1<17)
   object{Frame_Seats2 translate<0,3.3,16> rotate<0,B1*14-45,0>}
   #declare B1=B1+1;
#end
//--------------------    
#declare B1=0;
#while (B1<3)
   object{Gentlemen_Room translate<0,3.3,16> rotate<0,B1*14-45,0>}
   #declare B1=B1+1;
#end
//--------------------    
#declare B1=17;
#while (B1<20)
   object{Gentlemen_Room translate<0,3.3,16> rotate<0,B1*14-45,0>}
   #declare B1=B1+1;
#end
//--------------------    
// Position bays by hand

object{BayR translate<0,0,16> rotate<0,0*14-45,0>}
object{BayL translate<0,0,16> rotate<0,1*14-45,0>}
object{BayDoor translate<0,0,16> rotate<0,2*14-45,0>}

object{BayR translate<0,0,16> rotate<0,3*14-45,0>}
object{BayL translate<0,0,16> rotate<0,4*14-45,0>}
object{BayDoor translate<0,0,16> rotate<0,5*14-45,0>}

object{BayR translate<0,0,16> rotate<0,6*14-45,0>}
object{BayL translate<0,0,16> rotate<0,7*14-45,0>}
object{BayDoor translate<0,0,16> rotate<0,8*14-45,0>}

object{BayR translate<0,0,16> rotate<0,9*14-45,0>}
object{BayL translate<0,0,16> rotate<0,10*14-45,0>}

object{BayR translate<0,0,16> rotate<0,13*14-45,0>}
object{BayL translate<0,0,16> rotate<0,12*14-45,0>}
object{BayDoor translate<0,0,16> rotate<0,11*14-45,0>}

object{BayR translate<0,0,16> rotate<0,16*14-45,0>}
object{BayL translate<0,0,16> rotate<0,15*14-45,0>}
object{BayDoor translate<0,0,16> rotate<0,14*14-45,0>}

object{BayR translate<0,0,16> rotate<0,19*14-45,0>}
object{BayL translate<0,0,16> rotate<0,18*14-45,0>}
object{BayDoor translate<0,0,16> rotate<0,17*14-45,0>}


#declare SAVE=union{
#declare B1=0;
#while (B1<20)
   object{BayL translate<0,0,16> rotate<0,B1*14-45,0>}
   #declare B1=B1+2;
#end
//--------------------              
#declare B1=1;
#while (B1<20)
   object{BayR translate<0,0,16> rotate<0,B1*14-45,0>}
   #declare B1=B1+2;
#end
//--------------------
}  // end save

  
//**** stage wall...............  
#declare B1=20;
#while (B1<=25)
   object{BayStage translate<0,0,16> rotate<0,B1*14-45,0>}
   #declare B1=B1+1;
#end
                    

object{BayStairs translate<0,0,19.7> rotate<0,6*14-40,0>}
object{BayStairs translate<0,0,19.7> rotate<0,12*14-40,0>}

object{Stage translate<-1.5,-.80,0>}
//}  // end stuff 

#ifdef(Fog)
fog {                                                 // White ground fog
  distance 20
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 1.5
  fog_alt .5
  turbulence 3.0
  turb_depth 1.0
}
#end