
// Glenn's POV-Ray Scene File - Hatteras Lighthouse
// created 21-Jul-99
// last update 30-Aug-99
// copyright 1999 Glenn McCarter (gmccarter@hotmail.com)

//#include "Colors.inc"
#include "GIncludeRH.inc"
//#include "GRuler.inc"
#declare GoodClouds = 0; // 1 turns on real clouds, 0 uses simple spheres
#include "Clouds.inc" // Clouds
#include "ClipperShip.inc" // Clipper ship
#include "Lighthouse.inc" // Cape Hatteras Lighthouse

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

// Scene scale is 1 inches = 1 unit
// Scene origin is at base of lighthouse tower
#declare LO = <-6*Feet,0,3340*Feet>; // Local Origin, near camera

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     0.0,  1.0>
		sky       <-0.05,     1.0,  0.0>  // Use left handed-system
//		sky       <0.0,     1.0,  0.0>  // Use left handed-system
		up        <0.0,     1.0,  0.0>  // Where Y is up
		right     <1.33333, 0.0,  0.0>
		angle 8
		location  <-0, 3*Feet, 3660*Feet>
		look_at   <-140*Feet, 110*Feet, 0.0*Feet>
	}
#declare Special_Cam = // move this camera anywhere for testing
	camera {
		perspective
		direction <0.0,     0.0,  1.0>
		sky       <0.0,     1.0,  0.0>  // Use left handed-system
		up        <0.0,     1.0,  0.0>  // Where Y is up
		right     <1.33333, 0.0,  0.0>
	angle 40
//	location  <0,220*Feet,-90*Feet>
//	look_at   <0,210*Feet,0*Feet> // lookdown tower top
//	location  <0,185*Feet,-90*Feet>
//	look_at   <0,200*Feet,0*Feet> // lookup tower top
	location  <0,18*Feet,-90*Feet>
	look_at   <0,10*Feet,0*Feet> // tower base
//	location  <-30*Feet,45*Feet,190*Feet>
//	look_at   <-30*Feet,0*Feet,-150*Feet> // buildings
//	location  <-30*Feet,350*Feet,800*Feet>
//	look_at   <-30*Feet,0*Feet,-150*Feet> // beach chopper view
	}

camera {
//	Special_Cam
	Render_Cam
	}


//===============================================
//             Textures
//===============================================


#declare WhiteBuildingTex =
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .34 specular .65 roughness .125 }
	}

#declare RoofTex =
	texture {
		pigment { color rgb <0.263,0.161,0.094> }
		finish { ambient .10 specular .17 roughness .185 }
	}

#declare ChimneyTex =
	texture {
		pigment { color rgb <0.631,0.408,0.290> }
		finish { ambient .08 specular .37 roughness .125 crand .3 }
	}


#declare SeaFloorTex =
	texture {
		pigment { color rgb <0.471,0.459,0.306> }
		normal { bumps 0.6 scale 2*Feet }
		finish { ambient .1 specular .62 roughness .033 }
	}

#declare BeachTex =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.00 color rgb <0.914,0.855,0.602> ]
					[ 0.30 color rgb <0.800,0.910,0.671> ]
					[ 0.32 color rgb <0.00,0.10,0.10> ]
					[ 0.38 color rgb <0.800,0.910,0.671> ]
					[ 1.00 color rgb <0.914,0.855,0.602> ]
				}
				turbulence .26
				octaves 6
				lambda 2.5
				omega 0.75
				scale 35*Feet
//			color rgb<.06,.06,.043>
			}
		normal { bumps .38 scale 1.5 } 
		finish { ambient .4 specular .7 roughness .07 }
//		finish { ambient .2 metallic brilliance 5 specular .92 roughness .008 reflection .2 }
//		finish { ambient .2 metallic brilliance 5 specular .92 roughness .008 reflection 0 }
	}
#declare FarLandTex =
	texture {
//		pigment { color rgb <0.667,0.620,0.333> }
		pigment {
			bozo
				color_map {
					[ 0.00 color rgb <0.667,0.620,0.333> ]
					[ 0.30 color rgb <0.700,0.610,0.371> ]
					[ 0.32 color rgb <0.00,0.50,0.10> ]
					[ 0.38 color rgb <0.600,0.610,0.371> ]
					[ 1.00 color rgb <0.667,0.620,0.333> ]
				}
				turbulence .16
				octaves 6
				lambda 2.5
				omega 0.75
				scale 15*Feet
			}
		normal { bumps .38 scale 1.5 } 
		finish { ambient .4 specular .7 roughness .07 }
	}
#declare FadeLandTex =
	texture {
		pigment {
			gradient y
				color_map {
					[ 0.00 color rgb <0.353,0.353,0.220> ]
					[ 0.40 color rgb <0.353,0.353,0.220> ]
					[ 0.47 color rgbf <1,1,1,1> ]
				}
				turbulence .16
				octaves 6
				lambda 2.5
				omega 0.75
				scale <50*Feet,20*Feet,20*Feet>
			}
		normal { bumps .38 scale 1.5 } 
		finish { ambient .4 specular .7 roughness .07 }
	}

#declare WaterTex =
		texture {
//		pigment { color rgb <0.125,0.212,0.267> } // test blue
//		pigment { color rgb <0.4,0.4,0.4> } // test grey
		pigment {
			granite
			color_map {
/*
				[ 0.00 color rgb <0.125,0.212,0.267> ]
				[ 0.30 color rgb <0.125,0.212,0.267> ]
				[ 0.34 color rgb <0.175,0.310,0.337> ]
				[ 0.40 color rgb <0.175,0.310,0.337> ]
				[ 0.43 color rgb <0.125,0.212,0.267> ]
				[ 1.00 color rgb <0.125,0.212,0.267> ]
*/

				[ 0.00 color rgb <0.125,0.162,0.087> ]
				[ 0.30 color rgb <0.178,0.212,0.117> ]
				[ 0.34 color rgb <0.235,0.310,0.137> ]
				[ 0.40 color rgb <0.235,0.310,0.137> ]
				[ 0.43 color rgb <0.178,0.212,0.117> ]
				[ 1.00 color rgb <0.125,0.162,0.087> ]

//				[ 0.00 color rgb <0.125,0.165,0.085> ]
			}
			scale 100
		}
		normal { bumps .63 scale <1.6,1,1>*0.46*Feet }
//		normal { crackle .6  scale <1.6,1,1>*0.16*Feet }
/*
		normal { bozo 4.0 scale <1.9,1,1>*.41*Feet
			slope_map {
			[0   <0, 1>]   // start at bottom and slope up
			[0.5 <1, 1>]   // halfway through reach top still climbing
			[0.5 <1,-1>]   // abruptly slope down
			[1   <0,-1>]   // finish on down slope at bottom
			}
		 }
*/
		finish { ambient .06 metallic specular .99 roughness .048 reflection 0.120 }
		}

#declare WaterTexT = // test
	texture {
		pigment { color rgbf<1,1,1,0> }
		finish { ambient .0 specular .92 roughness .008 reflection 0 }
	}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,-7*Feet> }
//object {StdBulb60Watt translate <-10*Feet,8*Feet,2*Feet> }

#declare SpecialSpotLight1 =
	light_source {
		<-4,2,-4>
//		color rgb <0.890,0.525,0.361>*1.0
		color rgb <1,1,1>*1.0
		spotlight
		point_at <-2,2,0>
		radius 20    // degrees fully lit (*2)
		falloff 42   // degrees no lighting (*2)
		tightness 1
		media_interaction off
		fade_distance 1.4
		fade_power 1
//		shadowless
	}
//object { SpecialSpotLight1 }

#declare Sun =
	light_source {
		<150*Miles,110*Miles,-80*Miles>
//		color rgb <0.890,0.525,0.361>*1.0
//		color rgb <1,1,1.5>*1.6
		color rgb <0.680,0.663,0.431>*2.4
		fade_distance 148*Miles
		fade_power 1
	}
object { Sun }

#declare SkyFill =
	light_source {
		<-.5*Miles,18*Miles,1*Miles>
//		color rgb <0.890,0.525,0.361>*1.0
//		color rgb <1,1,1.5>*1.6
		color rgb <0.580,0.463,0.831>*0.4
		spotlight
		point_at LO
		radius 4    // degrees fully lit (*2)
		falloff 8   // degrees no lighting (*2)
		tightness 1
		media_interaction off
		fade_distance 24*Miles
		fade_power 1
	}
object { SkyFill }

#declare TestCyl =
cone {
	<-14,2,44>,0.2,<0,2,50>,1.5
	texture { pigment { color rgb<1,1,1> } finish { ambient .8} }
}
//object { TestCyl }

//===============================================
//             Environment
//===============================================

//background { color rgb <0.0, 0.0, 0.0> } // black
background { color rgb <0.2, 0.4, 0.8> } // light blue
//background { color rgb <0.01, 0.01, 0.09> } // dark blue
/*
sky_sphere {
	pigment {
		gradient y
		color_map {
			[ 0.00 color rgb<0.62,0.72,.58> ] //
//			[ 0.03 color rgb<0.62,0.68,.38> ] // yellow just above horizon
			[ 0.03 color rgb<0.32,0.48,.68> ] // blue just above horizon
//			[ 0.30 color rgb<0.42,0.55,.78> ] // blue near top of image
			[ 0.30 color rgb<0.62,0.65,.68> ] // grey near top of image
			[ 0.40 color rgb<0.58,0.42,0.56> ] // 
			[ 1.00 color rgb<0.30,0.32,0.46> ] // zenith
		}
	}
}
*/

#declare SkyTex1 = // clear blue white sky
	texture {
		pigment { color rgb <1,1,1> }
		finish { ambient .6 }
	}
#declare SkyTex2 = // turbulent purple storm clouds
	texture {
//		pigment { color rgb <.1,.1,1> }
			pigment {
				bozo
				color_map {
					[ 0.00 color rgb<0.62,0.72,.58> ] // white grey
					[ 0.50 color rgb <0.557,0.341,0.518> ] // purple blue
					[ 1.00 color rgb<0.62,0.72,.58> ] // return to original color
//					[ 0.50 color rgb<0.962,0.972,.958> ] // test
//					[ 0.50 color rgb<0.032,0.048,.968> ] // test
//					[ 1.00 color rgb<0.62,0.72,.58> ] // test
				}
				turbulence .35
				scale .12
			}
		finish { ambient .6 }
	}
#declare SkyCyl =
	cylinder {
		<-2*Miles,0,0>,<2*Miles,0,0>,1.3*Miles
		texture {
			gradient x
			texture_map {
				[ 0.0 SkyTex1 ] // clear sky on left
				[ 1.0 SkyTex2 ] // turbulent storm on right
			}
			scale 3.4*Miles
			translate <1.1*Miles,0,0>
			rotate z*-62
		}
	}
object { SkyCyl translate <-0.85*Miles,1.30*Miles,-25*Miles>}

#declare GroundPlaneWhite =
  plane { y, 0
    texture {
      pigment{White}
    }
    hollow
  }
//object {GroundPlaneWhite translate y*0}

#declare Dunes =
	height_field {
		png "Dunes1.png"
		smooth
//		water_level .015
//		translate <-0.085*in,0,-0.008*in> // align to scene origin
		rotate y*180
		translate <0,0,0.5>
		scale <400*Feet,8*Feet,300*Feet> // scale it up, Y-scale sets max height
		translate <200*Feet,0*Feet,0*Feet> // move to local scene
		texture { BeachTex }
	}
#declare FarLand =
	height_field {
		png "Dunes1.png"
		smooth
//		water_level .015
//		translate <-0.085*in,0,-0.008*in> // align to scene origin
//		rotate y*180
		translate <0,0,-1>
		scale <1200*Feet,20*Feet,300*Feet> // scale it up, Y-scale sets max height
		translate <-600*Feet,0*Feet,-200*Feet> // move to local scene
		texture { FarLandTex }
	}
#declare FadeLand =
	box {
		<-1000*Feet,0,0>,<1000*Feet,17*Feet,1>
		translate <0,0,-500*Feet>
		texture { FadeLandTex }
	}

#declare DunesT = // for testing
	box {
		<-1*Mile,-200*Feet,-1*Mile>,<1*Mile,1,.05*Mile>
		texture { BeachTex }
	}
#declare FarSeaWater =
	box {
		<-1000*Feet,-1,0>,<1000*Feet,0,5*Miles>
		rotate x*1
		texture { WaterTex }
	}
#declare SeaWaterT = // for testing
  plane { y, 0
    texture { WaterTex }
    hollow
  }
#declare SeaFloor =
	box {
		<-1*Mile,-4,0>,<1*Mile,-20,1*Mile>
		rotate x*6
		translate <0,0,0.05*Mile> // align to edge of beach
		texture { SeaFloorTex }
	}
#declare LocalWaves =
	height_field {
		png "Waves02.png"
		smooth
//		water_level .015
//		translate <-0.085*in,0,-0.008*in> // align to scene origin
		translate <-0.5,-0.5,-0.5>
		scale <265*Feet,6.7*Feet,65*Feet> // scale it up, Y-scale sets max height
		texture { WaterTex }
	}


#declare LocalWavesT =
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					gif "Foam1.gif"
					transmit   0, 0.9
					once
				}
				rotate <90,0,0> // align map to height_field
			}
			finish { ambient .62 }
		}
//		water_level .015
//		translate <-0.085*in,0,-0.008*in> // align to scene origin
		scale <125*Feet,1.3*Feet,125*Feet> // scale it up, Y-scale sets max height
		translate <-10*Feet,0*Feet,530*Feet> // ensure local area is below ground
	}

#declare SprayInt =
	interior {
		media {
//			emission  rgb<.038,.045,.052>*.6 // bright green-blue
			emission  rgb<.047,.050,.052>*.6 // more grey
//			absorption  rgb<.038,.045,.052>*2.6 //
			absorption  rgb<.020,.019,.016>*1.0 //
			density { spherical                           
				color_map{
					[ 0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[ 0.60 color rgb <0,0,0> ] // still transparent, this prevents it from reaching the container
					[ 0.62 color rgb <.1,.1,.1> ] // abruptly change to opaque
//					[ 1.0 color rgb <1,1,1> ] // inside region is opaque
					[ 1.0 color rgb <.1,.1,.1> ] // inside region is a little transparent, deep dark
//					[ 1.0 color rgb <.065,.065,.065> ] // inside region is rather transparent, medium thickness
//					[ 1.0 color rgb <.025,.025,.025> ] // inside region is quite transparent, whispier
//					[ 1.0 color rgb <.005,.005,.005> ] // inside region is quite transparent
				}
			turbulence .43 // stir it up a lot
			omega 0.835 // default is 0.5, higher = rougher
    	}
		}
	}
#declare Spray2Int =
	interior {
		media {
			emission  rgb<.044,.047,.052>*4.9 // bright green-blue
			absorption  rgb<.020,.0195,.0182>*18 //
			density { spherical                           
				color_map{
					[ 0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[ 0.60 color rgb <0,0,0> ] // still transparent, this prevents it from reaching the container
					[ 0.62 color rgb <.1,.1,.1> ] // abruptly change to opaque
					[ 1.0 color rgb <.1,.1,.1> ] // inside region is a little transparent, deep dark
				}
			turbulence .43 // stir it up a lot
			omega 0.835 // default is 0.5, higher = rougher
    	}
		}
	}
#declare SpraySurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#declare SprayMaterial =
	material {
		texture { SpraySurfTex }
		interior { SprayInt }
	}
#declare Spray2Material =
	material {
		texture { SpraySurfTex }
		interior { Spray2Int }
	}
#declare ShipSpray =
	sphere {
		<0,0,0>,1
		hollow
		material { SprayMaterial }
//texture { MasonaryTex }
		scale 30*Feet
	}
#declare ShipSpray2 =
	sphere {
		<0,0,0>,1
		hollow
		material { Spray2Material }
//texture { MasonaryTex }
		scale 9*Feet
	}


//===============================================
//             Objects
//===============================================


//--------------- Building --------------------

#declare Building1 =
	union {
		difference {
			box {
				<-40*Feet,0,-10*Feet>,<40*Feet,30*Feet,10*Feet>
				texture { WhiteBuildingTex }
			}
			box { // roof
				<-41*Feet,0,-10*Feet>,<41*Feet,15*Feet,20*Feet>
				rotate x*30
				translate <0,27*Feet,0>
				texture { RoofTex }
			}
			box { // roof
				<-41*Feet,0,10*Feet>,<41*Feet,15*Feet,-20*Feet>
				rotate x*-30
				translate <0,27*Feet,0>
				texture { RoofTex }
			}
		} // end difference
		box { // lower windows
			<-35*Feet,0,-10.01*Feet>,<35*Feet,4*Feet,10.01*Feet>
			translate <0,4*Feet,0>
			//#macro Stripe(Direction,Thickness,Scale,Color)
			texture { Stripe(x,2*Feet,10*Feet,<.31,.31,.37>) }
		}
		box { // upper windows
			<-35*Feet,0,-10.01*Feet>,<35*Feet,4*Feet,10.01*Feet>
			translate <0,16*Feet,0>
			//#macro Stripe(Direction,Thickness,Scale,Color)
			texture { Stripe(x,2*Feet,10*Feet,<.41,.45,.57>) }
		}
		box { // chimney
			<-6,0,-2.5*Feet>,<18,36*Feet,2.5*Feet>
			translate <-14*Feet,0,0>
			texture { ChimneyTex }
		}
		box { // chimney
			<-6,0,-2.5*Feet>,<18,36*Feet,2.5*Feet>
			translate <40*Feet,0,0>
			texture { ChimneyTex }
		}
		box { // small roof
			<-40.5*Feet,0,0>,<40.5*Feet,8,12*Feet>
			rotate x*20
			translate <0,13*Feet,10*Feet>
			texture { RoofTex }
		}
		box { // small roof
			<-40.5*Feet,0,0>,<40.5*Feet,8,-12*Feet>
			rotate x*-20
			translate <0,13*Feet,-10*Feet>
			texture { RoofTex }
		}
	} // end union

#declare Building2 =
	union {
		difference {
			box {
				<-15*Feet,0,-10*Feet>,<15*Feet,30*Feet,10*Feet>
				texture { WhiteBuildingTex }
			}
			box { // roof
				<-16*Feet,0,-10*Feet>,<16*Feet,15*Feet,20*Feet>
				rotate x*30
				translate <0,23*Feet,0>
				texture { RoofTex }
			}
			box { // roof
				<-16*Feet,0,10*Feet>,<16*Feet,15*Feet,-20*Feet>
				rotate x*-30
				translate <0,23*Feet,0>
				texture { RoofTex }
			}
		} // end difference
		box { // lower windows
			<-12*Feet,0,-10.01*Feet>,<12*Feet,4*Feet,10.01*Feet>
			translate <0,4*Feet,0>
			//#macro Stripe(Direction,Thickness,Scale,Color)
			texture { Stripe(x,2*Feet,10*Feet,<.31,.31,.37>) }
		}
		box { // upper windows
			<-15.01*Feet,0,-5*Feet>,<15.01*Feet,4*Feet,5*Feet>
			translate <0,16*Feet,0>
			//#macro Stripe(Direction,Thickness,Scale,Color)
			texture { Stripe(z,2*Feet,10*Feet,<.41,.45,.57>) }
		}
		box { // lower front windows
			<-15.01*Feet,0,-5*Feet>,<15.01*Feet,4*Feet,5*Feet>
			translate <0,4*Feet,0>
			//#macro Stripe(Direction,Thickness,Scale,Color)
			texture { Stripe(z,2*Feet,5*Feet,<.41,.45,.57>) translate z*30*Feet }
		}
		box { // chimney
			<-6,0,-2.5*Feet>,<18,32*Feet,2.5*Feet>
			translate <14*Feet,0,0>
			texture { ChimneyTex }
		}
		box { // chimney
			<-6,0,-2.5*Feet>,<18,32*Feet,2.5*Feet>
			translate <-4*Feet,0,-7*Feet>
			texture { ChimneyTex }
		}
		box { // small roof
			<-8*Feet,0,8*Feet>,<0*Feet,8,-8*Feet>
			rotate z*20
			translate <-15*Feet,12*Feet,0>
			texture { RoofTex }
		}
	} // end union



//===============================================
//             Object Placement
//===============================================

object { FarSeaWater translate <0,2*Feet,0> }
object { LocalWaves translate LO+<-30*Feet,0,120*Feet> }
object { LocalWaves translate LO+<0*Feet,0,-100*Feet> }

object { SeaFloor }
//object { CloudGroup1 translate <0*Feet,0.2*Miles,-7*Miles> } // small
//object { CloudGroup2 translate <-1900*Feet,0.2*Miles,-19*Miles> } // big


object { Lighthouse translate <0,2*Feet,0> }
object { Building1 rotate y*55 translate <-60*Feet,2*Feet,-150*Feet> }
object { Building2 rotate y*120 translate <-96*Feet,2*Feet,-100*Feet> }
object { Dunes }
object { FarLand }
object { FadeLand }
object { Ship rotate <-12,235,0> translate LO+<-34*Feet,0,-200*Feet> } // 6-degree tilt
object { ShipSpray translate LO+<-40*Feet,-6*Feet,-160*Feet> }
object { ShipSpray2 translate LO+<-34*Feet,3*Feet,-160*Feet> }

// TEST OBJECTS -- DO NOT RENDER
//object { SeaWaterT }
//object { Ship rotate y*180 translate LO+<0,0*Feet,-150*Feet> } // bow test
//object { CloudGroup1 translate <1200*Feet,0.2*Miles,-3*Miles> } // near
//object { CloudGroup2 translate <10*Feet,0.2*Miles,-5*Miles> } // near
//object { Ship rotate <-12,235,0> translate LO+<-70*Feet,0,60*Feet> } // 18-degree camera tilt
