
// POV-Ray Object File - Lighthouse
// created 1-Aug-99
// last update 27-Aug-99
// 1999 Glenn McCarter
// This file does not render.  #include "Lighthouse.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Lighthouse
//
// Intended scale is English system (inches)
// Uses LH coordinate reference system (Y=up)


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#macro Stripe(Direction,Thickness,Scale,Color)
pigment {
	gradient Direction
		color_map {
			[ Thickness/Scale color Color ]
			[ Thickness/Scale color rgbt<1,1,1,1> ]
		}
		scale Scale
}
#end

#declare LighthouseTex =
	texture {
		pigment {
			gradient y
			color_map {
				[ 0.0 color rgb<1,1,1> ]
				[ 0.5 color rgb<1,1,1> ]
				[ 0.5 color rgb<.1,.1,.1> ]
			}
			scale 38*Feet
			rotate z*-45
			translate y*-20*Feet
		}
		finish { ambient .12 specular .08 roughness .123 reflection 0 }
	}
#declare LGlassTex =
	texture {
		pigment { color rgbf<.81,.81,.91,.4> }
		finish { ambient .12 specular .82 roughness .033 reflection 0.1 }
	}
#declare OGlassTex =
	texture {
		pigment { color rgbf<.81,.81,.91,.74> }
		finish { ambient .12 specular .82 roughness .033 reflection 0.1 }
	}
#declare SteelTex =
	texture {
		pigment { color rgb<.003,.003,.003> }
		finish { ambient .12 specular .82 roughness .033 reflection 0.08 }
	}
#declare BrickTex =
	texture {
		pigment { color rgb <0.478,0.196,0.125> }
		finish { ambient .12 specular .27 roughness .085 reflection 0.0 }
	}
#declare MasonaryTex =
	texture {
		pigment { color rgb <0.753,0.733,0.596> }
		finish { ambient .12 specular .27 roughness .085 reflection 0.0 }
	}


//===============================================
//						 Objects
//===============================================


//--------------- Lighthouse --------------------

#declare BaseUnit =
	union {
		height_field {
		png "Brick5.png"
		rotate -90*x
		texture {
			material_map {
				png "Brick5.png"
				texture { MasonaryTex } // index 0
				texture { BrickTex } // index 1
			}
		}
		rotate x*90
		// following line seems incorrect, but works.  I don't know why...
		scale <18.3*Feet,-60*Feet,20*Feet> // scale it up, Y-scale sets max height
		rotate x*-85
		translate <-18.3/2*Feet,0*Feet,-22*Feet>
	}
		box {
			<-9.3*Feet,20.3*Feet,-22.8*Feet>,<9.3*Feet,21.5*Feet,0>
			texture { MasonaryTex }
		}
		box {
			<-9.5*Feet,21.5*Feet,-23.4*Feet>,<9.5*Feet,22.1*Feet,0>
			texture { MasonaryTex }
		}
	} // end union

#declare FresnelLight =
	union {
		sphere {
			<0,0,0>,2*Feet
			scale <1,1.5,1>
			translate <0,5*Feet,0>
			texture { LGlassTex }
		}
		cylinder {
			<0,0,0>,<0,3.6*Feet,0>,1*Feet
			texture { SteelTex }
		}
	} // end union

#declare OuterGlass =
	cone {
		<0,0,0>,5.8*Feet,<0,10*Feet,0>,5.8*Feet
		texture { OGlassTex }
	}

#declare Support =
	union {
		box {
			<-5,-16,0>,<5,0,10*Feet>
		}
		box {
			<-5,0,0>,<5,1.2*Feet,10*Feet>
			rotate x*60
			translate <0,-18,1.5*Feet>
		}
		texture { SteelTex }
	} // end union

#declare RoofHeight = 18*Feet; // from walkway
#declare TopStructure = // origin at walkway
	union {
		object { FresnelLight translate <0,8*Feet,0> }
		object { OuterGlass translate <0,8*Feet,0> }
		cylinder { // floor
			<0,-3*Feet,0>,<0,0,0>,14*Feet
		}
		#local FC = 0; // floor supports
		#while ( FC < 16 )
			object { Support
				translate <0,-3*Feet,-13*Feet>
				rotate y*FC*360/16
			}
			#local FC = FC + 1;
		#end
		torus { // handrail
			13.7*Feet,1.2
			translate <0,4*Feet,0>
		}
		torus { // below handrail
			13.7*Feet,1.6 
			scale <1,.6,1>
			translate <0,3*Feet,0>
		}
		#local RC = 0; // railing supports
		#while ( RC < 40 )
			cylinder {
				<0,0,0>,<0,4*Feet,0>,1.1
				translate <0,0,-13.7*Feet>
				rotate y*RC*360/40
			}
			#local RC = RC + 1;
		#end
		cone { // main lower
			<0,-12*Feet,0>,8.5*Feet,<0,0,0>,8.0*Feet
		}
		cone { // main upper
			<0,0,0>,7.5*Feet,<0,8*Feet,0>,7.5*Feet
		}
		cylinder  { // cone lower rim
			<0,-11.2*Feet,0>,<0,-11.2*Feet+8,0>,9.5*Feet
		}
		cylinder { // upper walkway floor
			<0,8*Feet,0>,<0,8.4*Feet,0>,10*Feet
		}
		torus { // upper handrail
			9.7*Feet,1.2
			translate <0,12.4*Feet,0>
		}
		#local URC = 0; // upper railing supports
		#while ( URC < 24 )
			cylinder {
				<0,0,0>,<0,4*Feet,0>,0.6
				translate <0,8.4*Feet,-9.7*Feet>
				rotate y*URC*360/24
			}
			#local URC = URC + 1;
		#end
		cylinder { // lid rim
			<0,RoofHeight,0>,<0,RoofHeight+0.6*Feet,0>,7.0*Feet
		}
		cone { // lid
			<0,RoofHeight+0.6*Feet,0>,6.6*Feet,<0,RoofHeight+4*Feet,0>,0.5*Feet
		}
		sphere { // tip
			<0,0,0>,2*Feet
			translate <0,RoofHeight+5.6*Feet,0>
		}
		cone { // tower
			<0,RoofHeight+4*Feet,0>,8,<0,RoofHeight+13*Feet,0>,2
		}
		texture { SteelTex }
	}

#declare Lighthouse =
	union {
		cone { // this is the main tower of the lighthouse!
			<0,0,0>,18*Feet,<0,196*Feet,0>,7.5*Feet
			texture { LighthouseTex }
		}
		object { BaseUnit rotate y*0 }
		object { BaseUnit rotate y*45 }
		object { BaseUnit rotate y*90 }
		object { BaseUnit rotate y*135 }
		object { BaseUnit rotate y*180 }
		object { BaseUnit rotate y*225 }
		object { BaseUnit rotate y*270 }
		object { BaseUnit rotate y*315 }
		object { TopStructure translate <0,196*Feet,0> }
	}


