#declare side = union {
  difference {
    union {
      box { -<3, 5, 40>*cm, <3, 50, 40>*cm }
      cylinder { <-3, 50, 0>*cm, <3, 50, 0>*cm, 40*cm }
    }
    box { -<4, 5, 30>*cm, <4, 50, 30>*cm }
    cylinder { <-4, 50, 0>*cm, <4, 50, 0>*cm, 30*cm }
  } 
  box { <-3, 45, -35>*cm, <3, 55, 35>*cm }
  box { -<2, 5, 0>*cm, <2, 5, 35>*cm rotate -45*x translate 50*cm*y }
  box { -<2, 5, 0>*cm, <2, 5, 35>*cm rotate -90*x translate 50*cm*y }
  box { -<2, 5, 0>*cm, <2, 5, 35>*cm rotate -135*x translate 50*cm*y } 
  
  box { -<3, 5, 8>*cm, <3, 50, 8>*cm }
  cylinder { <0, -5*cm, 0>, <0, 50*cm, 0>, 5*cm }
  sphere { <0, 50*cm, 0>, 5*cm }  
}

#declare base = union {  
  superellipsoid {
    <0.1, 0.1>
    scale <1.1, 0.75, 0.4>*m
  }      
  object {
    side
    translate -1*m*x+75*cm*y
  }
  object {
    side 
    translate 75*cm*y
  }
  object {
    side
    translate 1*m*x+75*cm*y
  }   
  box { <-10, 0, 30>*cm, <10, 100, 50>*cm }     
  
  texture { Dark_Metal }
  texture { Stains }  
  texture { TextMouillee }
}
        
#declare wheel = union {
  cylinder { -1*cm*x, 1*cm*x, 35*cm }
  difference {
    cylinder { -2*cm*x, 2*cm*x, 30*cm }
    cylinder { -4*cm*x, 4*cm*x, 25*cm }
  }
}
          
#declare axle = union {  
  cylinder {
    <-1.52, 0, 0>*m, <1.52, 0, 0>*m, 2*cm
    texture { Dark_Metal }
  }          
  superellipsoid {
    <1, 0.1>
    scale <10, 10, 45>*cm
    rotate 90*y
    translate -50*cm*x
    texture { T_Chrome_2C }
    texture { TextMouillee }
  }
  superellipsoid {
    <1, 0.1>
    scale <10, 10, 45>*cm
    rotate 90*y
    translate 50*cm*x
    texture { T_Chrome_2C }  
    texture { Stains }
    texture { TextMouillee }
  }
  intersection {
    object {
      Hyperboloid_Y
      scale 12.5*cm
    }
    box { -20*cm, 20*cm }
    texture { T_Brass_1A }
    texture { Stains }
    texture { TextMouillee } 
    rotate 90*z
    translate -1.3*m*x
  }
  intersection {
    object {
      Hyperboloid_Y
      scale 12.5*cm
    }
    box { -20*cm, 20*cm }
    texture { T_Brass_1A } 
    texture { Stains }
    texture { TextMouillee } 
    rotate 90*z
    translate 1.3*m*x
  }  
  superellipsoid {  
    <1, 0.7>
    scale <30, 30, 35>*cm
    rotate 90*y
    translate -50*cm*x
    pigment {
      crackle
      color_map { 
        [ 0.0 (Green+White)/4 ]  
        [ 0.3 Black ]
        [ 1.0 Black ]
      }          
      scale <0.01, 1, 1>
      scale 8*cm
    }           
    finish {
      diffuse 0.1
    }
  }
  object {
    wheel
    translate -87*cm*x
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }
  object {
    wheel
    translate -13*cm*x
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }
  object {
    wheel
    translate 13*cm*x
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }
  object {
    wheel
    translate 87*cm*x
    texture { Dark_Metal }
    texture { Stains }
    texture { TextMouillee }
  }

}

#declare guindeau = union {
  object { base }  
  object { axle translate 1.25*m*y }
}