//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#local pov=<5,1.83,-300>;
#local poi=<0,100,0>;

global_settings {
	max_trace_level 20
	number_of_waves 20
	radiosity {
		brightness 10
		distance_maximum 0
		error_bound 0.5
		low_error_factor 0.1
		count 200
		nearest_count 10
	}
}

camera {
	location pov
	sky y*1
	right x*4/3
	look_at poi
	normal { bump_map { png "logomask.png" interpolate 2 } 1 translate -0.5 }
}

sky_sphere {
	pigment {
		gradient y
		colour_map {
			[0 rgb <1,0,0>]
			[0.1 rgb <0.1,0,0>]
			[0.15 rgb <0,0,0.1>]
			[1 rgb <0,0,1>]
		}
	}
}

fog {
	fog_type 2
	rgb <1,0,0>
	distance 100
	fog_offset -1
	fog_alt 1
}

#local m = 1;
#local cm = m/100;
#local mm = m/1000;

//*****************************************************************************************************************************
// textures
//*****************************************************************************************************************************
#macro oilmetal(turb)
	texture {
		pigment { rgb 0.5 }
	}
	finish {
		diffuse 0.4
		ambient 0.1
		reflection 0.01
		specular 0.19
		metallic
		irid {
			0.3
			thickness 1
			turbulence turb
		}
	}
#end
	
#macro metalfinish()
	finish {
		ambient 0.3
		diffuse 0.7
		specular 0.2
		metallic
		roughness 0.1
	}
#end

#local spmetal = texture {
	pigment {
		granite
		colour_map {
			[0 rgb 0.1]
			[1 rgb 0.2]
		}
		scale mm
	}
	normal {
		granite 0.1
		scale mm
	}
	finish {
		ambient 0.5
		diffuse 0.5
		specular 0.2
	}
}

#local metal = texture { pigment { rgb 0.7 } metalfinish() }

#local water = texture {
	pigment {
		crackle
		turbulence 0.1
		colour_map {
			[0 rgb 1]
			[0.2 rgb <0,0,0.3>]
		}
	}
	normal {
		waves 0.1
		frequency 500
		sine_wave
		translate -0.5
		scale <1000,1,1000>
	}
	finish {
		ambient 0.2
		diffuse 0.2
		reflection 0.6
	}
}

#local rsurface = texture {
	pigment {
		granite
		colour_map {
			[0 rgb 0.5]
			[1 rgb 0.8]
		}
		scale 0.1
	}
	finish {
		ambient 0.1
		diffuse 0.9
	}
}

#local wsurface = texture {
	pigment {
		rgb 1
	}
	finish {
		ambient 0.1
		diffuse 0.9
	}
}

#local chatch = texture {
	gradient x
	sine_wave
	scale 0.1
	texture_map {
		[0.5 wsurface ]
		[0.5 rsurface ]
	}
	rotate y*45
}

//*****************************************************************************************************************************
// Police Hover tank
//
//		The weapons on this tank are a bit "over modelled" for this scene but they were originally designed for a spaceship
//		project which was never finished.
//*****************************************************************************************************************************
#local rcannona = union {
	cylinder {
		x*0.5*m x*-0.5*m 5*cm
		texture { spmetal }
	}
	cone {
		x*-1*m 0 x*-0.5*m 0.2*m
		pigment { rgb 1 }
		finish {
			specular 1
			roughness 0.1
			reflection 1
			ambient 0.1
			diffuse 0
			metallic
		}
	}
	intersection {
		sphere { 0 0.2*m }
		plane { -x 0 }
		translate x*-0.5*m
		pigment { rgb 1 }
		finish {
			specular 1
			roughness 0.1
			reflection 1
			ambient 0.1
			diffuse 0
			metallic
		}
	}
	difference {
		merge {
			#local rcac = 0;
			#while (360>rcac)
				merge {
					box {
						-1,1
						scale 10*cm
						texture { spmetal }
					}
					box {
						-1,1
						scale 10*cm
						translate x*0.9*m
						texture { spmetal }
					}
					cylinder {
						x*-1*m x*0.9*m 5*cm
						texture { metal }
					}
					intersection {
						torus {
							0.4*m 5*cm
							rotate 90*x
						}
						plane {	y 0 }
						plane { -x 0 }
						texture { spmetal }
						translate x*0.5*m
					}
					intersection {
						torus {
							0.4*m 5*cm
							rotate 90*x
						}
						plane { y 0 }
						plane { x 0 }
						texture { spmetal }
						translate x*0.4*m
					}
					translate y*0.4*m
					rotate x*rcac
				}
				#local rcac = rcac + 45;
			#end
			difference {
				cylinder {
					x*-0.55*m x*0.55*m 0.45*m
				}
				cylinder {
					x*-1*m x*1*m 0.35*m
				}
				cylinder {
					x*-0.45*m x*0.45 0.6*m
				}
				texture { spmetal }
			}
			cylinder {
				x*0.5*m+z*0.6*m x*0.5*m-z*0.6*m 5*cm
				texture { spmetal }
			}
		}
		#local rcac = 0;
		#while (360>rcac)
			cylinder {
				x*-1.01*m+y*0.4*m x*0.9*m+y*0.4*m 4*cm
				texture { metal }
				rotate x*rcac
			}
			#local rcac = rcac + 45;
		#end
	}
	translate x*-0.5*m
}	
	
#local rcannonb = difference {
	merge {
		cylinder {
			x*0.5*m+z*0.6*m x*0.5*m-z*0.6*m 5*cm
			texture { spmetal }
		}
		cylinder {
			x*-1*m x*0.9*m 5*cm
			texture { metal }
		}
		torus {
			0.4*m 5*cm
			rotate z*90
			translate x*-0.9*m
			texture { spmetal }
		}
		#local rcbc = 36;
		#while (rcbc <= 360)
			union {
				cylinder {
					-0.1*x*m+y*0.4*m 0.8*x*m+y*0.4*m 10*cm
					texture { metal }
				}
				cylinder {
					-0.1*x*m+y*0.4*m 0.9*m*-x+z*0.4*m 5*cm
					texture { spmetal }
				}
				cylinder {
					-0.1*x*m+y*0.4*m 0.9*m*-x-z*0.4*m 5*cm
					texture { spmetal }
				}
				sphere {
					<-0.9,0,0.4>*m 10*cm
					texture { metal }
				}
				rotate x*rcbc
			}
			#local rcbc1 = -0.5;
			#while (rcbc1 <= 0.5 )
				merge {
					intersection {
						torus {
							0.4*m 5*cm
							rotate x*90
						}
						plane { -x 0 }
						plane { y 0 }
						texture { metal }
					}
					box {
						-1, 1
						scale 10*cm
						translate x*0.4*m
						texture { spmetal }
					}
					translate y*0.4*m+x*rcbc1*m
					rotate x*rcbc
				}
				#local rcbc1 = rcbc1 + 0.45;
			#end
			#local rcbc = rcbc + 36;
		#end
		box {
			-1,1
			scale 10*cm
			translate x*0.9*m
			texture { metal }
		}
	}
	cylinder {
		x*-1.01*m x*0.9*m 4*cm
		texture { metal }
	}
	translate x*-0.5*m
}

#local rcannonc = difference {
	merge {
		cylinder {
			x*0.5*m+z*0.6*m x*0.5*m-z*0.6*m 5*cm
			texture { spmetal }
		}
		sphere {
			x*0.5*m 0.5*m
			texture { spmetal }
		}
		cylinder {
			x*-1*m x*0.5*m 5*cm
			texture { metal }
		}
		difference {
			merge {
				#local rccc = 0;
				#while (rccc < 180)
					cylinder {
						x*-1*m x*0.5*m 1
						scale <1,0.5,0.01>*m
						rotate x*rccc
						texture { metal }
					}
					#local rccc = rccc + 22.5;
				#end
			}
			sphere {
				x*-1*m 0.5*m
				texture { metal }
			}
			torus {
				0.25*m 0.2*m
				texture { metal }
				rotate z*90
				translate x*-0.25*m
			}
			torus {
				0.4*m 0.05*m
				texture { metal }
				rotate z*90
				translate x*-0.5*m
			}
			torus {
				0.4*m 0.05*m
				texture { metal }
				rotate z*90
			}
		}
	}
	cylinder {
		x*-1.01*m x*0.9*m 4*cm
		texture { metal }
	}
	translate x*-0.5*m
}

#local spoda = union {
	cylinder {
		x*0.5*m+z*0.6*m x*0.5*m-z*0.6*m 5*cm
		texture { spmetal }
	}
	union {
		cone { x*0.5*m 0.1*m x*-0.09*m 0 }
		sphere { x*0.75*m m*0.25 }
		#local tpac=0;
		#while (tpac<360)
			union {
				cone { x*0 0.25*m x*-1*m 0 }
				intersection {
					plane { -x 0 }
					sphere { 0 0.25*m }
				}
				translate y*0.25*m
				rotate x*tpac
			}
			#local tpac = tpac + 60;
		#end
		texture {
			pigment { rgb 1 }
		}
		finish {
			irid {
				0.4
				thickness 1
				turbulence 0.1
			}
			reflection 0.5
			diffuse 0.1
			ambient 0
			metallic
		}
	}
	light_source {
		x*-0.1*m
		rgb 1
		spotlight
		radius 30
		falloff 40
		fade_distance 10*m
		fade_power 2
		point_at x*-1*m
		looks_like {
			sphere {
				0,0.1
				pigment { rgb 1 }
				finish {
					ambient 1
					diffuse 0
				}
			}
		}
	}
	translate x*-0.5*m
}

#macro wmount(weapon,weaponrot,mountrot)
	union {
		object {
			weapon
			rotate z*-weaponrot
			translate y*0.6*m+x*0.5*m
		}
		sphere { y*0.6*m+x*0.5*m+z*0.6*m 0.1*m }
		sphere { y*0.6*m+x*0.5*m-z*0.6*m 0.1*m }
		sphere { x*0.9*m+z*0.6*m 0.1*m }
		sphere { x*0.9*m-z*0.6*m 0.1*m }
		sphere { x*-0.9*m+z*0.6*m 0.1*m }
		sphere { x*-0.9*m-z*0.6*m 0.1*m }
		sphere { z*0.6*m 0.1*m }
		sphere { z*-0.6*m 0.1*m }
		cylinder { z*0.6*m+x*0.9*m z*0.6*m-x*0.9*m 5*cm }
		cylinder { z*0.6*m+x*0.5*m+y*0.6*m z*0.6+x*0.9*m 5*cm}
		cylinder { z*0.6*m+x*0.5*m+y*0.6*m z*0.6 5*cm}
		cylinder { z*0.6*m+x*0.5*m+y*0.6*m z*0.6-x*0.9*m 5*cm}
		cylinder { z*-0.6*m+x*0.9*m z*-0.6*m-x*0.9*m 5*cm }
		cylinder { z*-0.6*m+x*0.5*m+y*0.6*m z*-0.6+x*0.9*m 5*cm}
		cylinder { z*-0.6*m+x*0.5*m+y*0.6*m z*-0.6 5*cm}
		cylinder { z*-0.6*m+x*0.5*m+y*0.6*m z*-0.6-x*0.9*m 5*cm}
		cylinder { z*-0.6*m z*0.6*m+x*-0.9*m 5*cm }
		cylinder { z*0.6*m z*-0.6*m+x*-0.9*m 5*cm }
		cylinder { y*0.6*m+x*0.5*m+z*0.51*m y*0.6*m+x*0.5*m+z*0.6*m 0.1*m }
		cylinder { y*0.6*m+x*0.5*m-z*0.51*m y*0.6*m+x*0.5*m-z*0.6*m 0.1*m }
		difference {
			merge {
				box { <-0.95,-0.2,-0.65>*m <0.95,0,0.65>*m }
				cone { x*0.5*m+0.6*m*y+z*0.6*m 10*cm z*0.8*m 0.2*m }
				cone { x*0.5*m+0.6*m*y-z*0.6*m 10*cm z*-0.8*m 0.2*m }
				cylinder { 0 y*-0.2*m 0.99*m }
				torus { 0.8*m 0.05*m }
				sphere { z*0.8*m 0.2*m }
				sphere { z*-0.8*m 0.2*m }
			}
			cylinder { y*0.6*m+x*0.5*m+z*0.55*m y*0.6*m+x*0.5*m-z*0.55*m 0.708*m }
		}
		difference {
			cylinder {
				y*-0.01*m y*-0.19*m 1*m
				texture {
					pigment {
						spiral1 90
						colour_map {
							[0.5 rgb 1*x]
							[0.5 rgb 1-1*z]
						}
						rotate x*90
					}
					finish {
						ambient 0.5
						diffuse 0.5
						specular 1
						metallic
					}
				}
			}
			cylinder { 0 y*-0.2*m 0.99*m }
		}
		texture { spmetal }
		translate y*0.2*m
		rotate y*mountrot
		rotate y*-90
	}
#end

#macro phtank(pos,rot,l,r)
union {
	object {
		wmount(rcannona,0,0)
		translate x*-2.5+y*2+z*3
	}
	
	object {
		wmount(rcannonc,0,0)
		translate x*2.5+y*2+z*3
	}
	
	object {
		wmount(rcannonb,0,0)
		translate z*2.5+y*2.5
	}
	
	object {
		wmount(spoda,0,l)
		translate x*2.5+y*0.8-z*1
	}
	
	object {
		wmount(spoda,0,r)
		translate x*-2.5+y*0.8-z*1
	}
	union {
		box { <-3.5,0.5,-1> <3.5,1,4> } 
		cylinder { <-3.5,0.75,-1> <-3.5,0.75,4> 0.25 }
		cylinder { <3.5,0.75,-1> <3.5,0.75,4> 0.25 }
		cylinder { <-3.5,0.75,4> <3.5,0.75,4> 0.25 }
		sphere { <-3.5,0.75,4> 0.25 }
		sphere { <3.5,0.75,4> 0.25 }
	}
	union {
		box { <-3.5,0.999,2> <3.5,2,4> }
		intersection {
			cylinder { <-3.5,1,0> <3.5,1,0> 1 scale <1,1,0.3> translate z*2 }
			box { <-3.6,0.99,0> <3.6,2,4> }
		}
	}
	union {
		box { <-1,0.999,1.5> <1,2.5,3.5> }
		intersection {
			box { <-2,0.99,0> <2,2.5,4> }
			union {
				cylinder { <0,0,0> <0,0,4> 1
					scale <0.25,1.75,1>
					translate x*1+y*0.75
				}
				cylinder { <0,0,0> <0,0,4> 1
					scale <0.25,1.75,1>
					translate x*-1+y*0.75
				}
			}
		}
	}
	torus { 3.5,0.25 translate <0,0.75,-1> }
	superellipsoid { <0.5,0.1>
		rotate y*90
		scale <2,0.1,0.5>
		translate <0,0.75,-4>
		hollow
		no_shadow
		texture {
			pigment {
				rgb 1
			}
		}
		finish {
			ambient 3
			diffuse 0
			specular 1
		}
	}
	light_source {
		0
		rgb 1
		spotlight
		point_at <0,0,-1>
		radius 30
		falloff 35
		rotate x*-20
		translate <1.9,0.75,-4.4>
	}
	light_source {
		0
		rgb 1
		spotlight
		point_at <0,0,-1>
		radius 30
		falloff 35
		rotate x*-20
		translate <-1.9,0.75,-4.4>
	}
	union {
		superellipsoid { <0.5,0.1>
			rotate y*90
			scale <2,0.1,0.5>
			translate <0,1.1,-3.5>
		}
		sphere {
			0,1
			scale <0.1,0.5,0.5>
			translate <-3.5,1.5,3>
		}
		sphere {
			0,1
			scale <0.1,0.5,0.5>
			translate <3.5,1.5,3>
		}
		texture {
			pigment {
				rgb <0,0,1>
			}
		}
		finish {
			ambient 10
			diffuse 0
			specular 1
		}
	}
	cylinder { <0,0.5,-1> <0,1,-1> 3.5 }
	union {
		superellipsoid { 0.5 translate x*2}
		superellipsoid { 0.5 translate x*-2}
		texture {
			pigment {
				gradient y
				colour_map {
					[0 rgb 1]
					[0.2 rgb <1,1,0>]
					[0.4 rgb <1,1,0>]
					[0.6 rgb <1,0,0>]
					[0.8 rgb 0]
				}
			}
		}
		finish {
			ambient 5
			diffuse 0
		}
		scale <1,0.33,3.5>
		translate <0,0.5,0.5>
	}
	intersection {
		box { <-2,0,-1> <2,1,0> }
		union {
			cylinder { <-1,0,0> <1,0,0> 1 }
			sphere { 0,1 scale <0.25,1,1> translate x*1 }
			sphere { 0,1 scale <0.25,1,1> translate x*-1 }
		}
		scale <1,1.75,6>
		translate <0,0.75,1.5>
		oilmetal(0)
	}
	scale 0.5
	texture{spmetal}
	translate pos
	rotate rot
}
#end

phtank(<9,0,0>,<0,30,0>,-40,80)
phtank(<-4,0,-270>,<0,0,0>,0,0)

//*****************************************************************************************************************************
// bridge, water & the "island"
//*****************************************************************************************************************************
plane { y, -1 texture { water } }
	
difference {
	cylinder { 2*y, -50*y 100 texture { wsurface } }
	cylinder { 2.1*y, 0 99 }
	box { <-10,-1,-101> <10,2.1,-50> }
	texture { rsurface }
}
	
box { <-10,-1,-1000> <10,0,-50> 
	texture {
		gradient x
		texture_map {
			[0.2 chatch ]
			[0.2 wsurface ]
			[0.205 wsurface ]
			[0.205 rsurface ]
			[0.45 rsurface ]
			[0.45 wsurface ]
			[0.455 wsurface ]
			[0.455 rsurface ]
			[0.7 rsurface]
			[0.7 wsurface]
			[0.71 wsurface]
			[0.71 chatch ]
		}
		scale 10
	}
}

box { <-0.05,-0.1,-1000> <0.05,0.5,-100>
	pigment { rgb 1 }
	finish {
		ambient 0.2
		diffuse 0.8
	}
}

box { <-10.1,-1,-1000> <-10,1,-100>
	pigment { rgb 1 }
	finish {
		ambient 0.2
		diffuse 0.8
	}
}

box { <10,-1,-1000> <10.1,1,-100>
	pigment { rgb 1 }
	finish {
		ambient 0.2
		diffuse 0.8
	}
}

#local lc = -260;
#while (lc <= 80 )
	union {
		intersection {
			plane { y 0 }
			torus { 2.5 0.05 rotate x*90 }
			rotate z*90
			translate <10,2.5,0>
			pigment { rgb 1 }
			finish {
				ambient 0.2
				diffuse 0.8
			}
		}
		light_source {
			<10,5,0>
			rgb 1
			spotlight
			radius 30
			falloff 50
			point_at <5,0,0>
			looks_like {
				sphere {
					0 0.1
					pigment { rgb 1}
					finish {
						ambient 1
						diffuse 0
					}
				}
			}
		}
		translate x*90
		rotate y*lc
	}
	#local lc = lc + 5;
	#end
#local lc = -340;
#while (lc <= -120)
	intersection {
		plane { y 0 }
		torus { 2.5 0.05 rotate x*90 }
		rotate z*-90
		translate <-10.01,2.5,lc>
		pigment { rgb 1 }
		finish {
			ambient 0.2
			diffuse 0.8
		}
	}
	intersection {
		plane { y 0 }
		torus { 2.5 0.05 rotate x*90 }
		rotate z*90
		translate <10.01,2.5,lc-10>
		pigment { rgb 1 }
		finish {
			ambient 0.2
			diffuse 0.8
		}
	}
	light_source {
		<-10,5,lc>
		rgb 1
		spotlight
		radius 30
		falloff 50
		point_at <-5,0,lc>
		looks_like {
			sphere {
				0 0.1
				pigment { rgb 1}
				finish {
					ambient 1
					diffuse 0
				}
			}
		}
	}
	light_source {
		<10,5,lc-10>
		rgb 1
		spotlight
		radius 30
		falloff 50
		point_at <5,0,lc-10>
		looks_like {
			sphere {
				0 0.1
				pigment { rgb 1}
				finish {
					ambient 1
					diffuse 0
				}
			}
		}
	}
	#local lc = lc + 20;
	#end

//*****************************************************************************************************************************
// The landmark PDS power and reclaimation tower
//*****************************************************************************************************************************
union {
	#local tc = 0;
	#while (tc <360)
		union {
			torus { 20,1
				rotate x*90
			}
			light_source {
				18.9*y
				rgb 0.5
				spotlight
				radius 0
				falloff 60
				tightness 0
				fade_distance 15
				fade_power 2
				looks_like {
					sphere { 0,0.1
						pigment { rgb 1 }
						finish { ambient 1 diffuse 0 }
					}
				}
			}
			translate x*20
			rotate y*tc
		}
		#local tc = tc + 30;
		#end
	torus { 20 1 translate y*20 }
	
	//layer 2 torii ring
	#local tc = 0;
	#while (tc < 360)
		union {
			torus { 10 1 rotate x*90 }
			difference {
				torus { 10 1 rotate x*90 }
				box { <0,-11.1,-1.1> <11.1,0,1.1> }
				translate x*-10+y*10
			}
			#local cc = 0;
			#while (cc < 360)
				cylinder { 5*y 10*y 0.2
					rotate z* cc
				}
				#local cc = cc + 90;
				#end
			translate x*20+y*30
			rotate y*tc
		}
		#local tc = tc + 30;
		#end
	#local tc = 15;
	#while (tc < 360)
		light_source {
			<0,0,0>
			rgb 1
			fade_distance 5
			fade_power 2
			looks_like {
				sphere { 0,1 
					pigment { rgbf 1 }
					hollow
					interior {
						media {
							emission rgb 1
							intervals 50
							samples 2,10
							density {
								spherical
								colour_map {
									[0 rgb 0]
									[0.1 rgb <0.1,0.1,0>]
									[0.2 rgb 0]
									[0.8 rgb 0.1]
									[1 rgb 1]
								}
							}
						}
					}
					finish {
						ambient 1
						diffuse 0
					}
					scale 4.5
				}
			}
			translate x*20+y*30
			rotate y*tc
		}
		#local tc = tc + 90;
		#end
	union {
		#local tc = 0;
		#while (tc < 360)
			torus { 5 0.2
				rotate x*90
				translate x*20+y*30
				rotate y*tc
			}
			#local tc = tc + 10;
			#end
		torus { 20 0.2 translate y*35 }
		torus { 20 0.2 translate y*25 }
		torus { 25 0.2 translate y*30 }
		torus { 15 0.2 translate y*30 }
		pigment { rgb 1 }
		finish {
			ambient 0.2
			metallic
			reflection 0.1
			diffuse 0.2
		}
	}
	torus { 10 1 translate y*30 }
	torus { 20 1 translate y*40 }
	torus { 10 1 translate y*50 }
	
	//layer 3
	#local tc = 0;
	#while (tc <180)
		intersection {
			torus { 10 1 rotate x*90 }
			plane { -y 0 }
			translate y*50
			rotate y*tc
		}
		#local tc = tc +30;
		#end
	sphere { <0,65,0> 15 }
	#local tc = 45;
	#while (tc < 180)
		torus {
			14.14 1
			rotate x*90
			rotate y*tc
			translate 80*y
		}
		#local tc = tc + 90;
		#end
		
	//layer 4
	superellipsoid {
		0.4
		scale 10
		translate y*90
	}
	#local lc = 0;
	#while (lc < 360)
		union {
			light_source {
				<0,0,0>
				rgb 1
				fade_distance 5
				fade_power 2
				looks_like {
					sphere { 0,1 
						pigment { rgbf 1 }
						hollow
						interior {
							media {
								emission rgb 1
								intervals 50
								samples 2,10
								density {
									spherical
									colour_map {
										[0 rgb 0]
										[0.1 rgb <0.1,0.1,0>]
										[0.2 rgb 0]
										[0.8 rgb 0.1]
										[1 rgb 1]
									}
								}
							}
						}
						finish {
							ambient 1
							diffuse 0
						}
						scale 4.5
					}
				}
			}
			cone { x*-0.1 0 x*-15 1 }
			cone { x*-0.1 0 x*-15+y*9 1 }
			pigment { rgb <0.6,0.4,0.1> }
			finish {
				ambient 0.15
				diffuse 0.85
				specular 1
				metallic
			}
			translate x*20+y*90
			rotate y*lc
		}
		#local lc = lc +90;
		#end
		
	// 4/5 join
	blob {
		threshold 0.5
		#local bc = 100;
		#while (bc < 150)
			sphere { bc*y 10 1 }
			#local bc = bc + 10;
			#end
	}

	//layer 5
	superellipsoid {
		0.4
		scale 10
		translate y*150
	}
	#local lc = 45;
	#while (lc < 360)
		union {
			light_source {
				<0,0,0>
				rgb 1
				fade_distance 5
				fade_power 2
				looks_like {
					sphere { 0,1 
						pigment { rgbf 1 }
						hollow
						interior {
							media {
								emission rgb 1
								intervals 50
								samples 2,10
								density {
									spherical
									colour_map {
										[0 rgb 0]
										[0.1 rgb <0.1,0.1,0>]
										[0.2 rgb 0]
										[0.8 rgb 0.1]
										[1 rgb 1]
									}
								}
							}
						}
						finish {
							ambient 1
							diffuse 0
						}
						scale 4.5
					}
				}
			}
			cone { x*-0.1 0 x*-15 1 }
			cone { x*-0.1 0 x*-15+y*9 1 }
			pigment { rgb <0.6,0.4,0.1> }
			finish {
				ambient 0.15
				diffuse 0.85
				specular 1
				metallic
			}
			translate x*20+y*150
			rotate y*lc
		}
		#local lc = lc +90;
		#end
		
	//spire
	cone { 150*y 10 200*y 0 scale <0.3,1,1> }
	cone { 150*y 10 200*y 0 scale <1,1,0.3> }
	light_source {
		<0,200.1,0>
		rgb <0,1,0>
		fade_distance 25
		fade_power 2
		looks_like {
			sphere { 0,1 
				pigment { rgbf 1 }
				hollow
				interior {
					media {
						emission rgb 1
						intervals 50
						samples 2,10
						density {
							spherical
							colour_map {
								[0 rgb 0]
								[0.1 rgb <0,0.05,0.05>]
								[0.2 rgb 0]
								[0.8 rgb <0,0.1,0>]
								[1 rgb 1]
							}
						}
					}
				}
				finish {
					ambient 1
					diffuse 0
				}
				scale 10
			}
		}
	}
				
	
	//texture
	pigment { rgb <0.9,1,0.9> }
	finish {
		ambient 0.1
		diffuse 0.9
		specular 0.3
		metallic
	}
}


//*****************************************************************************************************************************
// Control building
//*****************************************************************************************************************************
box { -1,1
	scale <10,2.5,10>
	translate x*55+y*2.5
	pigment {
		rgb 1
	}
	finish {
		ambient 0.1
		diffuse 0.9
	}
}

//*****************************************************************************************************************************
// Star field
//*****************************************************************************************************************************
#local sr1 = seed(1764);
#local sc = 0;
#while (sc < 1000)
	sphere { 0, 20
		translate x*(10000 + 10000*rand(sr1))
		rotate z*(180*rand(sr1))
		rotate y*(360*rand(sr1))
		pigment { rgb 1 }
		finish {
			ambient 1
			diffuse 0
		}
	}
	#local sc = sc +1 ;
	#end