//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 6 materials and 227 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 08/29/1999    (29.08.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
 }

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     500.0
  color <1.0,1.0,1.0,0.0,0.0>
  up           <0,0,1>
  fog_offset   10.0
  fog_alt      10.0
}

camera {  //  Camera Camera01
  location  <      2.098,    -260.835,       1.830>
  direction <        0.0,         0.0,      1.5498> // Aperture is 0.62 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      8.156,       1.989,      78.640>
}

//
// *******  L I G H T S *******
//

light_source { // Arealight001
  <74.626, -212.962, 426.541>
  color rgb <1.000, 1.000, 1.000>*2.5000
  area_light <125.184, 0.000, 0.000>, <0.000, 10.931, 9.205>, 5, 5
  adaptive 1
  jitter
}



//
// ********  MATERIALS  *******
//

#include "pisa_torre2.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Piano = union {
  torus { // Torus001
    1.975, 0.025  rotate -x*90
    scale <12.5, 12.5, 15.0>
    translate  13.8*z
  }
  cylinder { // Cylndro_colonne
    <0,0,1>, <0,0,0>, 1 
    scale <24.5, 24.5, 1.0>
    translate  12.63*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <24.5, 24.5, 0.7>
    translate  13.45*z
  }
  material {
    Marmo
  }
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <0.911422, -1.699301>,
  <1.769231, -1.699301>,
  <1.7895, -1.286721>,
  <1.798733, -0.826486>,
  <1.871449, -0.398172>,
  <2.026369, 0.057984>,
  <2.322552, 0.446737>,
  <2.745338, 0.721445>,
  <3.389277, 0.825175>,
  <3.389394, 0.884421>,
  <0.911422, 0.884421>,
  <0.911422, -1.699301>
  rotate -x*90
  scale <1.0, 1.0, 0.952448>
  translate  <-0.9, 0.0, 0.0>
}
#declare Arco = union {
  object { TransSweep001 }
  object { // TransSweep002->TransSweep001
    TransSweep001
    rotate <180.0, 0.0, 180.0>
    translate  0.95*z
  }
  scale <1.131774, 1.007751, 1.0>
  rotate 90.0*x
  translate  <-0.010574, 0.477002, 11.839735>
}
#declare Elemento = union {
  object { Arco }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.098716, 1.0, 0.80791>
    rotate <0.0, -0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
    scale <9.844755, 1.0, 0.762238>
    rotate -180.0*z
    translate  9.51049*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 13.0>
    translate  -4.0*z
  }
  material {
    Marmo
  }
  translate  <0.0, -24.0, 4.0>
}
#declare Insieme_Colonne = union {
  object { // Elemento29->Elemento
    Elemento
    rotate -168.0*z
    translate  <9.979761, -46.951085, 0.0>
  }
  object { // Elemento28->Elemento
    Elemento
    rotate 24.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Elemento27->Elemento
    Elemento
    rotate -144.0*z
    translate  <28.213692, -38.832816, 0.0>
  }
  object { // Elemento26->Elemento
    Elemento
    rotate 48.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Elemento25->Elemento
    Elemento
    rotate -120.0*z
    translate  <41.569219, -24.0, 0.0>
  }
  object { // Elemento24->Elemento
    Elemento
    rotate 72.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Elemento23->Elemento
    Elemento
    rotate -96.0*z
    translate  <47.737051, -5.017366, 0.0>
  }
  object { // Elemento22->Elemento
    Elemento
    rotate 96.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Elemento21->Elemento
    Elemento
    rotate -72.0*z
    translate  <45.650713, 14.832816, 0.0>
  }
  object { // Elemento20->Elemento
    Elemento
    rotate 120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Elemento19->Elemento
    Elemento
    rotate -48.0*z
    translate  <35.670952, 32.118269, 0.0>
  }
  object { // Elemento18->Elemento
    Elemento
    rotate 144.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Elemento17->Elemento
    Elemento
    rotate -24.0*z
    translate  <19.523359, 43.850182, 0.0>
  }
  object { // Elemento16->Elemento
    Elemento
    rotate 168.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Elemento15->Elemento
    Elemento
    rotate -0.0*z
    translate  <0.0, 48.0, 0.0>
  }
  object { // Elemento14->Elemento
    Elemento
    rotate -168.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Elemento13->Elemento
    Elemento
    rotate 24.0*z
    translate  <-19.523359, 43.850182, 0.0>
  }
  object { // Elemento12->Elemento
    Elemento
    rotate -144.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Elemento11->Elemento
    Elemento
    rotate 48.0*z
    translate  <-35.670952, 32.118269, 0.0>
  }
  object { // Elemento10->Elemento
    Elemento
    rotate -120.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Elemento9->Elemento
    Elemento
    rotate 72.0*z
    translate  <-45.650713, 14.832816, 0.0>
  }
  object { // Elemento8->Elemento
    Elemento
    rotate -96.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Elemento7->Elemento
    Elemento
    rotate 96.0*z
    translate  <-47.737051, -5.017366, 0.0>
  }
  object { // Elemento6->Elemento
    Elemento
    rotate -72.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Elemento5->Elemento
    Elemento
    rotate 120.0*z
    translate  <-41.569219, -24.0, 0.0>
  }
  object { // Elemento4->Elemento
    Elemento
    rotate -48.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Elemento3->Elemento
    Elemento
    rotate 144.0*z
    translate  <-28.213692, -38.832816, 0.0>
  }
  object { // Elemento2->Elemento
    Elemento
    rotate -24.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Elemento1->Elemento
    Elemento
    rotate 168.0*z
    translate  <-9.979761, -46.951085, 0.0>
  }
  object { Elemento }
  translate  -4.0*z
}
#declare Piano_Colonne = union {
  object { Piano }
  object { Insieme_Colonne }
  translate  4.0*z
}
#declare Asta_Ringhiera = object {
  cylinder { // Asta_Ringhiera
    <0,0,1>, <0,0,0>, 1 
    material {
      RInghiera_tex
    }
    scale <0.15, 0.15, 3.5>
    translate  <0.0, -23.92, 109.9>
  }
}
#declare Ringhiera_sotto = object {
  torus { // Ringhiera_sotto
    1.995, 0.005  rotate -x*90
    material {
      RInghiera_tex
    }
    scale <12.0, 12.0, 1.0>
    translate  113.0*z
  }
}
#declare Ringhiera = union {
  object { // Asta_Ringhiera29->Asta Ringhiera
    Asta_Ringhiera
    translate  <4.973248, 0.522709, 0.0>
  }
  object { // Asta_Ringhiera28->Asta Ringhiera
    Asta_Ringhiera
    translate  <9.729141, 2.067993, 0.0>
  }
  object { // Asta_Ringhiera27->Asta Ringhiera
    Asta_Ringhiera
    translate  <14.059823, 4.568313, 0.0>
  }
  object { // Asta_Ringhiera26->Asta Ringhiera
    Asta_Ringhiera
    translate  <17.776024, 7.914396, 0.0>
  }
  object { // Asta_Ringhiera25->Asta Ringhiera
    Asta_Ringhiera
    translate  <20.715328, 11.96, 0.0>
  }
  object { // Asta_Ringhiera24->Asta Ringhiera
    Asta_Ringhiera
    translate  <22.749272, 16.528313, 0.0>
  }
  object { // Asta_Ringhiera23->Asta Ringhiera
    Asta_Ringhiera
    translate  <23.788964, 21.419679, 0.0>
  }
  object { // Asta_Ringhiera22->Asta Ringhiera
    Asta_Ringhiera
    translate  <23.788964, 26.420321, 0.0>
  }
  object { // Asta_Ringhiera21->Asta Ringhiera
    Asta_Ringhiera
    translate  <22.749272, 31.311687, 0.0>
  }
  object { // Asta_Ringhiera20->Asta Ringhiera
    Asta_Ringhiera
    translate  <20.715328, 35.88, 0.0>
  }
  object { // Asta_Ringhiera19->Asta Ringhiera
    Asta_Ringhiera
    translate  <17.776024, 39.925604, 0.0>
  }
  object { // Asta_Ringhiera18->Asta Ringhiera
    Asta_Ringhiera
    translate  <14.059823, 43.271687, 0.0>
  }
  object { // Asta_Ringhiera17->Asta Ringhiera
    Asta_Ringhiera
    translate  <9.729141, 45.772007, 0.0>
  }
  object { // Asta_Ringhiera16->Asta Ringhiera
    Asta_Ringhiera
    translate  <4.973248, 47.317291, 0.0>
  }
  object { // Asta_Ringhiera15->Asta Ringhiera
    Asta_Ringhiera
    translate  <0.0, 47.84, 0.0>
  }
  object { // Asta_Ringhiera14->Asta Ringhiera
    Asta_Ringhiera
    translate  <-4.973248, 47.317291, 0.0>
  }
  object { // Asta_Ringhiera13->Asta Ringhiera
    Asta_Ringhiera
    translate  <-9.729141, 45.772007, 0.0>
  }
  object { // Asta_Ringhiera12->Asta Ringhiera
    Asta_Ringhiera
    translate  <-14.059823, 43.271687, 0.0>
  }
  object { // Asta_Ringhiera11->Asta Ringhiera
    Asta_Ringhiera
    translate  <-17.776024, 39.925604, 0.0>
  }
  object { // Asta_Ringhiera10->Asta Ringhiera
    Asta_Ringhiera
    translate  <-20.715328, 35.88, 0.0>
  }
  object { // Asta_Ringhiera9->Asta Ringhiera
    Asta_Ringhiera
    translate  <-22.749272, 31.311687, 0.0>
  }
  object { // Asta_Ringhiera8->Asta Ringhiera
    Asta_Ringhiera
    translate  <-23.788964, 26.420321, 0.0>
  }
  object { // Asta_Ringhiera7->Asta Ringhiera
    Asta_Ringhiera
    translate  <-23.788964, 21.419679, 0.0>
  }
  object { // Asta_Ringhiera6->Asta Ringhiera
    Asta_Ringhiera
    translate  <-22.749272, 16.528313, 0.0>
  }
  object { // Asta_Ringhiera5->Asta Ringhiera
    Asta_Ringhiera
    translate  <-20.715328, 11.96, 0.0>
  }
  object { // Asta_Ringhiera4->Asta Ringhiera
    Asta_Ringhiera
    translate  <-17.776024, 7.914396, 0.0>
  }
  object { // Asta_Ringhiera3->Asta Ringhiera
    Asta_Ringhiera
    translate  <-14.059823, 4.568313, 0.0>
  }
  object { // Asta_Ringhiera2->Asta Ringhiera
    Asta_Ringhiera
    translate  <-9.729141, 2.067993, 0.0>
  }
  object { // Asta_Ringhiera1->Asta Ringhiera
    Asta_Ringhiera
    translate  <-4.973248, 0.522709, 0.0>
  }
  object { Asta_Ringhiera }
  object { // Ringhiera_Sopra->Ringhiera sotto
    Ringhiera_sotto
    translate  -1.0*z
  }
  object { Ringhiera_sotto }
  material {
    RInghiera_tex
  }
  scale <0.99, 0.99, 1.0>
  translate  <-0.027249, 0.0, -1.5>
}
#declare Cylndr006 = object {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Cilindretti_in_cima
    }
    scale <0.19, 0.19, 0.78>
    rotate 45.0*x
    translate  <0.0, -9.261164, 0.194702>
  }
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  25  // control points
  <-1.0, -1.0>,
  <-0.989308, -2.006289>,
  <-0.006509, -2.006289>,
  <-0.006289, -0.63522>,
  <0.03561, -0.172327>,
  <0.092629, 0.108528>,
  <0.195043, 0.337726>,
  <0.312856, 0.48665>,
  <0.418044, 0.590988>,
  <0.548284, 0.699099>,
  <0.753747, 0.762512>,
  <1.001053, 0.790355>,
  <1.004146, 1.502783>,
  <0.845133, 1.894958>,
  <0.641532, 2.071433>,
  <0.500964, 2.180673>,
  <0.327603, 2.266639>,
  <0.06719, 2.321712>,
  <-0.107817, 2.321661>,
  <-0.352997, 2.2581>,
  <-0.609305, 2.134236>,
  <-0.780523, 1.977263>,
  <-0.930731, 1.753056>,
  <-0.995826, 1.502783>,
  <-1.0, -1.0>
  rotate -x*90
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  20  // control points
  <2.037983, -2.011472>,
  <-0.026777, -2.006289>,
  <-0.026557, -0.63522>,
  <0.015342, -0.172327>,
  <0.072361, 0.108528>,
  <0.174775, 0.337726>,
  <0.292588, 0.48665>,
  <0.397776, 0.590988>,
  <0.528016, 0.699099>,
  <0.733479, 0.762512>,
  <0.980785, 0.790355>,
  <1.247157, 0.76568>,
  <1.468809, 0.679994>,
  <1.637209, 0.575934>,
  <1.761927, 0.472976>,
  <1.855279, 0.34317>,
  <1.914921, 0.16116>,
  <1.968736, -0.158355>,
  <2.026277, -0.642952>,
  <2.037983, -2.011472>
  rotate -x*90
  scale <1.0, 1.0, 3.0>
}
#declare Portale_cima = union {
  object { // TransSweep003->TransSweep004
    TransSweep004
    rotate <-180.0, 0.0, -180.0>
    translate  <2.0, 0.0, 1.0>
  }
  object { TransSweep004 }
  object { TransSweep005 }
  scale <4.292707, 3.3, 4.292707>
  rotate <90.0, 0.0, 132.838974>
  translate  <-9.777293, -15.343878, 118.0>
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  16  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.906776, 1.297203>,
  <0.81037, 1.536131>,
  <0.627198, 1.831585>,
  <0.43174, 2.013986>,
  <0.237543, 2.153846>,
  <0.00838, 2.247086>,
  <-0.191935, 2.177156>,
  <-0.41993, 2.025641>,
  <-0.580828, 1.839161>,
  <-0.75338, 1.582751>,
  <-0.934965, 1.273893>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <0.508188, 1.0, 0.4>
}
#declare Finestra = union {
  object { TransSweep006 }
  object { // TransSweep007->TransSweep006
    TransSweep006
    scale <0.7, 0.7, 4.0>
    translate  0.4*z
  }
  scale <2.272727, 2.272727, 3.636364>
  rotate <90.0, -0.0, 180.0>
  translate  <0.170515, -17.555136, 120.777875>
}
#declare Cube003 = object {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale 0.08
    translate  <0.233355, 0.597487, -1.214619>
  }
}
#declare Cubetti = union {
  object { Cube003 }
  object { // Cube004->Cube003
    Cube003
    rotate <0.0, -0.0, -0.0>
    translate  <0.335833, 0.0, 0.317917>
  }
  object { // Cube005->Cube003
    Cube003
    rotate <0.0, -0.0, -0.0>
    translate  <0.687708, 0.0, 0.667917>
  }
  object { // Cube006->Cube003
    Cube003
    rotate <0.0, -0.0, -0.0>
    translate  <0.959375, 0.0, 0.969792>
  }
  scale <1.0, 2.0, 1.0>
  translate  <0.09625, -0.5, -0.064167>
}
#declare Cylndr005 = object {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 0.8>
    rotate -90.0*x
    translate  -0.15*y
  }
}
#declare Cube007 = object {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.2, 1.0>
    rotate -45.0*y
    translate  <-0.011405, 0.6, 0.0>
  }
}
#declare Rifinitura_Base = union {
  object { Cubetti }
  object { // Cylndr003->Cylndr005
    Cylndr005
    scale 1.4
    rotate -0.0*x
    translate  -0.7*y
  }
  object { // Cylndr004->Cylndr005
    Cylndr005
    scale 1.1
    translate  -0.339758*y
  }
  object { Cylndr005 }
  object { // Cube002->Cube007
    Cube007
    scale 0.4
    rotate -0.0*y
    translate  <-0.009124, 0.6, 0.0>
  }
  object { Cube007 }
  object { // Cubetti1->Cubetti
    Cubetti
    rotate -90.0*y
    translate  <0.032083, 0.0, -0.016042>
  }
  object { // Cubetti2->Cubetti
    Cubetti
    rotate <-180.0, 0.0, -180.0>
    translate  <-0.032083, 0.0, -0.016042>
  }
  object { // Cubetti3->Cubetti
    Cubetti
    rotate 90.0*y
    translate  <-0.0, 0.0, 0.0>
  }
  material {
    Marmo
  }
  scale 2.18609
  translate  <-0.004558, -24.314522, -6.0>
}
#declare Cube008 = object {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      Marmo
    }
    scale <1.0, 3.963726, 5.0>
    rotate <-0.0, 0.0, 30.05545>
    translate  <9.567525, -13.158439, 6.749825>
  }
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  16  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.906776, 1.297203>,
  <0.81037, 1.536131>,
  <0.627198, 1.831585>,
  <0.43174, 2.013986>,
  <0.237543, 2.153846>,
  <0.00838, 2.247086>,
  <-0.191935, 2.177156>,
  <-0.41993, 2.025641>,
  <-0.580828, 1.839161>,
  <-0.75338, 1.582751>,
  <-0.934965, 1.273893>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Marmo
  }
  scale <1.5, 1.0, 1.0>
}




//
// ********  OBJECTS  *******
//

sphere { // Sphere001
  <0,0,0>,1
  material {
    Cielo
  }
  hollow
  scale 5000.0
}




plane { // Terreno
  z,0
  material {
    pavimento
  }
}


#declare Cima_con_cilindretti = union {
  object { Cylndr006 }
  cone { // Sprogenza_in_cima
    <0,0,0>, 0.9, <0,0,1>, 1.0
    material {
      Sporgenza_cima
    }
    scale <10.0, 10.0, 1.0>
  }
  object { // Cylndr007->Cylndr006
    Cylndr006
    rotate -3.6*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr100->Cylndr006
    Cylndr006
    rotate 3.600006*z
    translate  <-0.000001, -0.0, -0.0>
  }
  object { // Cylndr010->Cylndr006
    Cylndr006
    rotate -32.400002*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr099->Cylndr006
    Cylndr006
    rotate 7.200012*z
    translate  <-0.000002, -0.0, -0.0>
  }
  object { // Cylndr011->Cylndr006
    Cylndr006
    rotate -36.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr009->Cylndr006
    Cylndr006
    rotate -28.799999*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr012->Cylndr006
    Cylndr006
    rotate -39.599998*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr013->Cylndr006
    Cylndr006
    rotate -43.200001*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr014->Cylndr006
    Cylndr006
    rotate -46.799999*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr015->Cylndr006
    Cylndr006
    rotate -50.400002*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr016->Cylndr006
    Cylndr006
    rotate -54.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr017->Cylndr006
    Cylndr006
    rotate -57.599998*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr018->Cylndr006
    Cylndr006
    rotate -61.200001*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr019->Cylndr006
    Cylndr006
    rotate -64.800003*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr020->Cylndr006
    Cylndr006
    rotate -68.400002*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr021->Cylndr006
    Cylndr006
    rotate -72.0*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr022->Cylndr006
    Cylndr006
    rotate -75.599998*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr023->Cylndr006
    Cylndr006
    rotate -79.199997*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr024->Cylndr006
    Cylndr006
    rotate -82.800003*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr025->Cylndr006
    Cylndr006
    rotate -86.400002*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr026->Cylndr006
    Cylndr006
    rotate -90.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr027->Cylndr006
    Cylndr006
    rotate -93.599998*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr028->Cylndr006
    Cylndr006
    rotate -97.199997*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr029->Cylndr006
    Cylndr006
    rotate -100.800003*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr030->Cylndr006
    Cylndr006
    rotate -104.400002*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr031->Cylndr006
    Cylndr006
    rotate -108.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr032->Cylndr006
    Cylndr006
    rotate -111.599998*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr033->Cylndr006
    Cylndr006
    rotate -115.199997*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr034->Cylndr006
    Cylndr006
    rotate -118.800003*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr035->Cylndr006
    Cylndr006
    rotate -122.400002*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr036->Cylndr006
    Cylndr006
    rotate -126.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr037->Cylndr006
    Cylndr006
    rotate -129.600006*z
    translate  <-0.000001, -0.000001, -0.0>
  }
  object { // Cylndr038->Cylndr006
    Cylndr006
    rotate -133.199997*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr039->Cylndr006
    Cylndr006
    rotate -136.800003*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr040->Cylndr006
    Cylndr006
    rotate -140.399994*z
    translate  <0.000001, 0.000001, -0.0>
  }
  object { // Cylndr041->Cylndr006
    Cylndr006
    rotate -144.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr042->Cylndr006
    Cylndr006
    rotate -147.600006*z
    translate  <-0.000001, -0.000001, -0.0>
  }
  object { // Cylndr043->Cylndr006
    Cylndr006
    rotate -151.199997*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr044->Cylndr006
    Cylndr006
    rotate -154.800003*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr045->Cylndr006
    Cylndr006
    rotate -158.399994*z
    translate  <0.000001, 0.0, -0.0>
  }
  object { // Cylndr046->Cylndr006
    Cylndr006
    rotate -162.0*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr047->Cylndr006
    Cylndr006
    rotate -165.600006*z
    translate  <-0.000001, -0.0, -0.0>
  }
  object { // Cylndr048->Cylndr006
    Cylndr006
    rotate -169.199997*z
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cylndr049->Cylndr006
    Cylndr006
    rotate -172.800003*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr050->Cylndr006
    Cylndr006
    rotate -176.399994*z
    translate  <0.000001, 0.0, -0.0>
  }
  object { // Cylndr051->Cylndr006
    Cylndr006
    rotate -180.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr052->Cylndr006
    Cylndr006
    rotate 176.399994*z
    translate  <-0.000001, 0.0, -0.0>
  }
  object { // Cylndr053->Cylndr006
    Cylndr006
    rotate 172.800003*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr054->Cylndr006
    Cylndr006
    rotate 169.199997*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr055->Cylndr006
    Cylndr006
    rotate 165.600006*z
    translate  <0.000001, -0.0, -0.0>
  }
  object { // Cylndr056->Cylndr006
    Cylndr006
    rotate 162.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr057->Cylndr006
    Cylndr006
    rotate 158.399994*z
    translate  <-0.000001, 0.0, -0.0>
  }
  object { // Cylndr058->Cylndr006
    Cylndr006
    rotate 154.800003*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr059->Cylndr006
    Cylndr006
    rotate 151.199997*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr060->Cylndr006
    Cylndr006
    rotate 147.600006*z
    translate  <0.000001, -0.000001, -0.0>
  }
  object { // Cylndr061->Cylndr006
    Cylndr006
    rotate 144.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr062->Cylndr006
    Cylndr006
    rotate 140.399994*z
    translate  <-0.000001, 0.000001, -0.0>
  }
  object { // Cylndr063->Cylndr006
    Cylndr006
    rotate 136.800003*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr064->Cylndr006
    Cylndr006
    rotate 133.199997*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr065->Cylndr006
    Cylndr006
    rotate 129.600006*z
    translate  <0.000001, -0.000001, -0.0>
  }
  object { // Cylndr066->Cylndr006
    Cylndr006
    rotate 126.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr067->Cylndr006
    Cylndr006
    rotate 122.399994*z
    translate  <-0.000001, 0.000001, -0.0>
  }
  object { // Cylndr068->Cylndr006
    Cylndr006
    rotate 118.800003*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr069->Cylndr006
    Cylndr006
    rotate 115.199997*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr070->Cylndr006
    Cylndr006
    rotate 111.600006*z
    translate  <0.0, -0.000001, -0.0>
  }
  object { // Cylndr071->Cylndr006
    Cylndr006
    rotate 108.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr072->Cylndr006
    Cylndr006
    rotate 104.399994*z
    translate  <-0.0, 0.000001, -0.0>
  }
  object { // Cylndr073->Cylndr006
    Cylndr006
    rotate 100.799988*z
    translate  <-0.0, 0.000002, -0.0>
  }
  object { // Cylndr074->Cylndr006
    Cylndr006
    rotate 97.200012*z
    translate  <0.0, -0.000002, -0.0>
  }
  object { // Cylndr075->Cylndr006
    Cylndr006
    rotate 93.600006*z
    translate  <0.0, -0.000001, -0.0>
  }
  object { // Cylndr076->Cylndr006
    Cylndr006
    rotate 90.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr077->Cylndr006
    Cylndr006
    rotate 86.399994*z
    translate  <0.0, 0.000001, -0.0>
  }
  object { // Cylndr078->Cylndr006
    Cylndr006
    rotate 82.799988*z
    translate  <0.0, 0.000002, -0.0>
  }
  object { // Cylndr079->Cylndr006
    Cylndr006
    rotate 79.200012*z
    translate  <-0.0, -0.000002, -0.0>
  }
  object { // Cylndr080->Cylndr006
    Cylndr006
    rotate 75.600006*z
    translate  <-0.0, -0.000001, -0.0>
  }
  object { // Cylndr081->Cylndr006
    Cylndr006
    rotate 72.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // Cylndr082->Cylndr006
    Cylndr006
    rotate 68.399994*z
    translate  <0.0, 0.000001, -0.0>
  }
  object { // Cylndr083->Cylndr006
    Cylndr006
    rotate 64.799988*z
    translate  <0.000001, 0.000002, -0.0>
  }
  object { // Cylndr084->Cylndr006
    Cylndr006
    rotate 61.200012*z
    translate  <-0.000001, -0.000002, -0.0>
  }
  object { // Cylndr085->Cylndr006
    Cylndr006
    rotate 57.600006*z
    translate  <-0.000001, -0.000001, -0.0>
  }
  object { // Cylndr086->Cylndr006
    Cylndr006
    rotate 54.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr087->Cylndr006
    Cylndr006
    rotate 50.399994*z
    translate  <0.000001, 0.000001, -0.0>
  }
  object { // Cylndr088->Cylndr006
    Cylndr006
    rotate 46.799988*z
    translate  <0.000001, 0.000001, -0.0>
  }
  object { // Cylndr089->Cylndr006
    Cylndr006
    rotate 43.200012*z
    translate  <-0.000001, -0.000001, -0.0>
  }
  object { // Cylndr090->Cylndr006
    Cylndr006
    rotate 39.600006*z
    translate  <-0.000001, -0.000001, -0.0>
  }
  object { // Cylndr091->Cylndr006
    Cylndr006
    rotate 36.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr092->Cylndr006
    Cylndr006
    rotate 32.399994*z
    translate  <0.000001, 0.000001, -0.0>
  }
  object { // Cylndr093->Cylndr006
    Cylndr006
    rotate 28.799988*z
    translate  <0.000002, 0.000001, -0.0>
  }
  object { // Cylndr094->Cylndr006
    Cylndr006
    rotate 25.200012*z
    translate  <-0.000002, -0.000001, -0.0>
  }
  object { // Cylndr095->Cylndr006
    Cylndr006
    rotate 21.600006*z
    translate  <-0.000001, -0.0, -0.0>
  }
  object { // Cylndr096->Cylndr006
    Cylndr006
    rotate 18.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr097->Cylndr006
    Cylndr006
    rotate 14.399994*z
    translate  <0.000001, 0.0, -0.0>
  }
  object { // Cylndr098->Cylndr006
    Cylndr006
    rotate 10.799988*z
    translate  <0.000002, 0.0, -0.0>
  }
  object { // Cylndr008->Cylndr006
    Cylndr006
    rotate -25.200001*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr101->Cylndr006
    Cylndr006
    rotate -21.6*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr102->Cylndr006
    Cylndr006
    rotate -18.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr103->Cylndr006
    Cylndr006
    rotate -14.4*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cylndr104->Cylndr006
    Cylndr006
    rotate -10.8*z
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr105->Cylndr006
    Cylndr006
    rotate -7.2*z
    translate  <-0.0, 0.0, -0.0>
  }
  scale <1.9, 1.9, 2.283019>
  translate  <-0.068594, 0.0, 127.038148>
}
#declare Cima_Torre = difference {
  cylinder { // CIMA_Torre
    <0,0,1>, <0,0,0>, 1 
    material {
      Marmo
    }
    scale <17.0, 17.295713, 19.0>
    translate  <0.027249, 0.0, 108.0>
  }
  cylinder { // Cilindro_Buco_Cima
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 17.55851>
    translate  109.038833*z
  }
  object { Portale_cima }
  object { // Portale_cima1->Portale_cima
    Portale_cima
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Portale_cima2->Portale_cima
    Portale_cima
    rotate <-0.0, 0.0, -180.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Portale_cima3->Portale_cima
    Portale_cima
    rotate <-0.0, 0.0, 90.0>
    translate  <-0.0, -0.0, -0.0>
  }                
   object { Finestra }
  object { // Finestra1->Finestra
    Finestra
    rotate <-0.0, -0.0, 180.0>
    translate  <0.304313, 0.279511, 0.0>
  }
  translate  0.0*x
}
#declare CIMA = union {
  object { Cima_con_cilindretti }
  object { Cima_Torre }
  cylinder { // Tetto_torre
    <0,0,1>, <0,0,0>, 1 
    material {
      Marmo
    }
    scale <19.0, 19.0, 1.0>
    translate  <-0.0, 0.0, 129.324674>
  }
  object { // Copia_Ringhiera_Cima->Ringhiera
    Ringhiera
    scale <0.72, 0.72, 1.0>
    translate  <-0.0, 0.0, 21.95>
  }
   scale 1.1
  rotate -0.0*y
  translate  <-0.226127, 0.061177, -11.0>
}
#declare Torre = union {
  object { Piano_Colonne }
  object { // Piano_Colonne1->Piano_Colonne
    Piano_Colonne
    translate  18.175*z
  }
  object { // Piano_Colonne2->Piano_Colonne
    Piano_Colonne
    translate  36.35*z
  }
  object { // Piano_Colonne3->Piano_Colonne
    Piano_Colonne
    translate  54.525*z
  }
  object { // Piano_Colonne4->Piano_Colonne
    Piano_Colonne
    translate  72.7*z
  }
  object { // Piano_Colonne5->Piano_Colonne
    Piano_Colonne
    translate  90.875*z
  }
  cylinder { // Cilindo_interno
    <0,0,1>, <0,0,0>, 1 
    material {
      Marmo
    }
    scale <20.0, 20.0, 108.0>
  }
  object { // Piano1->Piano
    Piano
    translate  -14.15*z
  }
  cylinder { // Base
    <0,0,1>, <0,0,0>, 1 
    scale <24.5, 24.5, 28.0>
    translate  -29.5*z
  }
  object { Ringhiera }
  object { CIMA }
  material {
    Marmo
  }
  translate  <0.027249, 0.0, 1.5>
}
#declare Rifinitura_base_torre = union {
  object { // Rifinitura_Base15->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 22.5>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base14->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base13->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 67.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Rifinitura_Base12->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base11->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 112.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Rifinitura_Base10->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 135.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base9->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, 157.5>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Rifinitura_Base8->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Rifinitura_Base7->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -157.5>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Rifinitura_Base6->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -135.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Rifinitura_Base5->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -112.5>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base4->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base3->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -67.5>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base2->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -45.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Rifinitura_Base1->Rifinitura_Base
    Rifinitura_Base
    rotate <0.0, 0.0, -22.5>
    translate  0.0*z
  }
  object { Rifinitura_Base }
}
#declare Ingresso = union {
  object { TransSweep008 }
  object { // TransSweep009->TransSweep008
    TransSweep008
    scale <0.7, 0.7, 1.5>
    translate  <0.0, -0.3, 1.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      Marmo
    }
    scale <1.512744, 3.413885, 6.0>
    translate  <0.0, -4.4, 6.0>
  }
  scale <2.0, 1.5, 1.0>
  rotate <90.0, 0.0, 161.162308>
  translate  <-9.272619, -23.182075, -16.36932>
}
difference { // Torre_da_fare_difference
  object { Torre }
  object { Rifinitura_base_torre }
  object { // Cube009->Cube008
    Cube008
    scale <1.0, 1.0, 1.29>
    rotate -62.756424*z
    translate  <-4.000671, 5.0, 64.383106>
  }
  object { // Cube010->Cube008
    Cube008
    scale <1.0, 1.0, 1.291352>
    rotate -0.0*x
    translate  <-5.523788, -0.1, 64.432828>
  }
  object { // Cube011->Cube008
    Cube008
    scale <1.0, 1.0, 1.29>
    rotate <-0.0, -0.0, -109.674019>
    translate  <0.823224, 4.0, 64.483106>
  }
  object { Cube008 }
  object { Ingresso }
  rotate 3.0*y
  translate  <5.833398, 0.0, 24.0>
}


