/* lunar.pov
 *
 * For use with POV-Ray v3.1
 *
 * This POV-Ray source file generates an image of an Apollo lunar
 * excusion module (LEM) on the surface of the moon. The earth is
 * visible in the background. 
 *
 * Copyright 1999 by Matthew Welch.  All Rights Reserved.
 */

global_settings { assumed_gamma 1.0 }

camera {
  location <0, 80, -130>
  look_at < 0, 80, 0 >
  //location <130, 66, -130>
  //look_at < 0, 25, -40 >
  angle 50
}

light_source { <0, 0, -2900000> rgb 1 rotate < 30, -45, 0 > }

/*sky_sphere {
  pigment {
    image_map {
      gif "starfld.gif"
      map_type 1
    }
  }
}

plane {
  -z, -300
  pigment {
    image_map { gif "starfld.gif" }
    scale 1000
  }
}*/

//plane { y, 0 pigment { color rgb 0.7 } }

///////////////////////////////////
// textures

#declare BasicWhite =
texture {
  pigment { color rgb 0.4 }
  normal {
    granite
    scale 20
    bump_size 1
  }
  finish {
    ambient 0
    diffuse 1
    specular 1
    roughness 0.1
    reflection 0.2
  }
}

#declare GoldFoil =
texture {
  pigment { color rgb < 0.83, 0.45, 0.0 > }
  normal {
    crackle
    scale < 2.5, 8, 2.5 >
    turbulence 0.2
    bump_size 10
  }
  finish {
    ambient 0
    diffuse 1
    specular 1
    roughness 0.01
    brilliance 8 //15
  }
}

#declare Gear2 =
texture {
  pigment { color rgb 0.5 }
  finish {
    ambient 0
    diffuse 1
    specular 0.7
    roughness 0.05
  }
}

#declare Gear3 =
texture {
  pigment { color rgb < 0.3, 0.2, 0.0 > }
  finish {
    ambient 0
    diffuse 1
    specular 0.5
    roughness 0.05
  }
}

#declare EngineMetal =
texture {
  pigment { color rgb 0.2 }
  finish {
    ambient 0
    diffuse 1
    specular 0.4
    roughness 0.1
  }
}

#declare AscentSilvery =
texture {
  pigment { color rgb 0.5 }
  finish {
    ambient 0
    diffuse 0.8
    specular 0.5
    roughness 0.01
    reflection 1
  }
}

#declare WindowDark =
texture {
  pigment { color rgb 0.01 }
  finish {
    ambient 0
    diffuse 0.7
    reflection 0.3
  }
}

#declare ReactorMetal =
texture {
  pigment { color rgb 0.8 }
  finish {
    ambient 0
    diffuse 1
    specular 1
    roughness 0.01
    brilliance 5
  }
}

#declare ShieldBlack =
texture {
  pigment { color rgb 0.05 }
  finish {
    ambient 0
    diffuse 1
    specular 0.3
    roughness 0.001
  }
}

///////////////////////////////////
// parts

#declare Engine =
object {
  cone { < 0, 8, 0 >, 10, < 0, 17, 0 >, 8 }
  texture { EngineMetal }
}

#declare HeatShield =
object {
  cylinder { < 0, 17, 0 >, < 0, 20, 0 >, 23 }
  texture { EngineMetal }
}

#declare LandingPad =
object {
  difference {
    sphere { < 0, 10.5, 0 > 10.5 }
    plane { -y, -1.885 }
    sphere { < 0, 10.5, 0 > 9.7 }
  }
  texture { GoldFoil }
}

#declare LandingGear1 =
object {
  union {
    cylinder { < 0, 0.5, 0 >, < 0, 42, 0 >, 1.5 }
    sphere { < 0, 42, 0 >, 1.5 }
    
    sphere { < -9, 28, 21 >, 1 }
    cylinder { < -9, 28, 21 >, < -10, 24, 17 >, 1 }
    sphere { < -10, 24, 17 >, 1 }    
    //cylinder { < -10, 24, 17 >, < 0, 19, 0 >, 1 }
    cylinder { < -10, 24, 17 >, < 9, 28, 21 >, 1 }
    cylinder { < -10, 24, 17 >, < -9, 38, 19 >, 1 }

    sphere { < 9, 28, 21 >, 1 }
    cylinder { < 9, 28, 21 >, < 10, 24, 17 >, 1 }
    sphere { < 10, 24, 17 >, 1 }    
    //cylinder { < 10, 24, 17 >, < 0, 19, 0 >, 1 }
    cylinder { < 10, 24, 17 >, < -9, 28, 21 >, 1 }
    cylinder { < 10, 24, 17 >, < 9, 38, 19 >, 1 }

    cylinder { < -9, 30, 21 >, < 0, 42, 0 >, 1 }
    cylinder { < 9, 30, 21 >, < 0, 42, 0 >, 1 }
    cylinder { < 0, 0, 0 >, < -9, 0, 16 >, 1 rotate -40*x translate 42*y }
    cylinder { < 0, 0, 0 >, < 9, 0, 16 >, 1 rotate -40*x translate 42*y }
  }
  texture { GoldFoil }
}

#declare LandingGear2 =
object {
  union {
    cylinder { < -10, 24, 17 >, < 0, 18, 0 >, 1 }
    cylinder { < 10, 24, 17 >, < 0, 18, 0 >, 1 }
  }
  texture { Gear2 }
}

#declare LandingGear3 =
object {
  union {
    cylinder { < -10, 24, 17 >, < -5, 21, 8.5 >, 1.5 }
    cylinder { < 10, 24, 17 >, < 5, 21, 8.5 >, 1.5 }
  }
  texture { Gear3 }
}

#declare LandingGear =
object {
  union {
    object { LandingGear1 }
    object { LandingGear2 }
    object { LandingGear3 }
    rotate 20*x
    translate -58*z
  }
}

#declare EngineHousing =
object {
  intersection {
    box { < -29, 20, -29 >, < 29, 46, 29 > }
    plane { x, 27.6 rotate 45*y }
    plane { x, 27.6 rotate 135*y }
    plane { x, 27.6 rotate 225*y }
    plane { x, 27.6 rotate 315*y }
  }
  texture { GoldFoil }
  texture { pigment { image_map { gif "unitstat.gif" once } scale < 10, 4.9, 1 > translate < -5, 38, 0 > rotate -45*y } }
  texture { pigment { image_map { gif "usflag.gif" once } scale < 10, 6.7, 1 > translate < -5, 36.2, 0 > rotate 45*y } }
  // on the back side of the LEM these two gifs show through backwards, so only render this from the front
}

#declare FuelStorageCompartment =
object {
  intersection {
    box { < -19, 54, 13 >, < 19, 80, 27 > }
    plane { x, 0 rotate -30*y translate < 19, 0, 27 > }
    plane { -x, 0 rotate 30*y translate < -19, 0, 27 > }
    plane { y, 0 rotate 20*x translate < 0, 80, 13 > }
    plane { y, 0 rotate < 20, 0, -30 > translate < 9, 80, 13 > }
    plane { y, 0 rotate < 20, 0, 30 > translate < -9, 80, 13 > }
  }
  texture { BasicWhite }
}

#declare MainBody =
object {
  union {
    intersection {
      box { < -19, 46, -13 >, < 19, 88, 13 > }
      plane { y, 0 rotate 45*z translate < -19, 78, 0 > }
      plane { y, 0 rotate -45*z translate < 19, 78, 0 > }
    }
    intersection {
      box { < 18, 46, -13 >, < 33, 66, 13 > }
      plane { x, 0 rotate 45*z translate < 28, 66, 0 > }
      plane { x, 0 rotate -45*z translate < 28, 46, 0 > }
      
      plane { x, 0 rotate < 0, 45, 45 > translate < 28, 66, -4 > }      
      plane { x, 0 rotate < 0, 45, -45 > translate < 28, 46, -4 > }      
      plane { x, 0 rotate < 0, 45, 0 > translate < 33, 0, -4 > }      

      plane { x, 0 rotate < 0, -45, 45 > translate < 28, 66, 4 > }      
      plane { x, 0 rotate < 0, -45, -45 > translate < 28, 46, 4 > }      
      plane { x, 0 rotate < 0, -45, 0 > translate < 33, 0, 4 > }      
    }
    intersection {
      box { < -26, 46, -13 >, < -18, 66, 13 > }
      plane { -x, 0 rotate -45*z translate < -21, 66, 0 > }
      plane { -x, 0 rotate 45*z translate < -21, 46, 0 > }
      
      plane { -x, 0 rotate < 0, -45, -45 > translate < -21, 66, -4 > }      
      plane { -x, 0 rotate < 0, -45, 45 > translate < -21, 46, -4 > }      
      plane { -x, 0 rotate < 0, -45, 0 > translate < -26, 0, -4 > }      

      plane { -x, 0 rotate < 0, 45, -45 > translate < -21, 66, 4 > }      
      plane { -x, 0 rotate < 0, 45, 45 > translate < -21, 46, 4 > }      
      plane { -x, 0 rotate < 0, 45, 0 > translate < -26, 0, 4 > }      
    }
  }
  texture { BasicWhite }
}

#declare CabinWalls =
object {
  union {
    intersection {
      cylinder { < 0, 65, -27 >, < 0, 65, -13 > 16.5 }
      plane { -z, 0 rotate 30*x translate < 0, 65, -27 > }
    }
    intersection {
      cylinder { < 0, 65, -31 >, < 0, 65, -13 > 16.5 }
      plane { -y, -65 }
      plane { -z, 0 rotate -45*y translate < 5, 0, -31 > }
      plane { -z, 0 rotate < -20, -45 0 > translate < 5, 74, -31 > }
      plane { -z, 0 rotate 45*y translate < -5, 0, -31 > }
      plane { -z, 0 rotate < -20, 45 0 > translate < -5, 74, -31 > }
    }
    cylinder { < 0, 72, -34 >, < 0, 72, -33 >, 2.5 }
  }
  texture { BasicWhite }
}

#declare CabinWindow =
object {
  union {
    box { < 0, -10, -0.1 >, < 12.7, 0, 0.1 > rotate < -20, -45 0 > translate < 5, 74, -31 > }
    box { < -12.7, -10, -0.1 >, < 0, 0, 0.1 > rotate < -20, 45 0 > translate < -5, 74, -31 > }
  }
  texture { WindowDark }
}

#declare Cabin =
object {
  union {
    object { CabinWalls }
    object { CabinWindow }
  }
}

#declare EquipmentShieldBody =
object {
  difference {
    intersection {
      box { < -8, 52, -33 >, < 8, 85, -12 > }
      plane { x, 0 rotate 6*z translate < 8, 52, 0 > }
      plane { -x, 0 rotate -6*z translate < -8, 52, 0 > }
      plane { -z, 0 rotate -25*x translate < 0, 65, -33 > }
    }
    intersection {
      box { < -7, 51, -34>, < 7, 65, -27 > }
      plane { x, 0 rotate 6*z translate < 7, 52, 0 > }
      plane { -x, 0 rotate -6*z translate < -7, 52, 0 > }      
    }
  }
  texture { BasicWhite }
}

#declare RoundThing =
object {
  cylinder { < 0, 72, -33.5 >, < 0, 72, -33 >, 4 }
  texture { WindowDark }
}

#declare EquipmentShield =
object {
  union {
    object { EquipmentShieldBody }
    object { RoundThing }
  }
}

#declare ReactorHousing =
object {
  union {
    intersection {
      box { < 10, 62, -23 >, < 23, 66, -19 > }
      plane { x, 0 rotate 45*y translate < 22, 0, -23 > }
    }
    cylinder { < 19.5, 58, -19.5 >, < 10, 46, -29 > 0.25 }
    cylinder { < 19.5, 58, -19.5 >, < 29, 46, -10 > 0.25 }
    cylinder { < 23, 46, -23 >, < 10, 46, -29 > 0.25 }
    cylinder { < 23, 46, -23 >, < 29, 46, -10 > 0.25 }
    cylinder { < 23, 46, -23 >, < 10, 43, -29 > 0.25 }
    cylinder { < 23, 46, -23 >, < 29, 43, -10 > 0.25 }
  }
  texture { BasicWhite }
}

#declare ReactorEngine =
object {
  union {
    cone { < 0, 0, -2 >, 0.25, < 0, 0, -6 >, 1 open translate < 21, 64, -21 > }
    cone { < 0, 0, -2 >, 0.25, < 0, 0, -6 >, 1 open rotate -90*y translate < 21, 64, -21 > }
    cone { < 0, 0, -2 >, 0.25, < 0, 0, -6 >, 1 open rotate -90*x translate < 21, 64, -21 > }
    cone { < 0, 0, -2 >, 0.25, < 0, 0, -6 >, 1 open rotate 90*x translate < 21, 64, -21 > }
  }
  texture { ReactorMetal }
}

#declare ReactorShield =
object {
  difference {
    cone { < 0, -14, 0 >, 4, < 0, 0, 0 >, 2  }
    cone { < 0, -14.1, 0 >, 3.5, < 0, 0.1, 0 >, 1.5  }
    plane { z, 1 }
    rotate < 30, -45, 0 >
    translate < 21, 59, -21 >
  }
  texture { ShieldBlack }
}

#declare ReactorControl =
object {
  union {
    object { ReactorHousing }
    object { ReactorEngine }
    object { ReactorShield }
  }
}

#declare CabinDoor =
object {
  difference {
    union {
      //box { < -5, 52, -28 >, < 5, 62, -27 > }
      box { < -3, 52, -27.5 >, < 3, 62, -27 > }
      box { < -5, 54, -27.5 >, < 5, 60, -27 > }
      cylinder { < -3, 60, -27.5 >, < -3, 60, -27 >, 2 }
      cylinder { < -3, 54, -27.5 >, < -3, 54, -27 >, 2 }
      cylinder { < 3, 60, -27.5 >, < 3, 60, -27 >, 2 }
      cylinder { < 3, 54, -27.5 >, < 3, 54, -27 >, 2 }
    }
    union {
      box { < -3, 52.5, -28 >, < 3, 61.5, -26.1 > }
      box { < -4.5, 54, -28 >, < 4.5, 60, -26.1 > }
      cylinder { < -3, 60, -28 >, < -3, 60, -26.1 >, 1.5 }
      cylinder { < -3, 54, -28 >, < -3, 54, -26.1 >, 1.5 }
      cylinder { < 3, 60, -28 >, < 3, 60, -26.1 >, 1.5 }
      cylinder { < 3, 54, -28 >, < 3, 54, -26.1 >, 1.5 }
    }
  }
  texture { ShieldBlack }
}

#declare RadarAntenna =
object {
  union {
    union {
      sphere { 0, 1 }
      cylinder { < 0, 0, 0 >, < 0, 0, 4 >, 1 }
      intersection {
        sphere { < 0, 0, 10 >, 6.5 }
        plane { z, 6 }
      }
      rotate 35*x
    }
    cylinder { < 0, 0, 0 >, < 0, -8, 0 >, 1 }
    translate 7*y
    rotate -45*x
    translate < 0, 85, -33 >
  }
  texture { EngineMetal }
}

#declare Ladder =
object {
  union {
    cylinder { < -4, 40.5, -1.75 >, < -4, 11.5, -1.75 >, 0.25 }
    cylinder { < 4, 40.5, -1.75 >, < 4, 11.5, -1.75 >, 0.25 }

    cylinder { < -4, 40, -1.75 >, < 4, 40, -1.75 >, 0.25 }
    cylinder { < -4, 36, -1.75 >, < 4, 36, -1.75 >, 0.25 }
    cylinder { < -4, 32, -1.75 >, < 4, 32, -1.75 >, 0.25 }
    cylinder { < -4, 28, -1.75 >, < 4, 28, -1.75 >, 0.25 }
    cylinder { < -4, 24, -1.75 >, < 4, 24, -1.75 >, 0.25 }
    cylinder { < -4, 20, -1.75 >, < 4, 20, -1.75 >, 0.25 }
    cylinder { < -4, 16, -1.75 >, < 4, 16, -1.75 >, 0.25 }
    cylinder { < -4, 12, -1.75 >, < 4, 12, -1.75 >, 0.25 }
    
    rotate 20*x
    translate -58*z
  }
  texture { BasicWhite }
}

///////////////////////////////////
// surface of the moon

object {
  height_field {
    gif "moonsurf.gif"
    scale < 1000, 60, 1000 >
    translate < -300, 0, -100 >
  }
  texture {
    pigment { rgb 0.7 }
    normal {
      granite
      scale 70
      bump_size 8
    }
    finish {
      ambient 0
      diffuse 1
    }
  }
}

///////////////////////////////////
// earth in background

// The Earth radius, distance from moon and distance to sun are at 1/1,000,000 scale
// which looks ok and made the numbers not be really huge.

#declare EarthSurface =
object {
  sphere { 0, 200   // earth about double scale in radius, should be 125
  }
  texture {
    pigment {
      image_map { gif "livearth.gif" map_type 1 }
    }
    finish { ambient 0 diffuse 1 }
  }
  rotate -90*y
  translate < 0, 0, 7540 >
}

#declare EarthClouds =
object {
  sphere { < 0, 0, 7540 >, 201   // earth about double scale in radius, should be 125
  }
  texture {
    pigment {
      bozo
      turbulence 0.7
      scale < 80, 20, 80 >
      color_map {
        [0.5 rgbf 1]
        [0.9 rgb 1]
      }
    }
    finish { ambient 0 diffuse 1 }
  }
}

object {
  union {
    object { EarthSurface }
    object { EarthClouds }
  }
  rotate < -10, 10, 0 >
}

///////////////////////////////////
// lander

#declare LEM=
object {
  union {
    object { Engine }
    object { HeatShield }
    object { LandingPad translate < 58, 0, 0 > }
    object { LandingPad translate < -58, 0, 0 > }
    object { LandingPad translate < 0, 0, 58 > }
    object { LandingPad translate < 0, 0, -58 > }
    object { LandingGear }
    object { LandingGear rotate 90*y }
    object { LandingGear rotate 180*y }
    object { LandingGear rotate 270*y }
    object { EngineHousing }
    object { FuelStorageCompartment }
    object { MainBody }
    object { Cabin }
    object { EquipmentShield }
    object { ReactorControl }
    object { ReactorControl scale -z }
    object { ReactorControl scale -x }
    object { ReactorControl scale < -1, 0, -1 > }
    object { CabinDoor }
    //object { RadarAntenna }
    object { Ladder }
  }
}

object { LEM rotate 15*y translate < -35, 0, 200 > } // < -35, 0, 130 >
