
// Persistence of Vision Ray Tracer Scene Description File
// File: monument.pov
// Vers: 3.1
// Desc: Monument inmitten eines Gebirgssees
// Date: August 1999
// Auth: Roy Schulz

#include "colors.inc"

global_settings { max_trace_level 10 }

#declare StandardCam = camera {
  location <0, 2, -40>
  look_at <0, 10, 0>
}

#declare TopCam = camera {
  location <0, 40, -.01>
  look_at <0, 10, 0>
  angle 35
}

#declare HandyCam = camera {
  location <-1.5, 1.1, -8.6>
  look_at <-1.75, 1, -8.6>
}

#declare PanoramaCam = camera {
  location <0, 2, -40>
  up y
  right x*2
  look_at <0, 11, 0>
  angle 75
}

camera { StandardCam }
//camera { TopCam }
//camera { HandyCam }
//camera { PanoramaCam}

light_source {
  <-40000, 40000, 100000>
  color White
  looks_like {
    disc {
      0, -z, 10000
      pigment {
        onion
        color_map {
          [ 0 White ]
          [ .15 White ]
          [ .15 color rgbt <1, 1, 1, .2> ]
          [ 1 color rgbt 1 ]
        }
        scale 10000
      }
      finish { diffuse 0 ambient 1 }
    }  
  }
}

light_source { <-10000, 1000, 2000> color Gray60 shadowless }
light_source {
  <6000, 10000, -10000>
  color Gray40
  area_light <10000, 0, 10000>, <10000, -10000 -10000>, 5, 5
  adaptive 1
  jitter
}
 

// --- Deklarationen ---


#declare Element = difference {
  cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <6, 14, .5> }
  cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <4.5, 13, .51> }
  plane { y, 0 }
  plane { -y, -12 }
} 

#declare Saeule = union {
  sphere { <0, 1, 0>, .05 }
  cylinder { 0, <0, 1, 0>, .03 }
}

#declare Monument = union {
  cylinder { 0, <0, 12, 0>, 1.1 }
  sphere { 0, 1 scale <1.1, 12, 1.1> translate y*12 }
  object { Element }
  object { Element rotate y*60 }
  object { Element rotate y*120 }
  difference {
    union {
      cylinder { <0, .1, 0>, <0, -1, 0>, 9 }
      box { <-2, .1, -50>, <2, -1, 0> }
    }
    cylinder { 0, <0, .2, 0>, 8.5 }
    box { <-1.5, 0, -49.5>, <1.5, .2, -1> }
  }
  union {
    cylinder { <-1.75, 1, -50>, <-1.75, 1, -8.58>, .03 }
    cylinder { <1.75, 1, -50>, <1.75, 1, -8.58>, .03 }
    difference {
      torus { 8.75, .03 translate y }
      box { <-1.75, .95, -9>, <1.75, 1.05, -8> }
    }
    #declare i=-8.58;
    #while (i>-50)
      #declare i=i-2.5;
      object { Saeule translate <-1.75, 0, i> }
      object { Saeule translate <1.75, 0, i> }
    #end
    #declare i=11.5;
    #while (i<360)   
      object { Saeule translate -z*8.75 rotate y*i }
      #declare i=i+16.85;
    #end  
    pigment { Gray50 }
    finish {
      reflection .7
      diffuse 0
      specular 1
      roughness .01
      metallic
    }
  }     
  pigment { color rgb <1, 1, .8> }
  normal { granite .1 scale .1 }
  finish { ambient 0 }
}                  
  
  
// --- Szene --- //
  
  
sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0 color rgb <.8, .9, 1> ]
      [ 1 color rgb <.3, .6, .9> ]
    }
  }
}

plane {
  y, 1000
  pigment {
    granite
    color_map {
      [ .6 White transmit 1 ]
      [ 1 White transmit .2 ]
    }
    scale 1000
  }
  finish { diffuse 0 ambient 1 }
}

height_field {
  png "berge.png"
  smooth
  translate <-.5, -.1, -.8>
  scale <5000, 800, 5000>
  rotate y*90
  pigment { color rgb <.7, .85, 1> }
  normal { granite }
  finish {
    diffuse .3
    brilliance .5
  }
}

plane {
  y, -1
  pigment { color Black }
  finish {
    reflection .9
    specular 1
    roughness .005
  }
  normal { bumps .1 scale .2 }
}

object { Monument }
