// DO_Palm1
// palm tree
// The following objects are defined in this file:
//    DO_Palm1 - a tree that looks like a palmetto tree
//    bottom center of tree is at <0,0,0>
//    note : This palm tree requires approximately 15MB of memory

#ifndef (DO_PALM1_INC)
#declare DO_PALM1_INC = version
#version 3

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare R1 = seed(0)

// curved spike: height = 0.25, width = 0.05, thickness = 0.025
#declare Spike =
   difference {
      cylinder { <-.1,0,0>, <.1,0,0>, 1 translate <0,0,1> }
      cylinder { <-.11,0,0>, <.11,0,0>, 2.736 translate <0,0,2.786> }
      box { <-.2,-1.1,-.1>, <.2,0,2.1> }
      box { <-.5,-.1,-.1>, <0,1.1,2.1> rotate z*-5.711 translate x*-.05 }
      box { <0,-.1,-.1>, <.5,1.1,2.1> rotate z*5.711 translate x*.05 }
      scale .5
      texture { pigment { color rgb <.6,.5,.4> } }
   }

// a circular row of curved spikes
#declare Radius = .1
#declare Angle = 0
#declare Num = 14
#declare AngleInc = 360 / Num
#declare RowOfSpikes = union {
#while (Angle < 360)
   object {
      Spike
      scale 1+rand(R1)*.2 - 0.1
      rotate z*(rand(R1)*12-6)
      rotate x*(rand(R1)*20)
      translate z*(Radius-.025) rotate y*Angle
      }
   #declare Angle = Angle + AngleInc
#end
}

// the trunk: a collection of circular rows
#declare Num = 10 // the number of rows of spikes
#declare BottomR = Radius
#declare TopR = Radius * 0.5
#declare RadiusInc = (BottomR - TopR) / Num
#declare Count = 0
#declare Height = 0
#declare MaxHeight = 1
#declare HeightInc = MaxHeight / Num
#declare Radius = BottomR
#declare Trunk = union {
#while (Count < Num)
   object {
      RowOfSpikes
      scale <Radius/BottomR,1,Radius/BottomR>
      translate y*Height
      rotate y*(5*AngleInc*Count/2)
      }
   #declare Height = Height + HeightInc
   #declare Radius = Radius - RadiusInc
   #declare Count = Count + 1
#end
cone { <0,0,0>, BottomR, <0,Height,0>, TopR
   texture { pigment { color rgb <.6,.5,.4> } }
   }
}

// a leaf from the palm plant, based on DO_Plant4
#declare Leaf3Pt1 =
difference {
   cylinder { <-.3,0,0>, <.3,0,0>, 1 open translate <0,-.866,0> }
   box { <-2,-2,-2> <0,2,2> rotate z*20 }
   box { < 0,-2,-2> <2,2,2> rotate z*-20 }
   texture {
      pigment { color rgb <.2,.5,.1> }
      finish { specular .15 }
      }
   }

#declare Leaf3 =
difference {
   object { Leaf3Pt1 }
   object { Leaf3Pt1 scale <2,1,1> translate <0, -0.001, 0> }
   translate <0,0,.5>
   }

// the stem the leaves are attached to
#declare Stem3 =
difference {
   cylinder { <0,0,-.01>, <0,0,.01>, 1 translate x }
   cylinder { <0,0,-.03>, <0,0,.03>, 0.99 translate x }
   box { <.5,-3,-3> <3,3,3> }
   box { <-3,-3,-3> <3,0,3> }
   box { <-3,-3,-3> <3,3,0> rotate x*.66  translate z*-.01 }
   box { <-3,-3, 0> <3,3,3> rotate x*-.66 translate z*.01  }
   texture { pigment { color rgb <0,.9,0> } }
   }

#declare Angle = 20
#declare Delta = 2
#declare NumLeaves = (60-Angle)/Delta
#declare LeafSize = .25  // largest leaf spans this distance

// Stalk3.  Looks like a palm frond.
#declare Stalk3 =
union {
object { Stem3 }
#while (Angle < 60)
   #declare Size = LeafSize*(sin( ((((Angle-20)/40))) *3.14159 ) )+(LeafSize*.1)
   object { Leaf3 scale Size
      rotate z*90  rotate x*(-30)
      translate <-1,0,0> rotate z*(-Angle) translate <1,0,0> }
   object { Leaf3 scale Size
      rotate y*180 rotate z*90 rotate x*30
      translate <-1,0,0> rotate z*(-Angle) translate <1,0,0> }
   #declare Angle = Angle + Delta
#end
rotate <0,0,-90>
}

#declare Rp = seed (10)
// this is the minimum height (approximately) of the smallest stalk
#declare P3minscale = .9
// this is the max height (approximately) of the largest stalk,
// and therefore of the plant
#declare P3maxscale = .9
#declare P3scale = P3maxscale
// the approximate minimum angle (relative to horizon)
// that one of the stalks will lean
#declare P3minangle = 0
#declare P3maxangle = 90
#declare P3angle = P3minangle
#declare P3rot = 0
// the number of stalks in the whole plant;
// determines how full or sparse the plant is
#declare Numstalks = 28

#declare N = 0
#declare DO_Plant4a = union {
#while (N<Numstalks)
   object { Stalk3 scale P3scale
      rotate z*P3angle+rand(Rp)*16-8  // make it lean a little at random
      rotate y*P3rot }
   #declare P3rot = P3rot + rand(Rp)*30-15 + 70  // make the rotation a bit random
   #declare P3angle = P3angle + (P3maxangle-P3minangle)/(Numstalks-1)
   #declare P3scale = P3scale - (P3maxscale-P3minscale)/(Numstalks-1)
   #declare N = N + 1
#end
}

#declare DO_Palm1 = union {
   object { Trunk }
   object { DO_Plant4a translate y*1 }
   }

// Uncomment the section below to render an image of the palm
/*
object { DO_Palm1 }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
torus { 0.5, 0.05 texture { T_Stone13 } }
cylinder { <0,0,0>, <0,.01,0>, 0.51 texture { pigment { color rgb <0,0,0> } } }
light_source { <-20,50,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
camera { location <0,.9,-2.4> look_at <0,.9,0> }
*/

#version DO_PALM1_INC
#end

