 pdmdcstl.pov/pdmdcstl.pov   <pżpD    (TEXTPOV3          /                         // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"

/*
Time For Parse:    0 hours  0 minutes  24.0 seconds (24 seconds)
Time For Trace:    0 hours 23 minutes  18.0 seconds (1398 seconds)
    Total Time:    0 hours 23 minutes  42.0 seconds (1422 seconds)
*/

// Flags - not all implemented yet.
#declare Detailed  = 1;

// Units
#declare in = 1;
#declare ft = 12;
#declare yd = 36;
#declare mi = 1760*yd;
#declare sx = 1/16;
#declare m  = 39.375*in;

#declare LAimage    =<200,27,125>*yd;
#declare LAoverview =<0*ft,175*ft,50*m>;
#declare VPclose    =<-75,80,-25>*m;
#declare VPnear     =<-150,80,25>*m;
#declare VPcliff    =<500,85,-375>*m;//<500,10,-375>*m;

//#declare ViewPoint=LAimage+<0*ft,140*ft,-200*ft>;#declare LookAt=LAimage;
//#declare ViewPoint=LAimage+<0,250,-500>*ft;#declare LookAt=LAimage;
//#declare ViewPoint=LAimage+<300,0,-500>*ft;#declare LookAt=LAimage;
//#declare ViewPoint=LAoverview+<0*ft,800*ft,-.375*mi>;#declare LookAt=LAoverview;
//#declare ViewPoint=LAoverview+<0*ft,800*ft,49*m>;#declare LookAt=LAoverview;
//#declare ViewPoint=LAoverview+<0*ft,1200*ft,-.375*mi>;#declare LookAt=LAoverview;
//#declare ViewPoint=LAoverview+<0*ft,1600*ft,-.5*mi>;#declare LookAt=LAoverview;
//#declare ViewPoint=VPclose;#declare LookAt=VPclose+<75,10,25>*m;
//#declare ViewPoint=VPnear;#declare LookAt=VPnear +<75,15,25>*m;
#declare ViewPoint=VPcliff;#declare LookAt=LAoverview;

global_settings{
  assumed_gamma 1.0
}

sky_sphere{
  pigment{
    gradient y
    colour_map{
      [0.500 colour rgb <0.5, 0.5, 0.8>]
      [1.000 colour rgb <0.0, 0.0, 0.4>]
    }
    scale 2
    translate -1
  }
  pigment{
    bozo
    turbulence 0.65
    octaves 6
    omega 0.8
    lambda 2
    colour_map{
      [0.000 colour rgb <0.88, 0.88, 0.93>]
      [0.100 colour rgb <0.90, 0.90, 0.90>]
      [0.300 colour rgbt <1.00, 1.00, 1.00, 1.00>]
      [1.000 colour rgbt <1.00, 1.00, 1.00, 1.00>]
    }
    scale <0.5, 0.1, 0.5>
    rotate 170*z
    //rotate y*57
  }
}

#declare Shingle=
texture{
  pigment{
    hexagon
    pigment{colour rgb < 0.4, 0.4, 0.4>}
    pigment{colour rgb < 0.85, 0.5, 0.5>}
    pigment{colour rgb < 0.85, 0.85, 0.5>}
  }
  normal{
    bumps .1 scale <0.125,1,0.125> frequency 3
    turbulence 1 omega .4 lambda .5 octaves 3
  }
  rotate x*90
}

#declare Grass=
texture{
  pigment{
    colour rgb < 0.4, 0.8, 0.6>
  }
  finish {
    roughness 0.4
  }
  normal{bumps .1 scale <0.1,1,0.1>*ft frequency 5
    turbulence 1 omega .8 lambda 1.5 octaves 3
  }
}

#declare CliffFace=
texture{
  pigment{
    colour rgb <.95,.95,.98>*0.8
  }
  normal{waves 1 scale <.25,100,.1>*m}
}

#declare Sea=
texture{
  pigment{
    colour rgbf <.7,.7,.8,.9>
  }
  finish {
    reflection 0.3
  }
  normal{waves .2 frequency 20
    turbulence 1  omega .8  lambda 1.5 octaves 3
    scale .1  translate <0,0,-50>
  }
}

#declare Levels=
texture{
    gradient y
    texture_map{
      [0.000 Shingle]
      [0.120 Shingle]
      [0.121 CliffFace]
      [0.700 CliffFace]
      [0.701 Grass]
      [1.000 Grass]
    }
}

#declare Chalk=
texture{
  pigment{
    colour rgb < 0.9, 0.9, 1.0>*1.25
  }
  #if (Detailed=1)
    finish {
      roughness 0.4
    }
    normal{bumps 6*in scale <0.1,1,0.1> frequency 5
      turbulence 1 omega .8 lambda 1.5 octaves 3
    }
  #end
}

#declare CastleStone =
// Based on the PinkAlabaster texture and a photo in a book of castles.
texture{
  pigment{
    granite
    turbulence 0.25
    colour_map{
      [0, 1 colour rgb <0.9, 0.9, 0.75>
            colour rgb <0.6, 0.6, 0.6> ]
    }
    scale 0.4
  }
  finish{ambient 0.2}
}
texture{
  pigment {
    granite turbulence 0.2
    colour_map {
      [0.0, 0.9 colour rgbf <0.78, 0.52, 0.39, 1.0> 
                colour rgbf <0.78, 0.52, 0.39, 0.5>]
      [0.9, 1.0 colour rgbf <0.63, 0.42, 0.55, 0.0>
                colour rgbf <0.63, 0.42, 0.55, 0.0>]
    }
    scale 2  
  }
  finish{
    specular 1   
    roughness 0.0001
    phong 0.25
    phong_size 75
    brilliance 4
  }
}

#declare Churchstone =
texture{
  pigment{
    granite
    turbulence 0.25
    colour_map{
      [0.0 colour rgb <0.9, 0.6, 0.75>]
      [1.0 colour rgb <0.6, 0.6, 0.6> ]
    }
    scale 0.4
  }
  finish{ambient 0.2}
}

camera{
  location    ViewPoint
  look_at     LookAt
}



light_source{// Sun
  <2*mi,4*mi,-2*mi>
  colour rgb 1
}

light_source{// Sun
  <2*mi,4*mi,2*mi>
  colour rgb .125
}

light_source{// Sun
  <-2*mi,4*mi,2*mi>
  colour rgb .125
}

// Landscape: Basic 0 level
height_field{
  gif "Castleland01.gif"
  smooth
  texture{
    Levels
  }
  translate <-.5,-.05,-.5>
  scale <1000*m,100*m,750*m>
}


box{//water
  <-600,-10,-500>*m,<600,5,500>*m
  texture{Sea}
}


//keep
union{
  box{
    <-18,82,-16>*m,<18,107,16>*m
  }
  box{
    <-3,82,-17>*m,<3,107,17>*m
  }
  box{
    <-19,82,-3>*m,<19,107,3>*m
  }
  //corner tower sections
  box{
    <-19,82,-17>*m,<-13,109,-11>*m
  }
  box{
    <-19,82,17>*m,<-13,109,11>*m
  }
  box{
    <19,82,-17>*m,<13,109,-11>*m
  }
  box{
    <-19,82,17>*m,<-13,109,11>*m
  }
  rotate y*30
  translate <-62,0,77>*m
  texture{CastleStone}
}

//pharos
cylinder{
  <88,82,-35>*m,<88,101,-35>*m,8*m
  texture{Chalk}
}

//church
union{
  box{
    <-19,82,-8>*m,<19,91,8>*m
  }
  box{
    <-14,82,-14>*m,<-4,90,14>*m
  }
  box{
    <-14,82,-8>*m,<-4,98,8>*m
  }
  rotate y*-23
  translate <116.5,0,-24>*m
  texture{Churchstone}
}

                                                                                                                  6  6   e u i l t - i n )        s0pdmdcstl.povage Bufferth-dt.jpgiTEXTPOV3                      r                                                                                                                         H 	Monaco  N     ^ N(F ^ N(FP  $  $  L     ^ N(F ^ N(F  L              X   #  w ttxt8BIMGKONGKONTVOD     	                         >                               ?  rpza                  A +  k |     d     F       6  6   e28@    R MPSR  FPRF   *           L    6     nPOV-Ray File Prefs                                                                                                     