// written by Marc Schimmler July 1999
// needs kolors.inc by Ken Tyler
// *************************************************** resistor

#macro resistor (col1,col2,col3,col4)
object{
 union {

  superellipsoid {<1,0.25> 
                  texture{pigment{PeachPuff }
                          finish{reflection 0.2
                                 ambient 0.2
                                 diffuse 0.3
                                 specular 0.4
                                 roughness 0.001}
                          }   
                  scale <1,1,3>
                  scale (1.0/12.0) }

  intersection{
   torus {0.05, 0.01 } 
   box {<0,1,0>, <0.05,-1,0.05>}
   rotate <0,0,90>
   translate <0,-0.05,0.25>
   texture {T_Chrome_5B}
  }

  intersection{
   torus {0.05, 0.01 } 
   box {<0,1,0>, <0.05,-1,0.05>}
   rotate <0,90,0>
   rotate <0,0,90>
   translate <0,-0.05,-0.25>
   texture {T_Chrome_5B}
  }

  cylinder {<0,0,0>,<0,-0.125,0>,0.01 
            texture{T_Chrome_5B}
            translate <0,-0.05,0.295> }

  cylinder {<0,0,0>,<0,-0.125,0>,0.01 
            texture{T_Chrome_5B}
            translate <0,-0.05,-0.295>}

  cylinder {<0,0,-0.15>,<0,0,-0.2>,0.085 
            pigment{col1}}

  cylinder {<0,0,-0.1>,<0,0,-0.05>,0.085
            pigment{col2}}

  cylinder {<0,0,0.0>,<0,0,0.05>,0.085
            pigment{col3}}

  cylinder {<0,0,0.1>,<0,0,0.2>,0.085
            pigment{col4}}


 }
 translate <0,0.13,0.295>
 scale (1/5.9)
 scale 1.5
 rotate <90,0,0>
}
#end

// *************************************************** transistor

#declare transistor = object{

union{

 intersection{
  cylinder {<-0.025,0.025,0.025>,<-0.025,0.025,0.055>,0.025}
  box {<0.01,-0.01,0>,<-0.06,0.0375,0.06>}
  texture{pigment {Black}
          finish {ambient 0.1
                  diffuse 0.2
                  reflection 0.1
                  specular   0.4
                  roughness  0.01}
         }
 } 

 cylinder{<0,0,-0.001>,<-0.025,0.025,0.04>,0.0025 
          texture{T_Chrome_5B} }
 cylinder{<-0.05,0,-0.001>,<-0.025,0.025,0.04>,0.0025 
          texture{T_Chrome_5B} }
 cylinder{<-0.025,0.05,-0.001>,<-0.025,0.025,0.04>,0.0025 
          texture{T_Chrome_5B} }
 }
}

// *************************************************** 16 pin chip

#declare pin16chip = object{

union{
 difference{
  box{<0.025,0,0.025>,<-0.375,0.1,0.075>}
  cylinder{<0.025,0.05,0.05>,<0.025,0.05,0.1>,0.025}
  texture{pigment {Black}
          finish {ambient 0.1
                  diffuse 0.2
                  reflection 0.1
                  specular   0.4
                  roughness  0.01}
         }
 }

 #declare i = 0;
 
 #while ( i<8 )
  union{
   box{<0.0125,0,0.025>,<-0.0125,-0.0025,0.05> }
   cylinder {<0,-0.00125,0.025>,<0,-0.00125,-0.01>,0.005 }   
   texture{T_Chrome_5B}
   translate <-i*0.05,0,0>
  }

  union{
   box{<0.0125,0,0.025>,<-0.0125,-0.0025,0.05> }
   cylinder {<0,-0.00125,0.025>,<0,-0.00125,-0.01>,0.005 }   
   texture{T_Chrome_5B}
   translate <0,0.1025,0>
   translate <-i*0.05,0,0>
  }

  #declare i = i + 1;
 #end

 }
 translate <0,0,-0.02>
}

// *************************************************** 10 pin chip

#declare pin10chip = object{

union{
 difference{
  box{<0.025,0,0.025>,<-0.225,0.1,0.075>}
  cylinder{<0.025,0.05,0.05>,<0.025,0.05,0.1>,0.025}
  texture{pigment {Black}
          finish {ambient 0.1
                  diffuse 0.2
                  reflection 0.1
                  specular   0.4
                  roughness  0.01}
         }
 }

 #declare i = 0;
 
 #while ( i<5 )          // number of pins in a row
  union{
   box{<0.0125,0,0.025>,<-0.0125,-0.0025,0.05> }
   cylinder {<0,-0.00125,0.025>,<0,-0.00125,-0.01>,0.005 }   
   texture{T_Chrome_5B}
   translate <-i*0.05,0,0>
  }

  union{
   box{<0.0125,0,0.025>,<-0.0125,-0.0025,0.05> }
   cylinder {<0,-0.00125,0.025>,<0,-0.00125,-0.01>,0.005 }   
   texture{T_Chrome_5B}
   translate <0,0.1025,0>
   translate <-i*0.05,0,0>
  }

  #declare i = i + 1;
 #end

 }
 translate <0,0,-0.02>
}

// *************************************************** condensator

#declare condensator = object{
 union {

  superellipsoid {<1,0.25> 
                  texture{pigment{Blue4 }
                          finish{reflection 0.1
                                 ambient 0.2
                                 diffuse 0.3
                                 specular 0.1
                                 roughness 0.01}
                          }   
                  scale <1,1,3>
                  scale (1.0/12.0) }

  intersection{
   torus {0.05, 0.01 } 
   box {<0,1,0>, <0.05,-1,0.05>}
   rotate <0,0,90>
   translate <0,-0.05,0.25>
   texture {T_Chrome_5B}
  }

  intersection{
   torus {0.05, 0.01 } 
   box {<0,1,0>, <0.05,-1,0.05>}
   rotate <0,90,0>
   rotate <0,0,90>
   translate <0,-0.05,-0.25>
   texture {T_Chrome_5B}
  }

  cylinder {<0,0,0>,<0,-0.125,0>,0.01 
            texture{T_Chrome_5B}
            translate <0,-0.05,0.295> }

  cylinder {<0,0,0>,<0,-0.125,0>,0.01 
            texture{T_Chrome_5B}
            translate <0,-0.05,-0.295>}

 }
 translate <0,0.13,0.295>
 scale (1/5.9)
 scale 1.5
 rotate <90,0,0>
}

// *************************************************** condensator 2

#declare condensator2 = object{
union{

difference{
 torus{0.05,0.0025 
       scale <1,1,0.5> 
       rotate <0,0,90>
       translate <0,-0.05,0>}
 box{<0.1,0.1,0>,<-0.1,-0.1,-0.1>}
 texture {T_Chrome_5B}
 }
 
 sphere{<0,-0.05,0.05>,0.03 
        pigment{Flesh}
        scale<0.3,1,1>}
 }
}

// *************************************************** condensator 3

#declare condensator3 = object{

union{ 

 difference{
  superellipsoid{<1,0.25> scale <1,1,2>}
  torus{1.5,0.55 rotate<90,0,0> translate<0,0,1.3>}
  cylinder {<0,0,-1.98>,<0,0,-2.5>,0.6 texture{T_Chrome_5B} }
  texture{
   pigment{marble 
           pigment_map{
                [0.7 RoyalBlue1]
                [0.7 Gray70A        ]}
           translate <0.5,0,0>
           scale 1.5}
   finish{reflection 0.01
          ambient 0.2
          diffuse 0.3
          specular 0.1
          roughness 0.01}
         }
  }
  cylinder {<0,0.5,1.9>,<0,0.5,3>,0.05 texture{T_Chrome_5B}}
  cylinder {<0,-0.5,1.9>,<0,-0.5,3>,0.05 texture{T_Chrome_5B}}
}
  rotate <180,0,0>
  translate <0,-0.5,2>
  scale 0.08}

// *************************************************** condensator 4

#declare condensator4 = object{

union{ 

 difference{
  superellipsoid{<1,0.25> scale <1,1,2>}
  torus{1.5,0.55 rotate<90,0,0> translate<0,0,1.3>}
  cylinder {<0,0,-1.98>,<0,0,-2.5>,0.6 texture{T_Chrome_5B} }
  texture{
   pigment{marble 
           pigment_map{
                [0.7 Firebrick1]
                [0.7 Gray70A        ]}
           translate <0.5,0,0>
           scale 1.5}
   finish{reflection 0.01
          ambient 0.2
          diffuse 0.3
          specular 0.1
          roughness 0.01}
         }
  }
  cylinder {<0,0.5,1.9>,<0,0.5,3>,0.05 texture{T_Chrome_5B}}
  cylinder {<0,-0.5,1.9>,<0,-0.5,3>,0.05 texture{T_Chrome_5B}}
}
  rotate <180,0,0>
  translate <0,-0.5,2>
  scale 0.04}

// *************************************************** led
/*
#macro led (ledcol,status)
 merge{
  sphere{<0,0,0.15>,0.05}
  cylinder{<0,0,0.15>,<>,}
  cylinder{<>,<>,}
 }
*/

