// d'aprs Jeff Lee <shipbrk@gate.net>
 
#ifndef (BriqueLongueur)   #declare BriqueLongueur=8;   #end
#ifndef (BriqueHauteur)    #declare BriqueHauteur=3;    #end 
#ifndef (BriqueDef)        #declare BriqueDef=4.5;      #end  
#ifndef (BriqueMortar)     #declare BriqueMortar=0.5;   #end
#ifndef (BriqueNormal)     #declare BriqueNormal=normal { granite 0.1 }  #end
#ifndef (BriqueFinish)     #declare BriqueFinish=finish {}        #end

#ifndef (Bascouleur) #declare Bascouleur=color rgb <0.60,0.10,0.10>; #end
#ifndef (MilieuBasCouleur) #declare MilieuBasCouleur=color rgb <0.40,0.05,0.00>;#end
#ifndef (MilieuHautCouleur) #declare MilieuHautCouleur=color rgb <0.75,0.25,0.10>;#end
#ifndef (HautCouleur) #declare HautCouleur=color rgb <0.60,0.10,0.10>;#end
#ifndef (PositionBasCouleur)#declare PositionBasCouleur=0.6; #end  
#ifndef (PositionHautsCouleur)#declare PositionHautCouleur=0.6; #end 

#ifndef (BriqueBozoScale) #declare BriqueBozoScale=100;   #end 
#ifndef (BriqueTurbulence)#declare BriqueTurbulence=0.05; #end 
#ifndef (Octaves)         #declare Octaves=2;             #end 
#ifndef (Lambda)          #declare Lambda=5.0;            #end 
#ifndef (Omega)           #declare Omega=0.8;             #end 



#ifndef (MortarCouleur)#declare MortarCouleur=color rgb <0.90,0.89,0.85>; #end


//=================================

 #declare P_BriqueA = pigment { 
      bozo
      pigment_map {
        [0.00 Bascouleur]
        [PositionBasCouleur  MilieuBasCouleur]
        [PositionHautCouleur MilieuHautCouleur]
        [1.00 HautCouleur]
      }
      scale BriqueBozoScale
    }

    #declare P_BriqueB = pigment {
      P_BriqueA
      warp { repeat x*BriqueLongueur offset <0,BriqueHauteur*15,0> }
    }
    #declare P_BriqueC = pigment {
      P_BriqueB
      warp { repeat z*BriqueDef offset <BriqueLongueur*20,0,0> }
    }
    #declare P_BriqueD = pigment {
      P_BriqueC
       warp { repeat y*BriqueHauteur offset <BriqueLongueur*7.5,0,0> }
    translate z*(BriqueDef/2)
          }

    #declare P_Mortier = pigment {color rgb <0.90,0.89,0.85> }

    #declare P_Brique = 
      pigment { P_BriqueD turbulence 0.075 }
     
    #declare P_Mortier =
      pigment { MortarCouleur }
   
#declare P_Brique= 
pigment {
       brick pigment { P_Mortier } , pigment {P_Brique turbulence BriqueTurbulence octaves Octaves lambda Lambda omega Omega} 
       brick_size <BriqueLongueur,BriqueHauteur,BriqueDef>
       mortar BriqueMortar
        }
        
#declare T_Brique=texture { 
        pigment {P_Brique }
        normal {BriqueNormal scale 0.3 }
        finish {BriqueFinish}
}

/*
 box { -0.5, 0.5 scale <100,100,1> texture { T_Brique }}
 box { -0.5, 0.5 scale <100,100,0.85> texture { T_Mortier }
*/ 