// Persistence of Vision Ray Tracer Scene 			
// Pov-Ray for windows version 3.1g
// Fichier        : IRTC August 99   Martial Rameaux
// Date           : 07 and 08 1999
// Description    :
//                  window macro (v 1.1), by Fabien Mosen 1999, 
//                  Clouds d'apres Jaime Vives Piqueres   
//                  gforge v13, ColorPicker112                     
// mile ;) ->m.r@lemel.fr
//==========================================  
//2h48mn59s 

// ==== Standard POV-Ray Includes ====

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "consts.inc"
#declare Rad_Quality = 5;
#include "rad_def.inc"
global_settings 
{ 
  assumed_gamma 1.5      
  max_trace_level 64          
  radiosity { distance_maximum 10 } // dpend de la scene 1/3 de la distance
}


//camera { location <0,10,-20>look_at 0 }  
camera { location <0,5,-20>look_at 0 }   


//light_source { <0,20,0> color rgb 0.5   fade_distance 25 fade_power 2}  //area_light <15,0,0><0,0,15>,3,3
light_source {x*0 rgb <0.5,0.5,0> translate <-10,6000,100>} 
light_source {x*0 rgb <0.8,0.8,0.6>*2 translate <-10,20,50> shadowless} 
sky_sphere { pigment { color rgb <0.7,0.8,1>}}
//====================================

//fog{rgb<.4, .7, .6>distance 1000 fog_type 2 fog_alt 1 fog_offset   0}
//fog{rgb<.4, .5, .6>distance 1000 fog_type 2 fog_alt 1 fog_offset   0}

//================ Sol et Fond ==========================
 #declare BriqueLongueur=3;
 #declare BriqueHauteur=1.2;
 #declare BriqueDef=2.5; 
 #declare BriqueMortar=0.2;
 
 #declare BriqueBozoScale=20;
 #declare Bascouleur=color rgb <0.50,0.50,0.35>;
 #declare MilieuBasCouleur=color rgb <0.40,0.40,0.35>;
 #declare MilieuHautCouleur=color rgb <0.60,0.60,0.45>;
 #declare HautCouleur=color rgb <0.60,0.60,0.55>;
 #declare PositionBasCouleur=0.2;
 #declare PositionHautCouleur=0.8;
 #declare MortarCouleur=color rgb <0.50,0.55,0.50>;

 #declare BriqueTurbulence=0.75;
 #declare Octaves=2;
 #declare Lambda=5.0;
 #declare Omega=0.8;
 
 #declare BriqueNormal=normal {granite 0.05 scale 0.2}
 #declare BriqueFinish=finish {ambient 0.3 diffuse 0.5 reflection 0.2 metallic phong 1 phong_size 40}     
 #include "brique.inc"


//====================================
#declare T_Fenetre=
texture {  pigment {  wood   color_map {
                                [0.0 rgb <0.5,0.4,0>]
                                [0.5 rgb <0.5,0.3,0>]
                                [1.0 rgb <0.3,0.2,0>]
                                }
                                  turbulence 0.1
                                        }
finish {ambient 0.5 diffuse 0.5 phong 1}   
scale 1.5                                    
}
                                            

#declare Carreau=box { <-2,-5,0><17,10,.5> pigment {color rgbf 0.9 }
        finish { ambient 0.3  } 
        interior {ior 1.5 caustics 1 }
        }
#include "macrowindow.inc"

#declare Glass1=material {
texture {pigment {LightBlue filter .99} finish {reflection .101}}
interior {ior 1.5}
}

union {
difference {
box { <-25,-21,-21>,<25,21,21>}    // la piece
box { <-24.0,-20,-20><24,20,20>  }    
box { <-5,-10,18><25,13,25> translate <-10,-1,0> } // trou de la fenetre
texture {T_Brique } //pigment { rgb 0.5}}//
} 
 
//(Bay_W,Bay_H,A,B,C,D,E,F,G,NbGlassW,NbGlassH,FenTex,GlassTex,LeftAngle,RightAngle,Handle)
object {
Dbl_Open_Window_1_1 (150,119,  4,5,1,5,1.2,.8,.4,  3,5,T_Fenetre ,Glass1, 60,90,sphere {<2,0,0>,2}) 
scale 0.2
rotate y*90
translate <-15,-12,19>
}
} 
      
//=============Sol=======================
 #declare BriqueLongueur=5.0;
 #declare BriqueHauteur=5.0;
 #declare BriqueDef=5.0; 
 #declare BriqueMortar=0.5;
 
 #declare BriqueBozoScale=20;
 #declare Bascouleur=color rgb <0.50,0.40,0.0>;
 #declare MilieuBasCouleur=color rgb <0.40,0.50,0.35>;
 #declare MilieuHautCouleur=color rgb <0.60,0.50,0.45>;
 #declare HautCouleur=color rgb <0.50,0.60,0.55>;
 #declare PositionBasCouleur=0.2;
 #declare PositionHautCouleur=0.8;
 #declare MortarCouleur=color rgb <0.50,0.55,0.50>;

 #declare BriqueTurbulence=0.75;
 #declare Octaves=2;
 #declare Lambda=5.0;
 #declare Omega=0.8;
 
 #declare BriqueNormal=normal { granite 0.01 scale 0.2}
 #declare BriqueFinish=finish {ambient 0.3 diffuse 0.5 }     
 #include "brique.inc"
box{ <-25,-20,-20>,<25,-19.5,20>
        texture { T_Brique  rotate y*45 }
}

//------------------------------------
         
 
//------------TABLE------------------------

#declare T_Table=texture {
                        pigment { wood 
                                color_map  { 
                                [0.0  rgb <0.5,0.4,0.1>]
                                [0.35 rgb <0.5,0.3,0.2>]
                                [0.65 rgb <0.4,0.2,0.2>]
                                [1.0  rgb <0.4,0.2,0.1>]
                                }
                                turbulence 0.5
                               octaves 2
                               lambda 1
                                omega 1
                               
                               ramp_wave
                                scale 0.8
                                rotate y*90
                                 }
                            finish {ambient 0.3 diffuse 0.5 phong 1 phong_size 40}     
                                }
                                
        
union { 
cylinder { <0,0,0><0,0.2,0>,6   }
cylinder { <0,-4,0><0,0,0>0.3 translate <-2,0,-2>} 
cylinder { <0,-4,0><0,0,0>0.3 translate < 2,0,-2>} 
cylinder { <0,-4,0><0,0,0>0.3 translate <-2,0, 2>} 
cylinder { <0,-4,0><0,0,0>0.3 translate < 2,0, 2>} 
              texture { T_Table}
        translate <2,-8,2>
        }                
                                         
                                               
//====================================
#declare P1=pigment {marble   color_map {
                                        [0.9 rgb 0.99] 
                                        [1.0 color rgb <0.263,0.478,0.208>]
                                        }
                                     }
#declare P2=pigment {marble color_map {
                                        [0.9 rgb 0.99] 
                                        [1.0 color rgb <0.263,0.478,0.208>]
                                        }
  rotate y*90
}

#declare T_Cartes=material { 
                        texture { 
                                pigment { marble
                                         pigment_map {
                                                        [0.0 P2] 
                                                        [1.0 P1]
                                         }
                                           
                                                   }       
                              finish {phong 0.1 phong_size 40 ambient 0.2}  
                              scale 0.5  
                             translate x*2  } 
                        

} 
union {
     light_source {<0,3,0> 
                        color rgb 2
                        spotlight 
                        radius 5
                        falloff 50
                        tightness 10
                        point_at <0, 0, 0>
        }
      object{
         height_field {png "mstmch.png" }
         scale < 1.2, .30, 1.2 >*8      // reduce height
         translate <-.5, 0, -.5>
         material { T_Cartes  }
        rotate y*120
         }
translate <0,-7.7,8>
}
//====================================
                
object{
 height_field {png "mstmch.png" }
 scale < 1.2, .22, 1.2 >*200      // reduce height
 translate <-.5, -0, -.5>*200
 texture { 
   pigment {
         gradient y
          color_map { 
                [0.0 rgb <0.0,0.1,0.01>]
                [0.1 rgb <0.0,0.2,0.1>]
                [0.3 rgb <0.1,0.2,0.2>] 
                [1.0 rgb <0.1,0.1,0.1>]
                }
   octaves .1
   lambda 0.1
   turbulence 0.01
   } 
   normal { gradient y 
        normal_map {  
                [ 0.0 ripples 1.2 scale 0.2]                                          
                [1.0  dents ]
        }
   }
   
   finish {phong 0.1 ambient 0.2} 
 scale 50}
rotate y*120 
translate <0,-22,180> }
//====================================

//fog {distance 1000 rgb <.2,.3,.4>}
//====================================
// NUAGES *******
//  D'apres Jaime Vives Piqueres
//====================================
/*
#declare P_ciel=color <0.8,0.9,1>;
#declare H_Nuages=2000;
#declare Plane_Distance=40;
#declare Texture_Distance=40;
#declare Nbr_Plan=40;
#declare Cpt=1;


#declare Pigment_Nuages=P_ciel*.5+White*.5;

#while (Cpt<=Nbr_Plan)
#declare P01=Pigment_Nuages*(1-(Cpt/Nbr_Plan))+ White*(Cpt/Nbr_Plan);
#declare P02=Pigment_Nuages*.9*(1-(Cpt/Nbr_Plan))+ White*.9*(Cpt/Nbr_Plan);

plane{
        y,0
        texture {
                   pigment{
                    granite           
                    octaves 9
                    lambda 3
                    turbulence 4
      color_map{        // notice that each plane has more transparency
     [0.0 Clear]
     [0.5 Clear]      // play with the "cloud zone" entries
     [0.6 P01 filter 0.7+0.1*(Cpt/Nbr_Plan)]
     [1.0 P02 filter 0.7+0.1*(Cpt/Nbr_Plan)]
                        }
     scale 1000000     // depends on the patern
                   }
                   
                   finish { Luminous }
                   translate (H_Nuages+Texture_Distance*Cpt)*y
  }
  translate (H_Nuages+Plane_Distance*Cpt)*y
  hollow
}
 #declare Cpt=Cpt+1;
#end
*/
//====================================
//============= FIN ===================
