
#include "colors.inc"

#include "CHARS.INC"    // A complete library of character objects, by Ken Maeno
//#include "CONSTS.INC"   // Various constants and alias definitions
#include "GLASS.INC"    // Glass textures
#include "GOLDS.INC"    // Gold textures
#include "METALS.INC"   // Metallic pigments, finishes, and textures
#include "SKIES.INC"    // Ready defined sky spheres
#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
//#include "STONES1.INC"  // Great stone-textures created by Mike Miller
//#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "WOODMAPS.INC" // Basic wooden colormaps
#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak

#declare marker = 1;
 
 
camera
{      


  location  <12, 7+clock*20, -50>
  direction 1.5*z
  right     4/3*x
  look_at   <-10,7,  0>
focal_point <0,3,0>

}


sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.184, 0.184, 0.309> ]
            [0.15 P_Cloud3 scale <0.05, 0.40, 0.05> rotate z*45 ]
            [0.45 P_Cloud3 scale <0.25, 0.15, 0.50> ]
        }
    }
}
      
      

      
      
light_source
{
  0*x   
  color rgb <1,1,1>
  translate <5000, 3000, -2005>
  media_interaction off 
}  

light_source
{
  0*x 
  color rgb <1,1,1>
  translate <5000, 2000, -2010>
  media_interaction off 
}

light_source
{
  0*x   
  color rgb <0.5,0.5,0.2>*1.7
  translate <-5,2.8,-15>
  media_interaction off 
}

 
            
            
 
light_source
{
  0*x                           // light's position (translated below)
  color rgb <1.5,1.3,0.5>*0.75  // light's color
  spotlight                     // this kind of light source
  translate <0, 18.05, 0>       // <x y z> position of light
  point_at <0, 18.05, -1>       // direction of spotlight
  radius 3                      // hotspot (inner, in degrees)
  tightness 80                  // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 5                     // intensity falloff radius (outer, in degrees)
  rotate <0,20,0>
  

  media_interaction on

}
           
            
            
            

plane {y,0  translate <0,0.2,0>
        pigment {color rgb <0,0.3,0.5>}
        normal {bumps 0.05 scale 0.3}
        finish {reflection 0.3
                phong 0.3
                }
        }

    
    
    
          

height_field
{
  gif "map.gif" 
 
 #if (marker = 1) 
  smooth
 #end
  
  texture
  {
    pigment
    {
      image_map { tga "map2.tga" map_type 0 interpolate 2 once }
      rotate x*90 
    }
  }
 

translate <-0.5,0,-0.5>
scale <100,3,300>

}

 
    

 

fog{
    color rgbt <0.5,0.8,0.8,0.8 >
    fog_type 2
    fog_alt 0.4
    fog_offset 0.4
    distance 30
    turbulence <.5, .6, .5>
          
     }
     
fog{
    color rgbt <0.5,0.5,0.5,0.75 >
    fog_type 1
    distance 2
    turbulence <.25, .7, .25>
}
 

#if (marker = 1) 
media { scattering { 3, color rgb 0.7                         
                        extinction 0 } }

#end

  
              
   

          
      
union { //gebude   
    
#if (marker = 1) 
    
union { //Turm

difference {
 union {
  intersection { 
   cylinder {<0,0,0>,<0,1.5,0>,2.045}
   box {<-2,0,-2><2,1.5,2>}
   box {<-2,0,-2><2,1.5,2> rotate <0,45,0>}
   } 
  cylinder {<0,1.5,0>,<0,1.6,0>,2}
  torus {2,0.05 translate <0,1.55,0>}
  
  texture {
   pigment {color rgb 0.99}
   normal {crackle 0.5 
           turbulence 0.1
           scale <0.3,0.1,0.3>
           }
 
   finish {phong 0.05  }
    
   }
  }
  box {<-0.25,0,-2.1> <0.25,1,-1.95> texture {T_Wood14 scale 0.2}}
  box {<-0.25,0,-2.1> <0.25,1,-1.95> texture {T_Wood14 scale 0.2} rotate <0,180,0>}
  box {<-0.25,0,-2.1> <0.25,1,-1.95> texture {T_Wood14 scale 0.2} rotate <0,90,0>}
  box {<-0.25,0,-2.1> <0.25,1,-1.95> texture {T_Wood14 scale 0.2} rotate <0,-90,0>}
}

#declare Loch = union {  
cylinder {<0,3,-5>,<0,3,5>,0.08 pigment {color rgb 0}}    
cylinder {<0,4.5,-5>,<0,4.5,5>,0.08 pigment {color rgb 0}}    
cylinder {<0,6,-5>,<0,6,5>,0.08 pigment {color rgb 0}}    
cylinder {<0,7.5,-5>,<0,7.5,5>,0.08 pigment {color rgb 0}}    
cylinder {<0,9,-5>,<0,9,5>,0.08 pigment {color rgb 0}}    
cylinder {<0,10.5,-5>,<0,10.5,5>,0.08 pigment {color rgb 0}}    
cylinder {<0,12,-5>,<0,12,5>,0.08 pigment {color rgb 0}}    
}

difference {                  
 cone {<0,1.6,0>,1.9,<0,13,0>,1 
  pigment {
    gradient y
    color_map {
                   [0.00 rgb <1,0.2,0.2> ]
                   [0.4 rgb <1,0.2,0.2>]
                   [0.41 rgb 0.955 ]
                   [0.6 rgb 0.955 ]
                   [0.61 rgb <1,0.2,0.2> ] 
                   [1 rgb <1,0.2,0.2> ]
    } 
   scale 14
   }
          normal {crackle 0.1 
           turbulence 0.1
           scale <0.1,0.05,0.1>
           }
 
   finish {phong 0.05
           }
  }               
 object {Loch}
 object {Loch rotate <0,90,0>}
 object {Loch rotate <0,-45,0>}
 object {Loch rotate <0,45,0>}
} 

cone {<0,1.6,0>,1.8,<0,13,0>,0.9 pigment {color rgb <0.3,0.3,0.8>}} 
    
union {
 cylinder {<0,13,0><0,15,0>1}
 
 torus {1.45,0.01 translate <0,13.5,0>}
 cylinder {<0,13,0><0,13.1,0>1.5}   
 
 torus {1.25,0.01 translate <0,15,0>} 
 cylinder {<0,14.4,0><0,14.5,0>1.3}
 cylinder {<0,15.5,0><0,15.6,0>1}
 cylinder {<0,15.5,0><0,15.85,0>1}
 cone {<0,15.6,0>,1.2,<0,16.5,0>0.07} 
 cone {<0,16.5,0>,0.07,<0,16.9,0>0.005} 
 cone {<0,16.9,0>0.005,<0,19.5,0>,0.0015}
 sphere {<0,19.5,0>,0.0015}
 
 cylinder {<0,15,0.9><0,15.5,0.9>0.02}
 cylinder {<0,15,0.9><0,15.5,0.9>0.02 rotate <0,180,0>}
 cylinder {<0,15,0.9><0,15.5,0.9>0.02 rotate <0,-120,0>}
 cylinder {<0,15,0.9><0,15.5,0.9>0.02 rotate <0,-60,0>}
 cylinder {<0,15,0.9><0,15.5,0.9>0.02 rotate <0,120,0>}
 cylinder {<0,15,0.9><0,15.5,0.9>0.02 rotate <0,60,0>} 
  
#declare Count = 0;
#while (Count < 16)
#declare Count = Count+1; 

union {
 cylinder {<0,12.8,1><0,13,1.4>,0.01}
 cylinder {<0,13,1.45><0,13.5,1.45>0.005}
 cylinder {<0,13,1.45><0,13.5,1.45>0.005 rotate <0,11.25,0>}
 cylinder {<0,14.5,1.25><0,15,1.25>0.005}
 cylinder {<0,14.5,1.25><0,15,1.25>0.005 rotate <0,11.25,0>}
 
 rotate <0,360*Count/16,0>
 }
 
#end
 texture {
  pigment {color rgb 0.01}
  finish { 
   phong 0.3
   }
   normal {bumps 0.1 scale 0.05}
  }    
 }


difference { 
 cylinder {<0,15,0><0,15.5,0>0.8} 
 cylinder {<0,15,0><0,15.5,0>0.75}
 texture { T_Glass1 }
}
 
  

} 
#else
cone {<0,0,0>,2.3,<0,16.5,0>,0.8 pigment {color rgb 1}} 
#end  
                                                                      
// ------------------------------------------------------------------- 
//"---------------------------------------------------------------------"

// ------------------------------------------------------------------- 
//"---------------------------------------------------------------------"

// ------------------------------------------------------------------- 
//"---------------------------------------------------------------------"
  
union {  //Haus



union { 
 difference {
  intersection {
   box {<-1,-1,-1><1,2,1>}
   box {<-1,-1,-1><1,1,1> rotate <45,0,0> translate <0,-0.5,0>}
   box {<-1,-1,-1><1,1,1> rotate <0,0,45>}
   }
   intersection {
   box {<-1,-1,-1><1,2,1>}
   box {<-1,-1,-1><1,1,1> rotate <45,0,0> translate <0,-0.5,0>}
   box {<-1,-1,-1><1,1,1> rotate <0,0,45>}
   scale 1.00001
   translate <0,-0.03,0>
   }
  } 
  box {<-0.1,0.5,0><0.1,0.51,-0.6>}  
 
 texture {
  pigment {
   bozo 
   color_map {[0,0.2 color rgb <0.8,0.2,0>  color rgb <0.9,0.2,0.1>]
              [0.2,0.5 color rgb <0.5,0.2,0.1>  color rgb <0.6,0.3,0.2>]
              [0.5,1  color rgb <0.9,0.3,0.1>  color rgb <0.7,0.3,0.1> ] } 
   scale <0.02,0.3,0.04>
   }
  normal {bozo 0.2 scale <0.02,0.3,0.04>}
  }
 translate <0,0.75,0>
}



difference {

union {   
  intersection {
   box {<-1,-1,-1><1,2,1>}
   box {<-1,-1,-1><1,1,1> rotate <45,0,0> translate <0,-0.5,0>}
   box {<-1,-1,-1><1,1,1> rotate <0,0,45>}
   box {<-1,2,-0.9><1,0,0.9>}
   translate <0,-0.03,0> 
   translate <0,0.75,0>
   }
   
  box {<-1.01,0,-0.9><1.01,0.7,0.9>}
  difference { 
   box {<-0.1,0.5,0><0.1,0.3,-0.6> translate <0,0.75,0>}
   box {<-0.08,0.48,-0.65><0.08,0.3,-0.7> translate <0,0.75,0>}
   }
  texture {
   normal { brick 0.05 scale 0.02  }
   pigment{  color rgb <0.4,0.3,0.1>}
   }
  }
 union {
  union {
   box {<0.8,0.2,-1>,<0.4,0.5,-0.87>  } 
   box {<-0.8,0.2,-1>,<-0.4,0.5,-0.87>  } 
   box {<0.2,0,-1>,<-0.2,0.5,-0.87> pigment {color rgb <0.7,0.3,0.1> }}
  }
  union {
   box {<0.8,0.2,-1>,<0.4,0.5,-0.87>  } 
   box {<-0.8,0.2,-1>,<-0.4,0.5,-0.87>  } 
   box {<0.2,0,-1>,<-0.2,0.5,-0.87>  }
   rotate <0,180,0>}
   pigment {color rgb <0.025,0.02,0.002>}
  }
} 
//box {<-0.08,0.48,-0.66><0.08,0.3,-0.7> translate <0,0.75,0> texture {T_Glass1}}
box {<-0.991,0,-0.891><0.991,0.7,0.891> pigment {color rgbf <0.6,0.6,0.7,0.35>} finish {reflection 0.5 phong 0.4} normal {bumps 0.4 scale 0.3}} 
//box {<-0.99,0,-0.89><0.99,0.7,0.89> texture {T_Glass1}}  
 box {<0.2,0,-0.9>,<-0.2,0.5,-0.87> texture {T_Wood2} }

difference { 
 box {<-1,0,0.3><-1.4,0.6,-0.3> texture {T_Wood2 scale 0.2}}
 plane {-y, 0 
        pigment {color rgb <0.8,0.2,0>}
        normal {bumps 0.4 scale <0.1,0.05,0.005> }
        rotate <0,0,45> translate <-1,0.6,0>}
        }
       
       
scale <2,2,2>
rotate <0,-80,0>
 
translate <-5,0,-15>
}

 translate <0,2.8,0>
}      


 

//        BOOT ********************************** BOOT -------------------------BOOT


union {
 union {
  cone {<0,2.5,0>,0.1,<2,1,0>,0.2}
  difference {
   sphere {<3,1,0>1.5}
   plane {<-1,-2,0>,0 translate <3,1,0>}
   }
  difference {
   cylinder {<3,1,0><9,1,0>1.5}
   plane {-y,0 translate <0,1.2,0>}
   } 
   box {<7,0.8,1.5><9,1.5,-1.5>} 
   box {<8,1.5,1.55><9.1,1.7,-1.55>}
   cone {<2.5,1,0>,0.1<2.5,6,0>,0.05}   
   cone {<5.5,1,0>,0.1<5.5,6.3,0>,0.05}
   cone {<7.5,1,0>,0.08<7.5,5,0>,0.05}
   box {<9.2,-0.5,0.01> <9.5,0.75,-0.01>}
 pigment {color rgb <0.2,0.2,0>}
 } 

 union {
 box{ <3,1.1,-1.5> <8,1,1.5>}
 box{ <3,0.9,-1.5> <8,0.8,1.5>}
 box{ <3,0.7,-1.5> <8,0.6,1.5>}
 pigment {color rgb 0.05}
 }

 union {
  cylinder {<0,2.5,0><2.5,6,0>0.01}
  cylinder {<2.5,5,0><5.5,6,0>0.01}
  cylinder {<5.5,6,0><7.5,4.5,0>0.01}
  
  cylinder {<2.5,1,-1><2.5,3,0>0.01}
  cylinder {<2.5,1,1><2.5,3,0>0.01}
  cylinder {<2.2,1,-1><2.5,3,0>0.01}
  cylinder {<2.2,1,1><2.5,3,0>0.01}
  cylinder {<2.8,1,-1><2.5,3,0>0.01}
  cylinder {<2.8,1,1><2.5,3,0>0.01}
  
  cylinder {<2.5,1,-1><2.5,5,0>0.01}
  cylinder {<2.5,1,1><2.5,5,0>0.01}
  cylinder {<2.2,1,-1><2.5,5,0>0.01}
  cylinder {<2.2,1,1><2.5,5,0>0.01}
  cylinder {<2.8,1,-1><2.5,5,0>0.01}
  cylinder {<2.8,1,1><2.5,5,0>0.01}
                                   
                                   
  cylinder {<5.5,1,-1><5.5,3,0>0.01}
  cylinder {<5.5,1,1><5.5,3,0>0.01}
  cylinder {<5.2,1,-1><5.5,3,0>0.01}
  cylinder {<5.2,1,1><5.5,3,0>0.01}
  cylinder {<5.8,1,-1><5.5,3,0>0.01}
  cylinder {<5.8,1,1><5.5,3,0>0.01}
  
  cylinder {<5.5,1,-1><5.5,5,0>0.01}
  cylinder {<5.5,1,1><5.5,5,0>0.01}
  cylinder {<5.2,1,-1><5.5,5,0>0.01}
  cylinder {<5.2,1,1><5.5,5,0>0.01}
  cylinder {<5.8,1,-1><5.5,5,0>0.01}
  cylinder {<5.8,1,1><5.5,5,0>0.01}
    
  //cylinder {<0, ,0><0,  ,0>0.01}
  pigment {color rgb <0.2,0.2,0.2>}
 }
 union {
 
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.6>,<-0.3,-1.3,1.3>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1.2,0.5>
   rotate <0,-48,0>
   translate <2.3,5.8,0>
  }
  
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1,0.8>
   rotate <0,-48,0>
   translate <0.5,2,0>
  }
   
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1.5,1.2>
   rotate <0,-48,0>
   translate <2.3,4.5,0>
  }
  
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1.5,1.2>
   rotate <0,-48,0>
   translate <2.3,3,0>
  }
  
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1,0.8>
   rotate <0,-48,0>
   translate <5.3,6,0>
  } 
  
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,2,1.5>
   rotate <0,-48,0>
   translate <5.3,5.4,0>
  }
   
  union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1.9,1.5>
   rotate <0,-48,0>
   translate <5.25,3.3,0>
  }  
  
      union {
   smooth_triangle{ <0,0,1>,<-0.3,0.3,1.3>,<0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,1.3>,<-0.3,-1.3,1.6>}                
   smooth_triangle{ <0,0,-1>,<-0.3,0.3,-1.3>,<0,-1,-1.3>,<-0.3,-1.3,-1.6>,<0,-1,1.3>,<-0.3,-1.3,1.6>} 
   scale <1,1.2,1>
   rotate <0,-48,0>
   translate <7.4,4.6,0>
  }
  
  smooth_triangle{ <6,1.5,0.2>,<5.5,1.2,0.4>,<9,1.5,0.5>,<10,1.2,0.5>,<9.2,4,0.4>,<10,5,0.6>}
  
  pigment {color rgb 0.3}
 }

scale 2.25
rotate <0,-20,0>
translate <-11.5,0.6,190>

}

    
 
 // Ruderboot      
 
 
union {     

 difference {
  sphere {<0,0,0>1 scale <1.5,0.8,4>}
  sphere {<0,0,0>1 scale <1.4,0.7,3.9>}
  plane {-y,0.1}
  pigment {
    gradient y
    color_map {
                   [0.1 rgb 0.7 ]
                   [0.8 rgb 0.7]
                   [0.85 rgb 0.2]
                   [0.9 rgb 0.2 ]                   
    }                        
    scale <1,0.07,1>
   } 
  }
  torus {1,0.05 scale <1.5,1,4> translate <0,-0.1,0> pigment {color Blue}}
  union {
   cylinder {<1.5,0.1,0><1,0.1,0> 0.01 }
   cylinder {<1.5,0.1,0><1.5,-0.3,0> 0.01 }
  pigment {color rgb 0.5}
  }
  intersection { 
  difference {
   sphere {<0,0,0>1 scale <1.5,0.9,4>}
   sphere {<0,0,0>1 scale <1.3,0.7,3.8>}
   }
  box {<0.1,-0.8,4.5>,<-0.1,0.3,-5>}
  pigment {color rgb 0.5}
  }
 intersection {                         
  box {<1.5,-0.2,0.3><-1.5,-0.3,-0.4>}
  sphere {<0,0,0>1 scale <1.4,0.7,3.9>}
  pigment {color rgb <0.5,0.5,0.2>}
  }
  
  union {
   difference { 
    box {<1.3,-1,-1.3><-1.3,-0.1,-1.4>}
    sphere {<0,0,0>1 scale <1.5,0.8,4>}
    }
    difference { 
    box {<1.3,-1,1.3><-1.3,-0.1,1.4>}
    sphere {<0,0,0>1 scale <1.5,0.8,4>}
    } 
     pigment {color rgb <0.5,0.5,0.2>}
   }
   union {
    cone {<0,-0.5,0>,0.08,<0,2,0>,0.04}
    cylinder {<0.1,0.3,-3><0.2,3,4>0.06 rotate <0,10,0>}
    cylinder {<0.8,0.6,-2><2,-1,-2.5>0.02}
    cylinder {<1,0.4,-2.3><2.3,-1,-2.1>0.02} 
    pigment {color rgb 0.75}
    normal {bumps 0.2 scale 0.1}
    }
    
  scale 0.7  
  translate <0,3.6,0>
  rotate <0,-55,0>
  translate <-5,0,-27>
 }   
 
 
 
           

     //Rad 
     
union {
union { 
 intersection { 
  difference {
   cylinder {<0,0.2,0><0,-0.2,0>1} 
   cylinder {<0,0.3,0><0,-0.3,0>0.8}
   }
  torus {0.9,0.3}
  }
  difference {
  
   intersection {
   cylinder {<0,0.2,0><0,-0.2,0>0.3}
   sphere {<0,0,0>0.43}
   }
   cylinder {<0,0.3,0><0,-0.3,0>0.1}
  }
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}} 
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>}
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>*2}
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>*4}
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>*5}
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>*6}
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>*7}
  union { cone {<0.1,0,0>0.1,<0.4,0,0>0.15} cone {<0.4,0,0>0.15,<0.8,0,0>0.1}rotate <0,36,0>*8}
  
  texture {T_Wood2 rotate <20,15,21> scale 0.3}
  }
  
 union {
 difference {
   cylinder {<0,0.18,0><0,-0.18,0>1.05} 
   cylinder {<0,0.3,0><0,-0.3,0>1}} 
 difference {
   cylinder {<0,0.23,0><0,-0.23,0>0.1} 
   cylinder {<0,0.3,0><0,-0.3,0>0.05}} 
 texture {pigment {color rgb 0.2}
          finish {phong 0.3
                  reflection 0.3}
          normal {bumps 0.2 scale 0.01}
          }    
         }
sphere {<-0.6,-0.3,0.1>0.33 texture {T_Stone9}}
scale <1,0.4,1>         
rotate <-18,0,-23>
translate <10,3.3,-30>
}               


//baum  
#declare Baum =
union {
sphere { <0,1,0>0.75 
        texture {  
         pigment { 
          bozo color_map {
                                             [0,0.2 color rgbf <0.3,0.8,0,0> color rgbf <0.2,0.9,0,1>]
                                             [0.2,0.5 color rgbf <0.3,1,0,1> color rgbf <0,0.5,0,1>]
                                             [0.5,0.6 color rgbf <0.8,0.8,0,1> color rgbf <0.8,0.9,0,1>]
                                             [0.6,1 color rgb <0.1,0.4,0.1> color rgbf <0,0.4,0.1,1>]
           }
           scale 0.05
          }
          normal {bumps 0.1 scale 0.1}
         }           
       }
 sphere { <0,1,0>0.65 
        texture {  
         pigment { 
          bozo color_map {
                                             [0,0.2 color rgbf <0.3,0.8,0,0> color rgbf <0.2,0.9,0,1>]
                                             [0.2,0.5 color rgbf <0.3,1,0,1> color rgbf <0,0.5,0,1>]
                                             [0.5,0.6 color rgbf <0.8,0.8,0,1> color rgbf <0.8,0.9,0,1>]
                                             [0.6,1 color rgb <0.1,0.4,0.1> color rgbf <0,0.4,0.1,1>]
           }
           scale 0.05
          }
          normal {bumps 0.1 scale 0.1}          
        }
       rotate <0,10,0>
       }
    scale 0.8 
   translate <0,2.8-0.4,0>
}


object {Baum translate <10,0,-20>}
object {Baum translate <8,0,-18>}
object {Baum translate <11,0,-15>}  
object {Baum translate <10,0,-20>}     
object {Baum translate <-4,0-0.15,-25>}
object {Baum translate <-5.5,0-0.15,-30>}    

#declare Blume2 =
union {
 union {
  cone {<0,0,0>,0,<0,0.2,0>0.1 open}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <20,0,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <30,0,0>} 
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <20,50,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <40,145,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <20,80,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <30,95,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <20,120,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <40,235,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <20,160,0>}
  cone {<0,0,0>,0,<0,0.2,0>0.1 open rotate <30,275,0>}
  pigment {color rgb <1,0.2,0>}
  translate <0,0.2,0>
  }  
 union {
  cone {<0,0,0>,0,<0,0.1,0>0.3 open}
  sphere {<0.2,0,0>0.2 scale <0.3,1,0.01> rotate <0,0,40>}

  cylinder {<0,0,0><0,0.2,0>0.01}
  normal {bumps 0.2 scale 0.2}
  pigment {color rgb <0.1,0.3,0>} 
  }
 scale <1,1.5,1>
 translate <0,0.3,0>
 }
  
object {Blume2  rotate <0,-30,-2> translate <8,2.6,-28>}
object {Blume2  rotate <0,-30,-2> translate <8.5,2.6,-30>}
object {Blume2  rotate <0,-30,-2> translate <6.5,2.6,-31>}
object {Blume2  rotate <0,-30,-2> translate <7.75,2.7,-29>}  
object {Blume2  rotate <0,-30,-2> translate <7.5,2.5,-32>}
object {Blume2  rotate <0,-30,-2> translate <7,2.5,-31>} 
 






 
#declare Blume = 
union {                       
 union {
  cone {<0,0,0>,0.02,<0,1,0>,0.01}  
  
   sor { 5, 
    <0, 0> 
    <0.001, 0.001>
    <0.2, 0.2>
    <0.5, 1>
    <1,1.01>  
    open
   clipped_by { box {<0,0,0><0.3,3,0.3>  }}
   scale <1,0.8,1>
   }
  cone {<0,1,0>,0,<0,1.1,0>,0.2}  
  pigment {color rgb <0.2,0.8,0.1> }           
   }
  union {
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1> rotate <0,60,0>}
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1> rotate <0,-60,0>}  
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1>} 
  pigment {color rgb <0.5,0,1>}
  }                   
  cylinder {<0,1.2,0><0,1.35,0>0.007 pigment {color rgb <1,0.7,0>}}         
  
  union { 
   union {
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1> rotate <0,60,0>}
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1> rotate <0,-60,0>}  
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1>} 
  pigment {color rgb <0.5,0,1>}
  }                   
  cylinder {<0,1.2,0><0,1.35,0>0.007 pigment {color rgb <1,0.7,0>}}
  cone {<0,0,0>0.02,<0,1,0>0  pigment {color rgb <0.2,0.8,0.1> } }
  scale <1,0.5,1>
  rotate <15,45,0>
  }  
    union {
     union {
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1> rotate <0,60,0>}
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1> rotate <0,-60,0>}  
  cone {<0,1,0>,0,<0,1.3,0>,0.4 open scale <0.5,1,1>} 
  pigment {color rgb <0.5,0,1>}
  }                   
  cylinder {<0,1.2,0><0,1.35,0>0.007 pigment {color rgb <1,0.7,0>}}
  cone {<0,0,0>0.02,<0,1,0>0  pigment {color rgb <0.2,0.8,0.1> } }
  scale <1,0.5,1>
  rotate <-15,65,0>
  }
 }
 
 
union { 
object { Blume scale <0.5,0.3,0.5> translate <8,2.55,-32> }   
object { Blume scale <0.5,0.2,0.5> rotate <2,-20,2> translate <9.5,2.45,-33> }
object { Blume scale <0.5,0.3,0.5> translate <8,2.55,-34> }   
object { Blume scale <0.5,0.4,0.5> rotate <2,120,2> translate <9,2.55,-32> }
object { Blume scale <0.5,0.3,0.5> translate <10,2.4,-35> }   
object { Blume scale <0.5,0.4,0.5> rotate <10.5,120,2> translate <9,2.45,-32> }
translate <0,0.3,0>
} 
 
 #declare Grass = 
 union {
  cone {<0,0,0>,0.01,<0,1,0>,0}   
   sor { 5, 
    <0, 0> 
    <0.001, 0.001>
    <0.2, 0.2>
    <0.5, 1>
    <1,1.01>  
    open
   clipped_by { box {<0,0,0><0.3,3,0.3>  }}
   scale <0.25,1,0.25>
   }  
  cone {<0,0,0>,0.01,<0,0.7,0>,0 rotate <15,0,0>}
  cone {<0,0,0>,0.01,<0,0.3,0>,0 rotate <0,10,20>}
  cone {<0,0,0>,0.01,<0,0.7,0>,0 rotate <18,45,0>}
   pigment {color rgb <0.2,0.7,0.1>}
 translate <0,0.25,0>
  }
 
 object { Grass rotate <2,20,2> translate <9,2.45,-31> }
 object { Grass rotate <0,30,-2> translate <7,2.55,-31> }
 object { Grass rotate <-2,30,0> translate <8,2.55,-28> }
 object { Grass rotate <-2,-20,2> translate <9.5,2.45,-35> }
 object { Grass rotate <0,-30,-2> translate <8.5,2.55,-32> }
 object { Grass rotate <-2,30,0> translate <7,2.55,-28> }
 object { Grass rotate <-2,-20,2> translate <10,2.4,-35> }
 object { Grass rotate <0,-30,-2> translate <10.5,2.4,-32> }
 object { Grass rotate <-2,30,0> translate <11,2.4,-28> } 
 
 #declare Grass2 = union {
 triangle {<0,0,0>,<0.1,0.4,0>,<0,1,0> rotate <8,0,0>}
 triangle {<0,0,0>,<0.1,0.4,0>,<0,1,0>rotate <8,240,0>}
 triangle {<0,0,0>,<0.1,0.4,0>,<0,1,0>rotate <8,120,0>}
  scale 0.8 
  translate <-0.5,0,0.3>
  pigment {color rgb <0.2,0.7,0.1>}
   }
 object { Grass2 rotate <2,20,2> translate <9,2.45,-31> }
 object { Grass2 rotate <0,30,-2> translate <7,2.55,-31> }
 object { Grass2 rotate <-2,30,0> translate <8,2.55,-28> }
 object { Grass2 rotate <-2,-20,2> translate <9.5,2.45,-35> }
 object { Grass2 rotate <0,-30,-2> translate <8.5,2.55,-32> }
 object { Grass2 rotate <-2,30,0> translate <7,2.55,-28> }
 object { Grass2 rotate <-2,-20,2> translate <10,2.4,-35> }
 object { Grass2 rotate <0,-30,-2> translate <10.5,2.4,-32> }
 object { Grass2 rotate <-2,30,0> translate <11,2.4,-28> } 
  
 
//anker 
#declare anker =
union {
 difference {
 torus {1,0.15 scale <1,0.5,1> rotate <90,0,0> }
 plane {-y,0}
 }
 cone {<0,-1,0>0.1,<0,-1.2,0>0.03}
 cylinder {<0,-1,0><0,1,0>0.1}
 torus {0.1,0.05 rotate <90,0,0> translate <0,1,0>}
 torus {0.15,0.1 rotate <0,0,90> translate <0,1.2,0>}
 cylinder {<0,1,1><0,1,-1>0.1}
 sphere {<0,1,1>0.12}
 sphere {<0,1,-1>0.12}
 cone {<1,0,0>0.2,<1.3,0,0>0 scale <1,1.5,1>}
 cone {<-1,0,0>0.2,<-1.3,0,0>0 scale <1,1.5,1>}
 texture { pigment {color rgb <0.4,0.3,0.2>}
           normal {bumps 0.2 scale 0.1}
           finish { reflection 0.1}
          }
  
 rotate <63,0,0>
 translate <0,0.5,0>
 }            
 
 object {anker
 scale 0.75 
 rotate <0,30,0>
 translate <6.5,2.8,-34>
 } 
 
#declare zaun =
union { 
 cylinder {<0,0,0><0,0.5,0>0.075}
  cylinder {<0,0,-2.05><0,0.5,-2.05>0.075}
 box {<0.07,0.45,-0.05><0.08,0.4,-2>}
 box {<0.07,0.35,-0.05><0.08,0.3,-2>}
 box {<0.07,0.25,-0.05><0.08,0.2,-2>}
 texture {T_Wood2 translate <1,0.25,-0.5>} 
 scale <1,2,1>
 }


object { zaun translate <-2,2.6,-20> translate <0,0,-2>}
object { zaun translate <-2,2.6,-20> translate <0,0,-4>}
object { zaun translate <-2,2.6,-20> translate <0,0,-6>}
object { zaun translate <-2,2.6,-20> translate <0,0,-8>}
object { zaun translate <-2,2.6,-20> translate <0,0,-10>} 
object { zaun translate <-2,2.6,-20> translate <0,0,-12>} 
 
 
 
//storch

union {
 union {
  intersection {
   box {<0,0,-1><1,1,1>}
   torus {0.9,0.1 rotate <90,0,0> translate <0,1,0>}
   scale <1,1.5,1>  
   translate <-0.2,-0.2,0>
   }
  sphere {<1,1.5,0>,0.2 translate <-0.2,-0.2,0>}

  sphere {<0,0,0>1 scale <0.5,1,0.5> rotate <0,0,-45> translate <-0.6,-0.6,0>}
  triangle {<-1,-0.5,0>,<-2,-1.5,-0.5>,<-2.5,-1.2,0>}
  triangle {<-1,-0.5,0>,<-2,-1.5,0.5>,<-2.5,-1.2,0>}
  cone {<-0.5,-0.75,-0.1>,0.15,<-0.3,-1.1,-0.1>,0.05}
  cone {<-0.5,-0.75,0.1>,0.15,<-0.3,-1.1,0.1>,0.05}
  pigment {
    bozo 
   color_map {[0,0.2 color rgb 0.7  color rgb 1]
              [0.2,0.5 color rgb 0.6  color rgb 0.9]
              [0.5,1  color rgb 0.5  color rgb 0.8 ] } 
   scale <0.2,0.05,0.2>
   rotate <0,0,45>
  }
  }
  union {
  triangle {<0.2,0.3,-0.5>,<-1.4,-0.4,-0.5>,<-0.5,-0.6,-0.5> translate <0,-0.4,0>} 
  triangle {<0.2,0.3,-0.5>,<-1.4,-0.4,-0.5>,<-0.5,-0.6,-0.5> translate <0,-0.4,0> scale <1,1,-1>}
  pigment {
  gradient <1,3,0>
    color_map {
                   [0.0 0.2 color rgb 0.3 color 0.1 ]
                   [0.2 0.5 color rgb <0.1,0.1,0.1> color rgb 1]
                   [0.7 1 color rgb 1 color rgb 0.3 ]    
    }
   scale <2,2,1>
   translate <0.6,0,0>
   }
  normal {bumps 0.2 scale 0.3} 
  }
  union {
  cylinder {<-0.3,-1.1,0.1> <-0.3,-2.3,0.1>0.02}
  cylinder {<-0.3,-1.1,-0.1> <-0.3,-2.3,-0.1>0.02 }
  sphere {<-0.3,-1.6,0.1>0.025}
  sphere {<-0.3,-1.6,-0.1>0.025}
  triangle {<-0.3,-2.3,0.2>,<-0.1,-2.3,0.3>,<0,-2.3,0.2> }
  triangle {<-0.3,-2.3,-0.2>,<-0.1,-2.3,-0.3>,<0,-2.3,-0.2> }
  pigment {color rgb <0.7,0.5,0>}
  } 
  cone { <0.9,1.3,0>,0.05,<1.2,0,0>,0 pigment {color rgb <1,0.2,0>
  
  }} 
  cylinder {<0.9,1.3,-0.22><0.9,1.3,0.22>0.03 pigment {color rgb 0}}
  translate <0.3,2.3,0>
  rotate <0,12,0>
  scale 0.4
  translate <-2,2.6,-20> translate <0,1,-14>
 }  
  
  


//storch2

union {
 union {
  intersection {
   box {<0,0,-1><1,1,1>}
   torus {0.9,0.1 rotate <90,0,0> translate <0,1,0>}
   scale <1,1.5,1>  
   translate <-0.2,-0.2,0>
   }
  sphere {<1,1.5,0>,0.2 translate <-0.2,-0.2,0>}

  sphere {<0,0,0>1 scale <0.5,1,0.5> rotate <0,0,-45> translate <-0.6,-0.6,0>}
  triangle {<-1,-0.5,0>,<-2,-1.5,-0.5>,<-2.5,-1.2,0>}
  triangle {<-1,-0.5,0>,<-2,-1.5,0.5>,<-2.5,-1.2,0>}
  cone {<-0.5,-0.75,-0.1>,0.15,<-0.3,-1.1,-0.1>,0.05}
  cone {<-0.5,-0.75,0.1>,0.15,<-0.3,-1.1,0.1>,0.05}
  pigment {
    bozo 
   color_map {[0,0.2 color rgb 0.7  color rgb 1]
              [0.2,0.5 color rgb 0.6  color rgb 0.9]
              [0.5,1  color rgb 0.5  color rgb 0.8 ] } 
   scale <0.2,0.05,0.2>
   rotate <0,0,45>
  }
  }
  union {
  triangle {<0.2,0.3,-0.3>,<-1.4,-0.1,-0.8>,<-0.1,0.0,-1.3> translate <0,-0.4,0>}
  triangle {<-0.3,0.3,-1.8>,<-1.4,-0.1,-0.8>,<-0.1,0.0,-1.3> translate <0,-0.4,0>}  
   triangle {<0.2,0.3,0.3>,<-1.4,-0.1,0.8>,<-0.1,0.0,1.3> translate <0,-0.4,0>}
  triangle {<-0.3,0.3,1.8>,<-1.4,-0.1,0.8>,<-0.1,0.0,1.3> translate <0,-0.4,0>} 
  pigment {
  gradient <1,3,0>
    color_map {
                   [0.0 0.2 color rgb 0.7 color 0.1 ]
                   [0.2 0.5 color rgb 0.5 color rgb 1]
                   [0.7 1 color rgb 1 color rgb 0.5 ]    
    }
   scale <2,2,1>
   translate <0.6,0,0>
   }
  normal {bumps 0.2 scale 0.3} 
  }
  union {
  cylinder {<-0.3,-1.1,0.1> <-0.3,-2.3,0.1>0.02}
  cylinder {<-0.3,-1.1,-0.1> <-0.3,-2.3,-0.1>0.02 }
  sphere {<-0.3,-1.6,0.1>0.025}
  sphere {<-0.3,-1.6,-0.1>0.025}
  triangle {<-0.3,-2.3,0.2>,<-0.1,-2.3,0.3>,<0,-2.3,0.2> }
  triangle {<-0.3,-2.3,-0.2>,<-0.1,-2.3,-0.3>,<0,-2.3,-0.2> }
  pigment {color rgb <0.7,0.5,0>}
  translate <0,1.1,0> rotate <0,0,-25> translate <0,-1.1,0>
  } 
  cone { <0.9,1.3,0>,0.05,<2.2,1.6,0>,0 pigment {color rgb <1,0.2,0>
  
  }} 
  cylinder {<0.9,1.3,-0.22><0.9,1.3,0.22>0.03 pigment {color rgb 0}}
  translate <0.3,2.3,0>
  rotate <0,12,0>
  scale <0.4,0.275,0.4>
  rotate <0,0,-25>
  translate <-8,10,-5> translate <0,1,-14>
 
 }  



  

  
//wegstein

difference {
 union {
  box {<-0.5,0,0><0.5,0.5,0.5>}
  cylinder {<0,0.5,0><0,0.5,0.5>0.5}
  texture {T_Stone8}
  }
  torus { 0.2,0.05 rotate <90,0,0> translate <0,0.5,0> texture {T_Gold_2B}}
  scale <0.7,0.7,0.2>
  translate <2,2.75,-30>
 }

 
 
 #declare Moeve =
 union {
  triangle {<0,0,0>,<1,1,0>,<1,1,1>}
  triangle {<2,0,0>,<1,1,0>,<1,1,1>}
  triangle {<0,0,0>,<-1,1,0>,<-1,1,1>}
  triangle {<-2,0,0>,<-1,1,0>,<-1,1,1>}
  triangle {<0,0,0>,<0,-0.2,0.3><0,-0.3,-0.4>}
  triangle {<0,-0.15,-0.2>,<0.1,-0.2,-0.4>,<-0.1,-0.2,0.4>}
  pigment {color rgb 0.6}
  scale <0.5,0.3,0.3>
  }         
  
  
object {Moeve rotate <10,0,0> translate <10,10,-2> rotate <0,0,0>}
object {Moeve rotate <0,0,10> translate <5,15,7> rotate <0,0,0>}
object {Moeve rotate <10,50,0> translate <11,8,10> rotate <0,0,0>}
object {Moeve rotate <0,80,0> translate <-6,18,-5> rotate <0,0,0>}
object {Moeve rotate <20,40,0> translate <-3,16,3> rotate <-2,5,0>}
object {Moeve rotate <0,30,0> translate <7,12,-7> rotate <4,13,0>}
object {Moeve rotate <0,0,0> translate <10,10,-2> rotate <-5,30,0>}
object {Moeve rotate <30,0,10> translate <5,11,7> rotate <0,20,0>}
object {Moeve rotate <0,50,0> translate <6,9,10> rotate <5,40,0>}
object {Moeve rotate <40,80,0> translate <-6,13,-5> rotate <10,70,0>}
object {Moeve rotate <0,40,0> translate <-6,17,3> rotate <0,120,0>}
object {Moeve rotate <10,30,0> translate <0,17.5,-6> rotate <0,20,0>}

   //netz
union {
 torus {2,1.5 rotate <90,0,0> clipped_by {box {<-0.5,0,-1.5><0.5,-1.5,1.5>}}
 texture {
  pigment
  {
    brick      color rgbf <1,1,1,1>, color rgb 0
    brick_size <0.1,0.1,0.1>   
    mortar     0.02       
  }
 }
 translate <0,1.5,0>
 scale <2,1,1>
 }
 cylinder {<-1,0,0>,<-1,1.5,0>,0.05 texture {T_Wood2 rotate <0,0,80>}}
 cylinder {<1,0,0>,<1,1.5,0>,0.05 texture {T_Wood2 rotate <0,0,80>}} 
rotate <0,15,0>
translate <-6,2.6,-20>
}
                              
  
    
    //steg                          
                                                     
union {                       
 box {<-10,2.5,-15>,<-15,2.35,-16>}
 box {<-15,2.3,-15>,<-30,2.15,-16>}
 box {<-15,2.7,-15>,<-30,2.76,-15.03>}
 cylinder {<-30,2.8,-15><-30,0,-15>0.1}
 cylinder {<-30,2.8,-16><-30,0,-16>0.1}
 cylinder {<-30,2.8,-15><-28,0,-15>0.1}
 cylinder {<-28,2.8,-16><-30,0,-16>0.1} 
 cylinder {<-28,2.8,-15><-26,0,-15>0.1} 
 cylinder {<-28,2.8,-16><-26,0,-16>0.1}
 cylinder {<-28,2.8,-15><-28,0,-15>0.1} 
 cylinder {<-28,2.8,-16><-28,0,-16>0.1}
 cylinder {<-26,2.8,-15><-26,0,-15>0.1}
 cylinder {<-26,2.8,-16><-26,0,-16>0.1}
 cylinder {<-24,2.8,-15><-22,0,-15>0.1}
 cylinder {<-24,2.8,-16><-24,0,-16>0.1}
 cylinder {<-22,2.8,-15><-22,0,-15>0.1}
 cylinder {<-22,2.8,-16><-22,0,-16>0.1}
 cylinder {<-20,2.8,-15><-20,0,-15>0.1}
 cylinder {<-20,2.8,-16><-20,0,-16>0.1}
 cylinder {<-17,2.8,-15><-17,0,-15>0.1}
 cylinder {<-17,2.8,-16><-17,0,-16>0.1}
 cylinder {<-14,2.8,-15><-14,0,-15>0.1}
 cylinder {<-14,2.8,-16><-14,0,-16>0.1}
 cylinder {<-12,2.6,-15><-12,0,-15>0.1}
 cylinder {<-12,2.6,-16><-12,0,-16>0.1}
 cylinder {<-10,2.5,-15><-10,0,-15>0.1}
 cylinder {<-10,2.5,-16><-10,0,-16>0.1}
 texture { T_Wood2}
 translate <-4,-0.3,8>
 }                               
 
 //Steinweg 
 
#declare Stein = sphere {<0,0,0> 1 scale <1,0.3,1>*0.3 rotate <0,0,0>}

#declare Weg2 = union {
object {Stein texture {T_Stone7} scale <1,1,0.8> rotate <0,110,0> translate <0,0,-30>  }
object {Stein texture {T_Stone19} scale <1,1,1.1> rotate <0,120,0> translate <0.2,0,-30.3>  }
object {Stein texture {T_Stone5} scale <1,1,1.2> rotate <0,130,0> translate <-0.5,0,-30.4>  }
object {Stein texture {T_Stone24} scale <1,1,0.9> rotate <0,140,0> translate <-0.7,0,-30.5>  }
object {Stein texture {T_Stone9} scale <0.9,1,1> rotate <0,150,0> translate <0.8,0,-30.1>  } 
object {Stein texture {T_Stone11} scale <1.3,1,1> rotate <0,160,0> translate <0.5,0,-30.5>  } 
object {Stein texture {T_Stone7} scale <1.2,1,1> rotate <0,170,0> translate <0,0,-30.6>  }
object {Stein texture {T_Stone19} scale <1,1,1.2> rotate <0,180,0> translate <0.3,0,-30.7>  }
object {Stein texture {T_Stone5} scale <1,1,1.1> rotate <0,10,0> translate <-0.4,0,-30.9>  }
object {Stein texture {T_Stone7} scale <1.4,1,1> rotate <0,110,0> translate <-0,0,-30.8>  }
object {Stein texture {T_Stone19} scale <0.9,1,1> rotate <0,120,0> translate <-0.6,0,-30.65>  }
object {Stein texture {T_Stone5} scale <0.8,1,1> rotate <0,130,0> translate <0.4,0,-30.95>  }
object {Stein texture {T_Stone7} scale <1,1,0.8> rotate <0,140,0> translate <0,0,-29>  }
object {Stein texture {T_Stone19} scale <1,1,0.7> rotate <0,150,0> translate <0.2,0,-29.3>  }
object {Stein texture {T_Stone5} scale <1,1,1.3> rotate <0,160,0> translate <-0.4,0,-29.4>  }
object {Stein texture {T_Stone24} scale <1.3,1,1> rotate <0,170,0> translate <-0.6,0,-29.5>  }
object {Stein texture {T_Stone9} scale <1.2,1,1> rotate <0,180,0> translate <0.7,0,-29.1>  } 
object {Stein texture {T_Stone11} scale <1,1,1.2> rotate <0,190,0> translate <0.4,0,-29.5>  }
object {Stein texture {T_Stone7} scale <0.8,1,1.4> rotate <0,110,0> translate <0,0,-28>  }
object {Stein texture {T_Stone19} scale <0.8,1,1> rotate <0,120,0> translate <0.2,0,-28.3>  }
object {Stein texture {T_Stone5} scale <1,1,1.2> rotate <0,130,0> translate <-0.4,0,-28.4>  }
object {Stein texture {T_Stone24} scale <1,1,1.1> rotate <0,140,0> translate <-0.6,0,-28.5>  }
object {Stein texture {T_Stone9} scale <1.3,1,1> rotate <0,150,0> translate <0.7,0,-28.1>  } 
object {Stein texture {T_Stone11} scale <1,1,0.7> rotate <0,160,0> translate <0.4,0,-28.5>  }
 scale <-1,1,1>
 translate <0,3.05,0>
 }
 
#declare Weg = union {
object {Stein texture {T_Stone7} scale <1,1,0.8> rotate <0,10,0> translate <0,0,-30>  }
object {Stein texture {T_Stone19} scale <1,1,1.1> rotate <0,20,0> translate <0.2,0,-30.3>  }
object {Stein texture {T_Stone5} scale <1,1,1.2> rotate <0,30,0> translate <-0.5,0,-30.4>  }
object {Stein texture {T_Stone24} scale <1,1,0.9> rotate <0,40,0> translate <-0.7,0,-30.5>  }
object {Stein texture {T_Stone9} scale <0.9,1,1> rotate <0,50,0> translate <0.8,0,-30.1>  } 
object {Stein texture {T_Stone11} scale <1.3,1,1> rotate <0,60,0> translate <0.5,0,-30.5>  } 
object {Stein texture {T_Stone7} scale <1.2,1,1> rotate <0,70,0> translate <0,0,-30.6>  }
object {Stein texture {T_Stone19} scale <1,1,1.2> rotate <0,80,0> translate <0.3,0,-30.7>  }
object {Stein texture {T_Stone5} scale <1,1,1.1> rotate <0,0,0> translate <-0.4,0,-30.9>  }
object {Stein texture {T_Stone7} scale <1.4,1,1> rotate <0,10,0> translate <-0,0,-30.8>  }
object {Stein texture {T_Stone19} scale <0.9,1,1> rotate <0,20,0> translate <-0.6,0,-30.65>  }
object {Stein texture {T_Stone5} scale <0.8,1,1> rotate <0,30,0> translate <0.4,0,-30.95>  }
object {Stein texture {T_Stone7} scale <1,1,0.8> rotate <0,40,0> translate <0,0,-29>  }
object {Stein texture {T_Stone19} scale <1,1,0.7> rotate <0,50,0> translate <0.2,0,-29.3>  }
object {Stein texture {T_Stone5} scale <1,1,1.3> rotate <0,60,0> translate <-0.4,0,-29.4>  }
object {Stein texture {T_Stone24} scale <1.3,1,1> rotate <0,70,0> translate <-0.6,0,-29.5>  }
object {Stein texture {T_Stone9} scale <1.2,1,1> rotate <0,80,0> translate <0.7,0,-29.1>  } 
object {Stein texture {T_Stone11} scale <1,1,1.2> rotate <0,90,0> translate <0.4,0,-29.5>  }
object {Stein texture {T_Stone7} scale <0.8,1,1.4> rotate <0,10,0> translate <0,0,-28>  }
object {Stein texture {T_Stone19} scale <0.8,1,1> rotate <0,20,0> translate <0.2,0,-28.3>  }
object {Stein texture {T_Stone5} scale <1,1,1.2> rotate <0,30,0> translate <-0.4,0,-28.4>  }
object {Stein texture {T_Stone24} scale <1,1,1.1> rotate <0,40,0> translate <-0.6,0,-28.5>  }
object {Stein texture {T_Stone9} scale <1.3,1,1> rotate <0,50,0> translate <0.7,0,-28.1>  } 
object {Stein texture {T_Stone11} scale <1,1,0.7> rotate <0,60,0> translate <0.4,0,-28.5>  }
 translate <0,3.05,0>
 }
    union {
object {Weg}
object {Weg2 translate <0,0,3>}
object {Weg translate <0,0,2*3>}
object {Weg2 translate <0,0,3*3>}
object {Weg translate <0,0,-3>}
object {Weg2 translate <0,0,-2*3>}
object {Weg translate <0,0,-3*3>}
object {Weg2 translate <0,0,-4*3>}
object {Weg translate <0,0,-5*3>}
object {Weg2 translate <0,0,4*3>}
object {Weg translate <0,0,5*3>}
object {Weg2 translate <0,0,6*3>}
object {Weg translate <0,0,7*3>}
object {Weg2 translate <0,0,8*3>}
translate <-0.2,-0.175,0>  

}

 union {
object {Weg2}
object {Weg translate <0,0,3>}
object {Weg2 translate <0,0,2*3>}
object {Weg translate <0,0,3*3>}
object {Weg2 translate <0,0,-3>}
object {Weg translate <0,0,-2*3>}
object {Weg2 translate <0,0,-3*3>}
object {Weg translate <0,0,-4*3>}
object {Weg2 translate <0,0,-5*3>}
object {Weg translate <0,0,4*3>}
object {Weg2 translate <0,0,5*3>}
object {Weg translate <0,0,6*3>}
object {Weg2 translate <0,0,7*3>}
object {Weg translate <0,0,8*3>}
translate <0.75,-0.175,0>  

}       
union {
 object {Weg translate <0,0,24> rotate <0,10,0>}
 object {Weg2 translate <0,0,24> rotate <0,20,0>}
 object {Weg translate <0,0,24> rotate <0,30,0>}
 object {Weg2 translate <0,0,24> rotate <0,40,0>}
 object {Weg translate <0,0,24> rotate <0,50,0>}
 object {Weg2 translate <0,0,24> rotate <0,60,0>}
 object {Weg translate <0,0,24> rotate <0,70,0>}
 object {Weg2 translate <0,0,24> rotate <0,80,0>}
 object {Weg translate <0,0,24> rotate <0,90,0>}
 object {Weg2 translate <0,0,24> rotate <0,100,0>}
 object {Weg translate <0,0,24> rotate <0,110,0>}
 object {Weg2 translate <0,0,24> rotate <0,120,0>}
 object {Weg translate <0,0,24> rotate <0,130,0>}
 object {Weg2 translate <0,0,24> rotate <0,140,0>}
 object {Weg translate <0,0,24> rotate <0,150,0>}
 object {Weg2 translate <0,0,24> rotate <0,160,0>}
 object {Weg translate <0,0,24> rotate <0,170,0>}
 object {Weg2 translate <0,0,24> rotate <0,180,0>}
 union {
 object {Weg translate <0,0,24> rotate <0,10,0>}
 object {Weg2 translate <0,0,24> rotate <0,20,0>}
 object {Weg translate <0,0,24> rotate <0,30,0>}
 object {Weg2 translate <0,0,24> rotate <0,40,0>}
 object {Weg translate <0,0,24> rotate <0,50,0>}
 object {Weg2 translate <0,0,24> rotate <0,60,0>}
 object {Weg translate <0,0,24> rotate <0,70,0>}
 object {Weg2 translate <0,0,24> rotate <0,80,0>}
 object {Weg translate <0,0,24> rotate <0,90,0>}
 object {Weg2 translate <0,0,24> rotate <0,100,0>}
 object {Weg translate <0,0,24> rotate <0,110,0>}
 object {Weg2 translate <0,0,24> rotate <0,120,0>}
 object {Weg translate <0,0,24> rotate <0,130,0>}
 object {Weg2 translate <0,0,24> rotate <0,140,0>}
 object {Weg translate <0,0,24> rotate <0,150,0>}
 object {Weg2 translate <0,0,24> rotate <0,160,0>}
 object {Weg translate <0,0,24> rotate <0,170,0>}
 object {Weg2 translate <0,0,24> rotate <0,180,0>}
 rotate <0,180,0>
 }
translate <0,-0.15,0>
scale <0.75,1,0.75>

}

object {Weg translate <-2,-0.15,15>}
    
union {
 union {
  box {<0.5,0,0><0.4,1.5,0.1>}
  box {<-0.5,0,0><-0.4,1.5,0.1>}
  box {<0.5,0.5,0><-0.5,0.6,0.1>}
  difference {
   cylinder {<0,1.5,0><0,1.5,0.1> 0.5}
   cylinder {<0,1.5,-0.1><0,1.5,0.11> 0.4}
   plane {y, 1.5}
   }
  box {<0.05,0.05,0.05><-0.05,-0.05,-0.05> scale 1.2 rotate <0,45,45> translate <0,1.975,0.025>}
  box {<0.05,0.05,0.05><-0.05,-0.05,-0.05> scale 1.2 rotate <0,45,45> translate <0,0.55,0.025>} 
  texture {T_Brass_2B}
  translate <0,0.1,0>
  }
  difference {
   box {<0,-1,-0.02><21,6,0.2>texture {T_Wood2}}
   object {char_S texture {T_Gold_2B} translate <3,0,-1>}
   object {char_Y texture {T_Gold_2B} translate <8,0,-1>}
   object {char_L texture {T_Gold_2B} translate <13,0,-1>}
   object {char_T texture {T_Gold_2B} translate <18,0,-1>}
   translate <-10,-6,0>
   scale <0.075,0.075,0.5>
   translate <0,1.5,0>
   }
      
 translate <2.7,2.5,-38>
 }


  
