// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1
global_settings
{
  assumed_gamma 1.0
}
#include "colors.inc"  

 

#declare T_Stone26 =
texture {
    pigment {
        granite
        rotate y*90
        color_map { 
            [0.02 color rgbf <0.60, 0.45, 0.25, 0.0> ]
            [0.06 color rgbf <0.55, 0.40, 0.20, 0.0> ]
            [0.10 color rgbf <0.25, 0.20, 0.15, 0.0> ]
            [1.00 color rgbf <0.75, 0.60, 0.40, 0.0> ]
        }
        frequency 6
        rotate <0, 10, 0>
        turbulence <0.05, 0.05, 0.05>
        octaves 6
        omega 0.7
        lambda 2  
        
    }
}
texture {
    pigment {
        gradient x
        color_map {
            [0.00 color Clear ]
            [0.10 color rgbf <1.00, 1.00, 1.00, 0.75> ]
            [0.15 color rgbf <0.40, 0.25, 0.15, 0.50> ]
            [0.20 color rgbf <0.10, 0.05, 0.0, 0.25> ]
            [0.25 color rgbf <0.50, 0.25, 0.15, 0.25> ]
            [0.30 color rgbf <0.40, 0.55, 0.35, 0.50> ]
            [0.35 color rgbf <0.20, 0.25, 0.25, 0.75> ]
            [0.35 color Clear ]
        }
        frequency 3
        rotate <1, 10, 45>
        rotate x*60
        turbulence <0.30, 0.30, 0.30>
        octaves 6
        omega 0.7
        lambda 2.2 
    }
}
texture {
    pigment {
        agate
        color_map {
            [0.00 color Clear ]
            [0.10 color rgbf <1.00, 1.00, 1.00, 0.75> ]
            [0.15 color rgbf <0.40, 0.55, 0.35, 0.50> ]
            [0.20 color rgbf <0.20, 0.25, 0.25, 0.25> ]
            [0.25 color rgbf <0.45, 0.60, 0.40, 0.25> ]
            [0.30 color rgbf <0.40, 0.55, 0.35, 0.50> ]
            [0.35 color rgbf <0.20, 0.25, 0.25, 0.75> ]
            [0.35 color Clear ]
        }
        frequency 3
        rotate <2, 10, 75>
        rotate x*120
        turbulence <0.05, 0.05, 0.05>
        octaves 6
        omega 0.7
        lambda 2  
        
    }
}




// ----------------------------------------
camera
{
  location  <0, 5, -4500>
  look_at   <0.0, 2100,  0> 
  angle 75
}

#declare MyClouds = pigment{
                   bozo
                   turbulence 1.5
                   color_map{
                      [0 MidnightBlue]
                      [0.3 rgb<0.1,0.1,0.1>]
                      [0.7 MidnightBlue]
                      [1   rgb<0.1,0.1,0.1>]
                   }       
}     
 

#declare MainSky = pigment{
         gradient y
         pigment_map {
              [(1-cos(radians(30)))/2 rgb<0.15,0,0>]
              [(1-cos(radians(120)))/2 MyClouds]
         } 

}

    

 

sky_sphere{pigment{MainSky}
          }

/****
light_source
{
  0*x // light's position (translated below)
  color red 1  green 1  blue 1  // light's color
  translate <-10000, 20000, 0>
}    
****/
// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <0.8,0.8,0.8>       // light's color
  
  translate <10000, 20000, -5000> // <x y z> position of light

  

} 


   

#declare SeaMaterial=material{
                        texture{pigment{rgb<0.075,0.075,0.15>}
                                normal{ripples 0.15}             
                                finish{diffuse 0.8 ambient 0.0 reflection 0.4}
                        }
                        interior{ior 1.33}
                    }   


#declare ThroneTex = texture{T_Stone26}
#declare LampTex=texture{T_Stone26 finish{ambient 0.2}}
  
 
// ----------------------------------------
// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
#declare ThroneSeat = height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "c:\images\ThroneSeat.tga"     // the file name to read
//  inverse | texture {...}
   smooth       
   water_level 0.001
   translate<-0.5,0.0,-0.5>
   scale <500,200,500>   
}


#declare ThroneArm = height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "c:\images\ThroneArm.tga"     // the file name to read
//  inverse | texture {...}
   smooth         
   water_level 0.001 
   translate<-0.5,0.0,-0.5>
   scale <300,350,500>
}  

#declare ThroneBack = height_field
{
    tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "c:\images\Throneback.tga"     // the file name to read
   smooth         
   water_level 0.001
   translate<-0.5,0.0,-0.5>
   scale <350,300,300>
}


  
#declare Throne = union{   
             object {ThroneSeat}                    
             object {ThroneArm                
                     translate <100,0,0> 
                     }           
             object {ThroneArm 
                        matrix<
                           -1, 0, 0,
                           0,  1, 0,
                           0,  0, 1,
                           0,  0, 0>
                       translate <-100,0,0>} 
             object {ThroneBack translate<0,0,3.00>}
          
                     
}             

#declare Steps = union{
                    cylinder{<0,0,0>,<0,500,0> 4000}
                    cylinder{<0,499,0>,<0,1000,0>,3000}
                 }

#declare ElderThrone = sphere{<0,0,0>,50}   
#declare Sea=plane{y,0.2} 



#declare R1 = seed(500);  
#declare R2 = seed(100);
#declare R3 = seed(200);
#declare FlameShape= merge{
                        cone{<0,0,0>,10,<0,50,0>,50} 
                       
                        blob{threshold 0.7 
                          #declare BallCount = 0         
                          #while (BallCount < 400)
                              #declare sx = 50 - rand(R1)*100;
                              #declare sz = 50 - rand(R2)*100;
                              #declare dy2 = 5 - rand(R3)*10;
                              #declare sradius = 10.0; 
                              #if ((sx*sx + sz*sz) <= 2500)
                                  sphere{<sx,50+dy2,sz>,sradius,0.8}
                                  #declare BallCount = BallCount+1;
                              #end
                          #end   
                          
                      }        
                     
                      hollow
                  
                      texture{pigment{rgbt <1,0.25,0,0.8>}
                             //normal{bozo 0.5
                             //       bump_size 5}
                         }  
                         interior{ 
                         media{
                                  emission 0.3
                                  scattering{4,0.1}
                                 // absorption <0.2,0,0>
                                     samples 5, 100
                                     intervals 10
                                     confidence 0.75
                                     variance 1/1000
                                  density {cylindrical
                                     turbulence 5
                                     scale 30
                                     translate<-10,0,0>
                                     frequency 10
                                     color_map{
                                          [0.9 rgbf <0.01, 0.01,0.01,1.0>]
                                       //   [0.5 rgb <0.1,0.01,0.0>] 
                                       //   [0.7 rgb <0.05,0.0,0.0>]   
                                          [1.0 rgbf <0.1,0.1,0.1,1>]
                                     } 
                                  
                                  }}}
}


#declare Flame =  
                   light_source{
                            <0,0,0>                     // light's position (translated below)
                            color rgb <0.8,0.8,0.8>       // light's color 
                            looks_like{FlameShape} 
                   }                          
                  
                   
                 
                   
                                                           
                       


          
#declare Lamp= height_field
{
  tga              // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "c:\images\VolcanoTex.tga"     // the file name to read         
  water_level 0.3
  translate <-0.5,-0.3,-0.5>
  scale <250,400,250>
}


#declare WaterMat=material{
                  texture{pigment{gradient z   
                                  color_map{[0 Clear]
                                            [0.5 White]
                                            [1 Clear]}
                                  scale 2
                                  translate<0,0,1> }
        
                          normal{gradient z}                  
                          }
                  interior{ior 1.33}
}                      

#declare WaterFall = blob{ 
         threshold 1.0  
         #declare RStream=seed(500);
         #declare Amplitude = 1.0;
         #declare px = -0.5;
         #declare py =  -Amplitude*px * px + 1;
         #declare pz = 1.0;
         #declare dx = 0.1; 
         #declare dz = 0.1;
         #while (px <= 3.5)
            #declare pz = -0.5;
            #while (pz<= 1.1)              
               sphere{<px,py,pz>,0.2,1                       
                     scale<1,1.2,1>
                    }
               #declare pz = pz + dz;      
                           
            #end        
            #declare dx = rand(RStream)*0.05;
            #declare px = px + dx; 
            #declare dy = -Amplitude *px  * dx;
            #declare py = py + dy; 
            #if ((px <= 0.2)&(px >= -0.05))
                #declare pz = -1.25 + px;
                #declare dz = 0.05;
            #else   
                #declare pz = -1.0;
                #declare dz = 0.1;
            #end 
         #end
}                           






//object{Range1 pigment{Brown}}
object{Sea material{SeaMaterial}}

/** God's Throne ****/   
object{Throne 
       texture{ThroneTex}
       scale <20,20,10> 
       translate<0,-1,0>
       }  
      

object{WaterFall 
        material{WaterMat}            
        scale<150,500,200> 
        rotate<0,80,0>
        translate<-1900,2000,-1400>
        
}        

object{WaterFall    
        material{WaterMat}             
        matrix<1,0,0,
               0,1,0,
               0,0,-1,
               0,0,0>  
        scale<150,500,200>
        rotate<0,100,0>
        translate<1900,2000,-1400>
}               

/**** 
    
object{Lamp 
       texture{LampTex}
       scale <8,10,10>
       translate<-1000,-300,-2000>
       }
object{Flame scale<8,10,10> translate<-1000,400,-2000>}              

object{Lamp    
       texture{LampTex}
       scale <8,10,10>
       translate<1000,-300,-2000>
       }
object{Flame scale<8,10,10> translate <1000,400,-2000>}         
***/
  
/****       
object{Lamp 
       texture{LampTex}
       scale <25,40,20>
       translate<-4100,0,1000>
       texture{LampTex}}       
object{Flame scale <25,40,20> translate <-4100,3100,1000>}   

object{Lamp 
       texture{LampTex}
       scale <25,40,20>
       translate<4100,0,1000>
      }    
object{Flame scale <25,40,20> translate <4100,3100,1000>}          
****/      
//object{Lamp  
//       texture{LampTex}
       //scale <10,10,10>
//       translate<50,-70,-6500>
//      }   
               
  /****            
object{Flame  
       scale<3,2.5,2>
       translate <30,-75,-4500>}          
       
       
 ****/      
//MEC       
/***       
object{Lamp 
       texture{LampTex}
       scale <10,10,10>
       translate<0,-200,-2100>
       }                    
object{Flame scale <10,10,10> translate <0,500,-2100>}          
****/
/***
object{Lamp            
       texture{LampTex} 
       scale <10,10,10>
       translate<-1000,-200,-6500>
      }                    
object{Flame scale <10,10,10> translate <-1000,350,-6500>}                      
***/
                
       
                

