global_settings { assumed_gamma 2.2 }

// NOTE: YOU NEED TO HAVE THE SUPERPATCH TO BE ABLE TO RENDER THIS SCENE

#declare DP  = color rgb <0.265, 0.060, 0.235>;
#declare DP2 = color rgbt<0.265, 0.060, 0.235, 0.65>;
#declare CC  = color rgb <0.850, 0.530, 0.100>;

#declare Face_Tex1=
 texture {
  pigment {
   crackle
   turbulence 0.371
   color_map {
    [0.0 CC]
    [0.3 CC*.8]
    [0.6 CC*.6]
    [1.0 CC*.4]
   }
  scale <1,13,1>
  }
  finish {ambient 0.23 diffuse 0.24}
 }
 texture {
  pigment {
   crackle
   turbulence 0.371
   color_map {
    [0.0 DP]
    [0.3 DP2*.8]
    [0.6 DP2*.6]
    [1.0 DP*.4]
   }
   scale <1,10,1>
  }
  finish {ambient 0.33 diffuse 0.14}
 }
 texture {
  pigment {
   marble
   turbulence 2
   color_map {
    [0.0   rgbt 1]
    [0.35  rgbt 1]
    [0.45  rgbt <0.5, 0.4, 0.1, 0.5>]
    [0.5   rgb  <0.5, 0.4, 0.1>]
    [0.55  rgbt <0.5, 0.4, 0.1, 0.5>]
    [0.65  rgbt 1]
    [1.0   rgbt 1]
   }
   scale <5,20,5>
  }
 }


#declare Brown = color red 0.647059 green 0.164706 blue 0.164706;
#declare Coral = color red 1.0 green 0.498039 blue 0.0;
#declare DarkSlateGrey = color red 0.184314 green 0.309804 blue 0.309804;
#declare Firebrick = color red 0.556863 green 0.137255 blue 0.137255;
#declare Goldenrod = color red 0.858824 green 0.858824 blue 0.439216;
#declare IndianRed = color red 0.309804 green 0.184314 blue 0.184314;
#declare Bronze = color red 0.55 green 0.47 blue 0.14;

#declare X1=
 color_map {
  [0.00 (Bronze+Goldenrod)/2]
  [0.15 (IndianRed+Goldenrod)/2]
  [0.25 Goldenrod]
  [0.28 (DarkSlateGrey+Goldenrod)/2]
  [0.30 DarkSlateGrey+(Goldenrod/4)]
  [0.32 (DarkSlateGrey+Goldenrod)/2]
  [0.35 (Firebrick+Goldenrod)/2]
  [0.45 (Firebrick+Goldenrod)/2]
  [0.60 Goldenrod]
  [0.75 (IndianRed+Goldenrod)/2]
  [1.00 (Bronze+Goldenrod)/2]
 }

#declare X2=
 color_map {
  [0.00 Goldenrod+(DarkSlateGrey/3)]
  [0.45 Goldenrod/1.3]
  [1.00 Goldenrod+(IndianRed/3)]
 }


#declare Sand1=
 texture {
  pigment {
   gradient y-(0.5*x)
   sine_wave
   turbulence 0.3
   frequency 0.1
   color_map {X2}
  }
  normal {granite 0.5 scale <1,0.1,1>}
  finish {ambient 0.24 diffuse 0.62 specular 0.1 roughness 0.07}
 }
 
#declare Pig1=
 function{
  pigment{
   bozo
   color_map{[0 rgb 1][1 rgb 0]}  
   scale .3
  }
 } 

#declare Pig3=
 function{
  pigment{
   bozo
   turbulence 0.371
   color_map{[0 rgb 1][1 rgb 0]}  
   scale .3
  }
 } 

#declare Cm1=
 camera {
  location <-50, 50, -400>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, 0, 0>
 }

#declare Cm2=
 camera {
  location <-12, 12, -20>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, 0, 0>
 }

#declare Cm3=
 camera {
  location <-2.5, 4, -20>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, 0, 0>
 }

#declare Cm4=
 camera {
  location <0, 10, -22>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, 23, 10>
 }

#declare Cm5=
 camera {
  location <0, 10, -8>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, 0, 0>
 }

#declare Cm6=
 camera {
  location <0, 3, -50>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <-5,31,50>
 }

#declare Cm7=
 camera {
  location <0, 3, -50>
  direction <0, 0, 1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <-5,3,50>
 }

camera {Cm6}

light_source {<-30, 100, -200> color rgb <1.2,1.0,0.8>
 area_light <-70,140,-240>, <10,60,-160>, 6, 6
}

#declare Spire1=
 union {
  // +(Pig1(x/3,y*2,z)*0.3)
  // DISK ON TOP
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/6) , (y/2) , (z/6) )*0.3)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15
   scale <6,2,6>
   rotate 8*x
   translate <9,63,50>
   texture {Sand1 scale 19}
  }
  // CENTRAL SPIRE
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/3.5) , (y/23)*9 , (z/3.5)*2 )*0.2)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15
   scale <3.5,23,3.5>
   translate <12,0,51>
   texture {Sand1 scale 19}
  }
  // FRONTAL NODE
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/2.5) , (y/13)*4 , (z/2.5)*2 )*0.2)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15
   scale <2.5,13,2.5>
   rotate -8*x
   translate <15,-14,48>
   texture {Sand1 scale 19}
  }
  // RIGHT-HAND NODE
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/3) , (y/13)*7 , (z/3)*2 )*0.2)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15
   scale <3,18,3>
   rotate -8*z
   translate <20,-5.5,52>
   texture {Sand1 scale 19}
  }
 }

#declare Spire_T1=
 union {
  sphere {0,1
   scale 3
   scale <6,2,6>
   rotate 8*x
   translate <9,63,50>
  }
  sphere {0,1
   scale 3
   scale <3.5,23,3.5>
   translate <12,0,51>
  }
  sphere {0,1
   scale 3
   scale <2.5,13,2.5>
   rotate -8*x
   translate <15,-14,48>
  }
  sphere {0,1
   scale 3
   scale <3,18,3>
   rotate -8*z
   translate <20,-5.5,52>
  }
  texture {Sand1 scale 19}
 }

#declare Spire_T2=
 union {
  sphere {0,1
   scale 3
   scale <6,6,2>
  }
  sphere {0,1
   scale 3
   scale <2,4,2>
   rotate <14,0,-20>
   translate <14,0,-20>
  }                
  sphere {0,1
   scale 3
   scale <3,16,3>
   rotate <-10,0,-63>
   translate <-12,0,12>
  }
  texture {Sand1 scale 19}
 }

#declare Spire2=
 union {
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/6) , (y/2) , (z/6) )*0.3)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15

   scale <6,6,2>
  }
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/6) , (y/2) , (z/6) )*0.3)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15

   scale <2,4,2>
   rotate <14,0,-20>
   translate <14,0,-20>
  }                
  isosurface {
   function {(x^2+y^2+z^2)/8
    +(Pig1( (x/6) , (y/2) , (z/6) )*0.3)
   }
   bounded_by {sphere {0,4}}
   sign 1
   threshold 1
   max_gradient 15

   scale <3,16,3>
   rotate <-10,0,-63>
   translate <-12,0,12>
  }
  texture {Sand1 scale 19}
 }

#declare Rot1=0;

#declare Face=
blob {
 threshold 0.65
 #while (Rot1 <= 180)
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate -25*z translate -2*x rotate Rot1*y  translate 1*y}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate -10*z translate -2*x rotate Rot1*y  translate 1*y}
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate  25*z rotate 180*x   translate -2*x rotate Rot1*y translate 1*y}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate  10*z rotate 180*x   translate -2*x rotate Rot1*y translate 1*y}
 #declare Rot1=Rot1+45;
 #end
 #while (Rot1 <= 360)
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate  10*z translate -2*x rotate Rot1*y  translate 1*y}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate  25*z translate -2*x rotate Rot1*y  translate 1*y}
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate -10*z rotate 180*x   translate -2*x rotate Rot1*y translate 1*y}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate -25*z rotate 180*x   translate -2*x rotate Rot1*y translate 1*y}
  #declare Rot1=Rot1+45;
 #end
 #declare Rot1=0;
 #while (Rot1 <= 180)
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate -25*z translate -2*x rotate Rot1*y  translate -1*y rotate   180*x}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate -10*z translate -2*x rotate Rot1*y  translate -1*y rotate   180*x}
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate  25*z rotate 180*x   translate -2*x rotate  Rot1*y translate -1*y rotate 180*x}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate  10*z rotate 180*x   translate -2*x rotate  Rot1*y translate -1*y rotate 180*x}
 #declare Rot1=Rot1+45;
 #end
 #while (Rot1 <= 360)
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate  10*z translate -2*x rotate Rot1*y  translate -1*y rotate   180*x}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate  25*z translate -2*x rotate Rot1*y  translate -1*y rotate   180*x}
  sphere {0,1,1 scale <0.5,3,2> translate  1*y rotate -10*z rotate 180*x   translate -2*x rotate  Rot1*y translate -1*y rotate    180*x}
  sphere {0,1,1 scale <0.5,3,2> translate -1*y rotate -25*z rotate 180*x   translate -2*x rotate  Rot1*y translate -1*y rotate    180*x}
  #declare Rot1=Rot1+45;
 #end
 sphere {0,1,-2 scale <0.2,1,6> rotate -10*z translate <0,-1.5,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate -20*z translate <0,-2.0,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate -30*z translate <0,-2.5,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate -160*z translate <0,-3,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate -170*z translate <0,-3.5,3> pigment {rgb<1,1,0>}}

 sphere {0,1,-2 scale <0.2,1,6> rotate  10*z translate <0,-1.5,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate  20*z translate <0,-2.0,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate  30*z translate <0,-2.5,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate  160*z translate <0,-3,3> pigment {rgb<1,1,0>}}
 sphere {0,1,-2 scale <0.2,1,6> rotate  170*z translate <0,-3.5,3> pigment {rgb<1,1,0>}}
 sturm
 texture {Face_Tex1 scale <0.2,0.5,0.2>}
 texture {
  pigment {rgbt <0,0,0,0.35>}
  finish {specular 0.5 roughness 0.05}
  normal { function (Pig3(x*6,y,z*6)*0.1)}
 }
 rotate 180*y
}

// ANTENNA ARE 100 WIDE, 20 HIGH
#declare Z_Rot=0;
#declare Scaler=1;
#declare X_Mov=0;

#declare Antenna=
 blob {
  threshold 0.65
  #while (Z_Rot <= 180)
   #if (Z_Rot > 38)
    sphere {0,1,1 scale <Scaler,Scaler,(Scaler/3)> translate 52*x translate -X_Mov*x rotate Z_Rot*z}
   #end
   #declare Z_Rot=Z_Rot+1;
   #declare Scaler=Scaler+(5/180);
   #if (Z_Rot > 120)
    #declare X_Mov=X_Mov+(4/60);
   #end
  #end
  translate -52*x
  rotate 15*z
  scale <1,0.3,1>
  translate <95,8,0>
  pigment {rgb<(63/255),(38/255),(7/255)>}
  finish {specular 0.76 roughness 0.075 ambient 0.54 diffuse 0.62}
 }

#declare Mraan_Face=
 union {
  // RIGHT ANTENNA
  object {Antenna  scale 0.15 rotate 40*z rotate 15*x translate <-0.17,2.8,1.2> rotate -90*y}
  // LEFT ANTENNA
  object {Antenna  scale 0.15 rotate 35*z rotate -15*x translate <-0.17,2.8,-1.2> rotate -90*y}
  // FACE
  difference {
   object {Face}
   // RIGHT EYE HOLE
    sphere {0,0.5 scale <1,2.4,1> translate <-1,1.2,-2> texture {Face_Tex1 scale <0.2,0.5,0.2>}}
    sphere {0,0.5 scale <1,1.4,1> translate <-1,1.2,-2> texture {Face_Tex1 scale <0.2,0.5,0.2>}}
   // LEFT EYE HOLE
    sphere {0,0.5 scale <1,2.4,1> translate <1,1.2,-2> texture {Face_Tex1 scale <0.2,0.5,0.2>}}
    sphere {0,0.5 scale <1,1.4,1> translate <1,1.2,-2> texture {Face_Tex1 scale <0.2,0.5,0.2>}}
  }
  // RIGHT EYE
  union {
   sphere {0,0.5 clipped_by {box {<-2,-2,-2>,<2,2,0>}} scale <1,2.4,1> clipped_by {box {<-4,0,-4>,<4,4,0>}} translate <-1,1.2,-2> pigment {rgbft <1.4, 0.0, 0.5, 0.5, 0.5>} normal {crackle -0.25 scale 0.175} finish {specular 0.95 roughness 0.005} interior {ior 1.5}}
   sphere {0,0.5 clipped_by {box {<-2,-2,-2>,<2,2,0>}} scale <1,1.4,1> clipped_by {box {<-4,0,-4>,<4,-4,0>}} translate <-1,1.2,-2> pigment {rgbft <1.4, 0.0, 0.5, 0.5, 0.5>} normal {crackle -0.25 scale 0.175} finish {specular 0.95 roughness 0.005} interior {ior 1.5}}
  }
  // LEFT EYE
  union {
   sphere {0,0.5 clipped_by {box {<-2,-2,-2>,<2,2,0>}} scale <1,2.4,1> clipped_by {box {<-4,0,-4>,<4,4,0>}} translate <1,1.2,-2> pigment {rgbft <1.4, 0.0, 0.5, 0.5, 0.5>} normal {crackle -0.25 scale 0.175} finish {specular 0.95 roughness 0.005} interior {ior 1.5}}
   sphere {0,0.5 clipped_by {box {<-2,-2,-2>,<2,2,0>}} scale <1,1.4,1> clipped_by {box {<-4,0,-4>,<4,-4,0>}} translate <1,1.2,-2> pigment {rgbft <1.4, 0.0, 0.5, 0.5, 0.5>} normal {crackle -0.25 scale 0.175} finish {specular 0.95 roughness 0.005} interior {ior 1.5}}
  }
  scale <0.7,1.5,1>
  rotate 15*x
  rotate -35*y
  translate <-4.7,1.8,-40>
 }


object {Spire1}
object {Spire2 translate <-12,0,122>}
object {Spire2 rotate -45*y translate <220,6,372>}
object {Mraan_Face}



height_field {tga "xt3.tga" smooth
 translate <-0.5,-0.5,0>
 scale <300,50,700>
 translate <0,-25,-70>
 texture {Sand1 scale 19}
}

fog{
    rgbt<0.3, -0.5, 0.4, 0.875>
    fog_type 2
    fog_alt 1.45
    fog_offset -10
    distance 0.11
    turbulence <.2, .2, .2>
    omega 0.40
    lambda 1.25
    octaves 5
}

fog{
    rgbt<0.858824/4, 0.858824/4, 0.43921/4, 0.175>
    fog_type 2
    fog_alt 1.45
    fog_offset -135
    distance 1.25
    turbulence <.2, .2, .2>
    omega 0.40
    lambda 1.25
    octaves 5
}

background {rgb<0.6,0.6,1>}
