/*
#include "colors.inc" 
#include "skies.inc"

sky_sphere {S_Cloud1}


camera {
	location <0,30,-60>
	look_at  <0,30,0>
}

light_source {<10,50,-100> color White}
*/

#declare Homoculus_Cage =
union {

#include "hom.inc"
object {Homoculus rotate <0,180,0> scale 45  translate <0,3,0> pigment{rgb <1.9,1.8,1.4>}finish{phong .2 phong_size 5}}


difference {
	cylinder {<0,0,0><0,40,0>,12 material{T13_Glass}}  
	cylinder {<0,-1,0><0,41,0>,10.5 material{T13_Glass}}
} 



difference {
	cylinder {<0,0,0><0,38,0>,10.499 texture{pigment{rgbf<.8,.7,.3,.6>}}}
	
	
	blob { threshold .75
		sphere {<0,38,0>,10,1} 
		#local Count1 = 0;
		#local Qty = 60;
		#local RS = seed(666);
		#while (Count1 < Qty)
		
			#local S1 = rand(RS);
			#local S2 = rand(RS);
			#if (S1 > .5)#local S1 = 1; #else #local S1 = -1; #end
			#if (S2 > .5)#local S2 = 1; #else #local S2 = -1; #end
			sphere {<(rand(RS) * 13 * S1),38,(rand(RS) * 13 * S2)>,(rand(RS) * 7),1}
		
			#local Count1 = (Count1 + 1);
		#end
		
		texture{
			pigment{rgbf<.8,.7,.3,.6>}
			finish {phong .5 reflection .1}
		}
	} 
	
	#local Count1 = 0;
	#local Qty = 500;
	#local RS = seed(13);
	#while (Count1 < Qty)
	
		sphere {<0,0,(5 + (rand(RS) * 5.3))>,.2
			rotate <0,(360 * rand(RS)),0>
			translate <0,(rand(RS) * 37),0>
			material{T13_Glass2}
		}
	
		#local Count1 = (Count1 + 1);
	#end  
	no_shadow
}  



light_source {<0,39,0> 
	color <1,.9,.5>
	fade_distance 40
	fade_power 2
} 

#declare Crib_Arm =
union {
	cylinder {<0,0,0><18,0,0>,1 texture{PodTex}}
	cone {<18,0,0>,.75,<22,0,0>,0 texture{PodTex}}
	cylinder {<15,-1,0><15,1,0>,2 texture{PodTex}} 
	cylinder {<15,-2,0><15,2,0>,1.8 texture{PodTex}}
}

#declare Crib_Cap =
union {

	cylinder {<0,0,0><0,-2.5,0>,12.5 texture{PodTex}} 
	cylinder {<0,-1.5,0><0,-1,0>,13 texture{PodTex}}  

	cylinder {<0,-4,0><0,-2.5,0>,11 texture{PodTex}}
	cylinder {<0,-4,0><0,-6,0>,8 texture{PodTex}}
	
	object {Crib_Arm translate <0,-1,0> rotate <0,30,0>} 
	object {Crib_Arm translate <0,-1,0> rotate <0,150,0>}
	object {Crib_Arm translate <0,-1,0> rotate <0,270,0>}
}

object {Crib_Cap}
object {Crib_Cap scale <1,-1,1> translate <0,40,0>}   

#declare Crib_Rod =
union {
	cylinder {<0,0,0><0,40,0>,.75 texture{PodTex}}
	
	cylinder {<0,5,0><0,10,0>,1 texture{PodTex}}
	cylinder {<0,15,0><0,20,0>,1 texture{PodTex}}
	cylinder {<0,25,0><0,30,0>,1 texture{PodTex}}
	cylinder {<0,35,0><0,40,0>,1 texture{PodTex}}
} 

object {Crib_Rod translate <15,0,0> rotate <0,30,0>} 
object {Crib_Rod translate <15,0,0> rotate <0,150,0>}
object {Crib_Rod translate <15,0,0> rotate <0,270,0>}  

#declare Support_Rod = cylinder {<15,43,0><0,80,0>,.4 texture{PodTex}}

object {Support_Rod rotate <0,30,0>} 
object {Support_Rod rotate <0,150,0>}
object {Support_Rod rotate <0,270,0>} 

}  

//object {Homoculus_Cage}

