//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//
//  Date : 03/13/1999    (13.03.1999)
//

// ========== Scene Comment ==========
//   This scene was created with Moray V3.1 For Windows.
//   Then it was modified in Povray, when I couldn't make it do quite what I wanted.
//   The room itself is based on tha bathroom I had when I started this project:
//    each unit of POV distance is equal to 1 centimetre of "real world".
// ===================================
 

global_settings {
     assumed_gamma 2.15                 max_intersections 64          max_trace_level 10
     radiosity {
          brightness       3.3          count            100          distance_maximum 0.0
          error_bound      0.4          gray_threshold   0.5          low_error_factor 0.8
          minimum_reuse    0.015        nearest_count    6            recursion_limit  1
     } 
} 

// Level 1 is for basic positioning of props
// Level 2 puts the jitter etc. into the light settings
#declare My_Level = 2;

//
// ********  MATERIALS  *******
//

#include "colors.inc"
#include "metals.inc"         // Polished Copper
#include "fittings.inc"       // Tub, sink, etc.
#include "room.inc"           // Walls, floor
#include "glass_1.inc"        // Glass tumbler, & pregnancy test 'Paddle'
#include "hanger1.inc"        // Bent Coathanger
#include "phone.inc"          // Mobile Phone


camera {  //  Camera StdCam
     location  < 8,  -52,  127 >   // Camera height (Approx. eye height)
     direction < 0,    0,    1 >  
     sky       < 0,    0,    1 >   // Use right handed-system 
     up        < 0,    0,    1 >   // Where Z is up (Damn you, Moray!)
     right     < 1.33333, 0, 0 >   // Aspect ratio
     look_at   < -120, -9,  70 >   // Wall behind sink is at x= -120
                                   // Wall behind bathtub (with window for light) is at y = 105
     angle     38.6                // 50mm lens = 38.58
}

//
// *********************  L I G H T S ****************************
//
// Room_Light
#if (My_Level = 1)
     light_source {  
          228*z                    color rgb 1       
          media_interaction off 
     }
#end
#if (My_Level = 2)
     light_source {  
          <-2.5, -2.5, 228 >       color rgb 1         area_light
          <5, 0, 0> <0, 5, 0>      4, 4                adaptive 1
          jitter                   looks_like { sphere { 249*z, 25  } }
    }
#end          
 

#if (My_Level = 1)  // LIGHT: Thru Window
     light_source { <95, 200, 240>          color rgb  0.45 } // <1, .3, .3 > 
#end
#if (My_Level = 2)
     light_source { 
          <95, 200, 240>          color rgb  0.45 // <1, .3, .3 >
          area_light               <15, 0, 0> <0, 0, 15>      4, 4                
          adaptive 1               jitter
     }
#end

#if (My_Level = 1)  // LIGHT: Flash thru doorway
     light_source { <72, -110, 155> color rgb  0.69 } 
#end
#if (My_Level = 2)
     light_source { 
          <28, -110, 110>         color rgb  0.69  
          area_light              <90, 0, 0> <0, 0, 90>      4, 4                
          adaptive 1              jitter
     }
#end


// ====================== ********  OBJECTS  ******* =========================================
//                                                                        
//      Originally, the scene contained an (almost) empty bottle of gin. However, I couldn't 
//      find a way to include it without the scene becoming too "cluttered". I could probably
//      even do away with the mobile phone....
                                                                        

object { Room } 
object { Fittings }

object { Tumbler         rotate <  0, 0, -30 >        translate < -113, -44.5, 81.05 > }
// object { Phone           rotate < 90, 0,   90 >        translate <  -78, -45.1, 84.1  > }
object { Packet          rotate <24, 0, 60>            translate  <-79.9, -45.9, 81.09> }

object { Coathanger      rotate < 90, 0, -116 >        translate < -107,   0,   83.05 > }
object { Blood_Spot                                    translate <-68, -18.9, 81.01 >  }

                                             



                                             