//

// 2.     Coathanger ------------------------------
#declare Coathanger_T = material  {   
     texture {      
          pigment { color rgb <0.658824, 0.658824, 0.658824>  }      
          normal  { bumps , -0.5        scale  <1.0, 0.001, 0.001>   }      
          finish  { 
               ambient 0.3         diffuse 0.7    
               brilliance 8        specular 0.8   
               roughness 0.1       reflection 0.15 
          }
     }
}


// ********  REFERENCED OBJECTS  *******
//

#declare Spiral_Length =      2.5;      // Length of spiral
#declare Spiral_Quality =     50;       // Higher means smoother, but renders take longer
#declare Outer_Radius =       0.2;      // A larger radius needs larger quality
#declare Inner_Radius =       0.25;     // Spiral radius (quality also affects this)
#declare Whorl_Density =      1.5;      // Number of windings in a certain length
#declare Helix = blob {
     #declare zh = 0;
     threshold 0.5
     #while (zh < Spiral_Length * Whorl_Density )
          sphere { 
               < 0, zh*3/Whorl_Density, 0 >, Inner_Radius, 0.6
               translate < Outer_Radius, 0, 0 >
               rotate < 0, 200*zh, 0 >
          }
          #declare zh = zh + (1/Spiral_Quality);
     #end
     scale 0.5
     rotate 90*x
     translate -1.16*z 
}


// Body001
#declare Body001 = object {
     cylinder { <0,0,0.6>, <0,0,0>, 0.1      rotate -15.0*y      translate  <0.28, 0.0, -1.73> }
}

#declare Wire001 = union { 
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-0.013083, 0, -0.999914>, <-0.013083, -1.333333, -0.999914>, <0.013083, -1.333333, 0.999914>, 
               <0.013083,  0, 0.999914>, <-5.557299, 0, 2.386896>, <-5.557299, -1.333333, 2.386896>, 
               <-3.866503, -1.333333, 3.455169>, <-3.866503, 0, 3.455169>, <-6.251214, 0, 8.147546>, 
               <-6.251214, -1.333333, 8.147546>, <-4.251247, -1.333333, 8.135933>, <-4.251247, 0, 8.135933>, 
               <-6.029177, 0, 38.013519>, <-6.029177, -1.333333, 38.013519>, 
               <-4.068808, -1.333333, 38.286388>, <-4.068808, 0, 38.286388>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <0.013083, -0.000000, 0.999914>, <0.013083, 1.333333, 0.999914>, 
               <-0.013083, 1.333330, -0.999914>, <-0.013083, -0.000002, -0.999914>, 
               <-3.866503, -0.000000, 3.455169>, <-3.866503, 1.333333, 3.455169>, 
               <-5.557299, 1.333330, 2.386896>, <-5.557299, -0.000002, 2.386896>, 
               <-4.251247, -0.000000, 8.135933>, <-4.251247, 1.333333, 8.135933>, 
               <-6.251214, 1.333330, 8.147546>, <-6.251214, -0.000002, 8.147546>, 
               <-4.068808, -0.000000, 38.286388>, <-4.068808, 1.333333, 38.286388>, 
               <-6.029177, 1.333330, 38.013519>, <-6.029177, -0.000002, 38.013519>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-6.029177, -0.000002, 38.013519>, <-6.029177, -1.333333, 38.013519>, 
               <-4.068808, -1.333333, 38.286388>, <-4.068808, -0.000000, 38.286388>, 
               <-5.807139, -0.000002, 67.879492>, <-5.807139, -1.333333, 67.879492>, 
               <-3.886369, -1.333333, 68.436843>, <-3.886369, -0.000000, 68.436843>, 
               <-8.287858, -0.000002, 92.578252>, <-8.287858, -1.333333, 92.578252>, 
               <-6.522854, -1.333333, 93.518869>, <-6.522854, -0.000000, 93.518869>, 
               <-11.278539, -0.000002, 103.169745>, <-11.278539, -1.333333, 103.169745>, 
               <-9.596134, -1.333333, 104.240183>, <-9.596134, -0.000000, 104.240183>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-4.068808, -0.000000, 38.286388>, <-4.068808, 1.333333, 38.286388>, 
               <-6.029177, 1.333330, 38.013519>, <-6.029177, -0.000002, 38.013519>, 
               <-3.886369, -0.000000, 68.436843>, <-3.886369, 1.333333, 68.436843>, 
               <-5.807139, 1.333330, 67.879492>, <-5.807139, -0.000002, 67.879492>, 
               <-6.522854, -0.000000, 93.518869>, <-6.522854, 1.333333, 93.518869>, 
               <-8.287858, 1.333330, 92.578252>, <-8.287858, -0.000002, 92.578252>, 
               <-9.596134, -0.000000, 104.240183>, <-9.596134, 1.333333, 104.240183>, 
               <-11.278539, 1.333330, 103.169745>, <-11.278539, -0.000002, 103.169745>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-11.278539, -0.000002, 103.169745>, <-11.278539, -1.333333, 103.169745>, 
               <-9.596134, -1.333333, 104.240183>, <-9.596134, -0.000000, 104.240183>, 
               <-14.269219, -0.000002, 113.761238>, <-14.269219, -1.333333, 113.761238>, 
               <-12.669413, -1.333333, 114.961497>, <-12.669413, -0.000000, 114.961497>, 
               <-59.461359, -0.000002, 186.345937>, <-59.461359, -1.333333, 186.345937>, 
               <-57.861553, -1.333333, 187.546195>, <-57.861553, -0.000000, 187.546195>, 
               <-59.919271, -0.000002, 188.327249>, <-59.919271, -1.333333, 188.327249>, 
               <-58.119367, -1.333333, 188.927378>, <-58.119367, -0.000000, 188.927378>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-9.596134, -0.000000, 104.240183>, <-9.596134, 1.333333, 104.240183>, 
               <-11.278539, 1.333330, 103.169745>, <-11.278539, -0.000002, 103.169745>, 
               <-12.669413, -0.000000, 114.961497>, <-12.669413, 1.333333, 114.961497>, 
               <-14.269219, 1.333330, 113.761238>, <-14.269219, -0.000002, 113.761238>, 
               <-57.861553, -0.000000, 187.546195>, <-57.861553, 1.333333, 187.546195>, 
               <-59.461359, 1.333330, 186.345937>, <-59.461359, -0.000002, 186.345937>, 
               <-58.119367, -0.000000, 188.927378>, <-58.119367, 1.333333, 188.927378>, 
               <-59.919271, 1.333330, 188.327249>, <-59.919271, -0.000002, 188.327249>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-59.919271, -0.000002, 188.327249>, <-59.919271, -1.333333, 188.327249>, 
               <-58.119367, -1.333333, 188.927378>, <-58.119367, -0.000000, 188.927378>, 
               <-60.377182, -0.000002, 190.308561>, <-60.377182, -1.333333, 190.308561>, 
               <-58.377182, -1.333333, 190.308561>, <-58.377182, -0.000000, 190.308561>, 
               <-45.984129, -0.000002, 288.632867>, <-45.984129, -1.333333, 288.632867>, 
               <-44.051156, -1.333333, 288.119433>, <-44.051156, -0.000000, 288.119433>, 
               <-33.199451, -0.000002, 330.115541>, <-33.199451, -1.333333, 330.115541>, 
               <-31.232965, -1.333333, 329.858824>, <-31.232965, -0.000000, 329.858824>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-58.119367, -0.000000, 188.927378>, <-58.119367, 1.333333, 188.927378>, 
               <-59.919271, 1.333330, 188.327249>, <-59.919271, -0.000002, 188.327249>, 
               <-58.377182, -0.000000, 190.308561>, <-58.377182, 1.333333, 190.308561>, 
               <-60.377182, 1.333330, 190.308561>, <-60.377182, -0.000002, 190.308561>, 
               <-44.051156, -0.000000, 288.119433>, <-44.051156, 1.333333, 288.119433>, 
               <-45.984129, 1.333330, 288.632867>, <-45.984129, -0.000002, 288.632867>, 
               <-31.232965, -0.000000, 329.858824>, <-31.232965, 1.333333, 329.858824>, 
               <-33.199451, 1.333330, 330.115541>, <-33.199451, -0.000002, 330.115541>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-33.199451, -0.000002, 330.115541>, <-33.199451, -1.333333, 330.115541>, 
               <-31.232965, -1.333333, 329.858824>, <-31.232965, -0.000000, 329.858824>, 
               <-20.414773, -0.000002, 371.598215>, <-20.414773, -1.333333, 371.598215>, 
               <-18.414773, -1.333333, 371.598215>, <-18.414773, -0.000000, 371.598215>, 
               <-17.909356, -0.000002, 384.115567>, <-17.909356, -1.333333, 384.115567>, 
               <-16.029641, -1.333333, 383.432432>, <-16.029641, -0.000000, 383.432432>, 
               <-10.602117, -0.000002, 387.738383>, <-10.602117, -1.333333, 387.738383>, 
               <-8.721603, -1.333333, 387.057455>, <-8.721603, -0.000000, 387.057455>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-31.232965, -0.000000, 329.858824>, <-31.232965, 1.333333, 329.858824>, 
               <-33.199451, 1.333330, 330.115541>, <-33.199451, -0.000002, 330.115541>, 
               <-18.414773, -0.000000, 371.598215>, <-18.414773, 1.333333, 371.598215>, 
               <-20.414773, 1.333330, 371.598215>, <-20.414773, -0.000002, 371.598215>, 
               <-16.029641, -0.000000, 383.432432>, <-16.029641, 1.333333, 383.432432>, 
               <-17.909356, 1.333330, 384.115567>, <-17.909356, -0.000002, 384.115567>, 
               <-8.721603, -0.000000, 387.057455>, <-8.721603, 1.333333, 387.057455>, 
               <-10.602117, 1.333330, 387.738383>, <-10.602117, -0.000002, 387.738383>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-10.602117, -0.000002, 387.738383>, <-10.602117, -1.333333, 387.738383>, 
               <-8.721603, -1.333333, 387.057455>, <-8.721603, -0.000000, 387.057455>, 
               <-3.294879, -0.000002, 391.361199>, <-3.294879, -1.333333, 391.361199>, 
               <-1.413566, -1.333333, 390.682479>, <-1.413566, -0.000000, 390.682479>, 
               <-3.354222, -0.000002, 393.021839>, <-3.354222, -1.333333, 393.021839>, 
               <-1.354222, -1.333333, 393.021839>, <-1.354222, -0.000000, 393.021839>, 
               <-3.354222, -0.000002, 426.711848>, <-3.354222, -1.333333, 426.711848>, 
               <-1.354222, -1.333333, 426.711848>, <-1.354222, -0.000000, 426.711848>
          }
     }
     object {
          bicubic_patch { type 1 flatness 0.0100 u_steps 4 v_steps 4,
               <-8.721603, -0.000000, 387.057455>, <-8.721603, 1.333333, 387.057455>, 
               <-10.602117, 1.333330, 387.738383>, <-10.602117, -0.000002, 387.738383>, 
               <-1.413566, -0.000000, 390.682479>, <-1.413566, 1.333333, 390.682479>, 
               <-3.294879, 1.333330, 391.361199>, <-3.294879, -0.000002, 391.361199>, 
               <-1.354222, -0.000000, 393.021839>, <-1.354222, 1.333333, 393.021839>, 
               <-3.354222, 1.333330, 393.021839>, <-3.354222, -0.000002, 393.021839>, 
               <-1.354222, -0.000000, 426.711848>, <-1.354222, 1.333333, 426.711848>, 
               <-3.354222, 1.333330, 426.711848>, <-3.354222, -0.000002, 426.711848>
          }
     }
     scale 0.1
     rotate -0.081645*y
     translate  <0.000888, 0.0, -44.376022>
}




//
// ********  OBJECTS  *******
//

#declare Neck = union {
     object { Helix  }
     object { Helix      rotate 180.0*z  }
     cylinder { <0, 0, 1.2>, <0, 0, 0>, 0.1                           translate  <-0.1, 0, 2.6>  }
     cylinder { <0, 0, 0.65>, <0, 0, 0>, 0.1       rotate 14*y         translate  <-0.27, 0, -1.76>  }
     cylinder { <0, 0, 0.65>, <0, 0, 0>, 0.1       rotate -14*y        translate  < 0.27, 0, -1.76>  }
}

#declare Hook = union {
     cylinder { <0,0,1>, <0,0,0>, 1     scale <0.1, 0.1, 2.0>         translate  <0.15, 0.0, 1.3>  }
     cylinder { <0,0,1>, <0,0,0>, 1     scale <0.1, 0.1, 2.4>         rotate -11.5*y      translate  <5.5, 0.0, 1.77>  }
     difference {
          torus { 2.5, 0.1              translate  <2.630155, 0.0, 3.379463>   }
          box { <-2.8, -0.15, -1.6>, <2.8, 0.15, 1.6>       rotate -10.0*y      translate  <2.9, 0.0, 2.135>  }
     }
}


#declare Main_Wire = union {
     object { Wire001 }
     object { Wire001              rotate <0.0, 0.0, -180.0>     }
}


#declare Red_Tip = union {
     intersection {
          object { Main_Wire }
          cylinder {  0*z,  4*z,  1  translate -44.9*z  }
          pigment { Blood }
     }
     difference {
          object { Main_Wire }
          cylinder {  0*z,  4*z,  1  translate -45*z    }
     } 
}

#declare Coathanger = union { // Coathanger
     object { Neck       rotate -25*x             translate  < 0, 0.68, 0>
     }
     object { Hook       rotate <-30, 0, 10>      
          translate <-0.15, 1.12, 1.12> 
     }
     object { Red_Tip }
     material { Coathanger_T }
}










